/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.swift;

import java.io.File;
import java.io.IOException;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.file.Deleter;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.tasks.StaleOutputCleaner;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingSchemeFactory;
import org.gradle.nativeplatform.toolchain.internal.compilespec.SwiftCompileSpec;

public class IncrementalSwiftCompiler
implements Compiler<SwiftCompileSpec> {
    private final Compiler<SwiftCompileSpec> compiler;
    private final TaskOutputsInternal outputs;
    private final CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory;
    private final Deleter deleter;

    public IncrementalSwiftCompiler(Compiler<SwiftCompileSpec> compiler, TaskOutputsInternal outputs, CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory, Deleter deleter) {
        this.compiler = compiler;
        this.outputs = outputs;
        this.compilerOutputFileNamingSchemeFactory = compilerOutputFileNamingSchemeFactory;
        this.deleter = deleter;
    }

    public WorkResult execute(SwiftCompileSpec spec) {
        boolean didRemove = spec.isIncrementalCompile() ? this.deleteOutputsForRemovedSources(spec) : this.cleanPreviousOutputs(spec);
        WorkResult compileResult = this.compile(spec);
        return WorkResults.didWork((didRemove || compileResult.getDidWork() ? 1 : 0) != 0);
    }

    protected WorkResult compile(SwiftCompileSpec spec) {
        return this.compiler.execute((CompileSpec)spec);
    }

    private boolean deleteOutputsForRemovedSources(SwiftCompileSpec spec) {
        boolean didRemove = false;
        for (File removedSource : spec.getRemovedSourceFiles()) {
            File objectFile = this.getObjectFile(spec.getObjectFileDir(), removedSource);
            try {
                if (!this.deleter.deleteRecursively(objectFile.getParentFile())) continue;
                didRemove = true;
            }
            catch (IOException ex) {
                throw UncheckedException.throwAsUncheckedException((Throwable)ex);
            }
        }
        return didRemove;
    }

    private File getObjectFile(File objectFileRoot, File sourceFile) {
        return this.compilerOutputFileNamingSchemeFactory.create().withObjectFileNameSuffix(".o").withOutputBaseFolder(objectFileRoot).map(sourceFile);
    }

    private boolean cleanPreviousOutputs(SwiftCompileSpec spec) {
        return StaleOutputCleaner.cleanOutputs((Deleter)this.deleter, (Iterable)this.outputs.getPreviousOutputFiles(), (File)spec.getObjectFileDir());
    }
}

