/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa;

import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import net.i2p.crypto.eddsa.EdDSAKey;
import net.i2p.crypto.eddsa.math.GroupElement;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;

public class EdDSAPublicKey
implements EdDSAKey,
PublicKey {
    private static final long serialVersionUID = 9837459837498475L;
    private final GroupElement A;
    private GroupElement Aneg = null;
    private final byte[] Abyte;
    private final EdDSAParameterSpec edDsaSpec;
    private static final int OID_OLD = 100;
    private static final int OID_ED25519 = 112;
    private static final int OID_BYTE = 8;
    private static final int IDLEN_BYTE = 3;

    public EdDSAPublicKey(EdDSAPublicKeySpec spec) {
        this.A = spec.getA();
        this.Abyte = this.A.toByteArray();
        this.edDsaSpec = spec.getParams();
    }

    public EdDSAPublicKey(X509EncodedKeySpec spec) throws InvalidKeySpecException {
        this(new EdDSAPublicKeySpec(EdDSAPublicKey.decode(spec.getEncoded()), (EdDSAParameterSpec)EdDSANamedCurveTable.ED_25519_CURVE_SPEC));
    }

    @Override
    public String getAlgorithm() {
        return "EdDSA";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        if (!this.edDsaSpec.equals(EdDSANamedCurveTable.ED_25519_CURVE_SPEC)) {
            return null;
        }
        int totlen = 12 + this.Abyte.length;
        byte[] rv = new byte[totlen];
        int idx = 0;
        rv[idx++] = 48;
        rv[idx++] = (byte)(totlen - 2);
        rv[idx++] = 48;
        rv[idx++] = 5;
        rv[idx++] = 6;
        rv[idx++] = 3;
        rv[idx++] = 43;
        rv[idx++] = 101;
        rv[idx++] = 112;
        rv[idx++] = 3;
        rv[idx++] = (byte)(1 + this.Abyte.length);
        rv[idx++] = 0;
        System.arraycopy(this.Abyte, 0, rv, idx, this.Abyte.length);
        return rv;
    }

    private static byte[] decode(byte[] d) throws InvalidKeySpecException {
        try {
            int totlen = 44;
            byte idlen = 5;
            byte doid = d[8];
            if (doid == 100) {
                totlen = 47;
                idlen = 8;
            } else if (doid == 112) {
                if (d[3] == 7) {
                    totlen = 46;
                    idlen = 7;
                }
            } else {
                throw new InvalidKeySpecException("unsupported key spec");
            }
            if (d.length != totlen) {
                throw new InvalidKeySpecException("invalid key spec length");
            }
            int idx = 0;
            if (d[idx++] != 48 || d[idx++] != totlen - 2 || d[idx++] != 48 || d[idx++] != idlen || d[idx++] != 6 || d[idx++] != 3 || d[idx++] != 43 || d[idx++] != 101) {
                throw new InvalidKeySpecException("unsupported key spec");
            }
            ++idx;
            if (doid == 100 ? d[idx++] != 10 || d[idx++] != 1 || d[idx++] != 1 : idlen == 7 && (d[idx++] != 5 || d[idx++] != 0)) {
                throw new InvalidKeySpecException("unsupported key spec");
            }
            if (d[idx++] != 3 || d[idx++] != 33 || d[idx++] != 0) {
                throw new InvalidKeySpecException("unsupported key spec");
            }
            byte[] rv = new byte[32];
            System.arraycopy(d, idx, rv, 0, 32);
            return rv;
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new InvalidKeySpecException(ioobe);
        }
    }

    @Override
    public EdDSAParameterSpec getParams() {
        return this.edDsaSpec;
    }

    public GroupElement getA() {
        return this.A;
    }

    public GroupElement getNegativeA() {
        GroupElement ourAneg = this.Aneg;
        if (ourAneg == null) {
            this.Aneg = ourAneg = this.A.negate();
        }
        return ourAneg;
    }

    public byte[] getAbyte() {
        return this.Abyte;
    }

    public int hashCode() {
        return Arrays.hashCode(this.Abyte);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EdDSAPublicKey)) {
            return false;
        }
        EdDSAPublicKey pk = (EdDSAPublicKey)o;
        return Arrays.equals(this.Abyte, pk.getAbyte()) && this.edDsaSpec.equals(pk.getParams());
    }
}

