!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubecompute_derivative
  use cubecompute_one2one_template
  use cubecompute_messaging
  !
  public :: cubecompute_derivative_register
  private
  !
  type(one2one_comm_t) :: derivative
  !
contains
  !
  subroutine cubecompute_derivative_register(error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    logical, intent(inout) :: error
    !
    character(len=*), parameter :: rname='PHASE>DERIVATIVE'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call derivative%register_syntax(&
         'DERIVATIVE','input',&
         code_access_speset,[flag_derivative],cubecompute_derivative_command,error)
    if (error) return
    call derivative%act%register_spe2spe(cubecompute_derivative_prog_act,error)
    if (error) return
  end subroutine cubecompute_derivative_register
  !
  subroutine cubecompute_derivative_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(one2one_user_t) :: user
    character(len=*), parameter :: rname='DERIVATIVE>COMMAND'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call derivative%parse(line,user,error)
    if (error) return
    call derivative%main(user,error)
    if (error) continue
  end subroutine cubecompute_derivative_command
  !
  subroutine cubecompute_derivative_prog_act(ie,input,output,error)
    use cubetools_parameters
    use cubetools_nan
    use cubeadm_spectrum_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    integer(kind=entr_k), intent(in)    :: ie
    type(spectrum_t),     intent(inout) :: input
    type(spectrum_t),     intent(inout) :: output
    logical,              intent(inout) :: error
    !
    integer(kind=chan_k) :: ic
    character(len=*), parameter :: rname='DERIVATIVE>PROG>ACT'
    !
    call input%get(ie,error)
    if (error) return
    output%y%val(1) = gr4nan
    do ic=2,input%n-1
       output%y%val(ic) = input%y%val(ic+1)-input%y%val(ic-1)
    enddo ! ic
    output%y%val(input%n) = gr4nan
    call output%put(ie,error)
    if (error) return
  end subroutine cubecompute_derivative_prog_act
end module cubecompute_derivative
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
