/* Generated by https://github.com/corsix/fast-crc32/ using: */
/* ./generate -i avx512_vpclmulqdq -p crc32c -a v3x2 */
/* Modified slightly post-generation to improve function name and include build target */
/* MIT licensed */

#include <stddef.h>
#include <stdint.h>
#include <nmmintrin.h>
#include <immintrin.h>

#if defined(_MSC_VER)
#define CRC_AINLINE static __forceinline
#define CRC_ALIGN(n) __declspec(align(n))
#else
#define CRC_AINLINE static __inline __attribute__((always_inline))
#define CRC_ALIGN(n) __attribute__((aligned(n)))
#endif
#define CRC_EXPORT extern

#define clmul_lo(a, b) (_mm512_clmulepi64_epi128((a), (b), 0))
#define clmul_hi(a, b) (_mm512_clmulepi64_epi128((a), (b), 17))

const char *const ISCSI_TARGET = "x86_64_avx512_vpclmulqdq_v3x2";

const char *get_iscsi_target() {
    return ISCSI_TARGET;
}

CRC_EXPORT uint32_t crc32_iscsi_impl(uint32_t crc0, const char* buf, size_t len) {
  crc0 = ~crc0;
  for (; len && ((uintptr_t)buf & 7); --len) {
    crc0 = _mm_crc32_u8(crc0, *buf++);
  }
  while (((uintptr_t)buf & 56) && len >= 8) {
    crc0 = _mm_crc32_u64(crc0, *(const uint64_t*)buf);
    buf += 8;
    len -= 8;
  }
  if (len >= 384) {
    __m128i z0;
    /* First vector chunk. */
    __m512i x0 = _mm512_loadu_si512((const void*)buf), y0;
    __m512i x1 = _mm512_loadu_si512((const void*)(buf + 64)), y1;
    __m512i x2 = _mm512_loadu_si512((const void*)(buf + 128)), y2;
    __m512i k;
    k = _mm512_broadcast_i32x4(_mm_setr_epi32(0xa87ab8a8, 0, 0xab7aff2a, 0));
    x0 = _mm512_xor_si512(_mm512_castsi128_si512(_mm_cvtsi32_si128(crc0)), x0);
    y0 = clmul_lo(x0, k), x0 = clmul_hi(x0, k);
    y1 = clmul_lo(x1, k), x1 = clmul_hi(x1, k);
    y2 = clmul_lo(x2, k), x2 = clmul_hi(x2, k);
    x0 = _mm512_ternarylogic_epi64(x0, y0, _mm512_loadu_si512((const void*)(buf + 192)), 0x96);
    x1 = _mm512_ternarylogic_epi64(x1, y1, _mm512_loadu_si512((const void*)(buf + 256)), 0x96);
    x2 = _mm512_ternarylogic_epi64(x2, y2, _mm512_loadu_si512((const void*)(buf + 320)), 0x96);
    buf += 384;
    len -= 384;
    /* Main loop. */
    while (len >= 384) {
      y0 = clmul_lo(x0, k), x0 = clmul_hi(x0, k);
      y1 = clmul_lo(x1, k), x1 = clmul_hi(x1, k);
      y2 = clmul_lo(x2, k), x2 = clmul_hi(x2, k);
      x0 = _mm512_ternarylogic_epi64(x0, y0, _mm512_loadu_si512((const void*)buf), 0x96);
      x1 = _mm512_ternarylogic_epi64(x1, y1, _mm512_loadu_si512((const void*)(buf + 64)), 0x96);
      x2 = _mm512_ternarylogic_epi64(x2, y2, _mm512_loadu_si512((const void*)(buf + 128)), 0x96);
      y0 = clmul_lo(x0, k), x0 = clmul_hi(x0, k);
      y1 = clmul_lo(x1, k), x1 = clmul_hi(x1, k);
      y2 = clmul_lo(x2, k), x2 = clmul_hi(x2, k);
      x0 = _mm512_ternarylogic_epi64(x0, y0, _mm512_loadu_si512((const void*)(buf + 192)), 0x96);
      x1 = _mm512_ternarylogic_epi64(x1, y1, _mm512_loadu_si512((const void*)(buf + 256)), 0x96);
      x2 = _mm512_ternarylogic_epi64(x2, y2, _mm512_loadu_si512((const void*)(buf + 320)), 0x96);
      buf += 384;
      len -= 384;
    }
    /* Reduce x0 ... x2 to just x0. */
    k = _mm512_broadcast_i32x4(_mm_setr_epi32(0x740eef02, 0, 0x9e4addf8, 0));
    y0 = clmul_lo(x0, k), x0 = clmul_hi(x0, k);
    x0 = _mm512_ternarylogic_epi64(x0, y0, x1, 0x96);
    x1 = x2;
    y0 = clmul_lo(x0, k), x0 = clmul_hi(x0, k);
    x0 = _mm512_ternarylogic_epi64(x0, y0, x1, 0x96);
    /* Reduce 512 bits to 128 bits. */
    k = _mm512_setr_epi32(0x1c291d04, 0, 0xddc0152b, 0, 0x3da6d0cb, 0, 0xba4fc28e, 0, 0xf20c0dfe, 0, 0x493c7d27, 0, 0, 0, 0, 0);
    y0 = clmul_lo(x0, k), k = clmul_hi(x0, k);
    y0 = _mm512_xor_si512(y0, k);
    z0 = _mm_ternarylogic_epi64(_mm512_castsi512_si128(y0), _mm512_extracti32x4_epi32(y0, 1), _mm512_extracti32x4_epi32(y0, 2), 0x96);
    z0 = _mm_xor_si128(z0, _mm512_extracti32x4_epi32(x0, 3));
    /* Reduce 128 bits to 32 bits, and multiply by x^32. */
    crc0 = _mm_crc32_u64(0, _mm_extract_epi64(z0, 0));
    crc0 = _mm_crc32_u64(crc0, _mm_extract_epi64(z0, 1));
  }
  for (; len >= 8; buf += 8, len -= 8) {
    crc0 = _mm_crc32_u64(crc0, *(const uint64_t*)buf);
  }
  for (; len; --len) {
    crc0 = _mm_crc32_u8(crc0, *buf++);
  }
  return ~crc0;
}
