// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The requested operation is not valid. You will see this exception if there are missing required fields or if the input value fails the validation.</p>
/// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>, one of the following errors:</p>
/// <ul>
/// <li>
/// <p>There are missing required fields.</p></li>
/// <li>
/// <p>The input value fails the validation.</p></li>
/// <li>
/// <p>You are trying to create more than 300 queries.</p></li>
/// </ul>
/// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html">DescribeConfigurationRecorders</a> and <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html">DescribeConfigurationRecorderStatus</a>, one of the following errors:</p>
/// <ul>
/// <li>
/// <p>You have specified more than one configuration recorder.</p></li>
/// <li>
/// <p>You have provided a service principal for service-linked configuration recorder that is not valid.</p></li>
/// </ul>
/// <p>For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">AssociateResourceTypes</a> and <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html">DisassociateResourceTypes</a>, one of the following errors:</p>
/// <ul>
/// <li>
/// <p>Your configuraiton recorder has a recording strategy that does not allow the association or disassociation of resource types.</p></li>
/// <li>
/// <p>One or more of the specified resource types are already associated or disassociated with the configuration recorder.</p></li>
/// <li>
/// <p>For service-linked configuration recorders, the configuration recorder does not record one or more of the specified resource types.</p></li>
/// </ul>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ValidationException {
    /// <p>Error executing the command</p>
    pub message: ::std::option::Option<::std::string::String>,
    pub(crate) meta: ::aws_smithy_types::error::ErrorMetadata,
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> ::std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl ::std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        ::std::write!(f, "ValidationException")?;
        if let ::std::option::Option::Some(inner_1) = &self.message {
            {
                ::std::write!(f, ": {}", inner_1)?;
            }
        }
        Ok(())
    }
}
impl ::std::error::Error for ValidationException {}
impl ::aws_types::request_id::RequestId for crate::types::error::ValidationException {
    fn request_id(&self) -> Option<&str> {
        use ::aws_smithy_types::error::metadata::ProvideErrorMetadata;
        self.meta().request_id()
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for ValidationException {
    fn meta(&self) -> &::aws_smithy_types::error::ErrorMetadata {
        &self.meta
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::types::error::ValidationException).
    pub fn builder() -> crate::types::error::builders::ValidationExceptionBuilder {
        crate::types::error::builders::ValidationExceptionBuilder::default()
    }
}

/// A builder for [`ValidationException`](crate::types::error::ValidationException).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ValidationExceptionBuilder {
    pub(crate) message: ::std::option::Option<::std::string::String>,
    meta: std::option::Option<::aws_smithy_types::error::ErrorMetadata>,
}
impl ValidationExceptionBuilder {
    /// <p>Error executing the command</p>
    pub fn message(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.message = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Error executing the command</p>
    pub fn set_message(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.message = input;
        self
    }
    /// <p>Error executing the command</p>
    pub fn get_message(&self) -> &::std::option::Option<::std::string::String> {
        &self.message
    }
    /// Sets error metadata
    pub fn meta(mut self, meta: ::aws_smithy_types::error::ErrorMetadata) -> Self {
        self.meta = Some(meta);
        self
    }

    /// Sets error metadata
    pub fn set_meta(&mut self, meta: std::option::Option<::aws_smithy_types::error::ErrorMetadata>) -> &mut Self {
        self.meta = meta;
        self
    }
    /// Consumes the builder and constructs a [`ValidationException`](crate::types::error::ValidationException).
    pub fn build(self) -> crate::types::error::ValidationException {
        crate::types::error::ValidationException {
            message: self.message,
            meta: self.meta.unwrap_or_default(),
        }
    }
}
