// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>This API allows you to create a conformance pack template with an Amazon Web Services Systems Manager document (SSM document). To deploy a conformance pack using an SSM document, first create an SSM document with conformance pack content, and then provide the <code>DocumentName</code> in the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConformancePack.html">PutConformancePack API</a>. You can also provide the <code>DocumentVersion</code>.</p>
/// <p>The <code>TemplateSSMDocumentDetails</code> object contains the name of the SSM document and the version of the SSM document.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct TemplateSsmDocumentDetails {
    /// <p>The name or Amazon Resource Name (ARN) of the SSM document to use to create a conformance pack. If you use the document name, Config checks only your account and Amazon Web Services Region for the SSM document.</p>
    pub document_name: ::std::string::String,
    /// <p>The version of the SSM document to use to create a conformance pack. By default, Config uses the latest version.</p><note>
    /// <p>This field is optional.</p>
    /// </note>
    pub document_version: ::std::option::Option<::std::string::String>,
}
impl TemplateSsmDocumentDetails {
    /// <p>The name or Amazon Resource Name (ARN) of the SSM document to use to create a conformance pack. If you use the document name, Config checks only your account and Amazon Web Services Region for the SSM document.</p>
    pub fn document_name(&self) -> &str {
        use std::ops::Deref;
        self.document_name.deref()
    }
    /// <p>The version of the SSM document to use to create a conformance pack. By default, Config uses the latest version.</p><note>
    /// <p>This field is optional.</p>
    /// </note>
    pub fn document_version(&self) -> ::std::option::Option<&str> {
        self.document_version.as_deref()
    }
}
impl TemplateSsmDocumentDetails {
    /// Creates a new builder-style object to manufacture [`TemplateSsmDocumentDetails`](crate::types::TemplateSsmDocumentDetails).
    pub fn builder() -> crate::types::builders::TemplateSsmDocumentDetailsBuilder {
        crate::types::builders::TemplateSsmDocumentDetailsBuilder::default()
    }
}

/// A builder for [`TemplateSsmDocumentDetails`](crate::types::TemplateSsmDocumentDetails).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct TemplateSsmDocumentDetailsBuilder {
    pub(crate) document_name: ::std::option::Option<::std::string::String>,
    pub(crate) document_version: ::std::option::Option<::std::string::String>,
}
impl TemplateSsmDocumentDetailsBuilder {
    /// <p>The name or Amazon Resource Name (ARN) of the SSM document to use to create a conformance pack. If you use the document name, Config checks only your account and Amazon Web Services Region for the SSM document.</p>
    /// This field is required.
    pub fn document_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.document_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name or Amazon Resource Name (ARN) of the SSM document to use to create a conformance pack. If you use the document name, Config checks only your account and Amazon Web Services Region for the SSM document.</p>
    pub fn set_document_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.document_name = input;
        self
    }
    /// <p>The name or Amazon Resource Name (ARN) of the SSM document to use to create a conformance pack. If you use the document name, Config checks only your account and Amazon Web Services Region for the SSM document.</p>
    pub fn get_document_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.document_name
    }
    /// <p>The version of the SSM document to use to create a conformance pack. By default, Config uses the latest version.</p><note>
    /// <p>This field is optional.</p>
    /// </note>
    pub fn document_version(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.document_version = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The version of the SSM document to use to create a conformance pack. By default, Config uses the latest version.</p><note>
    /// <p>This field is optional.</p>
    /// </note>
    pub fn set_document_version(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.document_version = input;
        self
    }
    /// <p>The version of the SSM document to use to create a conformance pack. By default, Config uses the latest version.</p><note>
    /// <p>This field is optional.</p>
    /// </note>
    pub fn get_document_version(&self) -> &::std::option::Option<::std::string::String> {
        &self.document_version
    }
    /// Consumes the builder and constructs a [`TemplateSsmDocumentDetails`](crate::types::TemplateSsmDocumentDetails).
    /// This method will fail if any of the following fields are not set:
    /// - [`document_name`](crate::types::builders::TemplateSsmDocumentDetailsBuilder::document_name)
    pub fn build(self) -> ::std::result::Result<crate::types::TemplateSsmDocumentDetails, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::TemplateSsmDocumentDetails {
            document_name: self.document_name.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "document_name",
                    "document_name was not specified but it is required when building TemplateSsmDocumentDetails",
                )
            })?,
            document_version: self.document_version,
        })
    }
}
