// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Filters the resource count based on account ID, region, and resource type.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ResourceCountFilters {
    /// <p>The type of the Amazon Web Services resource.</p>
    pub resource_type: ::std::option::Option<crate::types::ResourceType>,
    /// <p>The 12-digit ID of the account.</p>
    pub account_id: ::std::option::Option<::std::string::String>,
    /// <p>The region where the account is located.</p>
    pub region: ::std::option::Option<::std::string::String>,
}
impl ResourceCountFilters {
    /// <p>The type of the Amazon Web Services resource.</p>
    pub fn resource_type(&self) -> ::std::option::Option<&crate::types::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The 12-digit ID of the account.</p>
    pub fn account_id(&self) -> ::std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The region where the account is located.</p>
    pub fn region(&self) -> ::std::option::Option<&str> {
        self.region.as_deref()
    }
}
impl ResourceCountFilters {
    /// Creates a new builder-style object to manufacture [`ResourceCountFilters`](crate::types::ResourceCountFilters).
    pub fn builder() -> crate::types::builders::ResourceCountFiltersBuilder {
        crate::types::builders::ResourceCountFiltersBuilder::default()
    }
}

/// A builder for [`ResourceCountFilters`](crate::types::ResourceCountFilters).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ResourceCountFiltersBuilder {
    pub(crate) resource_type: ::std::option::Option<crate::types::ResourceType>,
    pub(crate) account_id: ::std::option::Option<::std::string::String>,
    pub(crate) region: ::std::option::Option<::std::string::String>,
}
impl ResourceCountFiltersBuilder {
    /// <p>The type of the Amazon Web Services resource.</p>
    pub fn resource_type(mut self, input: crate::types::ResourceType) -> Self {
        self.resource_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The type of the Amazon Web Services resource.</p>
    pub fn set_resource_type(mut self, input: ::std::option::Option<crate::types::ResourceType>) -> Self {
        self.resource_type = input;
        self
    }
    /// <p>The type of the Amazon Web Services resource.</p>
    pub fn get_resource_type(&self) -> &::std::option::Option<crate::types::ResourceType> {
        &self.resource_type
    }
    /// <p>The 12-digit ID of the account.</p>
    pub fn account_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.account_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The 12-digit ID of the account.</p>
    pub fn set_account_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.account_id = input;
        self
    }
    /// <p>The 12-digit ID of the account.</p>
    pub fn get_account_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.account_id
    }
    /// <p>The region where the account is located.</p>
    pub fn region(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.region = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The region where the account is located.</p>
    pub fn set_region(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.region = input;
        self
    }
    /// <p>The region where the account is located.</p>
    pub fn get_region(&self) -> &::std::option::Option<::std::string::String> {
        &self.region
    }
    /// Consumes the builder and constructs a [`ResourceCountFilters`](crate::types::ResourceCountFilters).
    pub fn build(self) -> crate::types::ResourceCountFilters {
        crate::types::ResourceCountFilters {
            resource_type: self.resource_type,
            account_id: self.account_id,
            region: self.region,
        }
    }
}
