// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>An object that contains the resource type and the number of resources.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ResourceCount {
    /// <p>The resource type (for example, <code>"AWS::EC2::Instance"</code>).</p>
    pub resource_type: ::std::option::Option<crate::types::ResourceType>,
    /// <p>The number of resources.</p>
    pub count: i64,
}
impl ResourceCount {
    /// <p>The resource type (for example, <code>"AWS::EC2::Instance"</code>).</p>
    pub fn resource_type(&self) -> ::std::option::Option<&crate::types::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The number of resources.</p>
    pub fn count(&self) -> i64 {
        self.count
    }
}
impl ResourceCount {
    /// Creates a new builder-style object to manufacture [`ResourceCount`](crate::types::ResourceCount).
    pub fn builder() -> crate::types::builders::ResourceCountBuilder {
        crate::types::builders::ResourceCountBuilder::default()
    }
}

/// A builder for [`ResourceCount`](crate::types::ResourceCount).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ResourceCountBuilder {
    pub(crate) resource_type: ::std::option::Option<crate::types::ResourceType>,
    pub(crate) count: ::std::option::Option<i64>,
}
impl ResourceCountBuilder {
    /// <p>The resource type (for example, <code>"AWS::EC2::Instance"</code>).</p>
    pub fn resource_type(mut self, input: crate::types::ResourceType) -> Self {
        self.resource_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The resource type (for example, <code>"AWS::EC2::Instance"</code>).</p>
    pub fn set_resource_type(mut self, input: ::std::option::Option<crate::types::ResourceType>) -> Self {
        self.resource_type = input;
        self
    }
    /// <p>The resource type (for example, <code>"AWS::EC2::Instance"</code>).</p>
    pub fn get_resource_type(&self) -> &::std::option::Option<crate::types::ResourceType> {
        &self.resource_type
    }
    /// <p>The number of resources.</p>
    pub fn count(mut self, input: i64) -> Self {
        self.count = ::std::option::Option::Some(input);
        self
    }
    /// <p>The number of resources.</p>
    pub fn set_count(mut self, input: ::std::option::Option<i64>) -> Self {
        self.count = input;
        self
    }
    /// <p>The number of resources.</p>
    pub fn get_count(&self) -> &::std::option::Option<i64> {
        &self.count
    }
    /// Consumes the builder and constructs a [`ResourceCount`](crate::types::ResourceCount).
    pub fn build(self) -> crate::types::ResourceCount {
        crate::types::ResourceCount {
            resource_type: self.resource_type,
            count: self.count.unwrap_or_default(),
        }
    }
}
