// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>An object that represents the details about the remediation configuration that includes the remediation action, parameters, and data to execute the action.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct RemediationConfiguration {
    /// <p>The name of the Config rule.</p>
    pub config_rule_name: ::std::string::String,
    /// <p>The type of the target. Target executes remediation. For example, SSM document.</p>
    pub target_type: crate::types::RemediationTargetType,
    /// <p>Target ID is the name of the SSM document.</p>
    pub target_id: ::std::string::String,
    /// <p>Version of the target. For example, version of the SSM document.</p><note>
    /// <p>If you make backward incompatible changes to the SSM document, you must call PutRemediationConfiguration API again to ensure the remediations can run.</p>
    /// </note>
    pub target_version: ::std::option::Option<::std::string::String>,
    /// <p>An object of the RemediationParameterValue.</p>
    pub parameters: ::std::option::Option<::std::collections::HashMap<::std::string::String, crate::types::RemediationParameterValue>>,
    /// <p>The type of a resource.</p>
    pub resource_type: ::std::option::Option<::std::string::String>,
    /// <p>The remediation is triggered automatically.</p>
    pub automatic: bool,
    /// <p>An ExecutionControls object.</p>
    pub execution_controls: ::std::option::Option<crate::types::ExecutionControls>,
    /// <p>The maximum number of failed attempts for auto-remediation. If you do not select a number, the default is 5.</p>
    /// <p>For example, if you specify MaximumAutomaticAttempts as 5 with RetryAttemptSeconds as 50 seconds, Config will put a RemediationException on your behalf for the failing resource after the 5th failed attempt within 50 seconds.</p>
    pub maximum_automatic_attempts: ::std::option::Option<i32>,
    /// <p>Time window to determine whether or not to add a remediation exception to prevent infinite remediation attempts. If <code>MaximumAutomaticAttempts</code> remediation attempts have been made under <code>RetryAttemptSeconds</code>, a remediation exception will be added to the resource. If you do not select a number, the default is 60 seconds.</p>
    /// <p>For example, if you specify <code>RetryAttemptSeconds</code> as 50 seconds and <code>MaximumAutomaticAttempts</code> as 5, Config will run auto-remediations 5 times within 50 seconds before adding a remediation exception to the resource.</p>
    pub retry_attempt_seconds: ::std::option::Option<i64>,
    /// <p>Amazon Resource Name (ARN) of remediation configuration.</p>
    pub arn: ::std::option::Option<::std::string::String>,
    /// <p>Name of the service that owns the service-linked rule, if applicable.</p>
    pub created_by_service: ::std::option::Option<::std::string::String>,
}
impl RemediationConfiguration {
    /// <p>The name of the Config rule.</p>
    pub fn config_rule_name(&self) -> &str {
        use std::ops::Deref;
        self.config_rule_name.deref()
    }
    /// <p>The type of the target. Target executes remediation. For example, SSM document.</p>
    pub fn target_type(&self) -> &crate::types::RemediationTargetType {
        &self.target_type
    }
    /// <p>Target ID is the name of the SSM document.</p>
    pub fn target_id(&self) -> &str {
        use std::ops::Deref;
        self.target_id.deref()
    }
    /// <p>Version of the target. For example, version of the SSM document.</p><note>
    /// <p>If you make backward incompatible changes to the SSM document, you must call PutRemediationConfiguration API again to ensure the remediations can run.</p>
    /// </note>
    pub fn target_version(&self) -> ::std::option::Option<&str> {
        self.target_version.as_deref()
    }
    /// <p>An object of the RemediationParameterValue.</p>
    pub fn parameters(&self) -> ::std::option::Option<&::std::collections::HashMap<::std::string::String, crate::types::RemediationParameterValue>> {
        self.parameters.as_ref()
    }
    /// <p>The type of a resource.</p>
    pub fn resource_type(&self) -> ::std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The remediation is triggered automatically.</p>
    pub fn automatic(&self) -> bool {
        self.automatic
    }
    /// <p>An ExecutionControls object.</p>
    pub fn execution_controls(&self) -> ::std::option::Option<&crate::types::ExecutionControls> {
        self.execution_controls.as_ref()
    }
    /// <p>The maximum number of failed attempts for auto-remediation. If you do not select a number, the default is 5.</p>
    /// <p>For example, if you specify MaximumAutomaticAttempts as 5 with RetryAttemptSeconds as 50 seconds, Config will put a RemediationException on your behalf for the failing resource after the 5th failed attempt within 50 seconds.</p>
    pub fn maximum_automatic_attempts(&self) -> ::std::option::Option<i32> {
        self.maximum_automatic_attempts
    }
    /// <p>Time window to determine whether or not to add a remediation exception to prevent infinite remediation attempts. If <code>MaximumAutomaticAttempts</code> remediation attempts have been made under <code>RetryAttemptSeconds</code>, a remediation exception will be added to the resource. If you do not select a number, the default is 60 seconds.</p>
    /// <p>For example, if you specify <code>RetryAttemptSeconds</code> as 50 seconds and <code>MaximumAutomaticAttempts</code> as 5, Config will run auto-remediations 5 times within 50 seconds before adding a remediation exception to the resource.</p>
    pub fn retry_attempt_seconds(&self) -> ::std::option::Option<i64> {
        self.retry_attempt_seconds
    }
    /// <p>Amazon Resource Name (ARN) of remediation configuration.</p>
    pub fn arn(&self) -> ::std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Name of the service that owns the service-linked rule, if applicable.</p>
    pub fn created_by_service(&self) -> ::std::option::Option<&str> {
        self.created_by_service.as_deref()
    }
}
impl RemediationConfiguration {
    /// Creates a new builder-style object to manufacture [`RemediationConfiguration`](crate::types::RemediationConfiguration).
    pub fn builder() -> crate::types::builders::RemediationConfigurationBuilder {
        crate::types::builders::RemediationConfigurationBuilder::default()
    }
}

/// A builder for [`RemediationConfiguration`](crate::types::RemediationConfiguration).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct RemediationConfigurationBuilder {
    pub(crate) config_rule_name: ::std::option::Option<::std::string::String>,
    pub(crate) target_type: ::std::option::Option<crate::types::RemediationTargetType>,
    pub(crate) target_id: ::std::option::Option<::std::string::String>,
    pub(crate) target_version: ::std::option::Option<::std::string::String>,
    pub(crate) parameters: ::std::option::Option<::std::collections::HashMap<::std::string::String, crate::types::RemediationParameterValue>>,
    pub(crate) resource_type: ::std::option::Option<::std::string::String>,
    pub(crate) automatic: ::std::option::Option<bool>,
    pub(crate) execution_controls: ::std::option::Option<crate::types::ExecutionControls>,
    pub(crate) maximum_automatic_attempts: ::std::option::Option<i32>,
    pub(crate) retry_attempt_seconds: ::std::option::Option<i64>,
    pub(crate) arn: ::std::option::Option<::std::string::String>,
    pub(crate) created_by_service: ::std::option::Option<::std::string::String>,
}
impl RemediationConfigurationBuilder {
    /// <p>The name of the Config rule.</p>
    /// This field is required.
    pub fn config_rule_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.config_rule_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the Config rule.</p>
    pub fn set_config_rule_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.config_rule_name = input;
        self
    }
    /// <p>The name of the Config rule.</p>
    pub fn get_config_rule_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.config_rule_name
    }
    /// <p>The type of the target. Target executes remediation. For example, SSM document.</p>
    /// This field is required.
    pub fn target_type(mut self, input: crate::types::RemediationTargetType) -> Self {
        self.target_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The type of the target. Target executes remediation. For example, SSM document.</p>
    pub fn set_target_type(mut self, input: ::std::option::Option<crate::types::RemediationTargetType>) -> Self {
        self.target_type = input;
        self
    }
    /// <p>The type of the target. Target executes remediation. For example, SSM document.</p>
    pub fn get_target_type(&self) -> &::std::option::Option<crate::types::RemediationTargetType> {
        &self.target_type
    }
    /// <p>Target ID is the name of the SSM document.</p>
    /// This field is required.
    pub fn target_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.target_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Target ID is the name of the SSM document.</p>
    pub fn set_target_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.target_id = input;
        self
    }
    /// <p>Target ID is the name of the SSM document.</p>
    pub fn get_target_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.target_id
    }
    /// <p>Version of the target. For example, version of the SSM document.</p><note>
    /// <p>If you make backward incompatible changes to the SSM document, you must call PutRemediationConfiguration API again to ensure the remediations can run.</p>
    /// </note>
    pub fn target_version(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.target_version = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Version of the target. For example, version of the SSM document.</p><note>
    /// <p>If you make backward incompatible changes to the SSM document, you must call PutRemediationConfiguration API again to ensure the remediations can run.</p>
    /// </note>
    pub fn set_target_version(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.target_version = input;
        self
    }
    /// <p>Version of the target. For example, version of the SSM document.</p><note>
    /// <p>If you make backward incompatible changes to the SSM document, you must call PutRemediationConfiguration API again to ensure the remediations can run.</p>
    /// </note>
    pub fn get_target_version(&self) -> &::std::option::Option<::std::string::String> {
        &self.target_version
    }
    /// Adds a key-value pair to `parameters`.
    ///
    /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
    ///
    /// <p>An object of the RemediationParameterValue.</p>
    pub fn parameters(mut self, k: impl ::std::convert::Into<::std::string::String>, v: crate::types::RemediationParameterValue) -> Self {
        let mut hash_map = self.parameters.unwrap_or_default();
        hash_map.insert(k.into(), v);
        self.parameters = ::std::option::Option::Some(hash_map);
        self
    }
    /// <p>An object of the RemediationParameterValue.</p>
    pub fn set_parameters(
        mut self,
        input: ::std::option::Option<::std::collections::HashMap<::std::string::String, crate::types::RemediationParameterValue>>,
    ) -> Self {
        self.parameters = input;
        self
    }
    /// <p>An object of the RemediationParameterValue.</p>
    pub fn get_parameters(
        &self,
    ) -> &::std::option::Option<::std::collections::HashMap<::std::string::String, crate::types::RemediationParameterValue>> {
        &self.parameters
    }
    /// <p>The type of a resource.</p>
    pub fn resource_type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.resource_type = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The type of a resource.</p>
    pub fn set_resource_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.resource_type = input;
        self
    }
    /// <p>The type of a resource.</p>
    pub fn get_resource_type(&self) -> &::std::option::Option<::std::string::String> {
        &self.resource_type
    }
    /// <p>The remediation is triggered automatically.</p>
    pub fn automatic(mut self, input: bool) -> Self {
        self.automatic = ::std::option::Option::Some(input);
        self
    }
    /// <p>The remediation is triggered automatically.</p>
    pub fn set_automatic(mut self, input: ::std::option::Option<bool>) -> Self {
        self.automatic = input;
        self
    }
    /// <p>The remediation is triggered automatically.</p>
    pub fn get_automatic(&self) -> &::std::option::Option<bool> {
        &self.automatic
    }
    /// <p>An ExecutionControls object.</p>
    pub fn execution_controls(mut self, input: crate::types::ExecutionControls) -> Self {
        self.execution_controls = ::std::option::Option::Some(input);
        self
    }
    /// <p>An ExecutionControls object.</p>
    pub fn set_execution_controls(mut self, input: ::std::option::Option<crate::types::ExecutionControls>) -> Self {
        self.execution_controls = input;
        self
    }
    /// <p>An ExecutionControls object.</p>
    pub fn get_execution_controls(&self) -> &::std::option::Option<crate::types::ExecutionControls> {
        &self.execution_controls
    }
    /// <p>The maximum number of failed attempts for auto-remediation. If you do not select a number, the default is 5.</p>
    /// <p>For example, if you specify MaximumAutomaticAttempts as 5 with RetryAttemptSeconds as 50 seconds, Config will put a RemediationException on your behalf for the failing resource after the 5th failed attempt within 50 seconds.</p>
    pub fn maximum_automatic_attempts(mut self, input: i32) -> Self {
        self.maximum_automatic_attempts = ::std::option::Option::Some(input);
        self
    }
    /// <p>The maximum number of failed attempts for auto-remediation. If you do not select a number, the default is 5.</p>
    /// <p>For example, if you specify MaximumAutomaticAttempts as 5 with RetryAttemptSeconds as 50 seconds, Config will put a RemediationException on your behalf for the failing resource after the 5th failed attempt within 50 seconds.</p>
    pub fn set_maximum_automatic_attempts(mut self, input: ::std::option::Option<i32>) -> Self {
        self.maximum_automatic_attempts = input;
        self
    }
    /// <p>The maximum number of failed attempts for auto-remediation. If you do not select a number, the default is 5.</p>
    /// <p>For example, if you specify MaximumAutomaticAttempts as 5 with RetryAttemptSeconds as 50 seconds, Config will put a RemediationException on your behalf for the failing resource after the 5th failed attempt within 50 seconds.</p>
    pub fn get_maximum_automatic_attempts(&self) -> &::std::option::Option<i32> {
        &self.maximum_automatic_attempts
    }
    /// <p>Time window to determine whether or not to add a remediation exception to prevent infinite remediation attempts. If <code>MaximumAutomaticAttempts</code> remediation attempts have been made under <code>RetryAttemptSeconds</code>, a remediation exception will be added to the resource. If you do not select a number, the default is 60 seconds.</p>
    /// <p>For example, if you specify <code>RetryAttemptSeconds</code> as 50 seconds and <code>MaximumAutomaticAttempts</code> as 5, Config will run auto-remediations 5 times within 50 seconds before adding a remediation exception to the resource.</p>
    pub fn retry_attempt_seconds(mut self, input: i64) -> Self {
        self.retry_attempt_seconds = ::std::option::Option::Some(input);
        self
    }
    /// <p>Time window to determine whether or not to add a remediation exception to prevent infinite remediation attempts. If <code>MaximumAutomaticAttempts</code> remediation attempts have been made under <code>RetryAttemptSeconds</code>, a remediation exception will be added to the resource. If you do not select a number, the default is 60 seconds.</p>
    /// <p>For example, if you specify <code>RetryAttemptSeconds</code> as 50 seconds and <code>MaximumAutomaticAttempts</code> as 5, Config will run auto-remediations 5 times within 50 seconds before adding a remediation exception to the resource.</p>
    pub fn set_retry_attempt_seconds(mut self, input: ::std::option::Option<i64>) -> Self {
        self.retry_attempt_seconds = input;
        self
    }
    /// <p>Time window to determine whether or not to add a remediation exception to prevent infinite remediation attempts. If <code>MaximumAutomaticAttempts</code> remediation attempts have been made under <code>RetryAttemptSeconds</code>, a remediation exception will be added to the resource. If you do not select a number, the default is 60 seconds.</p>
    /// <p>For example, if you specify <code>RetryAttemptSeconds</code> as 50 seconds and <code>MaximumAutomaticAttempts</code> as 5, Config will run auto-remediations 5 times within 50 seconds before adding a remediation exception to the resource.</p>
    pub fn get_retry_attempt_seconds(&self) -> &::std::option::Option<i64> {
        &self.retry_attempt_seconds
    }
    /// <p>Amazon Resource Name (ARN) of remediation configuration.</p>
    pub fn arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Amazon Resource Name (ARN) of remediation configuration.</p>
    pub fn set_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.arn = input;
        self
    }
    /// <p>Amazon Resource Name (ARN) of remediation configuration.</p>
    pub fn get_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.arn
    }
    /// <p>Name of the service that owns the service-linked rule, if applicable.</p>
    pub fn created_by_service(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.created_by_service = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Name of the service that owns the service-linked rule, if applicable.</p>
    pub fn set_created_by_service(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.created_by_service = input;
        self
    }
    /// <p>Name of the service that owns the service-linked rule, if applicable.</p>
    pub fn get_created_by_service(&self) -> &::std::option::Option<::std::string::String> {
        &self.created_by_service
    }
    /// Consumes the builder and constructs a [`RemediationConfiguration`](crate::types::RemediationConfiguration).
    /// This method will fail if any of the following fields are not set:
    /// - [`config_rule_name`](crate::types::builders::RemediationConfigurationBuilder::config_rule_name)
    /// - [`target_type`](crate::types::builders::RemediationConfigurationBuilder::target_type)
    /// - [`target_id`](crate::types::builders::RemediationConfigurationBuilder::target_id)
    pub fn build(self) -> ::std::result::Result<crate::types::RemediationConfiguration, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::RemediationConfiguration {
            config_rule_name: self.config_rule_name.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "config_rule_name",
                    "config_rule_name was not specified but it is required when building RemediationConfiguration",
                )
            })?,
            target_type: self.target_type.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "target_type",
                    "target_type was not specified but it is required when building RemediationConfiguration",
                )
            })?,
            target_id: self.target_id.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "target_id",
                    "target_id was not specified but it is required when building RemediationConfiguration",
                )
            })?,
            target_version: self.target_version,
            parameters: self.parameters,
            resource_type: self.resource_type,
            automatic: self.automatic.unwrap_or_default(),
            execution_controls: self.execution_controls,
            maximum_automatic_attempts: self.maximum_automatic_attempts,
            retry_attempt_seconds: self.retry_attempt_seconds,
            arn: self.arn,
            created_by_service: self.created_by_service,
        })
    }
}
