// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The relationship of the related resource to the main resource.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct Relationship {
    /// <p>The resource type of the related resource.</p>
    pub resource_type: ::std::option::Option<crate::types::ResourceType>,
    /// <p>The ID of the related resource (for example, <code>sg-xxxxxx</code>).</p>
    pub resource_id: ::std::option::Option<::std::string::String>,
    /// <p>The custom name of the related resource, if available.</p>
    pub resource_name: ::std::option::Option<::std::string::String>,
    /// <p>The type of relationship with the related resource.</p>
    pub relationship_name: ::std::option::Option<::std::string::String>,
}
impl Relationship {
    /// <p>The resource type of the related resource.</p>
    pub fn resource_type(&self) -> ::std::option::Option<&crate::types::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The ID of the related resource (for example, <code>sg-xxxxxx</code>).</p>
    pub fn resource_id(&self) -> ::std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The custom name of the related resource, if available.</p>
    pub fn resource_name(&self) -> ::std::option::Option<&str> {
        self.resource_name.as_deref()
    }
    /// <p>The type of relationship with the related resource.</p>
    pub fn relationship_name(&self) -> ::std::option::Option<&str> {
        self.relationship_name.as_deref()
    }
}
impl Relationship {
    /// Creates a new builder-style object to manufacture [`Relationship`](crate::types::Relationship).
    pub fn builder() -> crate::types::builders::RelationshipBuilder {
        crate::types::builders::RelationshipBuilder::default()
    }
}

/// A builder for [`Relationship`](crate::types::Relationship).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct RelationshipBuilder {
    pub(crate) resource_type: ::std::option::Option<crate::types::ResourceType>,
    pub(crate) resource_id: ::std::option::Option<::std::string::String>,
    pub(crate) resource_name: ::std::option::Option<::std::string::String>,
    pub(crate) relationship_name: ::std::option::Option<::std::string::String>,
}
impl RelationshipBuilder {
    /// <p>The resource type of the related resource.</p>
    pub fn resource_type(mut self, input: crate::types::ResourceType) -> Self {
        self.resource_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The resource type of the related resource.</p>
    pub fn set_resource_type(mut self, input: ::std::option::Option<crate::types::ResourceType>) -> Self {
        self.resource_type = input;
        self
    }
    /// <p>The resource type of the related resource.</p>
    pub fn get_resource_type(&self) -> &::std::option::Option<crate::types::ResourceType> {
        &self.resource_type
    }
    /// <p>The ID of the related resource (for example, <code>sg-xxxxxx</code>).</p>
    pub fn resource_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.resource_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ID of the related resource (for example, <code>sg-xxxxxx</code>).</p>
    pub fn set_resource_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.resource_id = input;
        self
    }
    /// <p>The ID of the related resource (for example, <code>sg-xxxxxx</code>).</p>
    pub fn get_resource_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.resource_id
    }
    /// <p>The custom name of the related resource, if available.</p>
    pub fn resource_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.resource_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The custom name of the related resource, if available.</p>
    pub fn set_resource_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.resource_name = input;
        self
    }
    /// <p>The custom name of the related resource, if available.</p>
    pub fn get_resource_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.resource_name
    }
    /// <p>The type of relationship with the related resource.</p>
    pub fn relationship_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.relationship_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The type of relationship with the related resource.</p>
    pub fn set_relationship_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.relationship_name = input;
        self
    }
    /// <p>The type of relationship with the related resource.</p>
    pub fn get_relationship_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.relationship_name
    }
    /// Consumes the builder and constructs a [`Relationship`](crate::types::Relationship).
    pub fn build(self) -> crate::types::Relationship {
        crate::types::Relationship {
            resource_type: self.resource_type,
            resource_id: self.resource_id,
            resource_name: self.resource_name,
            relationship_name: self.relationship_name,
        }
    }
}
