// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>An object that represents the account ID and region of an aggregator account that is requesting authorization but is not yet authorized.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct PendingAggregationRequest {
    /// <p>The 12-digit account ID of the account requesting to aggregate data.</p>
    pub requester_account_id: ::std::option::Option<::std::string::String>,
    /// <p>The region requesting to aggregate data.</p>
    pub requester_aws_region: ::std::option::Option<::std::string::String>,
}
impl PendingAggregationRequest {
    /// <p>The 12-digit account ID of the account requesting to aggregate data.</p>
    pub fn requester_account_id(&self) -> ::std::option::Option<&str> {
        self.requester_account_id.as_deref()
    }
    /// <p>The region requesting to aggregate data.</p>
    pub fn requester_aws_region(&self) -> ::std::option::Option<&str> {
        self.requester_aws_region.as_deref()
    }
}
impl PendingAggregationRequest {
    /// Creates a new builder-style object to manufacture [`PendingAggregationRequest`](crate::types::PendingAggregationRequest).
    pub fn builder() -> crate::types::builders::PendingAggregationRequestBuilder {
        crate::types::builders::PendingAggregationRequestBuilder::default()
    }
}

/// A builder for [`PendingAggregationRequest`](crate::types::PendingAggregationRequest).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct PendingAggregationRequestBuilder {
    pub(crate) requester_account_id: ::std::option::Option<::std::string::String>,
    pub(crate) requester_aws_region: ::std::option::Option<::std::string::String>,
}
impl PendingAggregationRequestBuilder {
    /// <p>The 12-digit account ID of the account requesting to aggregate data.</p>
    pub fn requester_account_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.requester_account_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The 12-digit account ID of the account requesting to aggregate data.</p>
    pub fn set_requester_account_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.requester_account_id = input;
        self
    }
    /// <p>The 12-digit account ID of the account requesting to aggregate data.</p>
    pub fn get_requester_account_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.requester_account_id
    }
    /// <p>The region requesting to aggregate data.</p>
    pub fn requester_aws_region(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.requester_aws_region = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The region requesting to aggregate data.</p>
    pub fn set_requester_aws_region(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.requester_aws_region = input;
        self
    }
    /// <p>The region requesting to aggregate data.</p>
    pub fn get_requester_aws_region(&self) -> &::std::option::Option<::std::string::String> {
        &self.requester_aws_region
    }
    /// Consumes the builder and constructs a [`PendingAggregationRequest`](crate::types::PendingAggregationRequest).
    pub fn build(self) -> crate::types::PendingAggregationRequest {
        crate::types::PendingAggregationRequest {
            requester_account_id: self.requester_account_id,
            requester_aws_region: self.requester_aws_region,
        }
    }
}
