// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Returns the status for an organization Config rule in an organization.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct OrganizationConfigRuleStatus {
    /// <p>The name that you assign to organization Config rule.</p>
    pub organization_config_rule_name: ::std::string::String,
    /// <p>Indicates deployment status of an organization Config rule. When management account calls PutOrganizationConfigRule action for the first time, Config rule status is created in all the member accounts. When management account calls PutOrganizationConfigRule action for the second time, Config rule status is updated in all the member accounts. Additionally, Config rule status is updated when one or more member accounts join or leave an organization. Config rule status is deleted when the management account deletes OrganizationConfigRule in all the member accounts and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
    /// <p>Config sets the state of the rule to:</p>
    /// <ul>
    /// <li>
    /// <p><code>CREATE_SUCCESSFUL</code> when an organization Config rule has been successfully created in all the member accounts.</p></li>
    /// <li>
    /// <p><code>CREATE_IN_PROGRESS</code> when an organization Config rule creation is in progress.</p></li>
    /// <li>
    /// <p><code>CREATE_FAILED</code> when an organization Config rule creation failed in one or more member accounts within that organization.</p></li>
    /// <li>
    /// <p><code>DELETE_FAILED</code> when an organization Config rule deletion failed in one or more member accounts within that organization.</p></li>
    /// <li>
    /// <p><code>DELETE_IN_PROGRESS</code> when an organization Config rule deletion is in progress.</p></li>
    /// <li>
    /// <p><code>DELETE_SUCCESSFUL</code> when an organization Config rule has been successfully deleted from all the member accounts.</p></li>
    /// <li>
    /// <p><code>UPDATE_SUCCESSFUL</code> when an organization Config rule has been successfully updated in all the member accounts.</p></li>
    /// <li>
    /// <p><code>UPDATE_IN_PROGRESS</code> when an organization Config rule update is in progress.</p></li>
    /// <li>
    /// <p><code>UPDATE_FAILED</code> when an organization Config rule update failed in one or more member accounts within that organization.</p></li>
    /// </ul>
    pub organization_rule_status: crate::types::OrganizationRuleStatus,
    /// <p>An error code that is returned when organization Config rule creation or deletion has failed.</p>
    pub error_code: ::std::option::Option<::std::string::String>,
    /// <p>An error message indicating that organization Config rule creation or deletion failed due to an error.</p>
    pub error_message: ::std::option::Option<::std::string::String>,
    /// <p>The timestamp of the last update.</p>
    pub last_update_time: ::std::option::Option<::aws_smithy_types::DateTime>,
}
impl OrganizationConfigRuleStatus {
    /// <p>The name that you assign to organization Config rule.</p>
    pub fn organization_config_rule_name(&self) -> &str {
        use std::ops::Deref;
        self.organization_config_rule_name.deref()
    }
    /// <p>Indicates deployment status of an organization Config rule. When management account calls PutOrganizationConfigRule action for the first time, Config rule status is created in all the member accounts. When management account calls PutOrganizationConfigRule action for the second time, Config rule status is updated in all the member accounts. Additionally, Config rule status is updated when one or more member accounts join or leave an organization. Config rule status is deleted when the management account deletes OrganizationConfigRule in all the member accounts and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
    /// <p>Config sets the state of the rule to:</p>
    /// <ul>
    /// <li>
    /// <p><code>CREATE_SUCCESSFUL</code> when an organization Config rule has been successfully created in all the member accounts.</p></li>
    /// <li>
    /// <p><code>CREATE_IN_PROGRESS</code> when an organization Config rule creation is in progress.</p></li>
    /// <li>
    /// <p><code>CREATE_FAILED</code> when an organization Config rule creation failed in one or more member accounts within that organization.</p></li>
    /// <li>
    /// <p><code>DELETE_FAILED</code> when an organization Config rule deletion failed in one or more member accounts within that organization.</p></li>
    /// <li>
    /// <p><code>DELETE_IN_PROGRESS</code> when an organization Config rule deletion is in progress.</p></li>
    /// <li>
    /// <p><code>DELETE_SUCCESSFUL</code> when an organization Config rule has been successfully deleted from all the member accounts.</p></li>
    /// <li>
    /// <p><code>UPDATE_SUCCESSFUL</code> when an organization Config rule has been successfully updated in all the member accounts.</p></li>
    /// <li>
    /// <p><code>UPDATE_IN_PROGRESS</code> when an organization Config rule update is in progress.</p></li>
    /// <li>
    /// <p><code>UPDATE_FAILED</code> when an organization Config rule update failed in one or more member accounts within that organization.</p></li>
    /// </ul>
    pub fn organization_rule_status(&self) -> &crate::types::OrganizationRuleStatus {
        &self.organization_rule_status
    }
    /// <p>An error code that is returned when organization Config rule creation or deletion has failed.</p>
    pub fn error_code(&self) -> ::std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>An error message indicating that organization Config rule creation or deletion failed due to an error.</p>
    pub fn error_message(&self) -> ::std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>The timestamp of the last update.</p>
    pub fn last_update_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
}
impl OrganizationConfigRuleStatus {
    /// Creates a new builder-style object to manufacture [`OrganizationConfigRuleStatus`](crate::types::OrganizationConfigRuleStatus).
    pub fn builder() -> crate::types::builders::OrganizationConfigRuleStatusBuilder {
        crate::types::builders::OrganizationConfigRuleStatusBuilder::default()
    }
}

/// A builder for [`OrganizationConfigRuleStatus`](crate::types::OrganizationConfigRuleStatus).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct OrganizationConfigRuleStatusBuilder {
    pub(crate) organization_config_rule_name: ::std::option::Option<::std::string::String>,
    pub(crate) organization_rule_status: ::std::option::Option<crate::types::OrganizationRuleStatus>,
    pub(crate) error_code: ::std::option::Option<::std::string::String>,
    pub(crate) error_message: ::std::option::Option<::std::string::String>,
    pub(crate) last_update_time: ::std::option::Option<::aws_smithy_types::DateTime>,
}
impl OrganizationConfigRuleStatusBuilder {
    /// <p>The name that you assign to organization Config rule.</p>
    /// This field is required.
    pub fn organization_config_rule_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.organization_config_rule_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name that you assign to organization Config rule.</p>
    pub fn set_organization_config_rule_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.organization_config_rule_name = input;
        self
    }
    /// <p>The name that you assign to organization Config rule.</p>
    pub fn get_organization_config_rule_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.organization_config_rule_name
    }
    /// <p>Indicates deployment status of an organization Config rule. When management account calls PutOrganizationConfigRule action for the first time, Config rule status is created in all the member accounts. When management account calls PutOrganizationConfigRule action for the second time, Config rule status is updated in all the member accounts. Additionally, Config rule status is updated when one or more member accounts join or leave an organization. Config rule status is deleted when the management account deletes OrganizationConfigRule in all the member accounts and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
    /// <p>Config sets the state of the rule to:</p>
    /// <ul>
    /// <li>
    /// <p><code>CREATE_SUCCESSFUL</code> when an organization Config rule has been successfully created in all the member accounts.</p></li>
    /// <li>
    /// <p><code>CREATE_IN_PROGRESS</code> when an organization Config rule creation is in progress.</p></li>
    /// <li>
    /// <p><code>CREATE_FAILED</code> when an organization Config rule creation failed in one or more member accounts within that organization.</p></li>
    /// <li>
    /// <p><code>DELETE_FAILED</code> when an organization Config rule deletion failed in one or more member accounts within that organization.</p></li>
    /// <li>
    /// <p><code>DELETE_IN_PROGRESS</code> when an organization Config rule deletion is in progress.</p></li>
    /// <li>
    /// <p><code>DELETE_SUCCESSFUL</code> when an organization Config rule has been successfully deleted from all the member accounts.</p></li>
    /// <li>
    /// <p><code>UPDATE_SUCCESSFUL</code> when an organization Config rule has been successfully updated in all the member accounts.</p></li>
    /// <li>
    /// <p><code>UPDATE_IN_PROGRESS</code> when an organization Config rule update is in progress.</p></li>
    /// <li>
    /// <p><code>UPDATE_FAILED</code> when an organization Config rule update failed in one or more member accounts within that organization.</p></li>
    /// </ul>
    /// This field is required.
    pub fn organization_rule_status(mut self, input: crate::types::OrganizationRuleStatus) -> Self {
        self.organization_rule_status = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates deployment status of an organization Config rule. When management account calls PutOrganizationConfigRule action for the first time, Config rule status is created in all the member accounts. When management account calls PutOrganizationConfigRule action for the second time, Config rule status is updated in all the member accounts. Additionally, Config rule status is updated when one or more member accounts join or leave an organization. Config rule status is deleted when the management account deletes OrganizationConfigRule in all the member accounts and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
    /// <p>Config sets the state of the rule to:</p>
    /// <ul>
    /// <li>
    /// <p><code>CREATE_SUCCESSFUL</code> when an organization Config rule has been successfully created in all the member accounts.</p></li>
    /// <li>
    /// <p><code>CREATE_IN_PROGRESS</code> when an organization Config rule creation is in progress.</p></li>
    /// <li>
    /// <p><code>CREATE_FAILED</code> when an organization Config rule creation failed in one or more member accounts within that organization.</p></li>
    /// <li>
    /// <p><code>DELETE_FAILED</code> when an organization Config rule deletion failed in one or more member accounts within that organization.</p></li>
    /// <li>
    /// <p><code>DELETE_IN_PROGRESS</code> when an organization Config rule deletion is in progress.</p></li>
    /// <li>
    /// <p><code>DELETE_SUCCESSFUL</code> when an organization Config rule has been successfully deleted from all the member accounts.</p></li>
    /// <li>
    /// <p><code>UPDATE_SUCCESSFUL</code> when an organization Config rule has been successfully updated in all the member accounts.</p></li>
    /// <li>
    /// <p><code>UPDATE_IN_PROGRESS</code> when an organization Config rule update is in progress.</p></li>
    /// <li>
    /// <p><code>UPDATE_FAILED</code> when an organization Config rule update failed in one or more member accounts within that organization.</p></li>
    /// </ul>
    pub fn set_organization_rule_status(mut self, input: ::std::option::Option<crate::types::OrganizationRuleStatus>) -> Self {
        self.organization_rule_status = input;
        self
    }
    /// <p>Indicates deployment status of an organization Config rule. When management account calls PutOrganizationConfigRule action for the first time, Config rule status is created in all the member accounts. When management account calls PutOrganizationConfigRule action for the second time, Config rule status is updated in all the member accounts. Additionally, Config rule status is updated when one or more member accounts join or leave an organization. Config rule status is deleted when the management account deletes OrganizationConfigRule in all the member accounts and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
    /// <p>Config sets the state of the rule to:</p>
    /// <ul>
    /// <li>
    /// <p><code>CREATE_SUCCESSFUL</code> when an organization Config rule has been successfully created in all the member accounts.</p></li>
    /// <li>
    /// <p><code>CREATE_IN_PROGRESS</code> when an organization Config rule creation is in progress.</p></li>
    /// <li>
    /// <p><code>CREATE_FAILED</code> when an organization Config rule creation failed in one or more member accounts within that organization.</p></li>
    /// <li>
    /// <p><code>DELETE_FAILED</code> when an organization Config rule deletion failed in one or more member accounts within that organization.</p></li>
    /// <li>
    /// <p><code>DELETE_IN_PROGRESS</code> when an organization Config rule deletion is in progress.</p></li>
    /// <li>
    /// <p><code>DELETE_SUCCESSFUL</code> when an organization Config rule has been successfully deleted from all the member accounts.</p></li>
    /// <li>
    /// <p><code>UPDATE_SUCCESSFUL</code> when an organization Config rule has been successfully updated in all the member accounts.</p></li>
    /// <li>
    /// <p><code>UPDATE_IN_PROGRESS</code> when an organization Config rule update is in progress.</p></li>
    /// <li>
    /// <p><code>UPDATE_FAILED</code> when an organization Config rule update failed in one or more member accounts within that organization.</p></li>
    /// </ul>
    pub fn get_organization_rule_status(&self) -> &::std::option::Option<crate::types::OrganizationRuleStatus> {
        &self.organization_rule_status
    }
    /// <p>An error code that is returned when organization Config rule creation or deletion has failed.</p>
    pub fn error_code(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.error_code = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>An error code that is returned when organization Config rule creation or deletion has failed.</p>
    pub fn set_error_code(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.error_code = input;
        self
    }
    /// <p>An error code that is returned when organization Config rule creation or deletion has failed.</p>
    pub fn get_error_code(&self) -> &::std::option::Option<::std::string::String> {
        &self.error_code
    }
    /// <p>An error message indicating that organization Config rule creation or deletion failed due to an error.</p>
    pub fn error_message(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.error_message = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>An error message indicating that organization Config rule creation or deletion failed due to an error.</p>
    pub fn set_error_message(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.error_message = input;
        self
    }
    /// <p>An error message indicating that organization Config rule creation or deletion failed due to an error.</p>
    pub fn get_error_message(&self) -> &::std::option::Option<::std::string::String> {
        &self.error_message
    }
    /// <p>The timestamp of the last update.</p>
    pub fn last_update_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.last_update_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The timestamp of the last update.</p>
    pub fn set_last_update_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.last_update_time = input;
        self
    }
    /// <p>The timestamp of the last update.</p>
    pub fn get_last_update_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.last_update_time
    }
    /// Consumes the builder and constructs a [`OrganizationConfigRuleStatus`](crate::types::OrganizationConfigRuleStatus).
    /// This method will fail if any of the following fields are not set:
    /// - [`organization_config_rule_name`](crate::types::builders::OrganizationConfigRuleStatusBuilder::organization_config_rule_name)
    /// - [`organization_rule_status`](crate::types::builders::OrganizationConfigRuleStatusBuilder::organization_rule_status)
    pub fn build(self) -> ::std::result::Result<crate::types::OrganizationConfigRuleStatus, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::OrganizationConfigRuleStatus {
            organization_config_rule_name: self.organization_config_rule_name.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "organization_config_rule_name",
                    "organization_config_rule_name was not specified but it is required when building OrganizationConfigRuleStatus",
                )
            })?,
            organization_rule_status: self.organization_rule_status.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "organization_rule_status",
                    "organization_rule_status was not specified but it is required when building OrganizationConfigRuleStatus",
                )
            })?,
            error_code: self.error_code,
            error_message: self.error_message,
            last_update_time: self.last_update_time,
        })
    }
}
