// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Organization Config rule creation or deletion status in each member account. This includes the name of the rule, the status, error code and error message when the rule creation or deletion failed.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct MemberAccountStatus {
    /// <p>The 12-digit account ID of a member account.</p>
    pub account_id: ::std::string::String,
    /// <p>The name of Config rule deployed in the member account.</p>
    pub config_rule_name: ::std::string::String,
    /// <p>Indicates deployment status for Config rule in the member account. When management account calls <code>PutOrganizationConfigRule</code> action for the first time, Config rule status is created in the member account. When management account calls <code>PutOrganizationConfigRule</code> action for the second time, Config rule status is updated in the member account. Config rule status is deleted when the management account deletes <code>OrganizationConfigRule</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
    /// <p>Config sets the state of the rule to:</p>
    /// <ul>
    /// <li>
    /// <p><code>CREATE_SUCCESSFUL</code> when Config rule has been created in the member account.</p></li>
    /// <li>
    /// <p><code>CREATE_IN_PROGRESS</code> when Config rule is being created in the member account.</p></li>
    /// <li>
    /// <p><code>CREATE_FAILED</code> when Config rule creation has failed in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_FAILED</code> when Config rule deletion has failed in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_IN_PROGRESS</code> when Config rule is being deleted in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_SUCCESSFUL</code> when Config rule has been deleted in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_SUCCESSFUL</code> when Config rule has been updated in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_IN_PROGRESS</code> when Config rule is being updated in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_FAILED</code> when Config rule deletion has failed in the member account.</p></li>
    /// </ul>
    pub member_account_rule_status: crate::types::MemberAccountRuleStatus,
    /// <p>An error code that is returned when Config rule creation or deletion failed in the member account.</p>
    pub error_code: ::std::option::Option<::std::string::String>,
    /// <p>An error message indicating that Config rule account creation or deletion has failed due to an error in the member account.</p>
    pub error_message: ::std::option::Option<::std::string::String>,
    /// <p>The timestamp of the last status update.</p>
    pub last_update_time: ::std::option::Option<::aws_smithy_types::DateTime>,
}
impl MemberAccountStatus {
    /// <p>The 12-digit account ID of a member account.</p>
    pub fn account_id(&self) -> &str {
        use std::ops::Deref;
        self.account_id.deref()
    }
    /// <p>The name of Config rule deployed in the member account.</p>
    pub fn config_rule_name(&self) -> &str {
        use std::ops::Deref;
        self.config_rule_name.deref()
    }
    /// <p>Indicates deployment status for Config rule in the member account. When management account calls <code>PutOrganizationConfigRule</code> action for the first time, Config rule status is created in the member account. When management account calls <code>PutOrganizationConfigRule</code> action for the second time, Config rule status is updated in the member account. Config rule status is deleted when the management account deletes <code>OrganizationConfigRule</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
    /// <p>Config sets the state of the rule to:</p>
    /// <ul>
    /// <li>
    /// <p><code>CREATE_SUCCESSFUL</code> when Config rule has been created in the member account.</p></li>
    /// <li>
    /// <p><code>CREATE_IN_PROGRESS</code> when Config rule is being created in the member account.</p></li>
    /// <li>
    /// <p><code>CREATE_FAILED</code> when Config rule creation has failed in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_FAILED</code> when Config rule deletion has failed in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_IN_PROGRESS</code> when Config rule is being deleted in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_SUCCESSFUL</code> when Config rule has been deleted in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_SUCCESSFUL</code> when Config rule has been updated in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_IN_PROGRESS</code> when Config rule is being updated in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_FAILED</code> when Config rule deletion has failed in the member account.</p></li>
    /// </ul>
    pub fn member_account_rule_status(&self) -> &crate::types::MemberAccountRuleStatus {
        &self.member_account_rule_status
    }
    /// <p>An error code that is returned when Config rule creation or deletion failed in the member account.</p>
    pub fn error_code(&self) -> ::std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>An error message indicating that Config rule account creation or deletion has failed due to an error in the member account.</p>
    pub fn error_message(&self) -> ::std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>The timestamp of the last status update.</p>
    pub fn last_update_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
}
impl MemberAccountStatus {
    /// Creates a new builder-style object to manufacture [`MemberAccountStatus`](crate::types::MemberAccountStatus).
    pub fn builder() -> crate::types::builders::MemberAccountStatusBuilder {
        crate::types::builders::MemberAccountStatusBuilder::default()
    }
}

/// A builder for [`MemberAccountStatus`](crate::types::MemberAccountStatus).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct MemberAccountStatusBuilder {
    pub(crate) account_id: ::std::option::Option<::std::string::String>,
    pub(crate) config_rule_name: ::std::option::Option<::std::string::String>,
    pub(crate) member_account_rule_status: ::std::option::Option<crate::types::MemberAccountRuleStatus>,
    pub(crate) error_code: ::std::option::Option<::std::string::String>,
    pub(crate) error_message: ::std::option::Option<::std::string::String>,
    pub(crate) last_update_time: ::std::option::Option<::aws_smithy_types::DateTime>,
}
impl MemberAccountStatusBuilder {
    /// <p>The 12-digit account ID of a member account.</p>
    /// This field is required.
    pub fn account_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.account_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The 12-digit account ID of a member account.</p>
    pub fn set_account_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.account_id = input;
        self
    }
    /// <p>The 12-digit account ID of a member account.</p>
    pub fn get_account_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.account_id
    }
    /// <p>The name of Config rule deployed in the member account.</p>
    /// This field is required.
    pub fn config_rule_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.config_rule_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of Config rule deployed in the member account.</p>
    pub fn set_config_rule_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.config_rule_name = input;
        self
    }
    /// <p>The name of Config rule deployed in the member account.</p>
    pub fn get_config_rule_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.config_rule_name
    }
    /// <p>Indicates deployment status for Config rule in the member account. When management account calls <code>PutOrganizationConfigRule</code> action for the first time, Config rule status is created in the member account. When management account calls <code>PutOrganizationConfigRule</code> action for the second time, Config rule status is updated in the member account. Config rule status is deleted when the management account deletes <code>OrganizationConfigRule</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
    /// <p>Config sets the state of the rule to:</p>
    /// <ul>
    /// <li>
    /// <p><code>CREATE_SUCCESSFUL</code> when Config rule has been created in the member account.</p></li>
    /// <li>
    /// <p><code>CREATE_IN_PROGRESS</code> when Config rule is being created in the member account.</p></li>
    /// <li>
    /// <p><code>CREATE_FAILED</code> when Config rule creation has failed in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_FAILED</code> when Config rule deletion has failed in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_IN_PROGRESS</code> when Config rule is being deleted in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_SUCCESSFUL</code> when Config rule has been deleted in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_SUCCESSFUL</code> when Config rule has been updated in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_IN_PROGRESS</code> when Config rule is being updated in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_FAILED</code> when Config rule deletion has failed in the member account.</p></li>
    /// </ul>
    /// This field is required.
    pub fn member_account_rule_status(mut self, input: crate::types::MemberAccountRuleStatus) -> Self {
        self.member_account_rule_status = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates deployment status for Config rule in the member account. When management account calls <code>PutOrganizationConfigRule</code> action for the first time, Config rule status is created in the member account. When management account calls <code>PutOrganizationConfigRule</code> action for the second time, Config rule status is updated in the member account. Config rule status is deleted when the management account deletes <code>OrganizationConfigRule</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
    /// <p>Config sets the state of the rule to:</p>
    /// <ul>
    /// <li>
    /// <p><code>CREATE_SUCCESSFUL</code> when Config rule has been created in the member account.</p></li>
    /// <li>
    /// <p><code>CREATE_IN_PROGRESS</code> when Config rule is being created in the member account.</p></li>
    /// <li>
    /// <p><code>CREATE_FAILED</code> when Config rule creation has failed in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_FAILED</code> when Config rule deletion has failed in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_IN_PROGRESS</code> when Config rule is being deleted in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_SUCCESSFUL</code> when Config rule has been deleted in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_SUCCESSFUL</code> when Config rule has been updated in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_IN_PROGRESS</code> when Config rule is being updated in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_FAILED</code> when Config rule deletion has failed in the member account.</p></li>
    /// </ul>
    pub fn set_member_account_rule_status(mut self, input: ::std::option::Option<crate::types::MemberAccountRuleStatus>) -> Self {
        self.member_account_rule_status = input;
        self
    }
    /// <p>Indicates deployment status for Config rule in the member account. When management account calls <code>PutOrganizationConfigRule</code> action for the first time, Config rule status is created in the member account. When management account calls <code>PutOrganizationConfigRule</code> action for the second time, Config rule status is updated in the member account. Config rule status is deleted when the management account deletes <code>OrganizationConfigRule</code> and disables service access for <code>config-multiaccountsetup.amazonaws.com</code>.</p>
    /// <p>Config sets the state of the rule to:</p>
    /// <ul>
    /// <li>
    /// <p><code>CREATE_SUCCESSFUL</code> when Config rule has been created in the member account.</p></li>
    /// <li>
    /// <p><code>CREATE_IN_PROGRESS</code> when Config rule is being created in the member account.</p></li>
    /// <li>
    /// <p><code>CREATE_FAILED</code> when Config rule creation has failed in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_FAILED</code> when Config rule deletion has failed in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_IN_PROGRESS</code> when Config rule is being deleted in the member account.</p></li>
    /// <li>
    /// <p><code>DELETE_SUCCESSFUL</code> when Config rule has been deleted in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_SUCCESSFUL</code> when Config rule has been updated in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_IN_PROGRESS</code> when Config rule is being updated in the member account.</p></li>
    /// <li>
    /// <p><code>UPDATE_FAILED</code> when Config rule deletion has failed in the member account.</p></li>
    /// </ul>
    pub fn get_member_account_rule_status(&self) -> &::std::option::Option<crate::types::MemberAccountRuleStatus> {
        &self.member_account_rule_status
    }
    /// <p>An error code that is returned when Config rule creation or deletion failed in the member account.</p>
    pub fn error_code(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.error_code = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>An error code that is returned when Config rule creation or deletion failed in the member account.</p>
    pub fn set_error_code(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.error_code = input;
        self
    }
    /// <p>An error code that is returned when Config rule creation or deletion failed in the member account.</p>
    pub fn get_error_code(&self) -> &::std::option::Option<::std::string::String> {
        &self.error_code
    }
    /// <p>An error message indicating that Config rule account creation or deletion has failed due to an error in the member account.</p>
    pub fn error_message(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.error_message = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>An error message indicating that Config rule account creation or deletion has failed due to an error in the member account.</p>
    pub fn set_error_message(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.error_message = input;
        self
    }
    /// <p>An error message indicating that Config rule account creation or deletion has failed due to an error in the member account.</p>
    pub fn get_error_message(&self) -> &::std::option::Option<::std::string::String> {
        &self.error_message
    }
    /// <p>The timestamp of the last status update.</p>
    pub fn last_update_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.last_update_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The timestamp of the last status update.</p>
    pub fn set_last_update_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.last_update_time = input;
        self
    }
    /// <p>The timestamp of the last status update.</p>
    pub fn get_last_update_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.last_update_time
    }
    /// Consumes the builder and constructs a [`MemberAccountStatus`](crate::types::MemberAccountStatus).
    /// This method will fail if any of the following fields are not set:
    /// - [`account_id`](crate::types::builders::MemberAccountStatusBuilder::account_id)
    /// - [`config_rule_name`](crate::types::builders::MemberAccountStatusBuilder::config_rule_name)
    /// - [`member_account_rule_status`](crate::types::builders::MemberAccountStatusBuilder::member_account_rule_status)
    pub fn build(self) -> ::std::result::Result<crate::types::MemberAccountStatus, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::MemberAccountStatus {
            account_id: self.account_id.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "account_id",
                    "account_id was not specified but it is required when building MemberAccountStatus",
                )
            })?,
            config_rule_name: self.config_rule_name.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "config_rule_name",
                    "config_rule_name was not specified but it is required when building MemberAccountStatus",
                )
            })?,
            member_account_rule_status: self.member_account_rule_status.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "member_account_rule_status",
                    "member_account_rule_status was not specified but it is required when building MemberAccountStatus",
                )
            })?,
            error_code: self.error_code,
            error_message: self.error_message,
            last_update_time: self.last_update_time,
        })
    }
}
