// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Provides the runtime system, policy definition, and whether debug logging enabled. You can specify the following CustomPolicyDetails parameter values only for Config Custom Policy rules.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct CustomPolicyDetails {
    /// <p>The runtime system for your Config Custom Policy rule. Guard is a policy-as-code language that allows you to write policies that are enforced by Config Custom Policy rules. For more information about Guard, see the <a href="https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a>.</p>
    pub policy_runtime: ::std::string::String,
    /// <p>The policy definition containing the logic for your Config Custom Policy rule.</p>
    pub policy_text: ::std::string::String,
    /// <p>The boolean expression for enabling debug logging for your Config Custom Policy rule. The default value is <code>false</code>.</p>
    pub enable_debug_log_delivery: bool,
}
impl CustomPolicyDetails {
    /// <p>The runtime system for your Config Custom Policy rule. Guard is a policy-as-code language that allows you to write policies that are enforced by Config Custom Policy rules. For more information about Guard, see the <a href="https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a>.</p>
    pub fn policy_runtime(&self) -> &str {
        use std::ops::Deref;
        self.policy_runtime.deref()
    }
    /// <p>The policy definition containing the logic for your Config Custom Policy rule.</p>
    pub fn policy_text(&self) -> &str {
        use std::ops::Deref;
        self.policy_text.deref()
    }
    /// <p>The boolean expression for enabling debug logging for your Config Custom Policy rule. The default value is <code>false</code>.</p>
    pub fn enable_debug_log_delivery(&self) -> bool {
        self.enable_debug_log_delivery
    }
}
impl CustomPolicyDetails {
    /// Creates a new builder-style object to manufacture [`CustomPolicyDetails`](crate::types::CustomPolicyDetails).
    pub fn builder() -> crate::types::builders::CustomPolicyDetailsBuilder {
        crate::types::builders::CustomPolicyDetailsBuilder::default()
    }
}

/// A builder for [`CustomPolicyDetails`](crate::types::CustomPolicyDetails).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct CustomPolicyDetailsBuilder {
    pub(crate) policy_runtime: ::std::option::Option<::std::string::String>,
    pub(crate) policy_text: ::std::option::Option<::std::string::String>,
    pub(crate) enable_debug_log_delivery: ::std::option::Option<bool>,
}
impl CustomPolicyDetailsBuilder {
    /// <p>The runtime system for your Config Custom Policy rule. Guard is a policy-as-code language that allows you to write policies that are enforced by Config Custom Policy rules. For more information about Guard, see the <a href="https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a>.</p>
    /// This field is required.
    pub fn policy_runtime(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.policy_runtime = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The runtime system for your Config Custom Policy rule. Guard is a policy-as-code language that allows you to write policies that are enforced by Config Custom Policy rules. For more information about Guard, see the <a href="https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a>.</p>
    pub fn set_policy_runtime(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.policy_runtime = input;
        self
    }
    /// <p>The runtime system for your Config Custom Policy rule. Guard is a policy-as-code language that allows you to write policies that are enforced by Config Custom Policy rules. For more information about Guard, see the <a href="https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a>.</p>
    pub fn get_policy_runtime(&self) -> &::std::option::Option<::std::string::String> {
        &self.policy_runtime
    }
    /// <p>The policy definition containing the logic for your Config Custom Policy rule.</p>
    /// This field is required.
    pub fn policy_text(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.policy_text = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The policy definition containing the logic for your Config Custom Policy rule.</p>
    pub fn set_policy_text(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.policy_text = input;
        self
    }
    /// <p>The policy definition containing the logic for your Config Custom Policy rule.</p>
    pub fn get_policy_text(&self) -> &::std::option::Option<::std::string::String> {
        &self.policy_text
    }
    /// <p>The boolean expression for enabling debug logging for your Config Custom Policy rule. The default value is <code>false</code>.</p>
    pub fn enable_debug_log_delivery(mut self, input: bool) -> Self {
        self.enable_debug_log_delivery = ::std::option::Option::Some(input);
        self
    }
    /// <p>The boolean expression for enabling debug logging for your Config Custom Policy rule. The default value is <code>false</code>.</p>
    pub fn set_enable_debug_log_delivery(mut self, input: ::std::option::Option<bool>) -> Self {
        self.enable_debug_log_delivery = input;
        self
    }
    /// <p>The boolean expression for enabling debug logging for your Config Custom Policy rule. The default value is <code>false</code>.</p>
    pub fn get_enable_debug_log_delivery(&self) -> &::std::option::Option<bool> {
        &self.enable_debug_log_delivery
    }
    /// Consumes the builder and constructs a [`CustomPolicyDetails`](crate::types::CustomPolicyDetails).
    /// This method will fail if any of the following fields are not set:
    /// - [`policy_runtime`](crate::types::builders::CustomPolicyDetailsBuilder::policy_runtime)
    /// - [`policy_text`](crate::types::builders::CustomPolicyDetailsBuilder::policy_text)
    pub fn build(self) -> ::std::result::Result<crate::types::CustomPolicyDetails, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::CustomPolicyDetails {
            policy_runtime: self.policy_runtime.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "policy_runtime",
                    "policy_runtime was not specified but it is required when building CustomPolicyDetails",
                )
            })?,
            policy_text: self.policy_text.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "policy_text",
                    "policy_text was not specified but it is required when building CustomPolicyDetails",
                )
            })?,
            enable_debug_log_delivery: self.enable_debug_log_delivery.unwrap_or_default(),
        })
    }
}
