// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// When writing a match expression against `ConformancePackState`, it is important to ensure
/// your code is forward-compatible. That is, if a match arm handles a case for a
/// feature that is supported by the service but has not been represented as an enum
/// variant in a current version of SDK, your code should continue to work when you
/// upgrade SDK to a future version in which the enum does include a variant for that
/// feature.
///
/// Here is an example of how you can make a match expression forward-compatible:
///
/// ```text
/// # let conformancepackstate = unimplemented!();
/// match conformancepackstate {
///     ConformancePackState::CreateComplete => { /* ... */ },
///     ConformancePackState::CreateFailed => { /* ... */ },
///     ConformancePackState::CreateInProgress => { /* ... */ },
///     ConformancePackState::DeleteFailed => { /* ... */ },
///     ConformancePackState::DeleteInProgress => { /* ... */ },
///     other @ _ if other.as_str() == "NewFeature" => { /* handles a case for `NewFeature` */ },
///     _ => { /* ... */ },
/// }
/// ```
/// The above code demonstrates that when `conformancepackstate` represents
/// `NewFeature`, the execution path will lead to the second last match arm,
/// even though the enum does not contain a variant `ConformancePackState::NewFeature`
/// in the current version of SDK. The reason is that the variable `other`,
/// created by the `@` operator, is bound to
/// `ConformancePackState::Unknown(UnknownVariantValue("NewFeature".to_owned()))`
/// and calling `as_str` on it yields `"NewFeature"`.
/// This match expression is forward-compatible when executed with a newer
/// version of SDK where the variant `ConformancePackState::NewFeature` is defined.
/// Specifically, when `conformancepackstate` represents `NewFeature`,
/// the execution path will hit the second last match arm as before by virtue of
/// calling `as_str` on `ConformancePackState::NewFeature` also yielding `"NewFeature"`.
///
/// Explicitly matching on the `Unknown` variant should
/// be avoided for two reasons:
/// - The inner data `UnknownVariantValue` is opaque, and no further information can be extracted.
/// - It might inadvertently shadow other intended match arms.
///
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    ::std::clone::Clone, ::std::cmp::Eq, ::std::cmp::Ord, ::std::cmp::PartialEq, ::std::cmp::PartialOrd, ::std::fmt::Debug, ::std::hash::Hash,
)]
pub enum ConformancePackState {
    #[allow(missing_docs)] // documentation missing in model
    CreateComplete,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    /// `Unknown` contains new variants that have been added since this code was generated.
    #[deprecated(note = "Don't directly match on `Unknown`. See the docs on this enum for the correct way to handle unknown variants.")]
    Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue),
}
impl ::std::convert::From<&str> for ConformancePackState {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_COMPLETE" => ConformancePackState::CreateComplete,
            "CREATE_FAILED" => ConformancePackState::CreateFailed,
            "CREATE_IN_PROGRESS" => ConformancePackState::CreateInProgress,
            "DELETE_FAILED" => ConformancePackState::DeleteFailed,
            "DELETE_IN_PROGRESS" => ConformancePackState::DeleteInProgress,
            other => ConformancePackState::Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue(other.to_owned())),
        }
    }
}
impl ::std::str::FromStr for ConformancePackState {
    type Err = ::std::convert::Infallible;

    fn from_str(s: &str) -> ::std::result::Result<Self, <Self as ::std::str::FromStr>::Err> {
        ::std::result::Result::Ok(ConformancePackState::from(s))
    }
}
impl ConformancePackState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConformancePackState::CreateComplete => "CREATE_COMPLETE",
            ConformancePackState::CreateFailed => "CREATE_FAILED",
            ConformancePackState::CreateInProgress => "CREATE_IN_PROGRESS",
            ConformancePackState::DeleteFailed => "DELETE_FAILED",
            ConformancePackState::DeleteInProgress => "DELETE_IN_PROGRESS",
            ConformancePackState::Unknown(value) => value.as_str(),
        }
    }
    /// Returns all the `&str` representations of the enum members.
    pub const fn values() -> &'static [&'static str] {
        &[
            "CREATE_COMPLETE",
            "CREATE_FAILED",
            "CREATE_IN_PROGRESS",
            "DELETE_FAILED",
            "DELETE_IN_PROGRESS",
        ]
    }
}
impl ::std::convert::AsRef<str> for ConformancePackState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
impl ConformancePackState {
    /// Parses the enum value while disallowing unknown variants.
    ///
    /// Unknown variants will result in an error.
    pub fn try_parse(value: &str) -> ::std::result::Result<Self, crate::error::UnknownVariantError> {
        match Self::from(value) {
            #[allow(deprecated)]
            Self::Unknown(_) => ::std::result::Result::Err(crate::error::UnknownVariantError::new(value)),
            known => Ok(known),
        }
    }
}
impl ::std::fmt::Display for ConformancePackState {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        match self {
            ConformancePackState::CreateComplete => write!(f, "CREATE_COMPLETE"),
            ConformancePackState::CreateFailed => write!(f, "CREATE_FAILED"),
            ConformancePackState::CreateInProgress => write!(f, "CREATE_IN_PROGRESS"),
            ConformancePackState::DeleteFailed => write!(f, "DELETE_FAILED"),
            ConformancePackState::DeleteInProgress => write!(f, "DELETE_IN_PROGRESS"),
            ConformancePackState::Unknown(value) => write!(f, "{}", value),
        }
    }
}
