// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The details of a conformance pack evaluation. Provides Config rule and Amazon Web Services resource type that was evaluated, the compliance of the conformance pack, related time stamps, and supplementary information.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ConformancePackEvaluationResult {
    /// <p>The compliance type. The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. <code>INSUFFICIENT_DATA</code> is not supported.</p>
    pub compliance_type: crate::types::ConformancePackComplianceType,
    /// <p>Uniquely identifies an evaluation result.</p>
    pub evaluation_result_identifier: ::std::option::Option<crate::types::EvaluationResultIdentifier>,
    /// <p>The time when Config rule evaluated Amazon Web Services resource.</p>
    pub config_rule_invoked_time: ::aws_smithy_types::DateTime,
    /// <p>The time when Config recorded the evaluation result.</p>
    pub result_recorded_time: ::aws_smithy_types::DateTime,
    /// <p>Supplementary information about how the evaluation determined the compliance.</p>
    pub annotation: ::std::option::Option<::std::string::String>,
}
impl ConformancePackEvaluationResult {
    /// <p>The compliance type. The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. <code>INSUFFICIENT_DATA</code> is not supported.</p>
    pub fn compliance_type(&self) -> &crate::types::ConformancePackComplianceType {
        &self.compliance_type
    }
    /// <p>Uniquely identifies an evaluation result.</p>
    pub fn evaluation_result_identifier(&self) -> ::std::option::Option<&crate::types::EvaluationResultIdentifier> {
        self.evaluation_result_identifier.as_ref()
    }
    /// <p>The time when Config rule evaluated Amazon Web Services resource.</p>
    pub fn config_rule_invoked_time(&self) -> &::aws_smithy_types::DateTime {
        &self.config_rule_invoked_time
    }
    /// <p>The time when Config recorded the evaluation result.</p>
    pub fn result_recorded_time(&self) -> &::aws_smithy_types::DateTime {
        &self.result_recorded_time
    }
    /// <p>Supplementary information about how the evaluation determined the compliance.</p>
    pub fn annotation(&self) -> ::std::option::Option<&str> {
        self.annotation.as_deref()
    }
}
impl ConformancePackEvaluationResult {
    /// Creates a new builder-style object to manufacture [`ConformancePackEvaluationResult`](crate::types::ConformancePackEvaluationResult).
    pub fn builder() -> crate::types::builders::ConformancePackEvaluationResultBuilder {
        crate::types::builders::ConformancePackEvaluationResultBuilder::default()
    }
}

/// A builder for [`ConformancePackEvaluationResult`](crate::types::ConformancePackEvaluationResult).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ConformancePackEvaluationResultBuilder {
    pub(crate) compliance_type: ::std::option::Option<crate::types::ConformancePackComplianceType>,
    pub(crate) evaluation_result_identifier: ::std::option::Option<crate::types::EvaluationResultIdentifier>,
    pub(crate) config_rule_invoked_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) result_recorded_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) annotation: ::std::option::Option<::std::string::String>,
}
impl ConformancePackEvaluationResultBuilder {
    /// <p>The compliance type. The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. <code>INSUFFICIENT_DATA</code> is not supported.</p>
    /// This field is required.
    pub fn compliance_type(mut self, input: crate::types::ConformancePackComplianceType) -> Self {
        self.compliance_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The compliance type. The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. <code>INSUFFICIENT_DATA</code> is not supported.</p>
    pub fn set_compliance_type(mut self, input: ::std::option::Option<crate::types::ConformancePackComplianceType>) -> Self {
        self.compliance_type = input;
        self
    }
    /// <p>The compliance type. The allowed values are <code>COMPLIANT</code> and <code>NON_COMPLIANT</code>. <code>INSUFFICIENT_DATA</code> is not supported.</p>
    pub fn get_compliance_type(&self) -> &::std::option::Option<crate::types::ConformancePackComplianceType> {
        &self.compliance_type
    }
    /// <p>Uniquely identifies an evaluation result.</p>
    /// This field is required.
    pub fn evaluation_result_identifier(mut self, input: crate::types::EvaluationResultIdentifier) -> Self {
        self.evaluation_result_identifier = ::std::option::Option::Some(input);
        self
    }
    /// <p>Uniquely identifies an evaluation result.</p>
    pub fn set_evaluation_result_identifier(mut self, input: ::std::option::Option<crate::types::EvaluationResultIdentifier>) -> Self {
        self.evaluation_result_identifier = input;
        self
    }
    /// <p>Uniquely identifies an evaluation result.</p>
    pub fn get_evaluation_result_identifier(&self) -> &::std::option::Option<crate::types::EvaluationResultIdentifier> {
        &self.evaluation_result_identifier
    }
    /// <p>The time when Config rule evaluated Amazon Web Services resource.</p>
    /// This field is required.
    pub fn config_rule_invoked_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.config_rule_invoked_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time when Config rule evaluated Amazon Web Services resource.</p>
    pub fn set_config_rule_invoked_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.config_rule_invoked_time = input;
        self
    }
    /// <p>The time when Config rule evaluated Amazon Web Services resource.</p>
    pub fn get_config_rule_invoked_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.config_rule_invoked_time
    }
    /// <p>The time when Config recorded the evaluation result.</p>
    /// This field is required.
    pub fn result_recorded_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.result_recorded_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time when Config recorded the evaluation result.</p>
    pub fn set_result_recorded_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.result_recorded_time = input;
        self
    }
    /// <p>The time when Config recorded the evaluation result.</p>
    pub fn get_result_recorded_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.result_recorded_time
    }
    /// <p>Supplementary information about how the evaluation determined the compliance.</p>
    pub fn annotation(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.annotation = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Supplementary information about how the evaluation determined the compliance.</p>
    pub fn set_annotation(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.annotation = input;
        self
    }
    /// <p>Supplementary information about how the evaluation determined the compliance.</p>
    pub fn get_annotation(&self) -> &::std::option::Option<::std::string::String> {
        &self.annotation
    }
    /// Consumes the builder and constructs a [`ConformancePackEvaluationResult`](crate::types::ConformancePackEvaluationResult).
    /// This method will fail if any of the following fields are not set:
    /// - [`compliance_type`](crate::types::builders::ConformancePackEvaluationResultBuilder::compliance_type)
    /// - [`config_rule_invoked_time`](crate::types::builders::ConformancePackEvaluationResultBuilder::config_rule_invoked_time)
    /// - [`result_recorded_time`](crate::types::builders::ConformancePackEvaluationResultBuilder::result_recorded_time)
    pub fn build(self) -> ::std::result::Result<crate::types::ConformancePackEvaluationResult, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::ConformancePackEvaluationResult {
            compliance_type: self.compliance_type.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "compliance_type",
                    "compliance_type was not specified but it is required when building ConformancePackEvaluationResult",
                )
            })?,
            evaluation_result_identifier: self.evaluation_result_identifier,
            config_rule_invoked_time: self.config_rule_invoked_time.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "config_rule_invoked_time",
                    "config_rule_invoked_time was not specified but it is required when building ConformancePackEvaluationResult",
                )
            })?,
            result_recorded_time: self.result_recorded_time.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "result_recorded_time",
                    "result_recorded_time was not specified but it is required when building ConformancePackEvaluationResult",
                )
            })?,
            annotation: self.annotation,
        })
    }
}
