// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Returns details of a conformance pack. A conformance pack is a collection of Config rules and remediation actions that can be easily deployed in an account and a region.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ConformancePackDetail {
    /// <p>Name of the conformance pack.</p>
    pub conformance_pack_name: ::std::string::String,
    /// <p>Amazon Resource Name (ARN) of the conformance pack.</p>
    pub conformance_pack_arn: ::std::string::String,
    /// <p>ID of the conformance pack.</p>
    pub conformance_pack_id: ::std::string::String,
    /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p><note>
    /// <p>This field is optional.</p>
    /// </note>
    pub delivery_s3_bucket: ::std::option::Option<::std::string::String>,
    /// <p>The prefix for the Amazon S3 bucket.</p><note>
    /// <p>This field is optional.</p>
    /// </note>
    pub delivery_s3_key_prefix: ::std::option::Option<::std::string::String>,
    /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
    pub conformance_pack_input_parameters: ::std::option::Option<::std::vec::Vec<crate::types::ConformancePackInputParameter>>,
    /// <p>The last time a conformation pack update was requested.</p>
    pub last_update_requested_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>The Amazon Web Services service that created the conformance pack.</p>
    pub created_by: ::std::option::Option<::std::string::String>,
    /// <p>An object that contains the name or Amazon Resource Name (ARN) of the Amazon Web Services Systems Manager document (SSM document) and the version of the SSM document that is used to create a conformance pack.</p>
    pub template_ssm_document_details: ::std::option::Option<crate::types::TemplateSsmDocumentDetails>,
}
impl ConformancePackDetail {
    /// <p>Name of the conformance pack.</p>
    pub fn conformance_pack_name(&self) -> &str {
        use std::ops::Deref;
        self.conformance_pack_name.deref()
    }
    /// <p>Amazon Resource Name (ARN) of the conformance pack.</p>
    pub fn conformance_pack_arn(&self) -> &str {
        use std::ops::Deref;
        self.conformance_pack_arn.deref()
    }
    /// <p>ID of the conformance pack.</p>
    pub fn conformance_pack_id(&self) -> &str {
        use std::ops::Deref;
        self.conformance_pack_id.deref()
    }
    /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p><note>
    /// <p>This field is optional.</p>
    /// </note>
    pub fn delivery_s3_bucket(&self) -> ::std::option::Option<&str> {
        self.delivery_s3_bucket.as_deref()
    }
    /// <p>The prefix for the Amazon S3 bucket.</p><note>
    /// <p>This field is optional.</p>
    /// </note>
    pub fn delivery_s3_key_prefix(&self) -> ::std::option::Option<&str> {
        self.delivery_s3_key_prefix.as_deref()
    }
    /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.conformance_pack_input_parameters.is_none()`.
    pub fn conformance_pack_input_parameters(&self) -> &[crate::types::ConformancePackInputParameter] {
        self.conformance_pack_input_parameters.as_deref().unwrap_or_default()
    }
    /// <p>The last time a conformation pack update was requested.</p>
    pub fn last_update_requested_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.last_update_requested_time.as_ref()
    }
    /// <p>The Amazon Web Services service that created the conformance pack.</p>
    pub fn created_by(&self) -> ::std::option::Option<&str> {
        self.created_by.as_deref()
    }
    /// <p>An object that contains the name or Amazon Resource Name (ARN) of the Amazon Web Services Systems Manager document (SSM document) and the version of the SSM document that is used to create a conformance pack.</p>
    pub fn template_ssm_document_details(&self) -> ::std::option::Option<&crate::types::TemplateSsmDocumentDetails> {
        self.template_ssm_document_details.as_ref()
    }
}
impl ConformancePackDetail {
    /// Creates a new builder-style object to manufacture [`ConformancePackDetail`](crate::types::ConformancePackDetail).
    pub fn builder() -> crate::types::builders::ConformancePackDetailBuilder {
        crate::types::builders::ConformancePackDetailBuilder::default()
    }
}

/// A builder for [`ConformancePackDetail`](crate::types::ConformancePackDetail).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ConformancePackDetailBuilder {
    pub(crate) conformance_pack_name: ::std::option::Option<::std::string::String>,
    pub(crate) conformance_pack_arn: ::std::option::Option<::std::string::String>,
    pub(crate) conformance_pack_id: ::std::option::Option<::std::string::String>,
    pub(crate) delivery_s3_bucket: ::std::option::Option<::std::string::String>,
    pub(crate) delivery_s3_key_prefix: ::std::option::Option<::std::string::String>,
    pub(crate) conformance_pack_input_parameters: ::std::option::Option<::std::vec::Vec<crate::types::ConformancePackInputParameter>>,
    pub(crate) last_update_requested_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) created_by: ::std::option::Option<::std::string::String>,
    pub(crate) template_ssm_document_details: ::std::option::Option<crate::types::TemplateSsmDocumentDetails>,
}
impl ConformancePackDetailBuilder {
    /// <p>Name of the conformance pack.</p>
    /// This field is required.
    pub fn conformance_pack_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.conformance_pack_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Name of the conformance pack.</p>
    pub fn set_conformance_pack_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.conformance_pack_name = input;
        self
    }
    /// <p>Name of the conformance pack.</p>
    pub fn get_conformance_pack_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.conformance_pack_name
    }
    /// <p>Amazon Resource Name (ARN) of the conformance pack.</p>
    /// This field is required.
    pub fn conformance_pack_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.conformance_pack_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Amazon Resource Name (ARN) of the conformance pack.</p>
    pub fn set_conformance_pack_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.conformance_pack_arn = input;
        self
    }
    /// <p>Amazon Resource Name (ARN) of the conformance pack.</p>
    pub fn get_conformance_pack_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.conformance_pack_arn
    }
    /// <p>ID of the conformance pack.</p>
    /// This field is required.
    pub fn conformance_pack_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.conformance_pack_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>ID of the conformance pack.</p>
    pub fn set_conformance_pack_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.conformance_pack_id = input;
        self
    }
    /// <p>ID of the conformance pack.</p>
    pub fn get_conformance_pack_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.conformance_pack_id
    }
    /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p><note>
    /// <p>This field is optional.</p>
    /// </note>
    pub fn delivery_s3_bucket(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.delivery_s3_bucket = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p><note>
    /// <p>This field is optional.</p>
    /// </note>
    pub fn set_delivery_s3_bucket(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.delivery_s3_bucket = input;
        self
    }
    /// <p>The name of the Amazon S3 bucket where Config stores conformance pack templates.</p><note>
    /// <p>This field is optional.</p>
    /// </note>
    pub fn get_delivery_s3_bucket(&self) -> &::std::option::Option<::std::string::String> {
        &self.delivery_s3_bucket
    }
    /// <p>The prefix for the Amazon S3 bucket.</p><note>
    /// <p>This field is optional.</p>
    /// </note>
    pub fn delivery_s3_key_prefix(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.delivery_s3_key_prefix = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The prefix for the Amazon S3 bucket.</p><note>
    /// <p>This field is optional.</p>
    /// </note>
    pub fn set_delivery_s3_key_prefix(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.delivery_s3_key_prefix = input;
        self
    }
    /// <p>The prefix for the Amazon S3 bucket.</p><note>
    /// <p>This field is optional.</p>
    /// </note>
    pub fn get_delivery_s3_key_prefix(&self) -> &::std::option::Option<::std::string::String> {
        &self.delivery_s3_key_prefix
    }
    /// Appends an item to `conformance_pack_input_parameters`.
    ///
    /// To override the contents of this collection use [`set_conformance_pack_input_parameters`](Self::set_conformance_pack_input_parameters).
    ///
    /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
    pub fn conformance_pack_input_parameters(mut self, input: crate::types::ConformancePackInputParameter) -> Self {
        let mut v = self.conformance_pack_input_parameters.unwrap_or_default();
        v.push(input);
        self.conformance_pack_input_parameters = ::std::option::Option::Some(v);
        self
    }
    /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
    pub fn set_conformance_pack_input_parameters(
        mut self,
        input: ::std::option::Option<::std::vec::Vec<crate::types::ConformancePackInputParameter>>,
    ) -> Self {
        self.conformance_pack_input_parameters = input;
        self
    }
    /// <p>A list of <code>ConformancePackInputParameter</code> objects.</p>
    pub fn get_conformance_pack_input_parameters(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::ConformancePackInputParameter>> {
        &self.conformance_pack_input_parameters
    }
    /// <p>The last time a conformation pack update was requested.</p>
    pub fn last_update_requested_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.last_update_requested_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The last time a conformation pack update was requested.</p>
    pub fn set_last_update_requested_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.last_update_requested_time = input;
        self
    }
    /// <p>The last time a conformation pack update was requested.</p>
    pub fn get_last_update_requested_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.last_update_requested_time
    }
    /// <p>The Amazon Web Services service that created the conformance pack.</p>
    pub fn created_by(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.created_by = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Web Services service that created the conformance pack.</p>
    pub fn set_created_by(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.created_by = input;
        self
    }
    /// <p>The Amazon Web Services service that created the conformance pack.</p>
    pub fn get_created_by(&self) -> &::std::option::Option<::std::string::String> {
        &self.created_by
    }
    /// <p>An object that contains the name or Amazon Resource Name (ARN) of the Amazon Web Services Systems Manager document (SSM document) and the version of the SSM document that is used to create a conformance pack.</p>
    pub fn template_ssm_document_details(mut self, input: crate::types::TemplateSsmDocumentDetails) -> Self {
        self.template_ssm_document_details = ::std::option::Option::Some(input);
        self
    }
    /// <p>An object that contains the name or Amazon Resource Name (ARN) of the Amazon Web Services Systems Manager document (SSM document) and the version of the SSM document that is used to create a conformance pack.</p>
    pub fn set_template_ssm_document_details(mut self, input: ::std::option::Option<crate::types::TemplateSsmDocumentDetails>) -> Self {
        self.template_ssm_document_details = input;
        self
    }
    /// <p>An object that contains the name or Amazon Resource Name (ARN) of the Amazon Web Services Systems Manager document (SSM document) and the version of the SSM document that is used to create a conformance pack.</p>
    pub fn get_template_ssm_document_details(&self) -> &::std::option::Option<crate::types::TemplateSsmDocumentDetails> {
        &self.template_ssm_document_details
    }
    /// Consumes the builder and constructs a [`ConformancePackDetail`](crate::types::ConformancePackDetail).
    /// This method will fail if any of the following fields are not set:
    /// - [`conformance_pack_name`](crate::types::builders::ConformancePackDetailBuilder::conformance_pack_name)
    /// - [`conformance_pack_arn`](crate::types::builders::ConformancePackDetailBuilder::conformance_pack_arn)
    /// - [`conformance_pack_id`](crate::types::builders::ConformancePackDetailBuilder::conformance_pack_id)
    pub fn build(self) -> ::std::result::Result<crate::types::ConformancePackDetail, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::ConformancePackDetail {
            conformance_pack_name: self.conformance_pack_name.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "conformance_pack_name",
                    "conformance_pack_name was not specified but it is required when building ConformancePackDetail",
                )
            })?,
            conformance_pack_arn: self.conformance_pack_arn.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "conformance_pack_arn",
                    "conformance_pack_arn was not specified but it is required when building ConformancePackDetail",
                )
            })?,
            conformance_pack_id: self.conformance_pack_id.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "conformance_pack_id",
                    "conformance_pack_id was not specified but it is required when building ConformancePackDetail",
                )
            })?,
            delivery_s3_bucket: self.delivery_s3_bucket,
            delivery_s3_key_prefix: self.delivery_s3_key_prefix,
            conformance_pack_input_parameters: self.conformance_pack_input_parameters,
            last_update_requested_time: self.last_update_requested_time,
            created_by: self.created_by,
            template_ssm_document_details: self.template_ssm_document_details,
        })
    }
}
