// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A summary of a configuration recorder, including the <code>arn</code>, <code>name</code>, <code>servicePrincipal</code>, and <code>recordingScope</code>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ConfigurationRecorderSummary {
    /// <p>The Amazon Resource Name (ARN) of the configuration recorder.</p>
    pub arn: ::std::string::String,
    /// <p>The name of the configuration recorder.</p>
    pub name: ::std::string::String,
    /// <p>For service-linked configuration recorders, indicates which Amazon Web Services service the configuration recorder is linked to.</p>
    pub service_principal: ::std::option::Option<::std::string::String>,
    /// <p>Indicates whether the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a> in scope for the configuration recorder are recorded for free (<code>INTERNAL</code>) or if you are charged a service fee for recording (<code>PAID</code>).</p>
    pub recording_scope: crate::types::RecordingScope,
}
impl ConfigurationRecorderSummary {
    /// <p>The Amazon Resource Name (ARN) of the configuration recorder.</p>
    pub fn arn(&self) -> &str {
        use std::ops::Deref;
        self.arn.deref()
    }
    /// <p>The name of the configuration recorder.</p>
    pub fn name(&self) -> &str {
        use std::ops::Deref;
        self.name.deref()
    }
    /// <p>For service-linked configuration recorders, indicates which Amazon Web Services service the configuration recorder is linked to.</p>
    pub fn service_principal(&self) -> ::std::option::Option<&str> {
        self.service_principal.as_deref()
    }
    /// <p>Indicates whether the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a> in scope for the configuration recorder are recorded for free (<code>INTERNAL</code>) or if you are charged a service fee for recording (<code>PAID</code>).</p>
    pub fn recording_scope(&self) -> &crate::types::RecordingScope {
        &self.recording_scope
    }
}
impl ConfigurationRecorderSummary {
    /// Creates a new builder-style object to manufacture [`ConfigurationRecorderSummary`](crate::types::ConfigurationRecorderSummary).
    pub fn builder() -> crate::types::builders::ConfigurationRecorderSummaryBuilder {
        crate::types::builders::ConfigurationRecorderSummaryBuilder::default()
    }
}

/// A builder for [`ConfigurationRecorderSummary`](crate::types::ConfigurationRecorderSummary).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ConfigurationRecorderSummaryBuilder {
    pub(crate) arn: ::std::option::Option<::std::string::String>,
    pub(crate) name: ::std::option::Option<::std::string::String>,
    pub(crate) service_principal: ::std::option::Option<::std::string::String>,
    pub(crate) recording_scope: ::std::option::Option<crate::types::RecordingScope>,
}
impl ConfigurationRecorderSummaryBuilder {
    /// <p>The Amazon Resource Name (ARN) of the configuration recorder.</p>
    /// This field is required.
    pub fn arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the configuration recorder.</p>
    pub fn set_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the configuration recorder.</p>
    pub fn get_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.arn
    }
    /// <p>The name of the configuration recorder.</p>
    /// This field is required.
    pub fn name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the configuration recorder.</p>
    pub fn set_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.name = input;
        self
    }
    /// <p>The name of the configuration recorder.</p>
    pub fn get_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.name
    }
    /// <p>For service-linked configuration recorders, indicates which Amazon Web Services service the configuration recorder is linked to.</p>
    pub fn service_principal(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.service_principal = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>For service-linked configuration recorders, indicates which Amazon Web Services service the configuration recorder is linked to.</p>
    pub fn set_service_principal(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.service_principal = input;
        self
    }
    /// <p>For service-linked configuration recorders, indicates which Amazon Web Services service the configuration recorder is linked to.</p>
    pub fn get_service_principal(&self) -> &::std::option::Option<::std::string::String> {
        &self.service_principal
    }
    /// <p>Indicates whether the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a> in scope for the configuration recorder are recorded for free (<code>INTERNAL</code>) or if you are charged a service fee for recording (<code>PAID</code>).</p>
    /// This field is required.
    pub fn recording_scope(mut self, input: crate::types::RecordingScope) -> Self {
        self.recording_scope = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates whether the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a> in scope for the configuration recorder are recorded for free (<code>INTERNAL</code>) or if you are charged a service fee for recording (<code>PAID</code>).</p>
    pub fn set_recording_scope(mut self, input: ::std::option::Option<crate::types::RecordingScope>) -> Self {
        self.recording_scope = input;
        self
    }
    /// <p>Indicates whether the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a> in scope for the configuration recorder are recorded for free (<code>INTERNAL</code>) or if you are charged a service fee for recording (<code>PAID</code>).</p>
    pub fn get_recording_scope(&self) -> &::std::option::Option<crate::types::RecordingScope> {
        &self.recording_scope
    }
    /// Consumes the builder and constructs a [`ConfigurationRecorderSummary`](crate::types::ConfigurationRecorderSummary).
    /// This method will fail if any of the following fields are not set:
    /// - [`arn`](crate::types::builders::ConfigurationRecorderSummaryBuilder::arn)
    /// - [`name`](crate::types::builders::ConfigurationRecorderSummaryBuilder::name)
    /// - [`recording_scope`](crate::types::builders::ConfigurationRecorderSummaryBuilder::recording_scope)
    pub fn build(self) -> ::std::result::Result<crate::types::ConfigurationRecorderSummary, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::ConfigurationRecorderSummary {
            arn: self.arn.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "arn",
                    "arn was not specified but it is required when building ConfigurationRecorderSummary",
                )
            })?,
            name: self.name.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "name",
                    "name was not specified but it is required when building ConfigurationRecorderSummary",
                )
            })?,
            service_principal: self.service_principal,
            recording_scope: self.recording_scope.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "recording_scope",
                    "recording_scope was not specified but it is required when building ConfigurationRecorderSummary",
                )
            })?,
        })
    }
}
