// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Records configuration changes to the resource types in scope.</p>
/// <p>For more information about the configuration recorder, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/stop-start-recorder.html"> <b>Working with the Configuration Recorder</b> </a> in the <i>Config Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ConfigurationRecorder {
    /// <p>The Amazon Resource Name (ARN) of the specified configuration recorder.</p>
    pub arn: ::std::option::Option<::std::string::String>,
    /// <p>The name of the configuration recorder.</p>
    /// <p>For customer managed configuration recorders, Config automatically assigns the name of "default" when creating a configuration recorder if you do not specify a name at creation time.</p>
    /// <p>For service-linked configuration recorders, Config automatically assigns a name that has the prefix "<code>AWS</code>" to a new service-linked configuration recorder.</p><note>
    /// <p><b>Changing the name of a configuration recorder</b></p>
    /// <p>To change the name of the customer managed configuration recorder, you must delete it and create a new customer managed configuration recorder with a new name.</p>
    /// <p>You cannot change the name of a service-linked configuration recorder.</p>
    /// </note>
    pub name: ::std::option::Option<::std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role assumed by Config and used by the specified configuration recorder.</p><note>
    /// <p><b>The server will reject a request without a defined <code>roleARN</code> for the configuration recorder</b></p>
    /// <p>While the API model does not require this field, the server will reject a request without a defined <code>roleARN</code> for the configuration recorder.</p>
    /// <p><b>Policies and compliance results</b></p>
    /// <p><a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM policies</a> and <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html">other policies managed in Organizations</a> can impact whether Config has permissions to record configuration changes for your resources. Additionally, rules directly evaluate the configuration of a resource and rules don't take into account these policies when running evaluations. Make sure that the policies in effect align with how you intend to use Config.</p>
    /// <p><b>Keep Minimum Permisions When Reusing an IAM role</b></p>
    /// <p>If you use an Amazon Web Services service that uses Config, such as Security Hub or Control Tower, and an IAM role has already been created, make sure that the IAM role that you use when setting up Config keeps the same minimum permissions as the pre-existing IAM role. You must do this to ensure that the other Amazon Web Services service continues to run as expected.</p>
    /// <p>For example, if Control Tower has an IAM role that allows Config to read S3 objects, make sure that the same permissions are granted to the IAM role you use when setting up Config. Otherwise, it may interfere with how Control Tower operates.</p>
    /// <p><b>The service-linked IAM role for Config must be used for service-linked configuration recorders</b></p>
    /// <p>For service-linked configuration recorders, you must use the service-linked IAM role for Config: <a href="https://docs.aws.amazon.com/config/latest/developerguide/using-service-linked-roles.html">AWSServiceRoleForConfig</a>.</p>
    /// </note>
    pub role_arn: ::std::option::Option<::std::string::String>,
    /// <p>Specifies which resource types are in scope for the configuration recorder to record.</p><note>
    /// <p><b> High Number of Config Evaluations</b></p>
    /// <p>You might notice increased activity in your account during your initial month recording with Config when compared to subsequent months. During the initial bootstrapping process, Config runs evaluations on all the resources in your account that you have selected for Config to record.</p>
    /// <p>If you are running ephemeral workloads, you may see increased activity from Config as it records configuration changes associated with creating and deleting these temporary resources. An <i>ephemeral workload</i> is a temporary use of computing resources that are loaded and run when needed. Examples include Amazon Elastic Compute Cloud (Amazon EC2) Spot Instances, Amazon EMR jobs, and Auto Scaling.</p>
    /// <p>If you want to avoid the increased activity from running ephemeral workloads, you can set up the configuration recorder to exclude these resource types from being recorded, or run these types of workloads in a separate account with Config turned off to avoid increased configuration recording and rule evaluations.</p>
    /// </note>
    pub recording_group: ::std::option::Option<crate::types::RecordingGroup>,
    /// <p>Specifies the default recording frequency for the configuration recorder. Config supports <i>Continuous recording</i> and <i>Daily recording</i>.</p>
    /// <ul>
    /// <li>
    /// <p>Continuous recording allows you to record configuration changes continuously whenever a change occurs.</p></li>
    /// <li>
    /// <p>Daily recording allows you to receive a configuration item (CI) representing the most recent state of your resources over the last 24-hour period, only if it’s different from the previous CI recorded.</p></li>
    /// </ul><note>
    /// <p><b>Some resource types require continuous recording</b></p>
    /// <p>Firewall Manager depends on continuous recording to monitor your resources. If you are using Firewall Manager, it is recommended that you set the recording frequency to Continuous.</p>
    /// </note>
    /// <p>You can also override the recording frequency for specific resource types.</p>
    pub recording_mode: ::std::option::Option<crate::types::RecordingMode>,
    /// <p>Specifies whether the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a> in scope for the specified configuration recorder are recorded for free (<code>INTERNAL</code>) or if it impacts the costs to your bill (<code>PAID</code>).</p>
    pub recording_scope: ::std::option::Option<crate::types::RecordingScope>,
    /// <p>For service-linked configuration recorders, specifies the linked Amazon Web Services service for the configuration recorder.</p>
    pub service_principal: ::std::option::Option<::std::string::String>,
}
impl ConfigurationRecorder {
    /// <p>The Amazon Resource Name (ARN) of the specified configuration recorder.</p>
    pub fn arn(&self) -> ::std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the configuration recorder.</p>
    /// <p>For customer managed configuration recorders, Config automatically assigns the name of "default" when creating a configuration recorder if you do not specify a name at creation time.</p>
    /// <p>For service-linked configuration recorders, Config automatically assigns a name that has the prefix "<code>AWS</code>" to a new service-linked configuration recorder.</p><note>
    /// <p><b>Changing the name of a configuration recorder</b></p>
    /// <p>To change the name of the customer managed configuration recorder, you must delete it and create a new customer managed configuration recorder with a new name.</p>
    /// <p>You cannot change the name of a service-linked configuration recorder.</p>
    /// </note>
    pub fn name(&self) -> ::std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role assumed by Config and used by the specified configuration recorder.</p><note>
    /// <p><b>The server will reject a request without a defined <code>roleARN</code> for the configuration recorder</b></p>
    /// <p>While the API model does not require this field, the server will reject a request without a defined <code>roleARN</code> for the configuration recorder.</p>
    /// <p><b>Policies and compliance results</b></p>
    /// <p><a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM policies</a> and <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html">other policies managed in Organizations</a> can impact whether Config has permissions to record configuration changes for your resources. Additionally, rules directly evaluate the configuration of a resource and rules don't take into account these policies when running evaluations. Make sure that the policies in effect align with how you intend to use Config.</p>
    /// <p><b>Keep Minimum Permisions When Reusing an IAM role</b></p>
    /// <p>If you use an Amazon Web Services service that uses Config, such as Security Hub or Control Tower, and an IAM role has already been created, make sure that the IAM role that you use when setting up Config keeps the same minimum permissions as the pre-existing IAM role. You must do this to ensure that the other Amazon Web Services service continues to run as expected.</p>
    /// <p>For example, if Control Tower has an IAM role that allows Config to read S3 objects, make sure that the same permissions are granted to the IAM role you use when setting up Config. Otherwise, it may interfere with how Control Tower operates.</p>
    /// <p><b>The service-linked IAM role for Config must be used for service-linked configuration recorders</b></p>
    /// <p>For service-linked configuration recorders, you must use the service-linked IAM role for Config: <a href="https://docs.aws.amazon.com/config/latest/developerguide/using-service-linked-roles.html">AWSServiceRoleForConfig</a>.</p>
    /// </note>
    pub fn role_arn(&self) -> ::std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Specifies which resource types are in scope for the configuration recorder to record.</p><note>
    /// <p><b> High Number of Config Evaluations</b></p>
    /// <p>You might notice increased activity in your account during your initial month recording with Config when compared to subsequent months. During the initial bootstrapping process, Config runs evaluations on all the resources in your account that you have selected for Config to record.</p>
    /// <p>If you are running ephemeral workloads, you may see increased activity from Config as it records configuration changes associated with creating and deleting these temporary resources. An <i>ephemeral workload</i> is a temporary use of computing resources that are loaded and run when needed. Examples include Amazon Elastic Compute Cloud (Amazon EC2) Spot Instances, Amazon EMR jobs, and Auto Scaling.</p>
    /// <p>If you want to avoid the increased activity from running ephemeral workloads, you can set up the configuration recorder to exclude these resource types from being recorded, or run these types of workloads in a separate account with Config turned off to avoid increased configuration recording and rule evaluations.</p>
    /// </note>
    pub fn recording_group(&self) -> ::std::option::Option<&crate::types::RecordingGroup> {
        self.recording_group.as_ref()
    }
    /// <p>Specifies the default recording frequency for the configuration recorder. Config supports <i>Continuous recording</i> and <i>Daily recording</i>.</p>
    /// <ul>
    /// <li>
    /// <p>Continuous recording allows you to record configuration changes continuously whenever a change occurs.</p></li>
    /// <li>
    /// <p>Daily recording allows you to receive a configuration item (CI) representing the most recent state of your resources over the last 24-hour period, only if it’s different from the previous CI recorded.</p></li>
    /// </ul><note>
    /// <p><b>Some resource types require continuous recording</b></p>
    /// <p>Firewall Manager depends on continuous recording to monitor your resources. If you are using Firewall Manager, it is recommended that you set the recording frequency to Continuous.</p>
    /// </note>
    /// <p>You can also override the recording frequency for specific resource types.</p>
    pub fn recording_mode(&self) -> ::std::option::Option<&crate::types::RecordingMode> {
        self.recording_mode.as_ref()
    }
    /// <p>Specifies whether the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a> in scope for the specified configuration recorder are recorded for free (<code>INTERNAL</code>) or if it impacts the costs to your bill (<code>PAID</code>).</p>
    pub fn recording_scope(&self) -> ::std::option::Option<&crate::types::RecordingScope> {
        self.recording_scope.as_ref()
    }
    /// <p>For service-linked configuration recorders, specifies the linked Amazon Web Services service for the configuration recorder.</p>
    pub fn service_principal(&self) -> ::std::option::Option<&str> {
        self.service_principal.as_deref()
    }
}
impl ConfigurationRecorder {
    /// Creates a new builder-style object to manufacture [`ConfigurationRecorder`](crate::types::ConfigurationRecorder).
    pub fn builder() -> crate::types::builders::ConfigurationRecorderBuilder {
        crate::types::builders::ConfigurationRecorderBuilder::default()
    }
}

/// A builder for [`ConfigurationRecorder`](crate::types::ConfigurationRecorder).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ConfigurationRecorderBuilder {
    pub(crate) arn: ::std::option::Option<::std::string::String>,
    pub(crate) name: ::std::option::Option<::std::string::String>,
    pub(crate) role_arn: ::std::option::Option<::std::string::String>,
    pub(crate) recording_group: ::std::option::Option<crate::types::RecordingGroup>,
    pub(crate) recording_mode: ::std::option::Option<crate::types::RecordingMode>,
    pub(crate) recording_scope: ::std::option::Option<crate::types::RecordingScope>,
    pub(crate) service_principal: ::std::option::Option<::std::string::String>,
}
impl ConfigurationRecorderBuilder {
    /// <p>The Amazon Resource Name (ARN) of the specified configuration recorder.</p>
    pub fn arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the specified configuration recorder.</p>
    pub fn set_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the specified configuration recorder.</p>
    pub fn get_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.arn
    }
    /// <p>The name of the configuration recorder.</p>
    /// <p>For customer managed configuration recorders, Config automatically assigns the name of "default" when creating a configuration recorder if you do not specify a name at creation time.</p>
    /// <p>For service-linked configuration recorders, Config automatically assigns a name that has the prefix "<code>AWS</code>" to a new service-linked configuration recorder.</p><note>
    /// <p><b>Changing the name of a configuration recorder</b></p>
    /// <p>To change the name of the customer managed configuration recorder, you must delete it and create a new customer managed configuration recorder with a new name.</p>
    /// <p>You cannot change the name of a service-linked configuration recorder.</p>
    /// </note>
    pub fn name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the configuration recorder.</p>
    /// <p>For customer managed configuration recorders, Config automatically assigns the name of "default" when creating a configuration recorder if you do not specify a name at creation time.</p>
    /// <p>For service-linked configuration recorders, Config automatically assigns a name that has the prefix "<code>AWS</code>" to a new service-linked configuration recorder.</p><note>
    /// <p><b>Changing the name of a configuration recorder</b></p>
    /// <p>To change the name of the customer managed configuration recorder, you must delete it and create a new customer managed configuration recorder with a new name.</p>
    /// <p>You cannot change the name of a service-linked configuration recorder.</p>
    /// </note>
    pub fn set_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.name = input;
        self
    }
    /// <p>The name of the configuration recorder.</p>
    /// <p>For customer managed configuration recorders, Config automatically assigns the name of "default" when creating a configuration recorder if you do not specify a name at creation time.</p>
    /// <p>For service-linked configuration recorders, Config automatically assigns a name that has the prefix "<code>AWS</code>" to a new service-linked configuration recorder.</p><note>
    /// <p><b>Changing the name of a configuration recorder</b></p>
    /// <p>To change the name of the customer managed configuration recorder, you must delete it and create a new customer managed configuration recorder with a new name.</p>
    /// <p>You cannot change the name of a service-linked configuration recorder.</p>
    /// </note>
    pub fn get_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.name
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role assumed by Config and used by the specified configuration recorder.</p><note>
    /// <p><b>The server will reject a request without a defined <code>roleARN</code> for the configuration recorder</b></p>
    /// <p>While the API model does not require this field, the server will reject a request without a defined <code>roleARN</code> for the configuration recorder.</p>
    /// <p><b>Policies and compliance results</b></p>
    /// <p><a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM policies</a> and <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html">other policies managed in Organizations</a> can impact whether Config has permissions to record configuration changes for your resources. Additionally, rules directly evaluate the configuration of a resource and rules don't take into account these policies when running evaluations. Make sure that the policies in effect align with how you intend to use Config.</p>
    /// <p><b>Keep Minimum Permisions When Reusing an IAM role</b></p>
    /// <p>If you use an Amazon Web Services service that uses Config, such as Security Hub or Control Tower, and an IAM role has already been created, make sure that the IAM role that you use when setting up Config keeps the same minimum permissions as the pre-existing IAM role. You must do this to ensure that the other Amazon Web Services service continues to run as expected.</p>
    /// <p>For example, if Control Tower has an IAM role that allows Config to read S3 objects, make sure that the same permissions are granted to the IAM role you use when setting up Config. Otherwise, it may interfere with how Control Tower operates.</p>
    /// <p><b>The service-linked IAM role for Config must be used for service-linked configuration recorders</b></p>
    /// <p>For service-linked configuration recorders, you must use the service-linked IAM role for Config: <a href="https://docs.aws.amazon.com/config/latest/developerguide/using-service-linked-roles.html">AWSServiceRoleForConfig</a>.</p>
    /// </note>
    pub fn role_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.role_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role assumed by Config and used by the specified configuration recorder.</p><note>
    /// <p><b>The server will reject a request without a defined <code>roleARN</code> for the configuration recorder</b></p>
    /// <p>While the API model does not require this field, the server will reject a request without a defined <code>roleARN</code> for the configuration recorder.</p>
    /// <p><b>Policies and compliance results</b></p>
    /// <p><a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM policies</a> and <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html">other policies managed in Organizations</a> can impact whether Config has permissions to record configuration changes for your resources. Additionally, rules directly evaluate the configuration of a resource and rules don't take into account these policies when running evaluations. Make sure that the policies in effect align with how you intend to use Config.</p>
    /// <p><b>Keep Minimum Permisions When Reusing an IAM role</b></p>
    /// <p>If you use an Amazon Web Services service that uses Config, such as Security Hub or Control Tower, and an IAM role has already been created, make sure that the IAM role that you use when setting up Config keeps the same minimum permissions as the pre-existing IAM role. You must do this to ensure that the other Amazon Web Services service continues to run as expected.</p>
    /// <p>For example, if Control Tower has an IAM role that allows Config to read S3 objects, make sure that the same permissions are granted to the IAM role you use when setting up Config. Otherwise, it may interfere with how Control Tower operates.</p>
    /// <p><b>The service-linked IAM role for Config must be used for service-linked configuration recorders</b></p>
    /// <p>For service-linked configuration recorders, you must use the service-linked IAM role for Config: <a href="https://docs.aws.amazon.com/config/latest/developerguide/using-service-linked-roles.html">AWSServiceRoleForConfig</a>.</p>
    /// </note>
    pub fn set_role_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.role_arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role assumed by Config and used by the specified configuration recorder.</p><note>
    /// <p><b>The server will reject a request without a defined <code>roleARN</code> for the configuration recorder</b></p>
    /// <p>While the API model does not require this field, the server will reject a request without a defined <code>roleARN</code> for the configuration recorder.</p>
    /// <p><b>Policies and compliance results</b></p>
    /// <p><a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html">IAM policies</a> and <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html">other policies managed in Organizations</a> can impact whether Config has permissions to record configuration changes for your resources. Additionally, rules directly evaluate the configuration of a resource and rules don't take into account these policies when running evaluations. Make sure that the policies in effect align with how you intend to use Config.</p>
    /// <p><b>Keep Minimum Permisions When Reusing an IAM role</b></p>
    /// <p>If you use an Amazon Web Services service that uses Config, such as Security Hub or Control Tower, and an IAM role has already been created, make sure that the IAM role that you use when setting up Config keeps the same minimum permissions as the pre-existing IAM role. You must do this to ensure that the other Amazon Web Services service continues to run as expected.</p>
    /// <p>For example, if Control Tower has an IAM role that allows Config to read S3 objects, make sure that the same permissions are granted to the IAM role you use when setting up Config. Otherwise, it may interfere with how Control Tower operates.</p>
    /// <p><b>The service-linked IAM role for Config must be used for service-linked configuration recorders</b></p>
    /// <p>For service-linked configuration recorders, you must use the service-linked IAM role for Config: <a href="https://docs.aws.amazon.com/config/latest/developerguide/using-service-linked-roles.html">AWSServiceRoleForConfig</a>.</p>
    /// </note>
    pub fn get_role_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.role_arn
    }
    /// <p>Specifies which resource types are in scope for the configuration recorder to record.</p><note>
    /// <p><b> High Number of Config Evaluations</b></p>
    /// <p>You might notice increased activity in your account during your initial month recording with Config when compared to subsequent months. During the initial bootstrapping process, Config runs evaluations on all the resources in your account that you have selected for Config to record.</p>
    /// <p>If you are running ephemeral workloads, you may see increased activity from Config as it records configuration changes associated with creating and deleting these temporary resources. An <i>ephemeral workload</i> is a temporary use of computing resources that are loaded and run when needed. Examples include Amazon Elastic Compute Cloud (Amazon EC2) Spot Instances, Amazon EMR jobs, and Auto Scaling.</p>
    /// <p>If you want to avoid the increased activity from running ephemeral workloads, you can set up the configuration recorder to exclude these resource types from being recorded, or run these types of workloads in a separate account with Config turned off to avoid increased configuration recording and rule evaluations.</p>
    /// </note>
    pub fn recording_group(mut self, input: crate::types::RecordingGroup) -> Self {
        self.recording_group = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies which resource types are in scope for the configuration recorder to record.</p><note>
    /// <p><b> High Number of Config Evaluations</b></p>
    /// <p>You might notice increased activity in your account during your initial month recording with Config when compared to subsequent months. During the initial bootstrapping process, Config runs evaluations on all the resources in your account that you have selected for Config to record.</p>
    /// <p>If you are running ephemeral workloads, you may see increased activity from Config as it records configuration changes associated with creating and deleting these temporary resources. An <i>ephemeral workload</i> is a temporary use of computing resources that are loaded and run when needed. Examples include Amazon Elastic Compute Cloud (Amazon EC2) Spot Instances, Amazon EMR jobs, and Auto Scaling.</p>
    /// <p>If you want to avoid the increased activity from running ephemeral workloads, you can set up the configuration recorder to exclude these resource types from being recorded, or run these types of workloads in a separate account with Config turned off to avoid increased configuration recording and rule evaluations.</p>
    /// </note>
    pub fn set_recording_group(mut self, input: ::std::option::Option<crate::types::RecordingGroup>) -> Self {
        self.recording_group = input;
        self
    }
    /// <p>Specifies which resource types are in scope for the configuration recorder to record.</p><note>
    /// <p><b> High Number of Config Evaluations</b></p>
    /// <p>You might notice increased activity in your account during your initial month recording with Config when compared to subsequent months. During the initial bootstrapping process, Config runs evaluations on all the resources in your account that you have selected for Config to record.</p>
    /// <p>If you are running ephemeral workloads, you may see increased activity from Config as it records configuration changes associated with creating and deleting these temporary resources. An <i>ephemeral workload</i> is a temporary use of computing resources that are loaded and run when needed. Examples include Amazon Elastic Compute Cloud (Amazon EC2) Spot Instances, Amazon EMR jobs, and Auto Scaling.</p>
    /// <p>If you want to avoid the increased activity from running ephemeral workloads, you can set up the configuration recorder to exclude these resource types from being recorded, or run these types of workloads in a separate account with Config turned off to avoid increased configuration recording and rule evaluations.</p>
    /// </note>
    pub fn get_recording_group(&self) -> &::std::option::Option<crate::types::RecordingGroup> {
        &self.recording_group
    }
    /// <p>Specifies the default recording frequency for the configuration recorder. Config supports <i>Continuous recording</i> and <i>Daily recording</i>.</p>
    /// <ul>
    /// <li>
    /// <p>Continuous recording allows you to record configuration changes continuously whenever a change occurs.</p></li>
    /// <li>
    /// <p>Daily recording allows you to receive a configuration item (CI) representing the most recent state of your resources over the last 24-hour period, only if it’s different from the previous CI recorded.</p></li>
    /// </ul><note>
    /// <p><b>Some resource types require continuous recording</b></p>
    /// <p>Firewall Manager depends on continuous recording to monitor your resources. If you are using Firewall Manager, it is recommended that you set the recording frequency to Continuous.</p>
    /// </note>
    /// <p>You can also override the recording frequency for specific resource types.</p>
    pub fn recording_mode(mut self, input: crate::types::RecordingMode) -> Self {
        self.recording_mode = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies the default recording frequency for the configuration recorder. Config supports <i>Continuous recording</i> and <i>Daily recording</i>.</p>
    /// <ul>
    /// <li>
    /// <p>Continuous recording allows you to record configuration changes continuously whenever a change occurs.</p></li>
    /// <li>
    /// <p>Daily recording allows you to receive a configuration item (CI) representing the most recent state of your resources over the last 24-hour period, only if it’s different from the previous CI recorded.</p></li>
    /// </ul><note>
    /// <p><b>Some resource types require continuous recording</b></p>
    /// <p>Firewall Manager depends on continuous recording to monitor your resources. If you are using Firewall Manager, it is recommended that you set the recording frequency to Continuous.</p>
    /// </note>
    /// <p>You can also override the recording frequency for specific resource types.</p>
    pub fn set_recording_mode(mut self, input: ::std::option::Option<crate::types::RecordingMode>) -> Self {
        self.recording_mode = input;
        self
    }
    /// <p>Specifies the default recording frequency for the configuration recorder. Config supports <i>Continuous recording</i> and <i>Daily recording</i>.</p>
    /// <ul>
    /// <li>
    /// <p>Continuous recording allows you to record configuration changes continuously whenever a change occurs.</p></li>
    /// <li>
    /// <p>Daily recording allows you to receive a configuration item (CI) representing the most recent state of your resources over the last 24-hour period, only if it’s different from the previous CI recorded.</p></li>
    /// </ul><note>
    /// <p><b>Some resource types require continuous recording</b></p>
    /// <p>Firewall Manager depends on continuous recording to monitor your resources. If you are using Firewall Manager, it is recommended that you set the recording frequency to Continuous.</p>
    /// </note>
    /// <p>You can also override the recording frequency for specific resource types.</p>
    pub fn get_recording_mode(&self) -> &::std::option::Option<crate::types::RecordingMode> {
        &self.recording_mode
    }
    /// <p>Specifies whether the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a> in scope for the specified configuration recorder are recorded for free (<code>INTERNAL</code>) or if it impacts the costs to your bill (<code>PAID</code>).</p>
    pub fn recording_scope(mut self, input: crate::types::RecordingScope) -> Self {
        self.recording_scope = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies whether the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a> in scope for the specified configuration recorder are recorded for free (<code>INTERNAL</code>) or if it impacts the costs to your bill (<code>PAID</code>).</p>
    pub fn set_recording_scope(mut self, input: ::std::option::Option<crate::types::RecordingScope>) -> Self {
        self.recording_scope = input;
        self
    }
    /// <p>Specifies whether the <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationItem.html">ConfigurationItems</a> in scope for the specified configuration recorder are recorded for free (<code>INTERNAL</code>) or if it impacts the costs to your bill (<code>PAID</code>).</p>
    pub fn get_recording_scope(&self) -> &::std::option::Option<crate::types::RecordingScope> {
        &self.recording_scope
    }
    /// <p>For service-linked configuration recorders, specifies the linked Amazon Web Services service for the configuration recorder.</p>
    pub fn service_principal(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.service_principal = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>For service-linked configuration recorders, specifies the linked Amazon Web Services service for the configuration recorder.</p>
    pub fn set_service_principal(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.service_principal = input;
        self
    }
    /// <p>For service-linked configuration recorders, specifies the linked Amazon Web Services service for the configuration recorder.</p>
    pub fn get_service_principal(&self) -> &::std::option::Option<::std::string::String> {
        &self.service_principal
    }
    /// Consumes the builder and constructs a [`ConfigurationRecorder`](crate::types::ConfigurationRecorder).
    pub fn build(self) -> crate::types::ConfigurationRecorder {
        crate::types::ConfigurationRecorder {
            arn: self.arn,
            name: self.name,
            role_arn: self.role_arn,
            recording_group: self.recording_group,
            recording_mode: self.recording_mode,
            recording_scope: self.recording_scope,
            service_principal: self.service_principal,
        }
    }
}
