// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A list that contains detailed configurations of a specified resource.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ConfigurationItem {
    /// <p>The version number of the resource configuration.</p>
    pub version: ::std::option::Option<::std::string::String>,
    /// <p>The 12-digit Amazon Web Services account ID associated with the resource.</p>
    pub account_id: ::std::option::Option<::std::string::String>,
    /// <p>The time when the recording of configuration changes was initiated for the resource.</p>
    pub configuration_item_capture_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>The configuration item status. Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>OK – The resource configuration has been updated</p></li>
    /// <li>
    /// <p>ResourceDiscovered – The resource was newly discovered</p></li>
    /// <li>
    /// <p>ResourceNotRecorded – The resource was discovered but its configuration was not recorded since the recorder doesn't record resources of this type</p></li>
    /// <li>
    /// <p>ResourceDeleted – The resource was deleted</p></li>
    /// <li>
    /// <p>ResourceDeletedNotRecorded – The resource was deleted but its configuration was not recorded since the recorder doesn't record resources of this type</p></li>
    /// </ul>
    pub configuration_item_status: ::std::option::Option<crate::types::ConfigurationItemStatus>,
    /// <p>An identifier that indicates the ordering of the configuration items of a resource.</p>
    pub configuration_state_id: ::std::option::Option<::std::string::String>,
    /// <p>Unique MD5 hash that represents the configuration item's state.</p>
    /// <p>You can use MD5 hash to compare the states of two or more configuration items that are associated with the same resource.</p>
    pub configuration_item_md5_hash: ::std::option::Option<::std::string::String>,
    /// <p>Amazon Resource Name (ARN) associated with the resource.</p>
    pub arn: ::std::option::Option<::std::string::String>,
    /// <p>The type of Amazon Web Services resource.</p>
    pub resource_type: ::std::option::Option<crate::types::ResourceType>,
    /// <p>The ID of the resource (for example, <code>sg-xxxxxx</code>).</p>
    pub resource_id: ::std::option::Option<::std::string::String>,
    /// <p>The custom name of the resource, if available.</p>
    pub resource_name: ::std::option::Option<::std::string::String>,
    /// <p>The region where the resource resides.</p>
    pub aws_region: ::std::option::Option<::std::string::String>,
    /// <p>The Availability Zone associated with the resource.</p>
    pub availability_zone: ::std::option::Option<::std::string::String>,
    /// <p>The time stamp when the resource was created.</p>
    pub resource_creation_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>A mapping of key value tags associated with the resource.</p>
    pub tags: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>,
    /// <p>A list of CloudTrail event IDs.</p>
    /// <p>A populated field indicates that the current configuration was initiated by the events recorded in the CloudTrail log. For more information about CloudTrail, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html">What Is CloudTrail</a>.</p>
    /// <p>An empty field indicates that the current configuration was not initiated by any event. As of Version 1.3, the relatedEvents field is empty. You can access the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_LookupEvents.html">LookupEvents API</a> in the <i>CloudTrail API Reference</i> to retrieve the events for the resource.</p>
    pub related_events: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    /// <p>A list of related Amazon Web Services resources.</p>
    pub relationships: ::std::option::Option<::std::vec::Vec<crate::types::Relationship>>,
    /// <p>The description of the resource configuration.</p>
    pub configuration: ::std::option::Option<::std::string::String>,
    /// <p>Configuration attributes that Config returns for certain resource types to supplement the information returned for the <code>configuration</code> parameter.</p>
    pub supplementary_configuration: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>,
    /// <p>The recording frequency that Config uses to record configuration changes for the resource.</p>
    pub recording_frequency: ::std::option::Option<crate::types::RecordingFrequency>,
    /// <p>The time when configuration changes for the resource were delivered.</p><note>
    /// <p>This field is optional and is not guaranteed to be present in a configuration item (CI). If you are using daily recording, this field will be populated. However, if you are using continuous recording, this field will be omitted since the delivery time is instantaneous as the CI is available right away. For more information on daily recording and continuous recording, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html#select-resources-recording-frequency">Recording Frequency</a> in the <i>Config Developer Guide</i>.</p>
    /// </note>
    pub configuration_item_delivery_time: ::std::option::Option<::aws_smithy_types::DateTime>,
}
impl ConfigurationItem {
    /// <p>The version number of the resource configuration.</p>
    pub fn version(&self) -> ::std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The 12-digit Amazon Web Services account ID associated with the resource.</p>
    pub fn account_id(&self) -> ::std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The time when the recording of configuration changes was initiated for the resource.</p>
    pub fn configuration_item_capture_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.configuration_item_capture_time.as_ref()
    }
    /// <p>The configuration item status. Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>OK – The resource configuration has been updated</p></li>
    /// <li>
    /// <p>ResourceDiscovered – The resource was newly discovered</p></li>
    /// <li>
    /// <p>ResourceNotRecorded – The resource was discovered but its configuration was not recorded since the recorder doesn't record resources of this type</p></li>
    /// <li>
    /// <p>ResourceDeleted – The resource was deleted</p></li>
    /// <li>
    /// <p>ResourceDeletedNotRecorded – The resource was deleted but its configuration was not recorded since the recorder doesn't record resources of this type</p></li>
    /// </ul>
    pub fn configuration_item_status(&self) -> ::std::option::Option<&crate::types::ConfigurationItemStatus> {
        self.configuration_item_status.as_ref()
    }
    /// <p>An identifier that indicates the ordering of the configuration items of a resource.</p>
    pub fn configuration_state_id(&self) -> ::std::option::Option<&str> {
        self.configuration_state_id.as_deref()
    }
    /// <p>Unique MD5 hash that represents the configuration item's state.</p>
    /// <p>You can use MD5 hash to compare the states of two or more configuration items that are associated with the same resource.</p>
    pub fn configuration_item_md5_hash(&self) -> ::std::option::Option<&str> {
        self.configuration_item_md5_hash.as_deref()
    }
    /// <p>Amazon Resource Name (ARN) associated with the resource.</p>
    pub fn arn(&self) -> ::std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The type of Amazon Web Services resource.</p>
    pub fn resource_type(&self) -> ::std::option::Option<&crate::types::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The ID of the resource (for example, <code>sg-xxxxxx</code>).</p>
    pub fn resource_id(&self) -> ::std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The custom name of the resource, if available.</p>
    pub fn resource_name(&self) -> ::std::option::Option<&str> {
        self.resource_name.as_deref()
    }
    /// <p>The region where the resource resides.</p>
    pub fn aws_region(&self) -> ::std::option::Option<&str> {
        self.aws_region.as_deref()
    }
    /// <p>The Availability Zone associated with the resource.</p>
    pub fn availability_zone(&self) -> ::std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The time stamp when the resource was created.</p>
    pub fn resource_creation_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.resource_creation_time.as_ref()
    }
    /// <p>A mapping of key value tags associated with the resource.</p>
    pub fn tags(&self) -> ::std::option::Option<&::std::collections::HashMap<::std::string::String, ::std::string::String>> {
        self.tags.as_ref()
    }
    /// <p>A list of CloudTrail event IDs.</p>
    /// <p>A populated field indicates that the current configuration was initiated by the events recorded in the CloudTrail log. For more information about CloudTrail, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html">What Is CloudTrail</a>.</p>
    /// <p>An empty field indicates that the current configuration was not initiated by any event. As of Version 1.3, the relatedEvents field is empty. You can access the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_LookupEvents.html">LookupEvents API</a> in the <i>CloudTrail API Reference</i> to retrieve the events for the resource.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.related_events.is_none()`.
    pub fn related_events(&self) -> &[::std::string::String] {
        self.related_events.as_deref().unwrap_or_default()
    }
    /// <p>A list of related Amazon Web Services resources.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.relationships.is_none()`.
    pub fn relationships(&self) -> &[crate::types::Relationship] {
        self.relationships.as_deref().unwrap_or_default()
    }
    /// <p>The description of the resource configuration.</p>
    pub fn configuration(&self) -> ::std::option::Option<&str> {
        self.configuration.as_deref()
    }
    /// <p>Configuration attributes that Config returns for certain resource types to supplement the information returned for the <code>configuration</code> parameter.</p>
    pub fn supplementary_configuration(&self) -> ::std::option::Option<&::std::collections::HashMap<::std::string::String, ::std::string::String>> {
        self.supplementary_configuration.as_ref()
    }
    /// <p>The recording frequency that Config uses to record configuration changes for the resource.</p>
    pub fn recording_frequency(&self) -> ::std::option::Option<&crate::types::RecordingFrequency> {
        self.recording_frequency.as_ref()
    }
    /// <p>The time when configuration changes for the resource were delivered.</p><note>
    /// <p>This field is optional and is not guaranteed to be present in a configuration item (CI). If you are using daily recording, this field will be populated. However, if you are using continuous recording, this field will be omitted since the delivery time is instantaneous as the CI is available right away. For more information on daily recording and continuous recording, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html#select-resources-recording-frequency">Recording Frequency</a> in the <i>Config Developer Guide</i>.</p>
    /// </note>
    pub fn configuration_item_delivery_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.configuration_item_delivery_time.as_ref()
    }
}
impl ConfigurationItem {
    /// Creates a new builder-style object to manufacture [`ConfigurationItem`](crate::types::ConfigurationItem).
    pub fn builder() -> crate::types::builders::ConfigurationItemBuilder {
        crate::types::builders::ConfigurationItemBuilder::default()
    }
}

/// A builder for [`ConfigurationItem`](crate::types::ConfigurationItem).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ConfigurationItemBuilder {
    pub(crate) version: ::std::option::Option<::std::string::String>,
    pub(crate) account_id: ::std::option::Option<::std::string::String>,
    pub(crate) configuration_item_capture_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) configuration_item_status: ::std::option::Option<crate::types::ConfigurationItemStatus>,
    pub(crate) configuration_state_id: ::std::option::Option<::std::string::String>,
    pub(crate) configuration_item_md5_hash: ::std::option::Option<::std::string::String>,
    pub(crate) arn: ::std::option::Option<::std::string::String>,
    pub(crate) resource_type: ::std::option::Option<crate::types::ResourceType>,
    pub(crate) resource_id: ::std::option::Option<::std::string::String>,
    pub(crate) resource_name: ::std::option::Option<::std::string::String>,
    pub(crate) aws_region: ::std::option::Option<::std::string::String>,
    pub(crate) availability_zone: ::std::option::Option<::std::string::String>,
    pub(crate) resource_creation_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) tags: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>,
    pub(crate) related_events: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    pub(crate) relationships: ::std::option::Option<::std::vec::Vec<crate::types::Relationship>>,
    pub(crate) configuration: ::std::option::Option<::std::string::String>,
    pub(crate) supplementary_configuration: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>,
    pub(crate) recording_frequency: ::std::option::Option<crate::types::RecordingFrequency>,
    pub(crate) configuration_item_delivery_time: ::std::option::Option<::aws_smithy_types::DateTime>,
}
impl ConfigurationItemBuilder {
    /// <p>The version number of the resource configuration.</p>
    pub fn version(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.version = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The version number of the resource configuration.</p>
    pub fn set_version(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.version = input;
        self
    }
    /// <p>The version number of the resource configuration.</p>
    pub fn get_version(&self) -> &::std::option::Option<::std::string::String> {
        &self.version
    }
    /// <p>The 12-digit Amazon Web Services account ID associated with the resource.</p>
    pub fn account_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.account_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The 12-digit Amazon Web Services account ID associated with the resource.</p>
    pub fn set_account_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.account_id = input;
        self
    }
    /// <p>The 12-digit Amazon Web Services account ID associated with the resource.</p>
    pub fn get_account_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.account_id
    }
    /// <p>The time when the recording of configuration changes was initiated for the resource.</p>
    pub fn configuration_item_capture_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.configuration_item_capture_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time when the recording of configuration changes was initiated for the resource.</p>
    pub fn set_configuration_item_capture_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.configuration_item_capture_time = input;
        self
    }
    /// <p>The time when the recording of configuration changes was initiated for the resource.</p>
    pub fn get_configuration_item_capture_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.configuration_item_capture_time
    }
    /// <p>The configuration item status. Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>OK – The resource configuration has been updated</p></li>
    /// <li>
    /// <p>ResourceDiscovered – The resource was newly discovered</p></li>
    /// <li>
    /// <p>ResourceNotRecorded – The resource was discovered but its configuration was not recorded since the recorder doesn't record resources of this type</p></li>
    /// <li>
    /// <p>ResourceDeleted – The resource was deleted</p></li>
    /// <li>
    /// <p>ResourceDeletedNotRecorded – The resource was deleted but its configuration was not recorded since the recorder doesn't record resources of this type</p></li>
    /// </ul>
    pub fn configuration_item_status(mut self, input: crate::types::ConfigurationItemStatus) -> Self {
        self.configuration_item_status = ::std::option::Option::Some(input);
        self
    }
    /// <p>The configuration item status. Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>OK – The resource configuration has been updated</p></li>
    /// <li>
    /// <p>ResourceDiscovered – The resource was newly discovered</p></li>
    /// <li>
    /// <p>ResourceNotRecorded – The resource was discovered but its configuration was not recorded since the recorder doesn't record resources of this type</p></li>
    /// <li>
    /// <p>ResourceDeleted – The resource was deleted</p></li>
    /// <li>
    /// <p>ResourceDeletedNotRecorded – The resource was deleted but its configuration was not recorded since the recorder doesn't record resources of this type</p></li>
    /// </ul>
    pub fn set_configuration_item_status(mut self, input: ::std::option::Option<crate::types::ConfigurationItemStatus>) -> Self {
        self.configuration_item_status = input;
        self
    }
    /// <p>The configuration item status. Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>OK – The resource configuration has been updated</p></li>
    /// <li>
    /// <p>ResourceDiscovered – The resource was newly discovered</p></li>
    /// <li>
    /// <p>ResourceNotRecorded – The resource was discovered but its configuration was not recorded since the recorder doesn't record resources of this type</p></li>
    /// <li>
    /// <p>ResourceDeleted – The resource was deleted</p></li>
    /// <li>
    /// <p>ResourceDeletedNotRecorded – The resource was deleted but its configuration was not recorded since the recorder doesn't record resources of this type</p></li>
    /// </ul>
    pub fn get_configuration_item_status(&self) -> &::std::option::Option<crate::types::ConfigurationItemStatus> {
        &self.configuration_item_status
    }
    /// <p>An identifier that indicates the ordering of the configuration items of a resource.</p>
    pub fn configuration_state_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.configuration_state_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>An identifier that indicates the ordering of the configuration items of a resource.</p>
    pub fn set_configuration_state_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.configuration_state_id = input;
        self
    }
    /// <p>An identifier that indicates the ordering of the configuration items of a resource.</p>
    pub fn get_configuration_state_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.configuration_state_id
    }
    /// <p>Unique MD5 hash that represents the configuration item's state.</p>
    /// <p>You can use MD5 hash to compare the states of two or more configuration items that are associated with the same resource.</p>
    pub fn configuration_item_md5_hash(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.configuration_item_md5_hash = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Unique MD5 hash that represents the configuration item's state.</p>
    /// <p>You can use MD5 hash to compare the states of two or more configuration items that are associated with the same resource.</p>
    pub fn set_configuration_item_md5_hash(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.configuration_item_md5_hash = input;
        self
    }
    /// <p>Unique MD5 hash that represents the configuration item's state.</p>
    /// <p>You can use MD5 hash to compare the states of two or more configuration items that are associated with the same resource.</p>
    pub fn get_configuration_item_md5_hash(&self) -> &::std::option::Option<::std::string::String> {
        &self.configuration_item_md5_hash
    }
    /// <p>Amazon Resource Name (ARN) associated with the resource.</p>
    pub fn arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Amazon Resource Name (ARN) associated with the resource.</p>
    pub fn set_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.arn = input;
        self
    }
    /// <p>Amazon Resource Name (ARN) associated with the resource.</p>
    pub fn get_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.arn
    }
    /// <p>The type of Amazon Web Services resource.</p>
    pub fn resource_type(mut self, input: crate::types::ResourceType) -> Self {
        self.resource_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The type of Amazon Web Services resource.</p>
    pub fn set_resource_type(mut self, input: ::std::option::Option<crate::types::ResourceType>) -> Self {
        self.resource_type = input;
        self
    }
    /// <p>The type of Amazon Web Services resource.</p>
    pub fn get_resource_type(&self) -> &::std::option::Option<crate::types::ResourceType> {
        &self.resource_type
    }
    /// <p>The ID of the resource (for example, <code>sg-xxxxxx</code>).</p>
    pub fn resource_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.resource_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ID of the resource (for example, <code>sg-xxxxxx</code>).</p>
    pub fn set_resource_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.resource_id = input;
        self
    }
    /// <p>The ID of the resource (for example, <code>sg-xxxxxx</code>).</p>
    pub fn get_resource_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.resource_id
    }
    /// <p>The custom name of the resource, if available.</p>
    pub fn resource_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.resource_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The custom name of the resource, if available.</p>
    pub fn set_resource_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.resource_name = input;
        self
    }
    /// <p>The custom name of the resource, if available.</p>
    pub fn get_resource_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.resource_name
    }
    /// <p>The region where the resource resides.</p>
    pub fn aws_region(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.aws_region = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The region where the resource resides.</p>
    pub fn set_aws_region(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.aws_region = input;
        self
    }
    /// <p>The region where the resource resides.</p>
    pub fn get_aws_region(&self) -> &::std::option::Option<::std::string::String> {
        &self.aws_region
    }
    /// <p>The Availability Zone associated with the resource.</p>
    pub fn availability_zone(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.availability_zone = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Availability Zone associated with the resource.</p>
    pub fn set_availability_zone(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.availability_zone = input;
        self
    }
    /// <p>The Availability Zone associated with the resource.</p>
    pub fn get_availability_zone(&self) -> &::std::option::Option<::std::string::String> {
        &self.availability_zone
    }
    /// <p>The time stamp when the resource was created.</p>
    pub fn resource_creation_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.resource_creation_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time stamp when the resource was created.</p>
    pub fn set_resource_creation_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.resource_creation_time = input;
        self
    }
    /// <p>The time stamp when the resource was created.</p>
    pub fn get_resource_creation_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.resource_creation_time
    }
    /// Adds a key-value pair to `tags`.
    ///
    /// To override the contents of this collection use [`set_tags`](Self::set_tags).
    ///
    /// <p>A mapping of key value tags associated with the resource.</p>
    pub fn tags(mut self, k: impl ::std::convert::Into<::std::string::String>, v: impl ::std::convert::Into<::std::string::String>) -> Self {
        let mut hash_map = self.tags.unwrap_or_default();
        hash_map.insert(k.into(), v.into());
        self.tags = ::std::option::Option::Some(hash_map);
        self
    }
    /// <p>A mapping of key value tags associated with the resource.</p>
    pub fn set_tags(mut self, input: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>) -> Self {
        self.tags = input;
        self
    }
    /// <p>A mapping of key value tags associated with the resource.</p>
    pub fn get_tags(&self) -> &::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>> {
        &self.tags
    }
    /// Appends an item to `related_events`.
    ///
    /// To override the contents of this collection use [`set_related_events`](Self::set_related_events).
    ///
    /// <p>A list of CloudTrail event IDs.</p>
    /// <p>A populated field indicates that the current configuration was initiated by the events recorded in the CloudTrail log. For more information about CloudTrail, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html">What Is CloudTrail</a>.</p>
    /// <p>An empty field indicates that the current configuration was not initiated by any event. As of Version 1.3, the relatedEvents field is empty. You can access the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_LookupEvents.html">LookupEvents API</a> in the <i>CloudTrail API Reference</i> to retrieve the events for the resource.</p>
    pub fn related_events(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        let mut v = self.related_events.unwrap_or_default();
        v.push(input.into());
        self.related_events = ::std::option::Option::Some(v);
        self
    }
    /// <p>A list of CloudTrail event IDs.</p>
    /// <p>A populated field indicates that the current configuration was initiated by the events recorded in the CloudTrail log. For more information about CloudTrail, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html">What Is CloudTrail</a>.</p>
    /// <p>An empty field indicates that the current configuration was not initiated by any event. As of Version 1.3, the relatedEvents field is empty. You can access the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_LookupEvents.html">LookupEvents API</a> in the <i>CloudTrail API Reference</i> to retrieve the events for the resource.</p>
    pub fn set_related_events(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.related_events = input;
        self
    }
    /// <p>A list of CloudTrail event IDs.</p>
    /// <p>A populated field indicates that the current configuration was initiated by the events recorded in the CloudTrail log. For more information about CloudTrail, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html">What Is CloudTrail</a>.</p>
    /// <p>An empty field indicates that the current configuration was not initiated by any event. As of Version 1.3, the relatedEvents field is empty. You can access the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_LookupEvents.html">LookupEvents API</a> in the <i>CloudTrail API Reference</i> to retrieve the events for the resource.</p>
    pub fn get_related_events(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        &self.related_events
    }
    /// Appends an item to `relationships`.
    ///
    /// To override the contents of this collection use [`set_relationships`](Self::set_relationships).
    ///
    /// <p>A list of related Amazon Web Services resources.</p>
    pub fn relationships(mut self, input: crate::types::Relationship) -> Self {
        let mut v = self.relationships.unwrap_or_default();
        v.push(input);
        self.relationships = ::std::option::Option::Some(v);
        self
    }
    /// <p>A list of related Amazon Web Services resources.</p>
    pub fn set_relationships(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::Relationship>>) -> Self {
        self.relationships = input;
        self
    }
    /// <p>A list of related Amazon Web Services resources.</p>
    pub fn get_relationships(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::Relationship>> {
        &self.relationships
    }
    /// <p>The description of the resource configuration.</p>
    pub fn configuration(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.configuration = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The description of the resource configuration.</p>
    pub fn set_configuration(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.configuration = input;
        self
    }
    /// <p>The description of the resource configuration.</p>
    pub fn get_configuration(&self) -> &::std::option::Option<::std::string::String> {
        &self.configuration
    }
    /// Adds a key-value pair to `supplementary_configuration`.
    ///
    /// To override the contents of this collection use [`set_supplementary_configuration`](Self::set_supplementary_configuration).
    ///
    /// <p>Configuration attributes that Config returns for certain resource types to supplement the information returned for the <code>configuration</code> parameter.</p>
    pub fn supplementary_configuration(
        mut self,
        k: impl ::std::convert::Into<::std::string::String>,
        v: impl ::std::convert::Into<::std::string::String>,
    ) -> Self {
        let mut hash_map = self.supplementary_configuration.unwrap_or_default();
        hash_map.insert(k.into(), v.into());
        self.supplementary_configuration = ::std::option::Option::Some(hash_map);
        self
    }
    /// <p>Configuration attributes that Config returns for certain resource types to supplement the information returned for the <code>configuration</code> parameter.</p>
    pub fn set_supplementary_configuration(
        mut self,
        input: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>,
    ) -> Self {
        self.supplementary_configuration = input;
        self
    }
    /// <p>Configuration attributes that Config returns for certain resource types to supplement the information returned for the <code>configuration</code> parameter.</p>
    pub fn get_supplementary_configuration(
        &self,
    ) -> &::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>> {
        &self.supplementary_configuration
    }
    /// <p>The recording frequency that Config uses to record configuration changes for the resource.</p>
    pub fn recording_frequency(mut self, input: crate::types::RecordingFrequency) -> Self {
        self.recording_frequency = ::std::option::Option::Some(input);
        self
    }
    /// <p>The recording frequency that Config uses to record configuration changes for the resource.</p>
    pub fn set_recording_frequency(mut self, input: ::std::option::Option<crate::types::RecordingFrequency>) -> Self {
        self.recording_frequency = input;
        self
    }
    /// <p>The recording frequency that Config uses to record configuration changes for the resource.</p>
    pub fn get_recording_frequency(&self) -> &::std::option::Option<crate::types::RecordingFrequency> {
        &self.recording_frequency
    }
    /// <p>The time when configuration changes for the resource were delivered.</p><note>
    /// <p>This field is optional and is not guaranteed to be present in a configuration item (CI). If you are using daily recording, this field will be populated. However, if you are using continuous recording, this field will be omitted since the delivery time is instantaneous as the CI is available right away. For more information on daily recording and continuous recording, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html#select-resources-recording-frequency">Recording Frequency</a> in the <i>Config Developer Guide</i>.</p>
    /// </note>
    pub fn configuration_item_delivery_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.configuration_item_delivery_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time when configuration changes for the resource were delivered.</p><note>
    /// <p>This field is optional and is not guaranteed to be present in a configuration item (CI). If you are using daily recording, this field will be populated. However, if you are using continuous recording, this field will be omitted since the delivery time is instantaneous as the CI is available right away. For more information on daily recording and continuous recording, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html#select-resources-recording-frequency">Recording Frequency</a> in the <i>Config Developer Guide</i>.</p>
    /// </note>
    pub fn set_configuration_item_delivery_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.configuration_item_delivery_time = input;
        self
    }
    /// <p>The time when configuration changes for the resource were delivered.</p><note>
    /// <p>This field is optional and is not guaranteed to be present in a configuration item (CI). If you are using daily recording, this field will be populated. However, if you are using continuous recording, this field will be omitted since the delivery time is instantaneous as the CI is available right away. For more information on daily recording and continuous recording, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html#select-resources-recording-frequency">Recording Frequency</a> in the <i>Config Developer Guide</i>.</p>
    /// </note>
    pub fn get_configuration_item_delivery_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.configuration_item_delivery_time
    }
    /// Consumes the builder and constructs a [`ConfigurationItem`](crate::types::ConfigurationItem).
    pub fn build(self) -> crate::types::ConfigurationItem {
        crate::types::ConfigurationItem {
            version: self.version,
            account_id: self.account_id,
            configuration_item_capture_time: self.configuration_item_capture_time,
            configuration_item_status: self.configuration_item_status,
            configuration_state_id: self.configuration_state_id,
            configuration_item_md5_hash: self.configuration_item_md5_hash,
            arn: self.arn,
            resource_type: self.resource_type,
            resource_id: self.resource_id,
            resource_name: self.resource_name,
            aws_region: self.aws_region,
            availability_zone: self.availability_zone,
            resource_creation_time: self.resource_creation_time,
            tags: self.tags,
            related_events: self.related_events,
            relationships: self.relationships,
            configuration: self.configuration,
            supplementary_configuration: self.supplementary_configuration,
            recording_frequency: self.recording_frequency,
            configuration_item_delivery_time: self.configuration_item_delivery_time,
        }
    }
}
