// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The details about the configuration aggregator, including information about source accounts, regions, and metadata of the aggregator.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ConfigurationAggregator {
    /// <p>The name of the aggregator.</p>
    pub configuration_aggregator_name: ::std::option::Option<::std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the aggregator.</p>
    pub configuration_aggregator_arn: ::std::option::Option<::std::string::String>,
    /// <p>Provides a list of source accounts and regions to be aggregated.</p>
    pub account_aggregation_sources: ::std::option::Option<::std::vec::Vec<crate::types::AccountAggregationSource>>,
    /// <p>Provides an organization and list of regions to be aggregated.</p>
    pub organization_aggregation_source: ::std::option::Option<crate::types::OrganizationAggregationSource>,
    /// <p>The time stamp when the configuration aggregator was created.</p>
    pub creation_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>The time of the last update.</p>
    pub last_updated_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>Amazon Web Services service that created the configuration aggregator.</p>
    pub created_by: ::std::option::Option<::std::string::String>,
    /// <p>An object to filter the data you specify for an aggregator.</p>
    pub aggregator_filters: ::std::option::Option<crate::types::AggregatorFilters>,
}
impl ConfigurationAggregator {
    /// <p>The name of the aggregator.</p>
    pub fn configuration_aggregator_name(&self) -> ::std::option::Option<&str> {
        self.configuration_aggregator_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the aggregator.</p>
    pub fn configuration_aggregator_arn(&self) -> ::std::option::Option<&str> {
        self.configuration_aggregator_arn.as_deref()
    }
    /// <p>Provides a list of source accounts and regions to be aggregated.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.account_aggregation_sources.is_none()`.
    pub fn account_aggregation_sources(&self) -> &[crate::types::AccountAggregationSource] {
        self.account_aggregation_sources.as_deref().unwrap_or_default()
    }
    /// <p>Provides an organization and list of regions to be aggregated.</p>
    pub fn organization_aggregation_source(&self) -> ::std::option::Option<&crate::types::OrganizationAggregationSource> {
        self.organization_aggregation_source.as_ref()
    }
    /// <p>The time stamp when the configuration aggregator was created.</p>
    pub fn creation_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The time of the last update.</p>
    pub fn last_updated_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.last_updated_time.as_ref()
    }
    /// <p>Amazon Web Services service that created the configuration aggregator.</p>
    pub fn created_by(&self) -> ::std::option::Option<&str> {
        self.created_by.as_deref()
    }
    /// <p>An object to filter the data you specify for an aggregator.</p>
    pub fn aggregator_filters(&self) -> ::std::option::Option<&crate::types::AggregatorFilters> {
        self.aggregator_filters.as_ref()
    }
}
impl ConfigurationAggregator {
    /// Creates a new builder-style object to manufacture [`ConfigurationAggregator`](crate::types::ConfigurationAggregator).
    pub fn builder() -> crate::types::builders::ConfigurationAggregatorBuilder {
        crate::types::builders::ConfigurationAggregatorBuilder::default()
    }
}

/// A builder for [`ConfigurationAggregator`](crate::types::ConfigurationAggregator).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ConfigurationAggregatorBuilder {
    pub(crate) configuration_aggregator_name: ::std::option::Option<::std::string::String>,
    pub(crate) configuration_aggregator_arn: ::std::option::Option<::std::string::String>,
    pub(crate) account_aggregation_sources: ::std::option::Option<::std::vec::Vec<crate::types::AccountAggregationSource>>,
    pub(crate) organization_aggregation_source: ::std::option::Option<crate::types::OrganizationAggregationSource>,
    pub(crate) creation_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) last_updated_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) created_by: ::std::option::Option<::std::string::String>,
    pub(crate) aggregator_filters: ::std::option::Option<crate::types::AggregatorFilters>,
}
impl ConfigurationAggregatorBuilder {
    /// <p>The name of the aggregator.</p>
    pub fn configuration_aggregator_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.configuration_aggregator_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the aggregator.</p>
    pub fn set_configuration_aggregator_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.configuration_aggregator_name = input;
        self
    }
    /// <p>The name of the aggregator.</p>
    pub fn get_configuration_aggregator_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.configuration_aggregator_name
    }
    /// <p>The Amazon Resource Name (ARN) of the aggregator.</p>
    pub fn configuration_aggregator_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.configuration_aggregator_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the aggregator.</p>
    pub fn set_configuration_aggregator_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.configuration_aggregator_arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the aggregator.</p>
    pub fn get_configuration_aggregator_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.configuration_aggregator_arn
    }
    /// Appends an item to `account_aggregation_sources`.
    ///
    /// To override the contents of this collection use [`set_account_aggregation_sources`](Self::set_account_aggregation_sources).
    ///
    /// <p>Provides a list of source accounts and regions to be aggregated.</p>
    pub fn account_aggregation_sources(mut self, input: crate::types::AccountAggregationSource) -> Self {
        let mut v = self.account_aggregation_sources.unwrap_or_default();
        v.push(input);
        self.account_aggregation_sources = ::std::option::Option::Some(v);
        self
    }
    /// <p>Provides a list of source accounts and regions to be aggregated.</p>
    pub fn set_account_aggregation_sources(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::AccountAggregationSource>>) -> Self {
        self.account_aggregation_sources = input;
        self
    }
    /// <p>Provides a list of source accounts and regions to be aggregated.</p>
    pub fn get_account_aggregation_sources(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::AccountAggregationSource>> {
        &self.account_aggregation_sources
    }
    /// <p>Provides an organization and list of regions to be aggregated.</p>
    pub fn organization_aggregation_source(mut self, input: crate::types::OrganizationAggregationSource) -> Self {
        self.organization_aggregation_source = ::std::option::Option::Some(input);
        self
    }
    /// <p>Provides an organization and list of regions to be aggregated.</p>
    pub fn set_organization_aggregation_source(mut self, input: ::std::option::Option<crate::types::OrganizationAggregationSource>) -> Self {
        self.organization_aggregation_source = input;
        self
    }
    /// <p>Provides an organization and list of regions to be aggregated.</p>
    pub fn get_organization_aggregation_source(&self) -> &::std::option::Option<crate::types::OrganizationAggregationSource> {
        &self.organization_aggregation_source
    }
    /// <p>The time stamp when the configuration aggregator was created.</p>
    pub fn creation_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.creation_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time stamp when the configuration aggregator was created.</p>
    pub fn set_creation_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.creation_time = input;
        self
    }
    /// <p>The time stamp when the configuration aggregator was created.</p>
    pub fn get_creation_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.creation_time
    }
    /// <p>The time of the last update.</p>
    pub fn last_updated_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.last_updated_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time of the last update.</p>
    pub fn set_last_updated_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.last_updated_time = input;
        self
    }
    /// <p>The time of the last update.</p>
    pub fn get_last_updated_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.last_updated_time
    }
    /// <p>Amazon Web Services service that created the configuration aggregator.</p>
    pub fn created_by(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.created_by = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Amazon Web Services service that created the configuration aggregator.</p>
    pub fn set_created_by(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.created_by = input;
        self
    }
    /// <p>Amazon Web Services service that created the configuration aggregator.</p>
    pub fn get_created_by(&self) -> &::std::option::Option<::std::string::String> {
        &self.created_by
    }
    /// <p>An object to filter the data you specify for an aggregator.</p>
    pub fn aggregator_filters(mut self, input: crate::types::AggregatorFilters) -> Self {
        self.aggregator_filters = ::std::option::Option::Some(input);
        self
    }
    /// <p>An object to filter the data you specify for an aggregator.</p>
    pub fn set_aggregator_filters(mut self, input: ::std::option::Option<crate::types::AggregatorFilters>) -> Self {
        self.aggregator_filters = input;
        self
    }
    /// <p>An object to filter the data you specify for an aggregator.</p>
    pub fn get_aggregator_filters(&self) -> &::std::option::Option<crate::types::AggregatorFilters> {
        &self.aggregator_filters
    }
    /// Consumes the builder and constructs a [`ConfigurationAggregator`](crate::types::ConfigurationAggregator).
    pub fn build(self) -> crate::types::ConfigurationAggregator {
        crate::types::ConfigurationAggregator {
            configuration_aggregator_name: self.configuration_aggregator_name,
            configuration_aggregator_arn: self.configuration_aggregator_arn,
            account_aggregation_sources: self.account_aggregation_sources,
            organization_aggregation_source: self.organization_aggregation_source,
            creation_time: self.creation_time,
            last_updated_time: self.last_updated_time,
            created_by: self.created_by,
            aggregator_filters: self.aggregator_filters,
        }
    }
}
