// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Indicates whether an Amazon Web Services resource that is evaluated according to one or more Config rules is compliant. A resource is compliant if it complies with all of the rules that evaluate it. A resource is noncompliant if it does not comply with one or more of these rules.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ComplianceByResource {
    /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
    pub resource_type: ::std::option::Option<::std::string::String>,
    /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
    pub resource_id: ::std::option::Option<::std::string::String>,
    /// <p>Indicates whether the Amazon Web Services resource complies with all of the Config rules that evaluated it.</p>
    pub compliance: ::std::option::Option<crate::types::Compliance>,
}
impl ComplianceByResource {
    /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
    pub fn resource_type(&self) -> ::std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
    pub fn resource_id(&self) -> ::std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Indicates whether the Amazon Web Services resource complies with all of the Config rules that evaluated it.</p>
    pub fn compliance(&self) -> ::std::option::Option<&crate::types::Compliance> {
        self.compliance.as_ref()
    }
}
impl ComplianceByResource {
    /// Creates a new builder-style object to manufacture [`ComplianceByResource`](crate::types::ComplianceByResource).
    pub fn builder() -> crate::types::builders::ComplianceByResourceBuilder {
        crate::types::builders::ComplianceByResourceBuilder::default()
    }
}

/// A builder for [`ComplianceByResource`](crate::types::ComplianceByResource).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ComplianceByResourceBuilder {
    pub(crate) resource_type: ::std::option::Option<::std::string::String>,
    pub(crate) resource_id: ::std::option::Option<::std::string::String>,
    pub(crate) compliance: ::std::option::Option<crate::types::Compliance>,
}
impl ComplianceByResourceBuilder {
    /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
    pub fn resource_type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.resource_type = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
    pub fn set_resource_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.resource_type = input;
        self
    }
    /// <p>The type of the Amazon Web Services resource that was evaluated.</p>
    pub fn get_resource_type(&self) -> &::std::option::Option<::std::string::String> {
        &self.resource_type
    }
    /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
    pub fn resource_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.resource_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
    pub fn set_resource_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.resource_id = input;
        self
    }
    /// <p>The ID of the Amazon Web Services resource that was evaluated.</p>
    pub fn get_resource_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.resource_id
    }
    /// <p>Indicates whether the Amazon Web Services resource complies with all of the Config rules that evaluated it.</p>
    pub fn compliance(mut self, input: crate::types::Compliance) -> Self {
        self.compliance = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates whether the Amazon Web Services resource complies with all of the Config rules that evaluated it.</p>
    pub fn set_compliance(mut self, input: ::std::option::Option<crate::types::Compliance>) -> Self {
        self.compliance = input;
        self
    }
    /// <p>Indicates whether the Amazon Web Services resource complies with all of the Config rules that evaluated it.</p>
    pub fn get_compliance(&self) -> &::std::option::Option<crate::types::Compliance> {
        &self.compliance
    }
    /// Consumes the builder and constructs a [`ComplianceByResource`](crate::types::ComplianceByResource).
    pub fn build(self) -> crate::types::ComplianceByResource {
        crate::types::ComplianceByResource {
            resource_type: self.resource_type,
            resource_id: self.resource_id,
            compliance: self.compliance,
        }
    }
}
