// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Indicates whether an Config rule is compliant. A rule is compliant if all of the resources that the rule evaluated comply with it. A rule is noncompliant if any of these resources do not comply.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ComplianceByConfigRule {
    /// <p>The name of the Config rule.</p>
    pub config_rule_name: ::std::option::Option<::std::string::String>,
    /// <p>Indicates whether the Config rule is compliant.</p>
    pub compliance: ::std::option::Option<crate::types::Compliance>,
}
impl ComplianceByConfigRule {
    /// <p>The name of the Config rule.</p>
    pub fn config_rule_name(&self) -> ::std::option::Option<&str> {
        self.config_rule_name.as_deref()
    }
    /// <p>Indicates whether the Config rule is compliant.</p>
    pub fn compliance(&self) -> ::std::option::Option<&crate::types::Compliance> {
        self.compliance.as_ref()
    }
}
impl ComplianceByConfigRule {
    /// Creates a new builder-style object to manufacture [`ComplianceByConfigRule`](crate::types::ComplianceByConfigRule).
    pub fn builder() -> crate::types::builders::ComplianceByConfigRuleBuilder {
        crate::types::builders::ComplianceByConfigRuleBuilder::default()
    }
}

/// A builder for [`ComplianceByConfigRule`](crate::types::ComplianceByConfigRule).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ComplianceByConfigRuleBuilder {
    pub(crate) config_rule_name: ::std::option::Option<::std::string::String>,
    pub(crate) compliance: ::std::option::Option<crate::types::Compliance>,
}
impl ComplianceByConfigRuleBuilder {
    /// <p>The name of the Config rule.</p>
    pub fn config_rule_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.config_rule_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the Config rule.</p>
    pub fn set_config_rule_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.config_rule_name = input;
        self
    }
    /// <p>The name of the Config rule.</p>
    pub fn get_config_rule_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.config_rule_name
    }
    /// <p>Indicates whether the Config rule is compliant.</p>
    pub fn compliance(mut self, input: crate::types::Compliance) -> Self {
        self.compliance = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates whether the Config rule is compliant.</p>
    pub fn set_compliance(mut self, input: ::std::option::Option<crate::types::Compliance>) -> Self {
        self.compliance = input;
        self
    }
    /// <p>Indicates whether the Config rule is compliant.</p>
    pub fn get_compliance(&self) -> &::std::option::Option<crate::types::Compliance> {
        &self.compliance
    }
    /// Consumes the builder and constructs a [`ComplianceByConfigRule`](crate::types::ComplianceByConfigRule).
    pub fn build(self) -> crate::types::ComplianceByConfigRule {
        crate::types::ComplianceByConfigRule {
            config_rule_name: self.config_rule_name,
            compliance: self.compliance,
        }
    }
}
