// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The current sync status between the source and the aggregator account.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct AggregatedSourceStatus {
    /// <p>The source account ID or an organization.</p>
    pub source_id: ::std::option::Option<::std::string::String>,
    /// <p>The source account or an organization.</p>
    pub source_type: ::std::option::Option<crate::types::AggregatedSourceType>,
    /// <p>The region authorized to collect aggregated data.</p>
    pub aws_region: ::std::option::Option<::std::string::String>,
    /// <p>Filters the last updated status type.</p>
    /// <ul>
    /// <li>
    /// <p>Valid value FAILED indicates errors while moving data.</p></li>
    /// <li>
    /// <p>Valid value SUCCEEDED indicates the data was successfully moved.</p></li>
    /// <li>
    /// <p>Valid value OUTDATED indicates the data is not the most recent.</p></li>
    /// </ul>
    pub last_update_status: ::std::option::Option<crate::types::AggregatedSourceStatusType>,
    /// <p>The time of the last update.</p>
    pub last_update_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>The error code that Config returned when the source account aggregation last failed.</p>
    pub last_error_code: ::std::option::Option<::std::string::String>,
    /// <p>The message indicating that the source account aggregation failed due to an error.</p>
    pub last_error_message: ::std::option::Option<::std::string::String>,
}
impl AggregatedSourceStatus {
    /// <p>The source account ID or an organization.</p>
    pub fn source_id(&self) -> ::std::option::Option<&str> {
        self.source_id.as_deref()
    }
    /// <p>The source account or an organization.</p>
    pub fn source_type(&self) -> ::std::option::Option<&crate::types::AggregatedSourceType> {
        self.source_type.as_ref()
    }
    /// <p>The region authorized to collect aggregated data.</p>
    pub fn aws_region(&self) -> ::std::option::Option<&str> {
        self.aws_region.as_deref()
    }
    /// <p>Filters the last updated status type.</p>
    /// <ul>
    /// <li>
    /// <p>Valid value FAILED indicates errors while moving data.</p></li>
    /// <li>
    /// <p>Valid value SUCCEEDED indicates the data was successfully moved.</p></li>
    /// <li>
    /// <p>Valid value OUTDATED indicates the data is not the most recent.</p></li>
    /// </ul>
    pub fn last_update_status(&self) -> ::std::option::Option<&crate::types::AggregatedSourceStatusType> {
        self.last_update_status.as_ref()
    }
    /// <p>The time of the last update.</p>
    pub fn last_update_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
    /// <p>The error code that Config returned when the source account aggregation last failed.</p>
    pub fn last_error_code(&self) -> ::std::option::Option<&str> {
        self.last_error_code.as_deref()
    }
    /// <p>The message indicating that the source account aggregation failed due to an error.</p>
    pub fn last_error_message(&self) -> ::std::option::Option<&str> {
        self.last_error_message.as_deref()
    }
}
impl AggregatedSourceStatus {
    /// Creates a new builder-style object to manufacture [`AggregatedSourceStatus`](crate::types::AggregatedSourceStatus).
    pub fn builder() -> crate::types::builders::AggregatedSourceStatusBuilder {
        crate::types::builders::AggregatedSourceStatusBuilder::default()
    }
}

/// A builder for [`AggregatedSourceStatus`](crate::types::AggregatedSourceStatus).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct AggregatedSourceStatusBuilder {
    pub(crate) source_id: ::std::option::Option<::std::string::String>,
    pub(crate) source_type: ::std::option::Option<crate::types::AggregatedSourceType>,
    pub(crate) aws_region: ::std::option::Option<::std::string::String>,
    pub(crate) last_update_status: ::std::option::Option<crate::types::AggregatedSourceStatusType>,
    pub(crate) last_update_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) last_error_code: ::std::option::Option<::std::string::String>,
    pub(crate) last_error_message: ::std::option::Option<::std::string::String>,
}
impl AggregatedSourceStatusBuilder {
    /// <p>The source account ID or an organization.</p>
    pub fn source_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.source_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The source account ID or an organization.</p>
    pub fn set_source_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.source_id = input;
        self
    }
    /// <p>The source account ID or an organization.</p>
    pub fn get_source_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.source_id
    }
    /// <p>The source account or an organization.</p>
    pub fn source_type(mut self, input: crate::types::AggregatedSourceType) -> Self {
        self.source_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The source account or an organization.</p>
    pub fn set_source_type(mut self, input: ::std::option::Option<crate::types::AggregatedSourceType>) -> Self {
        self.source_type = input;
        self
    }
    /// <p>The source account or an organization.</p>
    pub fn get_source_type(&self) -> &::std::option::Option<crate::types::AggregatedSourceType> {
        &self.source_type
    }
    /// <p>The region authorized to collect aggregated data.</p>
    pub fn aws_region(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.aws_region = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The region authorized to collect aggregated data.</p>
    pub fn set_aws_region(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.aws_region = input;
        self
    }
    /// <p>The region authorized to collect aggregated data.</p>
    pub fn get_aws_region(&self) -> &::std::option::Option<::std::string::String> {
        &self.aws_region
    }
    /// <p>Filters the last updated status type.</p>
    /// <ul>
    /// <li>
    /// <p>Valid value FAILED indicates errors while moving data.</p></li>
    /// <li>
    /// <p>Valid value SUCCEEDED indicates the data was successfully moved.</p></li>
    /// <li>
    /// <p>Valid value OUTDATED indicates the data is not the most recent.</p></li>
    /// </ul>
    pub fn last_update_status(mut self, input: crate::types::AggregatedSourceStatusType) -> Self {
        self.last_update_status = ::std::option::Option::Some(input);
        self
    }
    /// <p>Filters the last updated status type.</p>
    /// <ul>
    /// <li>
    /// <p>Valid value FAILED indicates errors while moving data.</p></li>
    /// <li>
    /// <p>Valid value SUCCEEDED indicates the data was successfully moved.</p></li>
    /// <li>
    /// <p>Valid value OUTDATED indicates the data is not the most recent.</p></li>
    /// </ul>
    pub fn set_last_update_status(mut self, input: ::std::option::Option<crate::types::AggregatedSourceStatusType>) -> Self {
        self.last_update_status = input;
        self
    }
    /// <p>Filters the last updated status type.</p>
    /// <ul>
    /// <li>
    /// <p>Valid value FAILED indicates errors while moving data.</p></li>
    /// <li>
    /// <p>Valid value SUCCEEDED indicates the data was successfully moved.</p></li>
    /// <li>
    /// <p>Valid value OUTDATED indicates the data is not the most recent.</p></li>
    /// </ul>
    pub fn get_last_update_status(&self) -> &::std::option::Option<crate::types::AggregatedSourceStatusType> {
        &self.last_update_status
    }
    /// <p>The time of the last update.</p>
    pub fn last_update_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.last_update_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time of the last update.</p>
    pub fn set_last_update_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.last_update_time = input;
        self
    }
    /// <p>The time of the last update.</p>
    pub fn get_last_update_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.last_update_time
    }
    /// <p>The error code that Config returned when the source account aggregation last failed.</p>
    pub fn last_error_code(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.last_error_code = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The error code that Config returned when the source account aggregation last failed.</p>
    pub fn set_last_error_code(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.last_error_code = input;
        self
    }
    /// <p>The error code that Config returned when the source account aggregation last failed.</p>
    pub fn get_last_error_code(&self) -> &::std::option::Option<::std::string::String> {
        &self.last_error_code
    }
    /// <p>The message indicating that the source account aggregation failed due to an error.</p>
    pub fn last_error_message(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.last_error_message = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The message indicating that the source account aggregation failed due to an error.</p>
    pub fn set_last_error_message(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.last_error_message = input;
        self
    }
    /// <p>The message indicating that the source account aggregation failed due to an error.</p>
    pub fn get_last_error_message(&self) -> &::std::option::Option<::std::string::String> {
        &self.last_error_message
    }
    /// Consumes the builder and constructs a [`AggregatedSourceStatus`](crate::types::AggregatedSourceStatus).
    pub fn build(self) -> crate::types::AggregatedSourceStatus {
        crate::types::AggregatedSourceStatus {
            source_id: self.source_id,
            source_type: self.source_type,
            aws_region: self.aws_region,
            last_update_status: self.last_update_status,
            last_update_time: self.last_update_time,
            last_error_code: self.last_error_code,
            last_error_message: self.last_error_message,
        }
    }
}
