// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::stop_configuration_recorder::_stop_configuration_recorder_output::StopConfigurationRecorderOutputBuilder;

pub use crate::operation::stop_configuration_recorder::_stop_configuration_recorder_input::StopConfigurationRecorderInputBuilder;

impl crate::operation::stop_configuration_recorder::builders::StopConfigurationRecorderInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::stop_configuration_recorder::StopConfigurationRecorderOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::stop_configuration_recorder::StopConfigurationRecorderError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.stop_configuration_recorder();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `StopConfigurationRecorder`.
///
/// <p>Stops the customer managed configuration recorder. The customer managed configuration recorder will stop recording configuration changes for the resource types you have specified.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct StopConfigurationRecorderFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::stop_configuration_recorder::builders::StopConfigurationRecorderInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::stop_configuration_recorder::StopConfigurationRecorderOutput,
        crate::operation::stop_configuration_recorder::StopConfigurationRecorderError,
    > for StopConfigurationRecorderFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::stop_configuration_recorder::StopConfigurationRecorderOutput,
            crate::operation::stop_configuration_recorder::StopConfigurationRecorderError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl StopConfigurationRecorderFluentBuilder {
    /// Creates a new `StopConfigurationRecorderFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the StopConfigurationRecorder as a reference.
    pub fn as_input(&self) -> &crate::operation::stop_configuration_recorder::builders::StopConfigurationRecorderInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::stop_configuration_recorder::StopConfigurationRecorderOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::stop_configuration_recorder::StopConfigurationRecorderError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::stop_configuration_recorder::StopConfigurationRecorder::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::stop_configuration_recorder::StopConfigurationRecorder::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::stop_configuration_recorder::StopConfigurationRecorderOutput,
        crate::operation::stop_configuration_recorder::StopConfigurationRecorderError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The name of the customer managed configuration recorder that you want to stop.</p>
    pub fn configuration_recorder_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.configuration_recorder_name(input.into());
        self
    }
    /// <p>The name of the customer managed configuration recorder that you want to stop.</p>
    pub fn set_configuration_recorder_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_configuration_recorder_name(input);
        self
    }
    /// <p>The name of the customer managed configuration recorder that you want to stop.</p>
    pub fn get_configuration_recorder_name(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_configuration_recorder_name()
    }
}
