// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::start_resource_evaluation::_start_resource_evaluation_output::StartResourceEvaluationOutputBuilder;

pub use crate::operation::start_resource_evaluation::_start_resource_evaluation_input::StartResourceEvaluationInputBuilder;

impl crate::operation::start_resource_evaluation::builders::StartResourceEvaluationInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::start_resource_evaluation::StartResourceEvaluationOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::start_resource_evaluation::StartResourceEvaluationError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.start_resource_evaluation();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `StartResourceEvaluation`.
///
/// <p>Runs an on-demand evaluation for the specified resource to determine whether the resource details will comply with configured Config rules. You can also use it for evaluation purposes. Config recommends using an evaluation context. It runs an execution against the resource details with all of the Config rules in your account that match with the specified proactive mode and resource type.</p><note>
/// <p>Ensure you have the <code>cloudformation:DescribeType</code> role setup to validate the resource type schema.</p>
/// <p>You can find the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">Resource type schema</a> in "<i>Amazon Web Services public extensions</i>" within the CloudFormation registry or with the following CLI commmand: <code>aws cloudformation describe-type --type-name "AWS::S3::Bucket" --type RESOURCE</code>.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry.html#registry-view">Managing extensions through the CloudFormation registry</a> and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and property types reference</a> in the CloudFormation User Guide.</p>
/// </note>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct StartResourceEvaluationFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::start_resource_evaluation::builders::StartResourceEvaluationInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::start_resource_evaluation::StartResourceEvaluationOutput,
        crate::operation::start_resource_evaluation::StartResourceEvaluationError,
    > for StartResourceEvaluationFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::start_resource_evaluation::StartResourceEvaluationOutput,
            crate::operation::start_resource_evaluation::StartResourceEvaluationError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl StartResourceEvaluationFluentBuilder {
    /// Creates a new `StartResourceEvaluationFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the StartResourceEvaluation as a reference.
    pub fn as_input(&self) -> &crate::operation::start_resource_evaluation::builders::StartResourceEvaluationInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::start_resource_evaluation::StartResourceEvaluationOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::start_resource_evaluation::StartResourceEvaluationError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::start_resource_evaluation::StartResourceEvaluation::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::start_resource_evaluation::StartResourceEvaluation::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::start_resource_evaluation::StartResourceEvaluationOutput,
        crate::operation::start_resource_evaluation::StartResourceEvaluationError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>Returns a <code>ResourceDetails</code> object.</p>
    pub fn resource_details(mut self, input: crate::types::ResourceDetails) -> Self {
        self.inner = self.inner.resource_details(input);
        self
    }
    /// <p>Returns a <code>ResourceDetails</code> object.</p>
    pub fn set_resource_details(mut self, input: ::std::option::Option<crate::types::ResourceDetails>) -> Self {
        self.inner = self.inner.set_resource_details(input);
        self
    }
    /// <p>Returns a <code>ResourceDetails</code> object.</p>
    pub fn get_resource_details(&self) -> &::std::option::Option<crate::types::ResourceDetails> {
        self.inner.get_resource_details()
    }
    /// <p>Returns an <code>EvaluationContext</code> object.</p>
    pub fn evaluation_context(mut self, input: crate::types::EvaluationContext) -> Self {
        self.inner = self.inner.evaluation_context(input);
        self
    }
    /// <p>Returns an <code>EvaluationContext</code> object.</p>
    pub fn set_evaluation_context(mut self, input: ::std::option::Option<crate::types::EvaluationContext>) -> Self {
        self.inner = self.inner.set_evaluation_context(input);
        self
    }
    /// <p>Returns an <code>EvaluationContext</code> object.</p>
    pub fn get_evaluation_context(&self) -> &::std::option::Option<crate::types::EvaluationContext> {
        self.inner.get_evaluation_context()
    }
    /// <p>The mode of an evaluation. The valid values for this API are <code>DETECTIVE</code> and <code>PROACTIVE</code>.</p>
    pub fn evaluation_mode(mut self, input: crate::types::EvaluationMode) -> Self {
        self.inner = self.inner.evaluation_mode(input);
        self
    }
    /// <p>The mode of an evaluation. The valid values for this API are <code>DETECTIVE</code> and <code>PROACTIVE</code>.</p>
    pub fn set_evaluation_mode(mut self, input: ::std::option::Option<crate::types::EvaluationMode>) -> Self {
        self.inner = self.inner.set_evaluation_mode(input);
        self
    }
    /// <p>The mode of an evaluation. The valid values for this API are <code>DETECTIVE</code> and <code>PROACTIVE</code>.</p>
    pub fn get_evaluation_mode(&self) -> &::std::option::Option<crate::types::EvaluationMode> {
        self.inner.get_evaluation_mode()
    }
    /// <p>The timeout for an evaluation. The default is 900 seconds. You cannot specify a number greater than 3600. If you specify 0, Config uses the default.</p>
    pub fn evaluation_timeout(mut self, input: i32) -> Self {
        self.inner = self.inner.evaluation_timeout(input);
        self
    }
    /// <p>The timeout for an evaluation. The default is 900 seconds. You cannot specify a number greater than 3600. If you specify 0, Config uses the default.</p>
    pub fn set_evaluation_timeout(mut self, input: ::std::option::Option<i32>) -> Self {
        self.inner = self.inner.set_evaluation_timeout(input);
        self
    }
    /// <p>The timeout for an evaluation. The default is 900 seconds. You cannot specify a number greater than 3600. If you specify 0, Config uses the default.</p>
    pub fn get_evaluation_timeout(&self) -> &::std::option::Option<i32> {
        self.inner.get_evaluation_timeout()
    }
    /// <p>A client token is a unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request using one of these actions, specify a client token in the request.</p><note>
    /// <p>Avoid reusing the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, other than the Region or Availability Zone, the retry fails with an IdempotentParameterMismatch error.</p>
    /// </note>
    pub fn client_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.client_token(input.into());
        self
    }
    /// <p>A client token is a unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request using one of these actions, specify a client token in the request.</p><note>
    /// <p>Avoid reusing the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, other than the Region or Availability Zone, the retry fails with an IdempotentParameterMismatch error.</p>
    /// </note>
    pub fn set_client_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_client_token(input);
        self
    }
    /// <p>A client token is a unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request using one of these actions, specify a client token in the request.</p><note>
    /// <p>Avoid reusing the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, other than the Region or Availability Zone, the retry fails with an IdempotentParameterMismatch error.</p>
    /// </note>
    pub fn get_client_token(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_client_token()
    }
}
