// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::put_remediation_configurations::_put_remediation_configurations_output::PutRemediationConfigurationsOutputBuilder;

pub use crate::operation::put_remediation_configurations::_put_remediation_configurations_input::PutRemediationConfigurationsInputBuilder;

impl crate::operation::put_remediation_configurations::builders::PutRemediationConfigurationsInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::put_remediation_configurations::PutRemediationConfigurationsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_remediation_configurations::PutRemediationConfigurationsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.put_remediation_configurations();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `PutRemediationConfigurations`.
///
/// <p>Adds or updates the remediation configuration with a specific Config rule with the selected target or action. The API creates the <code>RemediationConfiguration</code> object for the Config rule. The Config rule must already exist for you to add a remediation configuration. The target (SSM document) must exist and have permissions to use the target.</p><note>
/// <p><b>Be aware of backward incompatible changes</b></p>
/// <p>If you make backward incompatible changes to the SSM document, you must call this again to ensure the remediations can run.</p>
/// <p>This API does not support adding remediation configurations for service-linked Config Rules such as Organization Config rules, the rules deployed by conformance packs, and rules deployed by Amazon Web Services Security Hub.</p>
/// </note> <note>
/// <p><b>Required fields</b></p>
/// <p>For manual remediation configuration, you need to provide a value for <code>automationAssumeRole</code> or use a value in the <code>assumeRole</code>field to remediate your resources. The SSM automation document can use either as long as it maps to a valid parameter.</p>
/// <p>However, for automatic remediation configuration, the only valid <code>assumeRole</code> field value is <code>AutomationAssumeRole</code> and you need to provide a value for <code>AutomationAssumeRole</code> to remediate your resources.</p>
/// </note> <note>
/// <p><b>Auto remediation can be initiated even for compliant resources</b></p>
/// <p>If you enable auto remediation for a specific Config rule using the <a href="https://docs.aws.amazon.com/config/latest/APIReference/emAPI_PutRemediationConfigurations.html">PutRemediationConfigurations</a> API or the Config console, it initiates the remediation process for all non-compliant resources for that specific rule. The auto remediation process relies on the compliance data snapshot which is captured on a periodic basis. Any non-compliant resource that is updated between the snapshot schedule will continue to be remediated based on the last known compliance data snapshot.</p>
/// <p>This means that in some cases auto remediation can be initiated even for compliant resources, since the bootstrap processor uses a database that can have stale evaluation results based on the last known compliance data snapshot.</p>
/// </note>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct PutRemediationConfigurationsFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::put_remediation_configurations::builders::PutRemediationConfigurationsInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::put_remediation_configurations::PutRemediationConfigurationsOutput,
        crate::operation::put_remediation_configurations::PutRemediationConfigurationsError,
    > for PutRemediationConfigurationsFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::put_remediation_configurations::PutRemediationConfigurationsOutput,
            crate::operation::put_remediation_configurations::PutRemediationConfigurationsError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl PutRemediationConfigurationsFluentBuilder {
    /// Creates a new `PutRemediationConfigurationsFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the PutRemediationConfigurations as a reference.
    pub fn as_input(&self) -> &crate::operation::put_remediation_configurations::builders::PutRemediationConfigurationsInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::put_remediation_configurations::PutRemediationConfigurationsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_remediation_configurations::PutRemediationConfigurationsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::put_remediation_configurations::PutRemediationConfigurations::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::put_remediation_configurations::PutRemediationConfigurations::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::put_remediation_configurations::PutRemediationConfigurationsOutput,
        crate::operation::put_remediation_configurations::PutRemediationConfigurationsError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    ///
    /// Appends an item to `RemediationConfigurations`.
    ///
    /// To override the contents of this collection use [`set_remediation_configurations`](Self::set_remediation_configurations).
    ///
    /// <p>A list of remediation configuration objects.</p>
    pub fn remediation_configurations(mut self, input: crate::types::RemediationConfiguration) -> Self {
        self.inner = self.inner.remediation_configurations(input);
        self
    }
    /// <p>A list of remediation configuration objects.</p>
    pub fn set_remediation_configurations(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::RemediationConfiguration>>) -> Self {
        self.inner = self.inner.set_remediation_configurations(input);
        self
    }
    /// <p>A list of remediation configuration objects.</p>
    pub fn get_remediation_configurations(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::RemediationConfiguration>> {
        self.inner.get_remediation_configurations()
    }
}
