// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::put_configuration_aggregator::_put_configuration_aggregator_output::PutConfigurationAggregatorOutputBuilder;

pub use crate::operation::put_configuration_aggregator::_put_configuration_aggregator_input::PutConfigurationAggregatorInputBuilder;

impl crate::operation::put_configuration_aggregator::builders::PutConfigurationAggregatorInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::put_configuration_aggregator::PutConfigurationAggregatorOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_configuration_aggregator::PutConfigurationAggregatorError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.put_configuration_aggregator();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `PutConfigurationAggregator`.
///
/// <p>Creates and updates the configuration aggregator with the selected source accounts and regions. The source account can be individual account(s) or an organization.</p>
/// <p><code>accountIds</code> that are passed will be replaced with existing accounts. If you want to add additional accounts into the aggregator, call <code>DescribeConfigurationAggregators</code> to get the previous accounts and then append new ones.</p><note>
/// <p>Config should be enabled in source accounts and regions you want to aggregate.</p>
/// <p>If your source type is an organization, you must be signed in to the management account or a registered delegated administrator and all the features must be enabled in your organization. If the caller is a management account, Config calls <code>EnableAwsServiceAccess</code> API to enable integration between Config and Organizations. If the caller is a registered delegated administrator, Config calls <code>ListDelegatedAdministrators</code> API to verify whether the caller is a valid delegated administrator.</p>
/// <p>To register a delegated administrator, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/set-up-aggregator-cli.html#register-a-delegated-administrator-cli">Register a Delegated Administrator</a> in the <i>Config developer guide</i>.</p>
/// </note> <note>
/// <p><b>Tags are added at creation and cannot be updated with this operation</b></p>
/// <p><code>PutConfigurationAggregator</code> is an idempotent API. Subsequent requests won’t create a duplicate resource if one was already created. If a following request has different <code>tags</code> values, Config will ignore these differences and treat it as an idempotent request of the previous. In this case, <code>tags</code> will not be updated, even if they are different.</p>
/// <p>Use <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_TagResource.html">TagResource</a> and <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_UntagResource.html">UntagResource</a> to update tags after creation.</p>
/// </note>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct PutConfigurationAggregatorFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::put_configuration_aggregator::builders::PutConfigurationAggregatorInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::put_configuration_aggregator::PutConfigurationAggregatorOutput,
        crate::operation::put_configuration_aggregator::PutConfigurationAggregatorError,
    > for PutConfigurationAggregatorFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::put_configuration_aggregator::PutConfigurationAggregatorOutput,
            crate::operation::put_configuration_aggregator::PutConfigurationAggregatorError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl PutConfigurationAggregatorFluentBuilder {
    /// Creates a new `PutConfigurationAggregatorFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the PutConfigurationAggregator as a reference.
    pub fn as_input(&self) -> &crate::operation::put_configuration_aggregator::builders::PutConfigurationAggregatorInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::put_configuration_aggregator::PutConfigurationAggregatorOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::put_configuration_aggregator::PutConfigurationAggregatorError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::put_configuration_aggregator::PutConfigurationAggregator::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::put_configuration_aggregator::PutConfigurationAggregator::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::put_configuration_aggregator::PutConfigurationAggregatorOutput,
        crate::operation::put_configuration_aggregator::PutConfigurationAggregatorError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The name of the configuration aggregator.</p>
    pub fn configuration_aggregator_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.configuration_aggregator_name(input.into());
        self
    }
    /// <p>The name of the configuration aggregator.</p>
    pub fn set_configuration_aggregator_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_configuration_aggregator_name(input);
        self
    }
    /// <p>The name of the configuration aggregator.</p>
    pub fn get_configuration_aggregator_name(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_configuration_aggregator_name()
    }
    ///
    /// Appends an item to `AccountAggregationSources`.
    ///
    /// To override the contents of this collection use [`set_account_aggregation_sources`](Self::set_account_aggregation_sources).
    ///
    /// <p>A list of AccountAggregationSource object.</p>
    pub fn account_aggregation_sources(mut self, input: crate::types::AccountAggregationSource) -> Self {
        self.inner = self.inner.account_aggregation_sources(input);
        self
    }
    /// <p>A list of AccountAggregationSource object.</p>
    pub fn set_account_aggregation_sources(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::AccountAggregationSource>>) -> Self {
        self.inner = self.inner.set_account_aggregation_sources(input);
        self
    }
    /// <p>A list of AccountAggregationSource object.</p>
    pub fn get_account_aggregation_sources(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::AccountAggregationSource>> {
        self.inner.get_account_aggregation_sources()
    }
    /// <p>An OrganizationAggregationSource object.</p>
    pub fn organization_aggregation_source(mut self, input: crate::types::OrganizationAggregationSource) -> Self {
        self.inner = self.inner.organization_aggregation_source(input);
        self
    }
    /// <p>An OrganizationAggregationSource object.</p>
    pub fn set_organization_aggregation_source(mut self, input: ::std::option::Option<crate::types::OrganizationAggregationSource>) -> Self {
        self.inner = self.inner.set_organization_aggregation_source(input);
        self
    }
    /// <p>An OrganizationAggregationSource object.</p>
    pub fn get_organization_aggregation_source(&self) -> &::std::option::Option<crate::types::OrganizationAggregationSource> {
        self.inner.get_organization_aggregation_source()
    }
    ///
    /// Appends an item to `Tags`.
    ///
    /// To override the contents of this collection use [`set_tags`](Self::set_tags).
    ///
    /// <p>An array of tag object.</p>
    pub fn tags(mut self, input: crate::types::Tag) -> Self {
        self.inner = self.inner.tags(input);
        self
    }
    /// <p>An array of tag object.</p>
    pub fn set_tags(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::Tag>>) -> Self {
        self.inner = self.inner.set_tags(input);
        self
    }
    /// <p>An array of tag object.</p>
    pub fn get_tags(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::Tag>> {
        self.inner.get_tags()
    }
    /// <p>An object to filter configuration recorders in an aggregator. Either <code>ResourceType</code> or <code>ServicePrincipal</code> is required.</p>
    pub fn aggregator_filters(mut self, input: crate::types::AggregatorFilters) -> Self {
        self.inner = self.inner.aggregator_filters(input);
        self
    }
    /// <p>An object to filter configuration recorders in an aggregator. Either <code>ResourceType</code> or <code>ServicePrincipal</code> is required.</p>
    pub fn set_aggregator_filters(mut self, input: ::std::option::Option<crate::types::AggregatorFilters>) -> Self {
        self.inner = self.inner.set_aggregator_filters(input);
        self
    }
    /// <p>An object to filter configuration recorders in an aggregator. Either <code>ResourceType</code> or <code>ServicePrincipal</code> is required.</p>
    pub fn get_aggregator_filters(&self) -> &::std::option::Option<crate::types::AggregatorFilters> {
        self.inner.get_aggregator_filters()
    }
}
