// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The input for the <code>GetResourceConfigHistory</code> action.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct GetResourceConfigHistoryInput {
    /// <p>The resource type.</p>
    pub resource_type: ::std::option::Option<crate::types::ResourceType>,
    /// <p>The ID of the resource (for example., <code>sg-xxxxxx</code>).</p>
    pub resource_id: ::std::option::Option<::std::string::String>,
    /// <p>The chronologically latest time in the time range for which the history requested. If not specified, current time is taken.</p>
    pub later_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>The chronologically earliest time in the time range for which the history requested. If not specified, the action returns paginated results that contain configuration items that start when the first configuration item was recorded.</p>
    pub earlier_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>The chronological order for configuration items listed. By default, the results are listed in reverse chronological order.</p>
    pub chronological_order: ::std::option::Option<crate::types::ChronologicalOrder>,
    /// <p>The maximum number of configuration items returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub limit: ::std::option::Option<i32>,
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub next_token: ::std::option::Option<::std::string::String>,
}
impl GetResourceConfigHistoryInput {
    /// <p>The resource type.</p>
    pub fn resource_type(&self) -> ::std::option::Option<&crate::types::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The ID of the resource (for example., <code>sg-xxxxxx</code>).</p>
    pub fn resource_id(&self) -> ::std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The chronologically latest time in the time range for which the history requested. If not specified, current time is taken.</p>
    pub fn later_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.later_time.as_ref()
    }
    /// <p>The chronologically earliest time in the time range for which the history requested. If not specified, the action returns paginated results that contain configuration items that start when the first configuration item was recorded.</p>
    pub fn earlier_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.earlier_time.as_ref()
    }
    /// <p>The chronological order for configuration items listed. By default, the results are listed in reverse chronological order.</p>
    pub fn chronological_order(&self) -> ::std::option::Option<&crate::types::ChronologicalOrder> {
        self.chronological_order.as_ref()
    }
    /// <p>The maximum number of configuration items returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub fn limit(&self) -> ::std::option::Option<i32> {
        self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(&self) -> ::std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl GetResourceConfigHistoryInput {
    /// Creates a new builder-style object to manufacture [`GetResourceConfigHistoryInput`](crate::operation::get_resource_config_history::GetResourceConfigHistoryInput).
    pub fn builder() -> crate::operation::get_resource_config_history::builders::GetResourceConfigHistoryInputBuilder {
        crate::operation::get_resource_config_history::builders::GetResourceConfigHistoryInputBuilder::default()
    }
}

/// A builder for [`GetResourceConfigHistoryInput`](crate::operation::get_resource_config_history::GetResourceConfigHistoryInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct GetResourceConfigHistoryInputBuilder {
    pub(crate) resource_type: ::std::option::Option<crate::types::ResourceType>,
    pub(crate) resource_id: ::std::option::Option<::std::string::String>,
    pub(crate) later_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) earlier_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) chronological_order: ::std::option::Option<crate::types::ChronologicalOrder>,
    pub(crate) limit: ::std::option::Option<i32>,
    pub(crate) next_token: ::std::option::Option<::std::string::String>,
}
impl GetResourceConfigHistoryInputBuilder {
    /// <p>The resource type.</p>
    /// This field is required.
    pub fn resource_type(mut self, input: crate::types::ResourceType) -> Self {
        self.resource_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The resource type.</p>
    pub fn set_resource_type(mut self, input: ::std::option::Option<crate::types::ResourceType>) -> Self {
        self.resource_type = input;
        self
    }
    /// <p>The resource type.</p>
    pub fn get_resource_type(&self) -> &::std::option::Option<crate::types::ResourceType> {
        &self.resource_type
    }
    /// <p>The ID of the resource (for example., <code>sg-xxxxxx</code>).</p>
    /// This field is required.
    pub fn resource_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.resource_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ID of the resource (for example., <code>sg-xxxxxx</code>).</p>
    pub fn set_resource_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.resource_id = input;
        self
    }
    /// <p>The ID of the resource (for example., <code>sg-xxxxxx</code>).</p>
    pub fn get_resource_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.resource_id
    }
    /// <p>The chronologically latest time in the time range for which the history requested. If not specified, current time is taken.</p>
    pub fn later_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.later_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The chronologically latest time in the time range for which the history requested. If not specified, current time is taken.</p>
    pub fn set_later_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.later_time = input;
        self
    }
    /// <p>The chronologically latest time in the time range for which the history requested. If not specified, current time is taken.</p>
    pub fn get_later_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.later_time
    }
    /// <p>The chronologically earliest time in the time range for which the history requested. If not specified, the action returns paginated results that contain configuration items that start when the first configuration item was recorded.</p>
    pub fn earlier_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.earlier_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The chronologically earliest time in the time range for which the history requested. If not specified, the action returns paginated results that contain configuration items that start when the first configuration item was recorded.</p>
    pub fn set_earlier_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.earlier_time = input;
        self
    }
    /// <p>The chronologically earliest time in the time range for which the history requested. If not specified, the action returns paginated results that contain configuration items that start when the first configuration item was recorded.</p>
    pub fn get_earlier_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.earlier_time
    }
    /// <p>The chronological order for configuration items listed. By default, the results are listed in reverse chronological order.</p>
    pub fn chronological_order(mut self, input: crate::types::ChronologicalOrder) -> Self {
        self.chronological_order = ::std::option::Option::Some(input);
        self
    }
    /// <p>The chronological order for configuration items listed. By default, the results are listed in reverse chronological order.</p>
    pub fn set_chronological_order(mut self, input: ::std::option::Option<crate::types::ChronologicalOrder>) -> Self {
        self.chronological_order = input;
        self
    }
    /// <p>The chronological order for configuration items listed. By default, the results are listed in reverse chronological order.</p>
    pub fn get_chronological_order(&self) -> &::std::option::Option<crate::types::ChronologicalOrder> {
        &self.chronological_order
    }
    /// <p>The maximum number of configuration items returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub fn limit(mut self, input: i32) -> Self {
        self.limit = ::std::option::Option::Some(input);
        self
    }
    /// <p>The maximum number of configuration items returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub fn set_limit(mut self, input: ::std::option::Option<i32>) -> Self {
        self.limit = input;
        self
    }
    /// <p>The maximum number of configuration items returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, Config uses the default.</p>
    pub fn get_limit(&self) -> &::std::option::Option<i32> {
        &self.limit
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.next_token = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn set_next_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.next_token = input;
        self
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn get_next_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.next_token
    }
    /// Consumes the builder and constructs a [`GetResourceConfigHistoryInput`](crate::operation::get_resource_config_history::GetResourceConfigHistoryInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<
        crate::operation::get_resource_config_history::GetResourceConfigHistoryInput,
        ::aws_smithy_types::error::operation::BuildError,
    > {
        ::std::result::Result::Ok(crate::operation::get_resource_config_history::GetResourceConfigHistoryInput {
            resource_type: self.resource_type,
            resource_id: self.resource_id,
            later_time: self.later_time,
            earlier_time: self.earlier_time,
            chronological_order: self.chronological_order,
            limit: self.limit,
            next_token: self.next_token,
        })
    }
}
