// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::describe_retention_configurations::_describe_retention_configurations_output::DescribeRetentionConfigurationsOutputBuilder;

pub use crate::operation::describe_retention_configurations::_describe_retention_configurations_input::DescribeRetentionConfigurationsInputBuilder;

impl crate::operation::describe_retention_configurations::builders::DescribeRetentionConfigurationsInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::describe_retention_configurations::DescribeRetentionConfigurationsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_retention_configurations::DescribeRetentionConfigurationsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.describe_retention_configurations();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `DescribeRetentionConfigurations`.
///
/// <p>Returns the details of one or more retention configurations. If the retention configuration name is not specified, this operation returns the details for all the retention configurations for that account.</p><note>
/// <p>Currently, Config supports only one retention configuration per region in your account.</p>
/// </note>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct DescribeRetentionConfigurationsFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::describe_retention_configurations::builders::DescribeRetentionConfigurationsInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::describe_retention_configurations::DescribeRetentionConfigurationsOutput,
        crate::operation::describe_retention_configurations::DescribeRetentionConfigurationsError,
    > for DescribeRetentionConfigurationsFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::describe_retention_configurations::DescribeRetentionConfigurationsOutput,
            crate::operation::describe_retention_configurations::DescribeRetentionConfigurationsError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl DescribeRetentionConfigurationsFluentBuilder {
    /// Creates a new `DescribeRetentionConfigurationsFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the DescribeRetentionConfigurations as a reference.
    pub fn as_input(&self) -> &crate::operation::describe_retention_configurations::builders::DescribeRetentionConfigurationsInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::describe_retention_configurations::DescribeRetentionConfigurationsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_retention_configurations::DescribeRetentionConfigurationsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::describe_retention_configurations::DescribeRetentionConfigurations::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::describe_retention_configurations::DescribeRetentionConfigurations::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::describe_retention_configurations::DescribeRetentionConfigurationsOutput,
        crate::operation::describe_retention_configurations::DescribeRetentionConfigurationsError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// Create a paginator for this request
    ///
    /// Paginators are used by calling [`send().await`](crate::operation::describe_retention_configurations::paginator::DescribeRetentionConfigurationsPaginator::send) which returns a [`PaginationStream`](aws_smithy_async::future::pagination_stream::PaginationStream).
    pub fn into_paginator(self) -> crate::operation::describe_retention_configurations::paginator::DescribeRetentionConfigurationsPaginator {
        crate::operation::describe_retention_configurations::paginator::DescribeRetentionConfigurationsPaginator::new(self.handle, self.inner)
    }
    ///
    /// Appends an item to `RetentionConfigurationNames`.
    ///
    /// To override the contents of this collection use [`set_retention_configuration_names`](Self::set_retention_configuration_names).
    ///
    /// <p>A list of names of retention configurations for which you want details. If you do not specify a name, Config returns details for all the retention configurations for that account.</p><note>
    /// <p>Currently, Config supports only one retention configuration per region in your account.</p>
    /// </note>
    pub fn retention_configuration_names(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.retention_configuration_names(input.into());
        self
    }
    /// <p>A list of names of retention configurations for which you want details. If you do not specify a name, Config returns details for all the retention configurations for that account.</p><note>
    /// <p>Currently, Config supports only one retention configuration per region in your account.</p>
    /// </note>
    pub fn set_retention_configuration_names(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.inner = self.inner.set_retention_configuration_names(input);
        self
    }
    /// <p>A list of names of retention configurations for which you want details. If you do not specify a name, Config returns details for all the retention configurations for that account.</p><note>
    /// <p>Currently, Config supports only one retention configuration per region in your account.</p>
    /// </note>
    pub fn get_retention_configuration_names(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        self.inner.get_retention_configuration_names()
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn next_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.next_token(input.into());
        self
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn set_next_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_next_token(input);
        self
    }
    /// <p>The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a paginated response.</p>
    pub fn get_next_token(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_next_token()
    }
}
