// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::describe_delivery_channels::_describe_delivery_channels_output::DescribeDeliveryChannelsOutputBuilder;

pub use crate::operation::describe_delivery_channels::_describe_delivery_channels_input::DescribeDeliveryChannelsInputBuilder;

impl crate::operation::describe_delivery_channels::builders::DescribeDeliveryChannelsInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::describe_delivery_channels::DescribeDeliveryChannelsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_delivery_channels::DescribeDeliveryChannelsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.describe_delivery_channels();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `DescribeDeliveryChannels`.
///
/// <p>Returns details about the specified delivery channel. If a delivery channel is not specified, this operation returns the details of all delivery channels associated with the account.</p><note>
/// <p>Currently, you can specify only one delivery channel per region in your account.</p>
/// </note>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct DescribeDeliveryChannelsFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::describe_delivery_channels::builders::DescribeDeliveryChannelsInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::describe_delivery_channels::DescribeDeliveryChannelsOutput,
        crate::operation::describe_delivery_channels::DescribeDeliveryChannelsError,
    > for DescribeDeliveryChannelsFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::describe_delivery_channels::DescribeDeliveryChannelsOutput,
            crate::operation::describe_delivery_channels::DescribeDeliveryChannelsError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl DescribeDeliveryChannelsFluentBuilder {
    /// Creates a new `DescribeDeliveryChannelsFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the DescribeDeliveryChannels as a reference.
    pub fn as_input(&self) -> &crate::operation::describe_delivery_channels::builders::DescribeDeliveryChannelsInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::describe_delivery_channels::DescribeDeliveryChannelsOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::describe_delivery_channels::DescribeDeliveryChannelsError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::describe_delivery_channels::DescribeDeliveryChannels::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::describe_delivery_channels::DescribeDeliveryChannels::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::describe_delivery_channels::DescribeDeliveryChannelsOutput,
        crate::operation::describe_delivery_channels::DescribeDeliveryChannelsError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    ///
    /// Appends an item to `DeliveryChannelNames`.
    ///
    /// To override the contents of this collection use [`set_delivery_channel_names`](Self::set_delivery_channel_names).
    ///
    /// <p>A list of delivery channel names.</p>
    pub fn delivery_channel_names(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.delivery_channel_names(input.into());
        self
    }
    /// <p>A list of delivery channel names.</p>
    pub fn set_delivery_channel_names(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.inner = self.inner.set_delivery_channel_names(input);
        self
    }
    /// <p>A list of delivery channel names.</p>
    pub fn get_delivery_channel_names(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        self.inner.get_delivery_channel_names()
    }
}
