// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::delete_organization_config_rule::_delete_organization_config_rule_output::DeleteOrganizationConfigRuleOutputBuilder;

pub use crate::operation::delete_organization_config_rule::_delete_organization_config_rule_input::DeleteOrganizationConfigRuleInputBuilder;

impl crate::operation::delete_organization_config_rule::builders::DeleteOrganizationConfigRuleInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::delete_organization_config_rule::DeleteOrganizationConfigRuleOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_organization_config_rule::DeleteOrganizationConfigRuleError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.delete_organization_config_rule();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `DeleteOrganizationConfigRule`.
///
/// <p>Deletes the specified organization Config rule and all of its evaluation results from all member accounts in that organization.</p>
/// <p>Only a management account and a delegated administrator account can delete an organization Config rule. When calling this API with a delegated administrator, you must ensure Organizations <code>ListDelegatedAdministrator</code> permissions are added.</p>
/// <p>Config sets the state of a rule to DELETE_IN_PROGRESS until the deletion is complete. You cannot update a rule while it is in this state.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct DeleteOrganizationConfigRuleFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::delete_organization_config_rule::builders::DeleteOrganizationConfigRuleInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::delete_organization_config_rule::DeleteOrganizationConfigRuleOutput,
        crate::operation::delete_organization_config_rule::DeleteOrganizationConfigRuleError,
    > for DeleteOrganizationConfigRuleFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::delete_organization_config_rule::DeleteOrganizationConfigRuleOutput,
            crate::operation::delete_organization_config_rule::DeleteOrganizationConfigRuleError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl DeleteOrganizationConfigRuleFluentBuilder {
    /// Creates a new `DeleteOrganizationConfigRuleFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the DeleteOrganizationConfigRule as a reference.
    pub fn as_input(&self) -> &crate::operation::delete_organization_config_rule::builders::DeleteOrganizationConfigRuleInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::delete_organization_config_rule::DeleteOrganizationConfigRuleOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_organization_config_rule::DeleteOrganizationConfigRuleError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::delete_organization_config_rule::DeleteOrganizationConfigRule::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::delete_organization_config_rule::DeleteOrganizationConfigRule::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::delete_organization_config_rule::DeleteOrganizationConfigRuleOutput,
        crate::operation::delete_organization_config_rule::DeleteOrganizationConfigRuleError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The name of organization Config rule that you want to delete.</p>
    pub fn organization_config_rule_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.organization_config_rule_name(input.into());
        self
    }
    /// <p>The name of organization Config rule that you want to delete.</p>
    pub fn set_organization_config_rule_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_organization_config_rule_name(input);
        self
    }
    /// <p>The name of organization Config rule that you want to delete.</p>
    pub fn get_organization_config_rule_name(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_organization_config_rule_name()
    }
}
