// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::delete_aggregation_authorization::_delete_aggregation_authorization_output::DeleteAggregationAuthorizationOutputBuilder;

pub use crate::operation::delete_aggregation_authorization::_delete_aggregation_authorization_input::DeleteAggregationAuthorizationInputBuilder;

impl crate::operation::delete_aggregation_authorization::builders::DeleteAggregationAuthorizationInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::delete_aggregation_authorization::DeleteAggregationAuthorizationOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_aggregation_authorization::DeleteAggregationAuthorizationError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.delete_aggregation_authorization();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `DeleteAggregationAuthorization`.
///
/// <p>Deletes the authorization granted to the specified configuration aggregator account in a specified region.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct DeleteAggregationAuthorizationFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::delete_aggregation_authorization::builders::DeleteAggregationAuthorizationInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::delete_aggregation_authorization::DeleteAggregationAuthorizationOutput,
        crate::operation::delete_aggregation_authorization::DeleteAggregationAuthorizationError,
    > for DeleteAggregationAuthorizationFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::delete_aggregation_authorization::DeleteAggregationAuthorizationOutput,
            crate::operation::delete_aggregation_authorization::DeleteAggregationAuthorizationError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl DeleteAggregationAuthorizationFluentBuilder {
    /// Creates a new `DeleteAggregationAuthorizationFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the DeleteAggregationAuthorization as a reference.
    pub fn as_input(&self) -> &crate::operation::delete_aggregation_authorization::builders::DeleteAggregationAuthorizationInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::delete_aggregation_authorization::DeleteAggregationAuthorizationOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_aggregation_authorization::DeleteAggregationAuthorizationError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::delete_aggregation_authorization::DeleteAggregationAuthorization::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::delete_aggregation_authorization::DeleteAggregationAuthorization::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::delete_aggregation_authorization::DeleteAggregationAuthorizationOutput,
        crate::operation::delete_aggregation_authorization::DeleteAggregationAuthorizationError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The 12-digit account ID of the account authorized to aggregate data.</p>
    pub fn authorized_account_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.authorized_account_id(input.into());
        self
    }
    /// <p>The 12-digit account ID of the account authorized to aggregate data.</p>
    pub fn set_authorized_account_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_authorized_account_id(input);
        self
    }
    /// <p>The 12-digit account ID of the account authorized to aggregate data.</p>
    pub fn get_authorized_account_id(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_authorized_account_id()
    }
    /// <p>The region authorized to collect aggregated data.</p>
    pub fn authorized_aws_region(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.authorized_aws_region(input.into());
        self
    }
    /// <p>The region authorized to collect aggregated data.</p>
    pub fn set_authorized_aws_region(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_authorized_aws_region(input);
        self
    }
    /// <p>The region authorized to collect aggregated data.</p>
    pub fn get_authorized_aws_region(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_authorized_aws_region()
    }
}
