/*
 * Code for class GDK_X11
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "gd327.h"
#include <ev_gtk.h>
#include "eif_misc.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F347_5906
static void inline_F347_5906 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11
	return gdk_x11_display_error_trap_push ((GdkDisplay *)arg1);
#endif
	;
}
#define INLINE_F347_5906
#endif
#ifndef INLINE_F347_5908
static EIF_POINTER inline_F347_5908 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11 
		/* Declarations */
	GC gc;									/* handle of newly created GC.  */
	unsigned long valuemask = 0;			/* which values in 'values' to  */
	Window win =  gdk_x11_window_get_xid ((GdkWindow *)arg1);
	Display* display = GDK_SCREEN_XDISPLAY(gdk_window_get_screen ((GdkWindow *)arg1));
		/* Define properties/values for the GC.  */
	XGCValues values;						/* initial values for the GC.   */
	unsigned int line_width = 1;			/* line width for the GC.       */
	int line_style = LineSolid;				/* style for lines drawing and  */
	int cap_style = CapButt;				/* style of the line's edje and */
	int join_style = JoinBevel;				/* joined lines.		*/
	values.function = GXcopy;               /* src */
	values.subwindow_mode = ClipByChildren; /* GCSubwindowMode */
	values.line_width = line_width;
	values.fill_style = FillSolid;
	values.arc_mode = ArcPieSlice;
	values.graphics_exposures = False;
	valuemask = GCFunction | GCFillStyle | GCArcMode | GCSubwindowMode | GCGraphicsExposures;
		/* Create the GC object */
	gc = XCreateGC(display, win, valuemask, &values);
	if (gc < 0) {
		fprintf(stderr, "XCreateGC: \n");
	}
	return gc;
#endif
	;
}
#define INLINE_F347_5908
#endif
#ifndef INLINE_F347_5912
static EIF_POINTER inline_F347_5912 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11 
	return (EIF_POINTER) GDK_SCREEN_XDISPLAY(gdk_window_get_screen ((GdkWindow *)arg1));
#endif
	;
}
#define INLINE_F347_5912
#endif
#ifndef INLINE_F347_5927
static EIF_INTEGER_32 inline_F347_5927 (void)
{
	#ifdef GDK_WINDOWING_X11
return LineSolid;
#endif
	;
}
#define INLINE_F347_5927
#endif
#ifndef INLINE_F347_5928
static EIF_INTEGER_32 inline_F347_5928 (void)
{
	#ifdef GDK_WINDOWING_X11
return CapButt;
#endif
	;
}
#define INLINE_F347_5928
#endif
#ifndef INLINE_F347_5929
static EIF_INTEGER_32 inline_F347_5929 (void)
{
	#ifdef GDK_WINDOWING_X11
return JoinBevel;
#endif
	;
}
#define INLINE_F347_5929
#endif
#ifndef INLINE_F347_5916
static void inline_F347_5916 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6)
{
	#ifdef GDK_WINDOWING_X11 
				XSetLineAttributes((Display*) arg1, (GC) arg2, 
					(unsigned int) arg3,
      				(int) arg4, (int) arg5, (int) arg6);
				#endif
	;
}
#define INLINE_F347_5916
#endif
#ifndef INLINE_F347_5917
static void inline_F347_5917 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_POINTER arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
	XSetDashes ((Display*) arg1, (GC) arg2, (int) arg3, (char*) arg4, (int) arg5);
#endif
	;
}
#define INLINE_F347_5917
#endif
#ifndef INLINE_F347_5926
static EIF_INTEGER_32 inline_F347_5926 (void)
{
	#ifdef GDK_WINDOWING_X11
return LineOnOffDash;
#endif
	;
}
#define INLINE_F347_5926
#endif
#ifndef INLINE_F347_5913
static EIF_POINTER inline_F347_5913 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11 
	return (EIF_POINTER) gdk_x11_window_get_xid ((GdkWindow *) arg1);
#endif
	;
}
#define INLINE_F347_5913
#endif
#ifndef INLINE_F347_5914
static void inline_F347_5914 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	#ifdef GDK_WINDOWING_X11 
XSetFunction((Display*) arg1, (GC) arg2, (int) arg3);
#endif
	;
}
#define INLINE_F347_5914
#endif
#ifndef INLINE_F347_5915
static void inline_F347_5915 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	#ifdef GDK_WINDOWING_X11 
XSetSubwindowMode((Display *)arg1, (GC)arg2, (int)arg3);
#endif
	;
}
#define INLINE_F347_5915
#endif
#ifndef INLINE_F347_5918
static void inline_F347_5918 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	#ifdef GDK_WINDOWING_X11 
XSetFillStyle((Display*)arg1, (GC) arg2, (int)arg3);	
#endif
	;
}
#define INLINE_F347_5918
#endif
#ifndef INLINE_F347_5920
static void inline_F347_5920 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11 
	XFlush((Display*) arg1);
#endif
	;
}
#define INLINE_F347_5920
#endif
#ifndef INLINE_F347_5921
static EIF_INTEGER_32 inline_F347_5921 (void)
{
	#ifdef GDK_WINDOWING_X11
return FillSolid;
#endif
	;
}
#define INLINE_F347_5921
#endif
#ifndef INLINE_F347_5922
static EIF_INTEGER_32 inline_F347_5922 (void)
{
	#ifdef GDK_WINDOWING_X11
return FillTiled;
#endif
	;
}
#define INLINE_F347_5922
#endif
#ifndef INLINE_F347_5931
static EIF_INTEGER_32 inline_F347_5931 (void)
{
	#ifdef GDK_WINDOWING_X11 
return IncludeInferiors;
#endif
	;
}
#define INLINE_F347_5931
#endif
#ifndef INLINE_F347_5934
static void inline_F347_5934 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
XColor color;
/* */
Colormap cmap =  DefaultColormap((Display*) arg1, DefaultScreen((Display*) arg1) );
color.red =   arg3;
color.green = arg4;
color.blue =  arg5;
color.flags = DoRed | DoGreen | DoBlue;
/* */
XAllocColor((Display*) arg1, cmap, &color);
XSetBackground((Display*) arg1, (GC) arg2, (unsigned long) color.pixel);
#endif
	;
}
#define INLINE_F347_5934
#endif
#ifndef INLINE_F347_5935
static void inline_F347_5935 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
XColor color;
Colormap cmap = DefaultColormap((Display*) arg1, DefaultScreen((Display*) arg1));
color.red =   arg3;
color.green = arg4;
color.blue =  arg5;
color.flags = DoRed | DoGreen | DoBlue;
XAllocColor((Display*) arg1, cmap, &color);
XSetForeground((Display*) arg1, (GC) arg2, (unsigned long) color.pixel);
#endif
	;
}
#define INLINE_F347_5935
#endif
#ifndef INLINE_F347_5937
static EIF_INTEGER_32 inline_F347_5937 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXand;
#endif
	;
}
#define INLINE_F347_5937
#endif
#ifndef INLINE_F347_5939
static EIF_INTEGER_32 inline_F347_5939 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXcopy;
#endif
	;
}
#define INLINE_F347_5939
#endif
#ifndef INLINE_F347_5942
static EIF_INTEGER_32 inline_F347_5942 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXxor;
#endif
	;
}
#define INLINE_F347_5942
#endif
#ifndef INLINE_F347_5943
static EIF_INTEGER_32 inline_F347_5943 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXor;
#endif
	;
}
#define INLINE_F347_5943
#endif
#ifndef INLINE_F347_5946
static EIF_INTEGER_32 inline_F347_5946 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXinvert;
#endif
	;
}
#define INLINE_F347_5946
#endif
#ifndef INLINE_F347_5952
static void inline_F347_5952 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7)
{
	#ifdef GDK_WINDOWING_X11 
	Window win = (Window) arg1;
	/*
	 * TODO check Gdkgc-x11 _gdk_x11_gc_flush implementation 
	 * that's used before
	 * for example gdk_x11_draw_segments the usage of
	 * GDK_GC_GET_XGC (gc),
	 * https://github.com/coapp-packages/gtk/blob/master/gdk/x11/gdkdrawable-x11.c
	 */
						
	XDrawLine((Display*) arg2, win, arg3, arg4, arg5, arg6, arg7);
	
#endif
	;
}
#define INLINE_F347_5952
#endif
#ifndef INLINE_F347_5953
static void inline_F347_5953 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
	XDrawPoint ((Display*) arg2, (Drawable) arg1, arg3, arg4, arg5);
#endif
	;
}
#define INLINE_F347_5953
#endif
#ifndef INLINE_F347_5954
static void inline_F347_5954 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7, EIF_INTEGER_32 arg8, EIF_INTEGER_32 arg9, EIF_INTEGER_32 arg10)
{
	#ifdef GDK_WINDOWING_X11 
					Window win = (Window) arg1;
					if (arg7 < 0 || arg8 < 0)
					{
						gint real_width;
						gint real_height;
						XWindowAttributes wa;
						XGetWindowAttributes((Display*) arg2, win, &wa);
						real_width = wa.width;
						real_height = wa.height;

						if (arg7 < 0)
							arg7 = real_width;
						if (arg8 < 0)
							arg8 = real_height;
					}

					if (arg4)
					    XFillArc ((Display*) arg2, win, arg3, arg5, arg6, arg7, arg8, arg9, arg10);
					else
					    XDrawArc ((Display*) arg2, win, arg3, arg5, arg6, arg7, arg8, arg9, arg10);	
	
				#endif
	;
}
#define INLINE_F347_5954
#endif
#ifndef INLINE_F347_5955
static void inline_F347_5955 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7, EIF_INTEGER_32 arg8)
{
	#ifdef GDK_WINDOWING_X11 
					Window win = (Window) arg1;
					if (arg7 < 0 || arg8 < 0)
					{
						gint real_width;
						gint real_height;
						
						XWindowAttributes wa;
						XGetWindowAttributes((Display*) arg2, win, &wa);
						real_width = wa.width;
						real_height = wa.height;
					   
					   	if (arg7 < 0)
							arg7 = real_width;
						if (arg8 < 0)
							arg8 = real_height;
					}

					if (arg4)
					    XFillRectangle ((Display*) arg2, win, arg3, arg5, arg6, arg7, arg8);
					else
					    XDrawRectangle ((Display*) arg2, win, arg3, arg5, arg6, arg7, arg8);

				#endif
	;
}
#define INLINE_F347_5955
#endif
#ifndef INLINE_F347_5956
static void inline_F347_5956 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_POINTER arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
					Window win = (Window) arg1;
					gint i;
					XPoint *tmp_points = g_new (XPoint, arg5);

					for (i=0; i<arg5; i++)
				    {
				      tmp_points[i].x = ((GdkPoint *)arg4)[i].x;
				      tmp_points[i].y = ((GdkPoint *)arg4)[i].y;
				    }
				    					
					XDrawLines ((Display*) arg2, win, arg3, tmp_points, arg5, CoordModeOrigin);
					g_free (tmp_points);
				#endif
	;
}
#define INLINE_F347_5956
#endif
#ifndef INLINE_F347_5957
static void inline_F347_5957 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_POINTER arg5, EIF_INTEGER_32 arg6)
{
	#ifdef GDK_WINDOWING_X11 
					Window win = (Window) arg1;
					XPoint *tmp_points;
 					gint tmp_npoints, i;


					if (!(arg4) &&
				      ( ((GdkPoint *)arg5)[0].x != ((GdkPoint *)arg5)[arg6-1].x || ((GdkPoint *)arg5)[0].y != ((GdkPoint *)arg5)[arg6-1].y))
				    {
				      tmp_npoints = arg6 + 1;
				      tmp_points = g_new (XPoint, tmp_npoints);
				      tmp_points[arg6].x = ((GdkPoint *)arg5)[0].x;
				      tmp_points[arg6].y = ((GdkPoint *)arg5)[0].y;
				    }
				  	else
				    {
				      tmp_npoints = arg6;
				      tmp_points = g_new (XPoint, tmp_npoints);
				    }

				  	for (i=0; i<arg6; i++)
				    {
				      tmp_points[i].x = ((GdkPoint *)arg5)[i].x;
				      tmp_points[i].y = ((GdkPoint *)arg5)[i].y;
				    }


				    if (arg4)
						XFillPolygon ((Display*) arg2, win, arg3, tmp_points, tmp_npoints, Complex, CoordModeOrigin);					
					else	
						XDrawLines ((Display*) arg2, win, arg3, tmp_points, tmp_npoints, CoordModeOrigin);
						
					g_free (tmp_points);
				#endif
	;
}
#define INLINE_F347_5957
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {GDK_X11}.gdk_x11_display_error_trap_push */
void F347_5906 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("gdk_x11_display_error_trap_push", 346, Current, 0, 1, 5462);
	inline_F347_5906 ((EIF_POINTER) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.create_gc */
EIF_POINTER F347_5908 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("create_gc", 346, Current, 0, 1, 5464);
	Result = inline_F347_5908 ((EIF_POINTER) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.set_line_attributes_to_solid_style */
void F347_5909 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	RTEX;
	EIF_POINTER tp1;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("set_line_attributes_to_solid_style", 346, Current, 0, 3, 5465);
	RTGC;
	RTHOOK(1);
	tp1 = inline_F347_5912(arg1);
	ti4_1 = inline_F347_5927();
	ti4_2 = inline_F347_5928();
	ti4_3 = inline_F347_5929();
	inline_F347_5916(tp1, arg2, arg3, ti4_1, ti4_2, ti4_3);
	RTHOOK(2);
	RTLE;
	RTEE;
}

/* {GDK_X11}.set_line_attributes_to_dashed_style */
void F347_5910 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	RTEX;
	EIF_POINTER loc1 = (EIF_POINTER) 0;
	EIF_INTEGER_16 loc2 = (EIF_INTEGER_16) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_16 ti2_1;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("set_line_attributes_to_dashed_style", 346, Current, 2, 3, 5466);
	RTGC;
	RTHOOK(1);
	loc1 = inline_F347_5912(arg1);
	RTHOOK(2);
	ti2_1 = eif_bit_shift_left(((EIF_INTEGER_16) 3L),((EIF_INTEGER_32) 8L));
	loc2 = eif_bit_or(((EIF_INTEGER_16) 3L),ti2_1);
	RTHOOK(3);
	inline_F347_5917(loc1, arg2, ((EIF_INTEGER_32) 0L), (EIF_INTEGER_16 *) &(loc2), ((EIF_INTEGER_32) 2L));
	RTHOOK(4);
	ti4_1 = inline_F347_5926();
	ti4_2 = inline_F347_5928();
	ti4_3 = inline_F347_5929();
	inline_F347_5916(loc1, arg2, arg3, ti4_1, ti4_2, ti4_3);
	RTHOOK(5);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_display */
EIF_POINTER F347_5912 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_display", 346, Current, 0, 1, 5468);
	Result = inline_F347_5912 ((EIF_POINTER) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_window */
EIF_POINTER F347_5913 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_window", 346, Current, 0, 1, 5469);
	Result = inline_F347_5913 ((EIF_POINTER) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_set_function */
void F347_5914 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_function", 346, Current, 0, 3, 5470);
	inline_F347_5914 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_subwindow_mode */
void F347_5915 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_subwindow_mode", 346, Current, 0, 3, 5471);
	inline_F347_5915 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_line_attributes */
void F347_5916 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_line_attributes", 346, Current, 0, 6, 5472);
	inline_F347_5916 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5, (EIF_INTEGER_32) arg6);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_dashes */
void F347_5917 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_POINTER arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_dashes", 346, Current, 0, 5, 5473);
	inline_F347_5917 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3, (EIF_POINTER) arg4, (EIF_INTEGER_32) arg5);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_fill_style */
void F347_5918 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_fill_style", 346, Current, 0, 3, 5474);
	inline_F347_5918 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_flush */
void F347_5920 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_flush", 346, Current, 0, 1, 5476);
	inline_F347_5920 ((EIF_POINTER) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_fill_solid */
EIF_INTEGER_32 F347_5921 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_fill_solid", 346, Current, 0, 0, 5477);
	Result = inline_F347_5921 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_fill_tiled */
EIF_INTEGER_32 F347_5922 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_fill_tiled", 346, Current, 0, 0, 5478);
	Result = inline_F347_5922 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_style_line_on_off_dash */
EIF_INTEGER_32 F347_5926 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_style_line_on_off_dash", 346, Current, 0, 0, 5482);
	Result = inline_F347_5926 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_style_line_solid */
EIF_INTEGER_32 F347_5927 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_style_line_solid", 346, Current, 0, 0, 5483);
	Result = inline_F347_5927 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_style_cap_butt */
EIF_INTEGER_32 F347_5928 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_style_cap_butt", 346, Current, 0, 0, 5484);
	Result = inline_F347_5928 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_style_join_bevel */
EIF_INTEGER_32 F347_5929 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_style_join_bevel", 346, Current, 0, 0, 5485);
	Result = inline_F347_5929 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_subwindow_mode_include_inferiors */
EIF_INTEGER_32 F347_5931 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_subwindow_mode_include_inferiors", 346, Current, 0, 0, 5487);
	Result = inline_F347_5931 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.set_drawable_background */
void F347_5932 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	EIF_POINTER loc1 = (EIF_POINTER) 0;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("set_drawable_background", 346, Current, 1, 5, 5488);
	RTGC;
	RTHOOK(1);
	loc1 = inline_F347_5912(arg1);
	RTHOOK(2);
	inline_F347_5934(loc1, arg2, arg3, arg4, arg5);
	RTHOOK(3);
	RTLE;
	RTEE;
}

/* {GDK_X11}.set_drawable_foreground */
void F347_5933 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	EIF_POINTER loc1 = (EIF_POINTER) 0;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("set_drawable_foreground", 346, Current, 1, 5, 5489);
	RTGC;
	RTHOOK(1);
	loc1 = inline_F347_5912(arg1);
	RTHOOK(2);
	inline_F347_5935(loc1, arg2, arg3, arg4, arg5);
	RTHOOK(3);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_background */
void F347_5934 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_background", 346, Current, 0, 5, 5490);
	inline_F347_5934 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_foreground */
void F347_5935 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_foreground", 346, Current, 0, 5, 5491);
	inline_F347_5935 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_function_gxand */
EIF_INTEGER_32 F347_5937 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_function_gxand", 346, Current, 0, 0, 5493);
	Result = inline_F347_5937 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_function_gxcopy */
EIF_INTEGER_32 F347_5939 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_function_gxcopy", 346, Current, 0, 0, 5495);
	Result = inline_F347_5939 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_function_gxxor */
EIF_INTEGER_32 F347_5942 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_function_gxxor", 346, Current, 0, 0, 5498);
	Result = inline_F347_5942 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_function_gxor */
EIF_INTEGER_32 F347_5943 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_function_gxor", 346, Current, 0, 0, 5499);
	Result = inline_F347_5943 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_function_gxinvert */
EIF_INTEGER_32 F347_5946 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_function_gxinvert", 346, Current, 0, 0, 5502);
	Result = inline_F347_5946 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.draw_line */
void F347_5952 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_line", 346, Current, 0, 7, 5508);
	inline_F347_5952 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5, (EIF_INTEGER_32) arg6, (EIF_INTEGER_32) arg7);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.draw_point */
void F347_5953 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_point", 346, Current, 0, 5, 5509);
	inline_F347_5953 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.draw_arc */
void F347_5954 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7, EIF_INTEGER_32 arg8, EIF_INTEGER_32 arg9, EIF_INTEGER_32 arg10)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_arc", 346, Current, 0, 10, 5510);
	inline_F347_5954 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4, (EIF_INTEGER_32) arg5, (EIF_INTEGER_32) arg6, (EIF_INTEGER_32) arg7, (EIF_INTEGER_32) arg8, (EIF_INTEGER_32) arg9, (EIF_INTEGER_32) arg10);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.draw_rectangle */
void F347_5955 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7, EIF_INTEGER_32 arg8)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_rectangle", 346, Current, 0, 8, 5511);
	inline_F347_5955 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4, (EIF_INTEGER_32) arg5, (EIF_INTEGER_32) arg6, (EIF_INTEGER_32) arg7, (EIF_INTEGER_32) arg8);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.draw_lines */
void F347_5956 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_POINTER arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_lines", 346, Current, 0, 5, 5512);
	inline_F347_5956 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_POINTER) arg4, (EIF_INTEGER_32) arg5);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.draw_polygon */
void F347_5957 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_POINTER arg5, EIF_INTEGER_32 arg6)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_polygon", 346, Current, 0, 6, 5513);
	inline_F347_5957 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4, (EIF_POINTER) arg5, (EIF_INTEGER_32) arg6);
	RTHOOK(1);
	RTLE;
	RTEE;
}

void EIF_Minit327 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
