/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.build.DirParser;
import org.basex.build.DiskBuilder;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.Databases;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateIndex;
import org.basex.core.cmd.Open;
import org.basex.core.jobs.JobException;
import org.basex.core.locks.Locks;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.io.IO;
import org.basex.io.IOStream;
import org.basex.io.in.LookupInput;
import org.basex.util.Util;

public final class CreateDB
extends ACreate {
    private Parser parser;

    public CreateDB(String name) {
        this(name, (String)null);
    }

    public CreateDB(String name, String input) {
        super(name, input);
    }

    public void setParser(Parser prsr) {
        this.parser = prsr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean run() {
        IO source;
        String name = this.args[0];
        if (!Databases.validName(name)) {
            return this.error(Text.NAME_INVALID_X, name);
        }
        try {
            source = this.sourceToIO(name);
            if (this.in != null) {
                LookupInput li = new LookupInput(source.inputStream());
                source = li.lookup() == -1 ? null : new IOStream(li, source.name());
            }
        }
        catch (IOException ex) {
            return this.error(Util.message(ex), new Object[0]);
        }
        try {
            Data data;
            if (source != null) {
                if (!source.exists()) {
                    return this.error(Text.RES_NOT_FOUND_X, source);
                }
                this.parser = new DirParser(source, this.options);
            } else if (this.parser == null) {
                this.parser = Parser.emptyParser(this.options);
            }
            Close.close(this.context);
            if (this.options.get(MainOptions.MAINMEM).booleanValue()) {
                try {
                    data = this.pushJob(new MemBuilder(name, this.parser)).build();
                }
                finally {
                    this.popJob();
                }
                this.context.openDB(data);
                this.context.datas.pin(data);
            } else {
                if (this.context.pinned(name)) {
                    return this.error(Text.DB_PINNED_X, name);
                }
                DiskBuilder builder = new DiskBuilder(name, this.parser, this.soptions, this.options);
                builder.binariesDir(this.soptions.dbPath(name));
                this.pushJob(builder);
                try {
                    builder.build().close();
                }
                finally {
                    this.popJob();
                }
                Open open = new Open(name);
                if (!open.run(this.context)) {
                    return this.error(open.info(), new Object[0]);
                }
                data = this.context.data();
            }
            if (!this.update(data, () -> {
                CreateIndex.create(data, this);
                return this.info(this.parser.info() + Text.DB_CREATED_X_X, name, this.jc().performance);
            })) {
                return false;
            }
            if (this.options.get(MainOptions.CREATEONLY).booleanValue()) {
                Close.close(this.context);
            }
            return true;
        }
        catch (JobException ex) {
            throw ex;
        }
        catch (IOException ex) {
            return this.error(Util.message(ex), new Object[0]);
        }
        catch (Exception ex) {
            Util.stack(ex);
            return this.error(Text.NOT_PARSED_X, this.parser.source());
        }
    }

    @Override
    public void addLocks() {
        Locks locks = this.jc().locks;
        locks.reads.add("internal:context");
        locks.writes.add(this.args[0]);
    }

    public static synchronized Data create(String name, Parser parser, Context ctx, MainOptions options) throws IOException {
        return CreateDB.create(name, parser, ctx, options, options.get(MainOptions.MAINMEM));
    }

    public static synchronized Data create(String name, Parser parser, Context ctx, MainOptions options, boolean mainmem) throws IOException {
        Data data;
        if (!ctx.user().has(Perm.CREATE)) {
            throw new BaseXException(Text.PERM_REQUIRED_X, new Object[]{Perm.CREATE});
        }
        if (mainmem) {
            data = MemBuilder.build(name, parser);
        } else {
            if (ctx.pinned(name)) {
                throw new BaseXException(Text.DB_PINNED_X, name);
            }
            new DiskBuilder(name, parser, ctx.soptions, options).build().close();
            data = Open.open(name, ctx, options, true, true);
        }
        CreateIndex.create(data, null);
        return data;
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init(String.valueOf((Object)Commands.Cmd.CREATE) + " " + String.valueOf((Object)Commands.CmdCreate.DB)).arg(0).add(1);
    }
}

