/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.languagetool.Languages;
import org.languagetool.gui.LanguageAdapter;
import org.languagetool.gui.LanguageComboBox;
import org.languagetool.gui.LocalStorage;
import org.languagetool.gui.LocaleBean;
import org.languagetool.gui.SavablePanel;

class GuiLangConfigPanel
extends JPanel
implements SavablePanel,
ItemListener {
    private final LocalStorage storage;
    private final ResourceBundle messages;
    private final LanguageComboBox languageBox;
    private final LanguageAdapter system;
    private final JLabel needsRestartLabel = new JLabel("");
    private boolean needsRestart = false;
    private LanguageAdapter guiLang = null;

    GuiLangConfigPanel(ResourceBundle messages, LocalStorage storage) {
        super(new GridBagLayout());
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        this.setBorder(BorderFactory.createTitledBorder(messages.getString("guiLanguage")));
        this.messages = messages;
        this.storage = storage;
        this.system = new LanguageAdapter(messages.getString("guiLanguageSystem"));
        this.languageBox = LanguageComboBox.create(messages, "", true, false, this.system);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 21;
        this.add((Component)this.languageBox, c);
        c.gridy = 1;
        c.fill = 2;
        this.add((Component)this.needsRestartLabel, c);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.guiLang = (LanguageAdapter)e.getItem();
            this.needsRestartLabel.setText(this.messages.getString("quiLanguageNeedsRestart"));
            this.needsRestartLabel.setForeground(Color.red);
        }
    }

    public void componentShowing() {
        this.languageBox.removeItemListener(this);
        this.loadOption();
        this.languageBox.addItemListener(this);
    }

    public void save() {
        if (this.guiLang == null) {
            return;
        }
        this.needsRestart = true;
        if (this.guiLang.getLanguage() != null) {
            this.storage.saveProperty("gui.locale", new LocaleBean(this.guiLang.getLanguage().getLocaleWithCountryAndVariant()));
        } else {
            this.storage.saveProperty("gui.locale", null);
        }
    }

    private void loadOption() {
        LocaleBean lang;
        this.guiLang = null;
        if (!this.needsRestart) {
            this.needsRestartLabel.setText("");
        }
        if ((lang = this.storage.loadProperty("gui.locale", LocaleBean.class)) != null) {
            Locale l = lang.asLocale();
            this.languageBox.selectLanguage(Languages.getLanguageForLocale((Locale)l));
        } else {
            this.languageBox.setSelectedItem(this.system);
        }
    }
}

