/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.classification.statistics.evaluations;

import com.hankcs.hanlp.classification.classifiers.IClassifier;
import com.hankcs.hanlp.classification.corpus.Document;
import com.hankcs.hanlp.classification.corpus.IDataSet;
import com.hankcs.hanlp.classification.corpus.MemoryDataSet;
import com.hankcs.hanlp.classification.statistics.evaluations.FMeasure;
import com.hankcs.hanlp.utility.MathUtility;
import java.util.Map;

public class Evaluator {
    private Evaluator() {
    }

    public static FMeasure evaluate(IClassifier classifier, IDataSet testingDataSet) {
        int c = classifier.getModel().catalog.length;
        double[] TP_FP = new double[c];
        double[] TP_FN = new double[c];
        double[] TP = new double[c];
        double time = System.currentTimeMillis();
        for (Document document : testingDataSet) {
            int out = classifier.label(document);
            int key = document.category;
            int n = out;
            TP_FP[n] = TP_FP[n] + 1.0;
            int n2 = key;
            TP_FN[n2] = TP_FN[n2] + 1.0;
            if (key != out) continue;
            int n3 = out;
            TP[n3] = TP[n3] + 1.0;
        }
        time = (double)System.currentTimeMillis() - time;
        FMeasure result = Evaluator.calculate(c, testingDataSet.size(), TP, TP_FP, TP_FN);
        result.catalog = testingDataSet.getCatalog().toArray();
        result.speed = (double)result.size / (time / 1000.0);
        return result;
    }

    public static FMeasure evaluate(IClassifier classifier, Map<String, String[]> testingDataSet) {
        return Evaluator.evaluate(classifier, new MemoryDataSet(classifier.getModel()).add(testingDataSet));
    }

    private static FMeasure calculate(int c, int size, double[] TP, double[] TP_FP, double[] TP_FN) {
        double[] precision = new double[c];
        double[] recall = new double[c];
        double[] f1 = new double[c];
        double[] accuracy = new double[c];
        FMeasure result = new FMeasure();
        result.size = size;
        for (int i = 0; i < c; ++i) {
            double TN = (double)result.size - TP_FP[i] - (TP_FN[i] - TP[i]);
            accuracy[i] = (TP[i] + TN) / (double)result.size;
            if (TP[i] != 0.0) {
                precision[i] = TP[i] / TP_FP[i];
                recall[i] = TP[i] / TP_FN[i];
                result.average_accuracy += TP[i];
            } else {
                precision[i] = 0.0;
                recall[i] = 0.0;
            }
            f1[i] = 2.0 * precision[i] * recall[i] / (precision[i] + recall[i]);
        }
        result.average_precision = MathUtility.average(precision);
        result.average_recall = MathUtility.average(recall);
        result.average_f1 = 2.0 * result.average_precision * result.average_recall / (result.average_precision + result.average_recall);
        result.average_accuracy /= (double)result.size;
        result.accuracy = accuracy;
        result.precision = precision;
        result.recall = recall;
        result.f1 = f1;
        return result;
    }
}

