/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AbstractRelationEditorAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorActionAccess;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorUpdateOn;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class EditAction
extends AbstractRelationEditorAction {
    private static final long serialVersionUID = 1L;

    public EditAction(IRelationEditorActionAccess editorAccess) {
        super(editorAccess, IRelationEditorUpdateOn.MEMBER_TABLE_SELECTION);
        this.putValue("ShortDescription", I18n.tr("Edit the relation the currently selected relation member refers to", new Object[0]));
        new ImageProvider("dialogs", "edit").getResource().attachImageIcon(this, true);
        this.updateEnabledState();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.editorAccess.getMemberTable().getSelectedRowCount() == 1 && this.editorAccess.getMemberTableModel().isEditableRelation(this.editorAccess.getMemberTable().getSelectedRow()));
    }

    protected Collection<RelationMember> getMembersForCurrentSelection(Relation r) {
        Collection selection = this.getLayer().data.getSelected();
        return r.getMembers().stream().filter(member -> selection.contains(member.getMember())).collect(Collectors.toSet());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        int idx = this.editorAccess.getMemberTable().getSelectedRow();
        if (idx < 0) {
            return;
        }
        OsmPrimitive primitive = this.editorAccess.getMemberTableModel().getReferredPrimitive(idx);
        if (!(primitive instanceof Relation)) {
            return;
        }
        Relation r = (Relation)primitive;
        if (r.isIncomplete()) {
            return;
        }
        RelationEditor.getEditor(this.getLayer(), r, this.getMembersForCurrentSelection(r)).setVisible(true);
    }
}

