// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Code generated from the elasticsearch-specification DO NOT EDIT.
// https://github.com/elastic/elasticsearch-specification/tree/2f823ff6fcaa7f3f0f9b990dc90512d8901e5d64

// Set upgrade_mode for ML indices.
// Sets a cluster wide upgrade_mode setting that prepares machine learning
// indices for an upgrade.
// When upgrading your cluster, in some circumstances you must restart your
// nodes and reindex your machine learning indices. In those circumstances,
// there must be no machine learning jobs running. You can close the machine
// learning jobs, do the upgrade, then open all the jobs again. Alternatively,
// you can use this API to temporarily halt tasks associated with the jobs and
// datafeeds and prevent new jobs from opening. You can also use this API
// during upgrades that do not require you to reindex your machine learning
// indices, though stopping jobs is not a requirement in that case.
// You can see the current value for the upgrade_mode setting by using the get
// machine learning info API.
package setupgrademode

import (
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/elastic/elastic-transport-go/v8/elastictransport"
	"github.com/elastic/go-elasticsearch/v8/typedapi/types"
)

// ErrBuildPath is returned in case of missing parameters within the build of the request.
var ErrBuildPath = errors.New("cannot build path, check for missing path parameters")

type SetUpgradeMode struct {
	transport elastictransport.Interface

	headers http.Header
	values  url.Values
	path    url.URL

	raw io.Reader

	paramSet int

	spanStarted bool

	instrument elastictransport.Instrumentation
}

// NewSetUpgradeMode type alias for index.
type NewSetUpgradeMode func() *SetUpgradeMode

// NewSetUpgradeModeFunc returns a new instance of SetUpgradeMode with the provided transport.
// Used in the index of the library this allows to retrieve every apis in once place.
func NewSetUpgradeModeFunc(tp elastictransport.Interface) NewSetUpgradeMode {
	return func() *SetUpgradeMode {
		n := New(tp)

		return n
	}
}

// Set upgrade_mode for ML indices.
// Sets a cluster wide upgrade_mode setting that prepares machine learning
// indices for an upgrade.
// When upgrading your cluster, in some circumstances you must restart your
// nodes and reindex your machine learning indices. In those circumstances,
// there must be no machine learning jobs running. You can close the machine
// learning jobs, do the upgrade, then open all the jobs again. Alternatively,
// you can use this API to temporarily halt tasks associated with the jobs and
// datafeeds and prevent new jobs from opening. You can also use this API
// during upgrades that do not require you to reindex your machine learning
// indices, though stopping jobs is not a requirement in that case.
// You can see the current value for the upgrade_mode setting by using the get
// machine learning info API.
//
// https://www.elastic.co/guide/en/elasticsearch/reference/current/ml-set-upgrade-mode.html
func New(tp elastictransport.Interface) *SetUpgradeMode {
	r := &SetUpgradeMode{
		transport: tp,
		values:    make(url.Values),
		headers:   make(http.Header),
	}

	if instrumented, ok := r.transport.(elastictransport.Instrumented); ok {
		if instrument := instrumented.InstrumentationEnabled(); instrument != nil {
			r.instrument = instrument
		}
	}

	return r
}

// HttpRequest returns the http.Request object built from the
// given parameters.
func (r *SetUpgradeMode) HttpRequest(ctx context.Context) (*http.Request, error) {
	var path strings.Builder
	var method string
	var req *http.Request

	var err error

	r.path.Scheme = "http"

	switch {
	case r.paramSet == 0:
		path.WriteString("/")
		path.WriteString("_ml")
		path.WriteString("/")
		path.WriteString("set_upgrade_mode")

		method = http.MethodPost
	}

	r.path.Path = path.String()
	r.path.RawQuery = r.values.Encode()

	if r.path.Path == "" {
		return nil, ErrBuildPath
	}

	if ctx != nil {
		req, err = http.NewRequestWithContext(ctx, method, r.path.String(), r.raw)
	} else {
		req, err = http.NewRequest(method, r.path.String(), r.raw)
	}

	req.Header = r.headers.Clone()

	if req.Header.Get("Accept") == "" {
		req.Header.Set("Accept", "application/vnd.elasticsearch+json;compatible-with=8")
	}

	if err != nil {
		return req, fmt.Errorf("could not build http.Request: %w", err)
	}

	return req, nil
}

// Perform runs the http.Request through the provided transport and returns an http.Response.
func (r SetUpgradeMode) Perform(providedCtx context.Context) (*http.Response, error) {
	var ctx context.Context
	if instrument, ok := r.instrument.(elastictransport.Instrumentation); ok {
		if r.spanStarted == false {
			ctx := instrument.Start(providedCtx, "ml.set_upgrade_mode")
			defer instrument.Close(ctx)
		}
	}
	if ctx == nil {
		ctx = providedCtx
	}

	req, err := r.HttpRequest(ctx)
	if err != nil {
		if instrument, ok := r.instrument.(elastictransport.Instrumentation); ok {
			instrument.RecordError(ctx, err)
		}
		return nil, err
	}

	if instrument, ok := r.instrument.(elastictransport.Instrumentation); ok {
		instrument.BeforeRequest(req, "ml.set_upgrade_mode")
		if reader := instrument.RecordRequestBody(ctx, "ml.set_upgrade_mode", r.raw); reader != nil {
			req.Body = reader
		}
	}
	res, err := r.transport.Perform(req)
	if instrument, ok := r.instrument.(elastictransport.Instrumentation); ok {
		instrument.AfterRequest(req, "elasticsearch", "ml.set_upgrade_mode")
	}
	if err != nil {
		localErr := fmt.Errorf("an error happened during the SetUpgradeMode query execution: %w", err)
		if instrument, ok := r.instrument.(elastictransport.Instrumentation); ok {
			instrument.RecordError(ctx, localErr)
		}
		return nil, localErr
	}

	return res, nil
}

// Do runs the request through the transport, handle the response and returns a setupgrademode.Response
func (r SetUpgradeMode) Do(providedCtx context.Context) (*Response, error) {
	var ctx context.Context
	r.spanStarted = true
	if instrument, ok := r.instrument.(elastictransport.Instrumentation); ok {
		ctx = instrument.Start(providedCtx, "ml.set_upgrade_mode")
		defer instrument.Close(ctx)
	}
	if ctx == nil {
		ctx = providedCtx
	}

	response := NewResponse()

	res, err := r.Perform(ctx)
	if err != nil {
		if instrument, ok := r.instrument.(elastictransport.Instrumentation); ok {
			instrument.RecordError(ctx, err)
		}
		return nil, err
	}
	defer res.Body.Close()

	if res.StatusCode < 299 {
		err = json.NewDecoder(res.Body).Decode(response)
		if err != nil {
			if instrument, ok := r.instrument.(elastictransport.Instrumentation); ok {
				instrument.RecordError(ctx, err)
			}
			return nil, err
		}

		return response, nil
	}

	errorResponse := types.NewElasticsearchError()
	err = json.NewDecoder(res.Body).Decode(errorResponse)
	if err != nil {
		if instrument, ok := r.instrument.(elastictransport.Instrumentation); ok {
			instrument.RecordError(ctx, err)
		}
		return nil, err
	}

	if errorResponse.Status == 0 {
		errorResponse.Status = res.StatusCode
	}

	if instrument, ok := r.instrument.(elastictransport.Instrumentation); ok {
		instrument.RecordError(ctx, errorResponse)
	}
	return nil, errorResponse
}

// IsSuccess allows to run a query with a context and retrieve the result as a boolean.
// This only exists for endpoints without a request payload and allows for quick control flow.
func (r SetUpgradeMode) IsSuccess(providedCtx context.Context) (bool, error) {
	var ctx context.Context
	r.spanStarted = true
	if instrument, ok := r.instrument.(elastictransport.Instrumentation); ok {
		ctx = instrument.Start(providedCtx, "ml.set_upgrade_mode")
		defer instrument.Close(ctx)
	}
	if ctx == nil {
		ctx = providedCtx
	}

	res, err := r.Perform(ctx)

	if err != nil {
		return false, err
	}
	io.Copy(io.Discard, res.Body)
	err = res.Body.Close()
	if err != nil {
		return false, err
	}

	if res.StatusCode >= 200 && res.StatusCode < 300 {
		return true, nil
	}

	if res.StatusCode != 404 {
		err := fmt.Errorf("an error happened during the SetUpgradeMode query execution, status code: %d", res.StatusCode)
		if instrument, ok := r.instrument.(elastictransport.Instrumentation); ok {
			instrument.RecordError(ctx, err)
		}
		return false, err
	}

	return false, nil
}

// Header set a key, value pair in the SetUpgradeMode headers map.
func (r *SetUpgradeMode) Header(key, value string) *SetUpgradeMode {
	r.headers.Set(key, value)

	return r
}

// Enabled When `true`, it enables `upgrade_mode` which temporarily halts all job
// and datafeed tasks and prohibits new job and datafeed tasks from
// starting.
// API name: enabled
func (r *SetUpgradeMode) Enabled(enabled bool) *SetUpgradeMode {
	r.values.Set("enabled", strconv.FormatBool(enabled))

	return r
}

// Timeout The time to wait for the request to be completed.
// API name: timeout
func (r *SetUpgradeMode) Timeout(duration string) *SetUpgradeMode {
	r.values.Set("timeout", duration)

	return r
}

// ErrorTrace When set to `true` Elasticsearch will include the full stack trace of errors
// when they occur.
// API name: error_trace
func (r *SetUpgradeMode) ErrorTrace(errortrace bool) *SetUpgradeMode {
	r.values.Set("error_trace", strconv.FormatBool(errortrace))

	return r
}

// FilterPath Comma-separated list of filters in dot notation which reduce the response
// returned by Elasticsearch.
// API name: filter_path
func (r *SetUpgradeMode) FilterPath(filterpaths ...string) *SetUpgradeMode {
	tmp := []string{}
	for _, item := range filterpaths {
		tmp = append(tmp, fmt.Sprintf("%v", item))
	}
	r.values.Set("filter_path", strings.Join(tmp, ","))

	return r
}

// Human When set to `true` will return statistics in a format suitable for humans.
// For example `"exists_time": "1h"` for humans and
// `"eixsts_time_in_millis": 3600000` for computers. When disabled the human
// readable values will be omitted. This makes sense for responses being
// consumed
// only by machines.
// API name: human
func (r *SetUpgradeMode) Human(human bool) *SetUpgradeMode {
	r.values.Set("human", strconv.FormatBool(human))

	return r
}

// Pretty If set to `true` the returned JSON will be "pretty-formatted". Only use
// this option for debugging only.
// API name: pretty
func (r *SetUpgradeMode) Pretty(pretty bool) *SetUpgradeMode {
	r.values.Set("pretty", strconv.FormatBool(pretty))

	return r
}
