; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
;
; Verify that wcslen calls with a constant argument of a nonintegral type
; of the same size as wchar_t or bigger doesn't cause trouble and is folded
; as expected.
;
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

!llvm.module.flags = !{!0}
!0 = !{i32 1, !"wchar_size", i32 4}

declare i64 @wcslen(ptr)

@af = constant [2 x float] [float 0x3FF3B2FEC0000000, float 0.0]

; TODO: Fold wcslen(af) to a constant.

define i64 @fold_af() {
; CHECK-LABEL: @fold_af(
; CHECK-NEXT:    [[N:%.*]] = call i64 @wcslen(ptr nonnull @af)
; CHECK-NEXT:    ret i64 [[N]]
;
  %n = call i64 @wcslen(ptr @af)
  ret i64 %n
}

; TODO: Likewise, fold wcslen(as) to a constant.

%struct.S = type { i32 }
@aS = constant [3 x %struct.S] [%struct.S { i32 2 }, %struct.S { i32 1 }, %struct.S zeroinitializer]

define i64 @fold_aS() {
; CHECK-LABEL: @fold_aS(
; CHECK-NEXT:    [[N:%.*]] = call i64 @wcslen(ptr nonnull @aS)
; CHECK-NEXT:    ret i64 [[N]]
;
  %n = call i64 @wcslen(ptr @aS)
  ret i64 %n
}
