
import { dirname } from 'path';
import { insertContentIntoFile } from '@joplin/tools/tool-utils';
const allCategories = require('@joplin/lib/pluginCategories.json');

const updateCategories = async () => {
	const buildScriptPath = `${dirname(__dirname)}/generators/app/templates/webpack.config.js`;

	const possibleCategoriesJson = JSON.stringify(allCategories).replace(/["]/g, '\'');
	const possibleCategoriesLine = `const allPossibleCategories = ${possibleCategoriesJson};`;

	await insertContentIntoFile(
		buildScriptPath,
		'// AUTO-GENERATED by updateCategories\n',
		'\n// AUTO-GENERATED by updateCategories',
		possibleCategoriesLine,
	);
};

void updateCategories();
