/*************************************************************************
* Copyright (C) 2021 Intel Corporation
*
* Licensed under the Apache License,  Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* 	http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law  or agreed  to  in  writing,  software
* distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the  specific  language  governing  permissions  and
* limitations under the License.
*************************************************************************/

#if 0

#ifndef IFMA_ECPRECOMP4_P256_H
#define IFMA_ECPRECOMP4_P256_H

#include "owndefs.h"

#if (_IPP32E >= _IPP32E_K1)

#include "gfpec/ecnist/ifma_defs.h"
#include "gfpec/pcpgfpecstuff.h"

#define BASE_POINT_WIN_SIZE (4)
#define BASE_POINT_N_ENTRY  (1 << ((BASE_POINT_WIN_SIZE)-1))

#define OPERAND_BITSIZE (256)
#define LEN52_P256      (NUMBER_OF_DIGITS(OPERAND_BITSIZE, DIGIT_SIZE))

/* P256 affine point */
typedef struct {
   BNU_CHUNK_T X[LEN52_P256];
   BNU_CHUNK_T Y[LEN52_P256];
} P256_POINT_AFFINE_IFMA_MEM;

extern const __ALIGN64 P256_POINT_AFFINE_IFMA_MEM ifma_ec_nistp256r1_bp_precomp[64][BASE_POINT_N_ENTRY];

#if !defined(_DISABLE_ECP_256R1_HARDCODED_BP_TBL_)
/* clang-format off */
/* Montgomery coefficient R = 2^(6*52) mod p */
const __ALIGN64 P256_POINT_AFFINE_IFMA_MEM ifma_ec_nistp256r1_bp_precomp[][BASE_POINT_N_ENTRY] = {
    { /* digit=0 (1,2,..,8)*(2^{0})*G */
        {{0x0008905f76bdc7b5,0x0007bd418a9143c1,0x000c475d568abc1f,0x0009a701075ba95f,0x00003d1f32c8b4b9},{0x000571ff18aafa5c,0x000f757ce95560a8,0x000434a7e54432f7,0x0002797258b4ab8e,0x00009df870e37032}},
        {{0x0006bb32e5348a6d,0x000d9d410ddd64df,0x0000ad784f985075,0x0008a23d9aa6ae3c,0x00001fb0f13f1e58},{0x0008c57751832101,0x00047d361bee1a57,0x000b725df8a6ac15,0x000e32cbe152cd7c,0x00008c240484bd0e}},
        {{0x0006936a3fdd92de,0x00061904eebc1272,0x0009e1ea17bc2219,0x00038de98b027f84,0x0000be1daceb9daa},{0x0005f06a2abb7836,0x000261fc983a7ebd,0x000c327193eff4d4,0x000b6b38e583e47a,0x0000315e09d4065e}},
        {{0x00077362f599237a,0x0003b0d46918dcc5,0x000d6eb05e7ddb8d,0x000ec90f24650a6e,0x0000604e8ac3b74e},{0x0004b14c39d10c04,0x000ee4ce4cbaba68,0x00017625a80d5c8a,0x000d1ce2e1762847,0x00009cb7c6eea514}},
        {{0x0009079606520cb9,0x000d1aec45c61f5c,0x0009cbb1bd776c0e,0x0006a090c90ec649,0x0000ce1d21d8a47e},{0x0003a076bba1725f,0x0003c4ae7ba4f107,0x000f724b117049be,0x00007c06873c568e,0x0000d1631291cbdd}},
        {{0x0003074b59672881,0x000c6373e77664a1,0x000f2165a2e4d910,0x000ef22ad55ae744,0x0000cd292bcbc0f3},{0x0004c9916deed188,0x000da20d377e44ba,0x000309358347a501,0x000921711299c2b5,0x0000cd3e2ccadf00}},
        {{0x0003ba5119d6cc8f,0x000a64ea0173b4f1,0x0003be81afdd3079,0x000572c082bd2021,0x00001db750e89b35},{0x000aedd9165911e1,0x000ef303f5b9d4de,0x000172b8a2c6cf35,0x000b760956742f2f,0x00007d5db743c61e}},
        {{0x000763891f69c8ac,0x000a0d19499a78fb,0x0004b837ab35be28,0x00064506b462ab5c,0x00002c41f6130b86},{0x0006ec12f2cdf2f2,0x000b1a9532d49775,0x000d78b2a72327aa,0x0006dc9f021e3327,0x00006889435a91f0}},
    },
    { /* digit=1 (1,2,..,8)*(2^{4})*G */
        {{0x0004d63c80e5d9f3,0x00018650bc6fb805,0x0004eb27f1ea9ab1,0x000aa02495882e07,0x0000a466f2e5fb46},{0x0004edf7b266ddd9,0x00042d652a23f9b6,0x0008e61d6dd58c13,0x0007a359e3670c31,0x0000d257b443894a}},
        {{0x0009227077a277a3,0x00059cfc5e3a3d83,0x000c07576f48364e,0x000355e97befd904,0x00001c25c29ce15c},{0x000231d792f7c39a,0x000a46ddbef42f56,0x0003e5d8c175121e,0x000d694407e449b6,0x00003711285e87b5}},
        {{0x00084039030f437c,0x000c53077adc612c,0x0008f397ca9d5bf0,0x0004489bda749652,0x0000af611eeda45e},{0x0005efc7e9c72224,0x0007b66175adff18,0x000b31e8fdcd72d3,0x0007b51e30b26d7f,0x0000abe9a851e48b}},
        {{0x0005fb8394ec96bc,0x000daf305968b809,0x000272a3f024eed6,0x0002f6201380a091,0x00005bd44243eed6},{0x000967204437eb69,0x000fc1280edfe2f2,0x000966478f3e6250,0x00056e2f88f726bb,0x0000b48e94ed5c40}},
        {{0x0000bfffc5132382,0x0005a0752b3e584c,0x0007f5386a673608,0x0005a637335ff9aa,0x0000ee72d7a3789f},{0x000995919cce62b7,0x0000b2a1d49c6052,0x0005898b5a5e55c7,0x000be3d281b037d7,0x0000fcf783c6d6c3}},
        {{0x0001eddf7fe28eb9,0x000d42333e12b701,0x000b07ef531b9d9c,0x0002d7c4d6d490a4,0x00008ce594304c88},{0x000f2a78b36344a4,0x000df28d87fd1d83,0x000cbdd7df5fbadb,0x000e518a2fd2f4f8,0x00002427ceb81118}},
        {{0x0001704d00faa90e,0x000f7760a99cbca7,0x00059333dbf16feb,0x00089ac0c94e258f,0x000067cee41b4c7d},{0x0005000c252c9746,0x000650ef88b8b706,0x000e5b0ea5e2af00,0x0009f378056feb92,0x000066ae9a8c4350}},
        {{0x000d311f2cf406c5,0x00006817a2ad62aa,0x0008ff31e0276fbf,0x000a6d8b57ef2b6b,0x0000437e1f6177bf},{0x000a38d321e63954,0x0002c87c2ff3b6df,0x00023c3f61ddd141,0x0009d5d38b46feaf,0x0000a9e4aaa74b8f}},
    },
    { /* digit=2 (1,2,..,8)*(2^{8})*G */
        {{0x000c3da1963d1b37,0x00058fa696946fc7,0x00083d8e03d70b52,0x000d8231550fbc6d,0x0000c23f1ad7a853},{0x00099d49ebcaeaa8,0x00055b03cfd5d8b3,0x00024f00b2ba1b89,0x000385daa0704b7c,0x00003f881bb6342a}},
        {{0x00042370d35642b3,0x000ce10399492969,0x000aa1fa40e1eea0,0x0002bfcf55b63827,0x00006300726619ca},{0x000dc61f92142820,0x0008f2ee0d985a17,0x000af47364dbdea2,0x0003af2f8192cc64,0x00009a126d8fb59a}},
        {{0x0005d5bbfc230970,0x000353eed4c37174,0x000ef73916a712cd,0x0004acaa59f8240c,0x0000b069410109c2},{0x0004d5e0fcf149d6,0x000f673137fd28e3,0x000f92655f0108ba,0x000ab48f2862ac6e,0x00009efcb3eef840}},
        {{0x000da26e1aec73e6,0x0009be144cc3adda,0x0005da1c14b462fc,0x000697e72d5ffa1d,0x00007dc85a835122},{0x0001c794b1a357c1,0x000661563483caaf,0x00083d98e34b8417,0x000eead3ce6924cd,0x0000cfb7382ae666}},
        {{0x000a786d62a93d0d,0x0002b5c08369a907,0x000a9e9647958a75,0x000519f802990c59,0x000076b05f00e31d},{0x000b2ce9e430d6f9,0x000b4be20ac3a8dd,0x00007f8d434c0323,0x000cdfc6531a2178,0x00009e7647365eaa}},
        {{0x000f3a8f9d8cc3f9,0x00072f38bd7aff18,0x000a8e4721a92651,0x00064b0151b5ee4c,0x00003b792b15a449},{0x000255f53b1b9da9,0x00010c9a0748be7d,0x0004d6d86ce4578c,0x00072ff371d391c9,0x0000702e661ee631}},
        {{0x0008c889de2e32a8,0x000b0d474a861082,0x000fc583d3b1de17,0x0003aa480f8048a8,0x00003ee931e746ba},{0x0001c240230a2d47,0x0001f2eb214a040f,0x0007461ec3244db5,0x0007f2d8ae8c48e9,0x0000149fdf2f3f76}},
        {{0x000c5fe1306bd6ce,0x00056b9eb7926b83,0x0003915e73d8d154,0x00006960bbff88cb,0x000076006a867f79},{0x000daf6b21ea15f4,0x0006ef43764fb3df,0x000733a24b0b851f,0x00086f1f37b5af31,0x000030c22394a5ed}},
    },
    { /* digit=3 (1,2,..,8)*(2^{12})*G */
        {{0x000a20ed2a8c1c6f,0x00041e5ab4b35a24,0x0001abcdbda4db56,0x0003f26801d8b600,0x000004b48afeb9ed},{0x000a24142725a709,0x00053d44fec01e63,0x000c6ddb3c8679c1,0x000868efd3ed7ddc,0x0000203192c73ce6}},
        {{0x00058ae74fac8317,0x0008162d5d721d5b,0x0002a648ba32d37d,0x0001fb6a40c3357a,0x0000d41eebd7ebce},{0x0007312ec0f21311,0x00009812e6dad6be,0x00010d0c3d9a387e,0x00083b3d8de28605,0x00000e56beae8107}},
        {{0x000fb3a0d6a300fe,0x0006afeaae6ee702,0x0005264f0ff2ccae,0x00093072a78f4cc1,0x000056f1807ed1cb},{0x0002f775e441af97,0x000f83bb25a43ba1,0x000106f6b36db209,0x00000ca2a30bf803,0x0000b4aeb7054ee0}},
        {{0x000161957d933aea,0x00028e76e6485b37,0x000b05babd7b6596,0x0000f456d4d3e24d,0x0000ce6abd42c3d5},{0x000aefa7aee9d873,0x0009f83cdb12a6c3,0x0001f36139b52f8a,0x0008e5973bf3fa88,0x0000e7a50e16b447}},
        {{0x000497cd9642f15e,0x000a28037a929a9e,0x000d3566f9270405,0x000ba2d6265601a8,0x000064b1d8ef45cf},{0x000a573239e26ada,0x0005e7f9aa5b2f93,0x000f2d605dae4d62,0x000f28430e5faa3f,0x000025c3e2fb5346}},
        {{0x0009b7e2c88699d1,0x000576bd17c24093,0x0003296e6ad3635b,0x0005cb70f2c4e479,0x00000b645230e891},{0x000c2f42b8f4bf96,0x0005122d096f4a9c,0x000af2a6a3deda09,0x0006383116861aec,0x000032eb61a73777}},
        {{0x000707b18213a914,0x000b751d0a917b49,0x0002b19247af2039,0x000f9e2b6c2cfa3f,0x0000392f6ab1c9d5},{0x00021fa98a0d29bf,0x000e272d5f8b10d2,0x00052db4aaa0a8d8,0x0006faa92fd30783,0x00006bd9fc3c53d0}},
        {{0x0003f63771beff8f,0x0006f623b36f9fd2,0x0003d9eb684ebab1,0x00084f3ef26543b2,0x000096ae77bc2ed6},{0x000fb89d795ff65e,0x0007796b6a1142e5,0x0005d3a20e91b4d9,0x00011bfd55ea6aac,0x0000a386dea94493}},
    },
    { /* digit=4 (1,2,..,8)*(2^{16})*G */
        {{0x000564bade8d111c,0x00049fce3779ee34,0x000d77e4a2bf81f0,0x00017327ae00e7f9,0x0000f7675150c393},{0x0007f7ccb1668c80,0x000b12ac4708e8e4,0x000b5f26ce2e2a59,0x000dbcb9f4f5725f,0x0000c707f408fcd6}},
        {{0x000dbde4ac826d0d,0x0007c0361a341c13,0x000fcf3f7c95b3aa,0x000c6246c3604dc5,0x0000ce46d1be3f02},{0x000f0d1f30affc92,0x0006a5d1c7eef696,0x000562423070d98e,0x0003f8fca5889680,0x00003b45ef942f70}},
        {{0x000c9a9d2168c124,0x000671dbe7a2af37,0x0008d31cad5154da,0x000c67297ec51caa,0x0000f6a5ba0129fa},{0x00003937564cf036,0x000ae4f6ef5f0145,0x000298d331a9ca83,0x00051e01e8abcf41,0x0000803532cecc34}},
        {{0x000688350470c6e0,0x000970977f7195ad,0x0006d7634e8b89f8,0x00088212d8ec8616,0x000043845130a44a},{0x000f5c2ee645cfc9,0x0005bf8309004c28,0x000584a3ba78a88d,0x0005275a4a96e4b7,0x000038c353982c77}},
        {{0x0006877b288e2940,0x000f33959145a65f,0x000803b8e80eaf37,0x0006112a0cd9bc36,0x0000b81a72e0ba9f},{0x00040fa5a0fd54f6,0x0008b9bf5cbdb258,0x000859f95ca88625,0x00044185f2a4fd1d,0x0000bbdb6fce4677}},
        {{0x0000d8b2dae7ca94,0x000fcb36b0cf82eb,0x0005753d030cfdc3,0x000d1805a6438d24,0x0000a53ea3da217e},{0x000afa8c8dcb9f12,0x000c8dbd9184c4d2,0x0005ce430ce88936,0x000756b473dbb18d,0x000096aae294c905}},
        {{0x000dfe0d903a457a,0x0001207e3533d77b,0x000970360f08ec9b,0x000e84aedd7222e6,0x00008819a858ad52},{0x000eb874ec49378f,0x0000bb61d056605f,0x000587efe032d6ae,0x000c3fe8ca9ea9df,0x0000fbcf08ae31fe}},
        {{0x00022a049341c337,0x00033a9bd7638026,0x00000306390eab7d,0x00022f7c4c21486a,0x0000d141475b8b86},{0x000540cb1b1be032,0x000da9dbb7a8ee0d,0x000b96c0e3c063f7,0x000de42ecdc2ed3b,0x0000397c62c0f6ec}},
    },
    { /* digit=5 (1,2,..,8)*(2^{20})*G */
        {{0x000e6e2135aa3e34,0x000406a584c5e205,0x00015b6e4efffd6a,0x00016589b267e4ea,0x000028a50a289a0f},{0x000fef4e6229a8b1,0x0001b6a8c8f936e6,0x000445d2f37ab589,0x000b64a868af84d0,0x00002d1d526d0d0a}},
        {{0x0005c78880bdb670,0x0001f09257226088,0x000a8d556d463880,0x000fe87ac131260d,0x0000a978da1cbb3c},{0x00081d1c0fbab2fc,0x00085ffc3bdf24eb,0x000b3da6a9989162,0x0009b73405bff75c,0x0000d9387ea82fe6}},
        {{0x00091ae46f2b2572,0x000703d442a8ad11,0x000ced9edcf5c7ca,0x000e533e5c3816a7,0x0000d4bbe9bb1cb0},{0x000a4a73efeed78e,0x000f18700611c5bf,0x000704c62558948e,0x00091cb5283171ed,0x00000228300708db}},
        {{0x0002b79aff1b7640,0x0003cc8f43a730f8,0x000bb0f3be0fe168,0x0008ce40be89b6f3,0x0000da60e29a2a91},{0x000b662498ee8663,0x000c556962fe5de3,0x000b255f6d5a6808,0x000a245580c590ad,0x0000e4d2e7887b5b}},
        {{0x00031ec55d438d92,0x000bcd082dd1b6ad,0x000794983e52056e,0x000cfd8aa5783a13,0x00009f94d2983cbc},{0x00042b80509ea4d5,0x000fe3f8e9a76414,0x000cc5621e2a00e9,0x000e39f93625453e,0x0000b6fe3802944d}},
        {{0x000414582cf35827,0x000a80d6c39765a2,0x000d882871de9e8b,0x0003d1450a2db3ac,0x000046f7d2fddbd8},{0x000672303b75f511,0x0007abc60eee9a8a,0x0001cc28700717f7,0x0003de4d554c79f0,0x00009aa79fb6b0ef}},
        {{0x0006940f54c45508,0x000502d3bfab839b,0x000378f6cb89828a,0x0002513c392474e0,0x0000cd44686f1550},{0x000e788bf3109a0c,0x00082f2f2759f255,0x000948a168d333d9,0x000b6b7459dd9578,0x0000c7da7b3800f6}},
        {{0x0004ff052f5917b5,0x000faa8719c05631,0x000ca760c26fde52,0x0005d57d3cd8ad2d,0x0000bd74588b7072},{0x0006ad71d02a024a,0x0003acf3e2d65208,0x00078da16339cd4e,0x000f011987ebdf0f,0x0000079790c922a9}},
    },
    { /* digit=6 (1,2,..,8)*(2^{24})*G */
        {{0x000f5d55f460757a,0x0004ec4868af75df,0x000e466b71f6795b,0x0000c72b0d7325cf,0x0000e10c5f3da26c},{0x00094ad8a7522d79,0x000cc411977a0ee8,0x0004e8d5601f6c03,0x0001e3b955085c4c,0x000028f635d618a7}},
        {{0x00066010689e1641,0x000f3b22c11bb373,0x000db6ec643ab5eb,0x000afb15d2d0366d,0x0000ab615f997250},{0x000b5f7e8a49c22d,0x000402c68d7b6d44,0x0008c124aab7be0b,0x000a684eea8f74f0,0x00006ee0d7c27a2d}},
        {{0x00079739f7318d32,0x00027b21994ef202,0x00093bf3a921a053,0x000dc5e102a653b6,0x0000417acbe360fd},{0x000b40cff123155f,0x000073c8b799336a,0x000c74fb67fa3a8f,0x000c69c2dfdfdf14,0x00008baaad38eb7e}},
        {{0x000984d8c0756da9,0x000f60b879fbbed4,0x000691183fa97cc8,0x00008c6450ff0ae8,0x0000bc7e3aa798e1},{0x0002c0087c8490da,0x000bba6d21008f03,0x0000075a13ccfa3b,0x000db76f329bd54a,0x0000cdfd68fa494d}},
        {{0x00075553bbd18331,0x0005fabfbaf50a55,0x000b10f8b3952494,0x000f37f05df55e76,0x000083667f4aec1f},{0x0001b91149c64f10,0x0006ca3553afa736,0x000beb9cb1077179,0x000ef4d35315f3ff,0x0000724cdc42e0e8}},
        {{0x0009f8db144f77e9,0x000026662b5f3af3,0x0000d0c25c1ff887,0x0007b73b1cefab56,0x0000cd5a1cf3f9ca},{0x000d5a818694755a,0x000725b3c61bfd60,0x000d33c6e57d6b39,0x000d8c2c2a5a4d41,0x0000da06aa84668d}},
        {{0x000633d510319630,0x0000a4956f908239,0x000fdde9a26b1a49,0x000f5c760ba0f507,0x000011a47fccb3c1},{0x00074a4f6a780782,0x0003543b8c9de617,0x0003e69cf7b58be5,0x000c69ab2b475125,0x000059a05b225efc}},
        {{0x00041b32e5ee0cd0,0x000bea601799a527,0x00014451f66c2b00,0x000f25a7ca20cec4,0x00001caa549ccc91},{0x000641caaadc47ea,0x00097814eb57d471,0x0004006d25c11bc5,0x000a4cb887a2d0ed,0x000005cf797f0540}},
    },
    { /* digit=7 (1,2,..,8)*(2^{28})*G */
        {{0x000cf9a2f2b6ddb7,0x000cb4f20151427a,0x0005e5495f13c8bb,0x000336c57206828b,0x0000deb474abe52a},{0x000c630fc54290e0,0x000e9da279153564,0x0006b3bbef1e9949,0x00021a8e27e0734b,0x0000614b2885f690}},
        {{0x0004ab68d7e959ee,0x000227a1ac2703b2,0x0008471ceedd9bdd,0x00080ded1b49258d,0x0000011c8d9a06d3},{0x0000b360f8d06cf6,0x000bfd4734e59d08,0x000843e26b87ae6b,0x000b0c3b35f8740c,0x0000b6d468726158}},
        {{0x000ac1e3e5d6df58,0x000075d5fa067d1d,0x000ebba6b226d7b2,0x000af82ac4134b57,0x00001bb953caf0cd},{0x000cde538c8bc9c2,0x0003669d81fbb26c,0x000be58de047db86,0x0007841e8449ed3e,0x0000d643fef5794d}},
        {{0x0003331d3c69f2bc,0x0000a8da61a76fa3,0x000d96e2379febe3,0x000486b9c598b441,0x0000390a58c27d0d},{0x000cdb9daf4c5417,0x0006d8e298de399d,0x0006c4c6e1a6e0f8,0x000649470cfdb8e7,0x0000690440cf3b0b}},
        {{0x000cd3d0d4027b25,0x000d3c2019f2a596,0x00035e7beba07964,0x000164eddb3ce5bb,0x00000d8037d39488},{0x0000c29968554c2a,0x0009ad6efed021c1,0x000059b49a323da0,0x0003c9c4a09a9f9b,0x0000c0cc53fbad1c}},
        {{0x000c73d2287162dd,0x000c529ed6e82ef1,0x00034977dd25e6f6,0x0004a8aae16f338e,0x0000dc61c21e5eed},{0x00096fe447e4eae7,0x0006a3174a5c8c7d,0x000fa5f9c92267ca,0x0007c117e01cd296,0x000068abc8039604}},
        {{0x00041d6367599350,0x000706e88fbd3813,0x00042818412bda97,0x0005e6bcd02cd4a8,0x0000b40e707676fb},{0x0006fe0a3a3a6e7f,0x000d8fbd238202b9,0x000a1286e09fb174,0x000d4efa0600b4d1,0x00005566cd140a17}},
        {{0x000246780b6116f2,0x00015367f636a38c,0x00064c305dbfeb38,0x0009f998b9f943fb,0x00002a4f058aaf47},{0x000300fadd2ed37d,0x00097156d549fc2b,0x0000ad7686ed0d31,0x00005d713c2953f3,0x0000c01130ae8caa}},
    },
    { /* digit=8 (1,2,..,8)*(2^{32})*G */
        {{0x000953c50eb5331d,0x00069024147519ad,0x000b4d5fade16af5,0x00052cec8d0981ea,0x0000f785b3ffbbf2},{0x00063ebb7f24f144,0x0001dccfd590f8f8,0x000abea80d987872,0x000fa20cf72e9626,0x0000721e8be990fd}},
        {{0x0009fb18a0fee18b,0x000f1f5678a31b0f,0x000d3f9d9d7f8899,0x0002e2896d50301a,0x0000467828ca24c1},{0x000a2f2a98bf1696,0x00042ebe8758851b,0x0005a36a8fac4075,0x000e6fdb71e64e4c,0x00002450761a46be}},
        {{0x000b89a4e82f20ac,0x0005be0e90fb21e5,0x0000601e57b9726e,0x000acbbb500fd2b8,0x0000def3cf863f66},{0x000f548f31add03f,0x0006e3f894407ce5,0x00040ccdd200e1b3,0x00036823ba0025b9,0x000057161113964b}},
        {{0x000379ae15e41fc7,0x0000ca7c35d87949,0x00076fdd0ccf2ac7,0x000135bfd042e655,0x00007cefff827780},{0x000b09f648a49efa,0x000b462fcc9981ea,0x0000c21f3e7dc01a,0x000af6bebaed3d63,0x0000701de9b6b9b9}},
        {{0x000bdcfbd504057f,0x00054d331b85f091,0x000a8cadea75bdae,0x000e6d1fd0f45354,0x00002490dea9fe2b},{0x0000ac8047450e35,0x000f366cd5225391,0x00027062fa6c9f4b,0x000f7bd93fa9d473,0x0000df0d238b6d83}},
        {{0x00004675e9e96a79,0x0009c366d91cd2c0,0x000ada5d7afaf95d,0x000d7678340a2bee,0x000031e43a7d6f3a},{0x000939ae632995b9,0x000f1ff840e446e0,0x000fe0f6e10f4eb2,0x0000641d99f9f258,0x000059714d33363a}},
        {{0x000dac0c56b9c972,0x00003146fc627e20,0x000583ab2dfb01e8,0x000b8d1d5a0569bc,0x0000e9531ed3477b},{0x000c960233998e0f,0x00024b5da590d5fc,0x000311eb725dffaa,0x0003166d0a806780,0x00002e32acfedeb4}},
        {{0x000a823a4160c545,0x000f51222248acc7,0x000eb7e2a9255142,0x00038a9281f6ec0e,0x0000f63c9cc1c2fa},{0x000efe9ed3f2c904,0x0002604e1900a791,0x000aaaefc6a23190,0x00095a14acde09d4,0x00007b2680ab6b58}},
    },
    { /* digit=9 (1,2,..,8)*(2^{36})*G */
        {{0x000c47940a63bdc1,0x000acbe305406dd9,0x000f4115854d7ebc,0x000bf8c8f8eb7dc7,0x0000eebcc0956bd4},{0x00040deabe2974cf,0x0008c5d99b307781,0x00065a6b4bc494d8,0x0005271e325380c5,0x00006c75941c35b1}},
        {{0x0003c3a8ea6b2c0c,0x0005526c49a861ec,0x00051d8b641c7fc2,0x0006ff017024f3b6,0x00006af90c54fe5b},{0x0006848b57a6af77,0x000fe2cb103d4c8d,0x0002bb9428138d50,0x000a1d94a02bc461,0x00005196aa6193cf}},
        {{0x000f0e96b0521716,0x0006bdb1782269b6,0x0008b6894ea0436c,0x000213b53ae34bf7,0x0000f89e64dfb40d},{0x000020f0e5f7aa5e,0x000a41577884456e,0x000b89101dc1c7bf,0x0005074deb3b5688,0x0000322f52afaf0d}},
        {{0x00039b66645c58c8,0x0007a8dbbe5a1a9a,0x000e8d8b5703704b,0x000b790268187fd5,0x000003b8f3f8d5eb},{0x000b2f3a4a4db66a,0x00074ef2d65a8087,0x000f193430cf1f8c,0x000a6ec4c4969044,0x0000c1c8991dfd8f}},
        {{0x000b8888bb33c9a0,0x00038dd0f82b2148,0x0009657b430acfe7,0x0000dfe19460c34f,0x0000b39b6f7347e5},{0x000bf0221449dce2,0x00055dcc07226779,0x0008802bed13455f,0x0001abec610d21be,0x0000f48269445497}},
        {{0x000dd04b97f56424,0x0001d60b7fe7b6e0,0x000a3239f41aa1f1,0x000c4a61e7d16189,0x000064bed27452ed},{0x00079b5499dfb43f,0x000fd9b506db8cc0,0x000ec79d2cb2ca13,0x0009706e65cd47aa,0x00001dff152d73d6}},
        {{0x000aa7cb935a507d,0x000551ae0ac29416,0x0004582b4da3a965,0x0007915d0279b025,0x00008622b071bf70},{0x00035a70c90666d4,0x00051800d37c7a50,0x000730d2e35953b1,0x0006c1b9213380c3,0x00008f95b8909dcf}},
        {{0x0003fba6baaee763,0x000548571ba18615,0x000c7ccd5282a222,0x0004c589348b22d5,0x0000c343e640ecd7},{0x000d50cd542a5f8c,0x000f1f3e5eea7d82,0x00063b79a4045592,0x0000f8e05521c879,0x000038b6e3d1e7a4}},
    },
    { /* digit=10 (1,2,..,8)*(2^{40})*G */
        {{0x0005910a01f9dd2f,0x0003e65533ef2177,0x00044e3924858ec2,0x0004e12677158c7e,0x0000817fb332f9e2},{0x0009f8be4c5579ed,0x000d207cf88577d2,0x0000ba656c829dbc,0x0002850852224525,0x0000a45a5a5d4127}},
        {{0x0006aebf577abd9d,0x00015452133ffd9d,0x0000ac605ac980fc,0x000e4582a39a8b2f,0x00004eec5aa7265a},{0x000045d5cf88aa51,0x00029cb76ccdac60,0x000c15412957a97b,0x000342cd1af4d36e,0x0000e6170f039470}},
        {{0x000f32ef99cc6085,0x000bc4351facc618,0x000d57573622f8bd,0x00097ededbaf2647,0x0000f2cc80070643},{0x00034049491087f9,0x0004f8c7593cbd4c,0x000c3f77e662b98a,0x000634616ed266c5,0x00002b5777286404}},
        {{0x0008c8bf5c4dddf3,0x000e274c005979da,0x0001c17823f45915,0x00004f9f9c2072b4,0x0000aaa1baf4fa40},{0x0001cb9e28458fbd,0x0002855114df14a7,0x000d8bfa4e43521f,0x000189718d4374a4,0x0000a04910e166e7}},
        {{0x000ca7b94abcb8cf,0x0009802094704963,0x000daf2a7eca4d08,0x000247498a489a5e,0x0000e144eefa19d2},{0x0008666e16797254,0x00009682ad636a41,0x0004f075f107c2c6,0x0002fc5436702702,0x0000b46d254bc836}},
        {{0x0002b2a3e2819447,0x000b6350369c8e10,0x0002b729e058e5fe,0x0006e9bab9271aa6,0x00006605f347cecb},{0x000ced0cf5b648e5,0x000fe5f0e2b379be,0x000be9659e2ffbdd,0x0000d1c063d3de39,0x00006c7602acd385}},
        {{0x000aa397878c7fdc,0x000d8ca2a604b3b7,0x0003bfbdcfdab93e,0x0000ba46e56f6518,0x000008070b9ee90b},{0x000ff6976d6bc06b,0x000412a0e01fabc4,0x0004d387028c757f,0x00060b4fe7c6ee8a,0x00005840dd588099}},
        {{0x00032caa306d36d2,0x0007e7903605c397,0x000e2e161f3c1bd9,0x0005b6484f0843d9,0x0000c3ed7e7103a9},{0x0002e9423a811470,0x000527061160170e,0x000b6096786931d4,0x000d933acc32788c,0x000040d7f8af5425}},
    },
    { /* digit=11 (1,2,..,8)*(2^{44})*G */
        {{0x0001682c10b4b42c,0x00049455922ac1c3,0x000c73c31352d93e,0x0002a2bc4a7b3ef5,0x00009c11c3b203bd},{0x000c092172b4577e,0x000a6f04bd55d319,0x00057bacfaff1310,0x0004d8a9db6d1c08,0x0000b14a2965910e}},
        {{0x000910b95bc8d4b3,0x0009d35ea6c39976,0x000a5950529391f9,0x000ac2a3954259aa,0x0000954edcb4e373},{0x000982812f18224f,0x000a61043e09aee6,0x000f3de4d536e4c0,0x000508c61ced56c9,0x000097bf82337dc0}},
        {{0x000fc9cdf0a602a7,0x0000f90768fccfce,0x000cc86be572242c,0x000fb55cef402d37,0x00007fc53399e03c},{0x00038fa2f84181fd,0x0002e72d1669a8bc,0x000b93e529c4e96f,0x000b28a0e33c536b,0x0000c1aea47311b9}},
        {{0x000e413c023b543e,0x000ff931341ed7a4,0x000c597461477da5,0x0006486a44223272,0x0000e62ade1b4548},{0x00073540e59ce025,0x0006c27e17e44ceb,0x00047c7e6d15d0b9,0x000ca71caee86bf7,0x000062dc3b140088}},
        {{0x000bd5ca4b43dca6,0x000b875b2c69dbcc,0x000837ee1021381f,0x000b45c713aa77a2,0x0000a05614cbf186},{0x0006c5c5b213f9f3,0x00065076db476cb9,0x0001c871dd6ccdd0,0x000210116fde15d6,0x00006771cf226ee0}},
        {{0x0001dde5dfbb6e3a,0x000b56c872b4a606,0x0003e4356c3c10e2,0x000cfdbd1ab2a34a,0x0000f1935615b0dc},{0x000bfd9fd4818329,0x000cd219f2275f33,0x0006091fe9776294,0x0002d94aa0750c8b,0x000091bb35d3e4f7}},
        {{0x0009529ca84f2105,0x000db2adb22b94b8,0x0009189807b37871,0x000fd1763993d8ae,0x000032507bd52b7d},{0x0006d1b1faa44f66,0x0007daae572a2530,0x0007fbd06d00887f,0x000f39d58e02b643,0x0000ff4486cf7424}},
        {{0x000977faf2fd74af,0x00010abaf95894c5,0x0006cdf3274ead88,0x00068f58b7b9bdc0,0x0000d28ef6376f5e},{0x000d37fa9f638299,0x000a9ef052c4b5b7,0x0000893d97515b4d,0x0006fb5c79fe87f7,0x0000baaee7122abf}},
    },
    { /* digit=12 (1,2,..,8)*(2^{48})*G */
        {{0x000e4daa4cf03ebf,0x000a5880a750c0f3,0x00031006e436dc3b,0x000d2500539bacfe,0x0000d4ef32a1291b},{0x000a444f665140ba,0x0002db55ffc69ff6,0x000c27c0e1c0d5f3,0x000e2259446f147b,0x0000e26f578ece85}},
        {{0x000392f2ec04cd39,0x0000d5ac3f16ea83,0x000d7f5ede30754d,0x0009b6872115a461,0x00008418a223a967},{0x000fc5ff44240c84,0x00018cde526cdc7f,0x000b22632c3da39d,0x000c70d988e537fd,0x0000709b1f542582}},
        {{0x0007f2ec2dc98f00,0x00016f4bdaedfbdc,0x000fbe8180bfa37c,0x000bc3e1723fd325,0x0000f58d97310235},{0x00064f972387d213,0x0001ff245104b0d2,0x000b879a945ab636,0x00029e80f5f00daf,0x0000fd8b684b4312}},
        {{0x0008d2c9ae428f00,0x0004f7ea90567e6d,0x0006dddb93095522,0x00081903d513257b,0x0000d1ef01808e5c},{0x000ffa707b56bdd1,0x000c2246b29cb44f,0x000c77ce5b30e21c,0x000d3bd42b540a21,0x0000c8f28344b9aa}},
        {{0x000eec41cb82328d,0x00015f3e30bc27ff,0x0009b1972345ec7f,0x000331e0ee5f0c05,0x000087d0ba66f3c7},{0x000ae59616536a6e,0x000025f99d0b09f8,0x000669480fe3c760,0x000e84b31c5d6cc5,0x0000ee121b26c778}},
        {{0x000c41d1ca8f6911,0x000d2f1d4e353b7b,0x00043304ded57d7b,0x000e262fd062d8a1,0x0000c7373014e0c7},{0x000d825d0c68baec,0x000f5e76be77800a,0x000717e2f324cc7d,0x000e0471a71fe8b3,0x00007ed811a51502}},
        {{0x000a2679405d4a59,0x0005c7b39f8868a8,0x0003eba5f06f98ea,0x0008af06ee27f4fd,0x0000bf77a2388b73},{0x000dcc46466ccfdf,0x000bc72fa30f349b,0x0008f8ca8aee594a,0x000b0c7d194c9d9c,0x0000db282f8561eb}},
        {{0x00067b085c91370d,0x000d35b1cb76219d,0x00009adb7621c58b,0x0008dbc100ec0bf9,0x000035a1c37429d0},{0x000539991832fa6f,0x00095595e93a96a9,0x000a66a28b826cbe,0x000e29cb77526c1e,0x0000acab05a94fb9}},
    },
    { /* digit=13 (1,2,..,8)*(2^{52})*G */
        {{0x00096e6d076e5fb1,0x000e067ceca9754a,0x0005a20acc991594,0x000e01fbf426d2cf,0x0000e8ea47274e03},{0x0003439dd70f73cd,0x000dbdd87880e616,0x000581c546fe37f4,0x0004291151554381,0x000076b608169ba2}},
        {{0x000be5a560218c0f,0x0002245983c38b5e,0x000b7795172b6411,0x000736ce6b14f176,0x0000b95d3a653da9},{0x00090806472dd13c,0x000e1cd9f87dc596,0x000392d3ef194f1a,0x00019f6577c595cd,0x000044201d70daf9}},
        {{0x000a4bf3535ca72f,0x000398eadd70482e,0x000990fe5b370e05,0x000e33fef708de92,0x000095e812192018},{0x0004f0f83a164ec7,0x000582c87912868c,0x00052a18313ff9b5,0x000a4bf0ab1b1be9,0x0000846b0bf28b93}},
        {{0x0003043896a03a07,0x0004b381d531696e,0x000fa5c9a5d318fa,0x0004ca8c757201bf,0x00003e9b1ef0bafa},{0x0000bf7978610e72,0x0004fe18555970de,0x0008447619e614fa,0x00020318b8267dfa,0x00002d551502ded1}},
        {{0x00020ab732d47663,0x000a19f16a66e918,0x0000781056db02b9,0x000d5c5eae97f282,0x000094939d8bd05b},{0x000b2c87b6265c14,0x0008af9287144234,0x000a628484fc8c50,0x0002a90cc54ecfff,0x0000ff62b0d3b8d2}},
        {{0x0000f30fee8c3f0a,0x000134286d2e0f86,0x0001ad978fe6de9b,0x0004d1149e592012,0x0000ed2e1530c0e4},{0x0008c9d2519e343d,0x0007006858e6a61a,0x00069709a27ec803,0x00054a1fbce4c776,0x0000b72f3fb5dbd3}},
        {{0x000c5a4b66e99b1a,0x000a6965f5206989,0x000da89d6d7224d3,0x000bf4eb9640631f,0x0000b4e03e0395b9},{0x000436d53d463c5d,0x000f7bf80b6783d1,0x000e25fb34d34e57,0x000cddcb280e701f,0x000018bf1fde0cd3}},
        {{0x0008e7dd3da6ac7a,0x0007068c094dbb56,0x000e7080f6d2bb87,0x00006862db77d062,0x0000957c36387eb2},{0x000c48a3b41f412c,0x0002b40013a5e585,0x0006e05598676e41,0x000588aab2131174,0x0000a5cfa92af35d}},
    },
    { /* digit=14 (1,2,..,8)*(2^{56})*G */
        {{0x000b63b80c17b3a5,0x0009991991724f36,0x000bce681e7aafdd,0x00021571e5eda799,0x0000608a0582bb4c},{0x0001f37958fc7a0f,0x000ed697e5fb5166,0x000a6efe500b7226,0x0002f1da5737708b,0x0000d330af0a0615}},
        {{0x0001d5f271b2ffcd,0x000ce2caa6650728,0x00046dfd327de7f3,0x00027f03178322fa,0x0000216e3f0e2310},{0x00003bbfc59abb34,0x000d842f48027f5b,0x000bd4fb27522c72,0x0007b690faa40cdb,0x0000abded9d9b492}},
        {{0x0002c6f30c43f226,0x0009e180d738ded3,0x0000ae17641d02b6,0x000b5f0756f1a5bb,0x0000e1022d63ad47},{0x000709b3807f334a,0x000c89dd8fffb620,0x0007ad500b84f625,0x000081d766a281b4,0x0000baefeb53ba7b}},
        {{0x000e8143ae4b352e,0x0008432a3326505c,0x00021f9bfe1140f1,0x000adfcfa38d6927,0x000034810d2f90b4},{0x0000bf0d00ef8992,0x0002ffa7e6ab6665,0x000fd1695563a3a5,0x000ad66ed6cd2d22,0x0000bbe464cbfd77}},
        {{0x0000824eeec7168a,0x000ce52877a21ec5,0x0006bed12ba5446b,0x000931ca2300414a,0x0000eeb5b0f5515a},{0x000322d64e381de0,0x0001cecf83cba5d5,0x000840921d7268be,0x000d46dd7f953814,0x00002b466f4b1410}},
        {{0x000bd6a7d881d987,0x000ec843d9325f3b,0x0000379b23abd56a,0x00044afc5a9bef2d,0x00004a3dd4f7b324},{0x00032b0b1e2614cb,0x000de028f61bc0b8,0x000ceba5ab839425,0x00059b798f49085e,0x00003b2eafe5b888}},
        {{0x00020cf3f9601768,0x0005c47f1f0ced18,0x00031285e9324320,0x0008926fa800cc79,0x000017299d89245e},{0x00019c8dbe5b7b2e,0x00054dc1c0f7d133,0x00005341590ca39e,0x0007e40e3ef92196,0x00008544b679b3ea}},
        {{0x0006e673cd25c857,0x000e1717b82b99b6,0x000ce0284257ae21,0x000cd7d6675922d4,0x0000134e48cf8715},{0x00020fa3844dead5,0x00092c4b5f2b89a4,0x0005e6feb94f1d13,0x0001f55da3de9c1e,0x0000bf9802bd31e3}},
    },
    { /* digit=15 (1,2,..,8)*(2^{60})*G */
        {{0x000a6b62d93fdd41,0x00055796424c49b9,0x0007cd56def02492,0x000194a49f888dfe,0x0000f9869f29b9e5},{0x000f96a765fed464,0x0004e6d179483cb7,0x0002157b537c82e0,0x00066411f666f963,0x00007c51bf707ed6}},
        {{0x00083fd5597eef8d,0x000467c051af62b9,0x000a73b96f3d0664,0x000e60da1e9a998e,0x00006cc734074631},{0x000f6191644596a8,0x00018ca65d698049,0x000dcf446dc950da,0x00041ba3b732b22d,0x0000e67d9922451a}},
        {{0x00021487098d3893,0x00021e0bdefdd4f1,0x0005e1525cf8642f,0x000032bc06995846,0x00002ad5c774a21a},{0x00067f595255747a,0x000b83318969006d,0x000e0b7efa7ee217,0x00097c961cb4d73c,0x00007cde45c8bbbd}},
        {{0x00054660dbc8b1ab,0x000d6088cad38c0b,0x000fb6902a066a7d,0x000dc7ca3471b7e8,0x0000e86a1789d644},{0x00095173a8f8b220,0x000fe11a6fd8de44,0x000a5a2626461987,0x000b8a17c44dbffe,0x000097f4a165ced5}},
        {{0x0008066addda0cdd,0x0005a434573eab0b,0x000b19a5f5541137,0x000d0bdfd11570df,0x00000f19e0267d6a},{0x0006506ae95d526b,0x000bfd8f8a3f0b44,0x00099a5c77b8b8a6,0x0006120809e0e489,0x00003bd4cf0ac49d}},
        {{0x000426d74951de36,0x00033f78fca399da,0x00015de0e419f0bc,0x000aabf82fe9e27d,0x0000b79a1cbd8d35},{0x000f1d0d57258a2f,0x0002d02ca81c66da,0x0006f614c6cdf2df,0x0007519ba84fb8d2,0x00009db0a7aaffb9}},
        {{0x000baef6bff2b941,0x0005465352c4b5c2,0x00012d5ccd22674c,0x000b65e5f4926153,0x00005b47a9bf6203},{0x000db83c64adc010,0x000ea6509ed3561b,0x0002da92e6a83a26,0x0008ccc691137023,0x00007a1159393722}},
        {{0x00013e2c380a9bf2,0x000364d391c2a82a,0x00027444dcb0941f,0x00055fbcabcdd486,0x0000ff69ccdcb479},{0x00052b540c86a1b2,0x000a4f04a057a87a,0x000001893b8ba415,0x000c36a44a876550,0x00000e23c958c1e1}},
    },
    { /* digit=16 (1,2,..,8)*(2^{64})*G */
        {{0x000f5e69622c79cf,0x00060c516a0d2bb2,0x000beb03cb372318,0x0004c5d8b0d5cc16,0x0000e18f5d34d82b},{0x000648f91783b808,0x000bf0bf5a01797f,0x000c6a4c687ad85d,0x00067d3523d20b44,0x00009192002a1f83}},
        {{0x0003271e6c831d51,0x00077b8fac61d9a1,0x0002d09fe01d7f5f,0x000a2a4037d25e06,0x000064507e385362},{0x000ea6041214d255,0x00051c0232f76a55,0x000d1178f014410a,0x00037fc788957c32,0x000085a49edcb98c}},
        {{0x000f3338ee1c0299,0x000f84bb5def9961,0x0003040a98f9248d,0x0003ac5761cb69c8,0x000000beb921e57f},{0x00066c038dfaec8c,0x000d10d2f5378a8d,0x00065894c993b6fc,0x000735690acf4c2c,0x00003b9318cab2f0}},
        {{0x000e0341bd6ee336,0x000102bb4d8bc50a,0x0005fb1615b32bf2,0x0005df468181c0b1,0x000049acb4f25f09},{0x0002c9d27e3d254d,0x000f8cf7003e8666,0x000a275ad19d7996,0x00026d7c2f11a6de,0x0000e62e628f9c93}},
        {{0x000a5ff674823c2b,0x0000030614c09004,0x000172a0cbd7525d,0x0008894a1da98d12,0x000030b72f8253fc},{0x000c72e27f2e7888,0x0000eb81d7ea1d7e,0x00029433ef893a49,0x00053356e38cf289,0x0000353f5c728ab5}},
        {{0x000b6b6e1ca760d8,0x0007f19a8afd30bb,0x0007cf16ffb18b25,0x0004823e08679832,0x0000efcafa52751d},{0x0002beaaf58337ec,0x0006f11471f1ff0f,0x0008cb570ffa8731,0x0005ed83ed76c338,0x00004c92081ca03b}},
        {{0x0000aaee181a2a7a,0x000ff32b88756ddc,0x000230d35049ce8e,0x000b74aa4ed4e865,0x0000261c5ca08124},{0x000d55e8ca475a13,0x000dab96c168af3a,0x000f0644ffaace6a,0x00053a1366563c7b,0x00008a47ff05a4d9}},
        {{0x000f835f9d0aad8a,0x000272e523b8bf60,0x000b800dac7dffa3,0x00068eb888009eb5,0x00005af05fd9e53f},{0x00029d4c6fdd401d,0x0000c312afceb620,0x000a13ffebd0185b,0x0006be5b0c797df2,0x00003ac5e2304089}},
    },
    { /* digit=17 (1,2,..,8)*(2^{68})*G */
        {{0x0000b1d093f471bb,0x0006510f5b343bcf,0x000a023f726a643d,0x000ed90df0f2e400,0x00003c3843aa4ab3},{0x0000bb7742e67add,0x0003e95c70816030,0x00093cfe99544825,0x000be16a6e943e4c,0x0000792d7df86acd}},
        {{0x0009c15b35bafc8c,0x000bc1b7bfe71786,0x000dfb7efd32fb77,0x0008ffa7d4e1deba,0x00001f575658ec09},{0x000e07633366d529,0x000ed66368710884,0x000cc4194ecbd474,0x00068764de5e29f5,0x0000a864508101bc}},
        {{0x0002009d82ccc196,0x0002d9731815e696,0x00067adc8a7f6da2,0x000f360af6df9cbd,0x0000fab708e5c748},{0x0008c7c19580ff2a,0x00056d28b898fc75,0x0009d3500789e54e,0x000af3c0972f1eed,0x00002ac6bc3c26f9}},
        {{0x000ff71880242404,0x000f1c7a3e6fced0,0x0005e468a56ae92f,0x0000f9670e8cbbdd,0x0000020c88ed5eef},{0x000f9526f1333efc,0x0008b74bd70437a2,0x00018a76b379190f,0x0004cd66e5fb3289,0x0000132085c0e1be}},
        {{0x000708697faad111,0x000b805a8271d7e9,0x0004c1dd178bfc81,0x000c149eb4735dfa,0x0000d2f552ec6eb2},{0x00048ef153d6518a,0x0004b40bfcc9a0be,0x000c00e5e2afad26,0x0000f1ea67b27e01,0x0000122effb0b8f9}},
        {{0x000484026aa4c38f,0x0009f8c0aeaa3c09,0x000e1764589f8c76,0x000e5ee3a89f46d9,0x000024e2c82b5288},{0x000f97b2a763d952,0x0004d8a87d83b5f4,0x000662574fedee3c,0x000e6c8cfdb2220d,0x00008ad1e213c69f}},
        {{0x000601630c24de4a,0x00030c2c880e5cac,0x000dc7106144a7e1,0x000995cbf8299dbe,0x00009f1a04b80eea},{0x00081b8f5e3ca421,0x00098fb79e7f8ea9,0x00075c1ae32a9ecf,0x00091361be448bba,0x0000009a3ed31173}},
        {{0x000edc4d24ff34d2,0x0005e5192c4d6840,0x00056736a2a84199,0x00067dc208b04d72,0x000091aa355f1170},{0x0000b62c6dbea762,0x00084bf854279005,0x00058b53b37ca64b,0x000f4906c3de8129,0x000017420c7a1978}},
    },
    { /* digit=18 (1,2,..,8)*(2^{72})*G */
        {{0x0004645d0c999206,0x000f55ed005832ae,0x000aac9fd1427420,0x000def2ca5f5efd3,0x0000d8417da6ba53},{0x00015bfe3a91ab48,0x000ad8bc9001d1f8,0x000bccb573cb03eb,0x000ed588452c8f0b,0x0000190d99ea9851}},
        {{0x000f6928ec987520,0x0001acce548b37b2,0x0002556adc5cbc76,0x000befb4fb38e754,0x0000e6f549a164e2},{0x000cbaf6791e178f,0x000242386ce6c413,0x0004d3f2b753e67f,0x0009e6bf901be1c5,0x0000fea1ab006e2d}},
        {{0x000afcbcddc5b4e3,0x0003f6ad7ab9a2d8,0x000cf2fe2c7a8c98,0x0009cf5c29c00090,0x00000a465e1b5bc1},{0x00039efc04140b7d,0x000aa29e99d043b6,0x000b4b1d9836432d,0x0007aac35ef51263,0x00007f50574f8f0c}},
        {{0x0003b25760e88423,0x0009b7d341d81dcf,0x00083e622c18ffb5,0x0007e4badcddb688,0x0000becf33dd410e},{0x0009a60cc895ade5,0x000e3f6a7a73ae65,0x000e082fa7baab21,0x000f729bc83879a5,0x0000c301b48a24ab}},
        {{0x000f2386acf8a72d,0x000604ac3b819900,0x00028ee94251e622,0x0000cfab91cb8372,0x000019e78eaae4da},{0x000f8063ac90f7e0,0x0006d1eb32912137,0x000dda25c7380214,0x00046a9e3a2f82b2,0x00002b889ab4a768}},
        {{0x000a78b173431ac6,0x000037c593710000,0x000074fceaa51d30,0x000c0a565e1c48c7,0x0000087805015262},{0x00044c6adeb5098c,0x000f59dbcc8ad945,0x0006844fc921b6d7,0x000aaf80a70dc04f,0x00009ea6e278d5f1}},
        {{0x000cf86624af5d13,0x000f4cf02ff6072b,0x0008cde126b78788,0x000985309a47d2ca,0x0000c4b1abc9fa46},{0x00028fb8b07c6947,0x000bf87aa9e5cb6d,0x000144b063bc3aa2,0x0003ccd35c98124f,0x0000562b62f1af58}},
        {{0x000915ee22d46e27,0x00009b665c7322db,0x0000faabc5d86f27,0x00004cf85cf12cc0,0x00003fe2633a632d},{0x0000a1c1ed8106c2,0x0002e3ba317db248,0x000897173dd719f7,0x000cd0e5087dec65,0x0000d47fab598e63}},
    },
    { /* digit=19 (1,2,..,8)*(2^{76})*G */
        {{0x0002aabc59c94f12,0x00095b397acf4ec2,0x00003bfdf9e674d3,0x0004780850426c40,0x0000ca04d6eb4c85},{0x0006908d03fd22f0,0x000814c5f5942bc4,0x000db3a0f5e9bc06,0x0001e62ba9a6168b,0x00006bd8a9096113}},
        {{0x00009d21104a01b4,0x00024745a1251fb6,0x0008668a04b75ff4,0x000fe349e967747a,0x00006e02c0c6d4e7},{0x000084a333d89913,0x00059a82fe122271,0x0005f3a1a369f264,0x000fa053caf9b5b9,0x000022f6b350187d}},
        {{0x000f36cba7ccb6b8,0x000008210395755c,0x00038f8b13d90150,0x0003ea696117ce63,0x0000c5fc7ad16c23},{0x000e0dbb58d94e9b,0x00051a9a40ebf884,0x000f65c5c2b999f2,0x0006d5effe6ec1bc,0x0000b7559295f5ad}},
        {{0x00048ff65b341317,0x0008233aed1d1f71,0x00033bc63a356251,0x0001b22cf566eaff,0x00007f53d3789579},{0x00086fa303582c2a,0x0005fd4cf94cf0dc,0x0003899cb5afac02,0x00035800d319bec8,0x0000afb9e2fd22fb}},
        {{0x00033425fb22b5b2,0x000c99c7ea2ee345,0x000bb698147612e7,0x00068f17a3fd0d94,0x0000828ad54f2117},{0x000657e7e87abddd,0x000bcc3810156e0e,0x00034a697c600213,0x000a648420ea020e,0x0000d279bdaf20cf}},
        {{0x000f31d817bed07d,0x00055ab5c8b06d5c,0x00022f1cd42f3db3,0x0009efa79b1a785a,0x00001ca931baa4c5},{0x000b66d8a740682e,0x000d06a15d7dc85d,0x0003d89a928be329,0x000b486c72f132b0,0x0000478e55d53bd7}},
        {{0x000bb6e6b0a9a305,0x000098b593d070f7,0x0005d69e7bacb02a,0x000d6fe994375751,0x00009b830bfbf6b1},{0x000cb4666d9987a2,0x0001462334c0922f,0x000e103fb50bd914,0x0006b82023df631d,0x0000f49e7f2f57df}},
        {{0x000e23139482dcb9,0x0001ee1adc1696fc,0x00023caa5f3be88a,0x0003ebb3598ebe59,0x0000801aabeabc49},{0x000560a9c8a8fda0,0x00082d4db067df91,0x0005b59ef1377a4c,0x0000329c198dda09,0x00005daf596bd7b8}},
    },
    { /* digit=20 (1,2,..,8)*(2^{80})*G */
        {{0x00064232b86345c6,0x000491cf1c367cab,0x000b12cd89c580bf,0x0005b4a329bc85a9,0x000061507757ea7e},{0x0007fbd8ddb9611c,0x00062b0167dad297,0x00011cbbb1d53bf6,0x000c8188b1604f30,0x00001f4d0fd7d22e}},
        {{0x000eb572d99661c4,0x0008402fcf0a7fd8,0x0008c5d33d449b8f,0x000f0f09842fd078,0x0000da7983de9402},{0x00076f6bdb01f785,0x0001f4c4d194a88b,0x00090292128bdeab,0x0009129fcd2b63fd,0x0000ebc377dfedf6}},
        {{0x0009a1904af269a5,0x000ee2c68af43eec,0x000da69b7072b08d,0x00046bcf55502468,0x0000f80ea4ac443d},{0x000a17081f1c5679,0x000da8d470c56a4f,0x000e1f2684ceb758,0x000ba15f3159abc5,0x0000964c76954003}},
        {{0x000943b9b2fa6dc9,0x000e0b2b4b4b67c8,0x00005ebe4c512574,0x000128fd8c1d10df,0x00006e0e8ebb49c2},{0x000b34a5656dfc03,0x000d6143b3def048,0x0001c1b2d09a22f2,0x000c08d4085ab3aa,0x000060432732650d}},
        {{0x000d702cfbe0903e,0x0006ef88e2f7d902,0x00074a4e05d17b88,0x0005b20e9fdbf33d,0x000010bd286ddbf2},{0x000dd0fd8fb34fd8,0x00013db85c88ce89,0x000b8030d8880391,0x000235bac23a3ce3,0x0000fa45c03bfea3}},
        {{0x000be6868dc83e03,0x0005e0798fa7aaac,0x0004248d23c0ea74,0x00098ae9b41209ee,0x00003cedae7fcc2a},{0x0000a5ccc7b9ebec,0x0005fdc32c04dd3e,0x000def4916cf5e80,0x0009ad4cfa6c35fa,0x0000a98de7d24b36}},
        {{0x000fd321053b8bde,0x00015a36fa6110cc,0x00012bc0351a15e4,0x000cb742b74fb1eb,0x0000cad7c54d4248},{0x000d56251a7ec868,0x0001ca2cc80ad571,0x00056953911caea0,0x0002c80cd7c27fc3,0x00000a95d3fdd32f}},
        {{0x0003858b5c81bd3f,0x000d2a9431dd80e8,0x0009efaae17d3682,0x000f67830eb7c7cc,0x00002f1f3290cd4f},{0x000990a639034a2c,0x000a593b6251d5c7,0x000299c23319bc02,0x000b194511cca1fd,0x00006f501add6b8d}},
    },
    { /* digit=21 (1,2,..,8)*(2^{84})*G */
        {{0x0006beb87707b7a2,0x000c72a87dec0e16,0x000d90f4e489ddf2,0x00017feb5010ded8,0x00009f1c146a514d},{0x0002ae989277487f,0x00076313476cd0e8,0x00052ddea0b6d98f,0x000ff20c6a63d0e6,0x0000d40ea3d516db}},
        {{0x00019c667d0d91d1,0x000e8105ca7d8669,0x0001a93ed4b79dc6,0x00058efbc582967e,0x00007205a3aecabf},{0x000187f1f85aef05,0x00012b160f5dcd7b,0x000f2c42bbc43ffd,0x0004562f5ec697b9,0x000026b5000648eb}},
        {{0x0000d41a77c52336,0x000441d214aeb181,0x000c6340187fcbdb,0x0006e6ac41506af3,0x00003b6fa4818220},{0x0006bdb65cf1fb29,0x0003ce4a84bde96b,0x00083b4cb3bfaea2,0x0008473e742f060d,0x0000fba067aea100}},
        {{0x000b6c2d46254ea3,0x00039b6ec7fae9f1,0x0004d44a4114c60f,0x000f5ba52995f271,0x000066e8cbd34843},{0x00062c42a011d210,0x0000c318129d7161,0x0000f32c7f0a2090,0x000229f63b03909f,0x00009687ec5c5909}},
        {{0x000507db0a04df74,0x000af43753b9371c,0x00099a17c1cd2a88,0x00066679629cab45,0x0000a296edbca1ad},{0x000519b397e39c16,0x000e052af036c326,0x00079fe7dac46a92,0x000efcd5086f0cc7,0x0000bf3f8cd63cc7}},
        {{0x00042e43a80c6fad,0x000b1ef9c053df72,0x00078ed2a6c7dc5b,0x000da22fb8de25b3,0x000063c34563eabb},{0x00066648e3f185ac,0x000a5f4dd6f958ec,0x000f2dde11a9f374,0x00087dd496925a77,0x00007412068d6cf7}},
        {{0x00005e399e662c0f,0x0000a57173e460c5,0x0004e0120bf24c7f,0x000f062621bbbce7,0x0000fbd676e31f74},{0x000bef99ec94a32a,0x00023cb57797ab7b,0x0009ae3d0efbd3a0,0x000900cc160ad35b,0x00000124b141f449}},
        {{0x0007c8bdf49d7f19,0x0007df31711ebec8,0x000f46d03fcfcebc,0x00035281f2da40f1,0x0000aacf4dcfdeba},{0x0004907c5d800621,0x00068e3c2eef12d5,0x000ae7e3f5965a34,0x0000ca494de95bb9,0x0000c88b84c6fe58}},
    },
    { /* digit=22 (1,2,..,8)*(2^{88})*G */
        {{0x000cadd1a806623b,0x000e2b6f79588c00,0x0009a8a99724a1aa,0x000f2088afa52fc6,0x0000f705025b0678},{0x0009b5b7e0f923c4,0x000e2b31803dd6fc,0x00048c34f654baea,0x0000a8a16488e4fa,0x000078ce7289743f}},
        {{0x000c047df2f3ac76,0x000c2b67c4a658ad,0x000864e2a38fcd7a,0x000ec6e4fb3c4763,0x000051531fb65393},{0x0005e4fd59db390b,0x000c9c55e59d92d3,0x0005b30150334900,0x000919016cedca47,0x0000584c78dab3ac}},
        {{0x0000d9a50b845667,0x000a70683a7337bd,0x00042f134d3dc726,0x0004c501f1e3416d,0x000077d800d0f3e2},{0x0002ade2f283b9d7,0x000aa506fe28ef7e,0x00054084698d5e5f,0x000e17b633cc5ef1,0x000066c31b2862f2}},
        {{0x000fc8a61448916d,0x000c74f3a29467a3,0x0009855614595002,0x0005455f2de81e94,0x0000c7e3b2cd575d},{0x0001458e271cf38c,0x0006c8f06d0de9fa,0x00049a303fe35dec,0x000c8fbd5bbc11cf,0x0000091b6978a5de}},
        {{0x000d37663e141628,0x000a0c7dacddb7dc,0x0003b0e7766eefa0,0x000f1de3392ed500,0x00000be7c32df13f},{0x000ffd3cfb24917d,0x00007c5f365b7cc3,0x000aa79e7c6214d8,0x0002056c1294e3a2,0x0000f07f35bd7c03}},
        {{0x000ef267775da03f,0x00054e3abb830d13,0x00021d39eaf8a67c,0x000aae69d2ad2353,0x0000cecdaaf36b90},{0x00073f3903ddce42,0x000b5039b0d7d86e,0x000c943f361c4d2a,0x000faa09580f5af2,0x0000f9ac892638f0}},
        {{0x0007e7ed58b7eafb,0x000a211399f9cf33,0x000de654563b6e7c,0x000addff178e7a48,0x0000fb88753b9155},{0x000f8b801c68011b,0x000ffd43c8aae72e,0x0004bce716798b71,0x000c168527878be9,0x00007ce2d9d5e353}},
        {{0x00072002d0deafc1,0x0007568e039c2560,0x000b74f7fa8c3e04,0x000fa452b5f26fb8,0x0000d5c673e4de9a},{0x00094308345d1eb9,0x000e937e84fb7e3e,0x0000233f0b08ef7d,0x0005f8881b401d8a,0x0000861e80d65e10}},
    },
    { /* digit=23 (1,2,..,8)*(2^{92})*G */
        {{0x00076ddafe513028,0x000b231be24319a2,0x000bb927cde9a7fd,0x00047f98503f7d28,0x0000bacef2354247},{0x000e4d52a90363e2,0x00072961d7a64eb7,0x000900d06b997d69,0x000d4f0d5e436088,0x0000deb49837ce80}},
        {{0x000bb2d0d12e52d0,0x0002d9d615faa8f2,0x00006ad2841c4cc3,0x0005178828fa1eb4,0x0000037e5443ad4c},{0x00018eaef0ca0cd3,0x00057646caa6d2f2,0x000e0158862a3d51,0x0004399628eb879d,0x0000cd6553865dd0}},
        {{0x0000a94af9ea7cde,0x00069d83d30a2c5c,0x000e36e136e23569,0x0009d6c9b0857f77,0x0000ee3ba9363a28},{0x00091c4d690c1482,0x000da0bdaa6ec1a9,0x0002efb68a84b025,0x0004cc597ba9fe49,0x00009c2e3b6a4baf}},
        {{0x000f0606c39967da,0x0008ecee978a1d35,0x00031bb32640de50,0x0003dde62e3a68b3,0x0000e08b646ad0ee},{0x0000f5f9d3887578,0x00046276f9326f11,0x0004b608425a9f9f,0x00069fb512f521c1,0x0000178ec5cbaa24}},
        {{0x00019c380abd55aa,0x000a2e43d34a2e3f,0x000dc29f25566282,0x0003bdcc7ee3759c,0x00006455153981a4},{0x000fab2b4f7c81ad,0x00074aade744b1f6,0x000ff14cda1c443c,0x000bd5111a7d222a,0x0000a28194e30835}},
        {{0x000876812dab14b9,0x0007f78a4d32282f,0x000c4f8b89ba0bce,0x00094fe50e36e029,0x00004692f67fcd8c},{0x000d3eea24df7225,0x000ee8ed23a17f08,0x00006374aae9a53a,0x0006455e06d7b448,0x00001b31dbe9cf50}},
        {{0x000a821ab5d22890,0x0001522b99a72cb0,0x00077cdf65604ed9,0x000cad53e06de6e6,0x000000279f3d1814},{0x000490a31fb979cc,0x000d92b7cb0b5a2b,0x000c1473e470c4c5,0x00054393aa7fb121,0x0000cf1f5b79004d}},
        {{0x0007d51e7e42a51e,0x000f444c5f95cd80,0x0000ecd677766dc5,0x00040656dda8c8af,0x00007a567e594477},{0x0001a1b8848c495f,0x000ff6ac2ccbcda6,0x000f23870b5b7597,0x000568bd43bc1923,0x0000956dd9ebf318}},
    },
    { /* digit=24 (1,2,..,8)*(2^{96})*G */
        {{0x000589fb928c5f43,0x000ab31b0e63d348,0x0002245b5418c388,0x0008872a4f460057,0x0000c3c71e7aa249},{0x000bb0696dee0485,0x00070cc6583553ae,0x0009f6a5e077bc6c,0x000ffc1520879094,0x0000bccee4609921}},
        {{0x0005aaf668ac79d7,0x000433ea2dee7a63,0x000c3da02c1bc912,0x00031cfaddcde2f3,0x00001022732669a2},{0x000b89dea0558e1e,0x000e6a9e5aa049a6,0x000d25865fe4287c,0x00021cec3e74083a,0x00001aa8b5c32deb}},
        {{0x00040e7bf97f20a1,0x0006d0399375235e,0x0006d582fd773a7e,0x0002e1f677614c84,0x00001999db61efd3},{0x0003489b6ccfa05d,0x000a931ee4c47744,0x0009f7bbf5dfe5c6,0x000fd75266f03847,0x00006555c655bd0c}},
        {{0x000be00843e7b7e6,0x000b723fe67ba665,0x000037ef26f02671,0x0004513139145076,0x00001e80333c65b0},{0x00067e7cf2b69e56,0x000e805d53ff04d3,0x0003276aa2047eed,0x000006ba0bf7ccdc,0x00008a2d8826cd00}},
        {{0x0003d241c54ab435,0x0009d27cc2338fb4,0x00094d101f8dfc4b,0x00065cb7689ff6fa,0x000074c538fab3e8},{0x00070471a2ea65d5,0x000e47dde9b62a31,0x000489a9bf481367,0x000580a7d6a06e98,0x0000679d2079dd65}},
        {{0x0009f3c5562d73af,0x000f9ae3113655ef,0x000a5dc46c2ad1e7,0x0006d3bbefa2c6e2,0x0000ec4fc810c34a},{0x0006b238915ff4c1,0x000af22a42581cb1,0x00020244d851d41a,0x0003999a8e1de0bc,0x0000d237a6934d96}},
        {{0x000987f8338f6cc0,0x00059e455950cc3a,0x000bad2e7384a6a9,0x0003fad84c71d665,0x000016cfe8130120},{0x000a6c81f092f72a,0x000fd727a79a6a7a,0x00073800ea330d7c,0x0001f541056e5d01,0x00003e66db6185a5}},
        {{0x0009356a79debb8e,0x00065b7b0dc85957,0x000825e834b42de6,0x00021f4a727de460,0x0000c18079e2bfdc},{0x0003b0bfe5e20c23,0x0000045f5f9a0529,0x00087fe98313de54,0x000411dfc1a8b0f8,0x00004e039a515ca2}},
    },
    { /* digit=25 (1,2,..,8)*(2^{100})*G */
        {{0x0009d20f961c2e82,0x000b85dc8de610b8,0x000ade101437f35a,0x0007eebc5e8c515f,0x00002509d1321032},{0x000842e3dac8ba0c,0x000fd66098583ce0,0x00048bafc3fcb163,0x00076414aa2eedb9,0x000007db9f48bc83}},
        {{0x000595c4b3f8dbd9,0x000359d74cd06ff8,0x000f270e29f8a825,0x00087d12b9c17c7d,0x0000b2e80e811f87},{0x000db27ce43a86c1,0x0003fca990f62ccd,0x0002ec59bf016957,0x0000628f5d9bed21,0x000027d55a4ba6a5}},
        {{0x000d03f718913dd5,0x000c2befc15aa1ee,0x0007c847102cc8f2,0x0005c8a1240d1254,0x0000fdffe724edc0},{0x000f68ea1cc2db7d,0x0003e6c4a02c4997,0x000d509587b544b9,0x0005f5faff725083,0x00002c702007fc4c}},
        {{0x000d112927153319,0x0003f1d26ee83821,0x0005188c3a678749,0x000f5953dcf17dcc,0x00006ee6a46384a1},{0x000b8bdb94fd5a59,0x0002b7750491a746,0x00019255042413ef,0x00049dcab687fa76,0x0000d3bdf3fd8d81}},
        {{0x00073eb5de6f16ea,0x000838af7f91d0f2,0x000180eba14a2d69,0x000c07d543b61b0f,0x0000a48e18374f25},{0x0002413c252f7b56,0x00055f77b4e4d538,0x000f5bfedb51fa0d,0x000d51bb3b7ce66b,0x0000bd4cf4850d41}},
        {{0x0005fe87134cd0da,0x000a17e3cc8ac855,0x00078703ee282882,0x00067052f8d725f5,0x000030f3d852516a},{0x000242d3ae1ef785,0x0007fa96ab6b01c8,0x0008fa96637638d6,0x0008ee49b69a02a8,0x0000dfec375d87b0}},
        {{0x000f921d710cc9ab,0x0008a269be47be0e,0x0007db96e1305cfa,0x000a2bce5323b7dd,0x0000b7178cc6492d},{0x0006c2921097b191,0x000d0fc3c4b880ea,0x000df1d178576177,0x0003f6e393f6f914,0x0000ac9a7fe9fa67}},
        {{0x000bc95725aee3d5,0x0002ea553fb2b560,0x0007423c28530356,0x00000bbd96ce141e,0x00009b1c7fa39ddb},{0x0007326ca7661923,0x00044911220fd06a,0x000b99589f2eb8ac,0x000d2c8a9716e3a3,0x000016f0b4225082}},
    },
    { /* digit=26 (1,2,..,8)*(2^{104})*G */
        {{0x000a527e6b978cee,0x000db82cf7d62d27,0x000ca96802e48946,0x000e9519e1f36e29,0x00007265e87b84fa},{0x000802786e991660,0x0003097581a85e38,0x000f541313771b92,0x00067126e1f1a520,0x0000d10aa19b0e7d}},
        {{0x0006f0af00724aea,0x0002a9e36f09ab05,0x0009f3200c5b7d67,0x000971f9803f163c,0x0000abeb83ab4494},{0x000dc4a79b89e736,0x00099ec70880e0de,0x000ed078e9a3f10d,0x000e77ebd7332a66,0x0000efcf0956aef4}},
        {{0x000be864b03d7cc0,0x000d4d1f4c6b6ec2,0x0006eccb68ebb96b,0x00094bfbf526b082,0x0000a5858dadf7d4},{0x00072e6a44328071,0x0001da542099b646,0x0009a026229e5471,0x000dbab9c2770b28,0x000007628b15e3f6}},
        {{0x000dce3782cc4229,0x00054d0c55c44969,0x000687ed744ff73a,0x00095ca63a6a9635,0x00006189f2556fe1},{0x0005e2f1f92bf8e0,0x000c16ab2b91f71a,0x0002b5bd2443b5ec,0x000ec35ade448982,0x0000c8788b8a39ca}},
        {{0x0004a1f390200e56,0x0008cc847c643671,0x000f310d5b30aabe,0x00025ae2c6a496b9,0x00007a3574996340},{0x000eafc1730bb4b0,0x000e3633ef1f5404,0x000a23f7ac20dc45,0x000363451d323b30,0x0000fabcf3b74204}},
        {{0x000392b0b18c6d03,0x00098e7abded5516,0x00086524935ee7e4,0x000a3d6a903d358b,0x00006875db035981},{0x0006fc5d51954294,0x0000e980b75c904f,0x000db1fb9c1ad202,0x000ea6532c305b0a,0x00001aa27478cb82}},
        {{0x00014710f8720b12,0x0004851b3e59b897,0x0004cfec90d17238,0x00000dc591361395,0x0000dc88b86a7ad2},{0x0001febd7319c15d,0x000eeced6c446c96,0x00060a4e95f5a70d,0x000a79f37e0aa7fd,0x0000ca962020a7e2}},
        {{0x0008f862ec09473d,0x0000ac9d64cc78c4,0x000b52744f8f7011,0x00038e5ab6c50621,0x000008c758760cd6},{0x0006d3b2c6ac19b7,0x0007bede1603c166,0x000ef5c6e18a250d,0x0000ffdfc19a80e0,0x0000dc276b838e08}},
    },
    { /* digit=27 (1,2,..,8)*(2^{108})*G */
        {{0x00011cac13161f9c,0x0001bbc453cadd69,0x00072aef15e577c3,0x0008c37af203900a,0x00000e41db5e3490},{0x000b87d44a487f26,0x000dc42ec965469f,0x00012e582d33e4d5,0x0001872850e9f769,0x000038b03659451d}},
        {{0x000da8e4f1aff818,0x000caa2d551ee106,0x000804d524b4b06e,0x00008fc8d87a8f1d,0x0000ef431fbeb97c},{0x0000c0d9b00298e4,0x00033f0cf9a4e718,0x000fbb34f16943d4,0x000ca08c0ff50200,0x0000745ea7a228cd}},
        {{0x000f1e0fa64b9ba1,0x000a4ff1d7aadabe,0x000fe6d896d5ce68,0x00034116f65d3825,0x00007bcae08c6246},{0x000ac54f612c30f9,0x000ceba33db72cdc,0x00092fb725511bb6,0x000d9573c017cbc0,0x0000a29dfebf2fc8}},
        {{0x0000903c4cbe46bc,0x000c0eb1bf4581ca,0x00060c177519da3e,0x0005066ace635e18,0x00005345445cd5a7},{0x0007197ca469b8c0,0x000858948f214029,0x0004225140fdccb5,0x00087719031b49c1,0x0000a2053b8e6576}},
        {{0x0002dda543915e7e,0x0005f5d4b07e2b19,0x000afac0fcdde015,0x000a72d14d144c4c,0x000034e73127607f},{0x0002db773ecd3720,0x0000fa8cf03dce66,0x0004b74758be1c61,0x0007668c48b5ea96,0x00009b6250934072}},
        {{0x000d7803581ab555,0x000eab4820357c72,0x000e419c5554fe07,0x000fef5a1992039a,0x0000d9875b456d0a},{0x0000ee0ea7058063,0x0001b4dc77ad4d4a,0x000858f1411d534f,0x000f0bd5ed49a799,0x000050a8f7fd0e17}},
        {{0x0003cab91b752141,0x000a5e89c92b2350,0x000e676eda85d689,0x0001c8f31a73bbd0,0x00003841c3e8d0f4},{0x000cd61ad4ee96e2,0x000a42f1db3574b2,0x000537e4eb45e77e,0x000813c06485b018,0x00002be90410b3b1}},
        {{0x000add5f69c02408,0x000d61cf3480d4af,0x0006c1ad6fb043be,0x00005529cf0d8edc,0x0000e6b784db99a8},{0x0005a454130bbd68,0x0002fad96f8acb1a,0x0004c17786cf7d98,0x0001fdbf4bddd49d,0x00002c7d15e91516}},
    },
    { /* digit=28 (1,2,..,8)*(2^{112})*G */
        {{0x0003c0440fd7f2f9,0x000bdbfc360e25a8,0x00048399d668b4f6,0x0002439f4e642519,0x000089f1fa0b9870},{0x00097b3d282ee427,0x0008cf1d720281f6,0x000e67baa329978c,0x0002104e72205910,0x000061a43a34e6ac}},
        {{0x00071279a45648bd,0x000de9afb3ff9ed0,0x000b10e3d7b7d810,0x00004e74928c2e0a,0x0000f66bf52858f1},{0x000e9fccc7111eb0,0x0004f6601fbe8556,0x0007f13a84fd868d,0x0003acc0b3ee394e,0x000011bb82692f56}},
        {{0x000f57841f3144bf,0x0001f9314092ebb4,0x000cf3369fecda45,0x0008e3164f17256b,0x000033b176e2d462},{0x000333e4efa6df27,0x0001d05e708d8553,0x0001d0bddee0a802,0x000f8c7d5856aae7,0x0000603c90846016}},
        {{0x0007512e2eb6a7c2,0x000b8dedda492f81,0x000a60d843d6851f,0x000eb594cc11a3ae,0x0000e9fde037b87d},{0x000cf109a400a483,0x000c6f3177bf8b6c,0x00093bd6f59a5d1e,0x0006c915d232ea4b,0x000066d0031672f4}},
        {{0x00008a54ec2b1382,0x000f888a1f258972,0x000f812b7fecbc4a,0x000e06b5c7ac6961,0x0000e7ee6a3486dd},{0x0003eeb9a9acb8ed,0x000811978660710a,0x00067f8f391f11c9,0x000b760a50cf70a9,0x0000a64a54a69740}},
        {{0x000869d0d5ac68e0,0x0008233169bca968,0x0003a53cda259d70,0x0005a1a9404d286d,0x000088e4951616f4},{0x00052a733ab82011,0x00026e5d0150d651,0x00030ee1a18ef179,0x0006e1c49a92e250,0x0000660861970a58}},
        {{0x0001843074252dfe,0x0003f588434a920a,0x0002c09cd3518f04,0x0005fc19ac0af8e9,0x000065ea1ee67b6e},{0x0000581fc169a790,0x00004aa5447ab801,0x0005b7021d9fcb63,0x000998a9ee5e5a32,0x000086ce09c0bdfe}},
        {{0x000b0da855c77138,0x0004d7080eb24a90,0x000d3d8064a79971,0x000e895b87bedfb4,0x0000ff2e824b81fa},{0x000939b48c4a16ef,0x00015dbde314c709,0x000bd2f933b9e136,0x0004c0d9ecdbf1fb,0x000042e460791f67}},
    },
    { /* digit=29 (1,2,..,8)*(2^{116})*G */
        {{0x000c8ac9b3f30faa,0x000821f711b0eb9e,0x00078b7fefa0a379,0x000f7e8dbb905f2c,0x0000d9b3674355ae},{0x000e568622b92879,0x0005fb6b40a24474,0x0001518d75018f42,0x00065c23f60121fc,0x0000b6c0f8efac61}},
        {{0x0002b23a10647092,0x000b4c64a8a3d626,0x000fc1c509c1f5da,0x0008752338469c4c,0x0000592d71f92d24},{0x000e65e5e66ab21c,0x0007ab4a63d1a4c4,0x000a2eb259587d83,0x000fd941c454e7fe,0x00001e808c047aac}},
        {{0x0003840fe88767bf,0x000b8176add85450,0x00066f408b7e5e73,0x000da5e771b71cb6,0x0000d35c39b650e0},{0x000174cced9e5822,0x000b8d51ec699775,0x0008df0a9a391539,0x00071f40cae243fb,0x0000e2156e1d8e4a}},
        {{0x0003c2f435522de5,0x00099b6cbc613e57,0x0004d5bbb1e76fb3,0x00050f9d533131d5,0x0000500dd4c4695d},{0x0006451f5801b985,0x0009f93a4a375fa7,0x000c41eea66a4aeb,0x000b4eccf5f06787,0x0000be0cc26ec73c}},
        {{0x00000b6c75700e6b,0x000408495fe1347f,0x00087f18e3c6eed8,0x00078726bab0f6c3,0x00006a00813e85d4},{0x0004f3ad785966ec,0x0000da6a78629992,0x000c99e4f0adef59,0x0001d2deb85e5a06,0x00008ebb465036e4}},
        {{0x0003d92b271a34e2,0x00021fc6c68d6876,0x000cbc1727a04409,0x0009c8c7a3e732c3,0x00006da92ca67f54},{0x000e2c06175bb538,0x0004abadd44867cb,0x000e3a947ba1a418,0x000b74f85a71b4a9,0x0000e7099fa89017}},
        {{0x0003b5fb75d8727b,0x000f2282bcffbc46,0x0006a334e0047ac4,0x000c33369708817a,0x000053e4b18d8ff4},{0x0005f5e93d863d2a,0x000bf53e7fe08c4a,0x00044f8de0daeb8c,0x000aaf25cb4d8bfd,0x000075bed4b944bf}},
        {{0x000274dcf1b355e8,0x000d5ef694db7e04,0x0007778800d4cda3,0x00062f4e1edca878,0x000092c279274250},{0x000be2b2abb3de8a,0x000b9b86def6d1a2,0x0000bff865bb4348,0x0002de558d25b167,0x0000a14c44f5e051}},
    },
    { /* digit=30 (1,2,..,8)*(2^{120})*G */
        {{0x000da4a7963ed790,0x000cc9dd111f8ec7,0x000d3a203fc9ff36,0x000619a51bcc33f8,0x0000c3316282fb7e},{0x00058ffec2ca8e3f,0x000cbe30bb1151be,0x00071d53238e4f7c,0x000c05f7854febac,0x00007acf3890bf9e}},
        {{0x00066adbf6bb7535,0x000ff9d29c4120ba,0x000f1a65fd1f4042,0x0009b85519f94391,0x000007d911a8b098},{0x0008234499aed7de,0x000763c34bfca38e,0x000fd1be8863128c,0x00048439ce0f2755,0x000013608ea8ba39}},
        {{0x000b6304a752fd49,0x0007c13516e19e45,0x00076a61d0ec2826,0x000e9d5f656e2e84,0x00006c970cc1cc09},{0x000935381bb3523e,0x00069363ab7e433f,0x0000053ef767b2e6,0x0002d839f1adea47,0x0000b39a71be38a8}},
        {{0x000cb10d572b5962,0x000ed9d918e49366,0x000645a02c2b89f6,0x000f43ab965035ef,0x00005fc3fbf56b43},{0x0007c7032b9ad449,0x0000eb7a242da112,0x000d3f646f3cae05,0x0002e606b16a4d3d,0x000066b08ba950ea}},
        {{0x000fa003d16724c1,0x000aa7d5846426f7,0x0008a4dd404bee11,0x0004afe48e7d09e8,0x00004e388ffd7c0c},{0x000d40da8e2b1cbb,0x000a64f17fd95965,0x0000d88abe4cfada,0x00066ec6a49e0e0a,0x000085fa4175ed03}},
        {{0x00089bc84468e031,0x0005ab4a595939dd,0x00084fd839d2cf16,0x000cd45120355647,0x0000a31eb877381b},{0x00012d8643774d44,0x000965d85a9184d6,0x000b3e932a3180a6,0x0003d448e562563b,0x0000bf1cf2a46781}},
        {{0x000d03d7d3318572,0x00049a354530bb24,0x00077e0492176e2e,0x000bd9f63bde3ef7,0x0000086e3e2a72d9},{0x000280da9fc53e22,0x0002d9e43b6a782b,0x0006ea07cbe66e70,0x000c1cbd9216db30,0x0000dfa49ad0403b}},
        {{0x00048234a455944a,0x0003c913e538cd75,0x000c398678aeeffb,0x000c8cbffa7001f6,0x00008153cadc4269},{0x000cbd665cbd5dcd,0x000d02d3d5b40458,0x0005bdd2db3441fc,0x00002b28bb0ffeeb,0x000086864413478b}},
    },
    { /* digit=31 (1,2,..,8)*(2^{124})*G */
        {{0x000d41f01735a335,0x00073f833f6746cb,0x00054167a0b39250,0x0003a7ba921e46f6,0x00006c09c11aae95},{0x000d59e95785f38c,0x000b834426ffb589,0x00057781d8acae7b,0x000a30f7f8055943,0x0000f1dc76c3a6d4}},
        {{0x00097ba641eb7f97,0x00074a9b733aa5fc,0x000b26df4bf350af,0x0002ceba5dece47c,0x0000cc1ae7e7d3b7},{0x0007fab43b1d99a8,0x000ad0409c110608,0x0004beb49cf2a615,0x00058d94656ea2c0,0x0000cf90618174d6}},
        {{0x000a41e9fa25ab62,0x000af5c775d6ece0,0x000bde7efd93c9a3,0x000b19a8169d2e3b,0x000085cb8fc6f6ee},{0x0005f7b3cfc01d0c,0x00027be909a1f0b1,0x0001f4efb7604d75,0x00015af69150a845,0x00001a9458cd6746}},
        {{0x000b433b59bb0813,0x0000341d4c5105f3,0x000e323c820b4e81,0x000deaab01ae80f8,0x0000ba1d2bfa0603},{0x00002fefd81e661f,0x0004eb693e856387,0x000273b996572680,0x000f613ecf7b5925,0x00002889ae807f47}},
        {{0x00070814d5389736,0x00073141339609ae,0x000d572fd5e8361d,0x000f5579c2b627de,0x0000b93bcfa4fc39},{0x000b4a9a9b91c818,0x000435717398d14c,0x0004b4b95c2dbae8,0x000ba7a759d37d25,0x0000ea36d4f85bce}},
        {{0x000489527486828e,0x000dc5c97290293f,0x000bdeff5a4b77f2,0x0000edddabf04a19,0x0000608db4f55ad8},{0x0004f5d47694d29d,0x000e1c32a5923d75,0x000ba8eaeefa4a0d,0x000473bfcc7bc949,0x0000b5fd2de9fe6f}},
        {{0x000e65bcd4111964,0x000a1f7d13fb27da,0x0002be0bd8ecb0f5,0x000e2f2c5c05b30d,0x0000ff05e9764421},{0x000cdc5908086e16,0x00094b8630d99eaf,0x0005e9509364c388,0x00080bcf1164be81,0x00001478d33e9527}},
        {{0x000e89f3d33e658c,0x000bb5d0fefb0c3a,0x000a984dcf89f8ee,0x000d20ca4d48fb56,0x0000b9304c4e5ff7},{0x0003083bb07dcf66,0x00023c86363d14cb,0x0000b4a396cd193c,0x000063a218981752,0x00009e66befec3c7}},
    },
    { /* digit=32 (1,2,..,8)*(2^{128})*G */
        {{0x0001d587d483a8ac,0x0001644bfe209256,0x00032e076092df00,0x0008fc46391c19ac,0x0000ca7c69ca0159},{0x000a11fe134033ed,0x00086a2a37173eaf,0x000759658d52a842,0x00086c73e2384800,0x0000d0571a330ac5}},
        {{0x000617ff6bb8909f,0x000aafeb8a24a205,0x00019f14a5d36b68,0x0006aa95317ebfed,0x0000c8fde1bb5304},{0x000967ce0fa78f8e,0x000a6c5e3c99ebdb,0x000d5e1c475a7c8b,0x000cdd9dffc64242,0x000020302e081fc1}},
        {{0x000418871e270c0b,0x00029a3b23358342,0x000a6cd6e14299eb,0x000d6b00d9526205,0x000018ce7f6af8dd},{0x000fdb3c22d19812,0x00064814082c1576,0x000fb9e6c451057f,0x000efd528cc914ac,0x000020534397c913}},
        {{0x000e205c1544399e,0x000710441c23fa36,0x000053783e19700e,0x00068fea7b4712eb,0x0000a112e4fbfa4f},{0x000514d89ca1abfd,0x0007c57b36416860,0x000d4097b2b1ef2f,0x000a206500432691,0x0000b3a43e7e1054}},
        {{0x0008a5b251a46688,0x000c41c2cf9d7c1c,0x000a25f0335a2815,0x000478f0c1320886,0x0000b3973c66051a},{0x0004dada9450a7b7,0x0005d32c11d23031,0x00020a289c0afe30,0x000abe1287da6691,0x0000967694826933}},
        {{0x000ce5870a0c41fd,0x000faaaf0dcbc49e,0x000883d62d516f72,0x000eaa5e57de551f,0x0000f8ef2d69da92},{0x000ff5e2f5425d4e,0x000c0dd167d79ae1,0x0002da879bcbf034,0x000d36191039df8a,0x00004f16c971cb78}},
        {{0x000aee99a83de201,0x0000551cbae2f701,0x000578bc0f4313d7,0x0003bf399efc4bc0,0x00004db1c0ede19f},{0x000c5f317b20b8d4,0x000b1b9ae8274c57,0x000500d18221751b,0x000091b816c14d44,0x0000685f584b909c}},
        {{0x0003bc3770684e62,0x000ca6bc4fe3c395,0x000318bfb46f7b63,0x0001ad259ba4a815,0x00008206cce146bd},{0x000c2731bc0908f4,0x000d4ab5afc60db8,0x00049492c0e73d3c,0x00006d107aa02235,0x0000a2cf845790c5}},
    },
    { /* digit=33 (1,2,..,8)*(2^{132})*G */
        {{0x00044ed736b966ec,0x000a5c2e48fb8898,0x0002f73bc5cfb109,0x0001bb4e226882c1,0x000063d7619b2c62},{0x0006a413e95e2beb,0x0005c6fd86e27c75,0x0009ae0bdbf2ca03,0x000edf84da04edac,0x00007492ad45d302}},
        {{0x00024f4d696da3cb,0x0003b1d5a74be506,0x00047c52228c154a,0x0001bfda2e41781c,0x000096ec0545b52c},{0x00001059ae4af1e1,0x000735dbdcc9ae4f,0x0005508ac4dfef91,0x000d754392573dbb,0x000045a30ae8165b}},
        {{0x000beab27c67ef12,0x0000c274d559d96d,0x0002dcf0b984d026,0x000aa0faf4f18c0d,0x0000a4d5a80a0707},{0x000bb192b84c56cb,0x000d3aa7040bf3b5,0x0004ba631dd8d7d4,0x000f4e45d39c479e,0x0000fd24341672c1}},
        {{0x000c13673627c363,0x0003c973112795f7,0x00071c3b07ab4999,0x000f308cde824443,0x000024017b4422c4},{0x0007e6782a430857,0x000be955dbec38e2,0x000c10a45929115d,0x000d83e2f51c0782,0x0000d2b6c6a41083}},
        {{0x000a0300c013b50b,0x000b751ec5d7f652,0x000666363fc769d4,0x000b40fb30c8f561,0x0000e14a50273cdc},{0x000989050f53d764,0x000cbadb114faf4d,0x00087892f0c26b7b,0x00024d2de328fc0b,0x00006f37a0582ce8}},
        {{0x000f9b21b06e4d48,0x000483d4ed2dbc25,0x00081ca00bd2f9e2,0x000314b350eba59c,0x0000879d4fee9d2e},{0x000846aa4551a9b0,0x0002394af267bae5,0x000565e76b699192,0x000e51500aa86cc2,0x00009d486efc3818}},
        {{0x0008b841146d2064,0x0005638e7e0c2780,0x000e4fd2ed5afa66,0x0003f8a3a09bf87c,0x0000a8d6a3930dd9},{0x000281d429091c44,0x000e8e029e646294,0x000f8a25ba1a0598,0x000386591adb60e8,0x00000de777e039ad}},
        {{0x00023eed8fe44b7b,0x0001c40e2c2bf152,0x000587aaa9751a65,0x000b04a65627a220,0x000078ae9a0140de},{0x0008dfbb97c7d47d,0x000a883a8363b49a,0x000920e2f50e570e,0x000074b5c1a0b6cb,0x00004368ec853ac9}},
    },
    { /* digit=34 (1,2,..,8)*(2^{136})*G */
        {{0x000c2a360971c31d,0x000066e846e364f6,0x000c727ad6974fa9,0x000639b6d7f33527,0x000015ca19ee6b97},{0x000b4ef351021aa4,0x000ba52f024e9245,0x00044265bc79a45a,0x000687390e0fa07a,0x000026bc8f7f2c64}},
        {{0x0001a05fe05069b5,0x00097050f15dde91,0x0007fbbecba1b4b7,0x0007e7662a47a76a,0x0000cef9eea25012},{0x000d251439c9ff5b,0x000996e9d529b36f,0x0000927929bcb4b0,0x000321b9855ab130,0x0000e6913e2a37cf}},
        {{0x000a22c213a1381c,0x0005998a9d82abfd,0x000b0c9eaee2416b,0x0002e94875f188cc,0x0000ed487d7becaf},{0x000a1bfe43d8e989,0x000d43afbddb4799,0x0003d3555d553c34,0x000ae422e4b606b8,0x0000a98941400820}},
        {{0x000495775835ddea,0x00038f3dbfb894e2,0x0006a991d3c0ab53,0x0007ac0dfbe9b79f,0x0000a996ed108d94},{0x000a1485e6867237,0x000b861bb9390993,0x0009ecbcb0ad8aab,0x00089ee3b1d6a974,0x00004490d265e84d}},
        {{0x0001f9addb3fd772,0x00068b61430c9ab7,0x0002b03f3bbc1b26,0x000a8d0ae0bdd41d,0x0000a6be72385501},{0x00063accbd8fe7a9,0x0001716c52dd907b,0x000c73a737c1e0a9,0x0002868a6d9bdf44,0x000035c09edac28b}},
        {{0x0002ad31f429e92f,0x0007dab4baef62e3,0x000275ae5ff44e2e,0x000fc47109f5a220,0x0000f78da2e8f242},{0x00089cf1ff54aea4,0x0008ca425bcf4d6c,0x000288b364e70dd4,0x000847d56ea95059,0x0000d5e592ce8a8c}},
        {{0x000e70062ee0a4a2,0x000917ac0b7eff35,0x000e6774850d2a32,0x0004c985f8552225,0x0000ed692c26dd93},{0x000068c99ecd36b0,0x000a048e7073969a,0x000922d3ea339e56,0x00093f20f392d2a2,0x0000a61b1d58dd81}},
        {{0x0006e4617f3e69bc,0x000caec1ed66f181,0x000bbf3b6cc4ad74,0x000551b4d225d906,0x00003684306257aa},{0x000516497c9675a0,0x0000addb2fbc3dd3,0x000f55d795decef3,0x000598fadedb5484,0x000015e8ee776bd7}},
    },
    { /* digit=35 (1,2,..,8)*(2^{140})*G */
        {{0x00020f2beb76812c,0x00013ecfa181e695,0x0000dec76ead7889,0x000698d5d9ea02f8,0x00000cd75bcfa2f0},{0x00017a069c2d2cc5,0x0008f0a1df843618,0x0000f08066c134ef,0x000c931ff1203772,0x00008f19ef39b4e2}},
        {{0x0000aecc1c7112bc,0x00073b6b294cda6a,0x00051854d3181244,0x00049ff216ce9bf7,0x0000f5f14402d398},{0x00056e372344bdbd,0x0005f3af02909e50,0x000f436065b91304,0x0002579f8c7d59ec,0x00001766823e2146}},
        {{0x00027d200e7695ba,0x000fb3189e800ca4,0x0006d1d4e8ef137a,0x0007f003750fe0c1,0x0000dad25c5ac540},{0x000807804fa82f49,0x000994fe616e2c00,0x0008e610d4715daf,0x00004e1739c25f4c,0x0000a1ed59eb55e7}},
        {{0x000c966787f80791,0x000d43a4f0d56f34,0x00077d92507dca1a,0x0006bb24b961e404,0x0000a0d775222852},{0x000bb6d594089b2b,0x0004142864fee422,0x000a2f57f8c8c37e,0x000969659c1be93d,0x0000e98561f48eb8}},
        {{0x0003d36eea5a411b,0x00083c9b809b7ceb,0x000b2ef3bd41c883,0x0005fa4368a41486,0x00005327a94036a4},{0x0009d81a294550be,0x000028a328cc987f,0x000b405a4a382a8d,0x000c01dba0a3bcd2,0x0000ecbc7c687492}},
        {{0x000ee9ea4399d83c,0x00029ade4d559419,0x000d914e5643a410,0x000194f9bdedafa5,0x0000ab6a2f9c77b5},{0x00023fc56d6b71dc,0x000ce1637a55a4a5,0x0003af1fce4bba9d,0x0002a5998eb19a51,0x0000fb6b0a026533}},
        {{0x0005384859f3a770,0x000970cb98fe684f,0x00091d11cbfe5c75,0x00014fb3fd60fbe9,0x000024a2c6896e9f},{0x000a7731d1c175f6,0x0007bf7b59e763bd,0x000880e35c8c898c,0x0002e8c923d4606a,0x00001705d921c944}},
        {{0x000bd17983bec34f,0x000e79390d458714,0x000fba44f409e51f,0x000e5b503e976403,0x0000bb28b50bfeca},{0x000460fc77585d24,0x000439ed5d2c53a7,0x0008896e3f104db9,0x0000d454e5ec4bcd,0x00005c92699d9c5e}},
    },
    { /* digit=36 (1,2,..,8)*(2^{144})*G */
        {{0x0000693a18674889,0x00096e1c63c4962c,0x0008d7b6a10d190a,0x00003a26b50541e8,0x0000e282f1e08996},{0x0001ed4e5703fca0,0x000c04e0117f203b,0x000258ac6a79aec7,0x000248c44245f196,0x0000ff00eb7253c2}},
        {{0x000d0301187bc101,0x0000eb6700a1acd0,0x0003f09695693995,0x000f3e0bae823fd7,0x0000bc494f5d06f0},{0x00015737c0a7b0f1,0x000bfc989fca8cdb,0x000b4882d64acc9e,0x00080e66f970d01d,0x00002a01327ea3d1}},
        {{0x0002887ba15c20fd,0x0007d9c6bdf22da8,0x000f0e54073dbcd2,0x0004f3951efbc432,0x0000469ec570ed01},{0x000deaa2e18dbfd8,0x000c5dab920ec1de,0x0002fe53ea59ef2c,0x000e8af47d0d7e8c,0x000015e430f8b3be}},
        {{0x00062dbbba9d84ad,0x0008b4ece53c2d04,0x000d18184b2003a6,0x0006765b0779d897,0x000067fc9538f5d6},{0x000035f7ff931704,0x00005f2cafe37b68,0x000f6c983617d6e7,0x000df03fd273d1eb,0x0000249da2e138a9}},
        {{0x000807b1c5ae6f72,0x0005a0f296c9005d,0x0009a3033a160965,0x0009f56d44b9094f,0x0000c6b826d12c11},{0x00092c2460ebcfff,0x0002ddfbe7133835,0x000e27e80740bd71,0x0003a6cdc435e063,0x00001a2aeff08bc3}},
        {{0x000bb88baca8d454,0x000d95a2093c22a9,0x000139b7af41216f,0x0005e33b6ebd0bd3,0x0000663daaf350bc},{0x000c3aa8010516da,0x000ab3875c1e3b2d,0x000fedd69c7bf698,0x00045728dbd2ac94,0x0000085149b36be5}},
        {{0x000d63c348e3925d,0x0000c0016e23e9d2,0x000b7a687e98afd3,0x00043c75ccb220c6,0x0000b36999ba7a86},{0x000e9f6ec46bda19,0x0002519cdc0bcb5a,0x000ee0c0acd4376d,0x000092de470f18b3,0x00002848124d0362}},
        {{0x0009d1febf2de9a9,0x0008bc77e6c55202,0x000fb2e7eb995763,0x0009cbd6dc27df9e,0x0000444476cdaaa8},{0x000ba7ced0785f36,0x0004b9e93470afed,0x000906fab0ce1fe7,0x000bf2f043e6a966,0x0000d9c1876fd26a}},
    },
    { /* digit=37 (1,2,..,8)*(2^{148})*G */
        {{0x0008d94f6be7acf2,0x0000341338d6e434,0x0002fc6886610503,0x0000f96ca56f7dd7,0x00002f54a7c972af},{0x0003e19d89ed269e,0x00005bb2ef8279cf,0x000a1736ca68762e,0x000fbb351d575465,0x000061e8deb175a7}},
        {{0x0002aae2b99711c5,0x00031ce51efb3108,0x000412e3130475fc,0x00003c959cb5b2eb,0x0000efeaac806f9f},{0x0004837f98bf8cb0,0x000da39411aa636f,0x0004e03d299b3bd8,0x0006376b77152ecc,0x0000b7bc15a5f18a}},
        {{0x00083eca38629302,0x000f164b71698f58,0x0002173c96261574,0x000a82abb6ba418d,0x0000a7d774e7d73d},{0x000c1dd5576a4dbc,0x000283ff3437f24a,0x0001f86ddde594be,0x000503b65e910b43,0x00004e079387d0c8}},
        {{0x00039d3ee2963f2f,0x000233a626332d5d,0x000281c47c620310,0x000452fa27bc3883,0x00006bc300c4cda7},{0x0004c341a09ee9c3,0x0003ad3e7676b0dc,0x000f36ad1e76c678,0x0007b36a8620e35f,0x00009710f4c3af53}},
        {{0x0000e7c2becbd6ac,0x000da1cf405ff065,0x000cf786bfcc5059,0x0009287fcebac86b,0x000006628092b297},{0x0003a21f33a3f231,0x0006f95fa90d7679,0x000b52ce8c481fe2,0x00088d46dae60eb7,0x0000dd27b34c3095}},
        {{0x0007112386fc20ce,0x0005122369b87ada,0x00088beb81cf895b,0x0008f96663c00e5d,0x0000786fe6f72494},{0x0003cd4c08b1b97b,0x00066986d9bd5f51,0x000845f5fa36c27c,0x000c259b22dcc7e3,0x00003a7a6a264018}},
        {{0x00014104124194f3,0x000f16022caf46b4,0x000f5955fa3d17a1,0x000fa544e6a45dd8,0x000027f7e6432277},{0x0001bcd329f0aee1,0x000ac1241de97bff,0x0000cbc3ebca8120,0x0002c1f37b8547b6,0x000028b36f4746d4}},
        {{0x0004a07f82ebea7c,0x000b5769bb816483,0x00053090a14d150d,0x000e04062d69eb48,0x00003488c7727160},{0x00062b085ef31ed0,0x0002787bbfb55541,0x00004cb77b99391c,0x0007343a0b06ed4d,0x00001334165040ae}},
    },
    { /* digit=38 (1,2,..,8)*(2^{152})*G */
        {{0x00027d09f86b87a6,0x000672f7189e71f4,0x00081c5287eec6df,0x000edd421c643874,0x0000dd3e802a5f6f},{0x0005cba1123d99ff,0x000318f38384a7a9,0x00041aa78a8746d0,0x000ea5919aac3acb,0x00001546626df6d9}},
        {{0x000842e7e3646f13,0x000721aaaca5e9b7,0x0000de2e53b43348,0x0009b4ef6518aa52,0x00004c1f8413e3b0},{0x00027091000d9504,0x000ab656868a5489,0x00024df86b81806a,0x000fc7333d963bd8,0x000027dffecf8b57}},
        {{0x000032dd3467eff0,0x0002e48a105fc8eb,0x00097868c757cfb0,0x0002c3180769d754,0x0000bb784982ad6d},{0x0009004e124bcf40,0x000e6db020b0aa69,0x000f6d64792a4968,0x0003db95d05137e7,0x00009c7931f4b21a}},
        {{0x000de8cdd0926a17,0x000b2a7d298c241d,0x00097897af2c8ee1,0x000fad3dbe3b697b,0x000095a39dc131b2},{0x00088519ea3f0b69,0x00087a75a4d2604d,0x000e93901ec55560,0x0004fb6cc27154d7,0x00006bfc52e1469f}},
        {{0x0007c1ff4bc6220d,0x000d7f796ea6ca1f,0x000927b7292549f1,0x000438045567cdc2,0x0000e37c17362496},{0x000832367b234acc,0x000ba574b6cad39a,0x000411ee7dad7e6f,0x0009c31fb3d58d63,0x0000883b19b2637f}},
        {{0x000d28e06912ab7f,0x0000d9f0e4938f75,0x00097f5a913534b6,0x0006ee5cc58d47d6,0x0000cf8cceb8bae1},{0x000d0bd2f66354b5,0x000c029210466f66,0x000f599a7c02757e,0x00079b57a2af1152,0x0000cd4c1d2a65b6}},
        {{0x000d0b153348f81a,0x000e92af416448df,0x000fef6bc43dd5d3,0x0001354ae4a7e8c0,0x0000c6d13c9cd270},{0x00067cecd88b842b,0x000ed48d98b5ca3e,0x000c09bcc716fe72,0x000f7af2ed01fe5f,0x000018e9887155d6}},
        {{0x0002571fa1c005d3,0x0000a1a7cb1282c7,0x00064bef7798f823,0x0000303b2a08d762,0x000094b95e409f27},{0x000cc832f936b83a,0x000392ff22dfd98c,0x000633bedd944ef9,0x000cfe67a87ab01a,0x00004e149b05af22}},
    },
    { /* digit=39 (1,2,..,8)*(2^{156})*G */
        {{0x0005d70b7657b7a1,0x0007085ca8d9d1ae,0x000cf3b0d35bf0d7,0x0000cc024adf2c77,0x000069d110cf7a09},{0x0003a7564e157769,0x0001d506260e70ff,0x000703a97ab76d5e,0x000435a6439d75ea,0x000076aec3e36360}},
        {{0x0002f99d592d4607,0x0009d3e3fcd3efca,0x0004150ef1418504,0x000f73feadd26c03,0x0000c8303bb7708f},{0x00028bb4209cedef,0x000e4552f1da46cd,0x000d486f19b140bd,0x000e6167872c3f8c,0x0000b4a36e89cdf5}},
        {{0x0007709b7b97f8c5,0x000cdd2e7417ce17,0x00011f9e4c798c2e,0x0006edf1eff42bc7,0x0000d3407d05f1c4},{0x000b2930ca06e395,0x000de1dbe217f2cb,0x000ca08df0ad2e70,0x0003a3b592af2a8c,0x000040a4a94b9f52}},
        {{0x000cf60f96d10e48,0x00095daf176f2c08,0x0004556116c14d5c,0x00025e7fb01ca460,0x00006c4e588656b4},{0x0007fb754d3440e4,0x000851cc9071c4aa,0x00038c48b2b6677b,0x0005b2981fd58874,0x0000cc23558b384c}},
        {{0x000981afc00085d1,0x000d0d5af71013f7,0x0004926c19866a71,0x000ed9fa0e68216e,0x00008c7bcfc44bd1},{0x0005694612f9623f,0x0002b679449f0e1f,0x000d14dea79b08e7,0x0009c8b2286cfc4b,0x00000d346cc223b8}},
        {{0x0001287ee355832e,0x000a8715bde48f8d,0x000250613d9a672a,0x00086c08ac970387,0x0000dae19fd8bb71},{0x0005fdcbcf36d30f,0x0007974db1dbf1fd,0x000ac30ebd07464c,0x000637413ea46588,0x00007cc18fa7cb4d}},
        {{0x0008561eaab750ec,0x000fd959890272db,0x0009861b1b6617ec,0x000313bb875f3432,0x0000725d0e14f52b},{0x000a16eb56377ba8,0x000efa08332aafd7,0x0004f969b00c6f26,0x000e75b6f9b0d8bb,0x0000fe905ed9a6d4}},
        {{0x0009badc329d1f15,0x000798a2ac13e274,0x000f04f6cdc35ac5,0x000fff5624494f6d,0x0000234123bdb8fa},{0x0003d01cf2e4388b,0x0001a41004f7571b,0x00002b4c77fb6c86,0x000ef3131bac67d1,0x00001a55a5e1aed2}},
    },
    { /* digit=40 (1,2,..,8)*(2^{160})*G */
        {{0x00010ee253308b7a,0x0006b0f6d3549cf8,0x000f79be840ba3a8,0x0008682b46f33696,0x0000b318d895599d},{0x000485717b66f888,0x00087e17159bb2cd,0x000da105c3fffe4c,0x000a76272f7dfbeb,0x0000bfbd7894f96f}},
        {{0x0005fd5fa205d0f4,0x0004ee8ee36860ce,0x000c5b16628b839b,0x0003f4e13daf04df,0x00008b3aaf4c153e},{0x0004e879df3f3f34,0x00029941a4e0551e,0x000d33e8877228e4,0x0005911236772cfb,0x00007681b72c03ca}},
        {{0x000b1aad44ef0b79,0x00091a9b898fd522,0x0007938044627d81,0x000438af82fb38a5,0x0000b4a5e385644c},{0x0005a947eeafb773,0x000c02e7cf2c0846,0x000e9dbe8a7ea8fd,0x000b6d78d1c57d96,0x0000586ca615cf4a}},
        {{0x000e349a4b31aebd,0x000f2b0285b94916,0x0007b017d6137900,0x0002b0dab01a0be8,0x00008ac2977211f9},{0x0006974d05362415,0x000fd464a1c6a163,0x0005f2a0e55b98f7,0x000493f71d99e6b6,0x0000a0e9ca0b6129}},
        {{0x0008c8ce34c9e3ed,0x000c916fdd5b8549,0x0007be5fa36b2b51,0x000ae2fad592549c,0x00002d134c65513c},{0x000e5adca237cbc0,0x00077e7e9090b363,0x0008cd9cdf14f0ed,0x0000cb97467fc3ab,0x0000a00ba453f572}},
        {{0x000b8f7229523466,0x000e3a1cfe89d80f,0x000cdf0d11487037,0x0009c00d2b42c026,0x0000172110f51188},{0x0009ff21f71bf171,0x00008ecd850935b3,0x000c9c32bfbbecc4,0x00028143434c1a74,0x00001cad52349f90}},
        {{0x000ae1d3d9866434,0x00034a7b3f85ff0f,0x000c1fa6ac6b4768,0x00077b494acd21cd,0x0000ad41f3fb547f},{0x000c5c3baf25baf6,0x000e8ce8a1c5d92d,0x0003fff5cbcfc843,0x000221dedbca01a9,0x00005c09e40eecf1}},
        {{0x000d9cce837c6d61,0x0003d148f9290579,0x0006232b855bab85,0x0007c64ce7a64ae0,0x000028043d63ffdc},{0x000f181a75f69e00,0x00059796e93b7c7b,0x000172a383b1d5d0,0x0000029a0e1e4709,0x0000b9ee91160db4}},
    },
    { /* digit=41 (1,2,..,8)*(2^{164})*G */
        {{0x00026fc9c4cd4abf,0x000e23f1402b9d0c,0x00026a0bfe9f0668,0x000417f6e573441c,0x000042560b13ff8a},{0x0003ef07f65b14ba,0x00061fd7493cea35,0x000ec7090c603bd2,0x00077a68fd05d4b3,0x00006ce1efdc940f}},
        {{0x000f63cfc83f45b8,0x00011d646ac49d20,0x000b73afaae16770,0x000dca23842c77c0,0x0000cf54b1e93428},{0x0004dcfda1adde56,0x0005a1bc6441f959,0x000957b146ed74f3,0x000a15bba7d38f71,0x000080b43552bdca}},
        {{0x00014e77a0de8421,0x000cc45526f09fd2,0x000c5fd9ac6926fb,0x000a7dc8de8a4f10,0x0000d25068992420},{0x000b6cda791fe0f2,0x0007b7314faa40ec,0x000b3679170d12a8,0x000c08f3e767867e,0x00000e1e221077f7}},
        {{0x0000cd9c328d84f2,0x000ec10296c36eff,0x000191f73e449397,0x000f344da7ee8967,0x00003d52cf283e17},{0x000adab3ad961303,0x000c8f7e455fe908,0x000af39881456bea,0x0006ae1ec3fb53cb,0x00007d83567df6b8}},
        {{0x00097128795b26d4,0x000007d53b618c0e,0x000b80b150a9c145,0x0006c0564c424f46,0x00006ae4b9ab6582},{0x0000d841a1380e4e,0x0005832f815561dd,0x000502e81430573a,0x000171a4f85f48ff,0x000063896020863d}},
        {{0x000f7199dc46d818,0x000722b599ff0f94,0x00073193628eba9f,0x0009137f368a923d,0x0000ee5360c30393},{0x0004f710bd7921fc,0x00093f6e46f2a79c,0x000d25010260474b,0x00092d27c08b5dea,0x0000fab67c859c32}},
        {{0x0004828817b2b97d,0x0002c0f0e0b040d2,0x0002217d0167ff6f,0x00040e422baf02d8,0x00006eb8e36ece4e},{0x0001f86203c5e993,0x0008a31113ec3567,0x000da3f78ff4f368,0x000ea84159e48861,0x0000bb7e93050f1a}},
        {{0x000e3d7a82a07312,0x000248b4ed80940f,0x00057c32545a8fa1,0x00024459f67e6d05,0x0000781e5623c72a},{0x0009422f1dd9d9ed,0x00045027e096ae27,0x0006ab7164488446,0x00002f2fcb1f3e1e,0x0000a08771e4d556}},
    },
    { /* digit=42 (1,2,..,8)*(2^{168})*G */
        {{0x000b1adfbccd5f72,0x000bafb9db3b3818,0x000e49c42a8e58da,0x000a5741f9c3a2de,0x0000e1b4d1992caf},{0x000d2ae779d25bd8,0x00001397e053a1bd,0x000689b00f8d9c66,0x000aeefabee2be5c,0x0000ed75eb0e9aae}},
        {{0x00070ef12df3aecb,0x0000e7a205b9d8b0,0x0003fe5865a61087,0x00049560e6eb8f06,0x000018c288645dc3},{0x000c1f205200dec5,0x000d0053bcc876ae,0x0007bb212c914ca5,0x000c3165e12a7533,0x0000fee6eaee8fb7}},
        {{0x000b625175d3e131,0x000ba79b6828f364,0x0007b65b0a28d9d9,0x000a31a0c9d7a025,0x00003f761efd974a},{0x000cea06f50c8e7a,0x00025dd9669b6210,0x0006ea0e74a30782,0x0007f7cbc88a2ca5,0x0000eefdd32a930a}},
        {{0x0006927bdc72fcef,0x00092b5c4e83d33c,0x0008986accaed0f0,0x000ee5e0fd9f3587,0x00006fc2b4d5332a},{0x000bd4c284a559fb,0x00092f79f9e0f036,0x000e91031f24a068,0x000494df12868661,0x000064b67a214c5a}},
        {{0x00038062d4c1e75b,0x0004591289a8619a,0x000fc2f14e9e6431,0x000a96b32ef796e5,0x0000cf84b53f10ce},{0x000e2d93f2a93799,0x000b1200573274eb,0x0003eaf97fa1c33c,0x000a47520d07b67e,0x000099241c28bfc2}},
        {{0x000e16a8fa9459c5,0x00069533f36d1411,0x00042fe5fb485de4,0x000223d3ae84bb3d,0x0000362e47c092d7},{0x00051ac53cf453e0,0x00072adddd472e03,0x0006d8041bea2700,0x0004e95997d405ee,0x000072103589e10b}},
        {{0x000c45b260b78e4a,0x000cab84444896b8,0x000f6cfa759ac76b,0x000f5fe7d64974d2,0x0000fc1b25688826},{0x00018f2e67924f42,0x00079c2d84634875,0x0006ee2d190516ad,0x000a501c0d1b2b3f,0x0000036290195036}},
        {{0x000578dc4ce14fbe,0x000b08c06d75fc1f,0x00063cd0cc5274b3,0x000f629dd2dcf7bb,0x0000f36db3fef100},{0x000304c0d907ee38,0x0005103df2ce7a06,0x00083934eed34414,0x00075ccabaee3628,0x0000f1816df3580c}},
    },
    { /* digit=43 (1,2,..,8)*(2^{172})*G */
        {{0x00065ca49bf70465,0x0002633070d3aab6,0x000b33d03149eda8,0x000f82c732643672,0x0000dae397b7ff25},{0x0005986e7c2b0613,0x000c759b3efb9983,0x000ccf96a4c52f87,0x000f392308a5b922,0x000053a40c602f11}},
        {{0x00003172599604ef,0x000e04fda79e5acb,0x0009d5feaf05bd45,0x00080866e68b83b3,0x00000b424807d53a},{0x0005296e9538c34c,0x000381ac5ccc2c46,0x000ad873e1d42e72,0x0005408bd7d7dc96,0x00006a74e1c17bc4}},
        {{0x000cfc53b4244564,0x0004fedf0290a8fd,0x0005ee4b6fd35ed5,0x00009974fcae8196,0x0000c1f220ef19f4},{0x000bedf5f9d4ef28,0x000ca3c4cb632f9e,0x0005cd318a6d91a9,0x00094f00ac42a1ad,0x0000689a17da238d}},
        {{0x000fd495f78c275c,0x00068cdb30cfb3a6,0x0000fcc91ed14bb9,0x000a17ddf6d09b8c,0x0000645d0ce04a7b},{0x000dc229b0415b16,0x000009f275264daf,0x0005e7bb59b2b9b3,0x000525c2280c2b74,0x00002b3172744708}},
        {{0x000e98378c350e3c,0x000c25a59b0ff628,0x0002b1fc99481f98,0x00035431d25ec81a,0x000068a37387c1fe},{0x000ebf428f4945e2,0x0009bd6f48485983,0x000f243e60db09cd,0x0002efd4687f2c5b,0x0000e57b62bb98a6}},
        {{0x000fa5e9a55e99f0,0x000bc7ad0d350a3a,0x000860b4358a0879,0x0008b504684f6ebf,0x00009bc6954fb2b7},{0x000e47f1dc72cd57,0x000587c1cdd69b63,0x000020a0729886ae,0x0005a9f2a64081a3,0x0000092024e42c9f}},
        {{0x0008186df8037536,0x000287fb7f01d83d,0x000a6db487d36c22,0x000fb5d0f5f1f860,0x0000704dccf6c287},{0x0004aaea176b654e,0x0000fa01720468f0,0x0000fb9b626920a1,0x0001293ca4247726,0x0000473f7f1fa757}},
        {{0x000fc20755e3176b,0x000828452666a58c,0x000016e7bc6ccdba,0x00078f9084bcb6e0,0x0000554faca4c643},{0x00094e142cf0b0d6,0x00046505294dba30,0x0006822fbef1afda,0x0006df474a30ba28,0x0000e6be6e6ae1a8}},
    },
    { /* digit=44 (1,2,..,8)*(2^{176})*G */
        {{0x000b296904664fc3,0x000b53e979f39254,0x000a642320a351cd,0x000cc34fa1efd130,0x0000a26d827b4096},{0x000df088ada01cc1,0x000d534b9db65b69,0x0001656914dd4d71,0x00018a2f335c82e3,0x000058dcd3dda1a0}},
        {{0x00008fc59cde3468,0x000e7124237b64b8,0x0009635d376aaed3,0x0004ff5d8688ebe9,0x0000c1b55d497018},{0x000b143a98f532c8,0x000632ba3585862b,0x000532de58edb3d0,0x000ebfa9bb66825d,0x000060efc436424d}},
        {{0x000f8f66b8a7cdf7,0x000c324f111661eb,0x0003f176844bf6c5,0x00056be78edced48,0x0000217f1b2be94c},{0x000ec85fbc8973e6,0x00067f4d7ed8216f,0x00068f645f12fdb9,0x000735154bf07f37,0x0000c3cd2d5edd0f}},
        {{0x000f53916fc6beae,0x0001122765fa7d04,0x000fce16c2004cf7,0x000c22d9859805be,0x000052df10ff2d7b},{0x00099f450e1f9830,0x000c61f33ddf6269,0x000e06e68bf551b7,0x000e86ee34206238,0x00002aa249bfa9c5}},
        {{0x00047aa4c7ac2b3c,0x00082731a3a93bc2,0x00057da03752d6c3,0x000d7d2fd42bbf46,0x00008348bc06dd42},{0x000825653cf027b6,0x0001032f60c77da5,0x000a69fded019b66,0x0001dc3cf6ffbc26,0x0000333cf94fd444}},
        {{0x000ddab96e59ccf0,0x00077ba4a493b31c,0x0001ce1d36b7f226,0x000c8a14b54f20a5,0x00001a428916f43d},{0x00047a670dede59a,0x0002d0aed25ea138,0x000afd5154d9620d,0x0009faac5fa1d09e,0x000024f267bf7958}},
        {{0x00017e76ea8b4aec,0x000d995d314e7bc2,0x000b24fa2303625b,0x000d3e9d32ee7464,0x0000fd86bbb7517e},{0x000a5817e3ed6c66,0x000681fe7cda917f,0x000a903127323a60,0x0005ae96b12d8016,0x000044afeb2ca0b2}},
        {{0x000b69cbf65aaebc,0x00090c5ac751e7b7,0x000281d845c75cee,0x0002f93c693f9647,0x00005a6bb7c3dc6e},{0x000be7048732b0cf,0x0003da2f4bf94e19,0x00085541905b0af8,0x00067070b1a5325f,0x0000e3a10d49e546}},
    },
    { /* digit=45 (1,2,..,8)*(2^{180})*G */
        {{0x0002dfa557bfa495,0x0000476e1337c262,0x000db45dc38dd4f8,0x00012d3d96faadeb,0x0000c13ada75bd32},{0x000c6ca5801dad5e,0x0007c17be93c6d61,0x000188985039af29,0x000bbefa124866c6,0x0000462261edbc6f}},
        {{0x0002edf52c078d85,0x000c57dd4b79bb87,0x000adfda839ce9d2,0x000ba33e8aee806f,0x00007fc8b3dee585},{0x0003b2818874b38e,0x0001a4e2127015a3,0x000069054d6b7749,0x000ba60c89051d0c,0x0000fcc7ea0acfb4}},
        {{0x0005464d0e55495d,0x00003ed9aed9f40e,0x00006de43f8b680d,0x0007a14ea70ca6ad,0x0000ab349a9bed40},{0x000e0296a877751d,0x00012dfd9e535ef8,0x00070ac681b2a37e,0x0003f0788abf57ea,0x0000a2d6ecfa6e9b}},
        {{0x00063f4153af6dcd,0x000c683171b445fe,0x00029af26bf85199,0x000cbbae89bcf21e,0x0000e2560e6db219},{0x000e1d75ae224a6c,0x000f6a930add43df,0x0002cb637aac5049,0x000bc7d6862ebb14,0x00005e73664b3718}},
        {{0x00093a787b955171,0x000d06e1f017d5eb,0x0005bd3a711ff605,0x000a317a03753339,0x0000d94a848d4553},{0x000d57bd8e1e0fef,0x00062a2dcc99ccc0,0x00038d4cbe8fa59c,0x000cfe9d5c134b41,0x00007c0347ff2191}},
        {{0x000145c114649f08,0x000f3ccf0bcfc46a,0x000e148a3dd22dd7,0x000be895b3a822ac,0x00007ff5e819ea62},{0x0001437bd32a8c35,0x0004c538be17bcdc,0x0002e928c1bccb8e,0x0008a932f01e867c,0x000082bf7d9a8a3a}},
        {{0x000d10ec409dd077,0x0005b006c19d4c7d,0x000704a0fd36352c,0x00021c0e8a0f3c43,0x0000f1b113eab5f7},{0x000cbd604ebce52c,0x0003d6cac7cd3e1f,0x000b62675f9792a4,0x000ca4b06ed3714e,0x00007ff6667d89a2}},
        {{0x00080034798ca4d4,0x000f2c7af8685c8b,0x000d778ecd30d2f0,0x000cf952ad4c1c8c,0x0000e198f05db898},{0x00063d51806a84e5,0x000e1e52eca3cdb7,0x000b75c78219120a,0x000a6e0cfea1db16,0x000052a4a35bae24}},
    },
    { /* digit=46 (1,2,..,8)*(2^{184})*G */
        {{0x0008e13092cf573a,0x0005c3f4c8303203,0x00005750d3512460,0x000db40fb842c7aa,0x0000494598d37817},{0x00077989cb6b3d8b,0x0007062757558f1a,0x000150731ef6087b,0x000f58b273cc3e83,0x0000ffa7db45a98a}},
        {{0x000d84601a040653,0x000c4f4b0166f7a3,0x0007916814ccaa7c,0x00080f8fdfbd3e3f,0x0000bdc4370992dc},{0x000a6279f7786e45,0x000a95c7c1620b02,0x000d01014b0992a4,0x000fa801eba68b4d,0x000052fa0f983aed}},
        {{0x000a03aee51cbd7a,0x0003eb0b796d2197,0x000eba706ef4966f,0x000307cf5c3e95f4,0x00007329daec404c},{0x000aacb62b09eeb6,0x0000d76f53a89aa8,0x000109dd72b102e5,0x0003bfa4f0d8af9b,0x0000584ec8a3c986}},
        {{0x000a4c97a4abc3b1,0x000629f8f5fcda83,0x000483a1c45951ca,0x0007bee77f3e558c,0x00000e48e3d45037},{0x000f9b7025a36d96,0x000524bf6dce6a73,0x0005d44b52ac36ba,0x000ec10e9ff373d9,0x00005254e73f1733}},
        {{0x000f6e149c30d036,0x000786c252bd4796,0x0009a3476ff36be0,0x000f9406305e0f88,0x0000f83a58f41674},{0x000e1a0a8596c4ab,0x000785cde601a897,0x00087559b39a4f3d,0x000826d27d17bbe9,0x00009be39f3ad611}},
        {{0x000e3c3c1d7cda3d,0x00032ea87baa6279,0x000158ee6a629579,0x0004420c958c1fec,0x0000d64ac7b719e3},{0x000792f805f03b27,0x000eb7b2bcfe0b0f,0x0001327ffd07ff8c,0x0003e8c973510710,0x00002665759bab58}},
        {{0x0000291d43fc236f,0x000e82235e6fc06c,0x000e4b14f6918efa,0x0006704723477728,0x0000cd51067b09ae},{0x0009f8b71be82198,0x0002467cec5a196b,0x0003a235d360dea7,0x0004c8451deeb31e,0x000071e8bcc32913}},
        {{0x00005ab8b7207ede,0x000a6911a335cc88,0x0009e9fe5b2d6bb2,0x000344b19563459b,0x000063bbb632aaa7},{0x000b647545ffb149,0x000c9da8d006086c,0x0009f1914bb72b13,0x0006fefd76ca4846,0x000088e4372592ac}},
    },
    { /* digit=47 (1,2,..,8)*(2^{188})*G */
        {{0x000cfd57c06983bb,0x00098e453544774f,0x000b3dde4afbe78c,0x0005fb6f5834d0ec,0x00007bae9c3b3751},{0x000ee4d65bdcce8d,0x000ab3dd6901b1d3,0x00047673a7680203,0x00093d2623b49fbb,0x0000be9b2e57312a}},
        {{0x0009ae30f9bf470b,0x000087d0d63d1fae,0x000118fba7a5a59e,0x000fc5809658fc05,0x00005a1e22227a90},{0x00083acb655ee723,0x000edd1818baf918,0x0006032f40bacfef,0x000334844e27e9e0,0x000040f4d53495bd}},
        {{0x000363b0cc192c11,0x0001d774e6daae2d,0x0002caa668f0d453,0x00082567e7b3ae0e,0x0000eb18f19fbe78},{0x000e6d2a4ad162d6,0x00046cf309ae93b1,0x00071ab3a096ecba,0x0002c0901a3f80be,0x0000db5da2662978}},
        {{0x000ee84e265cd5da,0x000988dc2c6ff707,0x000f46f3d40f2a5f,0x0000c9df979d6122,0x0000ed01e35bdcbd},{0x0002d0793015eb1a,0x00095b063cd880a6,0x0005d2a436307bbd,0x000f365423f3ea7c,0x000081c0177d53ec}},
        {{0x0003403ae96daf9b,0x0005aaabeccefb5d,0x000862e19cddd34e,0x00005dbc1cf56ede,0x00001050a209e4e5},{0x0009710fdf7e6a41,0x000c40de8785a64c,0x0006cd11554ee79f,0x000527d0210f3d64,0x00003c2dab8fffd1}},
        {{0x00065f36c733ecb7,0x00097438a5807cef,0x0002edb163b75a2e,0x000e8e6daad28389,0x00005a009a4a047b},{0x00026231865878db,0x0006b9ea60d32b2d,0x000a6c1f604286b8,0x000e303b5ee93df4,0x0000ae2226c13edc}},
        {{0x000f246cdd4e3845,0x00068e73245980e9,0x0006e1e20523881d,0x000db26e1a6f5965,0x000056940ffbe18c},{0x000cde6b503aafdb,0x0005617f961ac0ef,0x0004eefd32ca8809,0x000b960d1c8a741b,0x00006dc0bf51f631}},
        {{0x000968734e4dd7f6,0x0008df9dec31a21e,0x0002817162256254,0x000a3ed65988c8b2,0x00009bb859066057},{0x000f94739f3adb65,0x000858f5da6309bd,0x0003e25d5a77565c,0x00068a42110f3a62,0x000053d37190038f}},
    },
    { /* digit=48 (1,2,..,8)*(2^{192})*G */
        {{0x00003f3e034d81e9,0x000580ef4f8b16a8,0x000e443be8670976,0x0001a9ec197241af,0x00001dd783168b20},{0x000097440f10fef1,0x00018a804dbec69c,0x00067b238c506e04,0x0008f287fa83b85f,0x0000d016711f649c}},
        {{0x000a1a96613ebed5,0x000aaa0b311898c7,0x000452f4160400b5,0x00055fbbce2a272e,0x000044105e96f0ba},{0x0002280dcf97d62e,0x00039cea1c8cde9a,0x0008d0499e144dcd,0x0003fe7cd9d958ba,0x00007fe9ad9ee6a5}},
        {{0x000320c5cb34fa83,0x000c1a43794f8dcb,0x0009951b966af168,0x000a28da0dcca923,0x0000bdaf4528f40a},{0x00083be9a0dbe4b2,0x00076ff47b50a951,0x0001b6b449d08629,0x0002b4f53933e3b0,0x000077b42a87e4bd}},
        {{0x0000a02b0eaceafd,0x00088c341dca5663,0x000aa7c1ff9509d6,0x0003070fb7de7fed,0x00009716331f83e3},{0x0005f449ec69c78b,0x00092aa2fd3cf36d,0x000709959bb35e00,0x00081dc33d131954,0x0000174691c29863}},
        {{0x0006166b44b3b527,0x000e8abe085116b3,0x00055111e7cb7191,0x0000aae2f04a4337,0x0000b8cbd7d43a2f},{0x000af71e91ff6ddc,0x000673cfd4b322cf,0x0006bf828cbf933f,0x0006d39eb726aa81,0x0000f4fde56a46c2}},
        {{0x00081dcee597d414,0x00087dac97e65165,0x00006a1325b93f7a,0x000a0d6498877936,0x000087e6a262fd86},{0x0009a34fc66e7cce,0x00055918f483f148,0x000c479481754c72,0x000f76c426d2dddf,0x00002d39a7634863}},
        {{0x000cca31c7a57625,0x000ade949dee1686,0x0002d160c071cd59,0x0001de16a1ae0522,0x0000da394a68f678},{0x0007da93fd13da3f,0x000971d9bc499082,0x000cce082821a131,0x0009544ac4a9b4a8,0x000025d76c70fa80}},
        {{0x000e658aedcda8bb,0x00031644cd8f64c3,0x000fe937f063f6ea,0x0001e975658a2d78,0x0000049c304fd752},{0x000473ffef5b241b,0x000792e05da59eb6,0x0002a9683732b03d,0x0000a6487ba3d60a,0x00005d72e137e219}},
    },
    { /* digit=49 (1,2,..,8)*(2^{196})*G */
        {{0x00099ee566eb922a,0x000364f692ac542f,0x000028dcac6c9771,0x00018cfbdf079ffe,0x0000610be982fc2a},{0x00013889ee80e815,0x000511fd62191997,0x000663545a2e0935,0x0008cc4048c883bc,0x00000920149ca0bb}},
        {{0x000eee0c0ea6e1a4,0x0009b8f81a1b3bed,0x0004ef395891f049,0x000e351f74f3ce14,0x000069aac489bd81},{0x00027729a694a1ff,0x000aec0d39e25c35,0x000071f076d9e952,0x0002d5b584061982,0x0000a6863991eccd}},
        {{0x0001ad919aac7231,0x000d837b1b76ba6f,0x00045b7295421df9,0x000677d0a1a2eab8,0x0000c06c35fd7a6d},{0x000314874f18d1ae,0x00031b807ea7b0ef,0x000e4bc5643a1ce2,0x0009b5aabedf5496,0x00007faef00cb014}},
        {{0x000747ea0bede08a,0x000e0753f73f449b,0x0007d5fd126e01d1,0x000e0524d1d1c94f,0x0000db80899bb94d},{0x000c10697e01e74f,0x00074fe228d291e6,0x0004d7b0c0585031,0x000c5761635b804b,0x0000e6909f3f3acf}},
        {{0x000a8f2439972c6b,0x000d88f0876fd4e6,0x00071943cf4a2c61,0x000dcc9cb45f0c30,0x0000274cda09b319},{0x0004426efde75793,0x000b01b65ccde7b6,0x0007c3a4fb720a13,0x000dcf1d741e2cd1,0x0000483cddf39166}},
        {{0x000d32fba5127c0b,0x0008344fc94dea3f,0x000edda3a50b098e,0x0009531ef34c8cdb,0x00009ea6e5479af1},{0x0003173f9743bb5a,0x00036f6795dcfb75,0x000330414c181516,0x0006467c0fef01b0,0x0000608f1137cc86}},
        {{0x000731021c804f19,0x000272aba16f73bc,0x0003c5c8b7dfaace,0x0001fdebf2fb3101,0x000060e66ffcf1c4},{0x00051f55a60c6b7d,0x000ca244fee99d47,0x000685a66c4490cf,0x0007f1df74bca48b,0x0000e008421c6eaf}},
        {{0x0008949a50ad4589,0x0009c1acb452fdbb,0x0004985e6bffc0ea,0x000efbfd931ee696,0x0000aba564d3b7e5},{0x0007a12f75fecfe0,0x000a3263c88f3bd1,0x0000c37c6a1321bb,0x00004ff03ab147c3,0x00003bd493c68746}},
    },
    { /* digit=50 (1,2,..,8)*(2^{200})*G */
        {{0x00032811a7abd874,0x000db7881fdad909,0x00057a04e50379b8,0x0002cd9e5cf638f5,0x0000f7d1bc229820},{0x000dd099becd5a2a,0x00089309bbd11ff0,0x000fa633afb561a6,0x000f7a86676108a6,0x0000803fa54a21da}},
        {{0x0002ede0e2398f58,0x000858a58d6cd461,0x00057b7853efdb37,0x0008c6b289cb633b,0x0000c7e7d1c765be},{0x0009e66e59813ff9,0x000d162065a6f4f9,0x000ccdd7da21b1ec,0x00007f41cc3a47ec,0x00006d5b783c2d8e}},
        {{0x000e4bf888b90c57,0x0004f777b0ac93d1,0x000d5aa9e84f32ca,0x000e8f22ba6e37b0,0x0000c2bfd71f0dbd},{0x00029438c4942ce8,0x00044e04df0ba2b4,0x000d0dcdfb573987,0x0007fc420935d5cf,0x0000d2dbc8e26eee}},
        {{0x000aebfa4044443e,0x000fabe67e573e06,0x0008d598ca0bb6e3,0x0007d84c505891db,0x00008b6a89573352},{0x000fd835db9f7005,0x000d7e9e56e55c19,0x00028cd210f50d2c,0x000afe3eb7148ced,0x0000282da8971416}},
        {{0x000d8c8bc0a17b96,0x000d956c17706169,0x000d6c4e0e6ccae6,0x000f778455351909,0x000039e97d726501},{0x000386493c5aa83e,0x0003ab6056becfd1,0x00038d0a6a30f997,0x0009bf4f933f1325,0x00003ec9cf3e5b1e}},
        {{0x000af546c8a478e5,0x00009fa5abea82a6,0x000929091c0b931c,0x000a611068dc611b,0x000031a3754d6e83},{0x000243fc70d1d9f1,0x00087c7c977ec238,0x000c3b180905907b,0x000f7b3c0a8de294,0x0000453273a39eaa}},
        {{0x000f989c69b6cdd9,0x0001b00b008733a5,0x000cf19582ee2e99,0x00082c3d0cba0697,0x0000f5ec6cff4889},{0x0003404faefb719d,0x0002c724c3c2b2fb,0x00084bc2cff9824d,0x00064341f90e02fa,0x0000ab3d02a9a4d4}},
        {{0x0009d7b51caacc1c,0x0008509081e9387c,0x0006c2bba30bf8a1,0x000749415fb9780d,0x000016b6886a163a},{0x0009d9971a12e8dd,0x000f041d6d9f6711,0x000897c914fde7c4,0x00037415fba6c1e2,0x000044ff79be19da}},
    },
    { /* digit=51 (1,2,..,8)*(2^{204})*G */
        {{0x000a38783edbf56a,0x0008a62060b5f619,0x0003e197df84183c,0x000ec5565a56f46b,0x00003d764abc2d6b},{0x000a0edc3fc096b3,0x00080a9da710718f,0x000633fc0eb6b9c6,0x000931e875a77998,0x000072910f080d6c}},
        {{0x000c351b873ccd50,0x000f849cb198ac73,0x000cd2f12adddfbb,0x00052b678a884a93,0x00006d2e4199685e},{0x000ba6f9e2ce488e,0x000619fe2c4b44b8,0x0006a77f7f29e16a,0x000b9984a580f6c4,0x0000c4fae9993e3c}},
        {{0x00043775095179f6,0x00074b65eb03c0ee,0x00038e84cad4f821,0x000c08ad2f19b795,0x0000a815addc931c},{0x000a6a2475d15354,0x000e250bb3ee8a3e,0x000bc6c7e2e9f012,0x00084e0f675eb14f,0x0000728fb5f890a9}},
        {{0x00079fb23be5ff7d,0x000b7abd3c095f18,0x000e5d17bb3553d9,0x0003eec8404b261b,0x00004c7b8e343501},{0x000f0ac52ff88cf7,0x0007572dfd754907,0x0004e2b22c9118c3,0x000d179073a97d08,0x0000d6bca24f52c6}},
        {{0x00062d8c5230f8f7,0x00029ee4b049136e,0x00014f3cb9c19a54,0x000e78a288b63bf1,0x0000675ced19a43f},{0x0004ac0245017d70,0x000da67379e7896c,0x000206517d607078,0x000c44a6ab25237a,0x0000c32d492b5336}},
        {{0x000e008c5bcdd3fe,0x00003fb319d76820,0x0008fc97a392e47d,0x0008db544b029312,0x00005611953b5d34},{0x000d3a1aadc08c32,0x000ab1c0278ca331,0x0006c870390417da,0x0008770cf666f76a,0x0000e48921cecb9f}},
        {{0x0000ffc1739db82e,0x000d6ff50f75f9cd,0x0002ad7569ae9e9d,0x000e1e3181d8eddf,0x0000eddba8e1699e},{0x00002aac66c37326,0x000c6e3037d90f29,0x0005d02ad905e85e,0x000d947afe3f307d,0x00000675780cc1ba}},
        {{0x000709def8c8c5c7,0x0004c1a567193ec5,0x000a8eed0812adee,0x0005924ddaf3c305,0x00002a0743a5403a},{0x000f431d23ed5fa0,0x000f9830eb2b6692,0x000b5818530569a5,0x000050c164d80ce1,0x0000cf41a7008416}},
    },
    { /* digit=52 (1,2,..,8)*(2^{208})*G */
        {{0x00037dccb38225c9,0x000f315adf7cccff,0x0005ec2414fcf3b3,0x00075f87e81a3e5d,0x0000f61ae1e090a2},{0x00009fa4f71b333a,0x0000e73907fba12d,0x00097997840dbf32,0x000506cc535daa6d,0x0000b54ff864cf47}},
        {{0x0008797e91aea7cc,0x000a480eb6b242d6,0x0002d2f863b4d485,0x00089479dd30bd02,0x0000e4b655e68a0f},{0x000d53005ec1aeb9,0x000290a6b4e185ab,0x000d8586b6a88091,0x00048c81b82f2c67,0x0000bb2a23d0098b}},
        {{0x000933d489d97ae7,0x000bb9e5cfe5c487,0x000e082b0c0ceb9f,0x000cebf8a82c020a,0x0000ded88fbff89b},{0x0000c73ff49bb729,0x000642e67c51e574,0x000a98cd0b0768e2,0x00043b1c60f64020,0x000020d51988ed0c}},
        {{0x0002f4209bf9bcf0,0x00059be9d8e68fd9,0x000288102284ec39,0x000064398db0f053,0x00004a5dc6b917e7},{0x000420b560d4b030,0x0007fcc1a739d4b6,0x000f3e6a037e1521,0x00016c1d009aea75,0x00000584c6da5516}},
        {{0x0005c25bb9b62679,0x00086c75488771a4,0x0001396cc5d8091e,0x000d1f142cb76e3f,0x000053b1fbdb29de},{0x00090a8fd649ba14,0x0008a31f88ce6dce,0x000c62ad1ca78ee8,0x000acf8c7be2becf,0x00000873b8c63e6b}},
        {{0x0003c778da9603b1,0x0004c5696f37750f,0x00069d8907179717,0x0006192ed25dda55,0x0000eacdd235716a},{0x000ba0f75d54c23c,0x000b8463b04938d5,0x0006234e9d1e300a,0x00020e9b53d9dded,0x0000bab7f97bd886}},
        {{0x000760871c2b484f,0x0004c8b4ebd3f02d,0x000caf56e9cde387,0x00059c4cea47acd9,0x0000eae7a0124e02},{0x00098b00ed0b01b8,0x000a0e536e530d74,0x0004cf87ac646f5d,0x0009e6d2a7abc52a,0x00002f3c4af4c323}},
        {{0x00082b921a859ae8,0x000619c6254dc41f,0x00038257ec641913,0x0006a3ca77e29392,0x00000c021e167183},{0x000a3d8c1544aca0,0x000f62e1402cec5e,0x00070ff1a4d2048f,0x0000bd9cb9f17ca1,0x000074174697d3a5}},
    },
    { /* digit=53 (1,2,..,8)*(2^{212})*G */
        {{0x000e0ace9790f135,0x00011e60ebcf7262,0x0001342678767f4b,0x0008aec094482b83,0x000086d2546132b7},{0x000cf8daedabfb38,0x00071d31f8d1f420,0x00014a5069e4864b,0x00083fb4b1b1e83f,0x00006eb2e2034cf9}},
        {{0x0004d5ef9bcae914,0x0000b0d1e935abb5,0x0003c077f3debaf5,0x000b3d7b5defd10b,0x00005a2eed07f66b},{0x000687601569519a,0x000a7ba74f17e266,0x0008123a7dcee411,0x000877efdc0a0e3c,0x000028a9a1af6c1e}},
        {{0x0009432af25a44dc,0x0003c0c207674f17,0x0006ba6b64e961d4,0x00069db1e112e09a,0x0000b97a68266210},{0x00016fbbff8bf955,0x000008fde2ddec64,0x000f11e7b94049f2,0x000e7c08a81392d1,0x000090f2310497ae}},
        {{0x000a995e5dfbc6e3,0x0004fc7904fc3fa4,0x00057d4a050cf2ac,0x000caf6aa14a23f4,0x00009e74b3de65f4},{0x00016c563b4a41b8,0x00083ecf3a5598a7,0x0007407e5359d663,0x000c3283c56534b1,0x0000a377a93e6974}},
        {{0x00064110e3d7be93,0x000db892f3b26e7d,0x00000446416395d6,0x000c44aa3f470986,0x0000d33c4ed3954c},{0x0002e3c7706265bd,0x000d02cfad414e41,0x00081bec63b3b22c,0x0001c5ef12b155f5,0x00004a979c09ab69}},
        {{0x000e709afd4ebe8c,0x000b8ea308780f21,0x000119d55ae78e9a,0x000664ba3dc8de76,0x00001b9c38ab8027},{0x000526074ae5ec7c,0x000c776021704560,0x000ac3d34419af49,0x000944e68bf204b3,0x0000bf2f1a243170}},
        {{0x000a45755beb5e5a,0x0004c3e7882f14f1,0x0004ed815580f741,0x0002464d0c9f6dc3,0x000088180b1213cd},{0x000ca2ca9f747a28,0x00054277c4608cf7,0x0001d9dd48232ab2,0x000f8730e7ccbdf3,0x00005ef4880c3dec}},
        {{0x0006539c7de5db9b,0x00043a7e0f222c2d,0x000b9c92b4c46a68,0x0003b3230309d42a,0x000069a4869c5fac},{0x000331fb46a1f47e,0x000277c432ac7d72,0x00000f4ddec961d1,0x000121ade72692cf,0x0000f86aeb4b1886}},
    },
    { /* digit=54 (1,2,..,8)*(2^{216})*G */
        {{0x000ffdfc7e7c2a09,0x00085eae457a4773,0x000bae6fdf8723eb,0x0009a0d71d19857d,0x0000d6ef525ea59c},{0x000d15002a515a26,0x0002c5426ee7cda3,0x0009a1edc37de8e0,0x000e199c8341b086,0x0000bbb468e51820}},
        {{0x000f6927b0d79bd1,0x000614c85edfa308,0x0003f86bcc29875b,0x000193b862597655,0x00001c7d62051005},{0x000d0721ecd294e3,0x000feba55f2f94c5,0x0008d744240dfdf9,0x00015625d6a996f9,0x0000e456c18ca0d6}},
        {{0x000072c30c9a3e3f,0x000a8e9262a35393,0x000d35fe1292598c,0x00087a2b978a49d1,0x000028a1a98b5727},{0x000912e3eefde708,0x000825277c850e61,0x000f065759f71f40,0x000459fad84f15f8,0x0000a72b7cdf565b}},
        {{0x0004cae01e64c20e,0x0009b2079e5fb67e,0x000a8bdf924006e5,0x00033ca37e1331fe,0x00003ed077fad719},{0x000c957822ca746f,0x000cfe60412a77db,0x000c22af18030eaf,0x0007aeb3106ff7ca,0x0000cacc54eeaa59}},
        {{0x000cfcde2a6c31ad,0x000d386365e668b9,0x000a0dc0c7d17066,0x0002d72beada8dcd,0x0000ed8b493a21b9},{0x000d65adf799777f,0x000c63e7e85d1e48,0x00096bbdaabe1343,0x00090a4ff9ca0967,0x000015220dfe9e8a}},
        {{0x0007e0aa7adc7a48,0x000db0cb0ce1c552,0x0004e3df0b8cb07c,0x0009bee3b5b534d0,0x0000fda2b88e9831},{0x000f7d9eeff2ac2e,0x0007e2d79362c410,0x0000823dcdc0db71,0x00077b12467920c9,0x00001801931c732f}},
        {{0x0001ff32eab51c2a,0x0002df10296f4fd3,0x0003b852814bc239,0x00078de051dca76a,0x0000dc7706867646},{0x000c2397edc895b3,0x000c8f18d2c714bf,0x0008327992dc9ba8,0x000467a2364b5c33,0x000088766fb7dea2}},
        {{0x000f5fa5904e2bd3,0x000209afa8338349,0x000206d2dfd21b18,0x0004529102295172,0x0000fd30a26b44f3},{0x000137b286ed0846,0x0004125e77d9a3b0,0x000a624d3959c964,0x0003d9c4a11235ce,0x000037f27954916b}},
    },
    { /* digit=55 (1,2,..,8)*(2^{220})*G */
        {{0x00061bbb05f9956d,0x000106ac42bd6d29,0x00082503dba8e1c1,0x000ae458e6df8646,0x00004572780d144e},{0x00004d881133b185,0x00070f070a6a26b8,0x000cb240e6288319,0x000ae43d370686c0,0x0000da343e03be55}},
        {{0x0001567f755e516f,0x0002de74462007dd,0x00047b5f76420568,0x0000d6ee7b8ab48a,0x00004f2bc1635d97},{0x000931de26c2af42,0x000d96b0887bcec5,0x000e8847159b8388,0x000b324cb694497c,0x000039c7e289bc5b}},
        {{0x000b15d6243f1091,0x0000ca11f17a34c7,0x0008a8443e31d5d4,0x0003fa53b5420ab3,0x0000927b5e2d1cf0},{0x000424051138a243,0x000fdb1e274e49c4,0x0004528d80f9684c,0x0000da2a45cf5074,0x0000abcad67dae2e}},
        {{0x00084e81ad96c3d5,0x00080021a93507a4,0x000744ed85217d67,0x000286a40b4cd118,0x0000702de63abcfb},{0x00077e27e30a727b,0x0000cb5272e9d6ec,0x0004ff812967789d,0x000a6af8eea1c93e,0x00003caac07df9b9}},
        {{0x000098baf9cb4cd3,0x000b81e48ac28403,0x0004bc21d97de9e8,0x0004798431831129,0x000013750d1196db},{0x000ae9e34b83b95b,0x00066584198da522,0x000be98219cfe30b,0x0007d4e08ab4fc17,0x00008387d9c3f13b}},
        {{0x0009f80d55b0c703,0x0003dec0ccced589,0x000b73ac42429524,0x000510fc625cd4b9,0x0000a65aaf5a02d6},{0x000f34bb38b3eac6,0x0007ac9ce6dc1532,0x0007a93199e8a328,0x0001c3b4d138d511,0x0000ca319150839a}},
        {{0x00061e15b0193f73,0x00026e84a34f239b,0x000c02e5ed252835,0x000fb353215fdb83,0x0000611a80a40f29},{0x00053277336c58d7,0x00082d4a127f89a5,0x000bb2b59fa73e65,0x000bfdf925d541e0,0x000059c1e0662639}},
        {{0x000f9b71b8c0f425,0x00077f2d0c051995,0x00029b4c129bcbe6,0x0007e7c82502fbc2,0x00002b22165d2734},{0x000b6e3e8373047f,0x000bb592b82dd077,0x000519b4c4ab6dee,0x0004bdb327630273,0x0000227777e79e51}},
    },
    { /* digit=56 (1,2,..,8)*(2^{224})*G */
        {{0x000c41114d0d0f0a,0x00071c035d0b34a2,0x000b56e6af5ad632,0x000f458d1440b386,0x00009070851ee09e},{0x0000477abf63470d,0x000c1f1ad95a0b12,0x0008478dc8a2c85e,0x0009d79c9c09b37a,0x00005669d660129e}},
        {{0x000a68df70882277,0x00065b3292a92874,0x00062d47b35717e2,0x000498f05ddc15cf,0x00002045f41bf3f8},{0x000a8b9343580755,0x000f94505bf7dd0a,0x0008e243ec49440b,0x000aea3afa4e63d3,0x00000f5462133be9}},
        {{0x0006113c503cd9d4,0x00061b51e706ad97,0x00044d98af8ed595,0x00086b990b99cebb,0x0000a86e1c215f82},{0x0003cbb144e6b9aa,0x000e4b097e2b5aa3,0x000c2fed61bf9a24,0x000125c6c7e1022c,0x000044eec8aec086}},
        {{0x0004e7b4f75c69c7,0x0009d717af715d2e,0x0003eb2b959f67ad,0x000b50256e2f7f59,0x0000faa39a85f847},{0x000657624d4d6888,0x000779788d5374a6,0x00031a2adb0e9860,0x0008607e22b915e6,0x00009ed17ced0865}},
        {{0x0007e49f538144e9,0x0000801dace5aca9,0x000179c203139436,0x000579d09c4fdbcf,0x0000b8c43e3ced43},{0x000f036040802177,0x0007090937e2ad5c,0x0007636ab7b11bc7,0x0009a49dc846e250,0x000015f05617398b}},
        {{0x000858e1e42fa26a,0x00096e07442f1d58,0x0000de8801c7a755,0x00023d647475607d,0x00002129ca073288},{0x0007cdea3e2c120d,0x000050b8231ee10a,0x000abbbc34902c47,0x0009866a41b80e7e,0x0000ea4fb6751c9a}},
        {{0x0005b9d57b4ca325,0x0009b07f8ae7c38d,0x000b67ba2c17122d,0x0004048b36db07a5,0x0000c13547ebaf13},{0x000fe5a101822457,0x000dbe78eba20f2f,0x000e71d40250d287,0x000744f58ef11ca8,0x000067b29ced3d7d}},
        {{0x000af127793627f3,0x0008811e51732d26,0x0007ba47d495211f,0x00011fbc5dfd6eb2,0x0000d0277a7c5305},{0x00059aba7caa2e14,0x000712d06c425aef,0x000b6687611ec682,0x00054599c6df92f8,0x00003f2120a92224}},
    },
    { /* digit=57 (1,2,..,8)*(2^{228})*G */
        {{0x0006605ecd65db55,0x000d72e421d3aa42,0x000cc1ef49735da2,0x000798f1cf926407,0x0000115826b66fae},{0x000b337ce7ef919a,0x000a7a6d6a5eabf5,0x0003c637e9a63491,0x0006f67021edb84f,0x0000746c950ad014}},
        {{0x000add3db7ec68b8,0x000b386d23ddc820,0x000c732406385f9e,0x000123ac503fd344,0x0000078adedd4745},{0x000755e7ed4c6729,0x000153f8260e01bc,0x00048d4be4a45000,0x0008bbb33fbeb49e,0x0000d816465d0546}},
        {{0x00074a9e86f273ac,0x0003768da9f3804c,0x000dda1996154227,0x000ef0ea5470f07f,0x00007a00585a4292},{0x000a3d7f108e6847,0x000633543471a24c,0x000deddbc6014539,0x000748d4d239446b,0x00003d82eda4eff3}},
        {{0x000157c30c88e767,0x0007447f23206d55,0x000fcbce3e45a30e,0x000a8919a2f6d341,0x0000644f481a46b6},{0x000508455987e93f,0x00086c52d4fb936f,0x000bf1494782ed2e,0x0009b3b64ef22f7a,0x0000e271957d8d37}},
        {{0x000051f896c2e8eb,0x000d7a69b583160e,0x0003d49398fdf12f,0x0009af8ffbe74fcd,0x000031d40fe11379},{0x0003fa86ded14ca8,0x000aa3806ceb84af,0x000ded17778cfed6,0x000b7ad455ace48c,0x0000241e365b6a4a}},
        {{0x000cdf92ebb9f2d2,0x00044fa908ec5b55,0x000d433b1e41dba3,0x0008fdc8a882d661,0x00004a21b29f9689},{0x000b80cdc8345f8c,0x00040425ef6c9c1e,0x00017accb726646f,0x000c62cc4b52d668,0x00004fe7071d103a}},
        {{0x000fc5b114eed902,0x00092c1ec222ba0e,0x000e6278ac333ebe,0x0000b826bc3dff42,0x0000884990265b21},{0x000e3baff2f463ac,0x000065bc6b05e85d,0x00088711208431cd,0x000750c9d0a6d302,0x000019cb19f15c3e}},
        {{0x000595cd1fa2a781,0x000d8d8df7304d44,0x000bb98b416f08ee,0x000983c60b71bcf1,0x0000fe06b3f76c34},{0x0009429622589d67,0x000cb9a4835859dc,0x000cb478d834436f,0x000f5234e4a0f0d2,0x000076555e5f3c86}},
    },
    { /* digit=58 (1,2,..,8)*(2^{232})*G */
        {{0x0004c9b20d431706,0x0002e62f23f2d925,0x000d0bef8e6b4e0a,0x00055d8206cab71b,0x0000c95a2a5e55d4},{0x00031469c615f1a7,0x00031aa9f2ac02f8,0x00069d5a83ea26e1,0x00016bd3403f8e61,0x00007f5ad3cb507d}},
        {{0x0008b75007f2d3e8,0x000b9583ae9c1bde,0x0007fac5923887d3,0x000d750b4e0af6d9,0x0000d1ef5fdad135},{0x0004069ea597b54b,0x0003bafe02358f2b,0x0006368b73835819,0x000671cfc31b8b85,0x0000fde8d8c56c72}},
        {{0x00028ad2a84e6c41,0x0004fcde36d07576,0x00017717c0d9fc24,0x000484cdff722d7b,0x0000ebe7611ea3b6},{0x000c336b09195735,0x0008ab520226040e,0x000064d14bbbb3e8,0x000ac8c886c34ecb,0x0000b85de43f45af}},
        {{0x000dcefcddd2868c,0x000b79e558df0194,0x000a5ea22e49ccca,0x00091ce24230da4b,0x00002dd640a90582},{0x00072d824d931811,0x000feb2a47d4c5ab,0x000efbe07e5114c0,0x000d6c17355ac9ab,0x0000fcd91a520be1}},
        {{0x000b8b3bb657e0d1,0x0002823cbb13d1b0,0x0002507060487a33,0x0003073a998799f4,0x0000a4673e731318},{0x00071b9484805f36,0x000b92e3ecebb211,0x000b1f5665228e4a,0x0000fe71f17cb6c4,0x0000fab132e7caf2}},
        {{0x000e8ef838c9fbc1,0x000c452de7e5c194,0x000973312d33ad9f,0x000d8b33dfab2860,0x000073e06257b5e1},{0x000ec0507e35022e,0x000df264cb1bf3d1,0x0009551e8ee3b962,0x000b4deed4c1f9d0,0x00009cc539a7598a}},
        {{0x00094abebcf27683,0x0008e09a607419d5,0x000262210bc3d71d,0x0004daef3faa71e6,0x000036cd41505615},{0x000a29a36702adec,0x000ba91eb78399f1,0x00052519283d6b50,0x000ce18f048aafb3,0x000081d651ae4804}},
        {{0x000a55b52ea9cdb8,0x000fab5ef7d92893,0x0007df294c2baacf,0x00036dbb62480d4a,0x00005fd14d5bdd1a},{0x000d5e9d7d31477a,0x0000715309eadb09,0x0009f58728a80fa4,0x00022c35adea7de5,0x0000ddf8bf0e739b}},
    },
    { /* digit=59 (1,2,..,8)*(2^{236})*G */
        {{0x0008d2fe5724a2d6,0x0008a411e84e0e5b,0x0002f5d04e3bf4c5,0x000d0d132a5db84d,0x00001765a592c24b},{0x0008b4a422ebc11c,0x0004336f3eb82fab,0x000c454ae73559b6,0x000b3a5108cb20cc,0x0000bc49662e3c97}},
        {{0x000dc9d1ec6f170f,0x000bea3af2ebc2fd,0x000ced852c3855dd,0x000b601b1a0af843,0x0000efe50594d52d},{0x000740f316de5b77,0x00051bb62771deb1,0x000a7a84b76a9d83,0x000c81aae829277a,0x0000e1420c11bfa4}},
        {{0x000d60f8e1cfb95a,0x000af10cab91f1eb,0x00038fbbd9345d96,0x00016c852bedd9e4,0x00005be88d186e1e},{0x000701924533f212,0x000417b9e05614a8,0x000660adcd80a4d5,0x00039c726fd26c76,0x00000cb351353c24}},
        {{0x000fcf57c64d0fe1,0x000089aeeaf8c495,0x000d0e557f623c19,0x0001b346cee7aa73,0x0000e3399090fc9a},{0x0006eb38aad81cf7,0x000a739b6057604e,0x0000db9b5314c754,0x000f3472d7d343c0,0x00004c1dfbe3a0a5}},
        {{0x000701a7d15ac5c0,0x00023520a981b0d0,0x0003b61899d2b0df,0x000d9eb9c1c354cb,0x0000a66e6fc26984},{0x00090a54c87214b2,0x000caefdcf2b9218,0x000333ea2b996b05,0x000111ae66ceef0b,0x0000fbf98e12d06c}},
        {{0x0002d09a5a1d9cdf,0x00039db4f6d01b11,0x00027c414e4622ba,0x000bc3b3be73c6bc,0x00008bb6de003282},{0x000e59669367bb32,0x00042eee7de13f4c,0x000535f66fef6436,0x0008d7d70177e2be,0x00000eff574037b4}},
        {{0x000291aba861ed06,0x000e76c048752a14,0x000e5d81960c63b1,0x000d9aa9241f2702,0x0000cb8d90ea933b},{0x00055408ef3f36fd,0x000ad70a653d61da,0x0003a9daac2f423c,0x00082428fd1b648d,0x0000eccb9ac2171b}},
        {{0x000848949c160154,0x0000e4f8be762b49,0x00006d459f779d3d,0x000d6b1fa2a9ee4d,0x000073144722cd51},{0x000631594e5d8939,0x0009ee5d23a84178,0x000d6db14456f57f,0x000650e1f892f3b1,0x0000d7a0b3f34fe0}},
    },
    { /* digit=60 (1,2,..,8)*(2^{240})*G */
        {{0x000585113ba8dd62,0x00080ea1f095615b,0x00065f617af767a6,0x000aab6be0a28ad7,0x0000085f54531694},{0x00033ed1deec48b1,0x000ae0b30df8aa1c,0x000b877911cd914a,0x000e64fcbaddda07,0x00004abbcd21ba68}},
        {{0x00032b33d4f558d6,0x00037483e07113c9,0x0008ea602fd9386b,0x0000f762b6e4a5d3,0x000040b7b04b7684},{0x000f178169d618d6,0x00020510dbbf08dd,0x000885aab8e91f1c,0x00043069b211d07c,0x0000c105f022a618}},
        {{0x000568d0917c4acb,0x000c55a83cdd60ed,0x0004cbae30f32f9c,0x000d8992a50602fb,0x0000910f7a813c33},{0x000ec2057b354ced,0x00035c70259217fd,0x0008e56f3c6925cc,0x000490b6e93831cd,0x0000a336551d0bd7}},
        {{0x0008835dedbc740c,0x0007d25913cc16df,0x000ce91f116c9a1b,0x000808dae18bc5b6,0x000071a394c1d139},{0x000ce433b9ac0821,0x000ead865a40ab05,0x0008bc6703c50add,0x0000029696559643,0x00009a0bfc436be6}},
        {{0x00066dd6d2079f06,0x0004c3d42e06189e,0x000067cd28417e6e,0x000130050bf07794,0x0000de2c929cf8ba},{0x000333b1e86df344,0x000b967ff99abde3,0x00009477132566ad,0x000536ed7c990355,0x0000973cee61a30e}},
        {{0x0000428dffccb096,0x000cfe784d6365d8,0x000f0f3311b8f429,0x000378330bcb7443,0x0000aa82351ab1ae},{0x00058c1fb6bdb9c6,0x000e9efa4faf8433,0x000dca1d65a933e3,0x0008101ceced8538,0x0000d4a8d9e6e600}},
        {{0x000e6c984782812a,0x000b4f7be42a5821,0x00004697d39f6d6b,0x00067b1a9d3fc608,0x0000472dc3a58087},{0x0006fec314288ecc,0x0007d25d30c31f70,0x000aa52b5e0e12c8,0x000798de7b7eb72b,0x00005698fa1698c6}},
        {{0x0009650f1aafc77c,0x00018b07e50122b3,0x000b118b6d8a8280,0x000784d7bdd744f8,0x0000b7a7039bee26},{0x0003cde18959c8fa,0x0004df71fa38477c,0x0009110e30c5b652,0x000a5bb8a3d815f1,0x00000fab64c70c58}},
    },
    { /* digit=61 (1,2,..,8)*(2^{244})*G */
        {{0x0009c02205f112dc,0x0009e952f41deff1,0x000acc7b67b111a0,0x0002d1d510e44a59,0x0000fa3e8511d623},{0x00051ff946f13b54,0x000dc69c4b7d692e,0x000317f509655586,0x000e6b4462e6392c,0x0000a96c730c5b29}},
        {{0x0000a3933301eb25,0x000a651566c5c43e,0x000854f45d136c9a,0x000a9b44acff9c91,0x0000afb49c7ad947},{0x000a2e067e61d8ad,0x0004dc10dc1eb2bf,0x000135c5137c224f,0x000bda57488cfd8c,0x0000c44a7f8d059f}},
        {{0x00052723d33fd8ae,0x000d77c5b0f7bd45,0x0008bb677dfa7a03,0x000ac19a96990c2c,0x00004b6f2495b079},{0x000fb6607adecf05,0x000bde2919ba0f93,0x00090c3da815b883,0x0000a7d12075a3bd,0x00004310fdce89c8}},
        {{0x0006c13cc1c1b2ba,0x000707f3e5f9f11f,0x0009e009feccf526,0x0004546bd9afe153,0x0000da180beb161c},{0x000f8417a1d44bc5,0x000008e325fc3ee3,0x00006399ac1041ab,0x000580ee77109540,0x0000ceab562965db}},
        {{0x0001872bafa156fb,0x0007a216ce400bb1,0x0007b96951ea5324,0x0007767e0f72919f,0x0000be25883d565f},{0x000a586c9ea652aa,0x00077eb211f7dc69,0x0005ba936a575e48,0x000dacedab8900e5,0x00003e88330c056f}},
        {{0x000fab17514db1c6,0x0008172813b230d7,0x000e97892cd69e71,0x000cdff6a634d0f5,0x0000c7df5b396089},{0x000b9815a106666f,0x000a1a74f7c4f830,0x000416725238afc5,0x000ab9aa0a7d2edc,0x000091170e9acf8b}},
        {{0x000a68529f79ae19,0x0006ae151c3ebe53,0x000797f52949338a,0x000e08fc9db14d5c,0x00004a632a0f71db},{0x0004b14f4695b847,0x0005adc149f75b88,0x000082eb2d6c5560,0x0009f624e9b8946a,0x0000a038b421d27b}},
        {{0x000db6d961011f15,0x000439b319540c33,0x000964ccfd972723,0x0008f8acb18490f5,0x00000165db5b23d9},{0x0003f6e09555115e,0x00005bb146110697,0x000e9391de70734b,0x0006302d2b19436a,0x000046716ed749df}},
    },
    { /* digit=62 (1,2,..,8)*(2^{248})*G */
        {{0x000b8a4cbe978aa8,0x000fbc8ee3c76cb3,0x0003979fd2b05b7b,0x000d941563cf1162,0x0000e542d606a5d0},{0x0005e56df6f115ed,0x0003ca59ce6bb278,0x00017eef4378ebbf,0x0000d8c8dc4afaa5,0x0000a21b92c92f88}},
        {{0x00035dc5396eb247,0x000c8ef4e4ca4631,0x00072209072a4380,0x000c5c200bcef728,0x0000b72cb6549160},{0x000b0c5738b12183,0x000822e27bf1bc68,0x000f7cd34933b26d,0x000119eda10a224e,0x0000c80f888434bc}},
        {{0x000e0efb3b8b1b5d,0x00038959884aaf7a,0x000259a44d6afe4d,0x000f91f87b1959be,0x0000337331701bb0},{0x000b01a0216bb368,0x0000c5eca8c325e7,0x000671fd9f4f814d,0x000e76c1d3c91169,0x000010645e8443c5}},
        {{0x0005b4488b3fb1e8,0x000d26b23a5d8961,0x00056a2fedc3595e,0x00081de771fe19e3,0x00005b981b48385a},{0x0002c4f79da9b17b,0x00017541a1f22bff,0x000fb8bc6c4a7592,0x00033ea8e920a8a6,0x000037f6be35ab5e}},
        {{0x0006210d9e58a61a,0x00029b5224c08dca,0x0003db93fef2cd7b,0x00002ae4f2bbb09b,0x00004673f3e36b54},{0x000acede4893a3e0,0x000167a09cb54d69,0x000fb53a3b5bd9ea,0x0006f485791eef6d,0x0000d389cb15387b}},
        {{0x00078c2ec1e3ed4f,0x00051691416a6a5e,0x00085c63595aa0e1,0x000163b5d8f860c7,0x0000283d923fc854},{0x0005beef7ad3f5b3,0x0007b815ad735813,0x000023a1511c7557,0x0006b79bab4cc9e0,0x0000199d8c4e721f}},
        {{0x000e42f66dd9a70c,0x0000846de6736294,0x000e21f936b36c3b,0x000215cc757f7aa1,0x0000e42c4db111bf},{0x000f78959874b51d,0x00067dc910778965,0x000f6350f2c2eb73,0x000e53487a0d690c,0x00008713f1619ac6}},
        {{0x000bdec2116e9b29,0x000389c76497ee80,0x0006bb3874fd1cc1,0x000343fe15d2b0ac,0x0000a3fadcb3a4e1},{0x00037248e9d64745,0x00087efa63b10110,0x0007dd6bd1db932c,0x000c6c78bf9e3fa9,0x00009e31d0655466}},
    },
    { /* digit=63 (1,2,..,8)*(2^{252})*G */
        {{0x000be5ed0e405bae,0x0007fc91ec34f9e7,0x0004b79b18f54024,0x000b106f3d8772d3,0x000037037c975e12},{0x000aec44147d71ff,0x0003d1931e82b100,0x0007bf1327384e2c,0x0002fb55ec63d285,0x0000df2ba6d3b215}},
        {{0x0007a23f356e3059,0x00041e71e29a3efb,0x000f94f0f0f98de8,0x0007a880ecbe906e,0x00002d869e92df60},{0x000cf0bbf87a34ec,0x00089c2efd2119d3,0x000ebfbd0dd06fa3,0x0006c851303198c6,0x000030a29d4bfdd3}},
        {{0x00089caef387625f,0x000fcb72b7247593,0x00017a38174726e5,0x0001b102c945353e,0x0000fcd0db4d1457},{0x0003429bba3484a4,0x0001753db65ef147,0x000e6a574289160a,0x0006d9c5f2dc2cb7,0x00005d42b1ac334f}},
        {{0x00012c9e1ee0d0a1,0x0003490b01e6e274,0x000da05414bdd548,0x000de03a9047e2cc,0x0000c371569c9623},{0x00078851bc8c9a7d,0x0000d36794075521,0x0006dbaa6726fc38,0x000ce611949c5013,0x000053af2d9b1059}},
        {{0x00035aa24062df0d,0x0002a52fb85fa4ca,0x000d94e1eaa94f02,0x0001840aed61257c,0x0000fb93c2113070},{0x0000d05aabec972c,0x000f75d4421fc835,0x00007292ec8f71dc,0x000b37558f6df8ee,0x0000d9d09ec67e4f}},
        {{0x0000235a102cb4ec,0x000fb35a64785f45,0x000b0f0672f75fa1,0x0002e6467bc56637,0x00008030444d7012},{0x000881065be741fe,0x000b8d8f2c4aa658,0x0000fb14fbdf31d8,0x000b607bac347583,0x00006adf01034a09}},
        {{0x000f12502f6f25d9,0x0000c22cc1b5e838,0x0000f6f93bcc544b,0x0008c7ddfde2d4ad,0x0000c68d49d6c0f8},{0x0003511dcdcef6f9,0x000a7dc7783920a0,0x000dbd6b689c8148,0x0000f52a6e80014a,0x0000730b2f927704}},
        {{0x000211e48a709134,0x000a06d95a7b1a29,0x0005aa515d70a8ec,0x000baface9c4e7ad,0x00001420ee199ed7},{0x0005f92e47355a0e,0x000716ec78ef1f42,0x000fe05e173edf3f,0x000e4dfe82b2c090,0x00005f26894a26e6}},
    },
    { /* digit=64 (1,2,..,8)*(2^{256})*G */
        {{0x0008910bd3c74498,0x000d8af3aeac968f,0x0008cc252692ed9e,0x00067be64e4f7fee,0x000092836060ef1c},{0x000890896b28139e,0x000470cc9c0726e3,0x0009a0eab753f427,0x00046bc1b1530956,0x000038600b6014d5}},
        {{0x000cd15a3cc6fb9b,0x000a19f82e4c6346,0x0003cd730abb95f1,0x000222f258efb831,0x000068413078deb3},{0x0001e7c1ed462bd3,0x000d5fdbfcd8fb51,0x000f5c6d0b354d1b,0x000acc02f31db2ee,0x00009cf8f2c231b2}},
        {{0x000ee3e9bd875a0b,0x00079f5903fa2711,0x00029af6a861120e,0x000561354e6da0fd,0x00000c0f6913abd6},{0x000948148819fd8a,0x0008e1ce27a94979,0x0003f4d9497c8870,0x0002f21ca36d254e,0x00009bc3a89fe40b}},
        {{0x0004af860fe1d658,0x0005c3a43228d831,0x00003626b989c96b,0x000ceba2924ae1c3,0x0000c45b79310a64},{0x0002ceb1de0d0667,0x00088613f714aa18,0x000d68a9c780c9b4,0x000a36f94f51865a,0x0000055e19d4f0d9}},
        {{0x00014fc2a4b59f10,0x0004bfd2f9fd51a3,0x000216cbd55294c7,0x00097be507f2f1fe,0x0000924f1faac4f7},{0x0003541b7a3d4f01,0x0003c8cb55fc5c6d,0x0007ec5dc6c3980a,0x000f63bcee3510ce,0x0000ab63b2a3eef9}},
        {{0x000560910cddf7bd,0x000a825eca445df4,0x0001e77f13b9bb31,0x000af16bcf1af24f,0x0000d48e4c17550d},{0x0005fc863ac98830,0x000ec32093eaa327,0x0009073fe1808aec,0x000fee1100183134,0x0000b88f64b6ab63}},
        {{0x00017535ffca9e3e,0x0004c4176a9f05d0,0x000b8e9c9e88a67d,0x000aa685e06ca4e4,0x0000941d64ce2bd7},{0x0004eb4d5b7fac46,0x0003ece406851d75,0x000f3bfe1359045f,0x0007cb734afa3acd,0x000087d6f48d53f1}},
        {{0x0004ef0fb7992ec5,0x000237355dbd4b3d,0x0007914aabfa41db,0x0003654621f87992,0x00002b7c7dfd2d83},{0x000c21100586c6db,0x000ded8f1bfb12a4,0x0008223d7b6ca10c,0x000b4b5146ab877e,0x000069c991a7978e}},
    }
};

/* clang-format on */

#endif /* #if !defined(_DISABLE_ECP_256R1_HARDCODED_BP_TBL_) */

IPP_OWN_DEFN(const cpPrecompAP *, gfpec_precom_nistP256r1_radix52_fun, (void))
{
   static cpPrecompAP t = {
      /* w */ 4,
      /* select function */ p256r1_select_ap_w4_ifma,
      /* precomputed data */ (BNU_CHUNK_T *)ifma_ec_nistp256r1_bp_precomp
   };
   return &t;
}

#endif // (_IPP32E >= _IPP32E_K1)

#endif /* #ifndef IFMA_ECPRECOMP4_P256_H */

#endif /* #if 0 */
