/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include "stamp-pdbgen.h"

#include <gegl.h>

#include <gdk-pixbuf/gdk-pixbuf.h>

#include "libgimpbase/gimpbase.h"

#include "pdb-types.h"

#include "core/gimp.h"
#include "core/gimpimage-convert-indexed.h"
#include "core/gimpimage-convert-precision.h"
#include "core/gimpimage-convert-type.h"
#include "core/gimpimage.h"
#include "core/gimpitemstack.h"
#include "core/gimppalette.h"
#include "core/gimpparamspecs.h"
#include "gegl/gimp-babl.h"

#include "gimppdb.h"
#include "gimppdberror.h"
#include "gimppdb-utils.h"
#include "gimpprocedure.h"
#include "internal-procs.h"

#include "gimp-intl.h"


static GimpValueArray *
image_convert_rgb_invoker (GimpProcedure         *procedure,
                           Gimp                  *gimp,
                           GimpContext           *context,
                           GimpProgress          *progress,
                           const GimpValueArray  *args,
                           GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;

  image = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      if (gimp_pdb_image_is_not_base_type (image, GIMP_RGB, error) &&
          gimp_babl_is_valid (GIMP_RGB, gimp_image_get_precision (image)))
        {
          success = gimp_image_convert_type (image, GIMP_RGB, NULL, NULL, error);
        }
      else
        {
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
image_convert_grayscale_invoker (GimpProcedure         *procedure,
                                 Gimp                  *gimp,
                                 GimpContext           *context,
                                 GimpProgress          *progress,
                                 const GimpValueArray  *args,
                                 GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;

  image = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      if (gimp_pdb_image_is_not_base_type (image, GIMP_GRAY, error) &&
          gimp_babl_is_valid (GIMP_GRAY, gimp_image_get_precision (image)))
        {
          success = gimp_image_convert_type (image, GIMP_GRAY, NULL, NULL, error);
        }
      else
        {
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
image_convert_indexed_invoker (GimpProcedure         *procedure,
                               Gimp                  *gimp,
                               GimpContext           *context,
                               GimpProgress          *progress,
                               const GimpValueArray  *args,
                               GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gint dither_type;
  gint palette_type;
  gint num_cols;
  gboolean alpha_dither;
  gboolean remove_unused;
  const gchar *palette;

  image = g_value_get_object (gimp_value_array_index (args, 0));
  dither_type = g_value_get_enum (gimp_value_array_index (args, 1));
  palette_type = g_value_get_enum (gimp_value_array_index (args, 2));
  num_cols = g_value_get_int (gimp_value_array_index (args, 3));
  alpha_dither = g_value_get_boolean (gimp_value_array_index (args, 4));
  remove_unused = g_value_get_boolean (gimp_value_array_index (args, 5));
  palette = g_value_get_string (gimp_value_array_index (args, 6));

  if (success)
    {
      GimpPalette *pal = NULL;

      if (gimp_pdb_image_is_not_base_type (image, GIMP_INDEXED, error)             &&
          gimp_pdb_image_is_precision (image, GIMP_PRECISION_U8_NON_LINEAR, error) &&
          gimp_babl_is_valid (GIMP_INDEXED, gimp_image_get_precision (image))      &&
          gimp_item_stack_is_flat (GIMP_ITEM_STACK (gimp_image_get_layers (image))))
        {
          switch (palette_type)
            {
            case GIMP_CONVERT_PALETTE_GENERATE:
              if (num_cols < 1 || num_cols > MAXNUMCOLORS)
                success = FALSE;
              break;

            case GIMP_CONVERT_PALETTE_CUSTOM:
              pal = GIMP_PALETTE (gimp_pdb_get_resource (gimp, GIMP_TYPE_PALETTE, palette,
                                                         GIMP_PDB_DATA_ACCESS_READ, error));
              if (! pal)
                {
                  success = FALSE;
                }
              else if (pal->n_colors > MAXNUMCOLORS)
                {
                  g_set_error_literal (error,
                                       GIMP_PDB_ERROR,
                                       GIMP_PDB_ERROR_INVALID_ARGUMENT,
                                       _("Cannot convert to a palette "
                                         "with more than 256 colors."));
                  success = FALSE;
                }
              break;

            default:
              break;
            }
        }
      else
        {
          success = FALSE;
        }

      if (success)
        success = gimp_image_convert_indexed (image,
                                              palette_type, num_cols, remove_unused,
                                              dither_type, alpha_dither, FALSE,
                                              pal,
                                              NULL, error);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
image_convert_set_dither_matrix_invoker (GimpProcedure         *procedure,
                                         Gimp                  *gimp,
                                         GimpContext           *context,
                                         GimpProgress          *progress,
                                         const GimpValueArray  *args,
                                         GError               **error)
{
  gboolean success = TRUE;
  gint width;
  gint height;
  GBytes *matrix;

  width = g_value_get_int (gimp_value_array_index (args, 0));
  height = g_value_get_int (gimp_value_array_index (args, 1));
  matrix = g_value_get_boxed (gimp_value_array_index (args, 2));

  if (success)
    {
      if (width == 0 || height == 0 || g_bytes_get_size (matrix) == width * height)
        {
          gimp_image_convert_indexed_set_dither_matrix (g_bytes_get_data (matrix, NULL),
                                                        width, height);
        }
      else
        {
          g_set_error_literal (error, GIMP_PDB_ERROR,
                               GIMP_PDB_ERROR_INVALID_ARGUMENT,
                               "Dither matrix length must be width * height");
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
image_convert_precision_invoker (GimpProcedure         *procedure,
                                 Gimp                  *gimp,
                                 GimpContext           *context,
                                 GimpProgress          *progress,
                                 const GimpValueArray  *args,
                                 GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gint precision;

  image = g_value_get_object (gimp_value_array_index (args, 0));
  precision = g_value_get_enum (gimp_value_array_index (args, 1));

  if (success)
    {
      if (gimp_pdb_image_is_not_base_type (image, GIMP_INDEXED, error) &&
          gimp_pdb_image_is_not_precision (image, precision, error)    &&
          gimp_babl_is_valid (gimp_image_get_base_type (image), precision))
        {
          gimp_image_convert_precision (image, precision,
                                        GEGL_DITHER_NONE,
                                        GEGL_DITHER_NONE,
                                        GEGL_DITHER_NONE,
                                        progress);
        }
      else
        {
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

void
register_image_convert_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-image-convert-rgb
   */
  procedure = gimp_procedure_new (image_convert_rgb_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-convert-rgb");
  gimp_procedure_set_static_help (procedure,
                                  "Convert specified image to RGB color",
                                  "This procedure converts the specified image to RGB color. This process requires an image in Grayscale or Indexed color mode. No image content is lost in this process aside from the colormap for an indexed image.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Peter Mattis",
                                         "Spencer Kimball & Peter Mattis",
                                         "1995-1996");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-convert-grayscale
   */
  procedure = gimp_procedure_new (image_convert_grayscale_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-convert-grayscale");
  gimp_procedure_set_static_help (procedure,
                                  "Convert specified image to grayscale",
                                  "This procedure converts the specified image to grayscale. This process requires an image in RGB or Indexed color mode.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Peter Mattis",
                                         "Spencer Kimball & Peter Mattis",
                                         "1995-1996");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-convert-indexed
   */
  procedure = gimp_procedure_new (image_convert_indexed_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-convert-indexed");
  gimp_procedure_set_static_help (procedure,
                                  "Convert specified image to and Indexed image",
                                  "This procedure converts the specified image to 'indexed' color. This process requires an image in RGB or Grayscale mode. The 'palette_type' specifies what kind of palette to use, A type of '0' means to use an optimal palette of 'num_cols' generated from the colors in the image. A type of '1' means to re-use the previous palette (not currently implemented). A type of '2' means to use the so-called WWW-optimized palette. Type '3' means to use only black and white colors. A type of '4' means to use a palette from the gimp palettes directories. The 'dither type' specifies what kind of dithering to use. '0' means no dithering, '1' means standard Floyd-Steinberg error diffusion, '2' means Floyd-Steinberg error diffusion with reduced bleeding, '3' means dithering based on pixel location ('Fixed' dithering).",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Peter Mattis",
                                         "Spencer Kimball & Peter Mattis",
                                         "1995-1996");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("dither-type",
                                                  "dither type",
                                                  "The dither type to use",
                                                  GIMP_TYPE_CONVERT_DITHER_TYPE,
                                                  GIMP_CONVERT_DITHER_NONE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("palette-type",
                                                  "palette type",
                                                  "The type of palette to use",
                                                  GIMP_TYPE_CONVERT_PALETTE_TYPE,
                                                  GIMP_CONVERT_PALETTE_GENERATE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("num-cols",
                                                 "num cols",
                                                 "The number of colors to quantize to, ignored unless (palette_type == GIMP_CONVERT_PALETTE_GENERATE)",
                                                 G_MININT32, G_MAXINT32, 0,
                                                 GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("alpha-dither",
                                                     "alpha dither",
                                                     "Dither transparency to fake partial opacity",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("remove-unused",
                                                     "remove unused",
                                                     "Remove unused or duplicate color entries from final palette, ignored if (palette_type == GIMP_CONVERT_PALETTE_GENERATE)",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("palette",
                                                       "palette",
                                                       "The name of the custom palette to use, ignored unless (palette_type == GIMP_CONVERT_PALETTE_CUSTOM)",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-convert-set-dither-matrix
   */
  procedure = gimp_procedure_new (image_convert_set_dither_matrix_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-convert-set-dither-matrix");
  gimp_procedure_set_static_help (procedure,
                                  "Set dither matrix for conversion to indexed",
                                  "This procedure sets the dither matrix used when converting images to INDEXED mode with positional dithering.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "David Gowers",
                                         "David Gowers",
                                         "2006");
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("width",
                                                 "width",
                                                 "Width of the matrix (0 to reset to default matrix)",
                                                 G_MININT32, G_MAXINT32, 0,
                                                 GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_int ("height",
                                                 "height",
                                                 "Height of the matrix (0 to reset to default matrix)",
                                                 G_MININT32, G_MAXINT32, 0,
                                                 GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boxed ("matrix",
                                                   "matrix",
                                                   "The matrix -- all values must be >= 1",
                                                   G_TYPE_BYTES,
                                                   GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-image-convert-precision
   */
  procedure = gimp_procedure_new (image_convert_precision_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-image-convert-precision");
  gimp_procedure_set_static_help (procedure,
                                  "Convert the image to the specified precision",
                                  "This procedure converts the image to the specified precision. Note that indexed images cannot be converted and are always in GIMP_PRECISION_U8.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2012");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("precision",
                                                  "precision",
                                                  "The new precision",
                                                  GIMP_TYPE_PRECISION,
                                                  GIMP_PRECISION_U8_LINEAR,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
