CHANGELOG for 8.0.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 8.0 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v8.0.0...v8.0.1

* 8.0.6 (2026-02-26)

 * bug #63492 [RateLimiter] Fix retryAfter when consuming exactly all remaining tokens in FixedWindow and TokenBucket (ERuban)
 * bug #63491 [RateLimiter] Fix `retryAfter` when consuming exactly all remaining tokens in `SlidingWindow` (ERuban)
 * bug #52413 [RateLimiter] Fix reservations outside the second fixed window (SanderSander)
 * bug #57392 [Serializer][Validator] Fix propertyPath in ConstraintViolationListNormalizer with MetadataAwareNameConverter (antten)
 * bug #54236 [Config][Routing] Fix exclude option being ignored for non-glob and PSR-4 resources (NeilPeyssard)
 * bug #47424 [Filesystem] makePathRelative with existing files, remove ending / (Petar Marjanovic)
 * bug #52083 [Messenger][Amqp] Don't use retry routing key when sending to failure transport (Fabien Perroquin)
 * bug #63275 [Messenger] Fix re-sending failed messages to a different failure transport (bartholdbos)
 * bug #63478 [Config] Fix ArrayShapeGenerator required keys with deep merging (lacatoire)
 * bug #63476 [Validator] Correctly handle null `allowedVariables` in `ExpressionSyntaxValidator` (alexandre-daubois)
 * bug #63473 [DependencyInjection] Fix PriorityTaggedServiceTrait not discovering `#[AsTaggedItem]` on decorated services (lacatoire)
 * bug #63446 [ObjectMapper] fix nested mapping with class-level transform (Thibaut Cholley)
 * bug #63472 [TwigBridge] Fix Bootstrap 4 form errors rendered inside `<label>` (asispts)
 * bug #54324 [Form] Fix merging POST params and files when collection entries have mismatched indices (priyadi)
 * bug #52722 [Validator] Fix type error for non-array items when `Unique::fields` is set (aprat84)
 * bug #54703 [HttpKernel] Fix default locale ignored when Accept-Language has no enabled-locale match (karimmorel)
 * bug #62681 [FrameworkBundle] Make `ConfigDebugCommand` use its container to resolve env vars (MatTheCat)
 * bug #47432 [Console] Fix various completion edge cases (Seldaek)
 * bug #60662 [Routing] assign attribute aliases to localized route if applicable (alcohol)
 * bug #63463 [Validator] Fix required options not validated when constructor calls parent with null (lacatoire)
 * bug #63468 [Mailer][Mailchimp] Fix webhook rejection by switching to form-encoded request parsing (nicolas-grekas)
 * bug #63450 [Form] Fix missing resource tracking for type extensions in FormPass (ranpafin)
 * bug #63435 [Mailer] Fix handling postal transport apikey (MarcHagen)
 * bug #63462 [FrameworkBundle] Fix phpstan false-positive about config/reference.php (nicolas-grekas)
 * bug #63454 [Security] Fix lazy firewall triggering remember me authentication on POST requests to public routes (nicolas-grekas)
 * bug #63460 [Workflow] Implement missing `reset()` method in `TraceableWorkflow` (santysisi)
 * bug #63456 [Console] Fix validator exception masked by MissingInputException on empty input (nicolas-grekas)
 * bug #63444 [Console] Fix arguments set via `#[Ask]` wrongly considered null in profiler (chalasr)
 * bug #63439 [SecurityBundle] Update security-1.0.xsd with missing oauth2 element (welcoMattic)
 * bug #63428 [Serializer] Fix handling of constructor enum denormalization errors (vvaswani)
 * bug #63438 [Console] ProgressIndicator console helper display with multiple processes (guillaumeVDP)
 * bug #63436 [Console] Silence shell_exec warning in hasSttyAvailable (lacatoire)
 * bug #63448 [HttpFoundation] Handle empty session data in updateTimestamp() to fix compat with PHP 8.6 (nicolas-grekas)
 * bug #63437 [Cache] Wrap `DoctrineDbalAdapter::doSave()` in savepoint to prevent transaction poisoning (lacatoire)
 * bug #63416 [TypeInfo] TypeContextFactory::collectTemplates now also works with `@phpstan`-template and `@psalm`-template (TomasLudvik)
 * bug #63415 [Console] Fix profiling commands that use `#[Ask]` (chalasr)
 * bug #63401 [Serializer] Fix constructor parameter type override when property type extractor returns a different type (nicolas-grekas)
 * bug #63405 [Serializer] Fix passing context option to property-info (nicolas-grekas)
 * bug #63400 [CssSelector] Fix memory exhaustion by adding an LRU cache to CssSelectorConverter (arcangelini)
 * bug #63391 [Cache][Messenger] Align Redis sentinel auth handling across components (nicolas-grekas)
 * bug #62738 [TypeInfo] Fix template key-type for array (DjordyKoert)
 * bug #63386 [HttpKernel] Handle invalid backed-enum values gracefully in RequestPayloadValueResolver (nicolas-grekas)
 * bug #63384 [FrameworkBundle] fail gracefully when the semaphore config is used but the component is missing (xabbuh)
 * bug #63380 [Messenger] Use mutable datetime columns in Doctrine transport schema (nicolas-grekas)
 * bug #63379 [DependencyInjection] Prevent false unused-env errors for abstract definitions removed at compile time (nicolas-grekas)
 * bug #63375 [PropertyInfo] prioritize property type over is/has/can accessors (xabbuh)
 * bug #63372 [Dotenv] Use `SYMFONY_DOTENV_PATH` variable when dumping dotenv (Spea)
 * bug #63344 [PropertyInfo] Prioritize property type over is/has/can accessors (nicolas-grekas)
 * bug #63368 [Console] Fix ProgressBar `remaining` and `estimated` placeholder guards (yoeunes)
 * bug #63363 [HttpKernel] Fix variadic argument handling with #[MapUploadedFile] (nicolas-grekas)
 * bug #63353 [Validator] Fix comparison validator crash on extreme dates (lacatoire)
 * bug #63354 [Mailer] Fix invalid encoding of custom headers in SES API (lacatoire)
 * bug #63349 [Validator] Fix AbstractComparison deprecation triggered for array values (lacatoire)
 * bug #63351 [Console] Fix SymfonyStyle block output with \r\n line endings (lacatoire)
 * bug #63342 [PropertyInfo] fix union with mixed handling for the legacy PropertyInfo Type (xabbuh)
 * bug #59540 [PropertyInfo] Fix support for inline ``@var`` docblocks on promoted properties (wuchen90)
 * bug #63247 [ObjectMapper] Skip source mapping attempts when target class condition evaluates to false (rrajkomar)
 * bug #63333 [FrameworkBundle] Fix JsonStreamer forward compatibility (mtarld)
 * bug #63264 [Mailer][MicrosoftGraph] Also bypass Sender header within MicrosoftGraphApiTransport (deeky666)
 * bug #63330 [TypeInfo] Fix nested union null type detection in `TypeFactoryTrait::union()` (yoeunes)
 * bug #63319 [HttpFoundation] BinaryFileResponse: always return 206 if Range is valid (Jimbolino)
 * bug #63329 [TypeInfo] Fix `ArrayShapeType::getExtraValueType()` return value (yoeunes)
 * bug #63309 [Workflow] Fix swapped workflow/transition names in `WorkflowValidator` (yoeunes)
 * bug #63315 [WebProfilerBundle] Fix EventSource is missing static properties (Oleksii Kozhemiaka)
 * bug #63307 [DependencyInjection] Fix stale binding lookup in `ResolveBindingsPass` error message (yoeunes)
 * bug #63317 [Asset] Fix JsonManifestVersionStrategy exception on missing manifest in non-strict mode (claude)
 * bug #63324 [Cache] Fix DSN auth not passed to Redis/RedisCluster/Relay in RedisTrait (ckrack)
 * bug #63324 [Cache] Fix DSN auth not passed to Redis/RedisCluster/Relay in RedisTrait (ckrack)
 * bug #57292 [Yaml] Fix parsing nested mappings in sequences (HypeMC)
 * bug #63294 [JsonStreamer] Fix DateTime handling in union types (mtarld)
 * bug #63305 [FrameworkBundle] Fix autoconfiguring controllers using legacy Route annotations as attributes (nicolas-grekas)
 * bug #63306 [Cache] Revert "Fix DSN auth not passed to clusters in RedisTrait" (nicolas-grekas)
 * bug #63272 [Messenger][Cache] Fix forwarding SSL settings to the redis sentinel (CientistaDaWeb)
 * bug #63288 [Messenger] Optimize serialized size of ErrorDetailsStamp (nicolas-grekas)
 * bug #63292 [Messenger] Fix AMQP heartbeat reconnection during in-flight message handling (wazum)
 * bug #63291 [JsonStreamer] Fix composite node provider arguments in stream mode (mtarld)
 * bug #63289 [PropertyInfo] Fix union with `mixed` handling (mtarld)
 * bug #63278 [Mailer] Fix Mailjet SMTP relay X-MJ-TemplateErrorReporting header format to MailjetApiTransport (mwijngaard)
 * bug #63282 [Messenger] Revert batch processing fix (HypeMC)
 * bug #63259 [FrameworkBundle] Fix BrowserKitAssertionsTrait compatibility with HttpBrowser (thiagomp)
 * bug #63281 [String] Treat emoji VS16 as wide in width calc (fabpot)
 * bug #63279 [Serializer] Normalize static methods when they have groups (digilist)
 * bug #62970 [WebProfilerBundle] Fix hot reload support (FrankenPHP) (dunglas)
 * bug #63271 [DoctrineBridge] Respect `schema_filter` in schema listeners (wazum)
 * bug #63235 [PropertyInfo] phpdocumentor/reflection-docblock 6 compatibility (mtarld)
 * bug #63262 [HttpFoundation] Reject invalid paths (nicolas-grekas)
 * bug #58460  Fix destructor throwing while timeout was handled (Seldaek, nicolas-grekas)
 * bug #63260 [HttpKernel] Fix handling empty MapUploadedFile arrays (nicolas-grekas)
 * bug #63255 [FrameworkBundle] Add missing `useAttributeAsKey` calls (MatTheCat)
 * bug #57561 [DependencyInjection] Fix ignore invalid_reference behavior param for the some services (Nguyen26052004)
 * bug #54304 [HttpFoundation] When calling UploadedFile::getErrorMessage() to a file which has no error and is uploaded successfully, it should not return an error (ArmCyber)
 * bug #63101 [HttpKernel] Bypass mapping construction when `RedirectController::urlRedirectAction` is triggered (florianorineveu)
 * bug #63238 [Console] Fall back to 0 when getCode() does not provide an integer (makomweb)
 * bug #63239 [FrameworkBundle] Fix accessing the test container when using KernelTestCase in non-debug mode (nicolas-grekas)
 * bug #58433 [Messenger] Avoid skipping batch handlers on flush (Erwin Houtsma)
 * bug #63236 [FrameworkBundle] Fix clearing the HttpCache store in tests (nicolas-grekas)
 * bug #63234 [DependencyInjection][HttpKernel] Fix parsing Target attributes on properties and on controllers (nicolas-grekas)
 * bug #63231 [Translation] Fix for Crowdin Translation File Replaced with Partial Data When Pushing Default Locale Without --force (bhdnb)
 * bug #63226 [Messenger] Fix calling nack() when ack() fails (nicolas-grekas)
 * bug #63230 [Cache][HttpFoundation][Lock] fix engine declaration on mysql pdo table creations (tandev)
 * bug #63225 [Finder] Fix SortableIterator inadvertently and inconsistently deduplicating appended iterators (nicolas-grekas)

* 8.0.5 (2026-01-28)

 * bug #63213 [DependencyInjection] Fix lazy proxy type resolution for decorated services (nicolas-grekas)
 * bug #63212 [HttpClient] Fix dealing with truncated streams after headers arrived with CurlHttpClient (nicolas-grekas)
 * bug #63208 [PropertyInfo] Fix DocBlock resolution for inherited promoted properties (yoeunes)
 * bug #63170 [RateLimiter] Persist state when consuming negative tokens (jhogervorst)
 * bug #63137 [HttpFoundation] Fix PdoSessionHandler charset-collation mismatch with the Doctrine DBAL (samy-mahmoudi)
 * bug #63211 [HttpClient] Fix dealing with multiple levels of AsyncResponse decoration (nicolas-grekas)
 * bug #63202 [Messenger] Only send `UNLISTEN` query if we are actively listening (jwage)
 * security #cve-2026-24739 [Process] Fix escaping for MSYS on Windows (nicolas-grekas)
 * bug #63206 [PropertyInfo] Conflict with phpdocumentor/reflection-docblock >= 6 (all branches) (nicolas-grekas)
 * bug #63204 [PropertyInfo] Fix resolution of self/parent types in inherited DocBlocks (yoeunes)
 * bug #63141 [ObjectMapper] apply conditions to constructor arguments (soyuka)
 * bug #63195 [FrameworkBundle] Clean `http_cache` dir in `KernelTestCase::ensureKernelShutdown()` (nicolas-grekas)
 * bug #63164 [Process] Fix escaping for MSYS on Windows (nicolas-grekas)
 * bug #63192 [Finder] Fix appending empty iterators (nicolas-grekas)
 * bug #63193 [PropertyInfo] Conflict with phpdocumentor/reflection-docblock >= 6 (branch 6.4 only) (nicolas-grekas)
 * bug #63191  [Serializer] Apply `#[Ignore]` to the right metadata (VincentLanglet)

* 8.0.4 (2026-01-25)

 * bug #63160 [DependencyInjection] Fix alias chain inversion when deprecated alias points to decorated service (amateescu)
 * bug #63159 [JsonStreamer] Fix exponential resource class memory growth (mtarld)
 * bug #62852 [Cache] Fix DSN auth not passed to clusters in RedisTrait (wikando-ck)
 * bug #62959 [PropertyInfo] do not parse `scalar` as an object (xabbuh)
 * bug #63136 [Serializer] Fix is/has/can accessor naming to strip prefix unless colliding (nicolas-grekas)
 * bug #63144 [Form] Fix `OrderedHashMap` auto-increment logic with mixed keys (yoeunes)
 * bug #63154 [Form] don't skip custom view transformers while normalizing submitted newlines (xabbuh)
 * bug #63155 [HttpClient] Skip HTTP/3 when using a proxy (nicolas-grekas)
 * bug #63084 [PropertyInfo] fix exception with nullable value-of phpdoc (Максим Колокольников, maxmirazh33)
 * bug #63051 [DoctrineBridge] Fix custom type based on Uid on entity loader (IndraGunawan)
 * bug #63108 [ErrorHandler] fix parsing of complexe type (jderusse)
 * bug #63126 [PropertyInfo] Throw when phpdocumentor/reflection-docblock v6 is in use (branch 6.4 only) (nicolas-grekas)
 * bug #63113 [Form] Fix ICU 72+ whitespace handling in `DateTimeToLocalizedStringTransformer` (roukmoute)
 * bug #63052 [Serializer] Fix NameConverter not detecting wrong input format with `allow_extra_attributes=false` (xersion22)
 * bug #63064 [Translation] Fix handling of empty lines in CsvFileLoader (fnogatz)
 * bug #63056 [String] Fix UnicodeString::startsWith()/endsWith() on strings that start/end with a zero (nicolas-grekas)
 * bug #63043 [FrameworkBundle] Check for console package before register `CommandDataCollector` (gimler)
 * bug #63016 [FrameworkBundle] Ensure a fresh container is used after cache warmup in `KernelTestCase` (lyrixx)
 * bug #63053 [Config] add back missing enabled key in normalization step (xabbuh)
 * bug #62762 [Finder] Fix `Finder::append()` breaking generic typing contract (jack-worman)
 * bug #62973 [WebProfiler] fix the security profiler template (aurac)
 * bug #63002 [Config] Fix merging node that canBeDisable()/canBeEnabled() (nicolas-grekas)
 * bug #63027 [ObjectMapper] error when multiple targets and no condition (soyuka)
 * bug #63000 [JsonStreamer] Fix memory leak by caching stream readers/writers (mtarld)
 * bug #62997 [TypeInfo] Fix type resolution when called class is in other namespace (mtarld)
 * bug #62985 [FrameworkBundle] Skip extensions with empty configuration in `reference.php` (bendavies)
 * bug #62984 [Mailer][MicrosoftGraph] Also bypass `Return-Path` header within `MicrosoftGraphApiTransport` (zoglo)
 * bug #62862 [ObjectMapper] Fix mapping for missing source properties (Ali-HENDA)
 * bug #63003 [FrameworkBundle] Don't list ExpressionConfigurator if expression-language is not installed on reference config shape (nicolas-grekas)
 * bug #63004 [Process] Ignore invalid env var names (nicolas-grekas)
 * bug #63005 [FrameworkBundle] Revert destination file change for secrets:decrypt-to-local (nicolas-grekas)
 * bug #63012 [HttpFoundation] Fix double-prefixing of session keys when using redis/memcached (nicolas-grekas)
 * bug #63001 [Scheduler] Fix array to string conversion in `#[AsCronTask]` arguments (serhiilabs)
 * bug #62953 [Serializer] Fix removing nested values (gnoddep)
 * bug #62988 [Messenger] Fix DBALv4 support by replacing trigger by explicit pg_notify() (nicolas-grekas)
 * bug #62795 [FrameworkBundle] Fix mocking decorated services in tests (nicolas-grekas)
 * bug #62779 [Messenger] Fix `DeduplicateStamp` serialization (VincentLanglet)
 * bug #62838 [Serializer] Fix serialization of method with same name than property (VincentLanglet)
 * bug #62872 [Messenger] Fix processing batches (HypeMC)
 * bug #62848 [HttpKernel] Fix using HTTP Cache in worker mode (nicolas-grekas, stakovicz)
 * bug #62954 [HttpClient] Fix existing headers must be replaced in CachingHttpClient (Toflar)
 * bug #62920 [Config] Allow `ParamConfigurator` in `ParametersConfig` (jack-worman)
 * feature #62892 [BrowserKit] Allow wrapping response content to give proper context when fetching fragments (Jean-Beru)
 * bug #62884 [Form][TwigBridge] Prevent cached block prefixes from leaking across nested collections (nicolas-grekas)
 * bug #62886 [PropertyAccess][PropertyInfo][Serializer] Skip methods that look like getters but return void or never (jordikroon)
 * bug #62898 [HttpClient] update chunk items' expiration on revalidation (Lctrs)
 * bug #62877 [Translation] Add ResetInterface and reset method to DataCollectorTranslator (tourze, adming-zz, nicolas-grekas)

* 8.0.3 (2025-12-31)

 * bug #62873 [Cache] Fix namespace of chained pools when using another chain as template (nicolas-grekas)
 * bug #62858 [WebProfilerBundle] Fix using URL objects with `EventSource` (HypeMC)
 * bug #62818 [Config][FrameworkBundle] Allow using ParamConfigurator with every configurable value (jack-worman)
 * bug #62840 [Cache] Fix stampede protection when forcing item recomputation (nicolas-grekas)
 * bug #62845 [HttpClient] Fix ever growing `$maxHostConnections` (nicolas-grekas)
 * bug #62843 [DependencyInjection] Fix referencing build-time array parameters (nicolas-grekas)
 * bug #62841 [Form] Always normalize CRLF and CR to LF in `TextareaType` (alexandre-daubois)
 * bug #62490 [FrameworkBundle] Fix cache:pool:prune exit code on failure (yoeunes)
 * bug #62837 [DoctrineBridge] Fix checking for the session table when using PDO (nicolas-grekas)
 * bug #62807 [Messenger] Incorrect filtering of signed messages based on routing (Orkin)
 * bug #62813 [Console] Fix EofShortcut instruction when using a modern terminal on Windows (fperxas)
 * bug #62827 [Console] Fix choice autocomplete issue when string has spaces (ayyoub-afwallah)
 * bug #62826 [Security] Fix persisting valid origin for both safe and non-safe requests (llegaz)
 * bug #62797 [Serializer] Fix inconsistent field naming from accessors when using groups (nicolas-grekas)
 * bug #62741 [Finder] Fix converting unanchored glob patterns to regex (nicolas-grekas)
 * bug #62759 [Form] do not use PHPUnit mock objects without configured expectations (xabbuh)
 * bug #62796 [Security] do not use PHPUnit mock objects without configured expectations (xabbuh)
 * bug #62808 [Translation] do not use PHPUnit mock objects without configured expectations (xabbuh)
 * bug #62775 [Process] Fix dealing with broken stdin pipes (nicolas-grekas)
 * bug #62791 [Routing] Fix simple parameter mappings in routes (nicolas-grekas)
 * bug #62793 [Cache] Fix calling the callback wrapper for `ChainAdapter` (nicolas-grekas)
 * bug #62799 [Cache][HttpFoundation] Fix VARBINARY columns on sqlsrv (nicolas-grekas)
 * bug #62803 [AssetMapper] Batch concurrent requests to prevent flooding jsdelivr (nicolas-grekas)
 * bug #62810 [TwigBundle] Align TemplateIterator handling of @! original bundle templates with TwigExtension (mbessolov)
 * bug #62812 [Messenger][AMQP] Fix negative delays with AMQP messenger transport (hockdudu)
 * bug #62805 [VarDumper] Fix dumper selection for Accept: */* requests (apoca)
 * feature #62785 [Messenger] The component v8.0 is backed by Cadoles, thanks to them! (nicolas-grekas)
 * bug #62794 [JsonPath] fix calling non-static method statically (keradus)
 * bug #62772 [PropertyInfo] Fix calling same-named method with required args instead of reading public property (makraz)
 * bug #62773 [Serializer] Do not skip nested `null` values when denormalizing (MatTheCat)
 * bug #62745 [Validator] do not use PHPUnit mock objects without configured expectations (xabbuh)
 * bug #62755 [DependencyInjection] Fix `#[AutowireCallable]` sometimes incorrectly inlined (HypeMC)
 * bug #61963 [Doctrine][Messenger] Remove old MySQL special handling that causes deadlocks (psihius)
 * bug #62744 [TwigBridge] do not use PHPUnit mock objects without configured expectations (xabbuh)
 * bug #62756 [Mailer] do not use PHPUnit mock objects without configured expectations (xabbuh)
 * bug #62740 [Serializer] Fix php 8.5 warning unexpected NAN value was coerced to … (aaa2000)
 * bug #62747 [Routing] Do not renumber query parameters with numeric key (tillhoerner)
 * bug #62758 [BrowserKit] Allow Cookie expiration to be an int (derrabus)
 * bug #62764 [Console] Escape `` in description of console commands (SiebeVE)
 * bug #62735 [JsonStreamer] Fix the generated PHP code when using array shape (sukei)
 * bug #62719 [Workflow] Fix empty string condition for place name (mboelsterli)
 * bug #62728 [HttpClient] mark response stale when age equals freshness lifetime (Lctrs)
 * bug #62396 [PropertyInfo] Fix inconsistency between isWritable and getWriteInfo (yoeunes)
 * bug #62699 [HttpClient] Fix `ScopingHttpClient` to always pass `base_uri` as `string` instead of parsed `array` (santysisi)
 * bug #62716 [Validator] fix handling named arguments in `Existence` constraint (xabbuh)
 * bug #62717 [PropertyInfo] fix ``@var`` tag support for `PhpStanExtractor` (qconer)
 * bug #62711 [PhpUnitBridge] Fix TestCase patching (villfa)
 * bug #62706 [HttpClient] Fix PHP deprecation when using `AmpHttpClient` (nicolas-grekas)
 * bug #62698 [HttpClient] Fix copy as curl for arrays with resources & unreachable host (HypeMC)
 * bug #62695 [TwigBridge] do not render button labels if they are explicitly disabled (xabbuh)
 * bug #62692 [FrameworkBundle] Enable console profiling only if the console is actually available (dbu)
 * bug #62691 [JsonPath] Update and fix the compliance test suite (alexandre-daubois)
 * bug #62686 [PropertyInfo] Fix PseudoType support in PhpDocTypeHelper (VincentLanglet)
 * bug #62710 [TwigBundle] Fix unintended BC break for the `exception_controller` twig setting (stof)
 * bug #62715 [DependencyInjection] Fix sharing services used only by tagged iterators (nicolas-grekas)
 * bug #62714 [DependencyInjection] Handle recursive factory reentry for shared services in `PhpDumper` (nicolas-grekas)

* 8.0.2 (2025-12-08)

 * bug #62682 [Serializer][Validator] Attribute metadata no longer requires `container.excluded` tags (HypeMC)
 * bug #62685 [DependencyInjection] Fix `PriorityTaggedServiceTrait` when tag attributes are not a list (GromNaN)

* 8.0.1 (2025-12-07)

 * bug #62663 [HttpFoundation] Improve logic in Request::createFromGlobals() (nicolas-grekas)
 * bug #62675 [DependencyInjection] Fix dealing with errored service definitions (nicolas-grekas)
 * bug #62671 [DomCrawler] Fixing dealing with invalid charset (ThomasLandauer)
 * bug #62488 [HttpKernel] Make `#[Cache]` respect all explicit cache directives set in controller (ayyoub-afwallah)
 * bug #62665 [DependencyInjection] Revert "bug #62541  Reset resolved state when setting a parameter" (nicolas-grekas)
 * bug #62388 [TypeInfo] Simple array should be array type (matijn-made)
 * bug #61962  [Console] Handle signals on text input (valx76)
 * bug #62661 [Runtime] Reuse the already created Request object when the app needs one as argument and returns a kernel (nicolas-grekas)
 * bug #62477 [DependencyInjection] Allow manual bindings on parameters with #[Target] (yoeunes)
 * bug #62495 [Security][Http] Fix OIDC discovery when multiple HttpClient instances are used (Ali-HENDA)
 * bug #62563 [Config] Fix array shape generation for backed enums (OskarStark)
 * bug #62621 [Form] Fix moneytype step (Belhassen)
 * bug #62622 [JsonStreamer] fix invalid json output for list of self (DjordyKoert)
 * bug #62627 [Console] Preserve `--help` option when a command is not found (santysisi)
 * bug #62656 [FrameworkBundle] Fix using `FailedMessages*Command` with `SigningSerializer` (HypeMC)
 * bug #62653 [Lock] Fix unserializing already serialized Key payloads (nicolas-grekas)
 * bug #62652 [HttpClient] CachingHttpClient must run after UriTemplate and Scoping (Lctrs)
 * bug #62651 [FrameworkBundle] Only register PhpConfigReferenceDumpPass in dev env with debug flag enabled (bobvandevijver)
 * bug #62619 [Messenger] Fix PHP 8.5 deprecation for pgsqlGetNotify() in PostgreSQL transport (Shine-neko)
 * bug #62544 [DependencyInjection] Ensure deprecation detection does not trigger a PHP error (bnf)
 * bug #62586 [DependencyInjection][FrameworkBundle] fix BC break when dumping container for build/lint commands (aschempp)
 * bug #62607 [Form] Clean up wrong method docblocks in data transformers (alexndlm)
 * bug #62612 [Yaml] Fix regression handling blank lines in unquoted scalars (yoeunes)
 * bug #62646 [DependencyInjection] Throw when using `$this` or its internal scope from PHP config files (nicolas-grekas)
 * bug #62645 [HttpClient] Fix sharing CurlClientState between clones of CurlHttpClient instances (nicolas-grekas)
 * bug #62647 [FrameworkBundle] Don't exclude classes with constraint/serialization attributes from being registered as services (nicolas-grekas)
 * bug #62614 [Cache] Fix NullAdapter must set taggable (a.dmitryuk)
 * bug #62562 [Console] don't discard existing aliases when constructing Command (henderkes)
 * bug #62535 [HttpKernel] Don't reset services between fragments redering when using in HttpCache (nicolas-grekas)
 * bug #62532 [FrameworkBundle] Dump bundles config reference first (MatTheCat)
 * bug #62541 [DependencyInjection] Reset resolved state when setting a parameter (yoeunes)
 * bug #62558 [DependencyInjection] Don't add empty `.container.known_envs` in XML loader (GromNaN)
 * bug #62602 [Cache] Fix the creation of a redis connection with only ext-relay (stof)
 * bug #62587 [PropertyInfo] treat mixed[] the same as array when getting types from docblocks (xabbuh)
 * bug #62524 [Notifier][Mercure] Add support for Mercure 0.7 (Kocal)
 * bug #62571 [Console] Fix profile invokable command (Jibbarth)
 * bug #62577 [PropertyInfo] treat `mixed[]` the same as `array` when getting types from docblocks (xabbuh)
 * bug #62498 [FrameworkBundle] fix merging of enabled locales (dmaicher)
 * bug #62551 [FrameworkBundle] register attribute loader arguments in a forward-compatible way (xabbuh)
 * bug #62465  [JsonPath] Fix throwing on quoted True/False/Null (TamasSzigeti)
 * bug #62482 [DependencyInjection] Fix loose validation in `#[Autowire]` attribute (yoeunes)
 * bug #62513 [FrameworkBundle] Add missing `useAttributeAsKey` calls (MatTheCat)
 * bug #62523 [DependencyInjection] Fix state corruption in `PhpFileLoader` during recursive imports (yoeunes)
 * bug #62543 [Cache] ensure compatibility with RelayCluster 0.20.0 (xabbuh)
 * bug #62536 [Cache] ensure compatibility with Relay extension 0.20.0 (xabbuh)
 * bug #62515  [FrameworkBundle] Allow backed enum to be used in initial_marking workflow configuration (DemonTPx)
 * bug #62506 [DependencyInjection] Fix `query_string` env processor for URLs without query string (yoeunes)
 * bug #62502 [HttpFoundation] Fix Expires response header for EventStream (4513)
 * bug #62503 [HttpClient] Fix releasing uploaded stream resources (nicolas-grekas)
 * bug #62474 [Config] Fix nullable EnumNode with BackedEnum (yoeunes)
 * bug #62485 [DependencyInjection] Fix loop corruption in `CheckTypeDeclarationsPass` (yoeunes)
 * bug #62486 [DependencyInjection] Fix invalid PHP syntax for nullable `TypedReference` in `PhpDumper` (yoeunes)
 * bug #62487 [Security] Fix `UserBadge` validation bypass via identifier normalizer (yoeunes)
 * bug #62489 [FrameworkBundle] Fix TypeError when traversing scalar values in debug:config (yoeunes)
 * bug #62493 [Console] Fix exception message when abbreviation matches multiple hidden commands (yoeunes)
 * bug #62471 [String] Fix normalization in trimPrefix/trimSuffix (yoeunes)

* 8.0.0 (2025-11-27)

 * feature #62530  Thank you PhpStorm for backing Symfony 8.0! (nicolas-grekas)
 * feature #62529  Thank you Sulu for backing Symfony 8.0! (nicolas-grekas)
 * feature #62528  Thank you redirection.io and JoliCode for backing Symfony 7.4! (nicolas-grekas)
 * feature #62527  Thank you Private Packagist for backing Symfony 7.4! (nicolas-grekas)
 * feature #62526  Thank you SensioLabs for backing Symfony 7.4! (nicolas-grekas)
 * bug #62476 [DependencyInjection] Fix wrong trait usage in ServiceLocatorArgument (yoeunes)
 * feature #62469 [Security] Keep SymfonyCasts as backers of the Security components v7.4 🤗 (nicolas-grekas)

* 8.0.0-RC3 (2025-11-21)

 * bug #62454 [ObjectMapper] mapping of nested classes with promoted read-only properties (soyuka)
 * bug #62456 [AssetMapper] Fix entrypoint status lost during update (yoeunes)
 * bug #62416 [Console] Fix completion for global options values (HypeMC)
 * bug #62455 [ObjectMapper] map to embedded object with property access (soyuka)
 * bug #62458 [Workflow] Fix `MethodMarkingStore` crash with inherited uninitialized properties (yoeunes)
 * bug #62459 [Routing] Fix case sensitivity for static host matching in compiled routes (yoeunes)
 * bug #62461 [Routing] Fix localized prefix updates breaking aliases (yoeunes)
 * bug #62460 [Routing] Fix addNamePrefix breaking aliases to external routes (yoeunes)
 * bug #62453 [FrameworkBundle] Make `APP_*_DIR` relative to the project directory (nicolas-grekas)
 * bug #62447 [Form] Mark FormFlow as finished if the last step is skipped (yceruto)
 * bug #62436 [FrameworkBundle] Dump all registered extensions’ configuration reference (MatTheCat)
 * bug #62449 [HttpKernel] Fix using MapRequestPayload on nullable arguments (nicolas-grekas)
 * bug #62415 [HttpClient] Don't reset unused clients in data collector (HypeMC)
 * bug #62417 [ObjectMapper] bypass lazy ghost with class transform (soyuka)
 * bug #62437 [DependencyInjection] Fix preloading `LazyClosure` (nicolas-grekas)
 * bug #62441 [WebProfilerBundle] fix displaying runner (94noni)

* 8.0.0-RC2 (2025-11-16)

 * bug #62411 [HttpKernel] Conflict with symfony/flex < 2.10 (nicolas-grekas)
 * bug #62409 [Yaml] Align unquoted multiline scalar parsing with spec for comments (yoeunes)
 * bug #62398 [Cache] Fix accepting named closures as early-expiration callbacks (nicolas-grekas)
 * bug #62406 [Notifier] do not use recipient phone numbers as sender e-mail addresses (xabbuh)
 * bug #62407 [FrameworkBundle] work around limitation in `JsonResponse` when the data is `null` (xabbuh)
 * bug #62402 [FrameworkBundle] Revert auto-import of #[Route] defined on controllers (nicolas-grekas)
 * bug #62400 [Form] Fix EnumType choice_label logic for grouped choices (yoeunes)
 * bug #62369 [Security] Set OIDC JWKS cache TTL from provider headers (Ali-HENDA)
 * bug #62393 [Dependencyinjection] Call default index method when index is not provided by tag (yoeunes)
 * bug #62372 [Cache] Recognize saveDeferred events as writes in `CacheDataCollector` (yitznewton)
 * bug #62389 [Routing] Align routing.schema.json with YamlFileLoader behavior (yoeunes)

* 8.0.0-RC1 (2025-11-13)

 * bug #62335 [Console] Fix signal handlers not being cleared after command termination (yoeunes)
 * bug #62348 [Translation][Lokalise] fix "Project too big for sync export" (santysisi)
 * bug #62304 [DependencyInjection] Fix lazy proxy creation for interfaces aliased to final classes (yoeunes)
 * bug #62036 [HttpKernel] Fix StreamedResponse with chunks support in HttpKernelBrowser (wuchen90)
 * bug #62063 [JsonStreamer] Rebuild cache on class update (mtarld)
 * bug #62287 [HttpFoundation] Fix AcceptHeader overwrites items with different parameters (yoeunes)
 * bug #62325 [Routing] Fix default value not taken if usigng name:entity.attribute (eltharin)
 * bug #62329 [DependencyInjection] Fix merging explicit tags and #[AsTaggeditem] (nicolas-grekas)
 * bug #62356 [HttpClient] Fix `Warning: curl_multi_select(): timeout must be positive` (Jeroeny)
 * bug #62334 [PropertyInfo] Fix `ReflectionExtractor` handling of underscore-only property names (yoeunes)
 * bug #58473 [Serializer] Fix `AbstractObjectNormalizer` to allow scalar values to be normalized (Hanmac, xabbuh)
 * bug #62093 [Security] Fix `HttpUtils::createRequest()` when the context’s base URL isn’t empty (MatTheCat)
 * bug #62007 [Serializer] fix inherited properties normalization (Link1515)
 * bug #62286 [Cache] compatibility with ext-redis 6.3 (xabbuh)
 * bug #62321 [Serializer] Fix BackedEnumNormalizer behavior with partial denormalization (yoeunes)
 * bug #62344 [OptionsResolver] Fix missing prototype key in nested error paths (yoeunes)
 * bug #62346 [Clock] Align MockClock::sleep() behavior with NativeClock for negative values (yoeunes)
 * bug #62347 [OptionsResolver] Ensure remove() also unsets deprecation status (yoeunes)
 * bug #62359 [Yaml] Fix parsing of unquoted multiline scalars with comments or blank lines (yoeunes)
 * bug #62350 [ExpressionLanguage] Compile numbers with var_export in Compiler::repr for thread-safety (yoeunes)
 * security #cve-2025-64500 [HttpFoundation] Fix parsing pathinfo with no leading slash (nicolas-grekas)
 * bug #62333  Postal mailer transport message ID retrieval (lalcebo)
 * feature #62326 [Cache][Messenger] re-allow ext-redis 6.1 (xabbuh)
 * bug #62324 [HttpFoundation] Fix parsing hosts and schemes in URLs (nicolas-grekas)
 * bug #62171 [Messenger] Fix commands writing to `STDERR` instead of `STDOUT` (wazum)
 * bug #62315  Keep body size limit for AMP redirects (villermen)
 * bug #62214 [ObjectMapper] lazy loading (soyuka)
 * bug #62237 [Form] Fix EnumType choice_label logic for grouped choices (yoeunes)
 * bug #62283 [Filesystem] Unify logic for isAbsolute() in Path (yoeunes)
 * feature #62302 [Routing] Simplify importing routes defined on controller services (nicolas-grekas)
 * bug #62091 [BrowserKit] The BrowserKit history with parameter separator without slash. (biozshock)
 * bug #62297 [Twig] Ensure WrappedTemplatedEmail::getReturnPath() returns a string (yoeunes)
 * bug #62294 [Console] Add missing VERBOSITY_SILENT case in CommandDataCollector (yoeunes)
 * bug #62290 [Routing] Fix matching the "0" URL (cs278)
 * bug #62285 [HttpClient] Reject 3xx pushed responses (nicolas-grekas)

* 8.0.0-BETA2 (2025-11-02)

 * feature #62270 [Lock][DynamoDB] Allow symfony/lock 8.0 (DavidPrevot)
 * bug #62267 [Config] Use the empty string instead of null as an array offset (santysisi)
 * feature #62266 [Mailer][MicrosoftGraph] Bump to PHP >= 8.4 (santysisi)
 * bug #62261 [Cache] Add missing SQLitePlatform use statement in DoctrineDbalAdapter (yoeunes)
 * feature #62230 [Messenger] Support signing messages per handler (nicolas-grekas)
 * bug #62246 [HttpFoundation] Allow Request::setFormat() to override predefined formats (longwave)
 * feature #60153 [Serializer] Allow forcing timezone in `DateTimeNormalizer` during denormalization (frankdekker)
 * bug #62240 [DomCrawler] Handle malformed tags in HTML5 parser (longwave)
 * bug #62242 [MonologBridge] Accept HttpExceptionInterface in HttpCodeActivationStrategy (GromNaN)
 * bug #62222 [Cache] fix ext-redis 6.2.0 compatibility (xabbuh)
 * bug #62211 [Workflow] State contamination due to class-based setter cache (nicolas-grekas)
 * bug #62184 [EventDispatcher][FrameworkBundle] Rework union types on `#[AsEventListener]` (HypeMC)
 * bug #62199 [Workflow] State Contamination in Marking Stores due to Class-based Getter Cache (siganushka)
 * bug #62197 [Validator] Fix call to undefined getParser() in YamlValidator (yoeunes)
 * bug #62203 [Mailer] Fix contentId assignment for inline attachments (webflo)
 * bug #62201 [HtmlSanitizer] Remove `srcdoc` from allowed attributes (Spomky)
 * feature #62190 [Runtime] Expose `project_dir` as `APP_PROJECT_DIR` env var (nicolas-grekas)
 * bug #62191 [FrameworkBundle] Change HttpCache directory to use new getShareDir (alexander-schranz)
 * bug #62169 [HttpClient] Fix caching client decorating scoping client (pierredup)
 * bug #62185 [FrameworkBundle] Add missing `container.excluded` to `serializer.attribute_metadata` (HypeMC)
 * bug #62186 [DomCrawler] Fix converting HTML5 trees to DOM nodes (nicolas-grekas)
 * bug #62182 [VarDumper] Fix dumping CurlHttpClient instances (nicolas-grekas)
 * bug #62180 [DomCrawler] Properly ignore errors when using the native HTML5 parser (nicolas-grekas)
 * bug #62178 [FrameworkBundle] Expose share directory in AboutCommand (ro0NL)
 * bug #62167 [Lock][DynamoDB] Enable `http_client` injection and fix tests using AmpV5 client (GromNaN)
 * feature #62170 [HttpKernel] Add `KernelInterface::getShareDir()`, `APP_SHARE_DIR` and `kernel.share_dir` (nicolas-grekas)

* 8.0.0-BETA1 (2025-10-27)

 * feature #59974 [Runtime] Make project_dir configurable (wickedOne)
 * feature #60033 [ErrorHandler][FrameworkBundle] Add support for selecting the appropriate error renderer based on the `APP_RUNTIME_MODE` (yceruto)
 * feature #62027 [DebugBundle][HttpKernel] Collect dumps when console profiling is enabled (HypeMC)
 * feature #61843 [Messenger] Add `MessageSentToTransportsEvent` (HypeMC)
 * feature #61880 [JsonStreamer] Merge `PropertyMetadata` value transformers (mtarld)
 * feature #60212 [Form] Add `FormFlow` for multistep forms management (yceruto)
 * feature #62113 [Config][DependencyInjection] Remove support for the fluent PHP config format (nicolas-grekas)
 * feature #62135 [Config] Deprecate config builder generators (nicolas-grekas)
 * feature #62129 [FrameworkBundle] Auto-generate `config/reference.php` to assist in writing and discovering app's configuration (nicolas-grekas)
 * feature #62069 [JsonStreamer] Add synthetic properties support (mtarld)
 * feature #62109 [Config] Ensure configuration nodes do not have both `isRequired()` and `defaultValue()` (GromNaN)
 * feature #62092 [Config][DependencyInjection] Deprecate the fluent PHP format for semantic configuration (nicolas-grekas)
 * feature #62090 [Config] Deprecate setting a default value to a node that is required (GromNaN)
 * feature #61984 [Messenger] Add retry delay on amazon sqs transport (deguif)
 * feature #62077 [Security] Add support for `Sec-Fetch-Site` to `SameOriginCsrfTokenManager` (nicolas-grekas)
 * feature #62073 [HttpClient] Add QUERY to the list of retriable HTTP methods (nicolas-grekas)
 * feature #62068 [Console] Add support for `Cursor` helper in invokable commands (yceruto)
 * feature #62059 [HttpClient] Add option `auto_upgrade_http_version` to control how the request HTTP version is handled in `HttplugClient` and `Psr18Client` (ajgarlag)
 * feature #62043 [Security] Allow multiple OIDC discovery endpoints (ruudk)
 * feature #62010 [Routing] Initialize `router.request_context`'s `_locale` parameter to `kernel.default_locale` (MatTheCat)
 * feature #62042 [HttpFoundation] drop support for HTTP method override for GET, HEAD, CONNECT and TRACE requests (xabbuh)
 * feature #62039 [Notifier] Add support for `confirm` option in Slack buttons API (Taras Hinyk)
 * feature #61949 [HttpFoundation] Deprecate HTTP method override for methods GET, HEAD, CONNECT and TRACE (nicolas-grekas)
 * feature #61979 [HttpFoundation] Add `Request::set/getAllowedHttpMethodOverride()` to list which HTTP methods can be overridden (nicolas-grekas)
 * feature #61490 [DependencyInjection][Routing] Define array-shapes to help writing PHP configs using yaml-like arrays (nicolas-grekas)
 * feature #61961 [HttpFoundation] Make `Request::createFromGlobals()` parse the body of PUT, DELETE, PATCH and QUERY requests (MatTheCat)
 * feature #61993 [DoctrineBridge] Remove `AbstractDoctrineExtension` (GromNaN)
 * feature #61992 [DoctrineBridge] Deprecate `AbstractDoctrineExtension` (GromNaN)
 * feature #61989 [Config][DependencyInjection][Routing] remove ability to access $this and the loader's internal state (xabbuh)
 * feature #61986 [DependencyInjection] remove getNamespace() and getXsdValidationBasePath() from ExtensionInterface (xabbuh)
 * feature #61987 [HttpClient] remove support for StoreInterface as the HTTP client cache (xabbuh)
 * feature #61983 [HttpFoundation] Remove `Request::get()` (PierreCapel)
 * feature #61976 [FrameworkBundle] remove the deprecated WorkflowDumpCommand (xabbuh)
 * feature #60660 [Security] Add security:oidc-token:generate command (Jean-Beru)
 * feature #61955 [Messenger] bump ext-redis to 6.2 and ext-relay to 0.12 minimum (xabbuh)
 * feature #61252 [FrameworkBundle] Add support for union types on `#[AsEventListener]` (Fan2Shrek)
 * feature #61748 [Console] Add support for interactive invokable commands with `#[Interact]` and `#[Ask]` attributes (yceruto)
 * feature #61952 [Cache] bump ext-relay to 0.12+ (xabbuh)
 * feature #61948 [HttpFoundation] Deprecate Request::get() in favor of using properties ->attributes, query or request directly (nicolas-grekas)
 * feature #61930 [DependencyInjection][Routing] Remove support for the XML configuration format (nicolas-grekas)
 * feature #61933 [Workflow] Move the dump command to the component (lyrixx)
 * feature #61919 [DependencyInjection] Deprecate `ExtensionInterface::getXsdValidationBasePath()` and `getNamespace()` (nicolas-grekas)
 * feature #60201 [Workflow] Add support for weighted transitions (lyrixx)
 * feature #60568 [DependencyInjection][Routing] Deprecate XML configuration format (MatTheCat)
 * feature #61837 [Form] Add new `active_at`, `not_active_at` and `legal_tender` options to `CurrencyType` (Crovitche-1623)
 * feature #61894 [DependencyInjection][Routing] Handle declaring services and routes using PHP arrays that follow the same shape as corresponding yaml files (nicolas-grekas)
 * feature #61860 [Config][DependencyInjection][Routing] Deprecate using `$this` or the internal scope of the loader from PHP config files (nicolas-grekas)
 * feature #61885 [DependencyInjection] Handle returning arrays and config-builders from config files (nicolas-grekas)
 * feature #59576 [HttpClient] Make `CachingHttpClient` compatible with RFC 9111 (Lctrs)
 * feature #61851 [Validator] remove support for implicit constraint option names in YAML/XML mapping files (xabbuh)
 * feature #61850 [Validator] remove support for passing associative arrays to GroupSequence (xabbuh)
 * feature #61848 [MonologBridge] remove the deprecated NotFoundActivationStrategy class (xabbuh)
 * feature #61841 [Validator] deprecate passing an associative array to GroupSequence (xabbuh)
 * feature #61789 [Security] deprecate extending `RememberMeDetails` using legacy constructor signature (xabbuh)
 * feature #61807 [Uid] Add `MockUuidFactory` for deterministic UUID generation in tests (momito69)
 * feature #61838 [Notifier][LOX24] Add Lox24 webhook request parser support (alebedev80)
 * feature #61836 [MonologBridge] Deprecate `NotFoundActivationStrategy` (HypeMC)
 * feature #61791 [Validator] deprecate implicit constraint option names in YAML/XML mapping files (xabbuh)
 * feature #61778 [Notifier] Add support for building SmsEvent by dlr_code and RemoteEvent for other LOX24 webhook event types (alebedev80)
 * feature #61820 [HttpKernel][WebProfilerBundle] Display runner class in the profiler toolbar (MatTheCat)
 * feature #60902 [TwigBridgeRessources] add aria-invalid and aria-describedby on form inputs when validation failure exist (jeanfrancois-morin)
 * feature #59955 [MonologBridge] Add ability to react to console input being interactive or not (dkarlovi)
 * feature #61812 [Uid] Default to `UuidV7` when using `UuidFactory` (nicolas-grekas)
 * feature #60237 [DoctrineBridge] Add new `DayPointType` and `TimePointType` Doctrine type (wkania)
 * feature #60085 [Security] improve VoteObject adding extraData for give more possibilities to AccessDecicsionStrategy (eltharin)
 * feature #51273 [Config] Add `ArrayNodeDefinition::acceptAndWrap()` to list alternative types that should be accepted and wrapped in an array (nicolas-grekas)
 * feature #60561 [Validator] Add option to allow `ANY` protocol in `Assert\Url` constraint (alekLexis)
 * feature #61760 [Security] remove the user FQCN from remember me cookies (xabbuh)
 * feature #61775 [Mailer][Mandrill] Add `subaccount` to the payload (andrehoong-pixieset)
 * feature #61777 [Notifier][Twilio] WhatsApp number validation (OvidiuGi)
 * feature #60023 [Lock] Add `LockKeyNormalizer` (valtzu)
 * feature #46257 [Messenger] Add AMQP exchange to exchange bindings (Samik081)
 * feature #60228 [Serializer] Support preserving array keys with `XmlEncoder` (Maximilian Ruta)
 * feature #61765 [TypeInfo] Add result cache to `TypeContextFactory` (landure)
 * feature #60114 [Workflow] Add support for `BackedEnum` in `MethodMarkingStore` (tucksaun)
 * feature #61758 [Mailer][Sendgrid] Add support for `global` region (sonnymilton)
 * feature #61743 [Security] deprecate the FQCN properties of `PersistentToken` and `RememberMeDetails` (xabbuh)
 * feature #60204 [FrameworkBundle] Add support for configuring workflow places with glob patterns matching consts/backed enums (lyrixx)
 * feature #60395 [HttpFoundation] Add `#[IsSignatureValid]` attribute (santysisi)
 * feature #61110 [FrameworkBundle] Prepare session in functionnal tests (cyve)
 * feature #61718 [Config] Add argument `$singular` to `NodeBuilder::arrayNode()` to decouple plurals/singulars from XML (nicolas-grekas)
 * feature #60138 [Lock] DynamoDB store (natepage)
 * feature #61092 [Console][QuestionHelper] add optional timeout for human interaction (janedbal)
 * feature #54366 [Messenger] Introduce `DefaultStampsProviderInterface ` (VincentLanglet)
 * feature #61694 [Security] Add `$tokenSource` argument to `#[IsCsrfTokenValid]` to support reading tokens from the query string or headers (webda2l)
 * feature #61563 [Serializer] Add `#[ExtendsSerializationFor]` to declare new serialization attributes for a class (nicolas-grekas)
 * feature #61545 [Validator] Add `#[ExtendsValidationFor]` to declare new constraints for a class (nicolas-grekas)
 * feature #61311 [WebProfilerBundle] Show `EventSource` requests in debug toolbar (valtzu)
 * feature #61654 [Security] Deprecate `PersistentToken::getClass()` and `RememberMeDetails::getUserFqcn()` in order to remove the user FQCN from the remember-me cookie in 8.0 (nicolas-grekas)
 * feature #58070 [VarDumper] Select HtmlDumper only if `Accept` header contains "html" (alexandre-daubois)
 * feature #61478 [Console] Add `#[Input]` attribute to support DTOs in invokable commands (yceruto)
 * feature #61034 [Security][SecurityBundle] Dump role hierarchy as mermaid chart (damienfern)
 * feature #61656 [DependencyInjection] Allow `Class::function(...)` and `global_function(...)` closures in PHP DSL for factories (GromNaN)
 * feature #61657 [VarExporter] Add support for exporting named closures (nicolas-grekas)
 * feature #61532 [Serializer] Allow using attributes to declare compile-time serialization metadata (nicolas-grekas)
 * feature #61528 [Validator] Allow using attributes to declare compile-time constraint metadata (nicolas-grekas)
 * feature #61379 [Security][TwigBridge] Add `access_decision()` and `access_decision_for_user()` (florentdestremau)
 * feature #59042 [Validator] Add `Video` constraint for validating video files (symfonyaml)
 * feature #61575 [DependencyInjection] Allow multiple `#[AsDecorator]` attributes (Jean-Beru)
 * feature #61592 [Runtime] Expose the runtime class in `$_SERVER['APP_RUNTIME']` (nicolas-grekas)
 * feature #61578 [DependencyInjection] Parse attributes found on abstract classes for resource definitions (nicolas-grekas)
 * feature #61564 [Serializer][Validator] Add JSON schema for validating and autocompleting YAML config files (nicolas-grekas)
 * feature #61536 [DependencyInjection] Allow adding resource tags using any config formats (nicolas-grekas)
 * feature #61297 [Form] Add form type guesser for `EnumType` (mttsch)
 * feature #61555 [Mailer][Sweego] Add support for new webhook events (welcoMattic)
 * feature #61431 [Intl] Add methods to filter currencies more precisely (Crovitche-1623)
 * feature #61542 [Security] Allow subclassing `#[IsGranted]` (nicolas-grekas)
 * feature #61540 [Validator] require a top-level domain by default in the Url constraint (xabbuh)
 * feature #61541 [DependencyInjection] throw when a service's id a non-existing FQCN (xabbuh)
 * feature #61497 [ObjectMapper] cache attributes in memory (soyuka)
 * feature #61522 [Runtime] Support runtime options as a string (VincentLanglet)
 * feature #59780 [FrameworkBundle] Only show relevant columns in `debug:router` call and adding colors (mamazu)
 * feature #61057 [Security] Improve performance of `RoleHierarchy::buildRoleMap` method (simonjamain-gp, simonjamain)
 * feature #60979 [Messenger] Add `--exclude-receivers` to `messenger:consume` command (jbdelhommeau)
 * feature #60442 [ObjectMapper] embed collection transformer (soyuka)
 * feature #61504  [SecurityHttp] Removes final keyword from IsGranted attribute (crtl)
 * feature #61500 [JsonPath][JsonStreamer][ObjectMapper] the components are no longer experimental (xabbuh)
 * feature #61492 [FrameworkBundle][Routing] Auto-register routes from attributes found on controller services (nicolas-grekas)
 * feature #61282 [DependencyInjection][Routing] Add JSON schema for validating and autocompleting YAML config files (nicolas-grekas)
 * feature #61078 [Console] Add getter for the original command "code" object (weitzman)
 * feature #61078 [Console] Add getter for the original command "code" object (weitzman)
 * feature #61480 [TypeInfo] Add extra type alias support (mtarld)
 * feature #61488 [Routing][Serializer] Remove annotation aliases and getters and setters in favor of public properties on attributes (nicolas-grekas)
 * feature #61487 [Routing][Serializer] Deprecate annotation aliases and getters and setters in favor of public properties on attributes (nicolas-grekas)
 * feature #61481 [DomCrawler] Always parse according to HTML5 rules thanks to the native DOM parser (nicolas-grekas)
 * feature #61475 [DomCrawler] Use the native HTML5 parser on PHP 8.4 (nicolas-grekas)
 * feature #61477 [Routing] Remove deprecated `getEnv` and `setEnv` methods (santysisi)
 * feature #60120 [Routing] Add possibility to create a request context with parameters directly (alexander-schranz)
 * feature #61455 [Mailer][Sendgrid] Add suppression groups support (KiloSierraCharlie)
 * feature #61267 [HttpFoundation] Add support for structured MIME suffix (Spomky)
 * feature #61358 [Routing] allow setting multiple envs in `#[Route]` attribute (santysisi)
 * feature #61359 [Security] Add `$methods` support to `#[IsGranted]` to restrict access by HTTP method (santysisi)
 * feature #60218 [Notifier][Discord] Add `DiscordBotTransport` (norkunas)
 * feature #61444 [Notifier][Telegram] Add TelegramOptions::messageThreadId() (MKC-MKC)
 * feature #61315 [Mailer] Add compatibility for Mailtrap's sandbox (KiloSierraCharlie)
 * feature #61173 [HttpFoundation][HttpKernel][WebProfilerBundle] Add support for the `QUERY` HTTP method (alexandre-daubois)
 * feature #61424 [HttpKernel][Mime][Serializer][String][Validator] Replace `__sleep/wakeup()` by `__(un)serialize()` (nicolas-grekas)
 * feature #61423 [Mime] Deprecate implementing `__sleep/wakeup()` on `AbstractPart` implementations (nicolas-grekas)
 * feature #61418 [Validator] Deprecate implementing `__sleep/wakeup()` on GenericMetadata implementations (nicolas-grekas)
 * feature #61417 [String] Deprecate implementing `__sleep/wakeup()` on string implementations (nicolas-grekas)
 * feature #61412 [HttpKernel] Deprecate `__sleep/wakeup()` on kernels and data collectors and make `Profile` final (nicolas-grekas)
 * feature #61413 [Serializer] Make `AttributeMetadata` and `ClassMetadata` final (nicolas-grekas)
 * feature #61391 [HtmlSanitizer] Remove MastermindsParser and add $context arg to ParserInterface::parse() (nicolas-grekas)
 * feature #61366 [HtmlSanitizer] Use the native HTML5 parser when using PHP 8.4+ (nicolas-grekas)
 * feature #61290 [Mailer] Add MicrosoftGraph API Transport (bobvandevijver)
 * feature #60754 [Messenger] Allow SQS to handle its own retry/DLQ (maxbaldanza)
 * feature #61308 [Console] Adding more helpful error messages to the Questionhelper (mamazu)
 * feature #61063 [Validator] remove support for generic constraint option handling (xabbuh)
 * feature #61270 [DependencyInjection] Deprecate registering a service without a class when its id is a non-existing FQCN (nicolas-grekas)
 * feature #61255 [Validator] deprecate passing choices as `$options` argument to `Choice` constraint (xabbuh)
 * feature #60355 [Serializer] Add `CDATA_WRAPPING_NAME_PATTERN` support to `XmlEncoder` (Maximilian Ruta)
 * feature #60955 [BrowserKit] Add PHPUnit constraints: `BrowserHistoryIsOnFirstPage` and `BrowserHistoryIsOnLastPage` (santysisi)
 * feature #60805 [Validator] Add `min` and `max` in both error messages of `LengthValidator` (VincentLanglet)
 * feature #61133 [AssetMapper] Add support for loading JSON using import statements (nicolas-grekas)
 * feature #61204 [Security] Support union type for `#[CurrentUser]` attribute (VincentLanglet)
 * feature #60730  [JsonStreamer] Add `include_null_properties` option (mtarld)
 * feature #61006 [JsonStreamer] Provide current object to value transformers  (mtarld)
 * feature #60935 [Translation] Add `StaticMessage` (VincentLanglet)
 * feature #61187 Declare new parameters on interfaces and methods explicitly (nicolas-grekas)
 * feature #61182 [Translation] Remove `TranslatableMessage::__toString()` method, use `trans()` or `getMessage()` instead (nicolas-grekas)
 * feature #61179 [DependencyInjection] Remove `!tagged` tag, use `!tagged_iterator` instead (nicolas-grekas)
 * feature #61183 [Security] Throw when passing an empty string as $userIdentifier and tighten AuthenticatorManager and OidcTokenHandler arguments (nicolas-grekas)
 * feature #61180 [HttpFoundation] Trigger PHP warning when using `Request::sendHeaders()` after headers have already been sent (nicolas-grekas)
 * feature #61176 [DoctrineBridge] Remove support for auto-mapping Doctrine entities to controller arguments (nicolas-grekas)
 * feature #61145 [ObjectMapper] Add `ObjectMapperAwareInterface` to set the owning object mapper instance (soyuka)
 * feature #61156 [FrameworkBundle][TwigBundle] Remove options session.sid_length session.sid_bits_per_character router.cache_dir validation.cache and base_template_class (nicolas-grekas)
 * feature #61155 [FrameworkBundle][SecurityBundle] Remove autowiring aliases for `RateLimiterFactory` (nicolas-grekas)
 * feature #61109 [Translation] Deprecate `TranslatableMessage::__toString` (VincentLanglet)
 * feature #61023 [Serializer] add `can` to the accessor prefixes recognized by the `AttributeLoader` (Mark Schmale)
 * feature #61127 [Cache] Add `TagAwareAdapterInterface` to `NullAdapter` (a.dmitryuk)
 * feature #61108 [DoctrineBridge][Validator] mark getRequiredOptions()/getDefaultOption() of UniqueEntity as deprecated (xabbuh)
 * feature #60988 [TypeInfo] Remove deprecated code for non-array based collections (mttsch)
 * feature #61067 [Ldap] remove the `sizeLimit` option of `AbstractQuery` (xabbuh)
 * feature #61068 [ExpressionLanguage] forbid passing `null` as allowed variables (xabbuh)
 * feature #61065 [FrameworkBundle][WebProfilerBundle] remove XML routing configuration files (xabbuh)
 * feature #61011 [Security] Remove deprecated `RememberMeToken::getSecret()` (ktherage)
 * feature #60801 [Validator] deprecate handling options in the base Constraint class (xabbuh)
 * feature #60110 [Mailer] [Transport] Allow exception logging for `RoundRobinTransport` mailer (jnoordsij)
 * feature #61024 [Intl] Optionally allow Kosovo as a component region (llupa)
 * feature #61048 [TwigBridge] remove the ability to pass a tag to FormThemeNode (xabbuh)
 * feature #61046 [SecurityBundle] configuration for the storage service for the login throttling rate limiter (xabbuh)
 * feature #60999 [Messenger] Allow any `ServiceResetterInterface` implementation in `ResetServicesListener` (santysisi)
 * feature #60952 [Form] Remove BC layer from `ResizeFormListener` (OskarStark)
 * feature #60986 [Intl] Remove deprecated `EmojiTransliterator` (mttsch)
 * feature #60990 [Notifier] Remove deprecated `TransportFactoryTestCase` (mttsch)
 * feature #61012 [SecurityBundle] remove the deprecated `security.authentication.hide_user_not_found` parameter (xabbuh)
 * feature #60987 [Translation] Remove deprecated `ProviderFactoryTestCase` (mttsch)
 * feature #60993 [Cache] Remove deprecated `CouchbaseBucketAdapter` (mttsch)
 * feature #60929 [SecurityBundle] Remove deprecated OIDC token handler options `algorithm` and `key` (OskarStark)
 * feature #60969 [FrameworkBundle] Make `Translator` class `final` (OskarStark)
 * feature #60966 [FrameworkBundle] Make `Router` class `final` (OskarStark)
 * feature #60960 [Form] Make `ResizeFormListener::postSetData()` method `final` (OskarStark)
 * feature #60959 [Command] Make `#[AsCommand]` attribute class `final` (OskarStark)
 * feature #60924 [Serializer] Remove deprecated `escape_char` functionality from `CsvEncoder` (OskarStark)
 * feature #60928 [SecurityBundle] Remove deprecated `hide_user_not_found` option (OskarStark)
 * feature #60930 [HttpFoundation] Remove deprecated session options from `NativeSessionStorage` (OskarStark)
 * feature #60925 [Translation] Remove deprecated `escape` parameter from `CsvFileLoader` (OskarStark)
 * feature #60480 [VarDumper] Add support for adding more default casters to `AbstractCloner::addDefaultCasters()` (lyrixx)
 * feature #60922 [Form] Change `UrlType` default protocol (OskarStark)
 * feature #60895 [BrowserKit] Add `isFirstPage()` and `isLastPage()` methods to History (santysisi)
 * feature #60857 [FrameworkBundle] Add `ControllerHelper`; the helpers from `AbstractController` as a standalone service (nicolas-grekas)
 * feature #60898 [Uid] Add microsecond precision to UUIDv7 and optimize on x64 (nicolas-grekas)
 * feature #60910 [DependencyInjection] Add argument `$target` to `ContainerBuilder::registerAliasForArgument()` (nicolas-grekas)
 * feature #60597 [DependencyInjection][FrameworkBundle] Use php-serialize to dump the container for debug/lint commands (nicolas-grekas)
 * feature #60874 [FrameworkBundle] Allow using their name without added suffix when using #[Target] for custom services (Valmonzo)
 * feature #60879 [Security] Remove callable firewall listeners support (MatTheCat)
 * feature #60878 [AssetMapper] Remove `ImportMapConfigReader::splitPackageNameAndFilePath()` (mttsch)
 * feature #60877 [Serializer] Remove deprecated compiled class meta data classes (mttsch)
 * feature #60614 [Security] Deprecate callable firewall listeners (MatTheCat)
 * feature #60876 [HttpFoundation] Deprecate using `Request::sendHeaders()` after headers have already been sent (nicolas-grekas)
 * feature #60823 [Console] Add support for Invokable Commands in `CommandTester` (ruudk)
 * feature #60870 [Serializer] Remove `AdvancedNameConverterInterface` (mttsch)
 * feature #60862 [Routing] Remove deprecated AttributeClassLoader property and setter (mttsch)
 * feature #60863 [Routing] Throw exception for non-array _query parameter (mttsch)
 * feature #60865 [Serializer] Remove deprecated withDefaultContructorArguments method (mttsch)
 * feature #60866 [Mailer] Remove deprecated TransportFactoryTestCase (mttsch)
 * feature #60852 [Notifier] remove the Sms77 Notifier bridge (xabbuh)
 * feature #60844 [DependencyInjection] Remove deprecated `ContainerBuilder::getAutoconfiguredAttributes()` (GromNaN)
 * feature #60851 [Yaml] raise a parse error for duplicate keys (xabbuh)
 * feature #60853 [HttpKernel] remove AddAnnotatedClassesToCachePass and related methods (xabbuh)
 * feature #60503 [Runtime] Automatically use FrankenPHP runner when its worker mode is detected (alexandre-daubois)
 * feature #60845 [DependencyInjection] Remove `#[TaggedIterator]` and `#[TaggedLocator]` attributes (GromNaN)
 * feature #60788 [FrameworkBundle] Allow to un-verbose all the method in `BrowserKitAssertionsTrait` (VincentLanglet)
 * feature #60819 [DependencyInjection] Allow extending `#[AsAlias]` attribute (ruudk)
 * feature #60742 [Ldap][Security] Remove deprecated `eraseCredentials()` from (User|Token)Interface (chalasr)
 * feature #60740 [Mailer] Add `assertEmailAddressNotContains` (santysisi)
 * feature #60767 [Console] Allow Usages to be specified via #[AsCommand] attribute (weitzman)
 * feature #60776 [Console][FrameworkBundle] Remove deprecated `Application::add()` methods (HypeMC)
 * feature #60586 [Console] Support `BackedEnum` in invokable commands (GromNaN)
 * feature #60371 [SecurityBundle] register alias for argument for password hasher (lyrixx, chalasr)
 * feature #60394 [Console][FrameworkBundle] Simplify using invokable commands when the component is used standalone (HypeMC)
 * feature #60731 [JsonStreamer] Add PHPDoc to generated code (mtarld)
 * feature #60739 [Console] Allow setting aliases & hidden via command name passed to the constructor (HypeMC)
 * feature #60726 [PropertyInfo] Remove PropertyInfo's `Type` (mtarld)
 * feature #60720 [FrameworkBundle] Enable the property-info constructor extractor by default (HypeMC)
 * feature #60716 [VarExporter] Remove `LazyGhostTrait` and `LazyProxyTrait` in favor of native lazy objects (nicolas-grekas)
 * feature #60723 [OptionsResolver] Remove support for nested options definition via `setDefault()`, use `setOptions()` instead (yceruto)
 * feature #60721 [Console] Remove deprecated code (yceruto)
 * feature #60424 [PhpUnitBridge] Add `strtotime()` to `ClockMock` (jprivet-dev)
 * feature #60508 [Routing] Allow query-specific parameters in `UrlGenerator` using `_query` (BenMorel)
 * feature #60712 [HttpClient] Remove support for amphp/http-client < 5 (nicolas-grekas)
 * feature #60704 [HttpClient] Deprecate using amphp/http-client < 5 (nicolas-grekas)
 * feature #60697 Enforce return types on all components (nicolas-grekas)
 * feature #60639 Bump Symfony 8 to PHP >= 8.4 (nicolas-grekas)
 * feature #60253 [Scheduler] Throw error on duplicate schedule provider service registration on the schedule name (adrianrudnik)
 * feature #60315 [Form] Add `input=date_point` to `DateTimeType`, `DateType` and `TimeType` (wkania)
 * feature #60498 [HttpCache] Add a `waiting` trace when finding the cache locked (mpdude)
 * feature #60569 [HttpKernel] Do not superseed private cache-control when no-store is set (alexander-schranz)
 * feature #60209 [Notifier] Allow to set block_id/value for SlackActionsBlock and SlackButtonBlockElement (miloszowi)
 * feature #60544 [JsonStreamer] Remove `nikic/php-parser` dependency (mtarld)
 * feature #60420 [WebLink] Add class to parse Link headers from HTTP responses (GromNaN)

