/**
 * 2d array of related domains (etld+1), all domains owned by the same entity go into
 * an array, this is later transformed for efficient lookups.
 */
let multiDomainFirstPartiesArray = [
  ["1800contacts.com", "800contacts.com"],
  ["2gis.ru", "2gis.ae", "2gis.kg", "2gis.kz", "2gis.com"],
  ["360.cn", "360.com", "360kuai.com", "360safe.com", "qhimg.com", "qhupdate.com"],
  ["37signals.com", "basecamp.com", "basecamphq.com", "highrisehq.com"],
  ["888.com", "888casino.com", "888slots.de", "888sport.com", "safe-iplay.com"],
  ["9gag.com", "9cache.com"],
  [
    "aa.com",
    "aa.com.br",
    "aa.com.do",
    "aa.com.pe",
    "aa.com.ve",
    "aa.co.uk",
    "aadvantage.com",
    "aavacations.com",
    "americanair.com",
    "americanairlines.be",
    "americanairlines.ch",
    "americanairlines.cl",
    "americanairlines.cn",
    "americanairlines.co.cr",
    "american-airlines.co.kr",
    "americanairlines.com",
    "americanairlines.com.au",
    "americanairlines.com.hk",
    "americanairlines.co.uk",
    "americanairlines.de",
    "americanairlines.es",
    "americanairlines.fi",
    "americanairlines.fr",
    "americanairlines.hu",
    "americanairlines.ie",
    "americanairlines.in",
    "americanairlines.it",
    "americanairlines.jp",
    "american-airlines.nl",
    "american.com"
  ],
  ["aenetworks.com", "aetv.com", "history.com", "mylifetime.com", "aetnd.com"],
  ["accountonline.com", "citi.com", "citibank.com", "citicards.com", "citibankonline.com"],
  [
    "action.group",

    "action360.ru",
    "fd.ru",
    "glavbukh.ru",

    "action-media.ru",
  ],
  [ "actonsoftware.com", "actonservice.com"],
  [
    "adidas-group.com",

    "adidas.ae",
    "adidas.at",
    "adidas.be",
    "adidas.ca",
    "adidas.ch",
    "adidas.cl",
    "adidas.cn",
    "adidas.co",
    "adidas.co.id",
    "adidas.co.in",
    "adidas.co.kr",
    "adidas.com",
    "adidas.com.ar",
    "adidas.com.au",
    "adidas.com.br",
    "adidas.com.co",
    "adidas.com.hk",
    "adidas.com.my",
    "adidas.com.om",
    "adidas.com.pe",
    "adidas.com.ph",
    "adidas.com.qa",
    "adidas.com.sa",
    "adidas.com.sg",
    "adidas.com.tr",
    "adidas.com.tw",
    "adidas.com.vn",
    "adidas.co.nz",
    "adidas.co.th",
    "adidas.co.uk",
    "adidas.co.za",
    "adidas.cz",
    "adidas.de",
    "adidas.dk",
    "adidas.es",
    "adidas.fi",
    "adidas.fr",
    "adidas.gr",
    "adidas.hu",
    "adidas.ie",
    "adidas.it",
    "adidas.jp",
    "adidas.mx",
    "adidas.nl",
    "adidas.no",
    "adidas.pe",
    "adidas.pl",
    "adidas.pt",
    "adidas.ru",
    "adidas.se",
    "adidas.sk",
    "adidas.us",
  ],
  [
    "adobe.com",

    "acrobat.com",
    "acrobatusers.com",
    "adobeconnect.com",
    "adobeevents.com",
    "adobeexchange.com",
    "adobefpl.com",
    "adobeidealab.com",
    "adobe.io",
    "adobelanding.com",
    "adobeleanprint.com",
    "adobelogin.com",
    "adobeprerelease.com",
    "adobeprimetime.com",
    "adobesigncdn.com",
    "adobesign.com",
    "adobesignforsalesforce.com",
    "adobe-students.com",
    "adobeyourshotyourstory.com",
    "behance.net",
    "echocdn.com",
    "echosign.com",
    "echosignforsalesforce.com",
    "macromedia.com",
    "mixamo.com",
    "mycreativetype.com",
    "myportfolio.com",
    "photoshop.com",
    "typekit.com",
  ],
  ["adobedc.net", "omtrdc.net"],
  [
    "agora.pl",

    "avanti24.pl",
    "czterykaty.pl",
    "edziecko.pl",
    "gazeta.pl",
    "g.pl",
    "haps.pl",
    "moto.pl",
    "plotek.pl",
    "radiozet.pl",
    "sport.pl",
    "tokfm.pl",
    "tuba.pl",
    "wyborcza.pl",
    "wysokieobcasy.pl",
    "zloteprzeboje.pl",

    "im-g.pl",
  ],
  [
    "airbnb.com",

    "airbnb.ae",
    "airbnb.al",
    "airbnb.am",
    "airbnb.at",
    "airbnb.az",
    "airbnb.ba",
    "airbnb.be",
    "airbnb.ca",
    "airbnb.cat",
    "airbnb.ch",
    "airbnb.cl",
    "airbnb.co.cr",
    "airbnb.co.id",
    "airbnb.co.il",
    "airbnb.co.in",
    "airbnb.co.kr",
    "airbnb.com.ar",
    "airbnb.com.au",
    "airbnb.com.bo",
    "airbnb.com.br",
    "airbnb.com.bz",
    "airbnb.com.co",
    "airbnb.com.ec",
    "airbnb.com.ee",
    "airbnb.com.gt",
    "airbnb.com.hk",
    "airbnb.com.hn",
    "airbnb.com.hr",
    "airbnb.com.kh",
    "airbnb.com.mt",
    "airbnb.com.my",
    "airbnb.com.ni",
    "airbnb.com.pa",
    "airbnb.com.pe",
    "airbnb.com.ph",
    "airbnb.com.py",
    "airbnb.com.ro",
    "airbnb.com.sg",
    "airbnb.com.sv",
    "airbnb.com.tr",
    "airbnb.com.tw",
    "airbnb.com.ua",
    "airbnb.com.vn",
    "airbnb.co.nz",
    "airbnb.co.uk",
    "airbnb.co.ve",
    "airbnb.co.za",
    "airbnb.cz",
    "airbnb.de",
    "airbnb.dk",
    "airbnb.es",
    "airbnb.fi",
    "airbnb.fr",
    "airbnb.gr",
    "airbnb.gy",
    "airbnb.hu",
    "airbnb.ie",
    "airbnb.is",
    "airbnb.it",
    "airbnb.jp",
    "airbnb.la",
    "airbnb.lt",
    "airbnb.lu",
    "airbnb.lv",
    "airbnb.me",
    "airbnb.mx",
    "airbnb.nl",
    "airbnb.no",
    "airbnb.pl",
    "airbnb.pt",
    "airbnb.rs",
    "airbnb.ru",
    "airbnb.se",
    "airbnb.si",

    "muscache.com",
  ],
  [
    "airfranceklm.com",

    "airfrance.cg",
    "airfrance.ci",
    "airfrance.cr",
    "airfrance.co.uk",
    "airfrance.com.au",
    "airfrance.com.cn",
    "airfrance.com.co",
    "airfrance.com.do",
    "airfrance.com.gh",
    "airfrance.com.lb",
    "airfrance.dz",
    "airfrance.es",
    "airfrance.fr",
    "airfrance.hu",
    "airfrance.id",
    "airfrance.ie",
    "airfrance.in",
    "airfrance.it",
    "airfrance.my",
    "airfrance.ng",
    "airfrance.pa",
    "airfrance.tn",
    "airfrance.us",
    "airfrance.vn",

    "klm.ae",
    "klm.at",
    "klm.aw",
    "klm.be",
    "klm.bg",
    "klm.by",
    "klm.bz",
    "klm.ca",
    "klm.ch",
    "klm.cl",
    "klm.co.ao",
    "klm.co.cr",
    "klm.co.id",
    "klm.co.il",
    "klm.co.in",
    "klm.co.jp",
    "klm.co.ke",
    "klm.co.kr",
    "klm.com",
    "klm.com.ar",
    "klm.com.au",
    "klm.com.bh",
    "klm.com.br",
    "klm.com.co",
    "klm.com.cy",
    "klm.com.ec",
    "klm.com.eg",
    "klm.com.gh",
    "klm.com.hk",
    "klm.com.mt",
    "klm.com.mx",
    "klm.com.my",
    "klm.com.na",
    "klm.com.ng",
    "klm.com.pa",
    "klm.com.pe",
    "klm.com.ph",
    "klm.com.py",
    "klm.com.qa",
    "klm.com.tr",
    "klm.com.tw",
    "klm.com.uy",
    "klm.co.nz",
    "klm.co.th",
    "klm.co.tz",
    "klm.co.ug",
    "klm.co.uk",
    "klm.co.za",
    "klm.co.zm",
    "klm.cw",
    "klm.cz",
    "klm.de",
    "klm.dk",
    "klm.do",
    "klm.es",
    "klm.fi",
    "klm.fr",
    "klm.ge",
    "klm.gr",
    "klm.hr",
    "klm.hu",
    "klm.ie",
    "klm.it",
    "klm.kz",
    "klm.lk",
    "klm.lt",
    "klm.lu",
    "klm.lv",
    "klm.mu",
    "klm.mw",
    "klm.nc",
    "klm.nl",
    "klm.no",
    "klm.pl",
    "klm.pt",
    "klm.ro",
    "klm.ru",
    "klm.se",
    "klm.sg",
    "klm.sk",
    "klm.sr",
    "klm.sx",
    "klm.ua",
    "klm.us",

    "static-af.com",
    "static-kl.com",
  ],
  ["ais.th", "ais.co.th"],
  ["alchemer.com", "surveygizmo.com"],
  [
    "alibaba.com",

    "1688.com",
    "95095.com",
    "9game.cn",
    "aliapp.org",
    "alibabacloud.co.in",
    "alibabacloud.com",
    "alibabacloud.com.au",
    "alibabacloud.com.hk",
    "alibabacloud.com.my",
    "alibabacloud.com.sg",
    "alibabacloud.com.tw",
    "alibabacorp.com",
    "alibabagroup.com",
    "alibaba-inc.com",
    "alicdn.com",
    "alicdn.net",
    "alicloud.com",
    "alidns.com",
    "aliexpress.com",
    "aliexpress.ru",
    "aliexpress.us",
    "alifanyi.com",
    "aligames.com",
    "alihealth.cn",
    "alihive.com",
    "aliimg.com",
    "alimama.com",
    "alimei.com",
    "aliplus.com",
    "alitrip.com",
    "alitrip.hk",
    "aliyun.com",
    "aliyuncs.com",
    "aliyundrive.com",
    "aliyun-iot-share.com",
    "allylikes.com",
    "amap.com",
    "cainiao.com",
    "cainiao.com.cn",
    "cibntv.net",
    "cnzz.com",
    "dayu.com",
    "dingtalkapps.com",
    "dingtalk.com",
    "dongting.com",
    "ele.me",
    "elenet.me",
    "etao.com",
    "feizhu.cn",
    "feizhu.com",
    "fliggy.com",
    "fliggy.hk",
    "freshippo.com",
    "i52hz.com",
    "jiaoyimao.com",
    "jingguan.ai",
    "jiyoujia.com",
    "juhuasuan.com",
    "kumiao.com",
    "laifeng.com",
    "liangxinyao.com",
    "mappcloud.com",
    "mei.com",
    "mmstat.com",
    "mobmore.com",
    "paike.com",
    "phpwind.com",
    "phpwind.net",
    "puata.info",
    "soku.com",
    "sparenode.com",
    "supet.com",
    "tanx.com",
    "taobao.com",
    "taopiaopiao.com",
    "tbcdn.cn",
    "tburl.in",
    "teambitionapis.com",
    "teambition.com",
    "teambition.net",
    "tianchi-global.com",
    "tmail.com",
    "tmall.com",
    "tmall.hk",
    "tmall.ru",
    "ttpod.com",
    "tudou.com",
    "uc.cn",
    "ucweb.com",
    "um0.cn",
    "umengcloud.com",
    "umeng.co",
    "umeng.com",
    "umindex.com",
    "umsns.com",
    "umtrack.com",
    "wasu.tv",
    "whalecloud.com",
    "www.net.cn",
    "xiami.com",
    "ykimg.com",
    "youku.com",
    "youkutv.com",
    "yousuode.cn",

    "aliexpress-media.com",

    "daraz.com",
    "daraz.com.bd",
    "daraz.com.np",
    "daraz.lk",
    "daraz.pk",
    "shop.com.mm",


    "alipay.com",

    "aliloan.com",
    "alipay-cloud.com",
    "alipay.cn",
    "alipay-eco.com",
    "alipay.hk",
    "alipayobjects.com",
    "alipayplus.com",
    "ant-biz.com",
    "ant-financial.com",
    "antfin.com",
    "antfin-inc.com",
    "antfortune.com",
    "antgroup.com",
    "ant-open.com",
    "antsdaq.com",
    "ebuckler.com",
    "fund123.cn",
    "huijucai.com",
    "koubei.com",
    "mayiyunbao.com",
    "mybank.cn",
    "sinopayment.com.cn",
    "ssdata.com",
    "xin.xin",
    "yidun.com",
    "zamcs.com",
    "zhisheng.com",
    "zmxy.com.cn",

    "lazada.com",

    "lazada.co.id",
    "lazada.com.my",
    "lazada.com.ph",
    "lazada.co.th",
    "lazada.sg",
    "lazada.vn",

    "lazcdn.com",
  ],
  ["allstate.com", "myallstate.com"],
  ["altra.org", "altraonline.org"],
  [
    "amazon.com",

    "amazon.ae",
    "amazon.ca",
    "amazon.cn",
    "amazon.co.jp",
    "amazon.com.au",
    "amazon.com.br",
    "amazon.com.mx",
    "amazon.com.sg",
    "amazon.com.tr",
    "amazon.co.uk",
    "amazon.co.za",
    "amazon.de",
    "amazon.eg",
    "amazon.es",
    "amazon.fr",
    "amazon.in",
    "amazon.it",
    "amazon.nl",
    "amazon.pl",
    "amazon.sa",
    "amazon.se",
    "amazon.sg",

    "audible.com",
    "audible.co.jp",
    "audible.com.au",
    "audible.co.uk",
    "audible.de",
    "audible.fr",
    "audible.in",
    "audible.it",

    "6pm.com",
    "abebooks.com",
    "abebooks.co.uk",
    "acx.com",
    "amazonaws.cn",
    "boxofficemojo.com",
    "amazoninspire.com",
    "amazon.jobs",
    "amazon.work",
    "aws.training",
    "brilliancepublishing.com",
    "comixology.com",
    "createspace.com",
    "dpreview.com",
    "eastdane.com",
    "fabric.com",
    "goodreads.com",
    "imdb.com",
    "pillpack.com",
    "primevideo.com",
    "shopbop.com",
    "skillbuilder.aws",
    "wholefoodsmarket.com",
    "woot.com",
    "zappos.com",

    "twitch.tv",
    "ext-twitch.tv",
    "jtvnw.net",
    "ttvnw.net",

    "a2z.com",
    "amazon.dev",
    "amazonpay.com",
    "aws.dev",
    "media-amazon.com",
    "media-imdb.com",
    "ssl-images-amazon.com",
  ],
  ["ameba.jp", "ameblo.jp"],
  [
    "americanexpress.com",

    "americanexpress.ca",
    "americanexpress.ch",
    "americanexpress.com.au",
    "americanexpress.co.uk",
    "americanexpress.no",

    "membershiprewards.ca",
    "membershiprewards.com.ar",
    "membershiprewards.com.au",
    "membershiprewards.com.sg",
    "membershiprewards.co.uk",
    "membershiprewards.de",

    "aetclocator.com",
    "americanexpressfhr.com",
    "amexnetwork.com",
    "amextravel.com",
    "amextravelresources.com",
    "thecenturionlounge.com",
    "yourcarrentalclaim.com",

    "aexp-static.com",
  ],
  [
    "ancestry.com",

    "ancestry.ca",
    "ancestry.com.au",
    "ancestry.co.uk",
    "ancestry.de",
    "ancestry.fr",
    "ancestry.ie",
    "ancestry.it",
    "ancestry.mx",
    "ancestry.nl",
    "ancestry.no",
    "ancestry.pl",
    "ancestry.se",

    "ancestrylibrary.com",
    "archives.com",
    "findagrave.com",
    "fold3.com",
    "newspapers.com",
    "progenealogists.com",
    "rootsweb.com",

    "ancestrylibrary.ca",

    "mfcreative.com",
    "ancestrycdn.com",
  ],
  ["androidcentral.com", "mobilenations.com"],
  [
    "apa.at",
    "apa-it.at",
    "apa-defacto.at",
    "ots.at",

    "orf.at",
    "oe24.at",
    "wienerzeitung.at",
    "kleinezeitung.at",
    "vn.at",
    "kurier.at",
    "schautv.at",
    "nachrichten.at",
    "derstandard.at",
    "sn.at",
    "volksblatt.at",
    "neue.at",

    "tt.com",
    "diepresse.com",
  ],
  ["ap.org", "apnews.com"],
  ["apple.com", "apple.news", "icloud.com", "icloud.com.cn", "webkit.org",
    "aaplimg.com", "cdn-apple.com"],
  ["applefcu.org", "applefcuonline.org"],
  ["archive.org", "openlibrary.org"],
  [
    "thearenagroup.net",

    "athlonsports.com",
    "dengarden.com",
    "exemplore.com",
    "fashionista.com",
    "howcast.com",
    "hubpages.com",
    "indiancountrytoday.com",
    "lamag.com",
    "mensjournal.com",
    "nationaldaycalendar.com",
    "pairedlife.com",
    "parade.com",
    "pethelpful.com",
    "psmag.com",
    "si.com",
    "thespun.com",
    "thestreet.com",
    "wanderwisdom.com",

    "maven.io",
    "mavencoalition.io",
  ],
  ["asos.com", "asosservices.com"],
  [
    "atlassian.com",

    "atlassian.io",
    "atlassian.net",
    "bitbucket.org",
    "customercase.com",
    "enso.me",
    "hipchat.com",
    "jira.com",
    "loom.com",
    "sourcetreeapp.com",
    "statuspage.io",
    "stride.com",
    "trello.com",

    "atl-paas.net",
  ],
  [
    "atresmedia.com",

    "atresplayer.com",
    "europafm.com",
    "lasexta.com",
    "melodia-fm.com",
    "ondacero.es",

    "antena3.com"
  ],
  [
    "att.com",

    "att.tv",
    "atttvnow.com",
    "attwatchtv.com",
    "directv.com",
    "directvnow.com",
  ],
  ["audi.com", "audi.de", "audi.nl", "audi.com.mx", "audiusa.com", "audi-boerse.de"],
  [
    "autodesk.com",

    "autodesk.io",
    "autodesk.net",
    "circuits.io",
    "tinkercad.com",

    "autodesk.ae",
    "autodesk.be",
    "autodesk.ca",
    "autodesk.ch",
    "autodesk.co.jp",
    "autodesk.co.kr",
    "autodesk.com.au",
    "autodesk.com.br",
    "autodesk.com.cn",
    "autodesk.com.hk",
    "autodesk.com.my",
    "autodesk.com.sg",
    "autodesk.com.tr",
    "autodesk.com.tw",
    "autodesk.co.nz",
    "autodesk.co.uk",
    "autodesk.co.za",
    "autodesk.cz",
    "autodesk.de",
    "autodesk.dk",
    "autodesk.es",
    "autodesk.eu",
    "autodesk.fi",
    "autodesk.fr",
    "autodesk.hu",
    "autodesk.in",
    "autodesk.it",
    "autodesk.mx",
    "autodesk.nl",
    "autodesk.no",
    "autodesk.pl",
    "autodesk.pt",
    "autodesk.ru",
    "autodesk.se",
  ],
  ["automattic.com", "wordpress.com", "wordpress.org", "wp.com"],
  ["avito.ru", "avito.st"],
  ["avon.com", "youravon.com"],
  [
    "axelspringer.com",

    "bild.de",
    "welt.de",

    "axelspringer.de"
  ],
  ["axept.io", "axeptio.eu"],
  ["bahn.de", "img-bahn.de", "static-bahn.de"],
  [
    "baidu.com",

    "hao123.com",
    "paddlepaddle.org.cn",
    "tieba.com",
    "wejianzhan.com",

    "iq.com",
    "iqiyi.com",

    "baidustatic.com",
    "bcebos.com",
    "bdimg.com",
    "bdstatic.com",
  ],
  ["bahnhof.se", "bahnhof.cloud", "bahnhof.net"],
  ["balsamiq.com", "balsamiq.cloud"],
  ["bancomer.com", "bancomer.com.mx", "bbvanet.com.mx"],
  [
    "bankofamerica.com",

    "bofa.com",
    "mbna.com",
    "usecfo.com",

    "ml.com",
    "mymerrill.com",
    "merrilledge.com",

    "bac-assets.com",
  ],
  ["bank-yahav.co.il", "bankhapoalim.co.il"],
  [
    "bauermedia.co.uk",

    "carmagazine.co.uk",
    "motorcyclenews.com",
    "parkers.co.uk",

    "bauersecure.com",
  ],
  ["bbc.co.uk", "bbc.com", "bbci.co.uk"],
  ["belkin.com", "seedonk.com"],
  [
    "bellmedia.ca",

    "9c9media.ca",
    "9c9media.com",
    "animalplanet.ca",
    "bardown.com",
    "bnnbloomberg.ca",
    "bnn.ca",
    "bravo.ca",
    "canald.com",
    "canalvie.com",
    "cinepop.ca",
    "cmdy.ca",
    "cookieless.ca",
    "cp24.com",
    "crave.ca",
    "crave.com",
    "cravetv.ca",
    "ctv.ca",
    "ctvdigital.net",
    "ctvnews.ca",
    "discovery.ca",
    "discoveryvelocity.ca",
    "envedette.ca",
    "etalk.ca",
    "fraichementpresse.ca",
    "investigationdiscovery.ca",
    "investigationtele.com",
    "lookdujour.ca",
    "marilyn.ca",
    "mtv.ca",
    "much.ca",
    "much.com",
    "muchmusic.com",
    "muramur.ca",
    "rds.ca",
    "sciencechannel.ca",
    "sego-cdn.com",
    "space.ca",
    "superecran.com",
    "superecrango.com",
    "sympatico.ca",
    "thecomedynetwork.ca",
    "theloop.ca",
    "thesocial.ca",
    "tmngo.ca",
    "tsn.ca",
    "voyagevoyage.ca",
    "vrak.tv",
    "ztele.com",
  ],
  ["betfair.com", "betfair.com.au", "betfair.es", "betfair.it", "betfair.se", "cdnbf.net"],
  ["betterhelp.com", "betterhelporg.com", "mytherapist.com", "regain.us", "teencounseling.com"],
  ["bhphotovideo.com", "bandh.com", "bhphoto.com", "bnh.com"],
  ["bilibili.com", "acgvideo.com", "biliapi.net", "biliapi.com", "bilibilicomics.com", "biligame.com", "bilivideo.com", "hdslb.com"],
  ["binance.com", "binance.cloud", "binance.vision", "bnbstatic.com"],
  ["bitrix24.com", "bitrix24.ru", "1c-bitrix.ru", "bitrix.info", "bitrix24.net"],
  [
    "blizzard.com",

    "battle.net",
    "heroesofthestorm.com",
    "starcraft.com",
    "starcraft2.com",
    "worldofwarcraft.com",
  ],
  ["bloomberg.com", "bbthat.com", "bwbx.io", "bloomberg.co.jp"],
  ["bmw.com", "bmw.de", "bmwgroup.com", "bmwusa.com", "mini.de", "bmwfs.com"],
  ["boardgamearena.com", "boardgamearena.net"],
  ["booking.com", "rentalcars.com", "bstatic.com"],
  ["bostonglobe.com", "boston.com", "statnews.com", "bostonglobemedia.com"],
  ["box.com", "boxcdn.net"],
  [
    "bytedance.com",

    "douyin.com",
    "ixigua.com",
    "lifeattiktok.com",
    "tiktok.com",
    "tiktokglobalshop.com",
    "tiktokshop.com",
    "toutiao.com",

    "byteoversea.com",
    "bytetos.com",
    "douyinstatic.com",
    "ibytedtos.com",
    "snssdk.com",
    "tiktokcdn.com",
    "tiktokcdn-us.com",
    "tiktokv.com",
    "tiktokv.us",
    "tiktokw.us",
    "ttwstatic.com",
    "zijieapi.com",
  ],
  [
    "bustle.company",

    "bustle.com",
    "elitedaily.com",
    "inputmag.com",
    "inverse.com",
    "mic.com",
    "nylon.com",
    "romper.com",
    "thezoereport.com",
  ],
  ["calvinklein.us", "calvinklein.co.uk", "calvinklein.de", "calvinklein.com"],
  [
    "canada.ca",

    "ceaa-acee.gc.ca",
    "collectionscanada.gc.ca",
    "cra-arc.gc.ca",
    "dfo-mpo.gc.ca",
    "ec.gc.ca",
    "esdc.gc.ca",
    "fcac-acfc.gc.ca",
    "hrdc-drhc.gc.ca",
    "ic.gc.ca",
    "jobbank.gc.ca",
    "labour.gc.ca",
    "nrcan.gc.ca",
    "sac-isc.gc.ca",
    "servicecanada.gc.ca",
    "services.gc.ca",
    "statcan.gc.ca",
    "tbs-sct.gc.ca",
    "tc.gc.ca",
    "tpsgc-pwgsc.gc.ca",
    "weather.gc.ca",

    "archives.ca",
    "canlearn.ca",
    "gcsurplus.ca",
    "letstalktransportation.ca",
  ],
  ["canadiantire.ca", "marks.com", "sportchek.com", "sportchek.ca", "triangle.com"],
  [
    "canalplus.com",

    "canal.fr",
    "canalplay.com",
    "canalplus-bo.net",
    "canal-plus.com",
    "canalplus.fr",
    "canalplusinternational.com",
    "canal-plus.net",
    "canal-plus.pro",
    "canalplus.pro",
    "canalpro.fr",
    "clique.tv",
    "cstar.fr",
    "mycanal.fr",
  ],
  ["capitalone.com", "capitalone360.com"],
  ["carousell.com", "carousell.com.hk", "carousell.com.my", "carousell.sg", "karousell.com"],
  ["casasbahia.com.br", "extra.com.br", "pontofrio.com.br", "casasbahia-imagens.com.br"],
  ["cb2.com", "crateandbarrel.com"],
  [
    "ccmbenchmark.com",

    "linternaute.com",
    "journaldesfemmes.fr",
    "journaldunet.com",
    "commentcamarche.net",

    "ccmbg.com",
  ],
  ["cctv.com", "cctv.cn", "cctvpic.com"],
  ["century21.com", "21online.com"],
  ["chart.io", "chartio.com"],
  ["chaturbate.com", "highwebmedia.com", "mmcdn.com"],
  ["chegg.com", "citationmachine.net", "easybib.com", "internships.com",
    "mathway.com", "cheggcdn.com"],
  [
    "cisco.com",

    "ciscolive.com",
    "duo.com",
    "netacad.com",
    "opendns.com",
    "umbrella.com",
    "webex.com",

    "static-cisco.com",
  ],
  ["citynews.it", "ilpost.it", "milanotoday.it", "palermotoday.it", "romatoday.it", "today.it", "stgy.ovh"],
  [
    "cloud.com",

    "cedexis.com",
    "citrix.com",
    "citrixonline.com",
    "ibi.com",
    "jaspersoft.com",
    "sharefile.com",
    "tibco.com",
  ],
  ["cms.gov", "medicare.gov", "mymedicare.gov"],
  ["coach.com", "coachoutlet.com"],
  ["codepen.io", "cdpn.io"],
  ["concur.com", "concursolutions.com"],
  [
    "condenast.com",

    "allure.com",
    "architecturaldigest.com",
    "arstechnica.com",
    "bonappetit.com",
    "cntraveler.com",
    "epicurious.com",
    "glamour.com",
    "glamourmagazine.co.uk",
    "gq.com",
    "gq-magazine.co.uk",
    "lennyletter.com",
    "newyorker.com",
    "pitchfork.com",
    "self.com",
    "teenvogue.com",
    "them.us",
    "vanityfair.com",
    "vogue.com",
    "vogue.fr",
    "vogue.in",
    "vogue.it",
    "wired.com",
    "wired.co.uk",
    "wired.it",

    "condenastdigital.com",
  ],
  [
    "cornell.edu",

    "birdsna.org",
    "birdsoftheworld.com",
    "birdsoftheworld.org",
    "ebird.org",
    "hbw.com",
    "macaulaylibrary.org",
  ],
  ["corriere.it", "corriereobjects.it"],
  ["costco.com", "costco.ca"],
  ["cox.com", "cox.net"],
  ["cricketwireless.com", "aiowireless.com"],
  ["daangn.com", "karrotmarket.com"],
  ["danskebank.se", "danskebank.com"],
  ["datadoghq.eu", "datadoghq.com"],
  ["dcu.org", "dcu-online.org"],
  [
    "deliveroo.com",

    "deliveroo.ae",
    "deliveroo.be",
    "deliveroo.com.au",
    "deliveroo.com.kw",
    "deliveroo.com.sg",
    "deliveroo.co.uk",
    "deliveroo.de",
    "deliveroo.es",
    "deliveroo.fr",
    "deliveroo.ie",
    "deliveroo.it",
    "deliveroo.nl",
  ],
  ["dickssportinggoods.com", "goinggoinggone.com", "golfgalaxy.com", "publiclands.com", "vrst.com"],
  ["dictionary.com", "thesaurus.com", "sfdict.com"],
  [
    "digikey.com",

    "digikey.ae",
    "digikey.am",
    "digikey.at",
    "digikey.ba",
    "digikey.be",
    "digikey.bg",
    "digikey.bo",
    "digikey.by",
    "digikey.ca",
    "digikey.ch",
    "digikey.cl",
    "digikey.cn",
    "digikey.co.id",
    "digikey.co.il",
    "digikey.com.ar",
    "digikey.com.au",
    "digikey.com.br",
    "digikey.com.cn",
    "digikey.com.co",
    "digikey.com.cy",
    "digikey.com.eg",
    "digikey.com.gt",
    "digikey.com.hr",
    "digikey.com.jm",
    "digikey.com.lb",
    "digikey.com.mk",
    "digikey.com.mx",
    "digikey.com.pa",
    "digikey.com.tr",
    "digikey.com.ua",
    "digikey.com.uy",
    "digikey.com.ve",
    "digikey.co.nz",
    "digikey.co.th",
    "digikey.co.uk",
    "digikey.co.za",
    "digikey.cr",
    "digikey.cz",
    "digikey.de",
    "digikey.dk",
    "digikey.do",
    "digikey.ec",
    "digikey.ee",
    "digikey.es",
    "digikey.fi",
    "digikey.fr",
    "digikey.gr",
    "digikey.hk",
    "digikey.hu",
    "digikey.ie",
    "digikey.in",
    "digikey.is",
    "digikey.it",
    "digikey.jp",
    "digikey.kr",
    "digikey.lk",
    "digikey.lt",
    "digikey.lu",
    "digikey.lv",
    "digikey.ma",
    "digikey.md",
    "digikey.my",
    "digikey.nl",
    "digikey.no",
    "digikey.pe",
    "digikey.ph",
    "digikey.pk",
    "digikey.pl",
    "digikey.pr",
    "digikey.pt",
    "digikey.ro",
    "digikey.rs",
    "digikey.ru",
    "digikey.se",
    "digikey.sg",
    "digikey.si",
    "digikey.sk",
    "digikey.tn",
    "digikey.tw",
    "digikey.vn",
  ],
  [
    "digitec.ch",

    "galaxus.ch",
    "galaxus.de",
    "galaxus.fr",

    "digitecgalaxus.ch",
  ],
  [
    "directferries.com",

    "directferries.at",
    "directferries.be",
    "directferries.ca",
    "directferries.ch",
    "directferries.cn",
    "directferries.co.id",
    "directferries.co.kr",
    "directferries.com.au",
    "directferries.com.tr",
    "directferries.com.ua",
    "directferries.co.nz",
    "directferries.co.uk",
    "directferries.cz",
    "directferries.de",
    "directferries.dk",
    "directferries.es",
    "directferries.fi",
    "directferries.fr",
    "directferries.gr",
    "directferries.ie",
    "directferries.it",
    "directferries.jp",
    "directferries.kr",
    "directferries.ma",
    "directferries.nl",
    "directferries.no",
    "directferries.nz",
    "directferries.pl",
    "directferries.pt",
    "directferries.ro",
    "directferries.ru",
    "directferries.se",
    "directferries.sk",
    "directferries.xyz",
  ],
  ["discountbank.co.il", "telebank.co.il"],
  ["discord.com", "discordapp.com", "discordapp.net"],
  ["discover.com", "discovercard.com"],
  ["disqus.com", "disquscdn.com"],
  [
    "dmgmedia.co.uk",

    "dailymail.co.uk",
    "inews.co.uk",
    "mailonsunday.co.uk",
    "metro.co.uk",
    "newzit.com",
    "thisismoney.co.uk",

    "anm.co.uk",
    "dmgmediaprivacy.co.uk",
  ],
  ["dmm.com", "dmm.co.jp"],
  ["doctolib.fr", "doctolib.de", "doctolib.it", "doctolib.com"],
  [
    "dpgmediagroup.com",

    "persgroep.net",
    "persgroep.cloud",

    "7sur7.be",
    "ad.nl",
    "bd.nl",
    "beursrally.be",
    "beurswijzer.com",
    "bndestem.nl",
    "demorgen.be",
    "destentor.nl",
    "dpgmedia.be",
    "dpgmedia.nl",
    "ed.nl",
    "gelderlander.nl",
    "hardware.info",
    "hln.be",
    "humo.be",
    "independer.nl",
    "parool.nl",
    "persgroepinternational.be",
    "persgroepinternational.com",
    "persgroep.nl",
    "pzc.nl",
    "tijd.be",
    "tijdschrift.nl",
    "topics.be",
    "topics.nl",
    "trouw.nl",
    "tubantia.nl",
    "volkskrant.nl",
    "vtm.be",

    "dpgmedia.net",
    "dpgmediagroup.net",
    "mychannels.world",

    "autoweek.nl",
    "donaldduck.nl",
    "fashionchick.nl",
    "kieskeurig.nl",
    "kijk.nl",
    "libelle.nl",
    "lindanieuws.nl",
    "linda.nl",
    "magazine.nl",
    "nu.nl",
    "oudersvannu.nl",
    "sbs6.nl",
    "schoolbank.nl",
    "sportnieuws.nl",
    "startpagina.nl",
    "tweakers.net",
    "veronicatv.nl",
    "vtwonen.nl",
    "wtf.nl",
    "zie.nl",

    "313.nl",
    "sanomaservices.nl",
    "snmmd.nl",
  ],
  ["dropbox.com", "dropboxstatic.com", "dropboxusercontent.com", "getdropbox.com"],
  ["d.rip", "kickstarter.com"],
  ["dsmgrup.com", "trendyol.com", "trendyol-milla.com", "dsmcdn.com"],
  ["duba.com", "91duba.com", "iduba.com", "newduba.cn"],
  ["dunamsz.hu", "hirado.hu", "m4sport.hu", "mediaklikk.hu", "mtv.hu"],
  [
    "dyson.com",

    "dyson.ae",
    "dyson.at",
    "dyson.be",
    "dysoncanada.ca",
    "dyson.ch",
    "dyson.cn",
    "dyson.co.il",
    "dyson.co.jp",
    "dyson.co.kr",
    "dyson.com.au",
    "dyson.com.ee",
    "dyson.com.kh",
    "dyson.com.ro",
    "dyson.com.sg",
    "dyson.com.tr",
    "dyson.co.nz",
    "dyson.co.th",
    "dyson.co.uk",
    "dyson.cz",
    "dyson.de",
    "dyson.dk",
    "dyson.ee",
    "dyson.es",
    "dyson.fr",
    "dyson.hk",
    "dyson.hu",
    "dyson.ie",
    "dyson.in",
    "dyson.it",
    "dyson.lt",
    "dyson.ma",
    "dyson.my",
    "dyson.nl",
    "dyson.no",
    "dyson.ph",
    "dyson.pl",
    "dyson.se",
    "dyson.tw",
    "dyson.vn",

    "dysonrecall.com",
  ],
  [
    "ea.com",

    "bioware.com",
    "masseffect.com",
    "origin.com",
    "play4free.com",
    "tiberiumalliance.com",
  ],
  [
    "ebay.com",
    "ebayinc.com",

    "ebay.at",
    "ebay.be",
    "ebay.ca",
    "ebay.ch",
    "ebay.com.au",
    "ebay.com.hk",
    "ebay.com.my",
    "ebay.com.sg",
    "ebay.co.uk",
    "ebay.de",
    "ebay.es",
    "ebay.fr",
    "ebay.ie",
    "ebay.in",
    "ebay.it",
    "ebay.nl",
    "ebay.ph",
    "ebay.pl",
    "vivanuncios.com.mx",

    "ebaydesc.com",
    "ebayimg.com",
    "ebayrtm.com",
    "ebaystatic.com",
    "ebay-us.com",
  ],
  ["elcorteingles.es", "elcorteingles.pt", "primeriti.es", "grupoelcorteingles.es"],
  ["ename.com", "ename.cn", "ename.net"],
  [
    "enterprise.com",

    "alamo.ca",
    "alamo.com",

    "autoshare.com",
    "autoshare.biz",
    "autoshare.ca",
    "autoshare.net",
    "autoshare.org",

    "cars.info",
    "carsharing.ca",
    "carsharingtoronto.com",
    "citer.fr",

    "ehi.com",
    "ehiaws.com",

    "enterprise.ca",
    "enterprise.ch",
    "enterprise.com.jm",
    "enterprise.co.uk",
    "enterprise.de",
    "enterprise.dk",
    "enterprise.ec",
    "enterprise.es",
    "enterprise.fr",
    "enterprise.gr",
    "enterprise.hr",
    "enterprise.hu",
    "enterprise.ie",
    "enterprise.lv",
    "enterprise.nl",
    "enterprise.no",
    "enterprise.pt",
    "enterprise.se",

    "enterprisecarclub.co.uk",
    "enterprisecarclub.ie",

    "enterprisecarshare.ca",
    "enterprisecarshare.com",
    "enterprisecarshare.co.uk",

    "enterpriserideshare.com",

    "enterpriserentacar.at",
    "enterpriserentacar.be",
    "enterpriserentacar.bg",
    "enterpriserentacar.ca",
    "enterpriserentacar.com.au",
    "enterpriserentacar.co.nz",
    "enterpriserentacar.cz",
    "enterpriserentacar.is",
    "enterpriserentacar.it",
    "enterpriserentacar.pl",
    "enterpriserentacar.se",

    "nationalcar.ca",
    "nationalcar.com",
    "nationalcar.co.uk",
    "nationalcar.de",
    "nationalcar.es",
    "nationalcar.fr",
    "nationalcar.ie",
    "nationalcar.it",
    "nationalcar.mobi",

    "onewaygo.de",

    "alamo-np.ca",
    "alamo-np.com",
    "alamo-np.co.uk",
    "alamo-np.de",
    "alamo-np.es",
    "alamo-np.fr",
    "alamo-np.ie",
  ],
  [
    "envato.com",

    "3docean.net",
    "audiojungle.net",
    "codecanyon.net",
    "envato.market",
    "graphicriver.net",
    "photodune.net",
    "placeit.net",
    "themeforest.net",
    "tutsplus.com",
    "videohive.net",

    "envato-static.com",
  ],
  [
    "epicgames.com",

    "3lateral.com",
    "artstation.com",
    "fallguys.com",
    "fortnite.com",
    "unrealengine.com",

    "bandcamp.com",
    "bcbits.com",
  ],
  ["etsy.com", "etsystatic.com"],
  [
    "eventbrite.com",

    "eventbrite.at",
    "eventbrite.be",
    "eventbrite.ca",
    "eventbrite.ch",
    "eventbrite.cl",
    "eventbrite.co",
    "eventbrite.com.ar",
    "eventbrite.com.au",
    "eventbrite.com.br",
    "eventbrite.com.mx",
    "eventbrite.com.ng",
    "eventbrite.com.pe",
    "eventbrite.co.nz",
    "eventbrite.co.uk",
    "eventbrite.co.za",
    "eventbrite.de",
    "eventbrite.dk",
    "eventbrite.es",
    "eventbrite.fi",
    "eventbrite.fr",
    "eventbrite.hk",
    "eventbrite.ie",
    "eventbrite.in",
    "eventbrite.it",
    "eventbrite.my",
    "eventbrite.nl",
    "eventbrite.ph",
    "eventbrite.pt",
    "eventbrite.se",
    "eventbrite.sg",

    "evbstatic.com",
    "evbuc.com",
    "eventbriteapi.com",
  ],
  [
    "eventim.de",

    "eventim.bg",
    "eventim.com.br",
    "eventim.hr",
    "eventim.hu",
    "eventim.ro",
    "eventim.si",

    "ticketone.it",

    "eventim.com",
  ],
  [
    "expedia.com",

    "carrentals.com",
    "cheaptickets.com",
    "ebookers.com",
    "hoteis.com",
    "hoteles.com",
    "hotels.com",
    "hotwire.com",
    "mrjet.se",
    "orbitz.com",
    "travelocity.com",
    "travelocity.ca",
    "wotif.com",

    "expedia-aarp.com",
    "expedia-barclays.co.uk",
    "expedia-cn.com",
    "expedia.at",
    "expedia.be",
    "expedia.ca",
    "expedia.ch",
    "expedia.cn",
    "expedia.co.id",
    "expedia.co.in",
    "expedia.co.jp",
    "expedia.co.kr",
    "expedia.co.nz",
    "expedia.co.th",
    "expedia.co.uk",
    "expedia.com.ar",
    "expedia.com.au",
    "expedia.com.br",
    "expedia.com.hk",
    "expedia.com.my",
    "expedia.com.ph",
    "expedia.com.sg",
    "expedia.com.tw",
    "expedia.com.vn",
    "expedia.de",
    "expedia.dk",
    "expedia.es",
    "expedia.fi",
    "expedia.fr",
    "expedia.ie",
    "expedia.it",
    "expedia.mx",
    "expedia.nl",
    "expedia.no",
    "expedia.ru",
    "expedia.se",
    "expediacorporate.eu",

    "expedia.net",

    "travel-assets.com",
    "trvl-media.com",

    "lastminute.com.au",
    "lastminute.co.nz",
    "wotif.com.au",
    "wotif.co.nz",

    "cdn-hotels.com",
    "hotels.cn",

    "hotwirestatic.com",

    "ebookers.at",
    "ebookers.be",
    "ebookers.ch",
    "ebookers.co.uk",
    "ebookers.de",
    "ebookers.fi",
    "ebookers.fr",
    "ebookers.ie",
    "ebookers.nl",
    "ebookers.no",

    "mrjet.dk",

    "vrbo.com",

    "abritel.fr",
    "aluguetemporada.com.br",
    "fewo-direkt.de",
    "homeaway.at",
    "homeaway.ca",
    "homeaway.com",
    "homeaway.com.au",
    "homeaway.com.mx",
    "homeaway.co.nz",
    "homeaway.co.uk",
    "homeaway.dk",
    "homeaway.es",
    "homeaway.fi",
    "homeaway.gr",
    "homeaway.it",
    "homeaway.nl",
    "homeaway.no",
    "homeaway.pl",
    "homeaway.pt",
    "homeaway.se",
    "homelidays.com",
    "homelidays.es",
    "homelidays.fr",
    "homelidays.it",
    "ownersdirect.co.uk",
    "stayz.com.au",
    "vacationrentals.com",
  ],
  ["express-scripts.com", "medcohealth.com"],
  [
    "faithlife.com",

    "biblescreen.com",
    "biblestudymagazine.com",
    "biblia.com",
    "didaktikosjournal.com",
    "faithlifetv.com",
    "kirkdalepress.com",
    "lexhampress.com",
    "logos.com",
    "ministrytracker.com",
    "proclaimonline.com",
    "verbum.com",

    "bibliacdn.com",
    "faithlifecdn.com",
    "faithlifesitescdn.com",
    "logoscdn.com",
  ],
  [
    "fandom.com",

    "gamespot.com",
    "giantbomb.com",
    "metacritic.com",
    "tvguide.com",

    "fandom-dev.pl",
    "fandom-dev.us",
    "nocookie.net",
    "wikia.com",
    "wikia-dev.com",
    "wikia-dev.pl",
    "wikia-dev.us",
    "wikiafanstudio.com",
    "wikia-inc.com",
    "wikia.net",
    "wikia.org",
    "wikia-services.com",
    "wikia-staging.com",
  ],
  [
    "fastcompany.com",

    "fastcocreate.com",
    "fastcodesign.com",
    "fastcoexist.com",
    "fastcolabs.com",
    "fast-co.net",
    "fcimpactcouncil.com",
    "inc.com",
    "innovationuncensored.com",
    "mansueto.com",
    "mvdigitalmedia.com",
    "mvlicensing.com",
    "nativguard.com",
    "retirementcomm.com",

    "fastcompany.net",
  ],
  ["fastmail.com", "fastmailusercontent.com"],
  ["firefox.com", "firefoxusercontent.com", "mozilla.org"],
  ["focuschina.com", "doba.com", "made-in-china.com", "micstatic.com"],
  [
    "foxcorporation.com",

    "foxbusiness.com",
    "fox.com",
    "foxnews.com",
    "foxsports.com",
    "foxtv.com",
    "foxweather.com",
    "outkick.com",

    "fox10phoenix.com",
    "fox13news.com",
    "fox13seattle.com",
    "fox26houston.com",
    "fox29.com",
    "fox2detroit.com",
    "fox32chicago.com",
    "fox35orlando.com",
    "fox4news.com",
    "fox5atlanta.com",
    "fox5dc.com",
    "fox5ny.com",
    "fox6now.com",
    "fox7austin.com",
    "fox9.com",
    "foxla.com",
    "ktvu.com",
    "q13fox.com",

    "fncstatic.com",
  ],
  [
    "freshworks.com",

    "freshchat.com",
    "freshdesk.com",
    "freshmarketer.com",
    "freshservice.com",
    "myfreshworks.com",
  ],
  [
    "funkedigital.de",

    "abendblatt.de",
    "derwesten.de",
    "morgenpost.de",

    "fnki.de",
  ],
  [
    "futureplc.com",

    "creativebloq.com",
    "cyclingnews.com",
    "digitalcameraworld.com",
    "gamesradar.com",
    "gizmodo.co.uk",
    "guitarworld.com",
    "kotaku.co.uk",
    "laptopmag.com",
    "lifehacker.co.uk",
    "livescience.com",
    "loudersound.com",
    "musicradar.com",
    "pcgamer.com",
    "space.com",
    "t3.com",
    "techradar.com",
    "tomsguide.com",
    "tomshardware.com",
    "toptenreviews.com",
    "whathifi.com",

    "futurecdn.net",
    "future-fie-assets.co.uk",
    "future-fie.co.uk",
    "future.net.uk",
  ],
  ["g2.com", "g2crowd.com"],
  ["gamestar.de", "gamepro.de", "cgames.de"],
  [
    "gannettdigital.com",

    "app.com",
    "argusleader.com",
    "azcentral.com",
    "beaconjournal.com",
    "burlingtonfreepress.com",
    "capecodtimes.com",
    "cincinnati.com",
    "citizen-times.com",
    "cjonline.com",
    "clarionledger.com",
    "commercialappeal.com",
    "courier-journal.com",
    "delawareonline.com",
    "democratandchronicle.com",
    "desertsun.com",
    "desmoinesregister.com",
    "detroitnews.com",
    "dispatch.com",
    "elpasotimes.com",
    "floridatoday.com",
    "freep.com",
    "gainesville.com",
    "greenvilleonline.com",
    "heraldtribune.com",
    "indystar.com",
    "jacksonville.com",
    "jsonline.com",
    "knoxnews.com",
    "lansingstatejournal.com",
    "lohud.com",
    "montgomeryadvertiser.com",
    "naplesnews.com",
    "news-journalonline.com",
    "news-leader.com",
    "news-press.com",
    "northjersey.com",
    "oklahoman.com",
    "palmbeachpost.com",
    "pjstar.com",
    "pnj.com",
    "providencejournal.com",
    "registerguard.com",
    "rgj.com",
    "savannahnow.com",
    "seacoastonline.com",
    "sj-r.com",
    "statesman.com",
    "statesmanjournal.com",
    "tallahassee.com",
    "tcpalm.com",
    "telegram.com",
    "tennessean.com",
    "theledger.com",
    "usatoday.com",
    "wickedlocal.com",

    "gannettinnovation.com",
  ],
  [
    "gap.com",

    "bananarepublic.com",
    "gapfactory.com",
    "gapinc.com",
    "oldnavy.com",
    "piperlime.com",

    "bananarepublic.ca",
    "bananarepublic.co.jp",
    "bananarepublic.co.uk",
    "bananarepublic.eu",
    "gapcanada.ca",
    "gap.co.jp",
    "gap.co.uk",
    "gap.eu",
    "gap.hk",
    "oldnavy.ca",

    "assets-gap.com",
  ],
  [
    "gartner.com",

    "capterra.com",

    "capterra.ae",
    "capterra.at",
    "capterra.ch",
    "capterra.com.au",
    "capterra.com.br",
    "capterra.com.de",
    "capterra.co.uk",
    "capterra.es",
    "capterra.fr",
    "capterra.ie",
    "capterra.it",
    "capterra.nl",
    "capterra.se",

    "getapp.cl",
    "getapp.com.br",
    "getapp.co.uk",
    "getapp.de",
    "getapp.es",
    "getapp.fr",
    "getapp.sg",

    "softwareadvice.fr",
  ],
  [
    "gedi.it",
    "gedispa.it",

    "capital.it",
    "deejay.it",
    "gelocal.it",
    "huffingtonpost.it",
    "ilsecoloxix.it",
    "kataweb.it",
    "lastampa.it",
    "lescienze.it",
    "limesonline.com",
    "m2o.it",
    "mymovies.it",
    "repubblica.it",

    "gedidigital.it",
    "repstatic.it",
  ],
  ["gemini.media", "elconsolto.com", "masrawy.com", "shift-eg.com", "yallakora.com"],
  [
    "gettyimages.com",

    "gettyimages.ae",
    "gettyimages.ca",
    "gettyimages.com.au",
    "gettyimages.com.br",
    "gettyimages.com.mx",
    "gettyimages.co.nz",
    "gettyimages.co.uk",
    "gettyimages.de",
    "gettyimages.dk",
    "gettyimages.es",
    "gettyimages.fi",
    "gettyimages.fr",
    "gettyimages.in",
    "gettyimages.it",
    "gettyimages.nl",
    "gettyimages.no",

    "istockphoto.com",

    "thinkstockphotos.com",
    "thinkstockphotos.ca",
  ],
  ["gismeteo.com", "gismeteo.by", "gismeteo.kz", "gismeteo.lt", "gismeteo.ru", "gismeteo.net"],
  ["gitlab.com", "gitlab-static.net"],
  [
    "g-omedia.com",

    "avclub.com",
    "deadspin.com",
    "gizmodo.com",
    "jalopnik.com",
    "jezebel.com",
    "kotaku.com",
    "lifehacker.com",
    "theinventory.com",
    "theonion.com",
    "theroot.com",
    "thetakeout.com",

    "kinja.com",
    "kinja-img.com",
    "kinja-static.com",
  ],
  ["globo.com", "techtudo.com.br", "glbimg.com"],
  ["gm.com", "buick.com", "cadillac.com", "chevrolet.com", "gmc.com", "gmcertified.com"],
  ["gogoair.com", "gogoinflight.com"],
  [
    "gogoanime.llc",

    "gogoanime.ar",
    "gogoanime.bid",
    "gogoanime.cl",
    "gogoanime.dev",
    "gogoanime.hu",
    "gogoanime.tel",
    "gogoanime3.co",
    "gogoanime3.net",
    "gogoanimehd.io",
    "gogoanimes.fi",
    "gogoanimes.org",
    "gogotaku.info",

    "gogoanime.news",
    "gogo-cdn.net",
    "gogocdn.net",
    "gogo-load.com",
  ],
  [
    "google.com",

    "android.com",
    "blogger.com",
    "chromium.org",
    "gmail.com",
    "googleblog.com",
    "youtube.com",

    "ggpht.com",
    "googleusercontent.com",
    "googlevideo.com",
    "gstatic.com",
    "youtube-nocookie.com",
    "ytimg.com",

    "google.ac",
    "google.ad",
    "google.ae",
    "google.al",
    "google.am",
    "google.as",
    "google.at",
    "google.az",
    "google.ba",
    "google.be",
    "google.bf",
    "google.bg",
    "google.bi",
    "google.bj",
    "google.bs",
    "google.bt",
    "google.by",
    "google.ca",
    "google.cat",
    "google.cd",
    "google.cf",
    "google.cg",
    "google.ch",
    "google.ci",
    "google.cl",
    "google.cm",
    "google.cn",
    "google.com.af",
    "google.com.ag",
    "google.com.ai",
    "google.com.ar",
    "google.com.au",
    "google.com.bd",
    "google.com.bh",
    "google.com.bn",
    "google.com.bo",
    "google.com.br",
    "google.com.bz",
    "google.com.co",
    "google.com.cu",
    "google.com.cy",
    "google.com.do",
    "google.com.ec",
    "google.com.eg",
    "google.com.et",
    "google.com.fj",
    "google.com.gh",
    "google.com.gi",
    "google.com.gt",
    "google.com.hk",
    "google.com.jm",
    "google.com.kh",
    "google.com.kw",
    "google.com.lb",
    "google.com.ly",
    "google.com.mm",
    "google.com.mt",
    "google.com.mx",
    "google.com.my",
    "google.com.na",
    "google.com.nf",
    "google.com.ng",
    "google.com.ni",
    "google.com.np",
    "google.com.om",
    "google.com.pa",
    "google.com.pe",
    "google.com.pg",
    "google.com.ph",
    "google.com.pk",
    "google.com.pr",
    "google.com.py",
    "google.com.qa",
    "google.com.sa",
    "google.com.sb",
    "google.com.sg",
    "google.com.sl",
    "google.com.sv",
    "google.com.tj",
    "google.com.tr",
    "google.com.tw",
    "google.com.ua",
    "google.com.uy",
    "google.com.vc",
    "google.com.vn",
    "google.co.ao",
    "google.co.bw",
    "google.co.ck",
    "google.co.cr",
    "google.co.id",
    "google.co.il",
    "google.co.in",
    "google.co.jp",
    "google.co.ke",
    "google.co.kr",
    "google.co.ls",
    "google.co.ma",
    "google.co.mz",
    "google.co.nz",
    "google.co.th",
    "google.co.tz",
    "google.co.ug",
    "google.co.uk",
    "google.co.uz",
    "google.co.ve",
    "google.co.vi",
    "google.co.za",
    "google.co.zm",
    "google.co.zw",
    "google.cv",
    "google.cz",
    "google.de",
    "google.dj",
    "google.dk",
    "google.dm",
    "google.dz",
    "google.ee",
    "google.es",
    "google.fi",
    "google.fm",
    "google.fr",
    "google.ga",
    "google.ge",
    "google.gg",
    "google.gl",
    "google.gm",
    "google.gp",
    "google.gr",
    "google.gy",
    "google.hn",
    "google.hr",
    "google.ht",
    "google.hu",
    "google.ie",
    "google.im",
    "google.iq",
    "google.is",
    "google.it",
    "google.je",
    "google.jo",
    "google.kg",
    "google.ki",
    "google.kz",
    "google.la",
    "google.li",
    "google.lk",
    "google.lt",
    "google.lu",
    "google.lv",
    "google.md",
    "google.me",
    "google.mg",
    "google.mk",
    "google.ml",
    "google.mn",
    "google.ms",
    "google.mu",
    "google.mv",
    "google.mw",
    "google.ne",
    "google.nl",
    "google.no",
    "google.nr",
    "google.nu",
    "google.pl",
    "google.pn",
    "google.ps",
    "google.pt",
    "google.ro",
    "google.rs",
    "google.ru",
    "google.rw",
    "google.sc",
    "google.se",
    "google.sh",
    "google.si",
    "google.sk",
    "google.sm",
    "google.sn",
    "google.so",
    "google.sr",
    "google.st",
    "google.td",
    "google.tg",
    "google.tk",
    "google.tl",
    "google.tm",
    "google.tn",
    "google.to",
    "google.tt",
    "google.vg",
    "google.vu",
    "google.ws",

    "fonts.googleapis.com",
    "storage.googleapis.com",
    "www.googleapis.com",

    "autodraw.com",
    "chromeexperiments.com",
    "nest.com",
    "thinkwithgoogle.com",

    "about.google",
    "blog.google",
    "chromeenterprise.google",
    "cloudskillsboost.google",
    "deepmind.google",
    "design.google",
    "dns.google",
    "domains.google",
    "doodles.google",
    "ga-dev-tools.google",
    "grow.google",
    "io.google",
    "labs.google",
    "notebooklm.google",
    "opensource.google",
    "registry.google",
    "research.google",
    "safety.google",
    "sustainability.google",
    "tv.google",

    "applieddigitalskills.withgoogle.com",
    "cloudonair.withgoogle.com",
    "codingcompetitions.withgoogle.com",
    "experiments.withgoogle.com",
    "foobar.withgoogle.com",
    "learndigital.withgoogle.com",
    "nestpowerproject.withgoogle.com",
    "newsinitiative.withgoogle.com",
    "productexperts.withgoogle.com",
    "projectshield.withgoogle.com",
    "quickdraw.withgoogle.com",
    "rsvp.withgoogle.com",
    "searchon.withgoogle.com",
    "sitekit.withgoogle.com",
    "stitch.withgoogle.com",
    "summerofcode.withgoogle.com",
    "teachablemachine.withgoogle.com",
    "webdesigner.withgoogle.com",
  ],
  [
    "goto.com",

    "logmeininc.com",
    "gotomeeting.com",
    "gotomeet.me",
    "gotomypc.com",
    "gotostage.com",
    "gotowebinar.com",
    "lastpass.com",
    "logme.in",
    "logmein.com",

    "getgo.com",
    "lmiutil.com",
  ],
  ["www.gov.uk", "cabinet-office.gov.uk", "publishing.service.gov.uk"],
  ["government.nl", "knmi.nl", "rijksoverheid.nl", "rivm.nl"],
  [
    "gray.tv",

    "1011northplatte.com",
    "1011now.com",
    "13abc.com",
    "26nbc.com",
    "abc12.com",
    "blackhillsfox.com",
    "cbs7.com",
    "graydc.com",
    "kalb.com",
    "kbtx.com",
    "kcrg.com",
    "kcwy13.com",
    "kfyrtv.com",
    "kgns.tv",
    "kgwn.tv",
    "kkco11news.com",
    "kktv.com",
    "kmot.com",
    "kmvt.com",
    "knoe.com",
    "knopnews2.com",
    "kolotv.com",
    "kotatv.com",
    "kqcd.com",
    "ksfy.com",
    "ksnblocal4.com",
    "kspr.com",
    "ktuu.com",
    "kumv.com",
    "kwch.com",
    "kwqc.com",
    "kwtx.com",
    "kxii.com",
    "ky3.com",
    "nbc15.com",
    "newsplex.com",
    "thenewscenter.tv",
    "uppermichigansource.com",
    "valleynewslive.com",
    "wabi.tv",
    "wagmtv.com",
    "wbay.com",
    "wbko.com",
    "wcax.com",
    "wcjb.com",
    "wctv.tv",
    "wdbj7.com",
    "wdtv.com",
    "weau.com",
    "webcenter11.com",
    "whsv.com",
    "wibw.com",
    "wifr.com",
    "wilx.com",
    "witn.com",
    "wjhg.com",
    "wkyt.com",
    "wndu.com",
    "wowt.com",
    "wrdw.com",
    "wsaw.com",
    "wsaz.com",
    "wswg.tv",
    "wtok.com",
    "wtvy.com",
    "wvlt.tv",
    "wymt.com",

    "graytvinc.com",
  ],
  ["groupon.com", "groupon.co.uk", "groupon.de", "groupon.fr", "groupon.pl", "livingsocial.com", "groupondata.com"],
  ["grubhub.com", "seamless.com"],
  ["guardian.co.uk", "guim.co.uk", "guardianapps.co.uk", "theguardian.com", "gu-web.net"],
  [
    "habr.com",
    "habr.ru",
    "habrahabr.ru",
    "freelansim.ru",
    "geektimes.com",
    "geektimes.ru",
    "moikrug.ru",
    "toster.ru",

    "habracdn.net",
    "habrastorage.org",
    "hsto.org",
  ],
  [
    "hatena.ne.jp",

    "hatena.blog",
    "hatena.com",

    "st-hatena.com",
  ],
  ["healthfusion.com", "healthfusionclaims.com"],
  [
    "hearst.com",

    "25ans.jp",
    "autoweek.com",
    "bazaar.com",
    "beaumontenterprise.com",
    "bestproducts.com",
    "bicycling.com",
    "caranddriver.com",
    "chron.com",
    "cosmopolitan.com",
    "countryliving.com",
    "crfashionbook.com",
    "ctnews.com",
    "ctpost.com",
    "dariennewsonline.com",
    "delish.com",
    "drozthegoodlife.com",
    "elle.com",
    "elledecor.com",
    "esquire.com",
    "expressnews.com",
    "fairfieldcitizenonline.com",
    "foothillstrader.com",
    "fujingaho.jp",
    "gametimect.com",
    "gearpatrol.com",
    "ghsealapplication.com",
    "goodhouse.com",
    "goodhousekeeping.com",
    "greenwichtime.com",
    "harpersbazaar.com",
    "housebeautiful.com",
    "houstonchronicle.com",
    "lmtonline.com",
    "marieclaire.com",
    "menshealth.com",
    "michigansthumb.com",
    "middletownpress.com",
    "mrt.com",
    "myjournalcourier.com",
    "mylo.id",
    "myplainview.com",
    "mysanantonio.com",
    "newcanaannewsonline.com",
    "newmilfordspectrum.com",
    "newstimes.com",
    "nhregister.com",
    "oprahmag.com",
    "ourmidland.com",
    "popularmechanics.com",
    "prevention.com",
    "redbookmag.com",
    "registercitizen.com",
    "roadandtrack.com",
    "rodalesorganiclife.com",
    "runnersworld.com",
    "seattlepi.com",
    "seventeen.com",
    "sfchronicle.com",
    "sfgate.com",
    "shondaland.com",
    "stamfordadvocate.com",
    "s-w-e-e-t.com",
    "thehour.com",
    "theintelligencer.com",
    "thepioneerwoman.com",
    "thepioneerwomancooks.com",
    "thetelegraph.com",
    "timesunion.com",
    "todays-rewards.com",
    "townandcountrymag.com",
    "veranda.com",
    "wearesweet.co",
    "westport-news.com",
    "womansday.com",
    "womenshealthmag.com",
    "yourconroenews.com",

    "h-cdn.co",
    "hdmtech.net",
    "hdmtools.com",
    "hdnux.com",
    "hearst3pcc.com",
    "hearstapps.com",
    "hearstapps.net",
    "hearstdigitalstudios.com",
    "hearstdigitalstudios.net",
    "hearst.io",
    "hearstlabs.com",
    "hearstmags.com",
    "hearstmobile.com",
    "hearstnp.com",
  ],
  ["hh.ru", "hh.kz", "rabota.by", "zarplata.ru", "hhcdn.ru"],
  ["himss.org", "healthcarefinancenews.com", "healthcareitnews.com", "mobihealthnews.com"],
  ["hmgroup.com", "hm.com", "cos.com", "weekday.com", "monki.com", "stories.com", "arket.com", "afound.com"],
  ["hostinger.com", "hosting24.com", "hostinger.in", "hostinger.co.id", "hostinger.co.uk", "hostinger.com.br"],
  [
    "houzz.com",

    "houzz.at",
    "houzz.be",
    "houzz.ca",
    "houzz.ch",
    "houzz.co.jp",
    "houzz.com.au",
    "houzz.com.sg",
    "houzz.co.nz",
    "houzz.co.uk",
    "houzz.de",
    "houzz.dk",
    "houzz.es",
    "houzz.fi",
    "houzz.fr",
    "houzz.ie",
    "houzz.in",
    "houzz.it",
    "houzz.jp",
    "houzz.no",
    "houzz.nz",
    "houzz.pt",
    "houzz.ru",
    "houzz.se",
    "houzz.sg",
    "houzz.uk",

    "gardenweb.com",
    "gwhouzz3.com",
    "gwhouzz.com",
    "houzz2.com",
    "houzz2.com.au",
    "houzz2.co.uk",
    "houzz3.com",
    "houzz3.com.au",
    "houzz3.co.uk",
    "hzcdn.com",
    "stghouzz.com",
    "thathomesite.com",
  ],
  ["hp.com", "hpconnected.com", "hpdaas.com", "hpsmart.com", "hpwolf.com", "hyperx.com", "poly.com"],
  ["hubspot.com", "hubspotdocuments.com", "hubspot.net"],
  [
    "huobi.com",

    "hbfile.net",
    "hbg.com",
    "huobiasia.vip",
    "huobi.br.com",
    "huobi.me",
  ],
  ["hvfcu.org", "hvfcuonline.org"],
  ["ibtimes.com", "ibtimes.co.uk", "myibtimes.com"],
  [
    "idealo.de",

    "idealo.at",
    "idealo.co.uk",
    "idealo.es",
    "idealo.fr",
    "idealo.it",
    "idealo.com",
  ],
  [
    "idg.com",

    "cio.com",
    "computerworld.com",
    "csoonline.com",
    "greenbot.com",
    "idg.net",
    "idg.tv",
    "infoworld.com",
    "macworld.com",
    "networkworld.com",
    "pcworld.com",
    "techhive.com",

    "staticworld.net",
  ],
  [
    "ign.fr",

    "cartoradio.fr",
    "culture.fr",
    "duministeredelaculture.fr",
    "gouvernement.fr",
    "ignrando.fr",

    "geopf.fr",

    "ants.gouv.fr",
    "culture.gouv.fr",
    "data.gouv.fr",
    "education.gouv.fr",
    "etalab.gouv.fr",
    "geoportail.gouv.fr",
    "geoportail-urbanisme.gouv.fr",
    "impots.gouv.fr",
    "premier-ministre.gouv.fr",
    "service-civique.gouv.fr",
    "yvelines.gouv.fr",

    "ac-grenoble.fr",
    "ac-versailles.fr",
    "ac-bordeaux.fr",
    "ac-montpellier.fr",
    "ac-lille.fr",
  ],
  ["iheart.com", "americantop40.com", "armstrongandgetty.com", "coasttocoastam.com"],
  [
    "impresa.pt",

    "blitz.pt",
    "expresso.pt",
    "famashow.pt",
    "impresamediacriativa.pt",
    "sapo.pt",
    "siccaras.pt",
    "sickapa.pt",
    "sicmulher.pt",
    "sicnoticias.pt",
    "sic.pt",
    "sicradical.pt",
    "smack.pt",
    "tribunaexpresso.pt",
    "volantesic.pt",
  ],
  ["immobilienscout24.de", "static-immobilienscout24.de"],
  [
    "indamedia.hu",

    "blog.hu",
    "divany.hu",
    "femina.hu",
    "index.hu",
    "port.hu",
    "totalbike.hu",
    "totalcar.hu",

    "indapass.hu"
  ],
  ["independent.co.uk", "indy100.com", "the-independent.com"],
  ["infor.pl", "gazetaprawna.pl", "forsal.pl", "dziennik.pl"],
  ["innogames.com", "elvenar.com", "forgeofempires.com", "grepolis.com", "innogamescdn.com"],
  ["intercom.com", "intercom.io", "intercomassets.com", "intercomcdn.com"],
  ["itmedia.co.jp", "itmedia.jp"],
  [
    "iu.edu",

    "indiana.edu",
    "iue.edu",
    "iufw.edu",
    "iuk.edu",
    "iun.edu",
    "iupuc.edu",
    "iupui.edu",
    "iusb.edu",
    "ius.edu",
    "myiu.org",
  ],
  [
    "jd.com",

    "3.cn",
    "360buy.com",
    "360buyimg.com",
    "7fresh.com",
    "baitiao.com",
    "caiyu.com",
    "chinabank.com.cn",
    "jd.co.th",
    "jd.hk",
    "jd.id",
    "jd.ru",
    "jdl.cn",
    "jdl.com",
    "jdpay.com",
    "jdwl.com",
    "jdx.com",
    "jkcsjd.com",
    "joybuy.com",
    "joybuy.es",
    "ocwms.com",
    "paipai.com",
    "toplife.com",
    "wangyin.com",
    "yhd.com",
    "yihaodianimg.com",
    "yiyaojd.com",
    "yizhitou.com",
  ],
  [
    "jetbrains.com",

    "datalore.io",
    "intellij.net",
    "jetbrains.dev",
    "kotlinconf.com",
    "kotlinlang.org",
    "ktor.io",
    "talkingkotlin.com",
  ],
  ["jpmorganchase.com", "jpmorgan.com", "chase.com", "chasecdn.com"],
  ["jobware.de", "jobware.com", "jobware.net"],
  ["jotform.com", "jotfor.ms"],
  ["kaizengaming.com", "betano.com", "betano.bg", "betano.bet.ar", "betano.de", "betano.pe", "stoiximan.gr", "gmlinteractive.com"],
  [
    "kakaocorp.com",

    "brunch.co.kr",
    "daum.net",
    "kakao.com",
    "tistory.com",

    "daumcdn.net",
    "kakaocdn.net",
  ],
  [
    "kaspersky.com",

    "kaspersky.ca",
    "kaspersky.co.in",
    "kaspersky.com.au",
    "kaspersky.com.br",
    "kaspersky.com.cn",
    "kaspersky.com.tr",
    "kaspersky.com.tw",
    "kaspersky.co.uk",
    "kaspersky.de",
    "kaspersky.es",
    "kaspersky.fi",
    "kaspersky.fr",
    "kaspersky.gr",
    "kaspersky.it",
    "kaspersky.nl",
    "kaspersky.rs",
    "kaspersky.ru",

    "kaspersky-labs.com",
  ],
  [
    "kayak.com",

    "kayak.ae",
    "kayak.cat",
    "kayak.ch",
    "kayak.cl",
    "kayak.co.id",
    "kayak.co.in",
    "kayak.co.jp",
    "kayak.co.kr",
    "kayak.com.ar",
    "kayak.com.au",
    "kayak.com.br",
    "kayak.com.co",
    "kayak.com.hk",
    "kayak.com.mx",
    "kayak.com.my",
    "kayak.com.pe",
    "kayak.com.ph",
    "kayak.com.tr",
    "kayak.co.th",
    "kayak.co.uk",
    "kayak.de",
    "kayak.dk",
    "kayak.es",
    "kayak.eu",
    "kayak.fr",
    "kayak.ie",
    "kayak.it",
    "kayak.nl",
    "kayak.no",
    "kayak.ph",
    "kayak.pl",
    "kayak.pt",
    "kayak.qa",
    "kayak.ru",
    "kayak.se",
    "kayak.sg",

    "checkfelix.com",
    "checkfelix.co.uk",
    "checkfelix.es",
    "checkfelix.fr",
    "checkfelix.it",

    "momondo.at",
    "momondo.be",
    "momondo.by",
    "momondo.ca",
    "momondo.ch",
    "momondo.cl",
    "momondo.com",
    "momondo.com.ar",
    "momondo.com.au",
    "momondo.com.br",
    "momondo.com.cn",
    "momondo.com.co",
    "momondo.com.pe",
    "momondo.com.tr",
    "momondo.co.nz",
    "momondo.co.uk",
    "momondo.co.za",
    "momondo.cz",
    "momondo.de",
    "momondo.dk",
    "momondo.ee",
    "momondo.es",
    "momondo.fi",
    "momondo.fr",
    "momondogroup.com",
    "momondo.hk",
    "momondo.ie",
    "momondo.in",
    "momondo.it",
    "momondo.kz",
    "momondo.lt",
    "momondo.mx",
    "momondo.net",
    "momondo.nl",
    "momondo.no",
    "momondo.pl",
    "momondo.pro",
    "momondo.pt",
    "momondo.ro",
    "momondo.ru",
    "momondo.se",
    "momondo.tw",
    "momondo.ua",

    "mundi.com.br",

    "speedfares.com",

    "swoodoo.at",
    "swoodoo.ch",
    "swoodoo.com",

    "r9cdn.net",
  ],
  ["kingfisher.com", "diy.com", "castorama.fr", "castorama.pl"],
  ["kiwi.com", "skypicker.com"],
  [
    "kogan.com",

    "dicksmith.com.au",
    "dicksmith.co.nz",
    "koganinternet.com.au",
    "koganmobile.co.nz",
    "kogansuper.com.au",
    "kogantravel.com",
    "mattblatt.com.au",
    "tandy.com.au",
    "zazz.com.au",
  ],
  [
    "kompasgramedia.com",

    "grid.id",
    "gridoto.com",
    "kgmedia.id",
    "kompas.com",
    "kompasiana.com",
    "kompas.tv",
    "tribunnews.com",
  ],
  ["kwai.com", "kwai.net"],
  ["lbry.com", "odysee.com", "lbry.tv"],
  ["lendingtree.com", "comparecards.com", "depositaccounts.com"],
  ["likee.video", "like-video.com", "like.video", "likee.com", "likeevideo.com"],
  ["livesport.eu", "diretta.it", "flashscore.com", "flashscore.com.br", "flashscore.fr", "flashscore.pl", "livescore.in", "rezultati.com"],
  ["lloydsbankinggroup.com", "bankofscotland.co.uk", "halifax.co.uk", "halifax-online.co.uk", "lloydsbank.com", "dashboard.co.uk"],
  ["lnk.to", "tix.to", "tck.to", "ticket.to", "linkfire.com", "assetlab.io", "linkfire.co", "lnkfi.re"],
  ["lottomaticagroup.com", "goldbet.it", "lottomatica.it", "planetwin365.it"],
  [
    "loveholidays.com",
    "loveholidays.be",
    "loveholidays.dk",
    "loveholidays.es",
    "loveholidays.fi",
    "loveholidays.fr",
    "loveholidays.ie",
    "loveholidays.nl",
    "loveholidays.no",
    "loveholidays.co.nz",
    "loveholidays.pt",
    "loveholidays.se",
    "lovevacations.com",
  ],
  ["macys.com", "macysassets.com"],
  [
    "mafra.cz",

    "idnes.cz",
    "lidovky.cz",
    "expres.cz",

    "1gr.cz",
  ],
  ["mandtbank.com", "mtb.com"],
  ["marriott.com", "marriott.co.jp", "marriott.co.uk", "marriott.de"],
  ["mars.com", "snickers.com"],
  ["marugroup.net", "maruhub.com", "marupanels.com", "maru-cdn.com"],
  ["mastercard.us", "mastercard.co.uk", "mastercard.com"],
  ["matchtv.ru", "sportbox.ru"],
  ["mathletics.com", "mathletics.com.au", "mathletics.co.uk"],
  [
    "mcclatchy.com",

    "bellinghamherald.com",
    "bnd.com",
    "bradenton.com",
    "calientesemanal.com",
    "carolinanewspapers.com",
    "centredaily.com",
    "chapelhillnews.com",
    "charlotte.com",
    "charlotteobserver.com",
    "claytonnewsstar.com",
    "cubanow.com",
    "demo-mo.com",
    "dfw.com",
    "diariolaestrella.com",
    "elnuevoherald.com",
    "encubahoy.com",
    "enquirerherald.com",
    "flkeysnews.com",
    "fortmilltimes.com",
    "fresnobee.com",
    "gateline.com",
    "gogamecocks.com",
    "heraldonline.com",
    "heraldsun.com",
    "idahostatesman.com",
    "incubatoday.com",
    "islandpacket.com",
    "kansascity.com",
    "kansas.com",
    "kcstar.com",
    "kentucky.com",
    "keysnet.com",
    "lakewyliepilot.com",
    "ledger-enquirer.com",
    "losbanosenterprise.com",
    "lsjournal.com",
    "macon.com",
    "mcclatchydc.com",
    "mcclatchyinteractive.com",
    "mcclatchy-newsroom.com",
    "mcclatchy-video.com",
    "mcclatchy-wires.com",
    "mercedsunstar.com",
    "miamiherald.com",
    "modbee.com",
    "myrtlebeachonline.com",
    "ncinsider.com",
    "newsobserver.com",
    "sacbee.com",
    "sanluisobispo.com",
    "sierrastar.com",
    "star-telegram.com",
    "sunherald.com",
    "thenewstribune.com",
    "theolympian.com",
    "thestate.com",
    "tri-cityherald.com",
    "vidaenelvalle.com",
  ],
  ["mdsol.com", "imedidata.com"],
  ["mediacorp.sg", "channelnewsasia.com", "melisten.sg", "mewatch.sg", "todayonline.com"],
  ["medialivre.pt", "cmjornal.pt", "record.pt", "xl.pt"],
  [
    "mediamarktsaturn.com",

    "mediamarkt.at",
    "mediamarkt.be",
    "mediamarkt.ch",
    "mediamarkt.com.tr",
    "mediamarkt.de",
    "mediamarkt.es",
    "mediamarkt.gr",
    "mediamarkt.hu",
    "mediamarkt.nl",
    "mediamarkt.se",

    "saturn.at",
    "saturn.de",
    "saturn.lu",

    "redblue.de",

    "mediamarkt.pl",
    "redcoon.pl",
    "saturn.pl",
    "ms-online.pl",
  ],
  ["meetup.com", "meetupstatic.com"],
  ["meituan.com", "dianping.com", "longcat.chat", "meituan.net"],
  [
    "mercadolibre.com",

    "mercadolibre.cl",
    "mercadolibre.co.cr",
    "mercadolibre.com.ar",
    "mercadolibre.com.bo",
    "mercadolibre.com.co",
    "mercadolibre.com.do",
    "mercadolibre.com.ec",
    "mercadolibre.com.gt",
    "mercadolibre.com.hn",
    "mercadolibre.com.mx",
    "mercadolibre.com.ni",
    "mercadolibre.com.pa",
    "mercadolibre.com.pe",
    "mercadolibre.com.py",
    "mercadolibre.com.sv",
    "mercadolibre.com.uy",
    "mercadolibre.com.ve",
    "mercadolivre.com",
    "mercadolivre.com.br",

    "mercadopago.com",
    "mercadopago.com.ar",
    "mercadopago.com.br",
    "mercadopago.com.co",
    "mercadopago.com.mx",
    "mercadopago.com.pe",
    "mercadopago.com.uy",
    "mercadopago.cl",

    "mercadoshops.com",
    "mercadoshops.cl",
    "mercadoshops.com.ar",
    "mercadoshops.com.br",
    "mercadoshops.com.co",
    "mercadoshops.com.mx",
    "mercadoshops.com.ve",

    "mercadoclics.com",
    "mlstatic.com",
  ],
  [
    "mercedes-benz.com",

    "mercedes-benz-africa.com",
    "mercedes-benz-asia.com",
    "mercedes-benz.at",
    "mercedes-benz.ba",
    "mercedes-benz.be",
    "mercedes-benz.bg",
    "mercedes-benz.ca",
    "mercedes-benz.ch",
    "mercedes-benz.cl",
    "mercedes-benz.co.id",
    "mercedes-benz.co.in",
    "mercedes-benz.co.jp",
    "mercedes-benz.co.kr",
    "mercedes-benz.com.ar",
    "mercedes-benz.com.au",
    "mercedes-benz.com.br",
    "mercedes-benz.com.cn",
    "mercedes-benz.com.co",
    "mercedes-benz.com.cy",
    "mercedes-benz.com.eg",
    "mercedes-benz.com.gt",
    "mercedes-benz.com.hk",
    "mercedes-benz.com.lk",
    "mercedes-benz.com.mt",
    "mercedes-benz.com.mx",
    "mercedes-benz.com.my",
    "mercedes-benz.com.pe",
    "mercedes-benz.com.ph",
    "mercedes-benz.com.sg",
    "mercedes-benz.com.tr",
    "mercedes-benz.com.tt",
    "mercedes-benz.com.tw",
    "mercedes-benz.com.uy",
    "mercedes-benz.com.vn",
    "mercedes-benz.co.nz",
    "mercedes-benz.co.th",
    "mercedes-benz.co.uk",
    "mercedes-benz.co.ve",
    "mercedes-benz.co.za",
    "mercedes-benz.cz",
    "mercedes-benz.de",
    "mercedes-benz.dk",
    "mercedes-benz-eastern-europe.com",
    "mercedes-benz.ee",
    "mercedes-benz.es",
    "mercedes-benz.fi",
    "mercedes-benz.fr",
    "mercedes-benz.gr",
    "mercedes-benz.hr",
    "mercedes-benz.hu",
    "mercedes-benz.ie",
    "mercedes-benz.is",
    "mercedes-benz.it",
    "mercedes-benz.li",
    "mercedes-benz.lt",
    "mercedes-benz.lu",
    "mercedes-benz.lv",
    "mercedes-benz-mena.com",
    "mercedes-benz.nl",
    "mercedes-benz.no",
    "mercedes-benz-north-cyprus.com",
    "mercedes-benz.pl",
    "mercedes-benz.pt",
    "mercedes-benz.ro",
    "mercedes-benz.rs",
    "mercedes-benz.ru",
    "mercedes-benz.se",
    "mercedes-benz.si",
    "mercedes-benz.sk",
    "mercedes-benz.ua",
  ],
  [
    "meta.com",

    "facebook.com",
    "instagram.com",
    "messenger.com",
    "threads.com",
    "threads.net",
    "workplace.com",

    "oculus.com",
    "oculuscdn.com",
    "oculusrift.com",
    "oculusvr.com",
    "powersunitedvr.com",

    "cdninstagram.com",
    "facebook.net",
    "fbcdn.com",
    "fbcdn.net",
    "fbsbx.com",
  ],
  ["meteored.com", "tempo.pt"],
  ["mi.com", "xiaomi.com"],
  [
    "microsoft.com",

    "1drv.ms",
    "aadrm.com",
    "acompli.net",
    "adaptivecards.io",
    "adbureau.net",
    "adecn.com",
    "aka.ms",
    "aquantive.com",
    "aspnetcdn.com",
    "assets-yammer.com",
    "azure.com",
    "azure.net",
    "azurerms.com",
    "azuresynapse.net",
    "bing.com",
    "bing.net",
    "cloudappsecurity.com",
    "cloud.microsoft",
    "dynamics.com",
    "eng.ms",
    "gamesforwindows.com",
    "getgamesmart.com",
    "gfx.ms",
    "groupme.com",
    "healthvault.com",
    "hockeyapp.net",
    "hotmail.com",
    "ieaddons.com",
    "iegallery.com",
    "live.com",
    "live.net",
    "lync.com",
    "mcas-gov.ms",
    "mcas-gov.us",
    "mcas.ms",
    "microsoft365.com",
    "microsoftalumni.com",
    "microsoftalumni.org",
    "microsoftazuread-sso.com",
    "microsoftedgeinsider.com",
    "microsoftedgeinsiders.com",
    "microsoftonline.com",
    "microsoftonline-p.com",
    "microsoftonline-p.net",
    "microsoftonline.us",
    "microsoftstore.com",
    "microsoftstore.com.cn",
    "microsoftstream.com",
    "microsoft.us",
    "minecraft.net",
    "mktoevents.com",
    "msads.net",
    "msappproxy.net",
    "msauthimages.net",
    "msecnd.net",
    "msedge.net",
    "msftidentity.com",
    "msft.net",
    "msidentity.com",
    "msn.cn",
    "msn.com",
    "msndirect.com",
    "msocdn.com",
    "msra.cn",
    "netconversions.com",
    "o365weve.com",
    "oaspapps.com",
    "office365.com",
    "office365.us",
    "office.com",
    "officelive.com",
    "office.net",
    "olsvc.com",
    "onedrive.com",
    "onenote.com",
    "onenote.net",
    "onestore.ms",
    "onmicrosoft.com",
    "outlook.com",
    "outlookmobile.com",
    "passport.net",
    "phonefactor.net",
    "powerapps.com",
    "powerautomate.com",
    "powerbi.com",
    "powerplatform.com",
    "roiservice.com",
    "sfbassets.com",
    "sfx.ms",
    "sharepoint.com",
    "sharepoint-df.com",
    "sharept.ms",
    "skypeassets.com",
    "skype.com",
    "skypeforbusiness.com",
    "s-microsoft.com",
    "s-msn.com",
    "staffhub.ms",
    "status.microsoft",
    "svc.ms",
    "sway-cdn.com",
    "sway.com",
    "sway-extensions.com",
    "tealsk12.org",
    "virtualearth.net",
    "visualstudio.com",
    "vsallin.net",
    "vsassets.io",
    "vscode.dev",
    "windowsazure.com",
    "windows.com",
    "windows.net",
    "windowsphone.com",
    "worldwidetelescope.org",
    "wunderlist.com",
    "xbox.com",
    "xboxlive.com",
    "yammer.com",
    "yammerusercontent.com",

    "s-msft.com",
    "msftauth.net",

    "linkedin.com",
    "licdn.com",

    "github.com",
    "githubapp.com",
    "githubassets.com",
    "github.dev",

    "avatars.githubusercontent.com",
    "avatars0.githubusercontent.com",
    "avatars1.githubusercontent.com",
    "avatars2.githubusercontent.com",
    "avatars3.githubusercontent.com",
    "camo.githubusercontent.com",
    "cloud.githubusercontent.com",
    "raw.githubusercontent.com",
  ],
  ["miraheze.org", "wikitide.net"],
  ["mobilism.org.in", "mobilism.org"],
  ["morganstanley.com", "morganstanleyclientserv.com", "stockplanconnect.com", "ms.com"],
  [
    "morningstar.com",

    "morningstar.at",
    "morningstar.be",
    "morningstarbr.com",
    "morningstar.ca",
    "morningstar.ch",
    "morningstar.cl",
    "morningstar.co.il",
    "morningstar.com.mx",
    "morningstar.co.uk",
    "morningstar.de",
    "morningstar.dk",
    "morningstar.es",
    "morningstar.fi",
    "morningstar.fr",
    "morningstarfunds.ie",
    "morningstar.it",
    "morningstar.nl",
    "morningstar.no",
    "morningstar.pt",
    "morningstar.se",
    "morningstarthailand.com",
  ],
  [
    "motorsportnetwork.com",

    "autosport.com",
    "insideevs.com",
    "motor1.com",
    "motorsport.com",
    "motorsporttickets.com",
  ],
  ["mts.ru", "mtsbank.ru"],
  [
    "mtv.fi",

    "cmore.fi",
    "lumijapyry.fi",
    "luukku.com",
    "mtvuutiset.fi",
    "salatutelamat.fi",
    "studio55.fi",
    "suomiareena.fi",
  ],
  ["my-bookings.org", "my-bookings.cc"],
  [
    "myheritage.com",

    "myheritageadn.be",
    "myheritageadn.fr",
    "myheritageadn.it",
    "myheritageadn.pt",
    "myheritage.am",
    "myheritage.at",
    "myheritage.be",
    "myheritage.cat",
    "myheritage.ch",
    "myheritage.cn",
    "myheritage.co.il",
    "myheritage.co.in",
    "myheritage.co.kr",
    "myheritage.com.br",
    "myheritage.com.hr",
    "myheritage.com.pt",
    "myheritage.com.tr",
    "myheritage.com.ua",
    "myheritage.cz",
    "myheritage.de",
    "myheritage.dk",
    "myheritagedna.be",
    "myheritagedna.com",
    "myheritagedna.fr",
    "myheritagedna.it",
    "myheritagedna.pt",
    "myheritage.ee",
    "myheritage.es",
    "myheritage.fi",
    "myheritage.fr",
    "myheritage.gr",
    "myheritage.hu",
    "myheritage.it",
    "myheritage.jp",
    "myheritagelibraryedition.com",
    "myheritage.lt",
    "myheritage.lv",
    "myheritage.mk",
    "myheritage.nl",
    "myheritage.no",
    "myheritage.pl",
    "myheritage.pt",
    "myheritage.ro",
    "myheritage.rs",
    "myheritage.se",
    "myheritage.si",
    "myheritage.sk",
    "myheritage.tw",

    "dnaquest.org",
    "familygraph.com",
    "familygraphql.com",
    "familytreebuilder.com",
    "tribalquest.org",

    "mhcache.com",
    "myheritage-container.com",
    "myheritagefiles.com",
    "myheritageimages.com",
  ],
  ["mynortonaccount.com", "norton.com"],
  ["mysmartedu.com", "mysmartabc.com"],
  ["myuv.com", "uvvu.com"],
  [
    "nationalworld.com",

    "lep.co.uk",
    "portsmouth.co.uk",
    "scotsman.com",
    "sussexexpress.co.uk",
    "thestar.co.uk",
    "yorkshireeveningpost.co.uk",
    "yorkshirepost.co.uk",
  ],
  [
    "naver.com",

    "grafolio.com",
    "plug.game",
    "vlive.tv",
    "webtoons.com",

    "naver.net",
    "pstatic.net",

    "2chblog.jp",
    "blog.jp",
    "blogos.com",
    "doorblog.jp",
    "ldblog.jp",
    "linecorp.com",
    "line.me",
    "livedoor.com",
    "livedoor.jp",

    "blogcms.jp",
    "blogimg.jp",
    "blogsys.jp",
    "line-apps.com",
    "line.biz",
    "line-scdn.net",
    "livedoor.net",
    "naver.jp",
  ],
  [
    "nbcuniversal.com",

    "apoyandoanuestrasescuelas.com",
    "bravotv.com",
    "cleartheshelters.com",
    "cnbc.com",
    "cozitv.com",
    "desocuparlosalbergues.com",
    "eonline.com",
    "fandango.com",
    "golfchannel.com",
    "lxtv.com",
    "movies.com",
    "msnbc.com",
    "nbc.com",
    "nbcnews.com",
    "nbcolympics.com",
    "nbcsports.com",
    "nbcsportsedge.com",
    "nbcstations.com",
    "nbcstormranger.com",
    "necn.com",
    "oxygen.com",
    "peacocktv.com",
    "rottentomatoes.com",
    "syfy.com",
    "telemundo.com",
    "telemundodeportes.com",
    "telexitos.com",
    "today.com",
    "usanetwork.com",

    "nbcbayarea.com",
    "nbcboston.com",
    "nbcchicago.com",
    "nbcconnecticut.com",
    "nbcdfw.com",
    "nbclosangeles.com",
    "nbcmiami.com",
    "nbcnewyork.com",
    "nbcphiladelphia.com",
    "nbcsandiego.com",
    "nbcwashington.com",

    "telemundo20.com",
    "telemundo31.com",
    "telemundo33.com",
    "telemundo40.com",
    "telemundo47.com",
    "telemundo48elpaso.com",
    "telemundo49.com",
    "telemundo51.com",
    "telemundo52.com",
    "telemundo62.com",
    "telemundoareadelabahia.com",
    "telemundoarizona.com",
    "telemundoboston.com",
    "telemundocazatormentas.com",
    "telemundochicago.com",
    "telemundodallas.com",
    "telemundodenver.com",
    "telemundohouston.com",
    "telemundolasvegas.com",
    "telemundonuevainglaterra.com",
    "telemundopr.com",
    "telemundoraleigh.com",
    "telemundosanantonio.com",
    "telemundoutah.com",
    "telemundowashingtondc.com",

    "nbcuni.com",
    "newsvine.com",
    "s-nbcnews.com",
  ],
  ["ncsoft.com", "aiononline.com", "bladeandsoul.com", "guildwars2.com", "lineage2.com"],
  ["nefcuonline.com", "nefcu.com"],
  [
    "netease.com",

    "126.com",
    "126.net",
    "127.net",
    "163.com",

    "icourse163.org",
    "kada.com",
    "kaola.com",
    "kaola.com.hk",
    "lofter.com",
  ],
  ["netflix.com", "nflxext.com", "nflximg.net", "nflxvideo.net"],
  [
    "nettix.fi",

    "nettiauto.com",
    "nettikaravaani.com",
    "nettikone.com",
    "nettimarkkina.com",
    "nettimokki.com",
    "nettimoto.com",
    "nettivaraosa.com",
    "nettivene.com",
    "nettivuokraus.com",
  ],
  ["newegg.com", "neweggbusiness.com", "neweggimages.com", "newegg.ca"],
  [
    "newfold.com",

    "bigrock.com",
    "bizland.com",
    "bluehost.com",
    "buydomains.com",
    "crazydomains.com",
    "domain.com",
    "hostgator.com",
    "ipage.com",
    "ipower.com",
    "logicboxes.com",
    "namejet.com",
    "networksolutions.com",
    "powweb.com",
    "register.com",
    "resellerclub.com",
    "sitebuilder.com",
    "snapnames.com",
    "startlogic.com",
    "verio.com",
    "virtualave.net",
    "vodien.com",
    "web.com",
  ],
  [
    "newscorp.com",

    "news.co.uk",
    "nypost.com",
    "pagesix.com",
    "thescottishsun.co.uk",
    "the-sun.com",
    "thesun.co.uk",
    "thesun.ie",
    "thetimes.co.uk",

    "barrons.com",
    "dowjones.com",
    "dowjoneson.com",
    "mansionglobal.com",
    "marketwatch.com",
    "wsj.com",
    "wsj.net",
  ],
  [
    "newscorpaustralia.com",

    "1degree.com.au",
    "adelaidenow.com.au",
    "api.news",
    "bestrecipes.com.au",
    "bodyandsoul.com.au",
    "brisbanenews.com.au",
    "cairnspost.com.au",
    "couriermail.com.au",
    "dailytelegraph.com.au",
    "delicious.com.au",
    "escape.com.au",
    "foxsports.com.au",
    "geelongadvertiser.com.au",
    "goldcoastbulletin.com.au",
    "gq.com.au",
    "heraldsun.com.au",
    "homelife.com.au",
    "insideout.com.au",
    "kidspot.com.au",
    "nativeincolour.com.au",
    "newsadds.com.au",
    "newsapi.com.au",
    "newscdn.com.au",
    "news.com.au",
    "news.net.au",
    "newsprestigenetwork.com.au",
    "newsxtend.com.au",
    "nlm.io",
    "ntnews.com.au",
    "skynews.com.au",
    "supercoach.com.au",
    "taste.com.au",
    "theaustralian.com.au",
    "themercury.com.au",
    "townsvillebulletin.com.au",
    "vogue.com.au",
    "weeklytimesnow.com.au",
    "whereilive.com.au",
    "whimn.com.au",
  ],
  ["newgrounds.com", "ngfiles.com"],
  ["nextdoor.com", "nextdoor.co.uk"],
  [
    "nfl.com",
    "nflgamepass.com",

    "49ers.com",
    "atlantafalcons.com",
    "azcardinals.com",
    "baltimoreravens.com",
    "bengals.com",
    "buccaneers.com",
    "buffalobills.com",
    "chargers.com",
    "chicagobears.com",
    "chiefs.com",
    "clevelandbrowns.com",
    "colts.com",
    "commanders.com",
    "dallascowboys.com",
    "denverbroncos.com",
    "detroitlions.com",
    "dolphins.com",
    "giants.com",
    "houstontexans.com",
    "jaguars.com",
    "miamidolphins.com",
    "neworleanssaints.com",
    "newyorkjets.com",
    "packers.com",
    "panthers.com",
    "patriots.com",
    "philadelphiaeagles.com",
    "raiders.com",
    "redskins.com",
    "seahawks.com",
    "steelers.com",
    "tennesseetitans.com",
    "therams.com",
    "vikings.com",

    "nfltags.com",
  ],
  [
    "ngs.ru",

    "29.ru",
    "45.ru",
    "59.ru",
    "63.ru",
    "72.ru",
    "74.ru",
    "86.ru",
    "93.ru",
    "116.ru",
    "161.ru",
    "chita.ru",
    "e1.ru",
    "fontanka.ru",
    "ircity.ru",
    "mgorsk.ru",
    "n1.ru",
    "ngs24.ru",
    "ngs42.ru",
    "ngs55.ru",
    "nn.ru",
    "sochi1.ru",
    "tolyatty.ru",
    "ufa1.ru",
    "v1.ru",
  ],
  [
    "nineforbrands.com.au",

    "2gb.com",
    "9news.com.au",
    "9now.com.au",
    "afr.com",
    "brisbanetimes.com.au",
    "businessinsider.com.au",
    "canberratimes.com.au",
    "caradvice.com.au",
    "domain.com.au",
    "drive.com.au",
    "fairfaxmedia.com.au",
    "gizmodo.com.au",
    "kotaku.com.au",
    "lifehacker.com.au",
    "ninemsn.com.au",
    "smh.com.au",
    "theage.com.au",
    "traveller.com.au",
    "watoday.com.au",

    "ffx.io",
    "nine.com.au",
  ],
  [
    "nintendo.com",

    "nintendo.at",
    "nintendo.be",
    "nintendo.ca",
    "nintendo.ch",
    "nintendo.co.jp",
    "nintendo.co.uk",
    "nintendo.co.za",
    "nintendo.com.au",
    "nintendo.de",
    "nintendo.es",
    "nintendo.eu",
    "nintendo.fr",
    "nintendo.it",
    "nintendo.nl",
    "nintendonyc.com",
    "nintendo.pt",
    "nintendo.ru",

    "nintendo-europe.com",
    "nintendo.net",

    "animal-crossing.com",
    "smashbros.com",
    "zelda.com",
  ],
  ["norsk-tipping.no", "buypass.no"],
  [
    "npo.nl",

    "2doc.nl",
    "3fm.nl",
    "avrotros.nl",
    "bnnvara.nl",
    "brainwash.nl",
    "delagarde.nl",
    "eo.nl",
    "funx.nl",
    "human.nl",
    "jeugdjournaal.nl",
    "joop.nl",
    "kro-ncrv.nl",
    "kro.nl",
    "npo3fm.nl",
    "npo3.nl",
    "npoplus.nl",
    "nporadio1.nl",
    "nporadio2.nl",
    "nporadio4.nl",
    "nporadio5.nl",
    "npostart.nl",
    "ntr.nl",
    "omroep.nl",
    "powned.tv",
    "publiekeomroep.nl",
    "radio4.nl",
    "schooltv.nl",
    "vara.nl",
    "vpro.nl",
    "zappelin.nl",
    "zapp.nl",
  ],
  ["ntt.com", "goo.ne.jp", "ocn.ne.jp"],
  [
    "nypublicradio.org",

    "newsounds.org",
    "radiolab.org",
    "thegreenespace.org",
    "wnycstudios.org",
    "wqxr.org",

    "wnyc.org",
  ],
  ["nytimes.com", "newyorktimes.com", "thewirecutter.com", "nyt.com"],
  ["nyu.edu", "nyupress.org"],
  [
    "nvidia.com",

    "nvidia.at",
    "nvidia.be",
    "nvidia.ch",
    "nvidia.cn",
    "nvidia.co.at",
    "nvidia.co.in",
    "nvidia.co.jp",
    "nvidia.co.kr",
    "nvidia.com.au",
    "nvidia.com.br",
    "nvidia.com.mx",
    "nvidia.com.pe",
    "nvidia.com.pl",
    "nvidia.com.tr",
    "nvidia.com.tw",
    "nvidia.com.ua",
    "nvidia.com.ve",
    "nvidia.co.uk",
    "nvidia.cz",
    "nvidia.de",
    "nvidia.dk",
    "nvidia.es",
    "nvidia.eu",
    "nvidia.fi",
    "nvidia.fr",
    "nvidia.in",
    "nvidia.it",
    "nvidia.jp",
    "nvidia.lu",
    "nvidia.mx",
    "nvidia.nl",
    "nvidia.no",
    "nvidia.pl",
    "nvidia.ro",
    "nvidia.ru",
    "nvidia.se",
    "nvidia.tw",

    "nvidiagrid.net",
    "nvidia.partners",

    "geforce.com",
    "geforcenow.com",
    "gputechconf.com",

    "geforce.cn",
    "geforce.com.tw",
    "geforce.co.uk",
  ],
  ["okcupid.com", "okccdn.com"],
  [
    "olxgroup.com",

    "olx.ba",
    "olx.bg",
    "olx.co.id",
    "olx.com",
    "olx.com.ar",
    "olx.com.br",
    "olx.com.co",
    "olx.com.ec",
    "olx.com.eg",
    "olx.com.pe",
    "olx.com.pk",
    "olx.com.sv",
    "olx.co.za",
    "olx.in",
    "olx.kz",
    "olx.pl",
    "olx.pt",
    "olx.ro",
    "olx.ua",
    "olx.uz",

    "otodom.pl",
    "otomoto.pl",

    "olxcdn.com",
    "olxssa.com",
    "olx-st.com",
  ],
  ["oneindia.com", "boldsky.com", "drivespark.com", "filmibeat.com", "gizbot.com", "goodreturns.in", "mykhel.com", "nativeplanet.com"],
  ["onlineatnsb.com", "norwaysavingsbank.com"],
  ["openai.com", "chatgpt.com", "oaistatic.com"],
  ["openstreetmap.org", "osmfoundation.org"],
  [
    "oracle.com",

    "ateam-oracle.com",
    "bronto.com",
    "covid19-rx.org",
    "covid19rx.org",
    "go.java",
    "java.com",
    "mysql.com",
    "oraclefoundation.org",
    "texturacorp.com",

    "oraclecloud.com",
    "oracleimg.com",
  ],
  ["orange.fr", "sosh.fr", "woopic.com"],
  ["osano.com", "datasubject.com"],
  ["oschina.net", "gitee.io", "gitee.com"],
  [
    "osf.io",

    "agrixiv.org",
    "arabixiv.org",
    "eartharxiv.org",
    "ecsarxiv.org",
    "engrxiv.org",
    "frenxiv.org",
    "marxiv.org",
    "mindrxiv.org",
    "paleorxiv.org",
    "psyarxiv.com",
    "thesiscommons.org"
  ],
  ["osu.edu", "osumc.edu", "ohio-state.edu"],
  [
    "ovh.com",

    "kimsufi.com",
    "ovhcloud.com",
    "ovhtelecom.fr",
    "soyoustart.com",

    "ovh.com.au",
    "ovh.co.uk",
    "ovh.cz",
    "ovh.de",
    "ovh.es",
    "ovh-hosting.fi",
    "ovh.ie",
    "ovh.it",
    "ovh.lt",
    "ovh.nl",
    "ovh.pl",
    "ovh.pt",
    "ovh.sn",

    "ovh.net",
  ],
  [
    "ozon.ru",

    "ozon.com",
    "ozon.tech",
    "ozone.ru",

    "ozon.by",
    "ozon.kz",

    "ozonusercontent.com"
  ],
  ["paypal.com", "paypal-search.com", "paypalobjects.com"],
  ["pbs.org", "pbskids.org", "whyy.org", "wttw.com"],
  [
    "pconline.cn",

    "geeknev.com",
    "imofan.com",
    "pcautoactivity.com.cn",
    "pcautoclub.com.cn",
    "pcauto.com.cn",
    "pcbaby.com.cn",
    "pc.com.cn",
    "pchouse.com.cn",
    "pclady.com.cn",
    "pconline.com.cn",
    "pcprices.com.cn",
    "pcvideo.com.cn",

    "3conline.com",
  ],
  [
    "pearson.com",

    "connexus.com",
    "ecollege.com",
    "english.com",
    "masteringchemistry.com",
    "masteringengineering.com",
    "masteringgeography.com",
    "masteringhealthandnutrition.com",
    "masteringphysics.com",
    "mathxl.com",
    "mathxlforschool.com",
    "mypearson.com",
    "pearsonassessments.com",
    "pearsoned.com",
    "pearsonelt.com",
    "pearsonhighered.com",
    "pearsonmylabandmastering.com",

    "pearsoncmg.com",
  ],
  ["pmc.com", "deadline.com", "indiewire.com", "rollingstone.com", "variety.com"],
  ["people.com.cn", "people.cn", "peopledaily.com.cn"],
  ["pepco.com", "pepcoholdings.com"],
  [
    "philips.com",

    "philips.ae",
    "philips.am",
    "philips.at",
    "philips.az",
    "philips.be",
    "philips.bg",
    "philips.by",
    "philips.ca",
    "philips.ch",
    "philips.cl",
    "philips.co.id",
    "philips.co.il",
    "philips.co.in",
    "philips.co.jp",
    "philips.co.ke",
    "philips.co.kr",
    "philips.com.ar",
    "philips.com.au",
    "philips.com.bh",
    "philips.com.br",
    "philips.com.cn",
    "philips.com.co",
    "philips.com.eg",
    "philips.com.ge",
    "philips.com.gh",
    "philips.com.hk",
    "philips.com.kw",
    "philips.com.lb",
    "philips.com.mx",
    "philips.com.my",
    "philips.com.om",
    "philips.com.pe",
    "philips.com.ph",
    "philips.com.pk",
    "philips.com.pl",
    "philips.com.qa",
    "philips.com.sa",
    "philips.com.sg",
    "philips.com.tr",
    "philips.com.tw",
    "philips.com.uy",
    "philips.com.ve",
    "philips.com.vn",
    "philips.co.nz",
    "philips.co.th",
    "philips.co.uk",
    "philips.co.za",
    "philips.cz",
    "philips.de",
    "philips.dk",
    "philips.ee",
    "philips.es",
    "philips.fi",
    "philips.fr",
    "philips.gr",
    "philips.hr",
    "philips.hu",
    "philips.ie",
    "philips.iq",
    "philips.it",
    "philips.jo",
    "philips.kz",
    "philips.lt",
    "philips.lv",
    "philips.ma",
    "philips.ng",
    "philips.nl",
    "philips.no",
    "philips.pl",
    "philips.pt",
    "philips.ro",
    "philips.rs",
    "philips.ru",
    "philips.sa",
    "philips.se",
    "philips.si",
    "philips.sk",
    "philips.ua",
    "philips.uz",

    "philips-hue.com",
  ],
  [
    "pinterest.com",

    "pinterest.at",
    "pinterest.be",
    "pinterest.ca",
    "pinterest.ch",
    "pinterest.cl",
    "pinterest.co",
    "pinterest.co.at",
    "pinterest.co.in",
    "pinterest.co.kr",
    "pinterest.com.au",
    "pinterest.com.bo",
    "pinterest.com.ec",
    "pinterest.com.mx",
    "pinterest.com.pe",
    "pinterest.com.py",
    "pinterest.com.uy",
    "pinterest.com.vn",
    "pinterest.co.nz",
    "pinterest.co.uk",
    "pinterest.de",
    "pinterest.dk",
    "pinterest.ec",
    "pinterest.engineering",
    "pinterest.es",
    "pinterest.fr",
    "pinterest.hu",
    "pinterest.id",
    "pinterest.ie",
    "pinterest.in",
    "pinterest.info",
    "pinterest.it",
    "pinterest.jp",
    "pinterest.kr",
    "pinterestmail.com",
    "pinterest.mx",
    "pinterest.nz",
    "pinterest.pe",
    "pinterest.ph",
    "pinterest.pt",
    "pinterest.ru",
    "pinterest.se",
    "pinterest.th",
    "pinterest.tw",
    "pinterest.uk",
    "pinterest.vn",

    "pinimg.com",
    "pin.it",
  ],
  ["plex.tv", "plex.direct"],
  ["pokemon-gl.com", "pokemon.com"],
  [
    "polsatnews.pl",

    "rmf24.pl",

    "interia.pl",
    "bryk.pl",
    "int.pl",
    "pomponik.pl",
    "skul.pl",
    "smaker.pl",
    "terazgotuje.pl",

    "iplsc.com"
  ],
  ["pornhub.com", "mainhub.com", "pornhub.org", "pornhubpremium.com", "redtube.com", "thumbzilla.com", "youporn.com", "phncdn.com"],
  ["postepay.it", "poste.it"],
  ["postimees.ee", "city24.ee", "city24.lv", "pmo.ee"],
  [
    "postmedia.com",

    "calgaryherald.com",
    "calgarysun.com",
    "canada.com",
    "canoe.com",
    "driving.ca",
    "edmontonjournal.com",
    "edmontonsun.com",
    "financialpost.com",
    "leaderpost.com",
    "lfpress.com",
    "montrealgazette.com",
    "nationalpost.com",
    "ottawacitizen.com",
    "ottawasun.com",
    "theprovince.com",
    "thestarphoenix.com",
    "thesudburystar.com",
    "thewhig.com",
    "torontosun.com",
    "vancouversun.com",
    "windsorstar.com",
    "winnipegsun.com",

    "postmedia.digital",
  ],
  [
    "prensaiberica360.es",

    "elperiodico.com",
    "levante-emv.com",
    "lne.es",

    "prensaiberica.es",
  ],
  ["pressreader.com", "prcdn.co"],
  [
    "pricerunner.com",

    "pricerunner.co.uk",
    "pricerunner.de",
    "pricerunner.dk",
    "pricerunner.net",
    "pricerunner.se",
    "pricerunner.uk",
  ],
  [
    "prisa.com",

    "as.com",
    "cadenaser.com",
    "caracol.com.co",
    "elpais.com",
    "huffingtonpost.es",
    "wradio.com.co",
    "wradio.com.mx",

    "epimg.net",
    "prisasd.com",
  ],
  [
    "prosiebensat1.de",
    "prosiebensat1.com",

    "atv.at",
    "atv2.at",
    "galileo.tv",
    "kabeleins.at",
    "kabeleins.ch",
    "kabeleins.de",
    "kabeleinsdoku.at",
    "kabeleinsdoku.ch",
    "kabeleinsdoku.de",
    "prosieben.at",
    "prosieben.ch",
    "prosieben.de",
    "prosiebenmaxx.at",
    "prosiebenmaxx.ch",
    "prosiebenmaxx.de",
    "puls24.at",
    "puls4.com",
    "puls8.ch",
    "ran.de",
    "sat1.at",
    "sat1.ch",
    "sat1.de",
    "sat1gold.at",
    "sat1gold.ch",
    "sat1gold.de",
    "sixx.at",
    "sixx.ch",
    "sixx.de",
    "the-voice-of-germany.at",
    "the-voice-of-germany.ch",
    "the-voice-of-germany.de",
    "zappn.tv",

    "p7s1.io",
  ],
  [
    "qantas.com",

    "jetstar.com",
    "qantas.com.au",
    "qantascourier.com.au",
    "qantasfutureplanet.com.au",
    "qantasgrouptravel.com",
    "qfcrew.com",
    "qfflightcrew.com",

    "aquire.com.au",
    "qantasassure.com",
    "qantasbusinessrewards.com",
    "qantasbusinessrewards.com.au",
    "qantasepiqure.com",
    "qantasepiqure.com.au",
    "qantasgolfclub.com",
    "qantasgolfclub.com.au",
    "qantasloyalty.com",
    "qantasloyalty.net",
    "qantasmall.com",
    "qantasmall.com.au",
    "qantasmall.co.nz",
    "qantaspoints.com",
    "qantaspoints.com.au",
    "qantasshopping.com",
    "qantasshopping.com.au",
    "qantasshopping.co.nz",
    "qantasstore.com.au",
    "qantasstore.co.nz",
    "redplanetgroup.com.au",
    "redplanetportal.com.au",

    "qantascash.com",
    "qantascash.com.au",
    "qantasmoney.com",
    "qantastravelmoney.com",
  ],
  [
    "qq.com",

    "aitangyou.com",
    "cdntips.com",
    "cnb.cool",
    "dnspod.cn",
    "dnspod.com",
    "extqq.com",
    "gdtimg.com",
    "gtimg.cn",
    "gtimg.com",
    "idqqimg.com",
    "imqq.com",
    "myapp.com",
    "myqcloud.com",
    "qcloud.com",
    "qpic.cn",
    "qqmail.com",
    "qzone.com",
    "sogou.com",
    "tencent.com",
    "tenpay.com",
    "ugdtimg.com",
    "url.cn",
    "webnovel.com",
    "wechat.com",
    "wegame.com",
    "weiyun.com",

    "cdn-go.cn"
  ],
  [
    "rai.it",

    "comunitaitalofona.org",
    "raicinema.it",
    "raicultura.it",
    "raimemo.it",
    "rainews24.it",
    "rainews.it",
    "raiplay.it",
    "raiplayradio.it",
    "raiplayyoyo.it",
    "raipubblicita.it",
    "raisport.it",
    "raitalia.it",
    "rai.tv",
    "raiway.it",
  ],
  ["railnation.ru", "railnation.de", "rail-nation.com", "railnation.gr", "railnation.us", "trucknation.de", "traviangames.com"],
  [
    "rakuten.com",

    "rakuten.co.jp",
    "rakuten.com.my",
    "rakuten.com.tw",
    "rakuten.co.uk",
    "rakuten.eu",
    "rakuten.fr",
    "rakuten.ne.jp",

    "buy.com",
    "buyservices.com",
    "fril.jp",
    "gnavi.co.jp",
    "infoseek.co.jp",
    "kobo.com",
    "linkshare.ne.jp",
    "nikki.ne.jp",
    "rakuten-airmap.co.jp",
    "rakuten-bank.co.jp",
    "rakuten-bank.com.tw",
    "rakuten-card.co.jp",
    "rakuten-dx.com",
    "rakuten-dx.eu",
    "rakuteneagles.jp",
    "rakuten-insurance.co.jp",
    "rakuten-life.co.jp",
    "rakuten-sec.co.jp",
    "rakutensl.com",
    "rakuten-sonpo.co.jp",
    "rakuten-sqreem.co.jp",
    "rakuten-ssi.co.jp",
    "rakuten.today",
    "rakuten.tv",
    "rakuten-wallet.co.jp",
    "rebates.jp",
    "vacation-stay.com",
    "viber.co.jp",
    "viber.com",
    "viki.com",
    "vissel-kobe.co.jp",

    "rakuten-static.com",
  ],
  ["raygun.com", "raygun.io"],
  ["rbcroyalbank.com", "royalbank.com", "rbc.com"],
  [
    "reachplc.com",

    "aberdeenlive.news",
    "accringtonobserver.co.uk",
    "bathchronicle.co.uk",
    "bedfordshirelive.co.uk",
    "belfastlive.co.uk",
    "birminghamlive.co.uk",
    "birminghammail.co.uk",
    "birminghampost.co.uk",
    "bristol.live",
    "bristolpost.co.uk",
    "buckinghamshirelive.com",
    "burtonmail.co.uk",
    "business-live.co.uk",
    "buzz.ie",
    "cambridge-news.co.uk",
    "cambridgeshirelive.co.uk",
    "cheshire-live.co.uk",
    "chesterchronicle.co.uk",
    "chroniclelive.co.uk",
    "corkbeo.ie",
    "cornwalllive.com",
    "coventrytelegraph.net",
    "crewechronicle.co.uk",
    "croydonadvertiser.co.uk",
    "dailypost.co.uk",
    "dailyrecord.co.uk",
    "dailystar.co.uk",
    "derbytelegraph.co.uk",
    "devonlive.com",
    "dorset.live",
    "dublinlive.ie",
    "edinburghlive.co.uk",
    "essexlive.news",
    "examiner.co.uk",
    "examinerlive.co.uk",
    "express.co.uk",
    "football.london",
    "footballscotland.co.uk",
    "galwaybeo.ie",
    "gazettelive.co.uk",
    "getbucks.co.uk",
    "gethampshire.co.uk",
    "getreading.co.uk",
    "getsurrey.co.uk",
    "getwestlondon.co.uk",
    "glasgowlive.co.uk",
    "gloucestershirelive.co.uk",
    "grimsbytelegraph.co.uk",
    "hampshirelive.news",
    "hertfordshiremercury.co.uk",
    "hinckleytimes.net",
    "hulldailymail.co.uk",
    "insider.co.uk",
    "irishmirror.ie",
    "kentlive.news",
    "lancs.live",
    "leeds-live.co.uk",
    "leicestermercury.co.uk",
    "lincolnshirelive.co.uk",
    "liverpool.com",
    "liverpoolecho.co.uk",
    "loughboroughecho.net",
    "macclesfield-express.co.uk",
    "macclesfield-live.co.uk",
    "manchestereveningnews.co.uk",
    "mirror.co.uk",
    "mylondon.news",
    "norfolklive.co.uk",
    "northantslive.news",
    "nottinghampost.com",
    "ok.co.uk",
    "oxfordshirelive.co.uk",
    "plymouthherald.co.uk",
    "rossendalefreepress.co.uk",
    "rsvplive.ie",
    "scottishdailyexpress.co.uk",
    "scunthorpetelegraph.co.uk",
    "somersetlive.co.uk",
    "southportvisiter.co.uk",
    "staffordshire-live.co.uk",
    "stokesentinel.co.uk",
    "suffolklive.com",
    "sussexlive.co.uk",
    "tm-aws.com",
    "tm-awx.com",
    "tm-dev-aws.com",
    "tm-dev-awx.com",
    "walesonline.co.uk",
    "wharf.co.uk",
    "wiltshirelive.co.uk",
  ],
  [
    "realestate.com.au",

    "property.com.au",
    "realcommercial.com.au",
    "spacely.com.au",

    "reastatic.net",
  ],
  [
    "recruit-holdings.com",

    "glassdoor.com",

    "glassdoor.be",
    "glassdoor.ca",
    "glassdoor.co.in",
    "glassdoor.com.au",
    "glassdoor.com.br",
    "glassdoor.co.uk",
    "glassdoor.de",
    "glassdoor.fr",
    "glassdoor.ie",
    "glassdoor.nl",
    "glassdoor.sg",

    "indeed.com",

    "indeed.ae",
    "indeed.ca",
    "indeed.ch",
    "indeed.cl",
    "indeed.co.in",
    "indeed.com.au",
    "indeed.com.br",
    "indeed.com.co",
    "indeed.com.mx",
    "indeed.com.my",
    "indeed.com.pe",
    "indeed.com.ph",
    "indeed.com.pk",
    "indeed.com.sg",
    "indeed.co.uk",
    "indeed.co.ve",
    "indeed.co.za",
    "indeed.de",
    "indeed.es",
    "indeed.fi",
    "indeed.fr",
    "indeed.hk",
    "indeed.ie",
    "indeed.jp",
    "indeed.lu",
    "indeed.nl",
    "indeed.pt",
  ],
  ["reddit.com", "redditmedia.com", "redditstatic.com", "redd.it", "redditenhancementsuite.com", "reddituploads.com", "imgur.com"],
  ["redhat.com", "openshift.com", "openshift.org", "okd.io"],
  [
    "redventures.com",

    "greatist.com",
    "healthgrades.com",
    "healthline.com",
    "healthlinemedia.com",
    "medicalnewstoday.com",
    "psychcentral.com",

    "rvohealth.com",
  ],
  [
    "reebok.at",
    "reebok.be",
    "reebok.ca",
    "reebok.ch",
    "reebok.cl",
    "reebok.co",
    "reebok.com",
    "reebok.com.ar",
    "reebok.com.br",
    "reebok.com.tr",
    "reebok.co.uk",
    "reebok.cz",
    "reebok.de",
    "reebok.dk",
    "reebok.es",
    "reebok.fi",
    "reebok.fr",
    "reebok.ie",
    "reebok.it",
    "reebok.mx",
    "reebok.nl",
    "reebok.pe",
    "reebok.pl",
    "reebok.ru",
    "reebok.se",
    "reebok.sk",
  ],
  [
    "relx.com",

    "elsevier.com",
    "jbc.org",
    "lexisnexis.com",
    "mayoclinicproceedings.org",
    "mendeley.com",
    "plu.mx",
    "sciencedirectassets.com",
    "sciencedirect.com",
    "ssrn.com",
    "thelancet.com",
  ],
  [
    "reuters.com",
    "reuters.tv",
    "reutersmedia.net",
    "thomsonreuters.com",

    "reutersagency.cn",

    "thomsonreuters.ca",
    "thomsonreuters.cn",
    "thomsonreuters.co.jp",
    "thomsonreuters.co.kr",
    "thomsonreuters.com.ar",
    "thomsonreuters.com.au",
    "thomsonreuters.com.br",
    "thomsonreuters.com.hk",
    "thomsonreuters.com.my",
    "thomsonreuters.com.pe",
    "thomsonreuters.com.sg",
    "thomsonreuters.com.tr",
    "thomsonreuters.co.uk",
    "thomsonreuters.es",
    "thomsonreuters.in",
    "thomsonreuters.ru",
  ],
  [
    "ringieraxelspringer.pl",

    "aktuality.sk",
    "auto-swiat.pl",
    "blic.rs",
    "businessinsider.com.pl",
    "cash.ch",
    "fakt.pl",
    "forbes.pl",
    "komputerswiat.pl",
    "libertatea.ro",
    "medonet.pl",
    "newsweek.pl",
    "nk.pl",
    "noizz.hu",
    "noizz.pl",
    "noizz.rs",
    "ofeminin.pl",
    "onet.pl",
    "plejada.pl",
    "ringieraxelspringer.com",
    "ringpublishing.com",
    "skapiec.pl",
    "vod.pl",

    "dreamlab.pl",
    "grupaonet.pl",

    "ocdn.eu",
    "pulsembed.eu",
  ],
  [
    "riotgames.com",

    "leagueoflegends.com",
    "lolesports.com",
    "lolstatic.com",
    "lolusercontent.com",

    "arcane.com",
    "playruneterra.com",
    "playvalorant.com",

    "riotcdn.net",
    "rdatasrv.net",
  ],
  [
    "rtl.nl",

    "bright.nl",
    "buienradar.nl",
    "healthyfest.nl",
    "rtlboulevard.nl",
    "rtllatenight.nl",
    "rtlnieuws.nl",
    "rtlxl.nl",
    "rtlz.nl",
    "videoland.com",
    "vtbl.nl",
  ],
  ["rtx.com", "collinsaerospace.com", "rockwellcollins.com", "rtxapps.com"],
  [
    "s-kanava.fi",

    "abcasemat.fi",
    "foodie.fi",
    "prisma.fi",
    "raflaamo.fi",
    "s-mobiili.fi",
    "sokos.fi",
    "sokoshotels.fi",
    "s-pankki.fi",
    "s-ryhma.fi",
    "tok.fi",
    "yhteishyva.fi",

    "s-cloud.fi",
    "sok.fi",
    "s-palvelut.fi",
  ],
  [
    "sanoma.fi",

    "aamulehti.fi",
    "akuankka.fi",
    "etlehti.fi",
    "gloria.fi",
    "hs.fi",
    "hyvaterveys.fi",
    "iltasanomat.fi",
    "is.fi",
    "jamsanseutu.fi",
    "janakkalansanomat.fi",
    "kankaanpaanseutu.fi",
    "kmvlehti.fi",
    "kodinkuvalehti.fi",
    "menaiset.fi",
    "merikarvialehti.fi",
    "nelonen.fi",
    "nokianuutiset.fi",
    "radiorock.fi",
    "radiosuomipop.fi",
    "rannikkoseutu.fi",
    "ruutu.fi",
    "satakunnankansa.fi",
    "supla.fi",
    "suurkeuruu.fi",
    "sydansatakunta.fi",
    "tiede.fi",
    "tyrvaansanomat.fi",
    "valkeakoskensanomat.fi",
    "vauva.fi",

    "nelonenmedia.fi",
    "snstatic.fi",
  ],
  [
    "salesforce.com",

    "documentforce.com",
    "einstein.com",
    "force.com",
    "pardot.com",
    "salesforceliveagent.com",
    "visualforce.com",

    "salesforce-sites.com",
  ],
  ["sanguosha.com", "bianfeng.com"],
  [
    "sberbank.com",

    "rabota.ru",
    "sberbank.ru",
    "sbercloud.ru",
    "sberdevices.ru",
    "sberlogistics.ru",
    "sbermobile.ru",

    "sber.ru",

    "rambler-co.ru",

    "championat.com",
    "ferra.ru",
    "gazeta.ru",
    "giga.chat",
    "indicator.ru",
    "lenta.ru",
    "letidor.ru",
    "livejournal.com",
    "moslenta.ru",
    "motor.ru",
    "passion.ru",
    "quto.ru",
    "secretmag.ru",
    "wmj.ru",

    "eaglecdn.com",
    "eagleplatform.com",
    "livejournal.net",
    "lj-toys.com",
    "rambler.ru",
  ],
  [
    "schwab.com",

    "schwab.com.hk",

    "schwabassetmanagement.com",
    "schwabcharitable.org",
    "schwabinstitutional.com",
    "schwabplan.com",

    "schwabcdn.com",

    "tdameritrade.com",
    "advisorclient.com",
    "ameritrade.com",
    "tdameritrade.com.sg",
    "thinkorswim.com",
    "thinkorswim.com.sg",
  ],
  ["schibsted.com", "finn.no", "tori.fi"],
  ["scmp.com", "i-scmp.com"],
  ["sears.com", "shld.net"],
  ["seek.com.au", "jobsdb.com", "jobstreet.com", "seek.co.nz"],
  [
    "seznam.cz",

    "firmy.cz",
    "garaz.cz",
    "kupi.cz",
    "lide.cz",
    "mapy.com",
    "mapy.cz",
    "novinky.cz",
    "prozeny.cz",
    "sauto.cz",
    "sbazar.cz",
    "sdovolena.cz",
    "seznamzpravy.cz",
    "sport.cz",
    "sreality.cz",
    "stream.cz",
    "super.cz",
    "sweb.cz",
    "televizeseznam.cz",
    "volnamista.cz",
    "zbozi.cz",

    "szn.cz",
  ],
  ["shein.com", "shein.in", "shein.com.mx", "shein.co.uk", "romwe.com", "ltwebstatic.com"],
  [
    "shopee.com",

    "shopee.cl",
    "shopee.cn",
    "shopee.co.id",
    "shopee.com.ar",
    "shopee.com.br",
    "shopee.com.co",
    "shopee.com.mx",
    "shopee.com.my",
    "shopee.co.th",
    "shopee.es",
    "shopee.fr",
    "shopee.in",
    "shopee.ph",
    "shopee.pl",
    "shopee.sg",
    "shopee.tw",
    "shopee.vn",

    "shopeemobile.com",
    "shp.ee",
  ],
  [
    "shopify.com",

    "shopify.ca",
    "shopify.in",
    "shopify.nl",

    "shop.app",

    "shopifysvc.com",
    "shopifycdn.com",
    "shopifyapps.com",
    "shopifycloud.com",
    "shopifyadmin.com",
    "shopifypreview.com",
  ],
  [
    "si.edu",

    "airspacemag.com",
    "smithsonianbooks.com",
    "smithsonianchannel.com",
    "smithsonianjourneys.org",
    "smithsonianmag.com",
    "smithsonianstore.com",

    "smithsonian.museum",
  ],
  ["signetjewelers.com", "jared.com", "kay.com", "zales.com", "jewels.com"],
  ["siriusxm.com", "sirius.com"],
  ["skygo.co.nz", "skytv.co.nz"],
  ["skysports.com", "skybet.com", "skyvegas.com"],
  ["slashdot.org", "sourceforge.net", "fsdn.com", "slashdotmedia.com"],
  ["slickdeals.net", "slickdealscdn.com"],
  ["snapchat.com", "bitmoji.com"],
  ["snapfish.com", "snapfish.ca"],
  [
    "sony.com",

    "sonyentertainmentnetwork.com",
    "sonyrewards.com",

    "playstation.com",
    "playstation.net",

    "sony-africa.com",
    "sony-asia.com",
    "sony.at",
    "sony.ba",
    "sony.be",
    "sony.bg",
    "sony.ca",
    "sony.ch",
    "sony.cl",
    "sony.co.cr",
    "sony.co.id",
    "sony.co.in",
    "sony.co.kr",
    "sony.com.ar",
    "sony.com.au",
    "sony.com.bo",
    "sony.com.br",
    "sony.com.co",
    "sony.com.do",
    "sony.com.ec",
    "sony.com.gt",
    "sony.com.hk",
    "sony.com.hn",
    "sony.com.mk",
    "sony.com.mx",
    "sony.com.my",
    "sony.com.ni",
    "sony.com.pa",
    "sony.com.pe",
    "sony.com.ph",
    "sony.com.sg",
    "sony.com.sv",
    "sony.com.tr",
    "sony.com.tw",
    "sony.com.vn",
    "sony.co.nz",
    "sony.co.th",
    "sony.co.uk",
    "sony.cz",
    "sony.de",
    "sony.dk",
    "sony.ee",
    "sony.es",
    "sony.eu",
    "sony-europe.com",
    "sony.fi",
    "sony.fr",
    "sony.gr",
    "sony.hr",
    "sony.hu",
    "sony.ie",
    "sony.it",
    "sony.kz",
    "sony-latin.com",
    "sonylatvija.com",
    "sony.lt",
    "sony.lu",
    "sony.lv",
    "sony-mea.com",
    "sony.nl",
    "sony.no",
    "sony.pl",
    "sony-promotion.eu",
    "sony.pt",
    "sony.ro",
    "sony.rs",
    "sony.ru",
    "sony.se",
    "sony.si",
    "sony.sk",
    "sony.ua",

    "sony.net",
  ],
  ["soundcloud.com", "sndcdn.com"],
  ["soundcu.com", "netteller.com"],
  ["southerncompany.com", "southernco.com"],
  ["spiceworks.com", "spiceworksstatic.com"],
  [
    "spotify.com",

    "scdn.co",
    "spotifyforbrands.com",
    "spotifyforartists.com",
    "spotify.net",
  ],
  [
    "springernature.com",

    "adis.com",
    "apress.com",
    "biomedcentral.com",
    "bsl.nl",
    "dgim-eakademie.de",
    "kardiologie.org",
    "macmillaneducation.com",
    "macmillanexplorers.com",
    "medengine.com",
    "medicinematters.com",
    "medicinematters.in",
    "medwirenews.com",
    "metzlerverlag.de",
    "nature.com",
    "natureindex.com",
    "palgrave.com",
    "scientificamerican.com",
    "springer.com",
    "springeraesthetik.de",
    "springerhealthcare.com",
    "springermedizin.at",
    "springermedizin.de",
    "springeropen.com",
    "springerpflege.de",
    "springerprofessional.de",
  ],
  ["sprint.com", "sprintpcs.com", "nextel.com"],
  ["squareup.com", "cash.app", "mkt.com", "squarecdn.com"],
  [
    "stackexchange.com",

    "askubuntu.com",
    "blogoverflow.com",
    "mathoverflow.net",
    "serverfault.com",
    "stackapps.com",
    "stackoverflow.blog",
    "stackoverflow.com",
    "superuser.com",

    "sstatic.net",
    "stackauth.com",
    "stackoverflow.email",
    "stacksnippets.net",
  ],
  ["steampowered.com", "steamstatic.com", "steamcommunity.com"],
  ["stripchat.com", "imagefap.live", "sun-porno.com", "xhamsterlive.com", "strpst.com", "striiiipst.com"],
  ["stripe.com", "stripe.network", "stripecdn.com"],
  ["suning.com", "suning.cn", "hksuning.com"],
  [
    "surveymonkey.com",

    "surveymonkey.ca",
    "surveymonkey.co.uk",
    "surveymonkey.de",
    "surveymonkey.eu",
    "surveymonkey.fr",
    "surveymonkey.net",
    "surveymonkey.nl",
    "surveymonkey.ru",

    "feedbackeconomy.com",
    "research.net",

    "smassets.net",
  ],
  ["t-mobile.com", "tmobile.com", "metrobyt-mobile.com", "t-mobilemoney.com"],
  ["target.com", "targetimg1.com"],
  ["techdata.com", "techdata.ch"],
  ["technologyadvice.com", "gadgethacks.com", "wonderhowto.com"],
  ["telegraaf.nl", "tcdn.nl", "tmgonlinemedia.nl", "tnet.nl"],
  ["telegram.org", "telegram.me", "t.me"],
  ["telekom.com", "t-online.de"],
  ["terabox.com", "1024tera.com", "1024terabox.com", "4funbox.com", "freeterabox.com", "mirrobox.com", "terabox.app", "terabox1024.com", "teraboxcdn.app", "teraboxcdn.com", "teraboxlink.com", "teraboxshare.com", "terafileshare.com", "terasharelink.com"],
  ["tesla.com", "teslamotors.com"],
  ["thegioididong.com", "dienmayxanh.com", "tgdd.vn"],
  ["thelocal.com", "thelocal.de", "thelocal.fr", "thelocal.se"],
  ["theregister.com", "theregister.co.uk", "regmedia.co.uk"],
  ["tilda.cc", "tildacdn.com"],
  [
    "timberland.com",
    "timberland.at",
    "timberland.be",
    "timberland.bo",
    "timberland.bz",
    "timberland.ca",
    "timberland.ch",
    "timberland.cl",
    "timberland.co",
    "timberland.co.cr",
    "timberland.co.uk",
    "timberland.co.ve",
    "timberland.com.gy",
    "timberland.com.py",
    "timberland.com.ve",
    "timberland.de",
    "timberland.dk",
    "timberland.ec",
    "timberland.es",
    "timberland.eu",
    "timberland.fr",
    "timberland.gf",
    "timberland.gt",
    "timberland.hn",
    "timberland.ie",
    "timberland.it",
    "timberland.lu",
    "timberland.ni",
    "timberland.nl",
    "timberland.pt",
    "timberland.se",
    "timberland.uy",
    "timberlandonline.co",
  ],
  [
    "timesinternet.in",

    "economictimes.com",
    "educationtimes.com",
    "etimes.in",
    "gaana.co.in",
    "gaana.com",
    "gadgetsnow.com",
    "iamgujarat.com",
    "idiva.com",
    "indiatimes.com",
    "indiatimes.in",
    "magicbricks.com",
    "maharashtratimes.com",
    "mensxp.com",
    "misskyra.com",
    "mumbaimirror.com",
    "punemirror.in",
    "samayam.com",
    "speakingtree.in",
    "timesnowhindi.com",
    "timesnownews.com",
    "timesofindia.com",
    "timespoints.com",
    "timesprime.com",
    "vijaykarnataka.com",
    "whatshot.in",

    "etimg.com",
    "gaanacdn.com",
    "iimg.in",
    "toiimg.com",
    "tvid.in",
  ],
  ["townhall.com", "bearingarms.com", "hotair.com", "pjmedia.com", "redstate.com", "twitchy.com"],
  [
    "townsquaremedia.com",

    "949whom.com",
    "97x.com",
    "allchristmas.fm",
    "antennamag.com",
    "arcadesushi.com",
    "b93.net",
    "bigcat921.com",
    "bigcat953.com",
    "brooklynvegan.com",
    "clrvynt.com",
    "cnynews.com",
    "comicsalliance.com",
    "danburycountry.com",
    "diffuser.fm",
    "elektrodaily.com",
    "foxsports1510.com",
    "fun107.com",
    "guyspeed.com",
    "hudsonvalleycountry.com",
    "juanhudsonvalley.com",
    "kbat.com",
    "king-mag.com",
    "lonestar923.com",
    "loudwire.com",
    "mix979fm.com",
    "noisecreep.com",
    "popcrush.com",
    "screencrush.com",
    "star939.com",
    "tasteofcountry.com",
    "theboot.com",
    "theeaglerocksny.com",
    "ultimateclassicrock.com",
    "wbkr.com",
    "wblm.com",
    "wbsm.com",
    "wcyy.com",
    "wjbq.com",
    "womiowensboro.com",
    "wsrkfm.com",
    "wtbdfm.com",
    "wzozfm.com",
    "xxlmag.com",

    "townsquare.media",
    "townsquareblogs.com",
  ],
  [
    "toyota.com",

    "lexus.com",

    "toyota.am",
    "toyota.at",
    "toyota.az",
    "toyota.ba",
    "toyota.be",
    "toyota.bg",
    "toyota-canarias.es",
    "toyotacg.me",
    "toyota.ch",
    "toyota.co.il",
    "toyota.com.cy",
    "toyota.com.mk",
    "toyota.com.mt",
    "toyota.com.tr",
    "toyota.co.uk",
    "toyota.cz",
    "toyota.de",
    "toyota.dk",
    "toyota.ee",
    "toyota.es",
    "toyota.fi",
    "toyota.fr",
    "toyota.ge",
    "toyota-gib.com",
    "toyota.gr",
    "toyota.hr",
    "toyota.hu",
    "toyota.ie",
    "toyota.is",
    "toyota.it",
    "toyota-kosovo.com",
    "toyota.kz",
    "toyota.lt",
    "toyota.lu",
    "toyota.lv",
    "toyota.md",
    "toyota.nl",
    "toyota.no",
    "toyota.pl",
    "toyota.pt",
    "toyota.ro",
    "toyota.rs",
    "toyota.ru",
    "toyota.se",
    "toyota.si",
    "toyota.sk",
    "toyota.ua",

    "toyota-europe.com",
  ],
  [
    "tribpub.com",

    "baltimoresun.com",
    "bestreviews.com",
    "chicagotribune.com",
    "courant.com",
    "dailypress.com",
    "mcall.com",
    "nydailynews.com",
    "orlandosentinel.com",
    "pilotonline.com",
    "sun-sentinel.com",
    "thedailymeal.com",
  ],
  [
    "trip.com",

    "ctrip.com",
    "c-ctrip.com",

    "skyscanner.com",

    "skyscanner.co.in",
    "skyscanner.com.br",
    "skyscanner.com.sg",
    "skyscanner.de",
    "skyscanner.es",
    "skyscanner.fr",
    "skyscanner.it",

    "skyscanner.net",
  ],
  [
    "tripadvisor.com",

    "tripadvisor.at",
    "tripadvisor.be",
    "tripadvisor.ca",
    "tripadvisor.ch",
    "tripadvisor.cl",
    "tripadvisor.co",
    "tripadvisor.co.hu",
    "tripadvisor.co.id",
    "tripadvisor.co.il",
    "tripadvisor.com.ar",
    "tripadvisor.com.au",
    "tripadvisor.com.br",
    "tripadvisor.com.gr",
    "tripadvisor.com.hk",
    "tripadvisor.com.mx",
    "tripadvisor.com.my",
    "tripadvisor.com.pe",
    "tripadvisor.com.ph",
    "tripadvisor.com.sg",
    "tripadvisor.com.tr",
    "tripadvisor.com.tw",
    "tripadvisor.co.nz",
    "tripadvisor.co.uk",
    "tripadvisor.co.za",
    "tripadvisor.de",
    "tripadvisor.dk",
    "tripadvisor.es",
    "tripadvisor.fi",
    "tripadvisor.fr",
    "tripadvisor.ie",
    "tripadvisor.in",
    "tripadvisor.it",
    "tripadvisor.jp",
    "tripadvisor.nl",
    "tripadvisor.pt",
    "tripadvisor.ru",
    "tripadvisor.se",
    "tripadvisor.sk",

    "seatguru.com",

    "jscache.com",
    "tacdn.com",
    "tamgrt.com",
  ],
  [
    "trivago.com",

    "trivago.ae",
    "trivago.at",
    "trivago.be",
    "trivago.bg",
    "trivago.ca",
    "trivago.ch",
    "trivago.cl",
    "trivago.co.id",
    "trivago.co.il",
    "trivago.co.kr",
    "trivago.com.ar",
    "trivago.com.au",
    "trivago.com.br",
    "trivago.com.co",
    "trivago.com.ec",
    "trivago.com.mx",
    "trivago.com.my",
    "trivago.com.ph",
    "trivago.com.tr",
    "trivago.com.tw",
    "trivago.com.uy",
    "trivago.co.nz",
    "trivago.co.th",
    "trivago.co.uk",
    "trivago.co.za",
    "trivago.cz",
    "trivago.de",
    "trivago.dk",
    "trivago.es",
    "trivago.fi",
    "trivago.fr",
    "trivago.gr",
    "trivago.hk",
    "trivago.hr",
    "trivago.hu",
    "trivago.ie",
    "trivago.in",
    "trivago.it",
    "trivago.jp",
    "trivago.nl",
    "trivago.no",
    "trivago.pe",
    "trivago.pl",
    "trivago.pt",
    "trivago.ro",
    "trivago.rs",
    "trivago.ru",
    "trivago.se",
    "trivago.sg",
    "trivago.si",
    "trivago.sk",
    "trivago.vn",
    "youzhan.com",
  ],
  ["trsretire.com", "divinvest.com"],
  ["turbotax.com", "intuit.com"],
  [
    "turkuvazyayin.com.tr",

    "ahaber.com.tr",
    "aspor.com.tr",
    "atv.com.tr",
    "dailysabah.com",
    "fotomac.com.tr",
    "sabah.com.tr",
    "takvim.com.tr",

    "tmgrup.com.tr"
  ],
  [
    "tvn.pl",

    "player.pl",
    "tvn24bis.pl",
    "tvn24.pl",

    "cdntvn.pl",
  ],
  ["tvp.pl", "tvp.info"],
  ["twinkl.co.uk", "twinkl.com", "twinkl.com.au", "twinkl.co.in", "twinkl.de"],
  ["ua2go.com", "ual.com", "united.com", "unitedwifi.com"],
  ["ubisoft.com", "ubi.com", "anno-union.com", "thesettlers-alliance.com", "ubisoftconnect.com"],
  ["ui.com", "ubnt.com"],
  [
    "unitedhealthgroup.com",

    "myprotectwell.com",
    "protectwellapp.com",
    "protectwell.org",
    "uhg.com",
    "unitedhealthgroup.net",
    "unitedhealthgroup.org",
    "weprotectwell.com",

    "healthyourway.com",
    "healthyourwaynow.com",
    "joinatyourbest.com",
    "mypersonalizedsupport.com",
    "myrenewactive.com",
    "mywellbeingsolution.com",
    "optummessenger.co",
    "personalhealthmessagecenter.com",
    "phs.com",
    "pwrfitness.com",
    "takechargeatwork.com",
    "wellnesscoachingnow.com",

    "aarpmedicareplans.com",
    "careimprovementplus.com",
    "health4me.com",
    "healthsafe-id.com",
    "myaarpmedicare.com",
    "myaarpmedicareplans.com",
    "myaarprenew.com",
    "myaarprenewma.com",
    "myaarprenewmapd.com",
    "myaarprenewpdp.com",
    "myaarpsupplementalhealthinsurance.com",
    "mymedicamedicare.com",
    "mymedicareaccount.com",
    "mypcpmedicare.com",
    "myuhc.com",
    "myuhcdental.com",
    "myuhcmedicare.com",
    "uhc.com",
    "uhcmedicaresolutions.com",
    "uhcmycarepath.com",
    "uhcretiree.com",
    "uhcservices.com",
    "yourdentalplan.com",

    "werally.com",

    "liveandworkwell.com",
    "myoptum.com",
    "optum.com",
    "optumrx.com",
    "ppconline.info",
    "ppconlineinfo.com",
    "wellbeing-4life.com",
  ],
  [
    "united-internet.de",

    "1and1.com",
    "1and1.co.uk",
    "1and1.es",
    "1and1.fr",
    "1and1.pl",
    "1und1.de",

    "gmx.at",
    "gmx.ch",
    "gmx.com",
    "gmx.fr",
    "gmx.net",

    "ionos.be",
    "ionos.ca",
    "ionos.ch",
    "ionos.co",
    "ionos.co.id",
    "ionos.com",
    "ionos.com.ar",
    "ionos.com.br",
    "ionos.com.es",
    "ionos.com.pe",
    "ionos.com.ua",
    "ionos.com.ve",
    "ionos.co.uk",
    "ionos.co.za",
    "ionos.de",
    "ionos.dk",
    "ionos.es",
    "ionos.eu",
    "ionos.fr",
    "ionos.id",
    "ionos.in",
    "ionos.info",
    "ionos.is",
    "ionos.it",
    "ionos.li",
    "ionos.me",
    "ionos.mx",
    "ionos.nl",
    "ionos.nz",
    "ionos.ph",
    "ionos.pt",
    "ionos.se",
    "ionos.sg",
    "ionos.uk",
    "ionos.us",
    "ionos.vn",

    "ionos-cloud.be",
    "ionoscloud.be",
    "ionos-cloud.biz",
    "ionoscloud.biz",
    "ionoscloud.ch",
    "ionos-cloud.com",
    "ionoscloud.com",
    "ionos-cloud.co.uk",
    "ionos-cloud.de",
    "ionos-cloud.dk",
    "ionoscloud.dk",
    "ionos-cloud.es",
    "ionos-cloud.eu",
    "ionoscloud.eu",
    "ionos-cloud.fr",
    "ionoscloud.fr",
    "ionos-cloud.info",
    "ionoscloud.info",
    "ionos-cloud.it",
    "ionoscloud.it",
    "ionos-cloud.me",
    "ionoscloud.me",
    "ionos-cloud.net",
    "ionoscloud.net",
    "ionos-cloud.nl",
    "ionoscloud.nl",
    "ionos-cloud.org",
    "ionoscloud.org",
    "ionos-cloud.pl",
    "ionoscloud.pl",
    "ionos-cloud.pt",
    "ionoscloud.pt",
    "ionos-cloud.ro",
    "ionoscloud.ro",
    "ionos-cloud.se",
    "ionoscloud.se",
    "ionos-cloud.uk",
    "ionoscloud.uk",
    "ionos-cloud.us",
    "ionoscloud.us",

    "alturo.de",
    "arsys.net",
    "banner.de",
    "mi-web.es",
    "mywebsite.it",
    "phptools.de",
    "puretec.de",
    "puretech.de",
    "purtec.de",
    "schlund.com",
    "schlund.de",
    "schlund.info",
    "schlund.net",
    "votre-domaine.fr",
    "votredomaine.fr",

    "mail.com",
    "ui-portal.com",
    "ui-portal.de",
    "web.de",

    "1u1s.de",
    "static-1and1.com",
    "uicdn.com",
    "uicdn.net",
    "uimserv.net",
  ],
  [
    "universalmusic.com",

    "taylorswift.com",
    "udiscovermusic.com",

    "umusic.com",
  ],
  ["vanguard.com", "investornews.vanguard", "vanguardblog.com", "vanguardcanada.ca", "vanguardinvestor.co.uk", "vgcontent.info"],
  [
    "verizonmedia.com",

    "verizon.com",
    "verizon.net",
    "verizonwireless.com",
    "vzw.com",

    "aol.com",
    "aolcdn.com",

    "autoblog.com",
    "compuserve.com",
    "engadget.com",
    "oath.com",
    "overture.com",
    "techcrunch.com",
    "yahoo.com",
    "yahoo-leisure.hk",

    "huffpost.com",
    "huffingtonpost.ca",
    "huffingtonpost.com",
    "huffingtonpost.com.au",
    "huffingtonpost.com.mx",
    "huffingtonpost.co.uk",
    "huffingtonpost.co.za",
    "huffingtonpost.de",
    "huffingtonpost.fr",
    "huffingtonpost.gr",
    "huffingtonpost.in",
    "huffingtonpost.jp",
    "huffingtonpost.kr",
    "huffpostarabi.com",
    "huffpostbrasil.com",
    "huffpostmaghreb.com",

    "buzzfeed.com",
    "buzzfeed.bio",
    "buzzfeed.io",
    "buzzfeednews.com",
    "bzfd.bio",
    "contagiousmedia.com",
    "hasbritainlefttheeu.com",
    "tasty.co",
    "worthitweek.com",

    "yahoo.com.tw",

    "yahoo.net",
    "yahooapis.com",
    "yahoodns.net",
    "yahoosandbox.com",
    "yimg.com",
  ],
  [
    "viacomcbs.com",

    "10play.com.au",
    "247sports.com",
    "bet.com",
    "cbs.com",
    "cbsi.com",
    "cbsinteractive.com",
    "cbslocal.com",
    "cbsnews.com",
    "cbssports.com",
    "cc.com",
    "channel5.com",
    "cmt.com",
    "collegesports.com",
    "comedycentral.com",
    "comicbook.com",
    "etonline.com",
    "fansonly.com",
    "insideedition.com",
    "last.fm",
    "maxpreps.com",
    "mtv.com",
    "mtv.co.uk",
    "nick.com",
    "paramountnetwork.com",
    "paramountplus.com",
    "paramountpluswithshowtime.com",
    "pluto.tv",
    "popculture.com",
    "scout.com",
    "search.com",
    "sho.com",
    "southparkstudios.com",
    "sportsline.com",
    "startrek.com",
    "vh1.com",

    "southpark.de",
    "southpark.lat",
    "southparkstudios.com.br",
    "southparkstudios.co.uk",
    "southparkstudios.nu",
    "southparkstudios.se",

    "cbsig.net",
    "cbsimg.net",
    "cbsistatic.com",
    "cbsivideo.com",
    "cbsstatic.com",
    "mtvnservices.com",
    "paramount.com",
    "paramount.tech",
  ],
  ["vimeo.com", "vimeocdn.com"],
  [
    "vinted.com",

    "kleiderkreisel.de",
    "mamikreisel.de",

    "vinted.co.uk",
    "vinted.cz",
    "vinted.de",
    "vinted.es",
    "vinted.fr",
    "vinted.it",
    "vinted.lt",
    "vinted.nl",
    "vinted.pl",
  ],
  [
    "vk.com",

    "mail.ru",
    "sportmail.ru",
    "imgsmail.ru",

    "ok.ru",
    "mycdn.me",
    "odnoklassniki.ru",
    "oklive.app",
    "ok.me",
    "tamtam.chat",
    "tt.me",

    "vk.me",
    "vk.ru",
    "vkontakte.ru",
    "vkplay.live",
    "vkplay.ru",
    "vkvideo.ru",

    "okcdn.ru",
    "vkuser.net",

    "yandex.com",

    "auto.ru",
    "beru.ru",
    "bookmate.ru",
    "bringly.ru",
    "dzen.ru",
    "kinopoisk.ru",
    "mykp.ru",
    "yadi.sk",
    "yandex-team.ru",

    "yandex.net",
    "yastatic.net",

    "yandex.az",
    "yandex.by",
    "yandex.co.il",
    "yandex.com.am",
    "yandex.com.ge",
    "yandex.com.tr",
    "yandex.com.ua",
    "yandex.ee",
    "yandex.eu",
    "yandex.fr",
    "yandex.kg",
    "yandex.kz",
    "yandex.lt",
    "yandex.lv",
    "yandex.md",
    "yandex.ru",
    "yandex.tj",
    "yandex.tm",
    "yandex.ua",
    "yandex.uz",
    "ya.ru",
  ],
  ["vnexpress.net", "ngoisao.net", "vnecdn.net"],
  ["vodafone.com", "vodafone.es", "vodafone.com.tr", "vodafone.co.uk"],
  ["volvooceanrace.com", "virtualregatta.com"],
  ["vonage.com", "vonagebusiness.com"],
  [
    "voxmedia.com",

    "curbed.com",
    "eater.com",
    "grubstreet.com",
    "mmafighting.com",
    "nymag.com",
    "polygon.com",
    "racked.com",
    "recode.net",
    "sbnation.com",
    "thecut.com",
    "theringer.com",
    "theverge.com",
    "thrillist.com",
    "vox.com",
    "vulture.com",

    "vox-cdn.com",
  ],
  [
    "vrt.be",

    "canvas.be",
    "een.be",
    "ketnet.be",
    "klara.be",
    "mnm.be",
    "radio1.be",
    "radio2.be",
    "sporza.be",
    "stubru.be",
  ],
  ["wa.gov", "wsdot.com", "wsdot.gov"],
  [
    "walmart.com",

    "walmartmexico.com",
    "walmartcentroamerica.com",

    "walmart.ca",
    "walmart.com.mx",

    "samsclub.com",
    "sams.com.mx",

    "asda.com",
    "bodegaaurrera.com.mx",

    "w-mt.co",
    "wal.co",
    "walmartimages.com",
    "walmartimages.ca",
  ],
  [
    "thewaltdisneycompany.com",

    "6abc.com",
    "abc10.com",
    "abc11.com",
    "abc13.com",
    "abc30.com",
    "abc7chicago.com",
    "abc7.com",
    "abc7news.com",
    "abc7ny.com",
    "abc.com",
    "abcnews.com",
    "goodmorningamerica.com",

    "go.com",

    "espn.com",
    "espncdn.com",

    "espn.cl",
    "espn.co.cr",
    "espn.com.ar",
    "espn.com.au",
    "espn.com.br",
    "espn.com.co",
    "espn.com.do",
    "espn.com.ec",
    "espn.com.gt",
    "espn.com.mx",
    "espn.com.pa",
    "espn.com.pe",
    "espn.com.sg",
    "espn.com.uy",
    "espn.com.ve",
    "espn.co.uk",
    "espn.es",
    "espn.in",
    "espn.nl",
    "espn.ph",

    "andscape.com",
    "espncricinfo.com",
    "footytips.com.au",
    "secsports.com",

    "espnfc.com",
    "espnfc.us",

    "fivethirtyeight.com",
    "freeform.com",
    "fxnetworks.com",
    "nationalgeographic.com",
    "starplus.com",

    "20thcenturystudios.com",
    "babble.com",
    "d23.com",
    "dadt.com",
    "disneyaccount.com",
    "disneyaulani.com",
    "disneybaby.com",
    "disneygiftcard.com",
    "disneyinteractive.com",
    "disneyinternationalhd.com",
    "disneylandparis.com",
    "disneymovieinsiders.com",
    "disneymoviesanywhere.com",
    "disneynow.com",
    "disneyplus.com",
    "disneyrewards.com",
    "disneystore.com",
    "disneyweddings.com",
    "disneyworld.co.uk",
    "disneyworld.eu",
    "ilm.com",
    "marvel.com",
    "readriordan.com",
    "rundisney.com",
    "shopdisney.com",
    "shopdisney.co.uk",
    "shopdisney.es",
    "shopdisney.fr",
    "skysound.com",
    "starwars.com",

    "disney.asia",
    "disney.be",
    "disney.bg",
    "disney.co.il",
    "disney.co.jp",
    "disney.com",
    "disney.com.au",
    "disney.com.br",
    "disney.com.hk",
    "disney.com.tw",
    "disney.co.th",
    "disney.co.uk",
    "disney.co.za",
    "disney.cz",
    "disney.de",
    "disney.dk",
    "disney.es",
    "disney.fi",
    "disney.fr",
    "disney.gr",
    "disney.hu",
    "disney.id",
    "disney.in",
    "disney.it",
    "disneylatino.com",
    "disneyme.com",
    "disney.my",
    "disney.nl",
    "disney.no",
    "disney.ph",
    "disney.pl",
    "disney.pt",
    "disney.ro",
    "disney.se",
    "disney.sg",
    "disneyturkiye.com.tr",

    "dilcdn.com",
    "disney.io",
    "disney-plus.net",
  ],
  [
    "wargaming.com",
    "wargaming.net",
    "worldoftanks.asia",
    "worldoftanks.com",
    "worldoftanks.eu",
    "worldoftanks.kr",
    "worldoftanks.ru",
    "worldofwarplanes.com",
    "worldofwarplanes.eu",
    "worldofwarplanes.ru",
    "worldofwarships.com",
    "worldofwarships.eu",
    "worldofwarships.ru",
    "wotblitz.com",
  ],
  [
    "warnermediagroup.com",

    "adultswim.com",
    "adventuretime.com",
    "atgamewiz.com",
    "ben10.com",
    "bleacherreport.com",
    "bleacherreportlive.com",
    "br.live",
    "brlive.com",
    "brlive.io",
    "cartoonnetwork.asia",
    "cartoonnetworkasia.com",
    "cartoonnetwork.com",
    "cartoonnetworkhotel.com",
    "cartoonnetworkpr.com",
    "catchsports.com",
    "chasingthecurelive.com",
    "cnn.com",
    "cnn.io",
    "cnnmoney.ch",
    "cnn.net",
    "d2c-ott.com",
    "dc.com",
    "dccomics.com",
    "dcuniverseinfinite.com",
    "d-league.com",
    "e-league.com",
    "eleague.com",
    "eurosport.com",
    "eurosport.de",
    "eurosport.fr",
    "eurosport.it",
    "extratv.com",
    "filmstruck.com",
    "golfdigest.com",
    "greatbig.com",
    "greatbigstory.com",
    "hbo.com",
    "hbogo.com",
    "hbomax.com",
    "hbonow.com",
    "heaveninc.com",
    "hlntv.com",
    "iamthenight.com",
    "juniorrydercup.com",
    "max.com",
    "maxgo.com",
    "nba.com",
    "nba.net",
    "ncaa.com",
    "ngtv.io",
    "oprah.com",
    "pgachampionship.com",
    "pga.com",
    "pga-events.com",
    "pga.net",
    "powerpuffgirls.com",
    "powerpufftheworld.com",
    "robotunicornattack.com",
    "roosterteeth.com",
    "rydercup.com",
    "samanthabee.com",
    "sambee.com",
    "shaqtoons.com",
    "stevenuniverseselfesteem.com",
    "stevenuniversethemovie.com",
    "summercampisland.com",
    "superstation.com",
    "suspensecollection.com",
    "tbs.com",
    "tcm.com",
    "teamcococdn.com",
    "thealienist.com",
    "thesuspensecollection.com",
    "ti-platform.com",
    "tmz.com",
    "tnt.tv",
    "tntdrama.com",
    "tntsports.com.ar",
    "trutv.com",
    "vgtf.net",
    "warnerbros.com",
    "warnerbrosgames.com",
    "warnermedia.com",
    "warnermediafitnation.com",
    "warnermediaready.com",
    "warnermediasupplierdiversity.com",
    "warnermediaupfront.com",
    "wbdndc.net",
    "wbtvd.com",
    "webarebears.com",
    "wnba.com",
    "yzzerdd.com",

    "warnermediacdn.com",

    "turner.com",
    "ugdturner.com",

    "discovery.com",

    "ahctv.com",
    "animalplanet.com",
    "cookingchanneltv.com",
    "destinationamerica.com",
    "discoverylife.com",
    "discoveryplus.com",
    "food.com",
    "foodnetwork.com",
    "hgtv.com",
    "investigationdiscovery.com",
    "motortrend.com",
    "sciencechannel.com",
    "tlc.com",
    "travelchannel.com",

    "sndimg.com",
  ],
  ["wayfair.com", "wayfair.ca", "wayfair.co.uk"],
  [
    "weather.com",
    "wunderground.com",

    "imwx.com",
    "wfxtriggers.com",
    "wsi.com",
    "w-x.co",
    "wxug.com",
  ],
  [
    "webmd.com",

    "emedicinehealth.com",
    "medicinenet.com",
    "medscape.com",
    "medscape.org",
    "onhealth.com",
    "rxlist.com",

    "medscapestatic.com",
  ],
  [
    "webnode.com",

    "webnode.at",
    "webnode.be",
    "webnode.bo",
    "webnode.cl",
    "webnode.com.ar",
    "webnode.com.br",
    "webnode.com.co",
    "webnode.com.py",
    "webnode.com.tr",
    "webnode.com.ua",
    "webnode.com.uy",
    "webnode.com.ve",
    "webnode.co.uk",
    "webnode.cr",
    "webnode.cz",
    "webnode.dk",
    "webnode.do",
    "webnode.ec",
    "webnode.es",
    "webnode.fi",
    "webnode.fr",
    "webnode.gr",
    "webnode.hr",
    "webnode.hu",
    "webnode.in",
    "webnode.it",
    "webnode.jp",
    "webnode.kr",
    "webnode.lv",
    "webnode.mx",
    "webnode.nl",
    "webnode.no",
    "webnode.pe",
    "webnode.pt",
    "webnode.ro",
    "webnode.ru",
    "webnode.se",
    "webnode.sk",
    "webnode.tw",
    "webnode.vn",
  ],
  ["weebly.com", "editmysite.com"],
  [
    "weibo.com",

    "sina.cn",
    "sina.com",
    "sina.com.cn",
    "sinaedge.com",
    "sinaimg.cn",
    "sinaimg.com",
    "sinaimg.com.cn",
    "sinajs.cn",
    "sina.net",
    "wbimg.cn",
    "wbimg.com",
    "wcdn.cn",
    "weibocdn.com",
    "weibo.cn",
    "weibopay.com",
  ],
  ["wellsfargo.com", "wf.com"],
  ["wetter.com", "tiempo.es", "wettercomassets.com"],
  [
    "wikimediafoundation.org",

    "mediawiki.org",
    "wikibooks.org",
    "wikidata.org",
    "wikifunctions.org",
    "wikimedia.org",
    "wikinews.org",
    "wikipedia.org",
    "wikiquote.org",
    "wikisource.org",
    "wikiversity.org",
    "wikivoyage.org",
    "wiktionary.org",
    "tools.wmflabs.org",

    "wmfusercontent.org",
  ],
  [
    "williams-sonomainc.com",

    "pbteen.com",
    "potterybarn.com",
    "potterybarnkids.com",
    "rejuvenation.com",
    "westelm.com",
    "williams-sonoma.com",
  ],
  ["wisconsin.gov", "wi.gov"],
  [
    "wix.com",

    "deviantart.com",
    "deviantart.net",
    "editorx.com",

    "parastorage.com",
    "wixapps.net",
    "wix-code.com",
    "wixmp.com",
    "wixpress.com",
    "wixstatic.com",
  ],
  [
    "wp.pl",

    "abczdrowie.pl",
    "allani.pl",
    "autocentrum.pl",
    "autokult.pl",
    "dobreprogramy.pl",
    "domodi.pl",
    "eholiday.pl",
    "finansowysupermarket.pl",
    "fotoblogia.pl",
    "gadzetomania.pl",
    "homebook.pl",
    "jedenwniosek.pl",
    "komorkomania.pl",
    "money.pl",
    "nocowanie.pl",
    "o2.pl",
    "open.fm",
    "parenting.pl",
    "pudelek.pl",
    "pudelek.tv",
    "totalmoney.pl",
    "wakacje.pl",
    "wawalove.pl",
    "wp.tv",

    "wpcdn.pl",
    "wpimg.pl",
  ],
  ["wpcu.coop", "wpcuonline.com"],
  ["x.com", "twitter.com", "twimg.com", "t.co", "periscope.tv", "pscp.tv"],
  ["xda-developers.com", "xda-cdn.com"],
  ["xfinity.com", "comcast.net", "comcast.com"],
  ["xhamster.com", "xhcdn.com"],
  ["xinhuanet.com", "news.cn"],
  ["yahoo.co.jp", "yimg.jp"],
  ["yomiuri.co.jp", "fujinkoron.jp", "hochi.news"],
  ["yoox.com", "mrporter.com", "theoutnet.com", "yoox.it"],
  [
    "sph.com.sg",

    "sphdigital.com",

    "beritaharian.sg",
    "businesstimes.com.sg",
    "shinmin.sg",
    "straitstimes.com",
    "tabla.com.sg",
    "tamilmurasu.com.sg",
    "tnp.sg",
    "wanbao.com.sg",
    "zaobao.com",
    "zaobao.com.sg",
    "zaobao.sg"
  ],
  ["zendesk.com", "zopim.com"],
  ["zhaopin.com", "zhaopin.cn"],
  ["zillow.com", "zillowstatic.com", "zillowcloud.com", "zg-api.com"],
  [
    "zoho.com",

    "zoho.com.au",
    "zoho.eu",
    "zoho.in",
    "zoho.jp",

    "zohositescontent.com",
    "zohositescontent.com.au",
    "zohositescontent.eu",

    "manageengine.com",
    "qntrl.com",

    "zohocdn.com",
    "zohocorp.com",
    "zohocreator.com",
    "zohopublic.com",
    "zohostatic.com",
  ],
  ["zonealarm.com", "zonelabs.com"],
  ["zoom.us", "zoom.com", "zoomgov.com"],
];

/**
 * Make a data structure for quick lookups of whether two domains are the same first party
 */
function makeDomainLookup(mdfpArray) {
  let out = {},
    arrLength = mdfpArray.length;
  for (let i = 0; i < arrLength; i++) {
    let inner = new Set(mdfpArray[i]);
    for (let domain of inner) {
      out[domain] = inner;
    }
  }
  return out;
}

function makeIsMultiDomainFirstParty(domainLookup) {
  return function (domain1, domain2) {
    if (domain1 in domainLookup) {
      return (domainLookup[domain1].has(domain2));
    }
    return false;
  };
}

let _domainLookup = makeDomainLookup(multiDomainFirstPartiesArray);
/**
 * Check if two domains belong to the same effective first party
 * @param {String} domain1 a base doamin
 * @param {String} domain2 a second base doamin
 *
 * @return boolean true if the domains are the same first party
 */
let isMultiDomainFirstParty = makeIsMultiDomainFirstParty(_domainLookup);

export default {
  isMultiDomainFirstParty,
  makeDomainLookup,
  makeIsMultiDomainFirstParty,
  multiDomainFirstPartiesArray,
};
