        PROGRAM MIK01B
C
C       =============================================================
C       Purpose: This program computes the modified Bessel functions 
C                I0(x), I1(x), K0(x), K1(x), and their derivatives 
C                using subroutine IK01B
C       Input :  x   --- Argument ( x  0 )
C       Output:  BI0 --- I0(x)
C                DI0 --- I0'(x)
C                BI1 --- I1(x)
C                DI1 --- I1'(x)
C                BK0 --- K0(x)
C                DK0 --- K0'(x)
C                BK1 --- K1(x)
C                DK1 --- K1'(x)
C       Example:
C
C         x      I0(x)         I0'(x)        I1(x)         I1'(x)
C       -------------------------------------------------------------
C        1.0   .126607D+01   .565159D+00   .565159D+00   .700907D+00
C       10.0   .281572D+04   .267099D+04   .267099D+04   .254862D+04
C       20.0   .435583D+08   .424550D+08   .424550D+08   .414355D+08
C       30.0   .781672D+12   .768532D+12   .768532D+12   .756055D+12
C       40.0   .148948D+17   .147074D+17   .147074D+17   .145271D+17
C       50.0   .293255D+21   .290308D+21   .290308D+21   .287449D+21
C
C         x      K0(x)         K0'(x)        K1(x)         K1'(x)
C       -------------------------------------------------------------
C        1.0   .421024D+00  -.601907D+00   .601907D+00  -.102293D+01
C       10.0   .177801D-04  -.186488D-04   .186488D-04  -.196449D-04
C       20.0   .574124D-09  -.588306D-09   .588306D-09  -.603539D-09
C       30.0   .213248D-13  -.216773D-13   .216773D-13  -.220474D-13
C       40.0   .839286D-18  -.849713D-18   .849713D-18  -.860529D-18
C       50.0   .341017D-22  -.344410D-22   .344410D-22  -.347905D-22
C       =============================================================
C
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
        WRITE(*,*)'Please enter x '
        READ(*,*)X
        WRITE(*,10)X
        WRITE(*,*)'  x       I0(x)          I0''(x)         I1(x)',
     &            '          I1''(x)'
        WRITE(*,*)'-------------------------------------------',
     &            '----------------------'
        CALL IK01B(X,BI0,DI0,BI1,DI1,BK0,DK0,BK1,DK1)
        WRITE(*,20)X,BI0,DI0,BI1,DI1
        WRITE(*,*)
        WRITE(*,*)'  x       K0(x)          K0''(x)         K1(x)',
     &            '          K1''(x)'
        WRITE(*,*)'-------------------------------------------',
     &            '----------------------'
        WRITE(*,20)X,BK0,DK0,BK1,DK1
10      FORMAT(3x 'x =',F5.1)
20      FORMAT(1X,F4.1,4D15.7)
        END


        SUBROUTINE IK01B(X,BI0,DI0,BI1,DI1,BK0,DK0,BK1,DK1)
C
C       =========================================================
C       Purpose: Compute modified Bessel functions I0(x), I1(1),
C                K0(x) and K1(x), and their derivatives
C       Input :  x   --- Argument ( x  0 )
C       Output:  BI0 --- I0(x)
C                DI0 --- I0'(x)
C                BI1 --- I1(x)
C                DI1 --- I1'(x)
C                BK0 --- K0(x)
C                DK0 --- K0'(x)
C                BK1 --- K1(x)
C                DK1 --- K1'(x)
C       =========================================================
C
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
        IF (X.EQ.0.0D0) THEN
           BI0=1.0D0
           BI1=0.0D0
           BK0=1.0D+300
           BK1=1.0D+300
           DI0=0.0D0
           DI1=0.5D0
           DK0=-1.0D+300
           DK1=-1.0D+300
           RETURN
        ELSE IF (X.LE.3.75D0) THEN
           T=X/3.75D0
           T2=T*T
           BI0=(((((.0045813D0*T2+.0360768D0)*T2+.2659732D0)
     &         *T2+1.2067492D0)*T2+3.0899424D0)*T2
     &         +3.5156229D0)*T2+1.0D0
           BI1=X*((((((.00032411D0*T2+.00301532D0)*T2
     &         +.02658733D0)*T2+.15084934D0)*T2+.51498869D0)
     &         *T2+.87890594D0)*T2+.5D0)
        ELSE
           T=3.75D0/X
           BI0=((((((((.00392377D0*T-.01647633D0)*T
     &         +.02635537D0)*T-.02057706D0)*T+.916281D-2)*T
     &         -.157565D-2)*T+.225319D-2)*T+.01328592D0)*T
     &         +.39894228D0)*DEXP(X)/DSQRT(X)
           BI1=((((((((-.420059D-2*T+.01787654D0)*T
     &         -.02895312D0)*T+.02282967D0)*T-.01031555D0)*T
     &         +.163801D-2)*T-.00362018D0)*T-.03988024D0)*T
     &         +.39894228D0)*DEXP(X)/DSQRT(X)
        ENDIF
        IF (X.LE.2.0D0) THEN
           T=X/2.0D0
           T2=T*T
           BK0=(((((.0000074D0*T2+.0001075D0)*T2+.00262698D0)
     &         *T2+.0348859D0)*T2+.23069756D0)*T2+.4227842D0)
     &         *T2-.57721566D0-BI0*DLOG(T)
           BK1=((((((-.00004686D0*T2-.00110404D0)*T2
     &         -.01919402D0)*T2-.18156897D0)*T2-.67278579D0)
     &         *T2+.15443144D0)*T2+1.0D0)/X+BI1*DLOG(T)
        ELSE
           T=2.0D0/X
           T2=T*T
           BK0=((((((.00053208D0*T-.0025154D0)*T+.00587872D0)
     &         *T-.01062446D0)*T+.02189568D0)*T-.07832358D0)
     &         *T+1.25331414D0)*DEXP(-X)/DSQRT(X)
           BK1=((((((-.00068245D0*T+.00325614D0)*T
     &         -.00780353D0)*T+.01504268D0)*T-.0365562D0)*T+
     &         .23498619D0)*T+1.25331414D0)*DEXP(-X)/DSQRT(X)
        ENDIF
        DI0=BI1
        DI1=BI0-BI1/X
        DK0=-BK1
        DK1=-BK0-BK1/X
        RETURN
        END
