/*
 * Open Surge Engine
 * credits.h - credits scene
 * Copyright 2008-2026 Alexandre Martins <alemartf(at)gmail.com>
 * http://opensurge2d.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _CREDITS_H
#define _CREDITS_H

/* public functions */
void credits_init(void*);
void credits_release();
void credits_update();
void credits_render();

/* generates the credits text and stores it in statically allocated buffers */
void credits_text(const char** base_text, int* assets_argc, const char*** assets_argv);

/* credits text of a mod; returns a statically allocated buffer */
const char* credits_mod_text();

#endif
