/*
 * Copyright (C) by Argonne National Laboratory
 *     See COPYRIGHT in top-level directory
 */
/* This file is automatically generated. DO NOT EDIT. */

#ifndef MPI_ABI_INTERNAL_H_INCLUDED
#define MPI_ABI_INTERNAL_H_INCLUDED

#define MPI_THREAD_SINGLE 0
#define MPI_THREAD_FUNNELED 1024
#define MPI_THREAD_SERIALIZED 2048
#define MPI_THREAD_MULTIPLE 4096

#ifndef MPI_H_ABI
#define MPI_H_ABI

#include <stdint.h>

#if defined(__cplusplus)
extern "C" {
#endif

#define MPI_VERSION    5
#define MPI_SUBVERSION 0

#define MPI_ABI_VERSION    1
#define MPI_ABI_SUBVERSION 0

/* MPI_Aint is defined to be intptr_t (or equivalent to it, if compiler support is absent).
 * The only acceptable alternative to intptr_t is the C89 type equivalent to it. */
#if !defined(MPI_ABI_Aint)
#define MPI_ABI_Aint intptr_t
#endif
typedef MPI_ABI_Aint MPI_Aint;
#undef  MPI_ABI_Aint

/* MPI_Offset will be 64b on all relevant systems.
 * We allow for MPI implementations supporting for 128b filesystems. */
#if !defined(MPI_ABI_Offset)
#define MPI_ABI_Offset int64_t
#endif
typedef MPI_ABI_Offset MPI_Offset;
#undef  MPI_ABI_Offset

/* MPI_Count must be large enough to hold the larger of MPI_Aint and MPI_Offset.
 * Platforms where MPI_Aint is larger than MPI_Offset are extremely rare. */
#if !defined(MPI_ABI_Count)
#define MPI_ABI_Count MPI_Offset
#endif
typedef MPI_ABI_Count MPI_Count;
#undef  MPI_ABI_Count

typedef struct {
    int MPI_SOURCE;
    int MPI_TAG;
    int MPI_ERROR;
    int count_lo;
    int count_hi_and_cancelled;
    int reserved[3];
} MPI_Status;

typedef struct MPI_ABI_Op* ABI_Op;
#define ABI_OP_NULL                    ((ABI_Op)0x00000020)
#define ABI_SUM                        ((ABI_Op)0x00000021)
#define ABI_MIN                        ((ABI_Op)0x00000022)
#define ABI_MAX                        ((ABI_Op)0x00000023)
#define ABI_PROD                       ((ABI_Op)0x00000024)
#define ABI_BAND                       ((ABI_Op)0x00000028)
#define ABI_BOR                        ((ABI_Op)0x00000029)
#define ABI_BXOR                       ((ABI_Op)0x0000002a)
#define ABI_LAND                       ((ABI_Op)0x00000030)
#define ABI_LOR                        ((ABI_Op)0x00000031)
#define ABI_LXOR                       ((ABI_Op)0x00000032)
#define ABI_MINLOC                     ((ABI_Op)0x00000038)
#define ABI_MAXLOC                     ((ABI_Op)0x00000039)
#define ABI_REPLACE                    ((ABI_Op)0x0000003c)
#define ABI_NO_OP                      ((ABI_Op)0x0000003d)

typedef struct MPI_ABI_Comm* ABI_Comm;
#define ABI_COMM_NULL                  ((ABI_Comm)0x00000100)
#define ABI_COMM_WORLD                 ((ABI_Comm)0x00000101)
#define ABI_COMM_SELF                  ((ABI_Comm)0x00000102)

typedef struct MPI_ABI_Group* ABI_Group;
#define ABI_GROUP_NULL                 ((ABI_Group)0x00000108)
#define ABI_GROUP_EMPTY                ((ABI_Group)0x00000109)

typedef struct MPI_ABI_Win* ABI_Win;
#define ABI_WIN_NULL                   ((ABI_Win)0x00000110)

typedef struct MPI_ABI_File* ABI_File;
#define MPI_FILE_NULL                  ((MPI_File)0x00000118)

typedef struct MPI_ABI_Session* ABI_Session;
#define ABI_SESSION_NULL               ((ABI_Session)0x00000120)

typedef struct MPI_ABI_Message* ABI_Message;
#define ABI_MESSAGE_NULL               ((ABI_Message)0x00000128)
#define ABI_MESSAGE_NO_PROC            ((ABI_Message)0x00000129)

typedef struct MPI_ABI_Info* ABI_Info;
#define ABI_INFO_NULL                  ((ABI_Info)0x00000130)
#define ABI_INFO_ENV                   ((ABI_Info)0x00000131)

typedef struct MPI_ABI_Errhandler* ABI_Errhandler;
#define ABI_ERRHANDLER_NULL            ((ABI_Errhandler)0x00000140)
#define ABI_ERRORS_ARE_FATAL           ((ABI_Errhandler)0x00000141)
#define ABI_ERRORS_ABORT               ((ABI_Errhandler)0x00000142)
#define ABI_ERRORS_RETURN              ((ABI_Errhandler)0x00000143)

typedef struct MPI_ABI_Request* ABI_Request;
#define ABI_REQUEST_NULL               ((ABI_Request)0x00000180)

typedef struct MPI_ABI_Datatype* ABI_Datatype;
#define ABI_DATATYPE_NULL              ((ABI_Datatype)0x00000200)
#define ABI_AINT                       ((ABI_Datatype)0x00000201)
#define ABI_COUNT                      ((ABI_Datatype)0x00000202)
#define ABI_OFFSET                     ((ABI_Datatype)0x00000203)
#define ABI_PACKED                     ((ABI_Datatype)0x00000207)
#define ABI_SHORT                      ((ABI_Datatype)0x00000208)
#define ABI_INT                        ((ABI_Datatype)0x00000209)
#define ABI_LONG                       ((ABI_Datatype)0x0000020a)
#define ABI_LONG_LONG                  ((ABI_Datatype)0x0000020b)
#define ABI_LONG_LONG_INT              ABI_LONG_LONG
#define ABI_UNSIGNED_SHORT             ((ABI_Datatype)0x0000020c)
#define ABI_UNSIGNED                   ((ABI_Datatype)0x0000020d)
#define ABI_UNSIGNED_LONG              ((ABI_Datatype)0x0000020e)
#define ABI_UNSIGNED_LONG_LONG         ((ABI_Datatype)0x0000020f)
#define ABI_FLOAT                      ((ABI_Datatype)0x00000210)
#define ABI_C_FLOAT_COMPLEX            ((ABI_Datatype)0x00000212)
#define ABI_C_COMPLEX                  ABI_C_FLOAT_COMPLEX
#define ABI_CXX_FLOAT_COMPLEX          ((ABI_Datatype)0x00000213)
#define ABI_DOUBLE                     ((ABI_Datatype)0x00000214)
#define ABI_C_DOUBLE_COMPLEX           ((ABI_Datatype)0x00000216)
#define ABI_CXX_DOUBLE_COMPLEX         ((ABI_Datatype)0x00000217)
#define ABI_LOGICAL                    ((ABI_Datatype)0x00000218)
#define ABI_INTEGER                    ((ABI_Datatype)0x00000219)
#define ABI_REAL                       ((ABI_Datatype)0x0000021a)
#define ABI_COMPLEX                    ((ABI_Datatype)0x0000021b)
#define ABI_DOUBLE_PRECISION           ((ABI_Datatype)0x0000021c)
#define ABI_DOUBLE_COMPLEX             ((ABI_Datatype)0x0000021d)
#define ABI_CHARACTER                  ((ABI_Datatype)0x0000021e)
#define ABI_LONG_DOUBLE                ((ABI_Datatype)0x00000220)
#define ABI_C_LONG_DOUBLE_COMPLEX      ((ABI_Datatype)0x00000224)
#define ABI_CXX_LONG_DOUBLE_COMPLEX    ((ABI_Datatype)0x00000225)
#define ABI_FLOAT_INT                  ((ABI_Datatype)0x00000228)
#define ABI_DOUBLE_INT                 ((ABI_Datatype)0x00000229)
#define ABI_LONG_INT                   ((ABI_Datatype)0x0000022a)
#define ABI_2INT                       ((ABI_Datatype)0x0000022b)
#define ABI_SHORT_INT                  ((ABI_Datatype)0x0000022c)
#define ABI_LONG_DOUBLE_INT            ((ABI_Datatype)0x0000022d)
#define ABI_2REAL                      ((ABI_Datatype)0x00000230)
#define ABI_2DOUBLE_PRECISION          ((ABI_Datatype)0x00000231)
#define ABI_2INTEGER                   ((ABI_Datatype)0x00000232)
#define ABI_C_BOOL                     ((ABI_Datatype)0x00000238)
#define ABI_CXX_BOOL                   ((ABI_Datatype)0x00000239)
#define ABI_WCHAR                      ((ABI_Datatype)0x0000023c)
#define ABI_INT8_T                     ((ABI_Datatype)0x00000240)
#define ABI_UINT8_T                    ((ABI_Datatype)0x00000241)
#define ABI_CHAR                       ((ABI_Datatype)0x00000243)
#define ABI_SIGNED_CHAR                ((ABI_Datatype)0x00000244)
#define ABI_UNSIGNED_CHAR              ((ABI_Datatype)0x00000245)
#define ABI_BYTE                       ((ABI_Datatype)0x00000247)
#define ABI_INT16_T                    ((ABI_Datatype)0x00000248)
#define ABI_UINT16_T                   ((ABI_Datatype)0x00000249)
#define ABI_INT32_T                    ((ABI_Datatype)0x00000250)
#define ABI_UINT32_T                   ((ABI_Datatype)0x00000251)
#define ABI_INT64_T                    ((ABI_Datatype)0x00000258)
#define ABI_UINT64_T                   ((ABI_Datatype)0x00000259)
#define ABI_LOGICAL1                   ((ABI_Datatype)0x000002c0)
#define ABI_INTEGER1                   ((ABI_Datatype)0x000002c1)
#define ABI_LOGICAL2                   ((ABI_Datatype)0x000002c8)
#define ABI_INTEGER2                   ((ABI_Datatype)0x000002c9)
#define ABI_REAL2                      ((ABI_Datatype)0x000002ca)
#define ABI_LOGICAL4                   ((ABI_Datatype)0x000002d0)
#define ABI_INTEGER4                   ((ABI_Datatype)0x000002d1)
#define ABI_REAL4                      ((ABI_Datatype)0x000002d2)
#define ABI_COMPLEX4                   ((ABI_Datatype)0x000002d3)
#define ABI_LOGICAL8                   ((ABI_Datatype)0x000002d8)
#define ABI_INTEGER8                   ((ABI_Datatype)0x000002d9)
#define ABI_REAL8                      ((ABI_Datatype)0x000002da)
#define ABI_COMPLEX8                   ((ABI_Datatype)0x000002db)
#define ABI_LOGICAL16                  ((ABI_Datatype)0x000002e0)
#define ABI_INTEGER16                  ((ABI_Datatype)0x000002e1)
#define ABI_REAL16                     ((ABI_Datatype)0x000002e2)
#define ABI_COMPLEX16                  ((ABI_Datatype)0x000002e3)
#define ABI_COMPLEX32                  ((ABI_Datatype)0x000002eb)

/* Fortran 1977 Status Size and Indices */
enum {
    MPI_F_STATUS_SIZE                  = 8,
    MPI_F_SOURCE                       = 0,
    MPI_F_TAG                          = 1,
    MPI_F_ERROR                        = 2
};

/* Error Classes */
enum {
    MPI_SUCCESS                        =  0,

    MPI_ERR_BUFFER                     =  1, /* added: MPI-1.0 */
    MPI_ERR_COUNT                      =  2, /* added: MPI-1.0 */
    MPI_ERR_TYPE                       =  3, /* added: MPI-1.0 */
    MPI_ERR_TAG                        =  4, /* added: MPI-1.0 */
    MPI_ERR_COMM                       =  5, /* added: MPI-1.0 */
    MPI_ERR_RANK                       =  6, /* added: MPI-1.0 */
    MPI_ERR_REQUEST                    =  7, /* added: MPI-1.0 */
    MPI_ERR_ROOT                       =  8, /* added: MPI-1.0 */
    MPI_ERR_GROUP                      =  9, /* added: MPI-1.0 */
    MPI_ERR_OP                         = 10, /* added: MPI-1.0 */
    MPI_ERR_TOPOLOGY                   = 11, /* added: MPI-1.0 */
    MPI_ERR_DIMS                       = 12, /* added: MPI-1.0 */
    MPI_ERR_ARG                        = 13, /* added: MPI-1.0 */
    MPI_ERR_UNKNOWN                    = 14, /* added: MPI-1.0 */
    MPI_ERR_TRUNCATE                   = 15, /* added: MPI-1.0 */
    MPI_ERR_OTHER                      = 16, /* added: MPI-1.0 */
    MPI_ERR_INTERN                     = 17, /* added: MPI-1.0 */
    MPI_ERR_PENDING                    = 18, /* added: MPI-1.1 */
    MPI_ERR_IN_STATUS                  = 19, /* added: MPI-1.1 */
    MPI_ERR_ACCESS                     = 20, /* added: MPI-2.0 */
    MPI_ERR_AMODE                      = 21, /* added: MPI-2.0 */
    MPI_ERR_ASSERT                     = 22, /* added: MPI-2.0 */
    MPI_ERR_BAD_FILE                   = 23, /* added: MPI-2.0 */
    MPI_ERR_BASE                       = 24, /* added: MPI-2.0 */
    MPI_ERR_CONVERSION                 = 25, /* added: MPI-2.0 */
    MPI_ERR_DISP                       = 26, /* added: MPI-2.0 */
    MPI_ERR_DUP_DATAREP                = 27, /* added: MPI-2.0 */
    MPI_ERR_FILE_EXISTS                = 28, /* added: MPI-2.0 */
    MPI_ERR_FILE_IN_USE                = 29, /* added: MPI-2.0 */
    MPI_ERR_FILE                       = 30, /* added: MPI-2.0 */
    MPI_ERR_INFO_KEY                   = 31, /* added: MPI-2.0 */
    MPI_ERR_INFO_NOKEY                 = 32, /* added: MPI-2.0 */
    MPI_ERR_INFO_VALUE                 = 33, /* added: MPI-2.0 */
    MPI_ERR_INFO                       = 34, /* added: MPI-2.0 */
    MPI_ERR_IO                         = 35, /* added: MPI-2.0 */
    MPI_ERR_KEYVAL                     = 36, /* added: MPI-2.0 */
    MPI_ERR_LOCKTYPE                   = 37, /* added: MPI-2.0 */
    MPI_ERR_NAME                       = 38, /* added: MPI-2.0 */
    MPI_ERR_NO_MEM                     = 39, /* added: MPI-2.0 */
    MPI_ERR_NOT_SAME                   = 40, /* added: MPI-2.0 */
    MPI_ERR_NO_SPACE                   = 41, /* added: MPI-2.0 */
    MPI_ERR_NO_SUCH_FILE               = 42, /* added: MPI-2.0 */
    MPI_ERR_PORT                       = 43, /* added: MPI-2.0 */
    MPI_ERR_QUOTA                      = 44, /* added: MPI-2.0 */
    MPI_ERR_READ_ONLY                  = 45, /* added: MPI-2.0 */
    MPI_ERR_RMA_ATTACH                 = 46, /* added: MPI-2.0 */
    MPI_ERR_RMA_CONFLICT               = 47, /* added: MPI-2.0 */
    MPI_ERR_RMA_RANGE                  = 48, /* added: MPI-2.0 */
    MPI_ERR_RMA_SHARED                 = 49, /* added: MPI-2.0 */
    MPI_ERR_RMA_SYNC                   = 50, /* added: MPI-2.0 */
    MPI_ERR_SERVICE                    = 51, /* added: MPI-2.0 */
    MPI_ERR_SIZE                       = 52, /* added: MPI-2.0 */
    MPI_ERR_SPAWN                      = 53, /* added: MPI-2.0 */
    MPI_ERR_UNSUPPORTED_DATAREP        = 54, /* added: MPI-2.0 */
    MPI_ERR_UNSUPPORTED_OPERATION      = 55, /* added: MPI-2.0 */
    MPI_ERR_WIN                        = 56, /* added: MPI-2.0 */
    MPI_ERR_RMA_FLAVOR                 = 57, /* added: MPI-3.0 */
    MPI_ERR_PROC_ABORTED               = 58, /* added: MPI-4.0 */
    MPI_ERR_VALUE_TOO_LARGE            = 59, /* added: MPI-4.0 */
    MPI_ERR_SESSION                    = 60, /* added: MPI-4.0 */
    MPI_ERR_ERRHANDLER                 = 61, /* added: MPI-4.1 */
    MPI_ERR_ABI                        = 62, /* added: MPI-5.0 */

    MPI_T_ERR_CANNOT_INIT              = 1001,
    MPI_T_ERR_NOT_ACCESSIBLE           = 1002,
    MPI_T_ERR_NOT_INITIALIZED          = 1003,
    MPI_T_ERR_NOT_SUPPORTED            = 1004,
    MPI_T_ERR_MEMORY                   = 1005,
    MPI_T_ERR_INVALID                  = 1006,
    MPI_T_ERR_INVALID_INDEX            = 1007,
    MPI_T_ERR_INVALID_ITEM             = 1008, /* deprecated: MPI-4.0 */
    MPI_T_ERR_INVALID_SESSION          = 1009,
    MPI_T_ERR_INVALID_HANDLE           = 1010,
    MPI_T_ERR_INVALID_NAME             = 1011,
    MPI_T_ERR_OUT_OF_HANDLES           = 1012,
    MPI_T_ERR_OUT_OF_SESSIONS          = 1013,
    MPI_T_ERR_CVAR_SET_NOT_NOW         = 1014,
    MPI_T_ERR_CVAR_SET_NEVER           = 1015,
    MPI_T_ERR_PVAR_NO_WRITE            = 1016,
    MPI_T_ERR_PVAR_NO_STARTSTOP        = 1017,
    MPI_T_ERR_PVAR_NO_ATOMIC           = 1018,

    MPI_ERR_LASTCODE                   = 0x3fff /* half of the minimum required value of INT_MAX */
};

/* Buffer Address Constants */
#define MPI_BOTTOM                     ((void*)0)
#define MPI_IN_PLACE                   ((void*)1)
#define MPI_BUFFER_AUTOMATIC           ((void*)2)

/* Empty/Ignored Constants */
#define MPI_ARGV_NULL                  ((char**)0)
#define MPI_ARGVS_NULL                 ((char***)0)
#define MPI_ERRCODES_IGNORE            ((int*)0)
#define MPI_STATUS_IGNORE              ((MPI_Status*)0)
#define MPI_STATUSES_IGNORE            ((MPI_Status*)0)
#define MPI_UNWEIGHTED                 ((int*)10)
#define MPI_WEIGHTS_EMPTY              ((int*)11)

/* Maximum Sizes for Strings */
#define MPI_MAX_DATAREP_STRING          128 /* MPICH:  128 - OMPI:  128 */
#define MPI_MAX_ERROR_STRING            512 /* MPICH:  512 - OMPI:  256 */
#define MPI_MAX_INFO_KEY                256 /* MPICH:  255 - OMPI:   36 */
#define MPI_MAX_INFO_VAL               1024 /* MPICH: 1024 - OMPI:  256 */
#define MPI_MAX_LIBRARY_VERSION_STRING 8192 /* MPICH: 8192 - OMPI:  256 */
#define MPI_MAX_OBJECT_NAME             128 /* MPICH:  128 - OMPI:   64 */
#define MPI_MAX_PORT_NAME              1024 /* MPICH:  256 - OMPI: 1024 */
#define MPI_MAX_PROCESSOR_NAME          256 /* MPICH:  128 - OMPI:  256 */
#define MPI_MAX_STRINGTAG_LEN          1024 /* MPICH:  256 - OMPI: 1024 */
#define MPI_MAX_PSET_NAME_LEN          1024 /* MPICH:  256 - OMPI:  512 */
/* Assorted Constants */
#define MPI_BSEND_OVERHEAD              512 /* MPICH:   96 - OMPI:  128 */

/* Mode Constants - must be powers-of-2 to support OR-ing */
enum {
    /* File Open Modes */
    MPI_MODE_APPEND                    = 1,
    MPI_MODE_CREATE                    = 2,
    MPI_MODE_DELETE_ON_CLOSE           = 4,
    MPI_MODE_EXCL                      = 8,
    MPI_MODE_RDONLY                    = 16,
    MPI_MODE_RDWR                      = 32,
    MPI_MODE_SEQUENTIAL                = 64,
    MPI_MODE_UNIQUE_OPEN               = 128,
    MPI_MODE_WRONLY                    = 256,

    /* Window Assertion Modes */
    MPI_MODE_NOCHECK                   = 1024,
    MPI_MODE_NOPRECEDE                 = 2048,
    MPI_MODE_NOPUT                     = 4096,
    MPI_MODE_NOSTORE                   = 8192,
    MPI_MODE_NOSUCCEED                 = 16384
};

enum {
    /* Wildcard values - must be negative */
    MPI_ANY_SOURCE                     = -1,
    MPI_ANY_TAG                        = -2,

    /* Rank sentinels - must be negative */
    MPI_PROC_NULL                      = -3,
    MPI_ROOT                           = -4,

    /* Multi-purpose sentinel - must be negative */
    MPI_UNDEFINED                      = -32766
};

enum {
    /* Thread Support - monotonic values, SINGLE < FUNNELED < SERIALIZED < MULTIPLE. */

    /* Array Datatype Order */
    MPI_ORDER_C                        = 0xC, /* 12 */
    MPI_ORDER_FORTRAN                  = 0xF, /* 15 */

    /* Array Datatype Distribution */
    MPI_DISTRIBUTE_NONE                = 16,
    MPI_DISTRIBUTE_BLOCK               = 17,
    MPI_DISTRIBUTE_CYCLIC              = 18,
    MPI_DISTRIBUTE_DFLT_DARG           = 19,

    /* Datatype Decoding Combiners */
    MPI_COMBINER_NAMED                 = 101,
    MPI_COMBINER_DUP                   = 102,
    MPI_COMBINER_CONTIGUOUS            = 103,
    MPI_COMBINER_VECTOR                = 104,
    MPI_COMBINER_HVECTOR               = 105,
    MPI_COMBINER_INDEXED               = 106,
    MPI_COMBINER_HINDEXED              = 107,
    MPI_COMBINER_INDEXED_BLOCK         = 108,
    MPI_COMBINER_HINDEXED_BLOCK        = 109,
    MPI_COMBINER_STRUCT                = 110,
    MPI_COMBINER_SUBARRAY              = 111,
    MPI_COMBINER_DARRAY                = 112,
    MPI_COMBINER_F90_REAL              = 113,
    MPI_COMBINER_F90_COMPLEX           = 114,
    MPI_COMBINER_F90_INTEGER           = 115,
    MPI_COMBINER_RESIZED               = 116,
    MPI_COMBINER_VALUE_INDEX           = 117,

    /* Fortran Datatype Matching */
    MPIX_TYPECLASS_LOGICAL             = 191,
    MPI_TYPECLASS_INTEGER              = 192,
    MPI_TYPECLASS_REAL                 = 193,
    MPI_TYPECLASS_COMPLEX              = 194,

    /* Communicator and Group Comparisons */
    MPI_IDENT                          = 201,
    MPI_CONGRUENT                      = 202,
    MPI_SIMILAR                        = 203,
    MPI_UNEQUAL                        = 204,

    /* Communicator Virtual Topology Types */
    MPI_CART                           = 211,
    MPI_GRAPH                          = 212,
    MPI_DIST_GRAPH                     = 213,

    /* Communicator Split Types */
    MPI_COMM_TYPE_SHARED               = 221,
    MPI_COMM_TYPE_HW_UNGUIDED          = 222,
    MPI_COMM_TYPE_HW_GUIDED            = 223,
    MPI_COMM_TYPE_RESOURCE_GUIDED      = 224,

    /* Window Lock Types */
    MPI_LOCK_EXCLUSIVE                 = 301,
    MPI_LOCK_SHARED                    = 302,

    /* Window Create Flavors */
    MPI_WIN_FLAVOR_CREATE              = 311,
    MPI_WIN_FLAVOR_ALLOCATE            = 312,
    MPI_WIN_FLAVOR_DYNAMIC             = 313,
    MPI_WIN_FLAVOR_SHARED              = 314,

    /* Window Memory Models */
    MPI_WIN_UNIFIED                    = 321,
    MPI_WIN_SEPARATE                   = 322,

    /* File Positioning */
    MPI_SEEK_CUR                       = 401,
    MPI_SEEK_END                       = 402,
    MPI_SEEK_SET                       = 403
};

/* File Operation Constants */
#define MPI_DISPLACEMENT_CURRENT       ((MPI_Offset)-1)

/* Predefined Attribute Keys */
enum {
    /* Invalid Attribute Key */
    ABI_KEYVAL_INVALID                 = 0,

    /* Communicator */
    ABI_TAG_UB                         = 501,
    ABI_IO                             = 502,
    ABI_HOST                           = 503, /* deprecated: MPI-4.1 */
    ABI_WTIME_IS_GLOBAL                = 504,
    ABI_APPNUM                         = 505,
    ABI_LASTUSEDCODE                   = 506,
    ABI_UNIVERSE_SIZE                  = 507,

    /* Window */
    ABI_WIN_BASE                       = 601,
    ABI_WIN_DISP_UNIT                  = 602,
    ABI_WIN_SIZE                       = 603,
    ABI_WIN_CREATE_FLAVOR              = 604,
    ABI_WIN_MODEL                      = 605
};

typedef void (MPI_User_function)(void *invec, void *inoutvec, int *len, ABI_Datatype *datatype);
typedef void (MPI_User_function_c)(void *invec, void *inoutvec, MPI_Count *len, ABI_Datatype *datatype);
typedef void (MPIX_User_function_x) ( void *invec, void *inoutvec, MPI_Count count, ABI_Datatype datatype, void *extra_state);

typedef int (MPI_Grequest_query_function)(void *extra_state, MPI_Status *status);
typedef int (MPI_Grequest_free_function)(void *extra_state);
typedef int (MPI_Grequest_cancel_function)(void *extra_state, int complete);

typedef int (MPI_Copy_function)(ABI_Comm comm, int keyval, void *extra_state, void *attribute_val_in, void *attribute_val_out, int *flag); /* deprecated: MPI-2.0 */
typedef int (MPI_Delete_function)(ABI_Comm omm, int keyval, void *attribute_val, void *extra_state); /* deprecated: MPI-2.0 */
typedef int (MPI_Comm_copy_attr_function)(ABI_Comm comm, int keyval, void *extra_state, void *attribute_val_in, void *attribute_val_out, int *flag);
typedef int (MPI_Comm_delete_attr_function)(ABI_Comm comm, int keyval, void *attribute_val, void *extra_state);
typedef int (MPI_Type_copy_attr_function)(ABI_Datatype datatype, int keyval, void *extra_state, void *attribute_val_in, void *attribute_val_out, int *flag);
typedef int (MPI_Type_delete_attr_function)(ABI_Datatype datatype, int keyval, void *attribute_val, void *extra_state);
typedef int (MPI_Win_copy_attr_function)(ABI_Win win, int keyval, void *extra_state, void *attribute_val_in, void *attribute_val_out, int *flag);
typedef int (MPI_Win_delete_attr_function)(ABI_Win win, int keyval, void *attribute_val, void *extra_state);

typedef int (MPI_Datarep_extent_function)(ABI_Datatype datatype, MPI_Aint *extent, void *extra_state);
typedef int (MPI_Datarep_conversion_function)(void *userbuf, ABI_Datatype datatype, int count, void *filebuf, MPI_Offset position, void *extra_state);
typedef int (MPI_Datarep_conversion_function_c)(void *userbuf, ABI_Datatype datatype, MPI_Count count, void *filebuf, MPI_Offset position, void *extra_state);

typedef void (MPI_Comm_errhandler_function)(ABI_Comm *comm, int *error_code, ...);
typedef void (MPI_File_errhandler_function)(ABI_File *file, int *error_code, ...);
typedef void (MPI_Win_errhandler_function)(ABI_Win *win, int *error_code, ...);
typedef void (MPI_Session_errhandler_function)(ABI_Session *session, int *error_code, ...);

typedef void (MPIX_Comm_errhandler_function_x)(ABI_Comm comm, int error_code, void *extra_state);
typedef void (MPIX_File_errhandler_function_x)(ABI_File file, int error_code, void *extra_state);
typedef void (MPIX_Win_errhandler_function_x)(ABI_Win win, int error_code, void *extra_state);
typedef void (MPIX_Session_errhandler_function_x)(ABI_Session session, int error_code, void *extra_state);

typedef MPI_Comm_errhandler_function MPI_Comm_errhandler_fn;
typedef MPI_File_errhandler_function MPI_File_errhandler_fn;
typedef MPI_Win_errhandler_function MPI_Win_errhandler_fn;
typedef MPI_Session_errhandler_function MPI_Session_errhandler_fn;

typedef void (MPIX_Destructor_function) (void *extra_state);

#define MPI_NULL_COPY_FN               ((MPI_Copy_function*)0x0) /* deprecated: MPI-2.0 */
#define MPI_DUP_FN                     ((MPI_Copy_function*)0x1) /* deprecated: MPI-2.0 */
#define MPI_NULL_DELETE_FN             ((MPI_Delete_function*)0x0) /* deprecated: MPI-2.0 */
#define MPI_COMM_NULL_COPY_FN          ((MPI_Comm_copy_attr_function*)0x0)
#define MPI_COMM_DUP_FN                ((MPI_Comm_copy_attr_function*)0x1)
#define MPI_COMM_NULL_DELETE_FN        ((MPI_Comm_delete_attr_function*)0x0)
#define MPI_TYPE_NULL_COPY_FN          ((MPI_Type_copy_attr_function*)0x0)
#define MPI_TYPE_DUP_FN                ((MPI_Type_copy_attr_function*)0x1)
#define MPI_TYPE_NULL_DELETE_FN        ((MPI_Type_delete_attr_function*)0x0)
#define MPI_WIN_NULL_COPY_FN           ((MPI_Win_copy_attr_function*)0x0)
#define MPI_WIN_DUP_FN                 ((MPI_Win_copy_attr_function*)0x1)
#define MPI_WIN_NULL_DELETE_FN         ((MPI_Win_delete_attr_function*)0x0)
#define MPI_CONVERSION_FN_NULL         ((MPI_Datarep_conversion_function*)0x0)
#define MPI_CONVERSION_FN_NULL_C       ((MPI_Datarep_conversion_function_c*)0x0)

/* MPI_T types and constants */

typedef struct MPIR_T_enum_s *MPI_T_enum;
typedef struct MPIR_T_cvar_handle_s *MPI_T_cvar_handle;
typedef struct MPIR_T_pvar_handle_s *MPI_T_pvar_handle;
typedef struct MPIR_T_pvar_session_s *MPI_T_pvar_session;
typedef struct MPIR_T_event_registration_s *MPI_T_event_registration;
typedef struct MPIR_T_event_instance_s *MPI_T_event_instance;

#define MPI_T_ENUM_NULL                ((MPI_T_enum)0)
#define MPI_T_CVAR_HANDLE_NULL         ((MPI_T_cvar_handle)0)
#define MPI_T_PVAR_SESSION_NULL        ((MPI_T_pvar_session)0)
#define MPI_T_PVAR_HANDLE_NULL         ((MPI_T_pvar_handle)0)
#define MPI_T_PVAR_ALL_HANDLES         ((MPI_T_pvar_handle)1)

typedef enum  MPI_T_cb_safety {
    MPI_T_CB_REQUIRE_NONE              = 0x00,
    MPI_T_CB_REQUIRE_MPI_RESTRICTED    = 0x03,
    MPI_T_CB_REQUIRE_THREAD_SAFE       = 0x0F,
    MPI_T_CB_REQUIRE_ASYNC_SIGNAL_SAFE = 0x3F
} MPI_T_cb_safety;

typedef enum MPI_T_source_order {
    MPI_T_SOURCE_ORDERED               = 1,
    MPI_T_SOURCE_UNORDERED             = 2
} MPI_T_source_order;

enum {
    MPI_T_VERBOSITY_USER_BASIC         = 0x09,
    MPI_T_VERBOSITY_USER_DETAIL        = 0x0a,
    MPI_T_VERBOSITY_USER_ALL           = 0x0c,
    MPI_T_VERBOSITY_TUNER_BASIC        = 0x11,
    MPI_T_VERBOSITY_TUNER_DETAIL       = 0x12,
    MPI_T_VERBOSITY_TUNER_ALL          = 0x14,
    MPI_T_VERBOSITY_MPIDEV_BASIC       = 0x21,
    MPI_T_VERBOSITY_MPIDEV_DETAIL      = 0x22,
    MPI_T_VERBOSITY_MPIDEV_ALL         = 0x24
};

enum {
    MPI_T_BIND_NO_OBJECT               = 1,
    MPI_T_BIND_MPI_COMM                = 2,
    MPI_T_BIND_MPI_DATATYPE            = 3,
    MPI_T_BIND_MPI_ERRHANDLER          = 4,
    MPI_T_BIND_MPI_FILE                = 5,
    MPI_T_BIND_MPI_GROUP               = 6,
    MPI_T_BIND_MPI_OP                  = 7,
    MPI_T_BIND_MPI_REQUEST             = 8,
    MPI_T_BIND_MPI_WIN                 = 9,
    MPI_T_BIND_MPI_MESSAGE             = 10,
    MPI_T_BIND_MPI_INFO                = 11,
    MPI_T_BIND_MPI_SESSION             = 12
};

enum {
    MPI_T_SCOPE_CONSTANT               = 1,
    MPI_T_SCOPE_READONLY               = 2,
    MPI_T_SCOPE_LOCAL                  = 3,
    MPI_T_SCOPE_GROUP                  = 4,
    MPI_T_SCOPE_GROUP_EQ               = 5,
    MPI_T_SCOPE_ALL                    = 6,
    MPI_T_SCOPE_ALL_EQ                 = 7
};

enum {
    MPI_T_PVAR_CLASS_STATE             =  1,
    MPI_T_PVAR_CLASS_LEVEL             =  2,
    MPI_T_PVAR_CLASS_SIZE              =  3,
    MPI_T_PVAR_CLASS_PERCENTAGE        =  4,
    MPI_T_PVAR_CLASS_HIGHWATERMARK     =  5,
    MPI_T_PVAR_CLASS_LOWWATERMARK      =  6,
    MPI_T_PVAR_CLASS_COUNTER           =  7,
    MPI_T_PVAR_CLASS_AGGREGATE         =  8,
    MPI_T_PVAR_CLASS_TIMER             =  9,
    MPI_T_PVAR_CLASS_GENERIC           =  10
};

typedef void (MPI_T_event_cb_function)(MPI_T_event_instance event_instance, MPI_T_event_registration event_registration, MPI_T_cb_safety cb_safety, void *user_data);
typedef void (MPI_T_event_free_cb_function)(MPI_T_event_registration event_registration, MPI_T_cb_safety cb_safety, void *user_data);
typedef void (MPI_T_event_dropped_cb_function)(MPI_Count count, MPI_T_event_registration event_registration, int source_index, MPI_T_cb_safety cb_safety, void *user_data);

/* MPI functions */
int MPI_Abi_get_fortran_booleans(int logical_size, void *logical_true, void *logical_false, int *is_set) MPICH_API_PUBLIC;
int MPI_Abi_get_fortran_info(ABI_Info *info) MPICH_API_PUBLIC;
int MPI_Abi_get_info(ABI_Info *info) MPICH_API_PUBLIC;
int MPI_Abi_get_version(int *abi_major, int *abi_minor) MPICH_API_PUBLIC;
int MPI_Abi_set_fortran_booleans(int logical_size, void *logical_true, void *logical_false) MPICH_API_PUBLIC;
int MPI_Abi_set_fortran_info(ABI_Info info) MPICH_API_PUBLIC;
int MPI_Abort(ABI_Comm comm, int errorcode) MPICH_API_PUBLIC;
int MPI_Accumulate(const void *origin_addr, int origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, int target_count, ABI_Datatype target_datatype, ABI_Op op, ABI_Win win) MPICH_API_PUBLIC;
int MPI_Accumulate_c(const void *origin_addr, MPI_Count origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, MPI_Count target_count, ABI_Datatype target_datatype, ABI_Op op, ABI_Win win) MPICH_API_PUBLIC;
int MPI_Add_error_class(int *errorclass) MPICH_API_PUBLIC;
int MPI_Add_error_code(int errorclass, int *errorcode) MPICH_API_PUBLIC;
int MPI_Add_error_string(int errorcode, const char *string) MPICH_API_PUBLIC;
int MPI_Allgather(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Allgather_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Allgather_init(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Allgather_init_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Allgatherv(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int displs[], ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Allgatherv_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint displs[], ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Allgatherv_init(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int displs[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Allgatherv_init_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint displs[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Alloc_mem(MPI_Aint size, ABI_Info info, void *baseptr) MPICH_API_PUBLIC;
int MPI_Allreduce(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Allreduce_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Allreduce_init(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Allreduce_init_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Alltoall(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Alltoall_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Alltoall_init(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Alltoall_init_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Alltoallv(const void *sendbuf, const int sendcounts[], const int sdispls[], ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int rdispls[], ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Alltoallv_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Alltoallv_init(const void *sendbuf, const int sendcounts[], const int sdispls[], ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int rdispls[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Alltoallv_init_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Alltoallw(const void *sendbuf, const int sendcounts[], const int sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const int recvcounts[], const int rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Alltoallw_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Alltoallw_init(const void *sendbuf, const int sendcounts[], const int sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const int recvcounts[], const int rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Alltoallw_init_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Attr_delete(ABI_Comm comm, int keyval) MPICH_API_PUBLIC;
int MPI_Attr_get(ABI_Comm comm, int keyval, void *attribute_val, int *flag) MPICH_API_PUBLIC;
int MPI_Attr_put(ABI_Comm comm, int keyval, void *attribute_val) MPICH_API_PUBLIC;
int MPI_Barrier(ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Barrier_init(ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Bcast(void *buffer, int count, ABI_Datatype datatype, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Bcast_c(void *buffer, MPI_Count count, ABI_Datatype datatype, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Bcast_init(void *buffer, int count, ABI_Datatype datatype, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Bcast_init_c(void *buffer, MPI_Count count, ABI_Datatype datatype, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Bsend(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Bsend_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Bsend_init(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Bsend_init_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Buffer_attach(void *buffer, int size) MPICH_API_PUBLIC;
int MPI_Buffer_attach_c(void *buffer, MPI_Count size) MPICH_API_PUBLIC;
int MPI_Buffer_detach(void *buffer_addr, int *size) MPICH_API_PUBLIC;
int MPI_Buffer_detach_c(void *buffer_addr, MPI_Count *size) MPICH_API_PUBLIC;
int MPI_Buffer_flush(void) MPICH_API_PUBLIC;
int MPI_Buffer_iflush(ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Cancel(ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Cart_coords(ABI_Comm comm, int rank, int maxdims, int coords[]) MPICH_API_PUBLIC;
int MPI_Cart_create(ABI_Comm comm_old, int ndims, const int dims[], const int periods[], int reorder, ABI_Comm *comm_cart) MPICH_API_PUBLIC;
int MPI_Cart_get(ABI_Comm comm, int maxdims, int dims[], int periods[], int coords[]) MPICH_API_PUBLIC;
int MPI_Cart_map(ABI_Comm comm, int ndims, const int dims[], const int periods[], int *newrank) MPICH_API_PUBLIC;
int MPI_Cart_rank(ABI_Comm comm, const int coords[], int *rank) MPICH_API_PUBLIC;
int MPI_Cart_shift(ABI_Comm comm, int direction, int disp, int *rank_source, int *rank_dest) MPICH_API_PUBLIC;
int MPI_Cart_sub(ABI_Comm comm, const int remain_dims[], ABI_Comm *newcomm) MPICH_API_PUBLIC;
int MPI_Cartdim_get(ABI_Comm comm, int *ndims) MPICH_API_PUBLIC;
int MPI_Close_port(const char *port_name) MPICH_API_PUBLIC;
int MPI_Comm_accept(const char *port_name, ABI_Info info, int root, ABI_Comm comm, ABI_Comm *newcomm) MPICH_API_PUBLIC;
int MPI_Comm_attach_buffer(ABI_Comm comm, void *buffer, int size) MPICH_API_PUBLIC;
int MPI_Comm_attach_buffer_c(ABI_Comm comm, void *buffer, MPI_Count size) MPICH_API_PUBLIC;
int MPI_Comm_call_errhandler(ABI_Comm comm, int errorcode) MPICH_API_PUBLIC;
int MPI_Comm_compare(ABI_Comm comm1, ABI_Comm comm2, int *result) MPICH_API_PUBLIC;
int MPI_Comm_connect(const char *port_name, ABI_Info info, int root, ABI_Comm comm, ABI_Comm *newcomm) MPICH_API_PUBLIC;
int MPI_Comm_create(ABI_Comm comm, ABI_Group group, ABI_Comm *newcomm) MPICH_API_PUBLIC;
int MPI_Comm_create_errhandler(MPI_Comm_errhandler_function *comm_errhandler_fn, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int MPIX_Comm_create_errhandler_x(MPIX_Comm_errhandler_function_x *comm_errhandler_fn_x, MPIX_Destructor_function *destructor_fn, void *extra_state, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int MPI_Comm_create_from_group(ABI_Group group, const char *stringtag, ABI_Info info, ABI_Errhandler errhandler, ABI_Comm *newcomm) MPICH_API_PUBLIC;
int MPI_Comm_create_group(ABI_Comm comm, ABI_Group group, int tag, ABI_Comm *newcomm) MPICH_API_PUBLIC;
int MPI_Comm_create_keyval(MPI_Comm_copy_attr_function *comm_copy_attr_fn, MPI_Comm_delete_attr_function *comm_delete_attr_fn, int *comm_keyval, void *extra_state) MPICH_API_PUBLIC;
int MPI_Comm_delete_attr(ABI_Comm comm, int comm_keyval) MPICH_API_PUBLIC;
int MPI_Comm_detach_buffer(ABI_Comm comm, void *buffer_addr, int *size) MPICH_API_PUBLIC;
int MPI_Comm_detach_buffer_c(ABI_Comm comm, void *buffer_addr, MPI_Count *size) MPICH_API_PUBLIC;
int MPI_Comm_disconnect(ABI_Comm *comm) MPICH_API_PUBLIC;
int MPI_Comm_dup(ABI_Comm comm, ABI_Comm *newcomm) MPICH_API_PUBLIC;
int MPI_Comm_dup_with_info(ABI_Comm comm, ABI_Info info, ABI_Comm *newcomm) MPICH_API_PUBLIC;
int MPI_Comm_flush_buffer(ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Comm_free(ABI_Comm *comm) MPICH_API_PUBLIC;
int MPI_Comm_free_keyval(int *comm_keyval) MPICH_API_PUBLIC;
int MPI_Comm_get_attr(ABI_Comm comm, int comm_keyval, void *attribute_val, int *flag) MPICH_API_PUBLIC;
int MPI_Comm_get_errhandler(ABI_Comm comm, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int MPI_Comm_get_info(ABI_Comm comm, ABI_Info *info_used) MPICH_API_PUBLIC;
int MPI_Comm_get_name(ABI_Comm comm, char *comm_name, int *resultlen) MPICH_API_PUBLIC;
int MPI_Comm_get_parent(ABI_Comm *parent) MPICH_API_PUBLIC;
int MPI_Comm_group(ABI_Comm comm, ABI_Group *group) MPICH_API_PUBLIC;
int MPI_Comm_idup(ABI_Comm comm, ABI_Comm *newcomm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Comm_idup_with_info(ABI_Comm comm, ABI_Info info, ABI_Comm *newcomm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Comm_iflush_buffer(ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Comm_join(int fd, ABI_Comm *intercomm) MPICH_API_PUBLIC;
int MPI_Comm_rank(ABI_Comm comm, int *rank) MPICH_API_PUBLIC;
int MPI_Comm_remote_group(ABI_Comm comm, ABI_Group *group) MPICH_API_PUBLIC;
int MPI_Comm_remote_size(ABI_Comm comm, int *size) MPICH_API_PUBLIC;
int MPI_Comm_set_attr(ABI_Comm comm, int comm_keyval, void *attribute_val) MPICH_API_PUBLIC;
int MPI_Comm_set_errhandler(ABI_Comm comm, ABI_Errhandler errhandler) MPICH_API_PUBLIC;
int MPI_Comm_set_info(ABI_Comm comm, ABI_Info info) MPICH_API_PUBLIC;
int MPI_Comm_set_name(ABI_Comm comm, const char *comm_name) MPICH_API_PUBLIC;
int MPI_Comm_size(ABI_Comm comm, int *size) MPICH_API_PUBLIC;
int MPI_Comm_spawn(const char *command, char *argv[], int maxprocs, ABI_Info info, int root, ABI_Comm comm, ABI_Comm *intercomm, int array_of_errcodes[]) MPICH_API_PUBLIC;
int MPI_Comm_spawn_multiple(int count, char *array_of_commands[], char **array_of_argv[], const int array_of_maxprocs[], const ABI_Info array_of_info[], int root, ABI_Comm comm, ABI_Comm *intercomm, int array_of_errcodes[]) MPICH_API_PUBLIC;
int MPI_Comm_split(ABI_Comm comm, int color, int key, ABI_Comm *newcomm) MPICH_API_PUBLIC;
int MPI_Comm_split_type(ABI_Comm comm, int split_type, int key, ABI_Info info, ABI_Comm *newcomm) MPICH_API_PUBLIC;
int MPI_Comm_test_inter(ABI_Comm comm, int *flag) MPICH_API_PUBLIC;
int MPI_Compare_and_swap(const void *origin_addr, const void *compare_addr, void *result_addr, ABI_Datatype datatype, int target_rank, MPI_Aint target_disp, ABI_Win win) MPICH_API_PUBLIC;
int MPI_Dims_create(int nnodes, int ndims, int dims[]) MPICH_API_PUBLIC;
int MPI_Dist_graph_create(ABI_Comm comm_old, int n, const int sources[], const int degrees[], const int destinations[], const int *weights, ABI_Info info, int reorder, ABI_Comm *comm_dist_graph) MPICH_API_PUBLIC;
int MPI_Dist_graph_create_adjacent(ABI_Comm comm_old, int indegree, const int sources[], const int *sourceweights, int outdegree, const int destinations[], const int *destweights, ABI_Info info, int reorder, ABI_Comm *comm_dist_graph) MPICH_API_PUBLIC;
int MPI_Dist_graph_neighbors(ABI_Comm comm, int maxindegree, int sources[], int *sourceweights, int maxoutdegree, int destinations[], int *destweights) MPICH_API_PUBLIC;
int MPI_Dist_graph_neighbors_count(ABI_Comm comm, int *indegree, int *outdegree, int *weighted) MPICH_API_PUBLIC;
int MPI_Errhandler_free(ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int MPI_Error_class(int errorcode, int *errorclass) MPICH_API_PUBLIC;
int MPI_Error_string(int errorcode, char *string, int *resultlen) MPICH_API_PUBLIC;
int MPI_Exscan(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Exscan_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Exscan_init(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Exscan_init_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Fetch_and_op(const void *origin_addr, void *result_addr, ABI_Datatype datatype, int target_rank, MPI_Aint target_disp, ABI_Op op, ABI_Win win) MPICH_API_PUBLIC;
int MPI_File_call_errhandler(ABI_File fh, int errorcode) MPICH_API_PUBLIC;
int MPI_File_close(ABI_File *fh) MPICH_API_PUBLIC;
int MPI_File_create_errhandler(MPI_File_errhandler_function *file_errhandler_fn, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int MPIX_File_create_errhandler_x(MPIX_File_errhandler_function_x *comm_errhandler_fn_x, MPIX_Destructor_function *destructor_fn, void *extra_state, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int MPI_File_delete(const char *filename, ABI_Info info) MPICH_API_PUBLIC;
int MPI_File_get_amode(ABI_File fh, int *amode) MPICH_API_PUBLIC;
int MPI_File_get_atomicity(ABI_File fh, int *flag) MPICH_API_PUBLIC;
int MPI_File_get_byte_offset(ABI_File fh, MPI_Offset offset, MPI_Offset *disp) MPICH_API_PUBLIC;
int MPI_File_get_errhandler(ABI_File file, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int MPI_File_get_group(ABI_File fh, ABI_Group *group) MPICH_API_PUBLIC;
int MPI_File_get_info(ABI_File fh, ABI_Info *info_used) MPICH_API_PUBLIC;
int MPI_File_get_position(ABI_File fh, MPI_Offset *offset) MPICH_API_PUBLIC;
int MPI_File_get_position_shared(ABI_File fh, MPI_Offset *offset) MPICH_API_PUBLIC;
int MPI_File_get_size(ABI_File fh, MPI_Offset *size) MPICH_API_PUBLIC;
int MPI_File_get_type_extent(ABI_File fh, ABI_Datatype datatype, MPI_Aint *extent) MPICH_API_PUBLIC;
int MPI_File_get_type_extent_c(ABI_File fh, ABI_Datatype datatype, MPI_Count *extent) MPICH_API_PUBLIC;
int MPI_File_get_view(ABI_File fh, MPI_Offset *disp, ABI_Datatype *etype, ABI_Datatype *filetype, char *datarep) MPICH_API_PUBLIC;
int MPI_File_iread(ABI_File fh, void *buf, int count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_File_iread_c(ABI_File fh, void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_File_iread_all(ABI_File fh, void *buf, int count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_File_iread_all_c(ABI_File fh, void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_File_iread_at(ABI_File fh, MPI_Offset offset, void *buf, int count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_File_iread_at_c(ABI_File fh, MPI_Offset offset, void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_File_iread_at_all(ABI_File fh, MPI_Offset offset, void *buf, int count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_File_iread_at_all_c(ABI_File fh, MPI_Offset offset, void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_File_iread_shared(ABI_File fh, void *buf, int count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_File_iread_shared_c(ABI_File fh, void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_File_iwrite(ABI_File fh, const void *buf, int count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_File_iwrite_c(ABI_File fh, const void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_File_iwrite_all(ABI_File fh, const void *buf, int count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_File_iwrite_all_c(ABI_File fh, const void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_File_iwrite_at(ABI_File fh, MPI_Offset offset, const void *buf, int count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_File_iwrite_at_c(ABI_File fh, MPI_Offset offset, const void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_File_iwrite_at_all(ABI_File fh, MPI_Offset offset, const void *buf, int count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_File_iwrite_at_all_c(ABI_File fh, MPI_Offset offset, const void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_File_iwrite_shared(ABI_File fh, const void *buf, int count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_File_iwrite_shared_c(ABI_File fh, const void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_File_open(ABI_Comm comm, const char *filename, int amode, ABI_Info info, ABI_File *fh) MPICH_API_PUBLIC;
int MPI_File_preallocate(ABI_File fh, MPI_Offset size) MPICH_API_PUBLIC;
int MPI_File_read(ABI_File fh, void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_read_c(ABI_File fh, void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_read_all(ABI_File fh, void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_read_all_c(ABI_File fh, void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_read_all_begin(ABI_File fh, void *buf, int count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int MPI_File_read_all_begin_c(ABI_File fh, void *buf, MPI_Count count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int MPI_File_read_all_end(ABI_File fh, void *buf, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_read_at(ABI_File fh, MPI_Offset offset, void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_read_at_c(ABI_File fh, MPI_Offset offset, void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_read_at_all(ABI_File fh, MPI_Offset offset, void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_read_at_all_c(ABI_File fh, MPI_Offset offset, void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_read_at_all_begin(ABI_File fh, MPI_Offset offset, void *buf, int count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int MPI_File_read_at_all_begin_c(ABI_File fh, MPI_Offset offset, void *buf, MPI_Count count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int MPI_File_read_at_all_end(ABI_File fh, void *buf, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_read_ordered(ABI_File fh, void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_read_ordered_c(ABI_File fh, void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_read_ordered_begin(ABI_File fh, void *buf, int count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int MPI_File_read_ordered_begin_c(ABI_File fh, void *buf, MPI_Count count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int MPI_File_read_ordered_end(ABI_File fh, void *buf, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_read_shared(ABI_File fh, void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_read_shared_c(ABI_File fh, void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_seek(ABI_File fh, MPI_Offset offset, int whence) MPICH_API_PUBLIC;
int MPI_File_seek_shared(ABI_File fh, MPI_Offset offset, int whence) MPICH_API_PUBLIC;
int MPI_File_set_atomicity(ABI_File fh, int flag) MPICH_API_PUBLIC;
int MPI_File_set_errhandler(ABI_File file, ABI_Errhandler errhandler) MPICH_API_PUBLIC;
int MPI_File_set_info(ABI_File fh, ABI_Info info) MPICH_API_PUBLIC;
int MPI_File_set_size(ABI_File fh, MPI_Offset size) MPICH_API_PUBLIC;
int MPI_File_set_view(ABI_File fh, MPI_Offset disp, ABI_Datatype etype, ABI_Datatype filetype, const char *datarep, ABI_Info info) MPICH_API_PUBLIC;
int MPI_File_sync(ABI_File fh) MPICH_API_PUBLIC;
int MPI_File_write(ABI_File fh, const void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_write_c(ABI_File fh, const void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_write_all(ABI_File fh, const void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_write_all_c(ABI_File fh, const void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_write_all_begin(ABI_File fh, const void *buf, int count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int MPI_File_write_all_begin_c(ABI_File fh, const void *buf, MPI_Count count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int MPI_File_write_all_end(ABI_File fh, const void *buf, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_write_at(ABI_File fh, MPI_Offset offset, const void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_write_at_c(ABI_File fh, MPI_Offset offset, const void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_write_at_all(ABI_File fh, MPI_Offset offset, const void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_write_at_all_c(ABI_File fh, MPI_Offset offset, const void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_write_at_all_begin(ABI_File fh, MPI_Offset offset, const void *buf, int count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int MPI_File_write_at_all_begin_c(ABI_File fh, MPI_Offset offset, const void *buf, MPI_Count count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int MPI_File_write_at_all_end(ABI_File fh, const void *buf, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_write_ordered(ABI_File fh, const void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_write_ordered_c(ABI_File fh, const void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_write_ordered_begin(ABI_File fh, const void *buf, int count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int MPI_File_write_ordered_begin_c(ABI_File fh, const void *buf, MPI_Count count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int MPI_File_write_ordered_end(ABI_File fh, const void *buf, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_write_shared(ABI_File fh, const void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_File_write_shared_c(ABI_File fh, const void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_Finalize(void) MPICH_API_PUBLIC;
int MPI_Finalized(int *flag) MPICH_API_PUBLIC;
int MPI_Free_mem(void *base) MPICH_API_PUBLIC;
int MPI_Gather(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Gather_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Gather_init(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Gather_init_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Gatherv(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int displs[], ABI_Datatype recvtype, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Gatherv_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint displs[], ABI_Datatype recvtype, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Gatherv_init(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int displs[], ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Gatherv_init_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint displs[], ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Get(void *origin_addr, int origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, int target_count, ABI_Datatype target_datatype, ABI_Win win) MPICH_API_PUBLIC;
int MPI_Get_c(void *origin_addr, MPI_Count origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, MPI_Count target_count, ABI_Datatype target_datatype, ABI_Win win) MPICH_API_PUBLIC;
int MPI_Get_accumulate(const void *origin_addr, int origin_count, ABI_Datatype origin_datatype, void *result_addr, int result_count, ABI_Datatype result_datatype, int target_rank, MPI_Aint target_disp, int target_count, ABI_Datatype target_datatype, ABI_Op op, ABI_Win win) MPICH_API_PUBLIC;
int MPI_Get_accumulate_c(const void *origin_addr, MPI_Count origin_count, ABI_Datatype origin_datatype, void *result_addr, MPI_Count result_count, ABI_Datatype result_datatype, int target_rank, MPI_Aint target_disp, MPI_Count target_count, ABI_Datatype target_datatype, ABI_Op op, ABI_Win win) MPICH_API_PUBLIC;
int MPI_Get_address(const void *location, MPI_Aint *address) MPICH_API_PUBLIC;
int MPI_Get_count(const MPI_Status *status, ABI_Datatype datatype, int *count) MPICH_API_PUBLIC;
int MPI_Get_count_c(const MPI_Status *status, ABI_Datatype datatype, MPI_Count *count) MPICH_API_PUBLIC;
int MPI_Get_elements(const MPI_Status *status, ABI_Datatype datatype, int *count) MPICH_API_PUBLIC;
int MPI_Get_elements_c(const MPI_Status *status, ABI_Datatype datatype, MPI_Count *count) MPICH_API_PUBLIC;
int MPI_Get_elements_x(const MPI_Status *status, ABI_Datatype datatype, MPI_Count *count) MPICH_API_PUBLIC;
int MPI_Get_hw_resource_info(ABI_Info *hw_info) MPICH_API_PUBLIC;
int MPI_Get_library_version(char *version, int *resultlen) MPICH_API_PUBLIC;
int MPI_Get_processor_name(char *name, int *resultlen) MPICH_API_PUBLIC;
int MPI_Get_version(int *version, int *subversion) MPICH_API_PUBLIC;
int MPI_Graph_create(ABI_Comm comm_old, int nnodes, const int indx[], const int edges[], int reorder, ABI_Comm *comm_graph) MPICH_API_PUBLIC;
int MPI_Graph_get(ABI_Comm comm, int maxindex, int maxedges, int indx[], int edges[]) MPICH_API_PUBLIC;
int MPI_Graph_map(ABI_Comm comm, int nnodes, const int indx[], const int edges[], int *newrank) MPICH_API_PUBLIC;
int MPI_Graph_neighbors(ABI_Comm comm, int rank, int maxneighbors, int neighbors[]) MPICH_API_PUBLIC;
int MPI_Graph_neighbors_count(ABI_Comm comm, int rank, int *nneighbors) MPICH_API_PUBLIC;
int MPI_Graphdims_get(ABI_Comm comm, int *nnodes, int *nedges) MPICH_API_PUBLIC;
int MPI_Grequest_complete(ABI_Request request) MPICH_API_PUBLIC;
int MPI_Grequest_start(MPI_Grequest_query_function *query_fn, MPI_Grequest_free_function *free_fn, MPI_Grequest_cancel_function *cancel_fn, void *extra_state, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Group_compare(ABI_Group group1, ABI_Group group2, int *result) MPICH_API_PUBLIC;
int MPI_Group_difference(ABI_Group group1, ABI_Group group2, ABI_Group *newgroup) MPICH_API_PUBLIC;
int MPI_Group_excl(ABI_Group group, int n, const int ranks[], ABI_Group *newgroup) MPICH_API_PUBLIC;
int MPI_Group_free(ABI_Group *group) MPICH_API_PUBLIC;
int MPI_Group_from_session_pset(ABI_Session session, const char *pset_name, ABI_Group *newgroup) MPICH_API_PUBLIC;
int MPI_Group_incl(ABI_Group group, int n, const int ranks[], ABI_Group *newgroup) MPICH_API_PUBLIC;
int MPI_Group_intersection(ABI_Group group1, ABI_Group group2, ABI_Group *newgroup) MPICH_API_PUBLIC;
int MPI_Group_range_excl(ABI_Group group, int n, int ranges[][3], ABI_Group *newgroup) MPICH_API_PUBLIC;
int MPI_Group_range_incl(ABI_Group group, int n, int ranges[][3], ABI_Group *newgroup) MPICH_API_PUBLIC;
int MPI_Group_rank(ABI_Group group, int *rank) MPICH_API_PUBLIC;
int MPI_Group_size(ABI_Group group, int *size) MPICH_API_PUBLIC;
int MPI_Group_translate_ranks(ABI_Group group1, int n, const int ranks1[], ABI_Group group2, int ranks2[]) MPICH_API_PUBLIC;
int MPI_Group_union(ABI_Group group1, ABI_Group group2, ABI_Group *newgroup) MPICH_API_PUBLIC;
int MPI_Iallgather(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Iallgather_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Iallgatherv(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int displs[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Iallgatherv_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint displs[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Iallreduce(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Iallreduce_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ialltoall(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ialltoall_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ialltoallv(const void *sendbuf, const int sendcounts[], const int sdispls[], ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int rdispls[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ialltoallv_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ialltoallw(const void *sendbuf, const int sendcounts[], const int sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const int recvcounts[], const int rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ialltoallw_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ibarrier(ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ibcast(void *buffer, int count, ABI_Datatype datatype, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ibcast_c(void *buffer, MPI_Count count, ABI_Datatype datatype, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ibsend(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ibsend_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Iexscan(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Iexscan_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Igather(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Igather_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Igatherv(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int displs[], ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Igatherv_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint displs[], ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Improbe(int source, int tag, ABI_Comm comm, int *flag, ABI_Message *message, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_Imrecv(void *buf, int count, ABI_Datatype datatype, ABI_Message *message, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Imrecv_c(void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Message *message, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ineighbor_allgather(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ineighbor_allgather_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ineighbor_allgatherv(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int displs[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ineighbor_allgatherv_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint displs[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ineighbor_alltoall(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ineighbor_alltoall_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ineighbor_alltoallv(const void *sendbuf, const int sendcounts[], const int sdispls[], ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int rdispls[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ineighbor_alltoallv_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ineighbor_alltoallw(const void *sendbuf, const int sendcounts[], const MPI_Aint sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const int recvcounts[], const MPI_Aint rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ineighbor_alltoallw_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Info_create(ABI_Info *info) MPICH_API_PUBLIC;
int MPI_Info_create_env(int argc, char *argv[], ABI_Info *info) MPICH_API_PUBLIC;
int MPI_Info_delete(ABI_Info info, const char *key) MPICH_API_PUBLIC;
int MPI_Info_dup(ABI_Info info, ABI_Info *newinfo) MPICH_API_PUBLIC;
int MPI_Info_free(ABI_Info *info) MPICH_API_PUBLIC;
int MPI_Info_get(ABI_Info info, const char *key, int valuelen, char *value, int *flag) MPICH_API_PUBLIC;
int MPI_Info_get_nkeys(ABI_Info info, int *nkeys) MPICH_API_PUBLIC;
int MPI_Info_get_nthkey(ABI_Info info, int n, char *key) MPICH_API_PUBLIC;
int MPI_Info_get_string(ABI_Info info, const char *key, int *buflen, char *value, int *flag) MPICH_API_PUBLIC;
int MPI_Info_get_valuelen(ABI_Info info, const char *key, int *valuelen, int *flag) MPICH_API_PUBLIC;
int MPI_Info_set(ABI_Info info, const char *key, const char *value) MPICH_API_PUBLIC;
int MPI_Init(int *argc, char ***argv) MPICH_API_PUBLIC;
int MPI_Init_thread(int *argc, char ***argv, int required, int *provided) MPICH_API_PUBLIC;
int MPI_Initialized(int *flag) MPICH_API_PUBLIC;
int MPI_Intercomm_create(ABI_Comm local_comm, int local_leader, ABI_Comm peer_comm, int remote_leader, int tag, ABI_Comm *newintercomm) MPICH_API_PUBLIC;
int MPI_Intercomm_create_from_groups(ABI_Group local_group, int local_leader, ABI_Group remote_group, int remote_leader, const char *stringtag, ABI_Info info, ABI_Errhandler errhandler, ABI_Comm *newintercomm) MPICH_API_PUBLIC;
int MPI_Intercomm_merge(ABI_Comm intercomm, int high, ABI_Comm *newintracomm) MPICH_API_PUBLIC;
int MPI_Iprobe(int source, int tag, ABI_Comm comm, int *flag, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_Irecv(void *buf, int count, ABI_Datatype datatype, int source, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Irecv_c(void *buf, MPI_Count count, ABI_Datatype datatype, int source, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ireduce(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ireduce_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ireduce_scatter(const void *sendbuf, void *recvbuf, const int recvcounts[], ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ireduce_scatter_c(const void *sendbuf, void *recvbuf, const MPI_Count recvcounts[], ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ireduce_scatter_block(const void *sendbuf, void *recvbuf, int recvcount, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ireduce_scatter_block_c(const void *sendbuf, void *recvbuf, MPI_Count recvcount, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Irsend(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Irsend_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Is_thread_main(int *flag) MPICH_API_PUBLIC;
int MPI_Iscan(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Iscan_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Iscatter(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Iscatter_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Iscatterv(const void *sendbuf, const int sendcounts[], const int displs[], ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Iscatterv_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint displs[], ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Isend(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Isend_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Isendrecv(const void *sendbuf, int sendcount, ABI_Datatype sendtype, int dest, int sendtag, void *recvbuf, int recvcount, ABI_Datatype recvtype, int source, int recvtag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Isendrecv_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, int dest, int sendtag, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, int source, int recvtag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Isendrecv_replace(void *buf, int count, ABI_Datatype datatype, int dest, int sendtag, int source, int recvtag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Isendrecv_replace_c(void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int sendtag, int source, int recvtag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Issend(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Issend_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Keyval_create(MPI_Copy_function *copy_fn, MPI_Delete_function *delete_fn, int *keyval, void *extra_state) MPICH_API_PUBLIC;
int MPI_Keyval_free(int *keyval) MPICH_API_PUBLIC;
int MPI_Lookup_name(const char *service_name, ABI_Info info, char *port_name) MPICH_API_PUBLIC;
int MPI_Mprobe(int source, int tag, ABI_Comm comm, ABI_Message *message, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_Mrecv(void *buf, int count, ABI_Datatype datatype, ABI_Message *message, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_Mrecv_c(void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Message *message, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_Neighbor_allgather(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Neighbor_allgather_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Neighbor_allgather_init(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Neighbor_allgather_init_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Neighbor_allgatherv(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int displs[], ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Neighbor_allgatherv_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint displs[], ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Neighbor_allgatherv_init(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int displs[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Neighbor_allgatherv_init_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint displs[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Neighbor_alltoall(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Neighbor_alltoall_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Neighbor_alltoall_init(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Neighbor_alltoall_init_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Neighbor_alltoallv(const void *sendbuf, const int sendcounts[], const int sdispls[], ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int rdispls[], ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Neighbor_alltoallv_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Neighbor_alltoallv_init(const void *sendbuf, const int sendcounts[], const int sdispls[], ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int rdispls[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Neighbor_alltoallv_init_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Neighbor_alltoallw(const void *sendbuf, const int sendcounts[], const MPI_Aint sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const int recvcounts[], const MPI_Aint rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Neighbor_alltoallw_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Neighbor_alltoallw_init(const void *sendbuf, const int sendcounts[], const MPI_Aint sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const int recvcounts[], const MPI_Aint rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Neighbor_alltoallw_init_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Op_commutative(ABI_Op op, int *commute) MPICH_API_PUBLIC;
int MPI_Op_create(MPI_User_function *user_fn, int commute, ABI_Op *op) MPICH_API_PUBLIC;
int MPI_Op_create_c(MPI_User_function_c *user_fn, int commute, ABI_Op *op) MPICH_API_PUBLIC;
int MPIX_Op_create_x(MPIX_User_function_x *user_fn_x, MPIX_Destructor_function *destructor_fn, int commute, void *extra_state, ABI_Op *op) MPICH_API_PUBLIC;
int MPI_Op_free(ABI_Op *op) MPICH_API_PUBLIC;
int MPI_Open_port(ABI_Info info, char *port_name) MPICH_API_PUBLIC;
int MPI_Pack(const void *inbuf, int incount, ABI_Datatype datatype, void *outbuf, int outsize, int *position, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Pack_c(const void *inbuf, MPI_Count incount, ABI_Datatype datatype, void *outbuf, MPI_Count outsize, MPI_Count *position, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Pack_external(const char *datarep, const void *inbuf, int incount, ABI_Datatype datatype, void *outbuf, MPI_Aint outsize, MPI_Aint *position) MPICH_API_PUBLIC;
int MPI_Pack_external_c(const char *datarep, const void *inbuf, MPI_Count incount, ABI_Datatype datatype, void *outbuf, MPI_Count outsize, MPI_Count *position) MPICH_API_PUBLIC;
int MPI_Pack_external_size(const char *datarep, int incount, ABI_Datatype datatype, MPI_Aint *size) MPICH_API_PUBLIC;
int MPI_Pack_external_size_c(const char *datarep, MPI_Count incount, ABI_Datatype datatype, MPI_Count *size) MPICH_API_PUBLIC;
int MPI_Pack_size(int incount, ABI_Datatype datatype, ABI_Comm comm, int *size) MPICH_API_PUBLIC;
int MPI_Pack_size_c(MPI_Count incount, ABI_Datatype datatype, ABI_Comm comm, MPI_Count *size) MPICH_API_PUBLIC;
int MPI_Parrived(ABI_Request request, int partition, int *flag) MPICH_API_PUBLIC;
int MPI_Pcontrol(const int level, ...) MPICH_API_PUBLIC;
int MPI_Pready(int partition, ABI_Request request) MPICH_API_PUBLIC;
int MPI_Pready_list(int length, const int array_of_partitions[], ABI_Request request) MPICH_API_PUBLIC;
int MPI_Pready_range(int partition_low, int partition_high, ABI_Request request) MPICH_API_PUBLIC;
int MPI_Precv_init(void *buf, int partitions, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Probe(int source, int tag, ABI_Comm comm, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_Psend_init(const void *buf, int partitions, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Publish_name(const char *service_name, ABI_Info info, const char *port_name) MPICH_API_PUBLIC;
int MPI_Put(const void *origin_addr, int origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, int target_count, ABI_Datatype target_datatype, ABI_Win win) MPICH_API_PUBLIC;
int MPI_Put_c(const void *origin_addr, MPI_Count origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, MPI_Count target_count, ABI_Datatype target_datatype, ABI_Win win) MPICH_API_PUBLIC;
int MPI_Query_thread(int *provided) MPICH_API_PUBLIC;
int MPI_Raccumulate(const void *origin_addr, int origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, int target_count, ABI_Datatype target_datatype, ABI_Op op, ABI_Win win, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Raccumulate_c(const void *origin_addr, MPI_Count origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, MPI_Count target_count, ABI_Datatype target_datatype, ABI_Op op, ABI_Win win, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Recv(void *buf, int count, ABI_Datatype datatype, int source, int tag, ABI_Comm comm, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_Recv_c(void *buf, MPI_Count count, ABI_Datatype datatype, int source, int tag, ABI_Comm comm, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_Recv_init(void *buf, int count, ABI_Datatype datatype, int source, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Recv_init_c(void *buf, MPI_Count count, ABI_Datatype datatype, int source, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Reduce(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Reduce_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Reduce_init(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Reduce_init_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Reduce_local(const void *inbuf, void *inoutbuf, int count, ABI_Datatype datatype, ABI_Op op) MPICH_API_PUBLIC;
int MPI_Reduce_local_c(const void *inbuf, void *inoutbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op) MPICH_API_PUBLIC;
int MPI_Reduce_scatter(const void *sendbuf, void *recvbuf, const int recvcounts[], ABI_Datatype datatype, ABI_Op op, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Reduce_scatter_c(const void *sendbuf, void *recvbuf, const MPI_Count recvcounts[], ABI_Datatype datatype, ABI_Op op, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Reduce_scatter_block(const void *sendbuf, void *recvbuf, int recvcount, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Reduce_scatter_block_c(const void *sendbuf, void *recvbuf, MPI_Count recvcount, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Reduce_scatter_block_init(const void *sendbuf, void *recvbuf, int recvcount, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Reduce_scatter_block_init_c(const void *sendbuf, void *recvbuf, MPI_Count recvcount, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Reduce_scatter_init(const void *sendbuf, void *recvbuf, const int recvcounts[], ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Reduce_scatter_init_c(const void *sendbuf, void *recvbuf, const MPI_Count recvcounts[], ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Register_datarep(const char *datarep, MPI_Datarep_conversion_function *read_conversion_fn, MPI_Datarep_conversion_function *write_conversion_fn, MPI_Datarep_extent_function *dtype_file_extent_fn, void *extra_state) MPICH_API_PUBLIC;
int MPI_Register_datarep_c(const char *datarep, MPI_Datarep_conversion_function_c *read_conversion_fn, MPI_Datarep_conversion_function_c *write_conversion_fn, MPI_Datarep_extent_function *dtype_file_extent_fn, void *extra_state) MPICH_API_PUBLIC;
int MPI_Remove_error_class(int errorclass) MPICH_API_PUBLIC;
int MPI_Remove_error_code(int errorcode) MPICH_API_PUBLIC;
int MPI_Remove_error_string(int errorcode) MPICH_API_PUBLIC;
int MPI_Request_free(ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Request_get_status(ABI_Request request, int *flag, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_Request_get_status_all(int count, const ABI_Request array_of_requests[], int *flag, MPI_Status *array_of_statuses) MPICH_API_PUBLIC;
int MPI_Request_get_status_any(int count, const ABI_Request array_of_requests[], int *indx, int *flag, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_Request_get_status_some(int incount, const ABI_Request array_of_requests[], int *outcount, int array_of_indices[], MPI_Status *array_of_statuses) MPICH_API_PUBLIC;
int MPI_Rget(void *origin_addr, int origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, int target_count, ABI_Datatype target_datatype, ABI_Win win, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Rget_c(void *origin_addr, MPI_Count origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, MPI_Count target_count, ABI_Datatype target_datatype, ABI_Win win, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Rget_accumulate(const void *origin_addr, int origin_count, ABI_Datatype origin_datatype, void *result_addr, int result_count, ABI_Datatype result_datatype, int target_rank, MPI_Aint target_disp, int target_count, ABI_Datatype target_datatype, ABI_Op op, ABI_Win win, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Rget_accumulate_c(const void *origin_addr, MPI_Count origin_count, ABI_Datatype origin_datatype, void *result_addr, MPI_Count result_count, ABI_Datatype result_datatype, int target_rank, MPI_Aint target_disp, MPI_Count target_count, ABI_Datatype target_datatype, ABI_Op op, ABI_Win win, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Rput(const void *origin_addr, int origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, int target_count, ABI_Datatype target_datatype, ABI_Win win, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Rput_c(const void *origin_addr, MPI_Count origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, MPI_Count target_count, ABI_Datatype target_datatype, ABI_Win win, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Rsend(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Rsend_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Rsend_init(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Rsend_init_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Scan(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Scan_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Scan_init(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Scan_init_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Scatter(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Scatter_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Scatter_init(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Scatter_init_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Scatterv(const void *sendbuf, const int sendcounts[], const int displs[], ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Scatterv_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint displs[], ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Scatterv_init(const void *sendbuf, const int sendcounts[], const int displs[], ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Scatterv_init_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint displs[], ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Send(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Send_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Send_init(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Send_init_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Sendrecv(const void *sendbuf, int sendcount, ABI_Datatype sendtype, int dest, int sendtag, void *recvbuf, int recvcount, ABI_Datatype recvtype, int source, int recvtag, ABI_Comm comm, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_Sendrecv_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, int dest, int sendtag, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, int source, int recvtag, ABI_Comm comm, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_Sendrecv_replace(void *buf, int count, ABI_Datatype datatype, int dest, int sendtag, int source, int recvtag, ABI_Comm comm, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_Sendrecv_replace_c(void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int sendtag, int source, int recvtag, ABI_Comm comm, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_Session_attach_buffer(ABI_Session session, void *buffer, int size) MPICH_API_PUBLIC;
int MPI_Session_attach_buffer_c(ABI_Session session, void *buffer, MPI_Count size) MPICH_API_PUBLIC;
int MPI_Session_call_errhandler(ABI_Session session, int errorcode) MPICH_API_PUBLIC;
int MPI_Session_create_errhandler(MPI_Session_errhandler_function *session_errhandler_fn, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int MPIX_Session_create_errhandler_x(MPIX_Session_errhandler_function_x *comm_errhandler_fn_x, MPIX_Destructor_function *destructor_fn, void *extra_state, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int MPI_Session_detach_buffer(ABI_Session session, void *buffer_addr, int *size) MPICH_API_PUBLIC;
int MPI_Session_detach_buffer_c(ABI_Session session, void *buffer_addr, MPI_Count *size) MPICH_API_PUBLIC;
int MPI_Session_finalize(ABI_Session *session) MPICH_API_PUBLIC;
int MPI_Session_flush_buffer(ABI_Session session) MPICH_API_PUBLIC;
int MPI_Session_get_errhandler(ABI_Session session, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int MPI_Session_get_info(ABI_Session session, ABI_Info *info_used) MPICH_API_PUBLIC;
int MPI_Session_get_nth_pset(ABI_Session session, ABI_Info info, int n, int *pset_len, char *pset_name) MPICH_API_PUBLIC;
int MPI_Session_get_num_psets(ABI_Session session, ABI_Info info, int *npset_names) MPICH_API_PUBLIC;
int MPI_Session_get_pset_info(ABI_Session session, const char *pset_name, ABI_Info *info) MPICH_API_PUBLIC;
int MPI_Session_iflush_buffer(ABI_Session session, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Session_init(ABI_Info info, ABI_Errhandler errhandler, ABI_Session *session) MPICH_API_PUBLIC;
int MPI_Session_set_errhandler(ABI_Session session, ABI_Errhandler errhandler) MPICH_API_PUBLIC;
int MPI_Ssend(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Ssend_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Ssend_init(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Ssend_init_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Start(ABI_Request *request) MPICH_API_PUBLIC;
int MPI_Startall(int count, ABI_Request array_of_requests[]) MPICH_API_PUBLIC;
int MPI_Status_get_error(const MPI_Status *status, int *error) MPICH_API_PUBLIC;
int MPI_Status_get_source(const MPI_Status *status, int *source) MPICH_API_PUBLIC;
int MPI_Status_get_tag(const MPI_Status *status, int *tag) MPICH_API_PUBLIC;
int MPI_Status_set_cancelled(MPI_Status *status, int flag) MPICH_API_PUBLIC;
int MPI_Status_set_elements(MPI_Status *status, ABI_Datatype datatype, int count) MPICH_API_PUBLIC;
int MPI_Status_set_elements_c(MPI_Status *status, ABI_Datatype datatype, MPI_Count count) MPICH_API_PUBLIC;
int MPI_Status_set_elements_x(MPI_Status *status, ABI_Datatype datatype, MPI_Count count) MPICH_API_PUBLIC;
int MPI_Status_set_error(MPI_Status *status, int error) MPICH_API_PUBLIC;
int MPI_Status_set_source(MPI_Status *status, int source) MPICH_API_PUBLIC;
int MPI_Status_set_tag(MPI_Status *status, int tag) MPICH_API_PUBLIC;
int MPI_Test(ABI_Request *request, int *flag, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_Test_cancelled(const MPI_Status *status, int *flag) MPICH_API_PUBLIC;
int MPI_Testall(int count, ABI_Request array_of_requests[], int *flag, MPI_Status *array_of_statuses) MPICH_API_PUBLIC;
int MPI_Testany(int count, ABI_Request array_of_requests[], int *indx, int *flag, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_Testsome(int incount, ABI_Request array_of_requests[], int *outcount, int array_of_indices[], MPI_Status *array_of_statuses) MPICH_API_PUBLIC;
int MPI_Topo_test(ABI_Comm comm, int *status) MPICH_API_PUBLIC;
int MPI_Type_commit(ABI_Datatype *datatype) MPICH_API_PUBLIC;
int MPI_Type_contiguous(int count, ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_contiguous_c(MPI_Count count, ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_create_darray(int size, int rank, int ndims, const int array_of_gsizes[], const int array_of_distribs[], const int array_of_dargs[], const int array_of_psizes[], int order, ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_create_darray_c(int size, int rank, int ndims, const MPI_Count array_of_gsizes[], const int array_of_distribs[], const int array_of_dargs[], const int array_of_psizes[], int order, ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_create_f90_complex(int p, int r, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_create_f90_integer(int r, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_create_f90_real(int p, int r, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_create_hindexed(int count, const int array_of_blocklengths[], const MPI_Aint array_of_displacements[], ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_create_hindexed_c(MPI_Count count, const MPI_Count array_of_blocklengths[], const MPI_Count array_of_displacements[], ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_create_hindexed_block(int count, int blocklength, const MPI_Aint array_of_displacements[], ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_create_hindexed_block_c(MPI_Count count, MPI_Count blocklength, const MPI_Count array_of_displacements[], ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_create_hvector(int count, int blocklength, MPI_Aint stride, ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_create_hvector_c(MPI_Count count, MPI_Count blocklength, MPI_Count stride, ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_create_indexed_block(int count, int blocklength, const int array_of_displacements[], ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_create_indexed_block_c(MPI_Count count, MPI_Count blocklength, const MPI_Count array_of_displacements[], ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_create_keyval(MPI_Type_copy_attr_function *type_copy_attr_fn, MPI_Type_delete_attr_function *type_delete_attr_fn, int *type_keyval, void *extra_state) MPICH_API_PUBLIC;
int MPI_Type_create_resized(ABI_Datatype oldtype, MPI_Aint lb, MPI_Aint extent, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_create_resized_c(ABI_Datatype oldtype, MPI_Count lb, MPI_Count extent, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_create_struct(int count, const int array_of_blocklengths[], const MPI_Aint array_of_displacements[], const ABI_Datatype array_of_types[], ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_create_struct_c(MPI_Count count, const MPI_Count array_of_blocklengths[], const MPI_Count array_of_displacements[], const ABI_Datatype array_of_types[], ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_create_subarray(int ndims, const int array_of_sizes[], const int array_of_subsizes[], const int array_of_starts[], int order, ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_create_subarray_c(int ndims, const MPI_Count array_of_sizes[], const MPI_Count array_of_subsizes[], const MPI_Count array_of_starts[], int order, ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_delete_attr(ABI_Datatype datatype, int type_keyval) MPICH_API_PUBLIC;
int MPI_Type_dup(ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_free(ABI_Datatype *datatype) MPICH_API_PUBLIC;
int MPI_Type_free_keyval(int *type_keyval) MPICH_API_PUBLIC;
int MPI_Type_get_attr(ABI_Datatype datatype, int type_keyval, void *attribute_val, int *flag) MPICH_API_PUBLIC;
int MPI_Type_get_contents(ABI_Datatype datatype, int max_integers, int max_addresses, int max_datatypes, int array_of_integers[], MPI_Aint array_of_addresses[], ABI_Datatype array_of_datatypes[]) MPICH_API_PUBLIC;
int MPI_Type_get_contents_c(ABI_Datatype datatype, MPI_Count max_integers, MPI_Count max_addresses, MPI_Count max_large_counts, MPI_Count max_datatypes, int array_of_integers[], MPI_Aint array_of_addresses[], MPI_Count array_of_large_counts[], ABI_Datatype array_of_datatypes[]) MPICH_API_PUBLIC;
int MPI_Type_get_envelope(ABI_Datatype datatype, int *num_integers, int *num_addresses, int *num_datatypes, int *combiner) MPICH_API_PUBLIC;
int MPI_Type_get_envelope_c(ABI_Datatype datatype, MPI_Count *num_integers, MPI_Count *num_addresses, MPI_Count *num_large_counts, MPI_Count *num_datatypes, int *combiner) MPICH_API_PUBLIC;
int MPI_Type_get_extent(ABI_Datatype datatype, MPI_Aint *lb, MPI_Aint *extent) MPICH_API_PUBLIC;
int MPI_Type_get_extent_c(ABI_Datatype datatype, MPI_Count *lb, MPI_Count *extent) MPICH_API_PUBLIC;
int MPI_Type_get_extent_x(ABI_Datatype datatype, MPI_Count *lb, MPI_Count *extent) MPICH_API_PUBLIC;
int MPI_Type_get_name(ABI_Datatype datatype, char *type_name, int *resultlen) MPICH_API_PUBLIC;
int MPI_Type_get_true_extent(ABI_Datatype datatype, MPI_Aint *true_lb, MPI_Aint *true_extent) MPICH_API_PUBLIC;
int MPI_Type_get_true_extent_c(ABI_Datatype datatype, MPI_Count *true_lb, MPI_Count *true_extent) MPICH_API_PUBLIC;
int MPI_Type_get_true_extent_x(ABI_Datatype datatype, MPI_Count *true_lb, MPI_Count *true_extent) MPICH_API_PUBLIC;
int MPI_Type_get_value_index(ABI_Datatype value_type, ABI_Datatype index_type, ABI_Datatype *pair_type) MPICH_API_PUBLIC;
int MPI_Type_indexed(int count, const int array_of_blocklengths[], const int array_of_displacements[], ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_indexed_c(MPI_Count count, const MPI_Count array_of_blocklengths[], const MPI_Count array_of_displacements[], ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_match_size(int typeclass, int size, ABI_Datatype *datatype) MPICH_API_PUBLIC;
int MPI_Type_set_attr(ABI_Datatype datatype, int type_keyval, void *attribute_val) MPICH_API_PUBLIC;
int MPI_Type_set_name(ABI_Datatype datatype, const char *type_name) MPICH_API_PUBLIC;
int MPI_Type_size(ABI_Datatype datatype, int *size) MPICH_API_PUBLIC;
int MPI_Type_size_c(ABI_Datatype datatype, MPI_Count *size) MPICH_API_PUBLIC;
int MPI_Type_size_x(ABI_Datatype datatype, MPI_Count *size) MPICH_API_PUBLIC;
int MPI_Type_vector(int count, int blocklength, int stride, ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Type_vector_c(MPI_Count count, MPI_Count blocklength, MPI_Count stride, ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int MPI_Unpack(const void *inbuf, int insize, int *position, void *outbuf, int outcount, ABI_Datatype datatype, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Unpack_c(const void *inbuf, MPI_Count insize, MPI_Count *position, void *outbuf, MPI_Count outcount, ABI_Datatype datatype, ABI_Comm comm) MPICH_API_PUBLIC;
int MPI_Unpack_external(const char datarep[], const void *inbuf, MPI_Aint insize, MPI_Aint *position, void *outbuf, int outcount, ABI_Datatype datatype) MPICH_API_PUBLIC;
int MPI_Unpack_external_c(const char datarep[], const void *inbuf, MPI_Count insize, MPI_Count *position, void *outbuf, MPI_Count outcount, ABI_Datatype datatype) MPICH_API_PUBLIC;
int MPI_Unpublish_name(const char *service_name, ABI_Info info, const char *port_name) MPICH_API_PUBLIC;
int MPI_Wait(ABI_Request *request, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_Waitall(int count, ABI_Request array_of_requests[], MPI_Status *array_of_statuses) MPICH_API_PUBLIC;
int MPI_Waitany(int count, ABI_Request array_of_requests[], int *indx, MPI_Status *status) MPICH_API_PUBLIC;
int MPI_Waitsome(int incount, ABI_Request array_of_requests[], int *outcount, int array_of_indices[], MPI_Status *array_of_statuses) MPICH_API_PUBLIC;
int MPI_Win_allocate(MPI_Aint size, int disp_unit, ABI_Info info, ABI_Comm comm, void *baseptr, ABI_Win *win) MPICH_API_PUBLIC;
int MPI_Win_allocate_c(MPI_Aint size, MPI_Aint disp_unit, ABI_Info info, ABI_Comm comm, void *baseptr, ABI_Win *win) MPICH_API_PUBLIC;
int MPI_Win_allocate_shared(MPI_Aint size, int disp_unit, ABI_Info info, ABI_Comm comm, void *baseptr, ABI_Win *win) MPICH_API_PUBLIC;
int MPI_Win_allocate_shared_c(MPI_Aint size, MPI_Aint disp_unit, ABI_Info info, ABI_Comm comm, void *baseptr, ABI_Win *win) MPICH_API_PUBLIC;
int MPI_Win_attach(ABI_Win win, void *base, MPI_Aint size) MPICH_API_PUBLIC;
int MPI_Win_call_errhandler(ABI_Win win, int errorcode) MPICH_API_PUBLIC;
int MPI_Win_complete(ABI_Win win) MPICH_API_PUBLIC;
int MPI_Win_create(void *base, MPI_Aint size, int disp_unit, ABI_Info info, ABI_Comm comm, ABI_Win *win) MPICH_API_PUBLIC;
int MPI_Win_create_c(void *base, MPI_Aint size, MPI_Aint disp_unit, ABI_Info info, ABI_Comm comm, ABI_Win *win) MPICH_API_PUBLIC;
int MPI_Win_create_dynamic(ABI_Info info, ABI_Comm comm, ABI_Win *win) MPICH_API_PUBLIC;
int MPI_Win_create_errhandler(MPI_Win_errhandler_function *win_errhandler_fn, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int MPIX_Win_create_errhandler_x(MPIX_Win_errhandler_function_x *comm_errhandler_fn_x, MPIX_Destructor_function *destructor_fn, void *extra_state, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int MPI_Win_create_keyval(MPI_Win_copy_attr_function *win_copy_attr_fn, MPI_Win_delete_attr_function *win_delete_attr_fn, int *win_keyval, void *extra_state) MPICH_API_PUBLIC;
int MPI_Win_delete_attr(ABI_Win win, int win_keyval) MPICH_API_PUBLIC;
int MPI_Win_detach(ABI_Win win, const void *base) MPICH_API_PUBLIC;
int MPI_Win_fence(int assert, ABI_Win win) MPICH_API_PUBLIC;
int MPI_Win_flush(int rank, ABI_Win win) MPICH_API_PUBLIC;
int MPI_Win_flush_all(ABI_Win win) MPICH_API_PUBLIC;
int MPI_Win_flush_local(int rank, ABI_Win win) MPICH_API_PUBLIC;
int MPI_Win_flush_local_all(ABI_Win win) MPICH_API_PUBLIC;
int MPI_Win_free(ABI_Win *win) MPICH_API_PUBLIC;
int MPI_Win_free_keyval(int *win_keyval) MPICH_API_PUBLIC;
int MPI_Win_get_attr(ABI_Win win, int win_keyval, void *attribute_val, int *flag) MPICH_API_PUBLIC;
int MPI_Win_get_errhandler(ABI_Win win, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int MPI_Win_get_group(ABI_Win win, ABI_Group *group) MPICH_API_PUBLIC;
int MPI_Win_get_info(ABI_Win win, ABI_Info *info_used) MPICH_API_PUBLIC;
int MPI_Win_get_name(ABI_Win win, char *win_name, int *resultlen) MPICH_API_PUBLIC;
int MPI_Win_lock(int lock_type, int rank, int assert, ABI_Win win) MPICH_API_PUBLIC;
int MPI_Win_lock_all(int assert, ABI_Win win) MPICH_API_PUBLIC;
int MPI_Win_post(ABI_Group group, int assert, ABI_Win win) MPICH_API_PUBLIC;
int MPI_Win_set_attr(ABI_Win win, int win_keyval, void *attribute_val) MPICH_API_PUBLIC;
int MPI_Win_set_errhandler(ABI_Win win, ABI_Errhandler errhandler) MPICH_API_PUBLIC;
int MPI_Win_set_info(ABI_Win win, ABI_Info info) MPICH_API_PUBLIC;
int MPI_Win_set_name(ABI_Win win, const char *win_name) MPICH_API_PUBLIC;
int MPI_Win_shared_query(ABI_Win win, int rank, MPI_Aint *size, int *disp_unit, void *baseptr) MPICH_API_PUBLIC;
int MPI_Win_shared_query_c(ABI_Win win, int rank, MPI_Aint *size, MPI_Aint *disp_unit, void *baseptr) MPICH_API_PUBLIC;
int MPI_Win_start(ABI_Group group, int assert, ABI_Win win) MPICH_API_PUBLIC;
int MPI_Win_sync(ABI_Win win) MPICH_API_PUBLIC;
int MPI_Win_test(ABI_Win win, int *flag) MPICH_API_PUBLIC;
int MPI_Win_unlock(int rank, ABI_Win win) MPICH_API_PUBLIC;
int MPI_Win_unlock_all(ABI_Win win) MPICH_API_PUBLIC;
int MPI_Win_wait(ABI_Win win) MPICH_API_PUBLIC;

MPI_Aint MPI_Aint_add(MPI_Aint base, MPI_Aint disp) MPICH_API_PUBLIC;
MPI_Aint MPI_Aint_diff(MPI_Aint addr1, MPI_Aint addr2) MPICH_API_PUBLIC;
double MPI_Wtick(void) MPICH_API_PUBLIC;
double MPI_Wtime(void) MPICH_API_PUBLIC;

ABI_Comm MPI_Comm_fromint(int comm) MPICH_API_PUBLIC;
int MPI_Comm_toint(ABI_Comm comm) MPICH_API_PUBLIC;
ABI_Errhandler MPI_Errhandler_fromint(int errhandler) MPICH_API_PUBLIC;
int MPI_Errhandler_toint(ABI_Errhandler errhandler) MPICH_API_PUBLIC;
ABI_File MPI_File_fromint(int file) MPICH_API_PUBLIC;
int MPI_File_toint(ABI_File file) MPICH_API_PUBLIC;
ABI_Group MPI_Group_fromint(int group) MPICH_API_PUBLIC;
int MPI_Group_toint(ABI_Group group) MPICH_API_PUBLIC;
ABI_Info MPI_Info_fromint(int info) MPICH_API_PUBLIC;
int MPI_Info_toint(ABI_Info info) MPICH_API_PUBLIC;
ABI_Message MPI_Message_fromint(int message) MPICH_API_PUBLIC;
int MPI_Message_toint(ABI_Message message) MPICH_API_PUBLIC;
ABI_Op MPI_Op_fromint(int op) MPICH_API_PUBLIC;
int MPI_Op_toint(ABI_Op op) MPICH_API_PUBLIC;
ABI_Request MPI_Request_fromint(int request) MPICH_API_PUBLIC;
int MPI_Request_toint(ABI_Request request) MPICH_API_PUBLIC;
ABI_Session MPI_Session_fromint(int session) MPICH_API_PUBLIC;
int MPI_Session_toint(ABI_Session session) MPICH_API_PUBLIC;
ABI_Datatype MPI_Type_fromint(int datatype) MPICH_API_PUBLIC;
int MPI_Type_toint(ABI_Datatype datatype) MPICH_API_PUBLIC;
ABI_Win MPI_Win_fromint(int win) MPICH_API_PUBLIC;
int MPI_Win_toint(ABI_Win win) MPICH_API_PUBLIC;

/* MPI_T functions */
int MPI_T_category_changed(int *update_number) MPICH_API_PUBLIC;
int MPI_T_category_get_categories(int cat_index, int len, int indices[]) MPICH_API_PUBLIC;
int MPI_T_category_get_cvars(int cat_index, int len, int indices[]) MPICH_API_PUBLIC;
int MPI_T_category_get_events(int cat_index, int len, int indices[]) MPICH_API_PUBLIC;
int MPI_T_category_get_index(const char *name, int *cat_index) MPICH_API_PUBLIC;
int MPI_T_category_get_info(int cat_index, char *name, int *name_len, char *desc, int *desc_len, int *num_cvars, int *num_pvars, int *num_categories) MPICH_API_PUBLIC;
int MPI_T_category_get_num(int *num_cat) MPICH_API_PUBLIC;
int MPI_T_category_get_num_events(int cat_index, int *num_events) MPICH_API_PUBLIC;
int MPI_T_category_get_pvars(int cat_index, int len, int indices[]) MPICH_API_PUBLIC;
int MPI_T_cvar_get_index(const char *name, int *cvar_index) MPICH_API_PUBLIC;
int MPI_T_cvar_get_info(int cvar_index, char *name, int *name_len, int *verbosity, ABI_Datatype *datatype, MPI_T_enum *enumtype, char *desc, int *desc_len, int *bind, int *scope) MPICH_API_PUBLIC;
int MPI_T_cvar_get_num(int *num_cvar) MPICH_API_PUBLIC;
int MPI_T_cvar_handle_alloc(int cvar_index, void *obj_handle, MPI_T_cvar_handle *handle, int *count) MPICH_API_PUBLIC;
int MPI_T_cvar_handle_free(MPI_T_cvar_handle *handle) MPICH_API_PUBLIC;
int MPI_T_cvar_read(MPI_T_cvar_handle handle, void *buf) MPICH_API_PUBLIC;
int MPI_T_cvar_write(MPI_T_cvar_handle handle, const void *buf) MPICH_API_PUBLIC;
int MPI_T_enum_get_info(MPI_T_enum enumtype, int *num, char *name, int *name_len) MPICH_API_PUBLIC;
int MPI_T_enum_get_item(MPI_T_enum enumtype, int indx, int *value, char *name, int *name_len) MPICH_API_PUBLIC;
int MPI_T_event_callback_get_info(MPI_T_event_registration event_registration, MPI_T_cb_safety cb_safety, ABI_Info *info_used) MPICH_API_PUBLIC;
int MPI_T_event_callback_set_info(MPI_T_event_registration event_registration, MPI_T_cb_safety cb_safety, ABI_Info info) MPICH_API_PUBLIC;
int MPI_T_event_copy(MPI_T_event_instance event_instance, void *buffer) MPICH_API_PUBLIC;
int MPI_T_event_get_index(const char *name, int *event_index) MPICH_API_PUBLIC;
int MPI_T_event_get_info(int event_index, char *name, int *name_len, int *verbosity, ABI_Datatype array_of_datatypes[], MPI_Aint array_of_displacements[], int *num_elements, MPI_T_enum *enumtype, ABI_Info *info, char *desc, int *desc_len, int *bind) MPICH_API_PUBLIC;
int MPI_T_event_get_num(int *num_events) MPICH_API_PUBLIC;
int MPI_T_event_get_source(MPI_T_event_instance event_instance, int *source_index) MPICH_API_PUBLIC;
int MPI_T_event_get_timestamp(MPI_T_event_instance event_instance, MPI_Count *event_timestamp) MPICH_API_PUBLIC;
int MPI_T_event_handle_alloc(int event_index, void *obj_handle, ABI_Info info, MPI_T_event_registration *event_registration) MPICH_API_PUBLIC;
int MPI_T_event_handle_free(MPI_T_event_registration event_registration, void *user_data, MPI_T_event_free_cb_function free_cb_function) MPICH_API_PUBLIC;
int MPI_T_event_handle_get_info(MPI_T_event_registration event_registration, ABI_Info *info_used) MPICH_API_PUBLIC;
int MPI_T_event_handle_set_info(MPI_T_event_registration event_registration, ABI_Info info) MPICH_API_PUBLIC;
int MPI_T_event_read(MPI_T_event_instance event_instance, int element_index, void *buffer) MPICH_API_PUBLIC;
int MPI_T_event_register_callback(MPI_T_event_registration event_registration, MPI_T_cb_safety cb_safety, ABI_Info info, void *user_data, MPI_T_event_cb_function event_cb_function) MPICH_API_PUBLIC;
int MPI_T_event_set_dropped_handler(MPI_T_event_registration event_registration, MPI_T_event_dropped_cb_function dropped_cb_function) MPICH_API_PUBLIC;
int MPI_T_finalize(void) MPICH_API_PUBLIC;
int MPI_T_init_thread(int required, int *provided) MPICH_API_PUBLIC;
int MPI_T_pvar_get_index(const char *name, int var_class, int *pvar_index) MPICH_API_PUBLIC;
int MPI_T_pvar_get_info(int pvar_index, char *name, int *name_len, int *verbosity, int *var_class, ABI_Datatype *datatype, MPI_T_enum *enumtype, char *desc, int *desc_len, int *bind, int *readonly, int *continuous, int *atomic) MPICH_API_PUBLIC;
int MPI_T_pvar_get_num(int *num_pvar) MPICH_API_PUBLIC;
int MPI_T_pvar_handle_alloc(MPI_T_pvar_session session, int pvar_index, void *obj_handle, MPI_T_pvar_handle *handle, int *count) MPICH_API_PUBLIC;
int MPI_T_pvar_handle_free(MPI_T_pvar_session session, MPI_T_pvar_handle *handle) MPICH_API_PUBLIC;
int MPI_T_pvar_read(MPI_T_pvar_session session, MPI_T_pvar_handle handle, void *buf) MPICH_API_PUBLIC;
int MPI_T_pvar_readreset(MPI_T_pvar_session session, MPI_T_pvar_handle handle, void *buf) MPICH_API_PUBLIC;
int MPI_T_pvar_reset(MPI_T_pvar_session session, MPI_T_pvar_handle handle) MPICH_API_PUBLIC;
int MPI_T_pvar_session_create(MPI_T_pvar_session *session) MPICH_API_PUBLIC;
int MPI_T_pvar_session_free(MPI_T_pvar_session *session) MPICH_API_PUBLIC;
int MPI_T_pvar_start(MPI_T_pvar_session session, MPI_T_pvar_handle handle) MPICH_API_PUBLIC;
int MPI_T_pvar_stop(MPI_T_pvar_session session, MPI_T_pvar_handle handle) MPICH_API_PUBLIC;
int MPI_T_pvar_write(MPI_T_pvar_session session, MPI_T_pvar_handle handle, const void *buf) MPICH_API_PUBLIC;
int MPI_T_source_get_info(int source_index, char *name, int *name_len, char *desc, int *desc_len, MPI_T_source_order *ordering, MPI_Count *ticks_per_second, MPI_Count *max_ticks, ABI_Info *info) MPICH_API_PUBLIC;
int MPI_T_source_get_num(int *num_sources) MPICH_API_PUBLIC;
int MPI_T_source_get_timestamp(int source_index, MPI_Count *timestamp) MPICH_API_PUBLIC;

/* PMPI functions */
int PMPI_Abi_get_fortran_booleans(int logical_size, void *logical_true, void *logical_false, int *is_set) MPICH_API_PUBLIC;
int PMPI_Abi_get_fortran_info(ABI_Info *info) MPICH_API_PUBLIC;
int PMPI_Abi_get_info(ABI_Info *info) MPICH_API_PUBLIC;
int PMPI_Abi_get_version(int *abi_major, int *abi_minor) MPICH_API_PUBLIC;
int PMPI_Abi_set_fortran_booleans(int logical_size, void *logical_true, void *logical_false) MPICH_API_PUBLIC;
int PMPI_Abi_set_fortran_info(ABI_Info info) MPICH_API_PUBLIC;
int PMPI_Abort(ABI_Comm comm, int errorcode) MPICH_API_PUBLIC;
int PMPI_Accumulate(const void *origin_addr, int origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, int target_count, ABI_Datatype target_datatype, ABI_Op op, ABI_Win win) MPICH_API_PUBLIC;
int PMPI_Accumulate_c(const void *origin_addr, MPI_Count origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, MPI_Count target_count, ABI_Datatype target_datatype, ABI_Op op, ABI_Win win) MPICH_API_PUBLIC;
int PMPI_Add_error_class(int *errorclass) MPICH_API_PUBLIC;
int PMPI_Add_error_code(int errorclass, int *errorcode) MPICH_API_PUBLIC;
int PMPI_Add_error_string(int errorcode, const char *string) MPICH_API_PUBLIC;
int PMPI_Allgather(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Allgather_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Allgather_init(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Allgather_init_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Allgatherv(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int displs[], ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Allgatherv_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint displs[], ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Allgatherv_init(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int displs[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Allgatherv_init_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint displs[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Alloc_mem(MPI_Aint size, ABI_Info info, void *baseptr) MPICH_API_PUBLIC;
int PMPI_Allreduce(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Allreduce_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Allreduce_init(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Allreduce_init_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Alltoall(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Alltoall_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Alltoall_init(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Alltoall_init_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Alltoallv(const void *sendbuf, const int sendcounts[], const int sdispls[], ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int rdispls[], ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Alltoallv_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Alltoallv_init(const void *sendbuf, const int sendcounts[], const int sdispls[], ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int rdispls[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Alltoallv_init_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Alltoallw(const void *sendbuf, const int sendcounts[], const int sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const int recvcounts[], const int rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Alltoallw_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Alltoallw_init(const void *sendbuf, const int sendcounts[], const int sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const int recvcounts[], const int rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Alltoallw_init_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Attr_delete(ABI_Comm comm, int keyval) MPICH_API_PUBLIC;
int PMPI_Attr_get(ABI_Comm comm, int keyval, void *attribute_val, int *flag) MPICH_API_PUBLIC;
int PMPI_Attr_put(ABI_Comm comm, int keyval, void *attribute_val) MPICH_API_PUBLIC;
int PMPI_Barrier(ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Barrier_init(ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Bcast(void *buffer, int count, ABI_Datatype datatype, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Bcast_c(void *buffer, MPI_Count count, ABI_Datatype datatype, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Bcast_init(void *buffer, int count, ABI_Datatype datatype, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Bcast_init_c(void *buffer, MPI_Count count, ABI_Datatype datatype, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Bsend(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Bsend_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Bsend_init(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Bsend_init_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Buffer_attach(void *buffer, int size) MPICH_API_PUBLIC;
int PMPI_Buffer_attach_c(void *buffer, MPI_Count size) MPICH_API_PUBLIC;
int PMPI_Buffer_detach(void *buffer_addr, int *size) MPICH_API_PUBLIC;
int PMPI_Buffer_detach_c(void *buffer_addr, MPI_Count *size) MPICH_API_PUBLIC;
int PMPI_Buffer_flush(void) MPICH_API_PUBLIC;
int PMPI_Buffer_iflush(ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Cancel(ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Cart_coords(ABI_Comm comm, int rank, int maxdims, int coords[]) MPICH_API_PUBLIC;
int PMPI_Cart_create(ABI_Comm comm_old, int ndims, const int dims[], const int periods[], int reorder, ABI_Comm *comm_cart) MPICH_API_PUBLIC;
int PMPI_Cart_get(ABI_Comm comm, int maxdims, int dims[], int periods[], int coords[]) MPICH_API_PUBLIC;
int PMPI_Cart_map(ABI_Comm comm, int ndims, const int dims[], const int periods[], int *newrank) MPICH_API_PUBLIC;
int PMPI_Cart_rank(ABI_Comm comm, const int coords[], int *rank) MPICH_API_PUBLIC;
int PMPI_Cart_shift(ABI_Comm comm, int direction, int disp, int *rank_source, int *rank_dest) MPICH_API_PUBLIC;
int PMPI_Cart_sub(ABI_Comm comm, const int remain_dims[], ABI_Comm *newcomm) MPICH_API_PUBLIC;
int PMPI_Cartdim_get(ABI_Comm comm, int *ndims) MPICH_API_PUBLIC;
int PMPI_Close_port(const char *port_name) MPICH_API_PUBLIC;
int PMPI_Comm_accept(const char *port_name, ABI_Info info, int root, ABI_Comm comm, ABI_Comm *newcomm) MPICH_API_PUBLIC;
int PMPI_Comm_attach_buffer(ABI_Comm comm, void *buffer, int size) MPICH_API_PUBLIC;
int PMPI_Comm_attach_buffer_c(ABI_Comm comm, void *buffer, MPI_Count size) MPICH_API_PUBLIC;
int PMPI_Comm_call_errhandler(ABI_Comm comm, int errorcode) MPICH_API_PUBLIC;
int PMPI_Comm_compare(ABI_Comm comm1, ABI_Comm comm2, int *result) MPICH_API_PUBLIC;
int PMPI_Comm_connect(const char *port_name, ABI_Info info, int root, ABI_Comm comm, ABI_Comm *newcomm) MPICH_API_PUBLIC;
int PMPI_Comm_create(ABI_Comm comm, ABI_Group group, ABI_Comm *newcomm) MPICH_API_PUBLIC;
int PMPI_Comm_create_errhandler(MPI_Comm_errhandler_function *comm_errhandler_fn, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int PMPIX_Comm_create_errhandler_x(MPIX_Comm_errhandler_function_x *comm_errhandler_fn_x, MPIX_Destructor_function *destructor_fn, void *extra_state, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int PMPI_Comm_create_from_group(ABI_Group group, const char *stringtag, ABI_Info info, ABI_Errhandler errhandler, ABI_Comm *newcomm) MPICH_API_PUBLIC;
int PMPI_Comm_create_group(ABI_Comm comm, ABI_Group group, int tag, ABI_Comm *newcomm) MPICH_API_PUBLIC;
int PMPI_Comm_create_keyval(MPI_Comm_copy_attr_function *comm_copy_attr_fn, MPI_Comm_delete_attr_function *comm_delete_attr_fn, int *comm_keyval, void *extra_state) MPICH_API_PUBLIC;
int PMPI_Comm_delete_attr(ABI_Comm comm, int comm_keyval) MPICH_API_PUBLIC;
int PMPI_Comm_detach_buffer(ABI_Comm comm, void *buffer_addr, int *size) MPICH_API_PUBLIC;
int PMPI_Comm_detach_buffer_c(ABI_Comm comm, void *buffer_addr, MPI_Count *size) MPICH_API_PUBLIC;
int PMPI_Comm_disconnect(ABI_Comm *comm) MPICH_API_PUBLIC;
int PMPI_Comm_dup(ABI_Comm comm, ABI_Comm *newcomm) MPICH_API_PUBLIC;
int PMPI_Comm_dup_with_info(ABI_Comm comm, ABI_Info info, ABI_Comm *newcomm) MPICH_API_PUBLIC;
int PMPI_Comm_flush_buffer(ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Comm_free(ABI_Comm *comm) MPICH_API_PUBLIC;
int PMPI_Comm_free_keyval(int *comm_keyval) MPICH_API_PUBLIC;
int PMPI_Comm_get_attr(ABI_Comm comm, int comm_keyval, void *attribute_val, int *flag) MPICH_API_PUBLIC;
int PMPI_Comm_get_errhandler(ABI_Comm comm, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int PMPI_Comm_get_info(ABI_Comm comm, ABI_Info *info_used) MPICH_API_PUBLIC;
int PMPI_Comm_get_name(ABI_Comm comm, char *comm_name, int *resultlen) MPICH_API_PUBLIC;
int PMPI_Comm_get_parent(ABI_Comm *parent) MPICH_API_PUBLIC;
int PMPI_Comm_group(ABI_Comm comm, ABI_Group *group) MPICH_API_PUBLIC;
int PMPI_Comm_idup(ABI_Comm comm, ABI_Comm *newcomm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Comm_idup_with_info(ABI_Comm comm, ABI_Info info, ABI_Comm *newcomm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Comm_iflush_buffer(ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Comm_join(int fd, ABI_Comm *intercomm) MPICH_API_PUBLIC;
int PMPI_Comm_rank(ABI_Comm comm, int *rank) MPICH_API_PUBLIC;
int PMPI_Comm_remote_group(ABI_Comm comm, ABI_Group *group) MPICH_API_PUBLIC;
int PMPI_Comm_remote_size(ABI_Comm comm, int *size) MPICH_API_PUBLIC;
int PMPI_Comm_set_attr(ABI_Comm comm, int comm_keyval, void *attribute_val) MPICH_API_PUBLIC;
int PMPI_Comm_set_errhandler(ABI_Comm comm, ABI_Errhandler errhandler) MPICH_API_PUBLIC;
int PMPI_Comm_set_info(ABI_Comm comm, ABI_Info info) MPICH_API_PUBLIC;
int PMPI_Comm_set_name(ABI_Comm comm, const char *comm_name) MPICH_API_PUBLIC;
int PMPI_Comm_size(ABI_Comm comm, int *size) MPICH_API_PUBLIC;
int PMPI_Comm_spawn(const char *command, char *argv[], int maxprocs, ABI_Info info, int root, ABI_Comm comm, ABI_Comm *intercomm, int array_of_errcodes[]) MPICH_API_PUBLIC;
int PMPI_Comm_spawn_multiple(int count, char *array_of_commands[], char **array_of_argv[], const int array_of_maxprocs[], const ABI_Info array_of_info[], int root, ABI_Comm comm, ABI_Comm *intercomm, int array_of_errcodes[]) MPICH_API_PUBLIC;
int PMPI_Comm_split(ABI_Comm comm, int color, int key, ABI_Comm *newcomm) MPICH_API_PUBLIC;
int PMPI_Comm_split_type(ABI_Comm comm, int split_type, int key, ABI_Info info, ABI_Comm *newcomm) MPICH_API_PUBLIC;
int PMPI_Comm_test_inter(ABI_Comm comm, int *flag) MPICH_API_PUBLIC;
int PMPI_Compare_and_swap(const void *origin_addr, const void *compare_addr, void *result_addr, ABI_Datatype datatype, int target_rank, MPI_Aint target_disp, ABI_Win win) MPICH_API_PUBLIC;
int PMPI_Dims_create(int nnodes, int ndims, int dims[]) MPICH_API_PUBLIC;
int PMPI_Dist_graph_create(ABI_Comm comm_old, int n, const int sources[], const int degrees[], const int destinations[], const int weights[], ABI_Info info, int reorder, ABI_Comm *comm_dist_graph) MPICH_API_PUBLIC;
int PMPI_Dist_graph_create_adjacent(ABI_Comm comm_old, int indegree, const int sources[], const int sourceweights[], int outdegree, const int destinations[], const int destweights[], ABI_Info info, int reorder, ABI_Comm *comm_dist_graph) MPICH_API_PUBLIC;
int PMPI_Dist_graph_neighbors(ABI_Comm comm, int maxindegree, int sources[], int sourceweights[], int maxoutdegree, int destinations[], int destweights[]) MPICH_API_PUBLIC;
int PMPI_Dist_graph_neighbors_count(ABI_Comm comm, int *indegree, int *outdegree, int *weighted) MPICH_API_PUBLIC;
int PMPI_Errhandler_free(ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int PMPI_Error_class(int errorcode, int *errorclass) MPICH_API_PUBLIC;
int PMPI_Error_string(int errorcode, char *string, int *resultlen) MPICH_API_PUBLIC;
int PMPI_Exscan(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Exscan_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Exscan_init(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Exscan_init_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Fetch_and_op(const void *origin_addr, void *result_addr, ABI_Datatype datatype, int target_rank, MPI_Aint target_disp, ABI_Op op, ABI_Win win) MPICH_API_PUBLIC;
int PMPI_File_call_errhandler(ABI_File fh, int errorcode) MPICH_API_PUBLIC;
int PMPI_File_close(ABI_File *fh) MPICH_API_PUBLIC;
int PMPI_File_create_errhandler(MPI_File_errhandler_function *file_errhandler_fn, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int PMPIX_File_create_errhandler_x(MPIX_File_errhandler_function_x *comm_errhandler_fn_x, MPIX_Destructor_function *destructor_fn, void *extra_state, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int PMPI_File_delete(const char *filename, ABI_Info info) MPICH_API_PUBLIC;
int PMPI_File_get_amode(ABI_File fh, int *amode) MPICH_API_PUBLIC;
int PMPI_File_get_atomicity(ABI_File fh, int *flag) MPICH_API_PUBLIC;
int PMPI_File_get_byte_offset(ABI_File fh, MPI_Offset offset, MPI_Offset *disp) MPICH_API_PUBLIC;
int PMPI_File_get_errhandler(ABI_File file, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int PMPI_File_get_group(ABI_File fh, ABI_Group *group) MPICH_API_PUBLIC;
int PMPI_File_get_info(ABI_File fh, ABI_Info *info_used) MPICH_API_PUBLIC;
int PMPI_File_get_position(ABI_File fh, MPI_Offset *offset) MPICH_API_PUBLIC;
int PMPI_File_get_position_shared(ABI_File fh, MPI_Offset *offset) MPICH_API_PUBLIC;
int PMPI_File_get_size(ABI_File fh, MPI_Offset *size) MPICH_API_PUBLIC;
int PMPI_File_get_type_extent(ABI_File fh, ABI_Datatype datatype, MPI_Aint *extent) MPICH_API_PUBLIC;
int PMPI_File_get_type_extent_c(ABI_File fh, ABI_Datatype datatype, MPI_Count *extent) MPICH_API_PUBLIC;
int PMPI_File_get_view(ABI_File fh, MPI_Offset *disp, ABI_Datatype *etype, ABI_Datatype *filetype, char *datarep) MPICH_API_PUBLIC;
int PMPI_File_iread(ABI_File fh, void *buf, int count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_File_iread_c(ABI_File fh, void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_File_iread_all(ABI_File fh, void *buf, int count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_File_iread_all_c(ABI_File fh, void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_File_iread_at(ABI_File fh, MPI_Offset offset, void *buf, int count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_File_iread_at_c(ABI_File fh, MPI_Offset offset, void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_File_iread_at_all(ABI_File fh, MPI_Offset offset, void *buf, int count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_File_iread_at_all_c(ABI_File fh, MPI_Offset offset, void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_File_iread_shared(ABI_File fh, void *buf, int count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_File_iread_shared_c(ABI_File fh, void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_File_iwrite(ABI_File fh, const void *buf, int count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_File_iwrite_c(ABI_File fh, const void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_File_iwrite_all(ABI_File fh, const void *buf, int count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_File_iwrite_all_c(ABI_File fh, const void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_File_iwrite_at(ABI_File fh, MPI_Offset offset, const void *buf, int count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_File_iwrite_at_c(ABI_File fh, MPI_Offset offset, const void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_File_iwrite_at_all(ABI_File fh, MPI_Offset offset, const void *buf, int count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_File_iwrite_at_all_c(ABI_File fh, MPI_Offset offset, const void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_File_iwrite_shared(ABI_File fh, const void *buf, int count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_File_iwrite_shared_c(ABI_File fh, const void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_File_open(ABI_Comm comm, const char *filename, int amode, ABI_Info info, ABI_File *fh) MPICH_API_PUBLIC;
int PMPI_File_preallocate(ABI_File fh, MPI_Offset size) MPICH_API_PUBLIC;
int PMPI_File_read(ABI_File fh, void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_read_c(ABI_File fh, void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_read_all(ABI_File fh, void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_read_all_c(ABI_File fh, void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_read_all_begin(ABI_File fh, void *buf, int count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int PMPI_File_read_all_begin_c(ABI_File fh, void *buf, MPI_Count count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int PMPI_File_read_all_end(ABI_File fh, void *buf, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_read_at(ABI_File fh, MPI_Offset offset, void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_read_at_c(ABI_File fh, MPI_Offset offset, void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_read_at_all(ABI_File fh, MPI_Offset offset, void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_read_at_all_c(ABI_File fh, MPI_Offset offset, void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_read_at_all_begin(ABI_File fh, MPI_Offset offset, void *buf, int count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int PMPI_File_read_at_all_begin_c(ABI_File fh, MPI_Offset offset, void *buf, MPI_Count count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int PMPI_File_read_at_all_end(ABI_File fh, void *buf, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_read_ordered(ABI_File fh, void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_read_ordered_c(ABI_File fh, void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_read_ordered_begin(ABI_File fh, void *buf, int count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int PMPI_File_read_ordered_begin_c(ABI_File fh, void *buf, MPI_Count count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int PMPI_File_read_ordered_end(ABI_File fh, void *buf, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_read_shared(ABI_File fh, void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_read_shared_c(ABI_File fh, void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_seek(ABI_File fh, MPI_Offset offset, int whence) MPICH_API_PUBLIC;
int PMPI_File_seek_shared(ABI_File fh, MPI_Offset offset, int whence) MPICH_API_PUBLIC;
int PMPI_File_set_atomicity(ABI_File fh, int flag) MPICH_API_PUBLIC;
int PMPI_File_set_errhandler(ABI_File file, ABI_Errhandler errhandler) MPICH_API_PUBLIC;
int PMPI_File_set_info(ABI_File fh, ABI_Info info) MPICH_API_PUBLIC;
int PMPI_File_set_size(ABI_File fh, MPI_Offset size) MPICH_API_PUBLIC;
int PMPI_File_set_view(ABI_File fh, MPI_Offset disp, ABI_Datatype etype, ABI_Datatype filetype, const char *datarep, ABI_Info info) MPICH_API_PUBLIC;
int PMPI_File_sync(ABI_File fh) MPICH_API_PUBLIC;
int PMPI_File_write(ABI_File fh, const void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_write_c(ABI_File fh, const void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_write_all(ABI_File fh, const void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_write_all_c(ABI_File fh, const void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_write_all_begin(ABI_File fh, const void *buf, int count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int PMPI_File_write_all_begin_c(ABI_File fh, const void *buf, MPI_Count count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int PMPI_File_write_all_end(ABI_File fh, const void *buf, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_write_at(ABI_File fh, MPI_Offset offset, const void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_write_at_c(ABI_File fh, MPI_Offset offset, const void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_write_at_all(ABI_File fh, MPI_Offset offset, const void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_write_at_all_c(ABI_File fh, MPI_Offset offset, const void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_write_at_all_begin(ABI_File fh, MPI_Offset offset, const void *buf, int count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int PMPI_File_write_at_all_begin_c(ABI_File fh, MPI_Offset offset, const void *buf, MPI_Count count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int PMPI_File_write_at_all_end(ABI_File fh, const void *buf, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_write_ordered(ABI_File fh, const void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_write_ordered_c(ABI_File fh, const void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_write_ordered_begin(ABI_File fh, const void *buf, int count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int PMPI_File_write_ordered_begin_c(ABI_File fh, const void *buf, MPI_Count count, ABI_Datatype datatype) MPICH_API_PUBLIC;
int PMPI_File_write_ordered_end(ABI_File fh, const void *buf, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_write_shared(ABI_File fh, const void *buf, int count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_File_write_shared_c(ABI_File fh, const void *buf, MPI_Count count, ABI_Datatype datatype, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_Finalize(void) MPICH_API_PUBLIC;
int PMPI_Finalized(int *flag) MPICH_API_PUBLIC;
int PMPI_Free_mem(void *base) MPICH_API_PUBLIC;
int PMPI_Gather(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Gather_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Gather_init(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Gather_init_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Gatherv(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int displs[], ABI_Datatype recvtype, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Gatherv_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint displs[], ABI_Datatype recvtype, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Gatherv_init(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int displs[], ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Gatherv_init_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint displs[], ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Get(void *origin_addr, int origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, int target_count, ABI_Datatype target_datatype, ABI_Win win) MPICH_API_PUBLIC;
int PMPI_Get_c(void *origin_addr, MPI_Count origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, MPI_Count target_count, ABI_Datatype target_datatype, ABI_Win win) MPICH_API_PUBLIC;
int PMPI_Get_accumulate(const void *origin_addr, int origin_count, ABI_Datatype origin_datatype, void *result_addr, int result_count, ABI_Datatype result_datatype, int target_rank, MPI_Aint target_disp, int target_count, ABI_Datatype target_datatype, ABI_Op op, ABI_Win win) MPICH_API_PUBLIC;
int PMPI_Get_accumulate_c(const void *origin_addr, MPI_Count origin_count, ABI_Datatype origin_datatype, void *result_addr, MPI_Count result_count, ABI_Datatype result_datatype, int target_rank, MPI_Aint target_disp, MPI_Count target_count, ABI_Datatype target_datatype, ABI_Op op, ABI_Win win) MPICH_API_PUBLIC;
int PMPI_Get_address(const void *location, MPI_Aint *address) MPICH_API_PUBLIC;
int PMPI_Get_count(const MPI_Status *status, ABI_Datatype datatype, int *count) MPICH_API_PUBLIC;
int PMPI_Get_count_c(const MPI_Status *status, ABI_Datatype datatype, MPI_Count *count) MPICH_API_PUBLIC;
int PMPI_Get_elements(const MPI_Status *status, ABI_Datatype datatype, int *count) MPICH_API_PUBLIC;
int PMPI_Get_elements_c(const MPI_Status *status, ABI_Datatype datatype, MPI_Count *count) MPICH_API_PUBLIC;
int PMPI_Get_elements_x(const MPI_Status *status, ABI_Datatype datatype, MPI_Count *count) MPICH_API_PUBLIC;
int PMPI_Get_hw_resource_info(ABI_Info *hw_info) MPICH_API_PUBLIC;
int PMPI_Get_library_version(char *version, int *resultlen) MPICH_API_PUBLIC;
int PMPI_Get_processor_name(char *name, int *resultlen) MPICH_API_PUBLIC;
int PMPI_Get_version(int *version, int *subversion) MPICH_API_PUBLIC;
int PMPI_Graph_create(ABI_Comm comm_old, int nnodes, const int indx[], const int edges[], int reorder, ABI_Comm *comm_graph) MPICH_API_PUBLIC;
int PMPI_Graph_get(ABI_Comm comm, int maxindex, int maxedges, int indx[], int edges[]) MPICH_API_PUBLIC;
int PMPI_Graph_map(ABI_Comm comm, int nnodes, const int indx[], const int edges[], int *newrank) MPICH_API_PUBLIC;
int PMPI_Graph_neighbors(ABI_Comm comm, int rank, int maxneighbors, int neighbors[]) MPICH_API_PUBLIC;
int PMPI_Graph_neighbors_count(ABI_Comm comm, int rank, int *nneighbors) MPICH_API_PUBLIC;
int PMPI_Graphdims_get(ABI_Comm comm, int *nnodes, int *nedges) MPICH_API_PUBLIC;
int PMPI_Grequest_complete(ABI_Request request) MPICH_API_PUBLIC;
int PMPI_Grequest_start(MPI_Grequest_query_function *query_fn, MPI_Grequest_free_function *free_fn, MPI_Grequest_cancel_function *cancel_fn, void *extra_state, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Group_compare(ABI_Group group1, ABI_Group group2, int *result) MPICH_API_PUBLIC;
int PMPI_Group_difference(ABI_Group group1, ABI_Group group2, ABI_Group *newgroup) MPICH_API_PUBLIC;
int PMPI_Group_excl(ABI_Group group, int n, const int ranks[], ABI_Group *newgroup) MPICH_API_PUBLIC;
int PMPI_Group_free(ABI_Group *group) MPICH_API_PUBLIC;
int PMPI_Group_from_session_pset(ABI_Session session, const char *pset_name, ABI_Group *newgroup) MPICH_API_PUBLIC;
int PMPI_Group_incl(ABI_Group group, int n, const int ranks[], ABI_Group *newgroup) MPICH_API_PUBLIC;
int PMPI_Group_intersection(ABI_Group group1, ABI_Group group2, ABI_Group *newgroup) MPICH_API_PUBLIC;
int PMPI_Group_range_excl(ABI_Group group, int n, int ranges[][3], ABI_Group *newgroup) MPICH_API_PUBLIC;
int PMPI_Group_range_incl(ABI_Group group, int n, int ranges[][3], ABI_Group *newgroup) MPICH_API_PUBLIC;
int PMPI_Group_rank(ABI_Group group, int *rank) MPICH_API_PUBLIC;
int PMPI_Group_size(ABI_Group group, int *size) MPICH_API_PUBLIC;
int PMPI_Group_translate_ranks(ABI_Group group1, int n, const int ranks1[], ABI_Group group2, int ranks2[]) MPICH_API_PUBLIC;
int PMPI_Group_union(ABI_Group group1, ABI_Group group2, ABI_Group *newgroup) MPICH_API_PUBLIC;
int PMPI_Iallgather(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Iallgather_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Iallgatherv(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int displs[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Iallgatherv_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint displs[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Iallreduce(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Iallreduce_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ialltoall(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ialltoall_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ialltoallv(const void *sendbuf, const int sendcounts[], const int sdispls[], ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int rdispls[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ialltoallv_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ialltoallw(const void *sendbuf, const int sendcounts[], const int sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const int recvcounts[], const int rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ialltoallw_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ibarrier(ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ibcast(void *buffer, int count, ABI_Datatype datatype, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ibcast_c(void *buffer, MPI_Count count, ABI_Datatype datatype, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ibsend(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ibsend_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Iexscan(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Iexscan_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Igather(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Igather_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Igatherv(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int displs[], ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Igatherv_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint displs[], ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Improbe(int source, int tag, ABI_Comm comm, int *flag, ABI_Message *message, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_Imrecv(void *buf, int count, ABI_Datatype datatype, ABI_Message *message, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Imrecv_c(void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Message *message, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ineighbor_allgather(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ineighbor_allgather_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ineighbor_allgatherv(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int displs[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ineighbor_allgatherv_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint displs[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ineighbor_alltoall(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ineighbor_alltoall_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ineighbor_alltoallv(const void *sendbuf, const int sendcounts[], const int sdispls[], ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int rdispls[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ineighbor_alltoallv_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ineighbor_alltoallw(const void *sendbuf, const int sendcounts[], const MPI_Aint sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const int recvcounts[], const MPI_Aint rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ineighbor_alltoallw_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Info_create(ABI_Info *info) MPICH_API_PUBLIC;
int PMPI_Info_create_env(int argc, char *argv[], ABI_Info *info) MPICH_API_PUBLIC;
int PMPI_Info_delete(ABI_Info info, const char *key) MPICH_API_PUBLIC;
int PMPI_Info_dup(ABI_Info info, ABI_Info *newinfo) MPICH_API_PUBLIC;
int PMPI_Info_free(ABI_Info *info) MPICH_API_PUBLIC;
int PMPI_Info_get(ABI_Info info, const char *key, int valuelen, char *value, int *flag) MPICH_API_PUBLIC;
int PMPI_Info_get_nkeys(ABI_Info info, int *nkeys) MPICH_API_PUBLIC;
int PMPI_Info_get_nthkey(ABI_Info info, int n, char *key) MPICH_API_PUBLIC;
int PMPI_Info_get_string(ABI_Info info, const char *key, int *buflen, char *value, int *flag) MPICH_API_PUBLIC;
int PMPI_Info_get_valuelen(ABI_Info info, const char *key, int *valuelen, int *flag) MPICH_API_PUBLIC;
int PMPI_Info_set(ABI_Info info, const char *key, const char *value) MPICH_API_PUBLIC;
int PMPI_Init(int *argc, char ***argv) MPICH_API_PUBLIC;
int PMPI_Init_thread(int *argc, char ***argv, int required, int *provided) MPICH_API_PUBLIC;
int PMPI_Initialized(int *flag) MPICH_API_PUBLIC;
int PMPI_Intercomm_create(ABI_Comm local_comm, int local_leader, ABI_Comm peer_comm, int remote_leader, int tag, ABI_Comm *newintercomm) MPICH_API_PUBLIC;
int PMPI_Intercomm_create_from_groups(ABI_Group local_group, int local_leader, ABI_Group remote_group, int remote_leader, const char *stringtag, ABI_Info info, ABI_Errhandler errhandler, ABI_Comm *newintercomm) MPICH_API_PUBLIC;
int PMPI_Intercomm_merge(ABI_Comm intercomm, int high, ABI_Comm *newintracomm) MPICH_API_PUBLIC;
int PMPI_Iprobe(int source, int tag, ABI_Comm comm, int *flag, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_Irecv(void *buf, int count, ABI_Datatype datatype, int source, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Irecv_c(void *buf, MPI_Count count, ABI_Datatype datatype, int source, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ireduce(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ireduce_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ireduce_scatter(const void *sendbuf, void *recvbuf, const int recvcounts[], ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ireduce_scatter_c(const void *sendbuf, void *recvbuf, const MPI_Count recvcounts[], ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ireduce_scatter_block(const void *sendbuf, void *recvbuf, int recvcount, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ireduce_scatter_block_c(const void *sendbuf, void *recvbuf, MPI_Count recvcount, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Irsend(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Irsend_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Is_thread_main(int *flag) MPICH_API_PUBLIC;
int PMPI_Iscan(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Iscan_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Iscatter(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Iscatter_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Iscatterv(const void *sendbuf, const int sendcounts[], const int displs[], ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Iscatterv_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint displs[], ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Isend(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Isend_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Isendrecv(const void *sendbuf, int sendcount, ABI_Datatype sendtype, int dest, int sendtag, void *recvbuf, int recvcount, ABI_Datatype recvtype, int source, int recvtag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Isendrecv_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, int dest, int sendtag, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, int source, int recvtag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Isendrecv_replace(void *buf, int count, ABI_Datatype datatype, int dest, int sendtag, int source, int recvtag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Isendrecv_replace_c(void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int sendtag, int source, int recvtag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Issend(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Issend_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Keyval_create(MPI_Copy_function *copy_fn, MPI_Delete_function *delete_fn, int *keyval, void *extra_state) MPICH_API_PUBLIC;
int PMPI_Keyval_free(int *keyval) MPICH_API_PUBLIC;
int PMPI_Lookup_name(const char *service_name, ABI_Info info, char *port_name) MPICH_API_PUBLIC;
int PMPI_Mprobe(int source, int tag, ABI_Comm comm, ABI_Message *message, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_Mrecv(void *buf, int count, ABI_Datatype datatype, ABI_Message *message, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_Mrecv_c(void *buf, MPI_Count count, ABI_Datatype datatype, ABI_Message *message, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_Neighbor_allgather(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Neighbor_allgather_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Neighbor_allgather_init(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Neighbor_allgather_init_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Neighbor_allgatherv(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int displs[], ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Neighbor_allgatherv_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint displs[], ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Neighbor_allgatherv_init(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int displs[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Neighbor_allgatherv_init_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint displs[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Neighbor_alltoall(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Neighbor_alltoall_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Neighbor_alltoall_init(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Neighbor_alltoall_init_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Neighbor_alltoallv(const void *sendbuf, const int sendcounts[], const int sdispls[], ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int rdispls[], ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Neighbor_alltoallv_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], ABI_Datatype recvtype, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Neighbor_alltoallv_init(const void *sendbuf, const int sendcounts[], const int sdispls[], ABI_Datatype sendtype, void *recvbuf, const int recvcounts[], const int rdispls[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Neighbor_alltoallv_init_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], ABI_Datatype sendtype, void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], ABI_Datatype recvtype, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Neighbor_alltoallw(const void *sendbuf, const int sendcounts[], const MPI_Aint sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const int recvcounts[], const MPI_Aint rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Neighbor_alltoallw_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Neighbor_alltoallw_init(const void *sendbuf, const int sendcounts[], const MPI_Aint sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const int recvcounts[], const MPI_Aint rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Neighbor_alltoallw_init_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint sdispls[], const ABI_Datatype sendtypes[], void *recvbuf, const MPI_Count recvcounts[], const MPI_Aint rdispls[], const ABI_Datatype recvtypes[], ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Op_commutative(ABI_Op op, int *commute) MPICH_API_PUBLIC;
int PMPI_Op_create(MPI_User_function *user_fn, int commute, ABI_Op *op) MPICH_API_PUBLIC;
int PMPI_Op_create_c(MPI_User_function_c *user_fn, int commute, ABI_Op *op) MPICH_API_PUBLIC;
int PMPI_Op_free(ABI_Op *op) MPICH_API_PUBLIC;
int PMPI_Open_port(ABI_Info info, char *port_name) MPICH_API_PUBLIC;
int PMPI_Pack(const void *inbuf, int incount, ABI_Datatype datatype, void *outbuf, int outsize, int *position, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Pack_c(const void *inbuf, MPI_Count incount, ABI_Datatype datatype, void *outbuf, MPI_Count outsize, MPI_Count *position, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Pack_external(const char *datarep, const void *inbuf, int incount, ABI_Datatype datatype, void *outbuf, MPI_Aint outsize, MPI_Aint *position) MPICH_API_PUBLIC;
int PMPI_Pack_external_c(const char *datarep, const void *inbuf, MPI_Count incount, ABI_Datatype datatype, void *outbuf, MPI_Count outsize, MPI_Count *position) MPICH_API_PUBLIC;
int PMPI_Pack_external_size(const char *datarep, int incount, ABI_Datatype datatype, MPI_Aint *size) MPICH_API_PUBLIC;
int PMPI_Pack_external_size_c(const char *datarep, MPI_Count incount, ABI_Datatype datatype, MPI_Count *size) MPICH_API_PUBLIC;
int PMPI_Pack_size(int incount, ABI_Datatype datatype, ABI_Comm comm, int *size) MPICH_API_PUBLIC;
int PMPI_Pack_size_c(MPI_Count incount, ABI_Datatype datatype, ABI_Comm comm, MPI_Count *size) MPICH_API_PUBLIC;
int PMPI_Parrived(ABI_Request request, int partition, int *flag) MPICH_API_PUBLIC;
int PMPI_Pcontrol(const int level, ...) MPICH_API_PUBLIC;
int PMPI_Pready(int partition, ABI_Request request) MPICH_API_PUBLIC;
int PMPI_Pready_list(int length, const int array_of_partitions[], ABI_Request request) MPICH_API_PUBLIC;
int PMPI_Pready_range(int partition_low, int partition_high, ABI_Request request) MPICH_API_PUBLIC;
int PMPI_Precv_init(void *buf, int partitions, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Probe(int source, int tag, ABI_Comm comm, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_Psend_init(const void *buf, int partitions, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Publish_name(const char *service_name, ABI_Info info, const char *port_name) MPICH_API_PUBLIC;
int PMPI_Put(const void *origin_addr, int origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, int target_count, ABI_Datatype target_datatype, ABI_Win win) MPICH_API_PUBLIC;
int PMPI_Put_c(const void *origin_addr, MPI_Count origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, MPI_Count target_count, ABI_Datatype target_datatype, ABI_Win win) MPICH_API_PUBLIC;
int PMPI_Query_thread(int *provided) MPICH_API_PUBLIC;
int PMPI_Raccumulate(const void *origin_addr, int origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, int target_count, ABI_Datatype target_datatype, ABI_Op op, ABI_Win win, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Raccumulate_c(const void *origin_addr, MPI_Count origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, MPI_Count target_count, ABI_Datatype target_datatype, ABI_Op op, ABI_Win win, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Recv(void *buf, int count, ABI_Datatype datatype, int source, int tag, ABI_Comm comm, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_Recv_c(void *buf, MPI_Count count, ABI_Datatype datatype, int source, int tag, ABI_Comm comm, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_Recv_init(void *buf, int count, ABI_Datatype datatype, int source, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Recv_init_c(void *buf, MPI_Count count, ABI_Datatype datatype, int source, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Reduce(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Reduce_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Reduce_init(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Reduce_init_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Reduce_local(const void *inbuf, void *inoutbuf, int count, ABI_Datatype datatype, ABI_Op op) MPICH_API_PUBLIC;
int PMPI_Reduce_local_c(const void *inbuf, void *inoutbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op) MPICH_API_PUBLIC;
int PMPI_Reduce_scatter(const void *sendbuf, void *recvbuf, const int recvcounts[], ABI_Datatype datatype, ABI_Op op, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Reduce_scatter_c(const void *sendbuf, void *recvbuf, const MPI_Count recvcounts[], ABI_Datatype datatype, ABI_Op op, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Reduce_scatter_block(const void *sendbuf, void *recvbuf, int recvcount, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Reduce_scatter_block_c(const void *sendbuf, void *recvbuf, MPI_Count recvcount, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Reduce_scatter_block_init(const void *sendbuf, void *recvbuf, int recvcount, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Reduce_scatter_block_init_c(const void *sendbuf, void *recvbuf, MPI_Count recvcount, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Reduce_scatter_init(const void *sendbuf, void *recvbuf, const int recvcounts[], ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Reduce_scatter_init_c(const void *sendbuf, void *recvbuf, const MPI_Count recvcounts[], ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Register_datarep(const char *datarep, MPI_Datarep_conversion_function *read_conversion_fn, MPI_Datarep_conversion_function *write_conversion_fn, MPI_Datarep_extent_function *dtype_file_extent_fn, void *extra_state) MPICH_API_PUBLIC;
int PMPI_Register_datarep_c(const char *datarep, MPI_Datarep_conversion_function_c *read_conversion_fn, MPI_Datarep_conversion_function_c *write_conversion_fn, MPI_Datarep_extent_function *dtype_file_extent_fn, void *extra_state) MPICH_API_PUBLIC;
int PMPI_Remove_error_class(int errorclass) MPICH_API_PUBLIC;
int PMPI_Remove_error_code(int errorcode) MPICH_API_PUBLIC;
int PMPI_Remove_error_string(int errorcode) MPICH_API_PUBLIC;
int PMPI_Request_free(ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Request_get_status(ABI_Request request, int *flag, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_Request_get_status_all(int count, const ABI_Request array_of_requests[], int *flag, MPI_Status *array_of_statuses) MPICH_API_PUBLIC;
int PMPI_Request_get_status_any(int count, const ABI_Request array_of_requests[], int *indx, int *flag, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_Request_get_status_some(int incount, const ABI_Request array_of_requests[], int *outcount, int array_of_indices[], MPI_Status *array_of_statuses) MPICH_API_PUBLIC;
int PMPI_Rget(void *origin_addr, int origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, int target_count, ABI_Datatype target_datatype, ABI_Win win, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Rget_c(void *origin_addr, MPI_Count origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, MPI_Count target_count, ABI_Datatype target_datatype, ABI_Win win, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Rget_accumulate(const void *origin_addr, int origin_count, ABI_Datatype origin_datatype, void *result_addr, int result_count, ABI_Datatype result_datatype, int target_rank, MPI_Aint target_disp, int target_count, ABI_Datatype target_datatype, ABI_Op op, ABI_Win win, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Rget_accumulate_c(const void *origin_addr, MPI_Count origin_count, ABI_Datatype origin_datatype, void *result_addr, MPI_Count result_count, ABI_Datatype result_datatype, int target_rank, MPI_Aint target_disp, MPI_Count target_count, ABI_Datatype target_datatype, ABI_Op op, ABI_Win win, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Rput(const void *origin_addr, int origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, int target_count, ABI_Datatype target_datatype, ABI_Win win, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Rput_c(const void *origin_addr, MPI_Count origin_count, ABI_Datatype origin_datatype, int target_rank, MPI_Aint target_disp, MPI_Count target_count, ABI_Datatype target_datatype, ABI_Win win, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Rsend(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Rsend_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Rsend_init(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Rsend_init_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Scan(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Scan_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Scan_init(const void *sendbuf, void *recvbuf, int count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Scan_init_c(const void *sendbuf, void *recvbuf, MPI_Count count, ABI_Datatype datatype, ABI_Op op, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Scatter(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Scatter_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Scatter_init(const void *sendbuf, int sendcount, ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Scatter_init_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Scatterv(const void *sendbuf, const int sendcounts[], const int displs[], ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Scatterv_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint displs[], ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Scatterv_init(const void *sendbuf, const int sendcounts[], const int displs[], ABI_Datatype sendtype, void *recvbuf, int recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Scatterv_init_c(const void *sendbuf, const MPI_Count sendcounts[], const MPI_Aint displs[], ABI_Datatype sendtype, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, int root, ABI_Comm comm, ABI_Info info, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Send(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Send_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Send_init(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Send_init_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Sendrecv(const void *sendbuf, int sendcount, ABI_Datatype sendtype, int dest, int sendtag, void *recvbuf, int recvcount, ABI_Datatype recvtype, int source, int recvtag, ABI_Comm comm, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_Sendrecv_c(const void *sendbuf, MPI_Count sendcount, ABI_Datatype sendtype, int dest, int sendtag, void *recvbuf, MPI_Count recvcount, ABI_Datatype recvtype, int source, int recvtag, ABI_Comm comm, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_Sendrecv_replace(void *buf, int count, ABI_Datatype datatype, int dest, int sendtag, int source, int recvtag, ABI_Comm comm, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_Sendrecv_replace_c(void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int sendtag, int source, int recvtag, ABI_Comm comm, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_Session_attach_buffer(ABI_Session session, void *buffer, int size) MPICH_API_PUBLIC;
int PMPI_Session_attach_buffer_c(ABI_Session session, void *buffer, MPI_Count size) MPICH_API_PUBLIC;
int PMPI_Session_call_errhandler(ABI_Session session, int errorcode) MPICH_API_PUBLIC;
int PMPI_Session_create_errhandler(MPI_Session_errhandler_function *session_errhandler_fn, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int PMPIX_Session_create_errhandler_x(MPIX_Session_errhandler_function_x *comm_errhandler_fn_x, MPIX_Destructor_function *destructor_fn, void *extra_state, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int PMPI_Session_detach_buffer(ABI_Session session, void *buffer_addr, int *size) MPICH_API_PUBLIC;
int PMPI_Session_detach_buffer_c(ABI_Session session, void *buffer_addr, MPI_Count *size) MPICH_API_PUBLIC;
int PMPI_Session_finalize(ABI_Session *session) MPICH_API_PUBLIC;
int PMPI_Session_flush_buffer(ABI_Session session) MPICH_API_PUBLIC;
int PMPI_Session_get_errhandler(ABI_Session session, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int PMPI_Session_get_info(ABI_Session session, ABI_Info *info_used) MPICH_API_PUBLIC;
int PMPI_Session_get_nth_pset(ABI_Session session, ABI_Info info, int n, int *pset_len, char *pset_name) MPICH_API_PUBLIC;
int PMPI_Session_get_num_psets(ABI_Session session, ABI_Info info, int *npset_names) MPICH_API_PUBLIC;
int PMPI_Session_get_pset_info(ABI_Session session, const char *pset_name, ABI_Info *info) MPICH_API_PUBLIC;
int PMPI_Session_iflush_buffer(ABI_Session session, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Session_init(ABI_Info info, ABI_Errhandler errhandler, ABI_Session *session) MPICH_API_PUBLIC;
int PMPI_Session_set_errhandler(ABI_Session session, ABI_Errhandler errhandler) MPICH_API_PUBLIC;
int PMPI_Ssend(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Ssend_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Ssend_init(const void *buf, int count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Ssend_init_c(const void *buf, MPI_Count count, ABI_Datatype datatype, int dest, int tag, ABI_Comm comm, ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Start(ABI_Request *request) MPICH_API_PUBLIC;
int PMPI_Startall(int count, ABI_Request array_of_requests[]) MPICH_API_PUBLIC;
int PMPI_Status_get_error(const MPI_Status *status, int *error) MPICH_API_PUBLIC;
int PMPI_Status_get_source(const MPI_Status *status, int *source) MPICH_API_PUBLIC;
int PMPI_Status_get_tag(const MPI_Status *status, int *tag) MPICH_API_PUBLIC;
int PMPI_Status_set_cancelled(MPI_Status *status, int flag) MPICH_API_PUBLIC;
int PMPI_Status_set_elements(MPI_Status *status, ABI_Datatype datatype, int count) MPICH_API_PUBLIC;
int PMPI_Status_set_elements_c(MPI_Status *status, ABI_Datatype datatype, MPI_Count count) MPICH_API_PUBLIC;
int PMPI_Status_set_elements_x(MPI_Status *status, ABI_Datatype datatype, MPI_Count count) MPICH_API_PUBLIC;
int PMPI_Status_set_error(MPI_Status *status, int error) MPICH_API_PUBLIC;
int PMPI_Status_set_source(MPI_Status *status, int source) MPICH_API_PUBLIC;
int PMPI_Status_set_tag(MPI_Status *status, int tag) MPICH_API_PUBLIC;
int PMPI_Test(ABI_Request *request, int *flag, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_Test_cancelled(const MPI_Status *status, int *flag) MPICH_API_PUBLIC;
int PMPI_Testall(int count, ABI_Request array_of_requests[], int *flag, MPI_Status *array_of_statuses) MPICH_API_PUBLIC;
int PMPI_Testany(int count, ABI_Request array_of_requests[], int *indx, int *flag, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_Testsome(int incount, ABI_Request array_of_requests[], int *outcount, int array_of_indices[], MPI_Status *array_of_statuses) MPICH_API_PUBLIC;
int PMPI_Topo_test(ABI_Comm comm, int *status) MPICH_API_PUBLIC;
int PMPI_Type_commit(ABI_Datatype *datatype) MPICH_API_PUBLIC;
int PMPI_Type_contiguous(int count, ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_contiguous_c(MPI_Count count, ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_create_darray(int size, int rank, int ndims, const int array_of_gsizes[], const int array_of_distribs[], const int array_of_dargs[], const int array_of_psizes[], int order, ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_create_darray_c(int size, int rank, int ndims, const MPI_Count array_of_gsizes[], const int array_of_distribs[], const int array_of_dargs[], const int array_of_psizes[], int order, ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_create_f90_complex(int p, int r, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_create_f90_integer(int r, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_create_f90_real(int p, int r, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_create_hindexed(int count, const int array_of_blocklengths[], const MPI_Aint array_of_displacements[], ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_create_hindexed_c(MPI_Count count, const MPI_Count array_of_blocklengths[], const MPI_Count array_of_displacements[], ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_create_hindexed_block(int count, int blocklength, const MPI_Aint array_of_displacements[], ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_create_hindexed_block_c(MPI_Count count, MPI_Count blocklength, const MPI_Count array_of_displacements[], ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_create_hvector(int count, int blocklength, MPI_Aint stride, ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_create_hvector_c(MPI_Count count, MPI_Count blocklength, MPI_Count stride, ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_create_indexed_block(int count, int blocklength, const int array_of_displacements[], ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_create_indexed_block_c(MPI_Count count, MPI_Count blocklength, const MPI_Count array_of_displacements[], ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_create_keyval(MPI_Type_copy_attr_function *type_copy_attr_fn, MPI_Type_delete_attr_function *type_delete_attr_fn, int *type_keyval, void *extra_state) MPICH_API_PUBLIC;
int PMPI_Type_create_resized(ABI_Datatype oldtype, MPI_Aint lb, MPI_Aint extent, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_create_resized_c(ABI_Datatype oldtype, MPI_Count lb, MPI_Count extent, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_create_struct(int count, const int array_of_blocklengths[], const MPI_Aint array_of_displacements[], const ABI_Datatype array_of_types[], ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_create_struct_c(MPI_Count count, const MPI_Count array_of_blocklengths[], const MPI_Count array_of_displacements[], const ABI_Datatype array_of_types[], ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_create_subarray(int ndims, const int array_of_sizes[], const int array_of_subsizes[], const int array_of_starts[], int order, ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_create_subarray_c(int ndims, const MPI_Count array_of_sizes[], const MPI_Count array_of_subsizes[], const MPI_Count array_of_starts[], int order, ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_delete_attr(ABI_Datatype datatype, int type_keyval) MPICH_API_PUBLIC;
int PMPI_Type_dup(ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_free(ABI_Datatype *datatype) MPICH_API_PUBLIC;
int PMPI_Type_free_keyval(int *type_keyval) MPICH_API_PUBLIC;
int PMPI_Type_get_attr(ABI_Datatype datatype, int type_keyval, void *attribute_val, int *flag) MPICH_API_PUBLIC;
int PMPI_Type_get_contents(ABI_Datatype datatype, int max_integers, int max_addresses, int max_datatypes, int array_of_integers[], MPI_Aint array_of_addresses[], ABI_Datatype array_of_datatypes[]) MPICH_API_PUBLIC;
int PMPI_Type_get_contents_c(ABI_Datatype datatype, MPI_Count max_integers, MPI_Count max_addresses, MPI_Count max_large_counts, MPI_Count max_datatypes, int array_of_integers[], MPI_Aint array_of_addresses[], MPI_Count array_of_large_counts[], ABI_Datatype array_of_datatypes[]) MPICH_API_PUBLIC;
int PMPI_Type_get_envelope(ABI_Datatype datatype, int *num_integers, int *num_addresses, int *num_datatypes, int *combiner) MPICH_API_PUBLIC;
int PMPI_Type_get_envelope_c(ABI_Datatype datatype, MPI_Count *num_integers, MPI_Count *num_addresses, MPI_Count *num_large_counts, MPI_Count *num_datatypes, int *combiner) MPICH_API_PUBLIC;
int PMPI_Type_get_extent(ABI_Datatype datatype, MPI_Aint *lb, MPI_Aint *extent) MPICH_API_PUBLIC;
int PMPI_Type_get_extent_c(ABI_Datatype datatype, MPI_Count *lb, MPI_Count *extent) MPICH_API_PUBLIC;
int PMPI_Type_get_extent_x(ABI_Datatype datatype, MPI_Count *lb, MPI_Count *extent) MPICH_API_PUBLIC;
int PMPI_Type_get_name(ABI_Datatype datatype, char *type_name, int *resultlen) MPICH_API_PUBLIC;
int PMPI_Type_get_true_extent(ABI_Datatype datatype, MPI_Aint *true_lb, MPI_Aint *true_extent) MPICH_API_PUBLIC;
int PMPI_Type_get_true_extent_c(ABI_Datatype datatype, MPI_Count *true_lb, MPI_Count *true_extent) MPICH_API_PUBLIC;
int PMPI_Type_get_true_extent_x(ABI_Datatype datatype, MPI_Count *true_lb, MPI_Count *true_extent) MPICH_API_PUBLIC;
int PMPI_Type_get_value_index(ABI_Datatype value_type, ABI_Datatype index_type, ABI_Datatype *pair_type) MPICH_API_PUBLIC;
int PMPI_Type_indexed(int count, const int array_of_blocklengths[], const int array_of_displacements[], ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_indexed_c(MPI_Count count, const MPI_Count array_of_blocklengths[], const MPI_Count array_of_displacements[], ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_match_size(int typeclass, int size, ABI_Datatype *datatype) MPICH_API_PUBLIC;
int PMPI_Type_set_attr(ABI_Datatype datatype, int type_keyval, void *attribute_val) MPICH_API_PUBLIC;
int PMPI_Type_set_name(ABI_Datatype datatype, const char *type_name) MPICH_API_PUBLIC;
int PMPI_Type_size(ABI_Datatype datatype, int *size) MPICH_API_PUBLIC;
int PMPI_Type_size_c(ABI_Datatype datatype, MPI_Count *size) MPICH_API_PUBLIC;
int PMPI_Type_size_x(ABI_Datatype datatype, MPI_Count *size) MPICH_API_PUBLIC;
int PMPI_Type_vector(int count, int blocklength, int stride, ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Type_vector_c(MPI_Count count, MPI_Count blocklength, MPI_Count stride, ABI_Datatype oldtype, ABI_Datatype *newtype) MPICH_API_PUBLIC;
int PMPI_Unpack(const void *inbuf, int insize, int *position, void *outbuf, int outcount, ABI_Datatype datatype, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Unpack_c(const void *inbuf, MPI_Count insize, MPI_Count *position, void *outbuf, MPI_Count outcount, ABI_Datatype datatype, ABI_Comm comm) MPICH_API_PUBLIC;
int PMPI_Unpack_external(const char datarep[], const void *inbuf, MPI_Aint insize, MPI_Aint *position, void *outbuf, int outcount, ABI_Datatype datatype) MPICH_API_PUBLIC;
int PMPI_Unpack_external_c(const char datarep[], const void *inbuf, MPI_Count insize, MPI_Count *position, void *outbuf, MPI_Count outcount, ABI_Datatype datatype) MPICH_API_PUBLIC;
int PMPI_Unpublish_name(const char *service_name, ABI_Info info, const char *port_name) MPICH_API_PUBLIC;
int PMPI_Wait(ABI_Request *request, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_Waitall(int count, ABI_Request array_of_requests[], MPI_Status *array_of_statuses) MPICH_API_PUBLIC;
int PMPI_Waitany(int count, ABI_Request array_of_requests[], int *indx, MPI_Status *status) MPICH_API_PUBLIC;
int PMPI_Waitsome(int incount, ABI_Request array_of_requests[], int *outcount, int array_of_indices[], MPI_Status *array_of_statuses) MPICH_API_PUBLIC;
int PMPI_Win_allocate(MPI_Aint size, int disp_unit, ABI_Info info, ABI_Comm comm, void *baseptr, ABI_Win *win) MPICH_API_PUBLIC;
int PMPI_Win_allocate_c(MPI_Aint size, MPI_Aint disp_unit, ABI_Info info, ABI_Comm comm, void *baseptr, ABI_Win *win) MPICH_API_PUBLIC;
int PMPI_Win_allocate_shared(MPI_Aint size, int disp_unit, ABI_Info info, ABI_Comm comm, void *baseptr, ABI_Win *win) MPICH_API_PUBLIC;
int PMPI_Win_allocate_shared_c(MPI_Aint size, MPI_Aint disp_unit, ABI_Info info, ABI_Comm comm, void *baseptr, ABI_Win *win) MPICH_API_PUBLIC;
int PMPI_Win_attach(ABI_Win win, void *base, MPI_Aint size) MPICH_API_PUBLIC;
int PMPI_Win_call_errhandler(ABI_Win win, int errorcode) MPICH_API_PUBLIC;
int PMPI_Win_complete(ABI_Win win) MPICH_API_PUBLIC;
int PMPI_Win_create(void *base, MPI_Aint size, int disp_unit, ABI_Info info, ABI_Comm comm, ABI_Win *win) MPICH_API_PUBLIC;
int PMPI_Win_create_c(void *base, MPI_Aint size, MPI_Aint disp_unit, ABI_Info info, ABI_Comm comm, ABI_Win *win) MPICH_API_PUBLIC;
int PMPI_Win_create_dynamic(ABI_Info info, ABI_Comm comm, ABI_Win *win) MPICH_API_PUBLIC;
int PMPI_Win_create_errhandler(MPI_Win_errhandler_function *win_errhandler_fn, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int PMPIX_Win_create_errhandler_x(MPIX_Win_errhandler_function_x *comm_errhandler_fn_x, MPIX_Destructor_function *destructor_fn, void *extra_state, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int PMPI_Win_create_keyval(MPI_Win_copy_attr_function *win_copy_attr_fn, MPI_Win_delete_attr_function *win_delete_attr_fn, int *win_keyval, void *extra_state) MPICH_API_PUBLIC;
int PMPI_Win_delete_attr(ABI_Win win, int win_keyval) MPICH_API_PUBLIC;
int PMPI_Win_detach(ABI_Win win, const void *base) MPICH_API_PUBLIC;
int PMPI_Win_fence(int assert, ABI_Win win) MPICH_API_PUBLIC;
int PMPI_Win_flush(int rank, ABI_Win win) MPICH_API_PUBLIC;
int PMPI_Win_flush_all(ABI_Win win) MPICH_API_PUBLIC;
int PMPI_Win_flush_local(int rank, ABI_Win win) MPICH_API_PUBLIC;
int PMPI_Win_flush_local_all(ABI_Win win) MPICH_API_PUBLIC;
int PMPI_Win_free(ABI_Win *win) MPICH_API_PUBLIC;
int PMPI_Win_free_keyval(int *win_keyval) MPICH_API_PUBLIC;
int PMPI_Win_get_attr(ABI_Win win, int win_keyval, void *attribute_val, int *flag) MPICH_API_PUBLIC;
int PMPI_Win_get_errhandler(ABI_Win win, ABI_Errhandler *errhandler) MPICH_API_PUBLIC;
int PMPI_Win_get_group(ABI_Win win, ABI_Group *group) MPICH_API_PUBLIC;
int PMPI_Win_get_info(ABI_Win win, ABI_Info *info_used) MPICH_API_PUBLIC;
int PMPI_Win_get_name(ABI_Win win, char *win_name, int *resultlen) MPICH_API_PUBLIC;
int PMPI_Win_lock(int lock_type, int rank, int assert, ABI_Win win) MPICH_API_PUBLIC;
int PMPI_Win_lock_all(int assert, ABI_Win win) MPICH_API_PUBLIC;
int PMPI_Win_post(ABI_Group group, int assert, ABI_Win win) MPICH_API_PUBLIC;
int PMPI_Win_set_attr(ABI_Win win, int win_keyval, void *attribute_val) MPICH_API_PUBLIC;
int PMPI_Win_set_errhandler(ABI_Win win, ABI_Errhandler errhandler) MPICH_API_PUBLIC;
int PMPI_Win_set_info(ABI_Win win, ABI_Info info) MPICH_API_PUBLIC;
int PMPI_Win_set_name(ABI_Win win, const char *win_name) MPICH_API_PUBLIC;
int PMPI_Win_shared_query(ABI_Win win, int rank, MPI_Aint *size, int *disp_unit, void *baseptr) MPICH_API_PUBLIC;
int PMPI_Win_shared_query_c(ABI_Win win, int rank, MPI_Aint *size, MPI_Aint *disp_unit, void *baseptr) MPICH_API_PUBLIC;
int PMPI_Win_start(ABI_Group group, int assert, ABI_Win win) MPICH_API_PUBLIC;
int PMPI_Win_sync(ABI_Win win) MPICH_API_PUBLIC;
int PMPI_Win_test(ABI_Win win, int *flag) MPICH_API_PUBLIC;
int PMPI_Win_unlock(int rank, ABI_Win win) MPICH_API_PUBLIC;
int PMPI_Win_unlock_all(ABI_Win win) MPICH_API_PUBLIC;
int PMPI_Win_wait(ABI_Win win) MPICH_API_PUBLIC;

MPI_Aint PMPI_Aint_add(MPI_Aint base, MPI_Aint disp) MPICH_API_PUBLIC;
MPI_Aint PMPI_Aint_diff(MPI_Aint addr1, MPI_Aint addr2) MPICH_API_PUBLIC;
double PMPI_Wtick(void) MPICH_API_PUBLIC;
double PMPI_Wtime(void) MPICH_API_PUBLIC;

ABI_Comm PMPI_Comm_fromint(int comm) MPICH_API_PUBLIC;
int PMPI_Comm_toint(ABI_Comm comm) MPICH_API_PUBLIC;
ABI_Errhandler PMPI_Errhandler_fromint(int errhandler) MPICH_API_PUBLIC;
int PMPI_Errhandler_toint(ABI_Errhandler errhandler) MPICH_API_PUBLIC;
ABI_File PMPI_File_fromint(int file) MPICH_API_PUBLIC;
int PMPI_File_toint(ABI_File file) MPICH_API_PUBLIC;
ABI_Group PMPI_Group_fromint(int group) MPICH_API_PUBLIC;
int PMPI_Group_toint(ABI_Group group) MPICH_API_PUBLIC;
ABI_Info PMPI_Info_fromint(int info) MPICH_API_PUBLIC;
int PMPI_Info_toint(ABI_Info info) MPICH_API_PUBLIC;
ABI_Message PMPI_Message_fromint(int message) MPICH_API_PUBLIC;
int PMPI_Message_toint(ABI_Message message) MPICH_API_PUBLIC;
ABI_Op PMPI_Op_fromint(int op) MPICH_API_PUBLIC;
int PMPI_Op_toint(ABI_Op op) MPICH_API_PUBLIC;
ABI_Request PMPI_Request_fromint(int request) MPICH_API_PUBLIC;
int PMPI_Request_toint(ABI_Request request) MPICH_API_PUBLIC;
ABI_Session PMPI_Session_fromint(int session) MPICH_API_PUBLIC;
int PMPI_Session_toint(ABI_Session session) MPICH_API_PUBLIC;
ABI_Datatype PMPI_Type_fromint(int datatype) MPICH_API_PUBLIC;
int PMPI_Type_toint(ABI_Datatype datatype) MPICH_API_PUBLIC;
ABI_Win PMPI_Win_fromint(int win) MPICH_API_PUBLIC;
int PMPI_Win_toint(ABI_Win win) MPICH_API_PUBLIC;

/* PMPI_T functions */
int PMPI_T_category_changed(int *update_number) MPICH_API_PUBLIC;
int PMPI_T_category_get_categories(int cat_index, int len, int indices[]) MPICH_API_PUBLIC;
int PMPI_T_category_get_cvars(int cat_index, int len, int indices[]) MPICH_API_PUBLIC;
int PMPI_T_category_get_events(int cat_index, int len, int indices[]) MPICH_API_PUBLIC;
int PMPI_T_category_get_index(const char *name, int *cat_index) MPICH_API_PUBLIC;
int PMPI_T_category_get_info(int cat_index, char *name, int *name_len, char *desc, int *desc_len, int *num_cvars, int *num_pvars, int *num_categories) MPICH_API_PUBLIC;
int PMPI_T_category_get_num(int *num_cat) MPICH_API_PUBLIC;
int PMPI_T_category_get_num_events(int cat_index, int *num_events) MPICH_API_PUBLIC;
int PMPI_T_category_get_pvars(int cat_index, int len, int indices[]) MPICH_API_PUBLIC;
int PMPI_T_cvar_get_index(const char *name, int *cvar_index) MPICH_API_PUBLIC;
int PMPI_T_cvar_get_info(int cvar_index, char *name, int *name_len, int *verbosity, ABI_Datatype *datatype, MPI_T_enum *enumtype, char *desc, int *desc_len, int *bind, int *scope) MPICH_API_PUBLIC;
int PMPI_T_cvar_get_num(int *num_cvar) MPICH_API_PUBLIC;
int PMPI_T_cvar_handle_alloc(int cvar_index, void *obj_handle, MPI_T_cvar_handle *handle, int *count) MPICH_API_PUBLIC;
int PMPI_T_cvar_handle_free(MPI_T_cvar_handle *handle) MPICH_API_PUBLIC;
int PMPI_T_cvar_read(MPI_T_cvar_handle handle, void *buf) MPICH_API_PUBLIC;
int PMPI_T_cvar_write(MPI_T_cvar_handle handle, const void *buf) MPICH_API_PUBLIC;
int PMPI_T_enum_get_info(MPI_T_enum enumtype, int *num, char *name, int *name_len) MPICH_API_PUBLIC;
int PMPI_T_enum_get_item(MPI_T_enum enumtype, int indx, int *value, char *name, int *name_len) MPICH_API_PUBLIC;
int PMPI_T_event_callback_get_info(MPI_T_event_registration event_registration, MPI_T_cb_safety cb_safety, ABI_Info *info_used) MPICH_API_PUBLIC;
int PMPI_T_event_callback_set_info(MPI_T_event_registration event_registration, MPI_T_cb_safety cb_safety, ABI_Info info) MPICH_API_PUBLIC;
int PMPI_T_event_copy(MPI_T_event_instance event_instance, void *buffer) MPICH_API_PUBLIC;
int PMPI_T_event_get_index(const char *name, int *event_index) MPICH_API_PUBLIC;
int PMPI_T_event_get_info(int event_index, char *name, int *name_len, int *verbosity, ABI_Datatype array_of_datatypes[], MPI_Aint array_of_displacements[], int *num_elements, MPI_T_enum *enumtype, ABI_Info *info, char *desc, int *desc_len, int *bind) MPICH_API_PUBLIC;
int PMPI_T_event_get_num(int *num_events) MPICH_API_PUBLIC;
int PMPI_T_event_get_source(MPI_T_event_instance event_instance, int *source_index) MPICH_API_PUBLIC;
int PMPI_T_event_get_timestamp(MPI_T_event_instance event_instance, MPI_Count *event_timestamp) MPICH_API_PUBLIC;
int PMPI_T_event_handle_alloc(int event_index, void *obj_handle, ABI_Info info, MPI_T_event_registration *event_registration) MPICH_API_PUBLIC;
int PMPI_T_event_handle_free(MPI_T_event_registration event_registration, void *user_data, MPI_T_event_free_cb_function free_cb_function) MPICH_API_PUBLIC;
int PMPI_T_event_handle_get_info(MPI_T_event_registration event_registration, ABI_Info *info_used) MPICH_API_PUBLIC;
int PMPI_T_event_handle_set_info(MPI_T_event_registration event_registration, ABI_Info info) MPICH_API_PUBLIC;
int PMPI_T_event_read(MPI_T_event_instance event_instance, int element_index, void *buffer) MPICH_API_PUBLIC;
int PMPI_T_event_register_callback(MPI_T_event_registration event_registration, MPI_T_cb_safety cb_safety, ABI_Info info, void *user_data, MPI_T_event_cb_function event_cb_function) MPICH_API_PUBLIC;
int PMPI_T_event_set_dropped_handler(MPI_T_event_registration event_registration, MPI_T_event_dropped_cb_function dropped_cb_function) MPICH_API_PUBLIC;
int PMPI_T_finalize(void) MPICH_API_PUBLIC;
int PMPI_T_init_thread(int required, int *provided) MPICH_API_PUBLIC;
int PMPI_T_pvar_get_index(const char *name, int var_class, int *pvar_index) MPICH_API_PUBLIC;
int PMPI_T_pvar_get_info(int pvar_index, char *name, int *name_len, int *verbosity, int *var_class, ABI_Datatype *datatype, MPI_T_enum *enumtype, char *desc, int *desc_len, int *bind, int *readonly, int *continuous, int *atomic) MPICH_API_PUBLIC;
int PMPI_T_pvar_get_num(int *num_pvar) MPICH_API_PUBLIC;
int PMPI_T_pvar_handle_alloc(MPI_T_pvar_session session, int pvar_index, void *obj_handle, MPI_T_pvar_handle *handle, int *count) MPICH_API_PUBLIC;
int PMPI_T_pvar_handle_free(MPI_T_pvar_session session, MPI_T_pvar_handle *handle) MPICH_API_PUBLIC;
int PMPI_T_pvar_read(MPI_T_pvar_session session, MPI_T_pvar_handle handle, void *buf) MPICH_API_PUBLIC;
int PMPI_T_pvar_readreset(MPI_T_pvar_session session, MPI_T_pvar_handle handle, void *buf) MPICH_API_PUBLIC;
int PMPI_T_pvar_reset(MPI_T_pvar_session session, MPI_T_pvar_handle handle) MPICH_API_PUBLIC;
int PMPI_T_pvar_session_create(MPI_T_pvar_session *session) MPICH_API_PUBLIC;
int PMPI_T_pvar_session_free(MPI_T_pvar_session *session) MPICH_API_PUBLIC;
int PMPI_T_pvar_start(MPI_T_pvar_session session, MPI_T_pvar_handle handle) MPICH_API_PUBLIC;
int PMPI_T_pvar_stop(MPI_T_pvar_session session, MPI_T_pvar_handle handle) MPICH_API_PUBLIC;
int PMPI_T_pvar_write(MPI_T_pvar_session session, MPI_T_pvar_handle handle, const void *buf) MPICH_API_PUBLIC;
int PMPI_T_source_get_info(int source_index, char *name, int *name_len, char *desc, int *desc_len, MPI_T_source_order *ordering, MPI_Count *ticks_per_second, MPI_Count *max_ticks, ABI_Info *info) MPICH_API_PUBLIC;
int PMPI_T_source_get_num(int *num_sources) MPICH_API_PUBLIC;
int PMPI_T_source_get_timestamp(int source_index, MPI_Count *timestamp) MPICH_API_PUBLIC;

#if defined(__cplusplus)
}
#endif

#endif  /* MPI_H_ABI */
typedef int MPI_Fint;
typedef struct MPI_F08_status_dummy MPI_F08_status;
#undef HAVE_FORTRAN_BINDING

#endif /* MPI_ABI_INTERNAL_H_INCLUDED */
