"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const url = tslib_1.__importStar(require("url"));
const errors_1 = require("../errors");
const search_config_1 = require("./search-config");
const options_1 = require("./options");
main().catch((e) => {
    const ext = (0, errors_1.getExtErrorProps)(e);
    if (!ext) {
        console.error("");
        console.error(e);
    }
    process.exit(1);
});
async function main() {
    const { cwd, rulePath } = await (0, search_config_1.searchConfig)(options_1.args, [
        "verdafile.js",
        "verdafile.cjs",
        "verdafile.mjs",
    ]);
    process.chdir(cwd);
    const _sessionModule = await import(url.pathToFileURL(rulePath).toString());
    const _session = _sessionModule.build || _sessionModule.default || _sessionModule;
    if (!_session.loadJournal || !_session.start) {
        throw new Error(`Configuration ${rulePath} is not default-exporting a Verda configuration`);
    }
    const session = _session;
    session.bindConfig({ ...options_1.args, rulePath, cwd });
    await session.loadJournal();
    await session.createSelfTrackingRule(session.userSelfTrackingGoal);
    const userCancel = () => {
        session.userCancelSync();
        process.exit(1);
    };
    process.once("SIGINT", userCancel).once("SIGTERM", userCancel);
    try {
        await session.start(...options_1.args.targets);
    }
    finally {
        session.saveJournalSync();
    }
}
