import { Arc, Arcs } from "../../derivable";
import { RootSolver } from "../../fn";
import { IRootSink } from "../../fn/solver";
import { IVec2 } from "../../point/interface";
export declare enum CornerType {
    Smooth = 0,
    Corner = 1,
    Extrema = 2,
    Hetero = 3
}
export type CurveClass = "line" | "quadratic" | "serpentine" | "cusp" | "loop" | "arch";
export type CurveClassifyResult = {
    type: CurveClass;
    roots: null | number[];
};
export declare class Bez3Slice extends Arcs.Bez3 {
    constructor(a: IVec2, b: IVec2, c: IVec2, d: IVec2);
    cornerTypeBefore: CornerType;
    cornerTypeAfter: CornerType;
    private isStraightCache?;
    forceStraight(): Bez3Slice;
    isStraight(): boolean;
    toString(): string;
    splitRatio(t?: number): [Bez3Slice, Bez3Slice];
    sliceRatio(t1: number, t2: number): Bez3Slice;
    getTOf(point: IVec2): number | null;
    classify(sink?: IRootSink): void;
    private cleanupClassifyResults;
    getLength(a?: number, b?: number): number;
    private getLengthIntegrand;
    private getLengthSteps;
    getXExtrema(sink: RootSolver.IRootSink): void;
    getYExtrema(sink: RootSolver.IRootSink): void;
    private getExtremaImpl;
    static fromStraightSegment(ss: Arcs.StraightSegment): Bez3Slice;
    static fromArcSlice(arc: Arc, t0: number, t1: number): Bez3Slice;
}
